/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.option.CustomOption;
import genj.option.Option;
import genj.option.OptionProvider;
import genj.option.PropertyOption;
import genj.renderer.DPI;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ScreenResolutionScale;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class RenderOptions
extends OptionProvider {
    private static final Resources RESOURCES = Resources.get(RenderOptions.class);
    private static final RenderOptions instance = new RenderOptions();
    private Font defaultFont = new Font("SansSerif", 0, 11);
    private DPI dpi = new DPI(Toolkit.getDefaultToolkit().getScreenResolution(), Toolkit.getDefaultToolkit().getScreenResolution());

    public static RenderOptions getInstance() {
        return instance;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font set) {
        this.defaultFont = set;
    }

    @Override
    public List<? extends Option> getOptions() {
        ArrayList<PropertyOption> result = new ArrayList<PropertyOption>(PropertyOption.introspect(RenderOptions.getInstance()));
        result.add((PropertyOption)((Object)new ScreenResolutionOption()));
        return result;
    }

    public DPI getDPI() {
        return this.dpi;
    }

    private class ScreenResolutionOption
    extends CustomOption {
        private ScreenResolutionOption() {
        }

        @Override
        public String getName() {
            return RESOURCES.getString("option.screenresolution");
        }

        @Override
        public String getToolTip() {
            return RESOURCES.getString("option.screenresolution.tip", false);
        }

        @Override
        public void persist() {
            Registry.get(this).put("dpi.h", RenderOptions.this.dpi.horizontal());
            Registry.get(this).put("dpi.v", RenderOptions.this.dpi.vertical());
        }

        @Override
        public void restore() {
            int h = Registry.get(this).get("dpi.h", 0);
            int v = Registry.get(this).get("dpi.v", 0);
            if (h > 0 && v > 0) {
                RenderOptions.this.dpi = new DPI(h, v);
            }
        }

        @Override
        protected JComponent getEditor() {
            return new ScreenResolutionScale(RenderOptions.this.dpi);
        }

        @Override
        protected void commit(JComponent editor) {
            RenderOptions.this.dpi = ((ScreenResolutionScale)editor).getDPI();
        }
    }
}

