/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.util.Trackable;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class ProgressWidget
extends JPanel {
    private static final ImageIcon IMG_CANCEL = new ImageIcon(ProgressWidget.class, "Cancel.png");
    private JProgressBar progress = new JProgressBar(0, 100);
    private Trackable track;
    private Timer timer;
    private Dimension minPreferredSize;

    public ProgressWidget(Trackable trackable) {
        super(new BorderLayout());
        JButton cancel = new JButton(new Cancel());
        cancel.setRequestFocusEnabled(false);
        cancel.setFocusable(false);
        cancel.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.progress, "Center");
        this.add((Component)cancel, "East");
        this.progress.setStringPainted(true);
        this.track = trackable;
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressWidget.this.progress.setValue(ProgressWidget.this.track.getProgress());
                ProgressWidget.this.progress.setString(ProgressWidget.this.track.getState());
                ProgressWidget.this.revalidate();
                ProgressWidget.this.repaint();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension oldMin = this.minPreferredSize;
        this.minPreferredSize = super.getPreferredSize();
        if (oldMin != null) {
            this.minPreferredSize.width = Math.max(this.minPreferredSize.width + 16, oldMin.width);
            this.minPreferredSize.height = Math.max(this.minPreferredSize.height, oldMin.height);
        }
        return this.minPreferredSize;
    }

    @Override
    public void addNotify() {
        this.timer.start();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    private class Cancel
    extends AbstractAncestrisAction {
        private Cancel() {
            this.setImage(IMG_CANCEL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProgressWidget.this.track.cancelTrackable();
        }
    }
}

