/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomproperties;

import ancestris.modules.editors.LanguagesConstants;
import ancestris.swing.UndoTextArea;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PropertiesPanel
extends JPanel
implements DocumentListener {
    static final String SUBM_NAME = "submName";
    static final String SUBM_ADDR = "submAddress";
    static final String SUBM_POST = "submPostcode";
    static final String SUBM_CITY = "submCity";
    static final String SUBM_STAE = "submState";
    static final String SUBM_CTRY = "submCountry";
    static final String SUBM_PHON = "submPhone";
    static final String SUBM_EMAI = "submEmail";
    static final String SUBM_WWW = "submWeb";
    private final Gedcom gedcom;
    private final Entity header;
    private Submitter submitter;
    private final JButton confirmButton;
    private final Boolean grammar7;
    private final SortedMap<String, String> translatedLanguages = new TreeMap<String, String>();
    private JLabel addressLabel;
    private JScrollPane addressScrollPane;
    private JTextArea addressTextArea;
    private JTextField cityTextField;
    private JLabel copyrightLabel;
    private JTextField copyrightTextField;
    private JLabel countryLabel;
    private JTextField countryTextField;
    private JLabel descLabel;
    private JPanel descPanel;
    private JScrollPane descScrollPane;
    private JTextArea descTextArea;
    private JTextField emailTextField;
    private JLabel filenameLabel;
    private JLabel filenameTextLabel;
    private JSeparator jSeparator;
    private JTabbedPane jTabbedPane;
    private JComboBox<String> languageComboBox;
    private JLabel languageLabel;
    private JLabel lastModificationLabel;
    private JLabel lastModificationTextLabel;
    private JButton loadSubmitterButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JTextField phoneTextField;
    private JLabel phoneemailLabel;
    private JTextField postcodeTextField;
    private JLabel regionLabel;
    private JButton saveSubmitterButton;
    private JLabel softwareLabel;
    private JLabel softwareTextLabel;
    private JTextField stateTextField;
    private JPanel submitterPanel;
    private JTextField webTextField;
    private JLabel websiteLabel;
    private JLabel zipcityLabel;

    public PropertiesPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.header = gedcom.getFirstEntity("HEAD");
        this.submitter = gedcom.getSubmitter();
        this.confirmButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"OK_button"));
        this.grammar7 = Grammar.V70 == gedcom.getGrammar();
        this.initLanguages();
        this.initComponents();
        this.load();
        this.updateButtons();
        this.descTextArea.getDocument().addDocumentListener(this);
        ((JTextComponent)this.languageComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.nameTextField.getDocument().addDocumentListener(this);
        this.addressTextArea.getDocument().addDocumentListener(this);
        this.postcodeTextField.getDocument().addDocumentListener(this);
        this.cityTextField.getDocument().addDocumentListener(this);
        this.stateTextField.getDocument().addDocumentListener(this);
        this.countryTextField.getDocument().addDocumentListener(this);
        this.phoneTextField.getDocument().addDocumentListener(this);
        this.emailTextField.getDocument().addDocumentListener(this);
        this.webTextField.getDocument().addDocumentListener(this);
        this.confirmButton.setEnabled(false);
    }

    private void initLanguages() {
        if (Grammar.V70.equals(this.gedcom.getGrammar())) {
            this.translateLanguages(LanguagesConstants.LANGUAGES_V7, true);
        } else {
            this.translateLanguages(LanguagesConstants.LANGUAGES_V55, false);
        }
    }

    private void translateLanguages(String[][] langues, boolean localeFirst) {
        for (String[] langue : langues) {
            Locale loc = new Locale(langue[localeFirst ? 0 : 1]);
            Object language = loc.getDisplayLanguage(loc);
            if (!((String)language).equals(loc.getDisplayLanguage(Locale.getDefault()))) {
                language = (String)language + " (" + loc.getDisplayLanguage(Locale.getDefault()) + ")";
            }
            this.translatedLanguages.put(langue[0], (String)language);
        }
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.descPanel = new JPanel();
        this.descLabel = new JLabel();
        this.descScrollPane = new JScrollPane();
        this.descTextArea = new JTextArea();
        this.languageLabel = new JLabel();
        this.languageComboBox = new JComboBox<String>(this.translatedLanguages.values().toArray(new String[this.translatedLanguages.values().size()]));
        this.filenameLabel = new JLabel();
        this.filenameTextLabel = new JLabel();
        this.lastModificationLabel = new JLabel();
        this.lastModificationTextLabel = new JLabel();
        this.softwareLabel = new JLabel();
        this.softwareTextLabel = new JLabel();
        this.submitterPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.addressLabel = new JLabel();
        this.addressScrollPane = new JScrollPane();
        this.addressTextArea = new UndoTextArea();
        this.zipcityLabel = new JLabel();
        this.postcodeTextField = new JTextField();
        this.cityTextField = new JTextField();
        this.loadSubmitterButton = new JButton();
        this.saveSubmitterButton = new JButton();
        this.regionLabel = new JLabel();
        this.stateTextField = new JTextField();
        this.countryLabel = new JLabel();
        this.countryTextField = new JTextField();
        this.phoneemailLabel = new JLabel();
        this.phoneTextField = new JTextField();
        this.emailTextField = new JTextField();
        this.websiteLabel = new JLabel();
        this.webTextField = new JTextField();
        this.jSeparator = new JSeparator();
        this.copyrightLabel = new JLabel();
        this.copyrightTextField = new JTextField();
        this.descLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.descLabel.text"));
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setRows(5);
        this.descScrollPane.setViewportView(this.descTextArea);
        this.languageLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.languageLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.languageLabel.text"));
        this.filenameLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.filenameLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.filenameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.filenameTextLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.filenameTextLabel.text"));
        this.lastModificationLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lastModificationLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.lastModificationLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.lastModificationTextLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.lastModificationTextLabel.text"));
        this.softwareLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.softwareLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.softwareLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.softwareTextLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.softwareTextLabel.text"));
        GroupLayout descPanelLayout = new GroupLayout(this.descPanel);
        this.descPanel.setLayout(descPanelLayout);
        descPanelLayout.setHorizontalGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descPanelLayout.createSequentialGroup().addContainerGap().addGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descScrollPane).addGroup(descPanelLayout.createSequentialGroup().addComponent(this.languageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageComboBox, 0, -1, Short.MAX_VALUE)).addGroup(descPanelLayout.createSequentialGroup().addGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descLabel).addGroup(descPanelLayout.createSequentialGroup().addComponent(this.filenameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filenameTextLabel)).addGroup(descPanelLayout.createSequentialGroup().addComponent(this.lastModificationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lastModificationTextLabel))).addGap(0, 0, Short.MAX_VALUE)).addGroup(descPanelLayout.createSequentialGroup().addComponent(this.softwareLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.softwareTextLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        descPanelLayout.setVerticalGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descScrollPane, -1, 114, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.languageLabel).addComponent(this.languageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filenameLabel).addComponent(this.filenameTextLabel)).addGap(18, 18, 18).addGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastModificationLabel).addComponent(this.lastModificationTextLabel)).addGap(18, 18, 18).addGroup(descPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.softwareTextLabel, -2, 63, -2).addComponent(this.softwareLabel)).addContainerGap()));
        this.jTabbedPane.addTab(NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.descPanel.TabConstraints.tabTitle"), this.descPanel);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.nameLabel.text"));
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PropertiesPanel.this.nameTextFieldKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.addressLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.addressLabel.text"));
        this.addressTextArea.setColumns(20);
        this.addressTextArea.setLineWrap(true);
        this.addressTextArea.setRows(3);
        this.addressScrollPane.setViewportView(this.addressTextArea);
        Mnemonics.setLocalizedText((JLabel)this.zipcityLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.zipcityLabel.text"));
        this.loadSubmitterButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/gedcomproperties/GetDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.loadSubmitterButton, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.loadSubmitterButton.text"));
        this.loadSubmitterButton.setToolTipText(NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.loadSubmitterButton.toolTipText"));
        this.loadSubmitterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesPanel.this.loadSubmitterButtonActionPerformed(evt);
            }
        });
        this.saveSubmitterButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/gedcomproperties/SaveAsDefault.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.saveSubmitterButton, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.saveSubmitterButton.text"));
        this.saveSubmitterButton.setToolTipText(NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.saveSubmitterButton.toolTipText"));
        this.saveSubmitterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesPanel.this.saveSubmitterButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.regionLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.regionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.countryLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.countryLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phoneemailLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.phoneemailLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.websiteLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.websiteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.copyrightLabel, (String)NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.copyrightLabel.text"));
        GroupLayout submitterPanelLayout = new GroupLayout(this.submitterPanel);
        this.submitterPanel.setLayout(submitterPanelLayout);
        submitterPanelLayout.setHorizontalGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitterPanelLayout.createSequentialGroup().addContainerGap().addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitterPanelLayout.createSequentialGroup().addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.addressLabel).addComponent(this.zipcityLabel).addComponent(this.regionLabel).addComponent(this.countryLabel).addComponent(this.phoneemailLabel).addComponent(this.websiteLabel).addComponent(this.copyrightLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webTextField, GroupLayout.Alignment.TRAILING).addComponent(this.countryTextField).addComponent(this.stateTextField).addGroup(GroupLayout.Alignment.TRAILING, submitterPanelLayout.createSequentialGroup().addComponent(this.postcodeTextField, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cityTextField)).addComponent(this.addressScrollPane, -1, 356, Short.MAX_VALUE).addComponent(this.nameTextField, GroupLayout.Alignment.TRAILING).addGroup(submitterPanelLayout.createSequentialGroup().addComponent(this.phoneTextField, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.emailTextField)).addComponent(this.copyrightTextField)).addGap(18, 18, 18).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveSubmitterButton).addComponent(this.loadSubmitterButton))).addComponent(this.jSeparator))));
        submitterPanelLayout.setVerticalGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitterPanelLayout.createSequentialGroup().addContainerGap().addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(submitterPanelLayout.createSequentialGroup().addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressScrollPane, -2, 54, -2).addComponent(this.saveSubmitterButton).addComponent(this.addressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cityTextField, -2, -1, -2).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.postcodeTextField, -2, -1, -2).addComponent(this.zipcityLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stateTextField, -2, -1, -2).addComponent(this.regionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.countryTextField, -2, -1, -2).addComponent(this.countryLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phoneTextField, -2, -1, -2).addComponent(this.emailTextField, -2, -1, -2).addComponent(this.phoneemailLabel))).addComponent(this.loadSubmitterButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.webTextField, -2, -1, -2).addComponent(this.websiteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(submitterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.copyrightTextField, -2, -1, -2).addComponent(this.copyrightLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane.addTab(NbBundle.getMessage(PropertiesPanel.class, (String)"PropertiesPanel.submitterPanel.TabConstraints.tabTitle"), this.submitterPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane).addContainerGap()));
    }

    private void saveSubmitterButtonActionPerformed(ActionEvent evt) {
        this.saveSubmitterAsDefault();
        this.updateButtons();
    }

    private void loadSubmitterButtonActionPerformed(ActionEvent evt) {
        this.reloadSubmitter();
        this.updateButtons();
    }

    private void nameTextFieldKeyReleased(KeyEvent evt) {
        String name = this.nameTextField.getText().trim();
        String defaultCopr = NbBundle.getMessage(PropertiesPanel.class, (String)"DFT_Copyright") + " " + Calendar.getInstance().get(1);
        String copr = this.copyrightTextField.getText().trim();
        int i = copr.lastIndexOf(defaultCopr);
        if (i != -1 || copr.isEmpty()) {
            this.copyrightTextField.setText(name + " " + defaultCopr);
        }
    }

    private boolean isSubmitterDifferent() {
        Registry submPref = Registry.get(PropertiesPanel.class);
        return !this.nameTextField.getText().trim().equals(submPref.get(SUBM_NAME, "")) || !this.addressTextArea.getText().trim().equals(submPref.get(SUBM_ADDR, "")) || !this.postcodeTextField.getText().trim().equals(submPref.get(SUBM_POST, "")) || !this.cityTextField.getText().trim().equals(submPref.get(SUBM_CITY, "")) || !this.stateTextField.getText().trim().equals(submPref.get(SUBM_STAE, "")) || !this.countryTextField.getText().trim().equals(submPref.get(SUBM_CTRY, "")) || !this.phoneTextField.getText().trim().equals(submPref.get(SUBM_PHON, "")) || !this.emailTextField.getText().trim().equals(submPref.get(SUBM_EMAI, "")) || !this.webTextField.getText().trim().equals(submPref.get(SUBM_WWW, ""));
    }

    private void reloadSubmitter() {
        Registry submPref = Registry.get(PropertiesPanel.class);
        this.nameTextField.setText(submPref.get(SUBM_NAME, ""));
        this.addressTextArea.setText(submPref.get(SUBM_ADDR, ""));
        this.postcodeTextField.setText(submPref.get(SUBM_POST, ""));
        this.cityTextField.setText(submPref.get(SUBM_CITY, ""));
        this.stateTextField.setText(submPref.get(SUBM_STAE, ""));
        this.countryTextField.setText(submPref.get(SUBM_CTRY, ""));
        this.phoneTextField.setText(submPref.get(SUBM_PHON, ""));
        this.emailTextField.setText(submPref.get(SUBM_EMAI, ""));
        this.webTextField.setText(submPref.get(SUBM_WWW, ""));
        this.copyrightTextField.setText(submPref.get(SUBM_NAME, "") + " " + NbBundle.getMessage(PropertiesPanel.class, (String)"DFT_Copyright") + " " + Calendar.getInstance().get(1));
    }

    private void saveSubmitterAsDefault() {
        Registry submPref = Registry.get(PropertiesPanel.class);
        submPref.put(SUBM_NAME, this.nameTextField.getText().trim());
        submPref.put(SUBM_ADDR, this.addressTextArea.getText().trim());
        submPref.put(SUBM_POST, this.postcodeTextField.getText().trim());
        submPref.put(SUBM_CITY, this.cityTextField.getText().trim());
        submPref.put(SUBM_STAE, this.stateTextField.getText().trim());
        submPref.put(SUBM_CTRY, this.countryTextField.getText().trim());
        submPref.put(SUBM_PHON, this.phoneTextField.getText().trim());
        submPref.put(SUBM_EMAI, this.emailTextField.getText().trim());
        submPref.put(SUBM_WWW, this.webTextField.getText().trim());
    }

    private void updateButtons() {
        this.loadSubmitterButton.setEnabled(this.isSubmitterDifferent());
        this.saveSubmitterButton.setEnabled(this.isSubmitterDifferent());
        this.confirmButton.setEnabled(true);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtons();
    }

    private void load() {
        this.lastModificationTextLabel.setText(this.getProperty(".:DATE") + " - " + this.getProperty(".:DATE:TIME"));
        this.softwareTextLabel.setText(NbBundle.getMessage(this.getClass(), (String)"PropertiesPanel.softwareTextLabel.text", (Object)this.getProperty(".:SOUR"), (Object)this.getProperty(".:SOUR:NAME"), (Object)this.getProperty(".:SOUR:VERS"), (Object)this.getProperty(".:SOUR:CORP"), (Object[])new Object[]{this.getProperty(".:SOUR:CORP:ADDR")}));
        try {
            this.filenameTextLabel.setText(this.gedcom.getOrigin().getFile().getCanonicalPath());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.descTextArea.setText(this.getProperty(".:NOTE"));
        String propertyLang = this.getProperty(".:LANG");
        if (this.grammar7.booleanValue() && !StringUtils.isEmpty((String)propertyLang)) {
            String[] loc = propertyLang.split("\\_");
            propertyLang = loc[0];
        }
        this.languageComboBox.setSelectedItem(this.translatedLanguages.get(propertyLang));
        if (this.languageComboBox.getSelectedIndex() == -1) {
            this.languageComboBox.setSelectedItem(this.translatedLanguages.get(Locale.getDefault().getDisplayLanguage(new Locale("en", "EN"))));
        }
        this.copyrightTextField.setText(this.getProperty(".:COPR"));
        if (this.submitter == null) {
            try {
                this.submitter = (Submitter)this.gedcom.createEntity("SUBM");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        this.nameTextField.setText(this.submitter.getName());
        this.addressTextArea.setText(this.submitter.getAddress());
        this.postcodeTextField.setText(this.submitter.getPostcode());
        this.cityTextField.setText(this.submitter.getCity());
        this.stateTextField.setText(this.submitter.getState());
        this.countryTextField.setText(this.submitter.getCountry());
        this.phoneTextField.setText(this.submitter.getPhone());
        this.emailTextField.setText(this.submitter.getEmail());
        this.webTextField.setText(this.submitter.getWeb());
    }

    public void execute() {
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITLE_update", (Object)this.gedcom.getDisplayName()), (JComponent)this).setMessageType(-1).setOptions(new Object[]{this.confirmButton, DialogManager.CANCEL_OPTION}).setDialogId("fileProperties").show();
        if (o == this.confirmButton) {
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PropertiesPanel.this.commit();
                    }
                });
            }
            catch (Throwable ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void commit() {
        if (!StringUtils.isEmpty((String)this.descTextArea.getText().trim())) {
            this.setProperty(".:NOTE", this.descTextArea.getText());
        }
        if (this.grammar7.booleanValue()) {
            this.setProperty(".:LANG", LanguagesConstants.LANGUAGES_V7[this.languageComboBox.getSelectedIndex()][0]);
        } else {
            this.setProperty(".:LANG", LanguagesConstants.LANGUAGES_V55[this.languageComboBox.getSelectedIndex()][0]);
        }
        if (!StringUtils.isEmpty((String)this.copyrightTextField.getText().trim())) {
            this.setProperty(".:COPR", this.copyrightTextField.getText());
        }
        if (!StringUtils.isEmpty((String)this.nameTextField.getText().trim())) {
            this.submitter.setName(this.nameTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.addressTextArea.getText().trim())) {
            this.submitter.setAddress(this.addressTextArea.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.postcodeTextField.getText().trim())) {
            this.submitter.setPostcode(this.postcodeTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.cityTextField.getText().trim())) {
            this.submitter.setCity(this.cityTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.stateTextField.getText().trim())) {
            this.submitter.setState(this.stateTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.countryTextField.getText().trim())) {
            this.submitter.setCountry(this.countryTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.phoneTextField.getText().trim())) {
            this.submitter.setPhone(this.phoneTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.emailTextField.getText().trim())) {
            this.submitter.setEmail(this.emailTextField.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.webTextField.getText().trim())) {
            this.submitter.setWeb(this.webTextField.getText().trim());
        }
    }

    private String getProperty(String tag) {
        Property prop = this.header.getPropertyByPath(tag);
        return prop != null ? prop.getValue() : "";
    }

    private void setProperty(String tag, String text) {
        text = text.trim();
        Property prop = this.header.getPropertyByPath(tag);
        if (prop == null) {
            prop = this.header.setValue(new TagPath(tag), text);
        } else {
            prop.setValue(text);
        }
    }
}

