/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import ancestris.core.actions.AbstractAncestrisContextAction;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.report.Report;
import genj.report.ReportLoader;
import genj.report.ReportPlugin;
import java.awt.event.ActionEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MyReportAction
extends AbstractAncestrisContextAction {
    public final FileObject fo;
    public final Report myReport;

    public static MyReportAction factory(FileObject reportProvider) {
        return new MyReportAction(reportProvider);
    }

    public MyReportAction() {
        this(null);
    }

    public MyReportAction(FileObject fo) {
        String displayTip;
        this.fo = fo;
        String reportName = (String)fo.getAttribute("reportName");
        this.myReport = this.getReport(reportName);
        if (this.myReport == null) {
            return;
        }
        String displayName = (String)fo.getAttribute("actionName");
        if (displayName == null) {
            displayName = this.myReport.getName();
        }
        if ((displayTip = (String)fo.getAttribute("actionTip")) == null) {
            String categoryName = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)("category." + this.myReport.getCategory().getName()));
            displayTip = NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MyReportAction_tip", (Object)("<b>" + this.myReport.getName() + "</b>"), (Object)categoryName);
        }
        if (reportName != null && !reportName.isBlank()) {
            this.setText(displayName);
            this.setTip("<html>" + displayTip + "</html>");
            this.setIconBase("genj/report/" + this.myReport.getCategory().getImageResourceName(this.myReport.getCategory().getName()));
        } else {
            this.setText("Null report");
            this.setIconBase("genj/report/View.png");
        }
    }

    protected void contextChanged() {
        Property property = !this.contextProperties.isEmpty() && this.myReport != null ? (Property)this.contextProperties.get(0) : null;
        this.setEnabled(property != null && (this.myReport.accepts(property) != null || this.myReport.accepts(property.getEntity()) != null || this.myReport.accepts(property.getGedcom()) != null));
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        String accept;
        if (this.myReport == null) {
            return;
        }
        ReportPlugin.ActionRun run = null;
        Object contextOK = null;
        Object contextProperty = !(this.contextProperties.get(0) instanceof Entity) ? this.contextProperties.get(0) : null;
        Entity contextEntity = ((Property)this.contextProperties.get(0)).getEntity();
        Gedcom gedcom = ((Property)this.contextProperties.get(0)).getGedcom();
        int scope = (Integer)this.fo.getAttribute("reportScope");
        contextOK = scope == 1 ? gedcom : contextEntity;
        String string = accept = contextOK != null ? this.myReport.accepts(contextOK) : null;
        if (accept == null) {
            contextOK = contextProperty;
            String string2 = accept = contextOK != null ? this.myReport.accepts(contextOK) : null;
            if (accept == null) {
                contextOK = contextEntity;
                String string3 = accept = contextOK != null ? this.myReport.accepts(contextOK) : null;
            }
            if (accept == null) {
                contextOK = gedcom;
                String string4 = accept = contextOK != null ? this.myReport.accepts(contextOK) : null;
            }
        }
        if (accept != null) {
            run = new ReportPlugin.ActionRun(accept, contextOK, this.myReport, gedcom);
            run.setFixedOptions(this.fo);
        }
        if (run != null) {
            run.actionPerformed(null);
        }
    }

    private Report getReport(String reportName) {
        for (Report report : ReportLoader.getInstance().getReports()) {
            if (!report.getClass().getSimpleName().equals(reportName)) continue;
            return report;
        }
        return null;
    }
}

