/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.IndiMatcherOptions;
import ancestris.util.GedcomUtilities;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class IndiMatcher
extends EntityMatcher<Indi, IndiMatcherOptions> {
    private static final int NB_VALUES = 9;
    private final Map<Indi, Values> indiValuesMap;
    protected static final int[] points = new int[]{-50, -30, 3, 20, 30};

    public IndiMatcher() {
        this.options = new IndiMatcherOptions();
        this.indiValuesMap = new HashMap<Indi, Values>();
    }

    private Values getValues(Indi indi) {
        Values values = this.indiValuesMap.get(indi);
        if (values == null) {
            values = new Values(indi);
            this.indiValuesMap.put(indi, values);
        }
        return values;
    }

    @Override
    public int compare(Indi leftIndi, Indi rightIndi) {
        boolean siblings;
        Values leftValues = this.getValues(leftIndi);
        Values rightValues = this.getValues(rightIndi);
        int itemScore = 0;
        int score = 0;
        int nbSure_Different = 0;
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[0] * rightValues.coef[0] == 1 && (itemScore = IndiMatcher.compareNames(leftValues.name, rightValues.name)) == COMPARE_SURE_DIFFERENT) {
            ++nbSure_Different;
        }
        score += points[itemScore];
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[1] * rightValues.coef[1] == 1 && (itemScore = IndiMatcher.compareDates(leftValues.birthDate, rightValues.birthDate)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[2] * rightValues.coef[2] == 1 && (itemScore = IndiMatcher.comparePlaces(leftValues.birthPlace, rightValues.birthPlace)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[3] * rightValues.coef[3] == 1 && (itemScore = IndiMatcher.compareDates(leftValues.deathDate, rightValues.deathDate)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        itemScore = COMPARE_UNKNOWN;
        if (leftValues.coef[4] * rightValues.coef[4] == 1 && (itemScore = IndiMatcher.comparePlaces(leftValues.deathPlace, rightValues.deathPlace)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
            return 0;
        }
        score += points[itemScore];
        Fam leftFam = leftIndi.getFamilyWhereBiologicalChild();
        boolean bl = siblings = leftFam != null && leftFam.equals(rightIndi.getFamilyWhereBiologicalChild());
        if (!siblings) {
            itemScore = COMPARE_UNKNOWN;
            if (leftValues.coef[5] * rightValues.coef[5] == 1 && (itemScore = IndiMatcher.compareNames(leftValues.father, rightValues.father)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
                return 0;
            }
            score += points[itemScore];
            itemScore = COMPARE_UNKNOWN;
            if (leftValues.coef[6] * rightValues.coef[6] == 1 && (itemScore = IndiMatcher.compareNames(leftValues.mother, rightValues.mother)) == COMPARE_SURE_DIFFERENT && ++nbSure_Different > 1) {
                return 0;
            }
            score += points[itemScore];
        }
        if (leftValues.coef[7] * rightValues.coef[7] == 1 && leftValues.sex != rightValues.sex) {
            score -= 10;
        }
        if (leftValues.coef[8] * rightValues.coef[8] == 1) {
            itemScore = this.getLevel(GedcomUtilities.calcCosine(leftValues.spousesElements, rightValues.spousesElements));
            score += points[itemScore];
        }
        if (score >= 40 && (leftIndi.isAncestorOf(rightIndi) || rightIndi.isAncestorOf(leftIndi) || leftIndi.isDescendantOf(rightIndi) || rightIndi.isDescendantOf(leftIndi))) {
            return 0;
        }
        return score;
    }

    @Override
    public String[] getKeys(Indi indi) {
        HashSet<CallSite> keys = new HashSet<CallSite>();
        Values values = new Values(indi);
        this.indiValuesMap.put(indi, values);
        if (values.coef[0] == 1) {
            for (String lastname : values.name.lastNames) {
                for (String firstName : values.name.firstNames) {
                    keys.add((CallSite)((Object)(lastname + "-" + firstName)));
                }
                if (values.coef[1] != 1) continue;
                keys.add((CallSite)((Object)(lastname + "-" + values.birthDate.dateYear)));
            }
        }
        return (String[])keys.toArray(String[]::new);
    }

    @Override
    public String getHexaKey(Indi indi) {
        int num = 0;
        Values values = this.indiValuesMap.get(indi);
        if (values.coef[0] == 1) {
            num = (byte)(num + 64);
        }
        if (values.coef[1] == 1) {
            num = (byte)(num + 32);
        }
        if (values.coef[2] == 1) {
            num = (byte)(num + 16);
        }
        if (values.coef[3] == 1) {
            num = (byte)(num + 8);
        }
        if (values.coef[4] == 1) {
            num = (byte)(num + 4);
        }
        if (values.coef[5] == 1 || values.coef[6] == 1) {
            num = (byte)(num + 2);
        }
        if (values.coef[8] == 1) {
            num = (byte)(num + 1);
        }
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    @Override
    public void reset() {
    }

    protected boolean putIndi(Indi indi) {
        Values values = this.indiValuesMap.get(indi);
        if (values != null) {
            return values.coef[0] == 1;
        }
        values = new Values(indi);
        this.indiValuesMap.put(indi, values);
        return values.coef[0] == 1;
    }

    private class Values {
        private EntityMatcher.NameData name;
        private EntityMatcher.DateData birthDate;
        private EntityMatcher.PlaceData birthPlace;
        private EntityMatcher.DateData deathDate;
        private EntityMatcher.PlaceData deathPlace;
        private EntityMatcher.NameData father;
        private EntityMatcher.NameData mother;
        private int sex;
        private Map<String, Integer> spousesElements;
        private final int[] coef = new int[9];

        public Values(Indi indi) {
            PropertyDate dateTo;
            PropertyDate dateFrom;
            PropertyDate.Format format;
            this.name = new EntityMatcher.NameData(indi);
            this.coef[0] = this.name.isValid();
            if (this.coef[0] == 0) {
                return;
            }
            PropertyDate date = indi.getBirthDate();
            if (date == null) {
                date = (PropertyDate)indi.getProperty(new TagPath("INDI:CHR:DATE"));
            }
            if (date == null && (date = (PropertyDate)indi.getProperty(new TagPath("INDI:FAMC:*:..:MARR:DATE"))) != null) {
                format = PropertyDate.BETWEEN_AND;
                dateFrom = new PropertyDate(date.getStart().getYear() + 15);
                dateTo = new PropertyDate(date.getStart().getYear() + 50);
                date = new PropertyDate();
                date.setValue(format, dateFrom.getStart(), dateTo.getStart(), "");
            }
            if (date == null && (date = (PropertyDate)indi.getProperty(new TagPath("INDI:FAMS:*:..:MARR:DATE"))) != null) {
                format = PropertyDate.BETWEEN_AND;
                dateFrom = new PropertyDate(date.getStart().getYear() - 50);
                dateTo = new PropertyDate(date.getStart().getYear() - 15);
                date = new PropertyDate();
                date.setValue(format, dateFrom.getStart(), dateTo.getStart(), "");
            }
            if (date == null || !date.isValid() || !date.getStart().isValid() || date.isRange() && !date.getEnd().isValid()) {
                this.coef[1] = 0;
            } else {
                this.birthDate = new EntityMatcher.DateData(date);
                this.coef[1] = this.birthDate.isValid();
            }
            PropertyPlace place = indi.getBirthPlace();
            if (place == null) {
                this.coef[2] = 0;
            } else {
                this.birthPlace = new EntityMatcher.PlaceData(place);
                this.coef[2] = this.birthPlace.isValid();
            }
            date = indi.getDeathDate();
            if (date == null) {
                date = (PropertyDate)indi.getProperty(new TagPath("INDI:BURI:DATE"));
            }
            if (date == null || !date.isValid() || !date.getStart().isValid() || date.isRange() && !date.getEnd().isValid()) {
                this.coef[3] = 0;
            } else {
                this.deathDate = new EntityMatcher.DateData(date);
                this.coef[3] = this.deathDate.isValid();
            }
            place = indi.getDeathPlace();
            if (place == null) {
                this.coef[4] = 0;
            } else {
                this.deathPlace = new EntityMatcher.PlaceData(place);
                this.coef[4] = this.deathPlace.isValid();
            }
            Indi fatherIndi = indi.getBiologicalFather();
            if (fatherIndi == null) {
                this.coef[5] = 0;
            } else {
                this.father = new EntityMatcher.NameData(fatherIndi);
                this.coef[5] = this.father.isValid();
            }
            Indi motherIndi = indi.getBiologicalMother();
            if (motherIndi == null) {
                this.coef[6] = 0;
            } else {
                this.mother = new EntityMatcher.NameData(motherIndi);
                this.coef[6] = this.mother.isValid();
            }
            this.sex = indi.getSex();
            this.coef[7] = this.sex == 1 || this.sex == 2 ? 1 : 0;
            ArrayList<String> listOfElements = new ArrayList<String>();
            for (Fam fam : indi.getFamiliesWhereSpouse(true)) {
                Indi spouse = fam.getOtherSpouse(indi);
                if (spouse != null) {
                    listOfElements.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce((String[])spouse.getLastNames(), (boolean)false)));
                    listOfElements.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce((String[])spouse.getFirstNames(), (boolean)true)));
                }
                if ((date = fam.getMarriageDate()) != null) {
                    listOfElements.addAll(Arrays.asList(date.getDisplayValue((Calendar)PointInTime.GREGORIAN).split(" ")));
                }
                if ((place = fam.getMarriagePlace()) == null) continue;
                listOfElements.addAll(Arrays.asList(GedcomUtilities.normalizeAndReduce((String[])place.getDisplayValue().split(","), (boolean)false)));
            }
            if (listOfElements.isEmpty()) {
                this.coef[8] = 0;
            } else {
                this.spousesElements = GedcomUtilities.buildMap(listOfElements);
                this.coef[8] = 1;
            }
        }
    }
}

