/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.FamMatcher;
import ancestris.modules.gedcom.matchers.IndiMatcher;
import ancestris.modules.gedcom.matchers.MediaMatcher;
import ancestris.modules.gedcom.matchers.NoteMatcher;
import ancestris.modules.gedcom.matchers.RepositoryMatcher;
import ancestris.modules.gedcom.matchers.SourceMatcher;
import ancestris.modules.gedcom.matchers.SubmitterMatcher;
import ancestris.modules.gedcom.searchdupes.DuplicatesResults;
import ancestris.modules.gedcom.searchdupes.DuplicatesTask;
import ancestris.util.swing.PotentialMatch;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import spin.Spin;

public class DuplicatesFinder
implements Runnable {
    private Entity mainEntity = null;
    private Gedcom gedcom = null;
    private final TreeMap<String, List<Entity>> entitiesMap = new TreeMap();
    private final List<PotentialMatch<? extends Entity>> matchesLinkedList = new LinkedList<PotentialMatch<? extends Entity>>();
    private final TreeMap<String, EntityMatcher> entitiesMatchers = new TreeMap<String, EntityMatcher>(){
        {
            this.put("INDI", new IndiMatcher());
            this.put("FAM", new FamMatcher());
            this.put("NOTE", new NoteMatcher());
            this.put("SNOTE", new NoteMatcher());
            this.put("SOUR", new SourceMatcher());
            this.put("REPO", new RepositoryMatcher());
            this.put("SUBM", new SubmitterMatcher());
            this.put("OBJE", new MediaMatcher());
        }
    };

    public DuplicatesFinder(Entity entity) {
        this.mainEntity = entity;
        this.gedcom = entity.getGedcom();
        this.entitiesMap.put(entity.getTag(), Arrays.asList(entity));
    }

    public DuplicatesFinder(List<Entity> list) {
        if (!list.isEmpty()) {
            this.mainEntity = list.get(0);
            this.gedcom = list.get(0).getGedcom();
        }
        long now = PropertyChange.toLocal((long)System.currentTimeMillis());
        for (Entity e : list) {
            String tag = e.getTag();
            long duration = now - (e.getLastChange() != null ? e.getLastChange().getTime() : now - 10000L);
            if (duration > 8000L) continue;
            List<Entity> taglist = this.entitiesMap.get(tag);
            if (taglist == null) {
                taglist = new ArrayList<Entity>();
                this.entitiesMap.put(tag, taglist);
            }
            if (taglist.contains(e)) continue;
            taglist.add(e);
        }
    }

    @Override
    public void run() {
        if (this.gedcom == null) {
            return;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DuplicatesFinder.class, (String)"AutomaticDuplicateCheck"));
        this.findMatches(75);
        if (!this.matchesLinkedList.isEmpty()) {
            this.sortMatches(null, null);
        }
        StatusDisplayer.getDefault().setStatusText(null);
        DuplicatesResults results = new DuplicatesResults(this.gedcom, this.matchesLinkedList, this.mainEntity, true, 0);
        results.setParams(this.mainEntity, this.entitiesMatchers.get(this.mainEntity.getTag()));
        results.show();
    }

    public List<PotentialMatch<? extends Entity>> findMatches(int threshold) {
        int step = 0;
        for (String tag : this.entitiesMap.keySet()) {
            EntityMatcher entityMatcher = this.entitiesMatchers.get(tag);
            ArrayList entities = new ArrayList(this.gedcom.getEntities(tag));
            entityMatcher.setInputs(entities, true, ++step, this.entitiesMap.keySet().size());
            EntityMatcher.CalculateEntityKeysTask getKeystask = entityMatcher.getcalculateEntityKeys();
            DuplicatesTask task1 = (DuplicatesTask)Spin.off((Object)getKeystask);
            task1.run();
            LinkedHashMap sortedEntities = getKeystask.getClusters();
            for (Entity entity : this.entitiesMap.get(tag)) {
                HashSet entitiesSet = new HashSet();
                for (String key : entityMatcher.getKeys(entity)) {
                    List ents = (List)sortedEntities.get(key);
                    if (ents == null) continue;
                    entitiesSet.addAll(ents);
                }
                ArrayList<Entity> list = new ArrayList<Entity>(entitiesSet);
                list.remove(entity);
                list.add(0, entity);
                List<PotentialMatch<Entity>> potentialMatches = entityMatcher.getDuplicates(entity, list, true, threshold);
                if (potentialMatches.isEmpty()) continue;
                for (PotentialMatch<Entity> e : potentialMatches) {
                    if (!((Entity)e.getLeft()).getId().equals(entity.getId())) continue;
                    e.swap();
                }
                this.matchesLinkedList.addAll(potentialMatches);
            }
        }
        return this.matchesLinkedList;
    }

    public EntityMatcher getMatcher(Entity entity) {
        return this.entitiesMatchers.get(entity.getTag());
    }

    public int sortMatches(Entity entity1, Entity entity2) {
        int rank = -1;
        Collections.sort(this.matchesLinkedList, new Comparator<PotentialMatch<? extends Entity>>(){

            @Override
            public int compare(PotentialMatch<? extends Entity> e1, PotentialMatch<? extends Entity> e2) {
                if (e2.getCertainty() - e1.getCertainty() != 0) {
                    return e2.getCertainty() - e1.getCertainty();
                }
                return ((Entity)e1.getLeft()).toString(true).toLowerCase().compareTo(((Entity)e2.getLeft()).toString(true).toLowerCase());
            }
        });
        boolean found = false;
        if (entity1 != null && entity2 != null) {
            for (PotentialMatch<? extends Entity> match : this.matchesLinkedList) {
                ++rank;
                if (match.getLeft().equals(entity1) && match.getRight().equals(entity2)) {
                    found = true;
                    break;
                }
                if (!match.getLeft().equals(entity2) || !match.getRight().equals(entity1)) continue;
                found = true;
                match.swap();
                break;
            }
        }
        return found ? rank : -1;
    }

    public List<PotentialMatch<? extends Entity>> getResult() {
        return this.matchesLinkedList;
    }
}

