package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Task extends Swimlane implements EventContainer {
	
	private List controllers = new ArrayList();
	private List events = new ArrayList();
	private List timers = new ArrayList();
	private String blocking = "false";
	private String signalling = "true";
	private String notify = "false";
	private String description;
	private String dueDate;
	private String swimlane;
	private String priority = "normal";
	private HashMap customProperties = new HashMap();
	
	public void setProperty(String name, String newValue) {
		String oldValue = (String)customProperties.get(name);
		customProperties.put(name, newValue);
		firePropertyChange("custom", new String[] { name, oldValue }, new String[] {name, newValue});
	}
	
	public String getProperty(String name) {
		return (String)customProperties.get(name);
	}
	
	public Map getProperties() {
		return new HashMap(customProperties);
	}
	
	
	public void addController(Controller controller) {
		controllers.add(controller);
		firePropertyChange("controllerAdd", null, controller);
	}
	
	public void removeController(Controller controller) {
		controllers.remove(controller);
		firePropertyChange("controllerRemove", controller, null);
	}
	
	public Controller[] getControllers() {
		return (Controller[])controllers.toArray(new Controller[controllers.size()]);
	}
	
	public void addEvent(Event event) {
		events.add(event);
		firePropertyChange("eventAdd", null, event);
	}
	
	public void removeEvent(Event event) {
		events.remove(event);
		firePropertyChange("eventRemove", event, null);
	}
	
	public Event[] getEvents() {
		return (Event[])events.toArray(new Event[events.size()]);
	}
	
	public void addTimer(Timer timer) {
		timers.add(timer);
		firePropertyChange("timerAdd", null, timer);
	}
	
	public void removeTimer(Timer timer) {
		timers.remove(timer);
		firePropertyChange("timerRemove", timer, null);
	}
	
	public Timer[] getTimers() {
		return (Timer[])timers.toArray(new Timer[timers.size()]);
	}
	
	public void setBlocking(String newBlocking) {
		String oldBlocking = blocking;
		blocking = newBlocking;
		firePropertyChange("blocking", oldBlocking, newBlocking);
	}
	
	public String getBlocking() {
		return blocking;
	}
	
	public void setSignalling(String newSignalling) {
		String oldSignalling = signalling;
		signalling = newSignalling;
		firePropertyChange("signalling", oldSignalling, newSignalling);
	}
	
	public String getSignalling() {
		return signalling;
	}
	
	public void setNotify(String newNotify) {
		String oldNotify = notify;
		notify = newNotify;
		firePropertyChange("notify", oldNotify, newNotify);
	}
	
	public String getNotify() {
		return notify;
	}
	
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		firePropertyChange("description", oldDescription, newDescription);
	}
	
	public String getDescription() {
		return description;
	}
	
	public void setDueDate(String newDueDate) {
		String oldDueDate = dueDate;
		dueDate = newDueDate;
		firePropertyChange("duedate", oldDueDate, newDueDate);
	}
	
	public String getDueDate() {
		return dueDate;
	}
	
	public void setSwimlane(String newSwimlane) {
		String oldSwimlane = swimlane;
		swimlane = newSwimlane;
		firePropertyChange("swimlane", oldSwimlane, newSwimlane);
	}
	
	public String getSwimlane() {
		return swimlane;
	}
	
	public void setPriority(String newPriority) {
		String oldPriority = priority;
		priority = newPriority;
		firePropertyChange("priority", oldPriority, newPriority);
	}
	
	public String getPriority() {
		return priority;
	}

}
