package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Assignment;
import org.jbpm.gd.jpdl.model.ConfigInfoElement;
import org.jbpm.gd.jpdl.model.ConfigType;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;

public class AssignmentDomAdapter extends JpdlElementDomAdapter {
	
	private static HashMap NODE_TYPES = null;
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("configInfoElement", "configInfoElement");
		}
		return NODE_TYPES;
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Assignment assignment = (Assignment)jpdlElement;
		assignment.setConfigInfoString(getTextContent());
		assignment.setClassName(getAttribute("class"));
		assignment.setConfigType(getAttribute("config-type"));
		assignment.setExpression(getAttribute("expression"));
		assignment.setActorId(getAttribute("actor-id"));
		assignment.setPooledActors(getAttribute("pooled-actors"));
		assignment.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		Assignment assignment = (Assignment)getJpdlElement();
		if (assignment != null) {
			setTextContent(assignment.getConfigInfoString());
			setAttribute("class", assignment.getClassName());
			setAttribute("config-type", assignment.getConfigType());
			setAttribute("expression", assignment.getExpression());
			setAttribute("actor-id", assignment.getActorId());
			setAttribute("pooled-actors", assignment.getPooledActors());
		}
	}
	
	protected String getDefaultValue(String attributeName) {
		if ("config-type".equals(attributeName)) {
			return ConfigType.FIELD;
		} else {
			return super.getDefaultValue(attributeName);
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("configInfoString".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		} else if ("className".equals(evt.getPropertyName())) {
			setAttribute("class", (String)evt.getNewValue());
		} else if ("configType".equals(evt.getPropertyName())) {
			setAttribute("config-type", (String)evt.getNewValue());
		} else if ("expression".equals(evt.getPropertyName())) {
			setAttribute("expression", (String)evt.getNewValue());
		} else if ("actorId".equals(evt.getPropertyName())) {
			setAttribute("actor-id", (String)evt.getNewValue());
		} else if ("pooledActors".equals(evt.getPropertyName())) {
			setAttribute("pooled-actors", (String)evt.getNewValue());
		} else if ("configInfoElementAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("configInfoElementRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		}
	}
	
	private boolean isDifferent(String left, String right) {
		if (left == null) return right == null;
		return left.equals(right);
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Assignment assignment = (Assignment)getJpdlElement();
		if ("#text".equals(name) && assignment.getConfigInfoElements().length == 0) {
			if (isDifferent(assignment.getConfigInfoString(), getTextContent())) {
				assignment.setConfigInfoString(newValue);
			}
		} else if ("class".equals(name)) {
			assignment.setClassName(newValue);
		} else if ("config-type".equals(name)) {
			assignment.setConfigType(newValue);
		} else if ("expression".equals(name)) {
			assignment.setExpression(newValue);
		} else if ("actor-id".equals(name)) {
			assignment.setActorId(newValue);
		} else if ("pooled-actors".equals(name) ) {
			assignment.setPooledActors(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		Assignment assignment = (Assignment)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(type);
		child.initialize(jpdlElement);
		if ("configInfoElement".equals(type)) {
			assignment.addConfigInfoElement((ConfigInfoElement)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// an assignment cannot have any child nodes
	}
	
}
