package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;


public class CancelTimerDomAdapter extends JpdlElementDomAdapter {

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		CancelTimer cancelTimer = (CancelTimer)jpdlElement;
		cancelTimer.setName(getAttribute("name"));
		cancelTimer.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		CancelTimer cancelTimer = (CancelTimer)getJpdlElement();
		if (cancelTimer != null) {
			setAttribute("name", cancelTimer.getName());
		}
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		CancelTimer event = (CancelTimer)getJpdlElement();
		if ("name".equals(name)) {
			event.setName(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// an action cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// an action cannot have any child nodes
	}
	
	
}
