package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.ConfigType;
import org.jbpm.gd.jpdl.model.Handler;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;

public class HandlerDomAdapter extends JpdlElementDomAdapter {
	
	private static HashMap NODE_TYPES = null;
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("configInfoElement", "configInfoElement");
		}
		return NODE_TYPES;
	}
	
	protected String getDefaultValue(String attributeName) {
		if ("config-type".equals(attributeName)) {
			return ConfigType.FIELD;
		} else {
			return super.getDefaultValue(attributeName);
		}
	}
	
	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		Handler handler = (Handler)jpdlElement;
		handler.setConfigInfoString(getTextContent());
		handler.setClassName(getAttribute("class"));
		handler.setConfigType(getAttribute("config-type"));
		handler.addPropertyChangeListener(this);
	}
	
	protected void initialize() {
		super.initialize();
		Handler handler = (Handler)getJpdlElement();
		if (handler != null) {
			setTextContent(handler.getConfigInfoString());
			setAttribute("class", handler.getClassName());
			setAttribute("config-type", handler.getConfigType());
		}
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("configInfoString".equals(evt.getPropertyName())) {
			setTextContent((String)evt.getNewValue());
		} else if ("className".equals(evt.getPropertyName())) {
			setAttribute("class", (String)evt.getNewValue());
		} else if ("configType".equals(evt.getPropertyName())) {
			setAttribute("config-type", (String)evt.getNewValue());
		} else if ("configInfoElementAdd".equals(evt.getPropertyName())) {
			addElement((AbstractJpdlElement)evt.getNewValue());
		} else if ("configInfoElementRemove".equals(evt.getPropertyName())) {
			removeElement((AbstractJpdlElement)evt.getOldValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		Handler handler = (Handler)getJpdlElement();
		if ("#text".equals(name)) {
			handler.setConfigInfoString(newValue);
		} else if ("class".equals(name)) {
			handler.setClassName(newValue);
		} else if ("config-type".equals(name)) {
			handler.setConfigType(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		// a handler cannot have any child nodes
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		// a handler cannot have any child nodes
	}
	
}
