/** DOS Library for BASEC by William Yu (C)1998 **/

#include <stdio.h>
#include <conio.h>
#include "doslib.h"
//#include "graphlib.h"

extern FILE *fp;
extern int screen_mode;

double evaluate_ex();

int CLS_Handler()
  {
    if (screen_mode == 0)
      {
        clrscr();
      }
    else
      {
        GCLS_Handler();
      }
    return 0;
  }

int LOCATE_Handler()
  {
    int y = abs(evaluate_ex());
    int x = abs(evaluate_ex());
    int c = evaluate_ex();

    if (y > 25) y = 25;
    if (x > 80) x = 80;
    if (x == 0) x = wherex();
    if (y == 0) y = wherey();

    gotoxy(x,y);

    switch (c)
      {
        case 0:
          _setcursortype(_NOCURSOR);
          break;
        case 1:
          _setcursortype(_NORMALCURSOR);
          break;
        case 2:
          _setcursortype(_SOLIDCURSOR);
          break;
      }
    return 0;
  }

int COLOR_Handler()
  {
    int fore = evaluate_ex();
    int back = evaluate_ex();

    if (fore >= 0) textcolor(fore);
    if (back >= 0) textbackground(back);
    return 0;
  }

int INKEY_Handler(char *string)
  {
    int i=0;
    while (kbhit() != 0)
      {
        string[i++] = getkey();
      }

    string[i] = '\0';
    return 0;
  }


int INPUT_Handler(char *string)
  {
    int i = evaluate_ex();
    int n=0;

    while (n<i)
      {
        if (kbhit() != 0)
          string[n++] = getkey();
      }
    string[n] = '\0';

    return 0;
  }


void DOS_Library()
  {

    switch (fgetc(fp))
      {
        case IK_CLS:
          CLS_Handler();
          break;
        case IK_LOCATE:
          LOCATE_Handler();
          break;
        case IK_COLOR:
          COLOR_Handler();
          break;
      }

  }
/** Endof DOS_Library **/
