/***************************************************************
* C file:   cpuid.h... for cpuspeed.exe
*
*       This program has been developed by Intel Corporation.  
*		You have Intel's permission to incorporate this code 
*       into your product, royalty free.  Intel has various 
*	    intellectual property rights which it may assert under
*       certain circumstances, such as if another manufacturer's
*       processor mis-identifies itself as being "GenuineIntel"
*		when the CPUID instruction is executed.
*
*       Intel specifically disclaims all warranties, express or
*       implied, and all liability, including consequential and
*		other indirect damages, for the use of this code, 
*		including liability for infringement of any proprietary
*		rights, and including the warranties of merchantability
*		and fitness for a particular purpose.  Intel does not 
*		assume any responsibility for any errors which may 
*		appear in this code nor any responsibility to update it.
*
*  * Other brands and names are the property of their respective
*    owners.
*
*  Copyright (c) 1995, Intel Corporation.  All rights reserved.
***************************************************************/

#ifndef cpuid_h
#define cpuid_h



// OPCODE DEFINITIONS //////////////////////////////////////////

#define CPU_ID db 0x0f, 0xa2  /* CPUID opcode */

#define OPND32 db 0x66   /* Macro for allowing 32-bit */
                         //   in-line assembly opcodes



// Public Functions ////////////////////////////////////////////

/***************************************************************
* cpuidsupport()
*
* Inputs: none
*
* Returns:
*  1 = CPUID opcode is supported
*  0 = CPUID opcode is not supported
***************************************************************/

int cpuidsupport (void);


/***************************************************************
* cpuid()
*
* Inputs: none
*
* Returns:
* -1 = Error occurred, or a processor beyond the 80486 but not 
*         genuine Intel.
*  0 = 8086/88
*  2 = 80286
*  3 = 80386
*  4 = 80486
*  5 = Pentium(R) Processor
*  6 = PentiumPro(R) Processor
*  7 or higher = Processor beyond the PentiumPro6(R) Processor
***************************************************************/
int cpuid (void);



// Private Function Declarations ///////////////////////////////

/***************************************************************
* check_clone()
*
* Inputs: none
*
* Returns:
*   1      if processor is clone (limited detection ability)
*   0      otherwise
***************************************************************/
int check_clone (void);


/***************************************************************
* check_8086()
*
* Inputs: none
*
* Returns: 
*   0      if processor 8086
*   0xffff otherwise
***************************************************************/
static int check_8086 (void);


/***************************************************************
* check_80286()
*
* Inputs: none
*
* Returns:
*   2      if processor 80286
*   0xffff otherwise
***************************************************************/
static int check_80286 (void);


/***************************************************************
* check_80386()
*
* Inputs: none
*
* Returns:
*   3      if processor 80386
*   0xffff otherwise
***************************************************************/
static int check_80386 (void);


/***************************************************************
* check_80486()
*
* Inputs: none
*
* Returns:
*   4      if processor 80486
*   0xffff otherwise
***************************************************************/
static int check_80486 (void);


/***************************************************************
* check_IDProc()
*
* Inputs: none
*
* Returns:
*  5 if Pentium(R) Processor
*  6 or higher if Processor beyond the Pentium(R) Processor
***************************************************************/
static int check_IDProc (void);

#endif cpuid_u
