{
    This file is the source for a series of routines to help determine a
    descriptive string for a PCI device based on it's vendor and device IDs.
    Copyright (C) 1998 by Phil Brutsche

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the
    Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA  02111-1307  USA.
}

unit pcilist;

interface

function pci_resolve_vendor (vendor_id : word) : string;
function pci_resolve_device (vendor_id, device_id : word) : string;

implementation

uses strings, strs, crt, dos;

type
  string127 = string [127];
  string4 = string [4];
  string80 = string [80];

var
  dir : dirstr;
  name : ^namestr;
  ext : ^extstr;

function pci_resolve_vendor (vendor_id : word) : string;
var
  pci_vendor_file : text;
  found : boolean;
  input_line : string127;
  vendor_number : string4;
  vendor_name : string80;
begin
  assign (pci_vendor_file, dir + 'pci.dat');
  {$I-}reset (pci_vendor_file);{$I+}
  pci_resolve_vendor := '???';
  if ioresult <> 0 then
    exit;
  found := false;
  repeat
    readln (pci_vendor_file, input_line);
    if input_line [1] <> #9 then begin { device entries begin with #9 }
      vendor_number := copy (input_line, 1, 4);
      vendor_name := copy (input_line, 6, length (input_line) - 5);
      if strupr (dectohex16 (vendor_id)) = vendor_number then begin
        found := true;
        pci_resolve_vendor := vendor_name;
      end;
    end;
  until (eof (pci_vendor_file)) or (found);
  if (found = false) then
    pci_resolve_vendor := '???';
  close (pci_vendor_file);
end;

function pci_resolve_device (vendor_id, device_id : word) : string;
var
  pci_vendor_file : text;
  found : boolean;
  input_line : string127;
  vendor_number : string4;
  device_name : string80;
  device_number : string4;
begin
  assign (pci_vendor_file, dir + 'pci.dat');
  {$I-}reset (pci_vendor_file);{$I+}
  pci_resolve_device := '???';
  if ioresult <> 0 then
    exit;
  found := false;
  repeat
    readln (pci_vendor_file, input_line);
    if (input_line [1] <> #9) or (input_line [1] <> ';') then begin
    { device entries begin with #9, comments begin with ';' }
      vendor_number := copy (input_line, 1, 4);
      if strupr (dectohex16 (vendor_id)) = vendor_number then
        found := true;
    end;
  until (eof (pci_vendor_file)) or (found);
  if (found = false) then
    pci_resolve_device := '???';
  found := false;
  repeat
    readln (pci_vendor_file, input_line);
    if input_line [1] = #9 then begin
      device_number := copy (input_line, 2, 4);
      device_name := copy (input_line, 7, length (input_line) - 6);
      if strupr (dectohex16 (device_id)) = device_number then begin
        found := true;
        pci_resolve_device := device_name;
      end;
    end;
  until (input_line [1] <> #9) or (found);
  if (found = false) then
    pci_resolve_device := '???';
  close (pci_vendor_file);
end;

begin
  write ('PCILIST.TPU initializing...');
  new (name);
  new (ext);
  fsplit (paramstr (0), dir, name^, ext^);
  dispose (name);
  dispose (ext);
  strupr (dir);
  writeln ('Done');
end.
