/*  Directory related functions

    Copyright (c) Marty M. Peritsky 1996.
    All Rights Reserved.

    See COPY.TXT for more details.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <ctype.h>
#include <direct.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "copy.h"
#include "strfns.h"
#include "dirfns.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define TRUE         1
#define FALSE        0
#define MAX_FILE_EXT 13

// M A C R O S //////////////////////////////////////////////////////////////

#define STRCAT2(x, y) strcat3(x, y, "")

#define CWD_IS_ROOT     (!cwd_parent_exists)
#define DWD_IS_ROOT     (!dwd_parent_exists)
#define CWD_IS_NOT_ROOT cwd_parent_exists
#define DWD_IS_NOT_ROOT dwd_parent_exists

#define FNSPLITX(x) fnsplit(x, tf.drive, tf.dir, tf.file, tf.ext)
#define FNMERGEX(x) fnmerge(x, tf.drive, tf.dir, tf.file, tf.ext)
#define FNSPLIT     FNSPLITX(fn_path)
#define FNMERGE     FNMERGEX(fn_path)

// G L O B A L S ////////////////////////////////////////////////////////////

extern char cwd[MAXPATH], *dwd, cwd_parent[MAXPATH];
extern int cwd_parent_exists, dwd_parent_exists, s_switch;
extern struct ffblk filedata;

// F U N C T I O N S ////////////////////////////////////////////////////////

char *fullpath(char *q)
{
    int i;
    char *p, *devices[]={ "AUX", "COM1", "COM2", "COM3", "COM4", "CON", "LPT1", "LPT2", "LPT3", "NUL", "PRN", NULL };
    extern char fn_path[MAXPATH];
    extern struct fn_parts {
      char drive[MAXDRIVE], dir[MAXDIR], file[MAXFILE], ext[MAXEXT];
      } tf;

    for (i=0;devices[i] != NULL;i++)
        {
        if (strcmpi(devices[i], q) == 0)
            {
            return strdup1(devices[i]);
            } // end if.

        } // end for.

    if (strcmp(q, ".") == 0)
        {
        return CWD_IS_ROOT ? STRCAT2(cwd, "*.*") : STRCAT2(cwd, "\\*.*");
        } // end if.

    if (strcmp(q, "..") == 0)
        {
        if (cwd_parent_exists)
            {
            return STRCAT2(cwd_parent, "*.*");
            } // end if.
        else
            {
            printf("Specification .. is invalid, root does not have parent.\n");
            main_exit(1);
            } // end else.

        } // end if.

    if (strncmp(q, "..\\", 3) == 0)
        {
        if (cwd_parent_exists)
            {
            p=STRCAT2(cwd_parent, (q+3));
            } // end if.
        else
            {
            printf("Specification .. is invalid, root does not have parent.\n");
            main_exit(1);
            } // end else.

        } // end if.
    else
        {
        if (strncmp(q, ".\\", 2) == 0)
            {
            p=STRCAT2(cwd, (CWD_IS_ROOT ? (q+2) : (q+1)));
            } // end if.
        else
            {
            p=strdup1(q);
            } // end else.

        } // end else.

    i=FNSPLITX(p);
    if ((i & DRIVE) != 0)
        update_dwd(tf.drive);

    // The mask-and-shift operations in the next statement cause
    // the bits in the result to have the following meanings:
    // 0x01 -- wildcards are present
    // 0x02 -- filename and/or extension are present
    // 0x04 -- directory is present
    // 0x08 -- drive is present
    switch(((i & 28) >> 1) | (i & 3))
        {
        case 2:                         // Example: a.b
            strcpy(fn_path, cwd);
            if (CWD_IS_NOT_ROOT)
                strcat(fn_path,"\\");

            strcat(fn_path, p);
            if (is_dir(fn_path))
                strcat(fn_path,"\\*.*");

            break;

        case 3:                         // Example: *.*
            strcpy(fn_path, cwd);
            if (CWD_IS_NOT_ROOT)
                strcat(fn_path,"\\");

            strcat(fn_path, p);
            break;

        case 4:                         // Example: d\ or \d\
            if (*(tf.dir) != '\\')
                {
                strcpy(fn_path, cwd);
                if (CWD_IS_NOT_ROOT)
                    strcat(fn_path,"\\");

                } // end if.
            else
                {
                strncpy(fn_path, cwd, 2);
                fn_path[2]='\0';
                } // end else.

            strcat(fn_path, p);
            strcat(fn_path,"*.*");
            break;

        case 6:                         // Example: d\a.b or \d\a.b
            if (*(tf.dir) != '\\')
                {
                strcpy(fn_path, cwd);
                if (CWD_IS_NOT_ROOT)
                    strcat(fn_path,"\\");

                } // end if.
            else
                {
                strncpy(fn_path, cwd, 2);
                fn_path[2]='\0';
                } // end else.

            strcat(fn_path, p);
            if (is_dir(fn_path))
                strcat(fn_path,"\\*.*");

            break;

        case 7:                         // Example: d\*.* or \d\*.*
            if (*(tf.dir) != '\\')
                {
                strcpy(fn_path, cwd);
                if (CWD_IS_NOT_ROOT)
                    strcat(fn_path,"\\");

                } // end if.
            else
                {
                strncpy(fn_path, cwd, 2);
                fn_path[2]='\0';
                } // end else.

            strcat(fn_path, p);
            break;

        case 8:                         // Example: e:
            strcpy(fn_path, dwd);
            if (DWD_IS_NOT_ROOT)
                strcat(fn_path,"\\");

            strcat(fn_path, "*.*");
            break;

        case 10:                        // Example: e:a.b
            strcpy(fn_path, dwd);
            if (DWD_IS_NOT_ROOT)
                strcat(fn_path,"\\");

            strcat(fn_path, tf.file);
            strcat(fn_path, tf.ext);
            if (is_dir(fn_path))
                strcat(fn_path,"\\*.*");

            break;

        case 11:                        // Example: e:*.*
            strcpy(fn_path, dwd);
            if (DWD_IS_NOT_ROOT)
                strcat(fn_path,"\\");

            strcat(fn_path, tf.file);
            strcat(fn_path, tf.ext);
            break;

        case 12:                        // Example: e:d\ or e:\d\
            if (*(tf.dir) == '\\')
                strcpy(fn_path, p);
            else
                {
                strcpy(fn_path, dwd);
                if (DWD_IS_NOT_ROOT)
                    strcat(fn_path,"\\");

                strcat(fn_path, tf.dir);
                } // end else.

            strcat(fn_path, "*.*");
            break;

        case 14:                        // Example: e:d\a.b or e:\d\a.b
            if (*(tf.dir) == '\\')
                strcpy(fn_path, p);
            else
                {
                strcpy(fn_path, dwd);
                if (DWD_IS_NOT_ROOT)
                    strcat(fn_path,"\\");

                strcat(fn_path, tf.dir);
                strcat(fn_path, tf.file);
                strcat(fn_path, tf.ext);
                } // end else.

            if (is_dir(fn_path))
                strcat(fn_path,"\\*.*");

            break;

        case 15:                        // Example: e:d\*.* or e:\d\*.*
            if (*(tf.dir) == '\\')
                strcpy(fn_path, p);
            else
                {
                strcpy(fn_path, dwd);
                if (DWD_IS_NOT_ROOT)
                    strcat(fn_path,"\\");

                strcat(fn_path, tf.dir);
                strcat(fn_path, tf.file);
                strcat(fn_path, tf.ext);
                } // end else.

            break;

        default:                        // Error.
            printf("Specification %s is not valid.\n", p);
            main_exit(1);
            break;

        } // end switch.

    free(p);
    return strdup1(fn_path);

} // end fullpath.

/////////////////////////////////////////////////////////////////////////////

char *getcurdir1(char *p)
{
    char q[MAXDIR];

    if (getcurdir(toupper(*p)-'A'+1, q) == 0)
        {
        return strcat3(p, "\\", q);
        } // end if.
    else
        {
        printf("Unable to determine current directory of %s\n", p);
        main_exit(1);
        } // end else.

} // end getcurdir1.

/////////////////////////////////////////////////////////////////////////////

void update_dwd(char *p)
{
    if (toupper(*p) != toupper(*dwd))
        {
        free(dwd);
        dwd=getcurdir1(p);
        dwd_parent_exists=(strlen(dwd) > 3);
        } // end if.
        
} // end update_dwd.

/////////////////////////////////////////////////////////////////////////////

int is_dir(char *p)
{
    int i=FALSE;
    struct ffblk fd;

    if (findfirst(p, &fd, (FA_DIREC | FA_SYSTEM | FA_HIDDEN)) == 0)
        {
        if ((fd.ff_attrib & FA_DIREC) != 0 )
            {
            i=TRUE;
            } // end if.

        } // end if.

    return i;

} // end is_dir.

/////////////////////////////////////////////////////////////////////////////

int fnsplit2(char *x, char **drive_dir, char **file_ext)
{
    char fn_path[MAXPATH];
    int i;
    struct fn_parts {
      char drive[MAXDRIVE], dir[MAXDIR], file[MAXFILE], ext[MAXEXT];
       } tf;

    i=FNSPLITX(x);
    *drive_dir=STRCAT2(tf.drive, tf.dir);
    *file_ext=STRCAT2(tf.file, tf.ext);
    return i;

} // end fnsplit2.

/////////////////////////////////////////////////////////////////////////////

char *newname(char *f, char *p)
{
    char q[MAX_FILE_EXT];
    int i;

    for (i=0;i<MAX_FILE_EXT;i++)
        q[i]='\0';

    i=0;
    do
        {
        switch (*p)
            {
            case '?':
                switch (*f)
                    {
                    case '.':
                    case '\0':
                        p++;
                        break;
                    default:
                        q[i++]=*(f++);
                        p++;
                        break;

                    } // end switch.

                break;
            case '*':
                switch (*f)
                    {
                    case '.':
                    case '\0':
                        p++;
                        break;
                    default:
                        do
                            {
                            q[i++]=*(f++);
                            } // end do.
                        while ((*f != '.') && (*f != '\0') && (i<MAX_FILE_EXT));

                        do
                            {
                            p++;
                            } // end do.
                        while ((*p != '.') && (*p != '\0'));
                        break;

                    } // end switch.

                break;
            case '.':
                switch (*f)
                    {
                    case '.':
                        f++;
                    case '\0':
                        q[i++]='.';
                        p++;
                        break;
                    default:
                        do
                            {
                            f++;
                            } // end do.
                        while ((*f != '.') && (*f != '\0'));
                        break;

                    } // end switch.

                break;
            case '\0':
                break;

            default:
                switch (*f)
                    {
                    case '.':
                    case '\0':
                        break;
                    default:
                        f++;
                        break;

                    } // end switch.

                q[i++]=*(p++);
                break;

            } // end switch.

        } // end do.
    while (((*p) != '\0') && (i < MAX_FILE_EXT));

    return strdup1(q);

} // end newname.
