/*
// Program:  Format
// Version:  0.90
// Written By:  Brian E. Reifsnyder
// Copyright:  2002 under the terms of the GNU GPL, Version 2
// Module Name:  userint.c
// Module Description:  User interfacing functions.
*/

//#include <stdlib.h>


#define USERINT

#include <dos.h>

#include "format.h"
#include "userint.h"




void ASCII_CD_Number(unsigned long number)
{
  int comma_counter;
  int index;
  int right_index;
  int shift_counter;
  int shift_register;
  int shift_temp_register;
  int start_shift;

  index=0;

  do
    {
    ascii_cd_number[index]=0;

    index++;
    }while(index<14);

  ultoa(number,ascii_cd_number,10);

  /* Add Commas */
  index=13;
  right_index=13;
  start_shift=FALSE;

  do
    {
    if(ascii_cd_number[index]>0) start_shift=TRUE;

    if(start_shift==TRUE)
      {
      ascii_cd_number[right_index]=ascii_cd_number[index];
      ascii_cd_number[index]=0;
      right_index--;
      }

    index--;
    }while(index>=0);

  comma_counter=0;
  index=13;
  do
    {
    comma_counter++;

    if(ascii_cd_number[index]==0)
      {
      comma_counter=5;
      ascii_cd_number[index]=' ';
      }

    if(comma_counter==4)
      {
      shift_counter=index-1;
      shift_register=ascii_cd_number[index];
      ascii_cd_number[index]=',';
      do
	{
	shift_temp_register=ascii_cd_number[shift_counter];
	ascii_cd_number[shift_counter]=shift_register;
	shift_register=shift_temp_register;

	shift_counter--;
	}while(shift_counter>=0);

      comma_counter=0;
      }

    index--;
    }while(index>=0);

  ascii_cd_number[14]=0;
}

void Ask_User_To_Insert_Disk()
{
  printf(" Insert new diskette for drive %c:\n",param.drive_letter[0]);
  printf(" and press ENTER when ready...");

  /* Wait for a key */

  regs.h.ah = 0x08;
  intdos(&regs, &regs);

  printf("\n\n");
}

void Confirm_Hard_Drive_Formatting()
{

  printf("\n WARNING: ALL DATA ON NON-REMOVABLE DISK\n");
  printf(" DRIVE %c: WILL BE LOST!\n",param.drive_letter[0]);
  printf(" Proceed with Format (Y/N)?");

  /* Get keypress */
  regs.h.ah = 0x07;
  intdos(&regs, &regs);

  printf("\n");
  if( toupper(regs.h.al) != 'Y' ) exit(10);
  printf("\n");
}


void Critical_Error_Handler(int source,unsigned int error_code)
{
  unsigned int error_code_high = (error_code & 0xff00) >> 8;
  unsigned int error_code_low  = error_code & 0x00ff;

  if(source==BIOS)
    {
    error_code_high = error_code_low;
    error_code_low  = 0x00;
    }

  printf("\n Critical error encountered.");

  /* Display Status Message. */

  printf("\n   Status:  ");

  if(error_code_high==0x00) printf("none");
  if(error_code_high==0x01) printf("bad command");
  if(error_code_high==0x02) printf("bad address mark");
  if(error_code_high==0x03) printf("write-protected disk");
  if(error_code_high==0x04) printf("requested sector not found");
  if(error_code_high==0x08) printf("DMS failure");
  if(error_code_high==0x10) printf("data error (bad CRC)");
  if(error_code_high==0x20) printf("controller failed");
  if(error_code_high==0x40) printf("seek operation failed");
  if(error_code_high==0x80) printf("device failed to respond (timeout)");

  /* Display Error Message. */
  printf("\n   Error:   ");

  if(error_code_low==0x00)  printf("none");
//  if(error_code_low==0x00)  printf("write-protection violation attempted");
  if(error_code_low==0x01)  printf("unknown unit for driver");
  if(error_code_low==0x02)  printf("drive not ready");
  if(error_code_low==0x03)  printf("unknown command given to driver");
  if(error_code_low==0x04)  printf("data error (bad CRC)");
  if(error_code_low==0x05)  printf("bad device driver request structure length");
  if(error_code_low==0x06)  printf("seek error");
  if(error_code_low==0x07)  printf("unknown media type");
  if(error_code_low==0x08)  printf("sector not found");
  if(error_code_low==0x09)  printf("printer out of paper");    /*    :-)    */
  if(error_code_low==0x0a)  printf("write fault");
  if(error_code_low==0x0b)  printf("read fault");
  if(error_code_low==0x0c)  printf("general failure");
  if(error_code_low==0x0d)  printf("sharing violation");
  if(error_code_low==0x0e)  printf("lock violation");
  if(error_code_low==0x0f)  printf("invalid disk change");
  if(error_code_low==0x10)  printf("FCB unavailable");
  if(error_code_low==0x11)  printf("sharing buffer overflow");
  if(error_code_low==0x12)  printf("code page mismatch");
  if(error_code_low==0x13)  printf("out of input");
  if(error_code_low==0x14)  printf("insufficient disk space");

  printf("\n Program terminated.\n");

  exit(1);
}

void Display_Drive_Statistics()
{
  drive_statistics.bytes_available_on_disk
   =drive_statistics.bytes_total_disk_space
   -drive_statistics.bytes_in_bad_sectors;

  drive_statistics.allocation_units_available_on_disk
   =drive_statistics.bytes_available_on_disk
   /drive_statistics.bytes_in_each_allocation_unit;

  ASCII_CD_Number(drive_statistics.bytes_total_disk_space);
  printf("\n%13s bytes total disk space\n",ascii_cd_number);

  if(drive_statistics.bytes_in_bad_sectors>0)
    {
    ASCII_CD_Number(drive_statistics.bytes_in_bad_sectors);
    printf("%13s bytes in bad sectors\n",ascii_cd_number);
    }

  ASCII_CD_Number(drive_statistics.bytes_available_on_disk);
  printf("%13s bytes available on disk\n",ascii_cd_number);

  printf("\n");

  ASCII_CD_Number(drive_statistics.bytes_in_each_allocation_unit);
  printf("%13s bytes in each allocation unit.\n",ascii_cd_number);

  ASCII_CD_Number(drive_statistics.allocation_units_available_on_disk);
  printf("%13s allocation units available on disk.\n",ascii_cd_number);

  printf("\n");
  printf(" Volume Serial Number is %04X-%04X\n"
   ,drive_statistics.serial_number_high,drive_statistics.serial_number_low);
}

void Display_Invalid_Combination()
{
  printf("\n Invalid combination of options...please consult documentation.\n");
  printf(" Operation Terminated.\n");
  exit(4);
}

/* Help Routine */
void Display_Help_Screen()
{
  printf("\n%6s Version %s\n",NAME,VERSION);
  printf("Written By:  Brian E. Reifsnyder\n");
  printf("Copyright 1999 - 2002 under the terms of the GNU GPL, Version 2.\n\n");
  printf("Syntax:\n\n");
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/F:size] [/B | /S]\n");
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/T:tracks /N:sectors] [/B | /S]\n");
  printf("FORMAT drive: [/V[:label]] [/Q] [/U] [/1] [/4] [/B | /S]\n");
  printf("FORMAT drive: [/Q] [/U] [/1] [/4] [/8] [/B | /S]\n\n");
  printf(" /V:label   Specifies a volume label for the disk.\n");
  printf(" /Q         Quick formats the disk.  The disk can be UNFORMATed.\n");
  printf(" /U         Unconditionally formats the disk.  The disk cannot be UNFORMATted\n");
  printf(" /F:size    Specifies the size of the floppy disk to format.  Valid sizes are:\n");
  printf("              160, 180, 320, 360, 720, 1200, 1440, or 2880.\n");
  printf(" /B         Kept for compatibility, formally reserved space for the boot files.\n");
  printf(" /S         Copies the operating system files to make the disk bootable.\n");
  printf(" /T:tracks  Specifies the number of tracks on a floppy disk.\n");
  printf(" /N:sectors Specifies the number of sectors on a floppy disk.\n");
  printf(" /1         Formats a single side of a floppy disk.\n");
  printf(" /4         Formats a 360K floppy disk in a 1.2 MB floppy drive.\n");
  printf(" /8         Formats a 5.25\" disk with 8 sectors per track.\n");
}

void Display_Percentage_Formatted(unsigned long percentage)
{
  printf("%3d percent completed.\n",percentage);

  if(debug_prog!=TRUE)
    {
    /* Re-position cursor back to the beginning of the line */
/*  printf("\r");       Didn't work...
*/

    regs.h.ah = 0x0f;
    int86(0x10, &regs, &regs); /* Get current video display mode.           */

    regs.h.ah = 0x03;
    int86(0x10, &regs, &regs); /* Get cursor position.                      */

    regs.h.ah = 0x02;
    regs.h.dh = regs.h.dh--;
    int86(0x10, &regs, &regs); /* Set cursor position to beginning of line. */
    }
}

void IllegalArg(char *option, char *argptr)
{
    printf("Parameter value not allowed - %s%s\n", option, argptr);
    exit(1);
}

