/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "SHRTSIZE.H"

/* converts an unsigned long count of bytes into a string */
char *shortsize (char *s, unsigned long u)
{
	BYTE level = 0;
	unsigned long r = 0, d;
	char s1[2];

	/*integer part */
	while (u>1024)
	{
		r = u % 1024;
		u /= 1024;
		level++;
	}

	/* fractional part */
	d = r / 102;
	r = r % 102;
	if (r>=50) d++;
	if (d>9) { d=0; u++; }

	/* convert value to string */
	sprintf (s, "%4lu.%01lu", u, d);

	/* Unit */
	switch (level)  {
		case 0:  strcat (s, " B" /*" bytes"*/);
			   break;
		case 1:  strcat (s, "KB");
			   break;
		case 2:  strcat (s, "MB");
			   break;
		case 3:  strcat (s, "GB");
			   break;
	}
	return s;
}
