// Copyright © 2017-2018 Mozilla Foundation
//
// This program is made available under an ISC-style license.  See the
// accompanying file LICENSE for details.

use cubeb_backend::ffi::*;

static CHANNEL_LAYOUT_UNDEFINED: &'static [cubeb_channel] = &[CHANNEL_INVALID];
static CHANNEL_LAYOUT_DUAL_MONO: &'static [cubeb_channel] = &[CHANNEL_LEFT, CHANNEL_RIGHT];
static CHANNEL_LAYOUT_DUAL_MONO_LFE: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_LFE];
static CHANNEL_LAYOUT_MONO: &'static [cubeb_channel] = &[CHANNEL_MONO];
static CHANNEL_LAYOUT_MONO_LFE: &'static [cubeb_channel] = &[CHANNEL_MONO, CHANNEL_LFE];
static CHANNEL_LAYOUT_STEREO: &'static [cubeb_channel] = &[CHANNEL_LEFT, CHANNEL_RIGHT];
static CHANNEL_LAYOUT_STEREO_LFE: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_LFE];
static CHANNEL_LAYOUT_3F: &'static [cubeb_channel] = &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_CENTER];
static CHANNEL_LAYOUT_3FLFE: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_CENTER, CHANNEL_LFE];
static CHANNEL_LAYOUT_2F1: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_RCENTER];
static CHANNEL_LAYOUT_2F1LFE: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_LFE, CHANNEL_RCENTER];
static CHANNEL_LAYOUT_3F1: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_CENTER, CHANNEL_RCENTER];
static CHANNEL_LAYOUT_3F1LFE: &'static [cubeb_channel] = &[
    CHANNEL_LEFT,
    CHANNEL_RIGHT,
    CHANNEL_CENTER,
    CHANNEL_LFE,
    CHANNEL_RCENTER,
];
static CHANNEL_LAYOUT_2F2: &'static [cubeb_channel] =
    &[CHANNEL_LEFT, CHANNEL_RIGHT, CHANNEL_LS, CHANNEL_RS];
static CHANNEL_LAYOUT_2F2LFE: &'static [cubeb_channel] = &[
    CHANNEL_LEFT,
    CHANNEL_RIGHT,
    CHANNEL_LFE,
    CHANNEL_LS,
    CHANNEL_RS,
];
static CHANNEL_LAYOUT_3F2: &'static [cubeb_channel] = &[
    CHANNEL_LEFT,
    CHANNEL_RIGHT,
    CHANNEL_CENTER,
    CHANNEL_LS,
    CHANNEL_RS,
];
static CHANNEL_LAYOUT_3F2LFE: &'static [cubeb_channel] = &[
    CHANNEL_LEFT,
    CHANNEL_RIGHT,
    CHANNEL_CENTER,
    CHANNEL_LFE,
    CHANNEL_LS,
    CHANNEL_RS,
];
static CHANNEL_LAYOUT_3F3RLFE: &'static [cubeb_channel] = &[
    CHANNEL_LEFT,
    CHANNEL_RIGHT,
    CHANNEL_CENTER,
    CHANNEL_LFE,
    CHANNEL_RCENTER,
    CHANNEL_LS,
    CHANNEL_RS,
];
static CHANNEL_LAYOUT_3F4LFE: &'static [cubeb_channel] = &[
    CHANNEL_LEFT,
    CHANNEL_RIGHT,
    CHANNEL_CENTER,
    CHANNEL_LFE,
    CHANNEL_RLS,
    CHANNEL_RRS,
    CHANNEL_LS,
    CHANNEL_RS,
];

pub fn channel_index_to_order(layout: cubeb_channel_layout) -> &'static [cubeb_channel] {
    match layout {
        CUBEB_LAYOUT_DUAL_MONO => CHANNEL_LAYOUT_DUAL_MONO,
        CUBEB_LAYOUT_DUAL_MONO_LFE => CHANNEL_LAYOUT_DUAL_MONO_LFE,
        CUBEB_LAYOUT_MONO => CHANNEL_LAYOUT_MONO,
        CUBEB_LAYOUT_MONO_LFE => CHANNEL_LAYOUT_MONO_LFE,
        CUBEB_LAYOUT_STEREO => CHANNEL_LAYOUT_STEREO,
        CUBEB_LAYOUT_STEREO_LFE => CHANNEL_LAYOUT_STEREO_LFE,
        CUBEB_LAYOUT_3F => CHANNEL_LAYOUT_3F,
        CUBEB_LAYOUT_3F_LFE => CHANNEL_LAYOUT_3FLFE,
        CUBEB_LAYOUT_2F1 => CHANNEL_LAYOUT_2F1,
        CUBEB_LAYOUT_2F1_LFE => CHANNEL_LAYOUT_2F1LFE,
        CUBEB_LAYOUT_3F1 => CHANNEL_LAYOUT_3F1,
        CUBEB_LAYOUT_3F1_LFE => CHANNEL_LAYOUT_3F1LFE,
        CUBEB_LAYOUT_2F2 => CHANNEL_LAYOUT_2F2,
        CUBEB_LAYOUT_2F2_LFE => CHANNEL_LAYOUT_2F2LFE,
        CUBEB_LAYOUT_3F2 => CHANNEL_LAYOUT_3F2,
        CUBEB_LAYOUT_3F2_LFE => CHANNEL_LAYOUT_3F2LFE,
        CUBEB_LAYOUT_3F3R_LFE => CHANNEL_LAYOUT_3F3RLFE,
        CUBEB_LAYOUT_3F4_LFE => CHANNEL_LAYOUT_3F4LFE,
        _ => CHANNEL_LAYOUT_UNDEFINED,
    }
}
