/* Autogenerated file, DO NOT EDIT manually! generated by brw_oa.py
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdint.h>
#include <stdbool.h>

#include "util/hash_table.h"

#include "brw_oa_glk.h"
#include "brw_context.h"
#include "brw_performance_query.h"


#define MIN(a, b) ((a < b) ? (a) : (b))
#define MAX(a, b) ((a > b) ? (a) : (b))


/* Render Metrics Basic Gen9 :: GPU Core Clocks */
static uint64_t
glk__render_basic__gpu_core_clocks__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: EU Active */
static float
glk__render_basic__eu_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: L3 Misses */
static uint64_t
glk__render_basic__l3_misses__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: GTI L3 Throughput */
static uint64_t
glk__render_basic__gti_l3_throughput__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $L3Misses 64 UMUL */
   uint64_t tmp0 = glk__render_basic__l3_misses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Render Metrics Basic Gen9 :: EU Both FPU Pipes Active */
static float
glk__render_basic__eu_fpu_both_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Sampler Cache Misses */
static uint64_t
glk__render_basic__sampler_l1_misses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 8 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 8;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: VS Send Pipe Active */
static float
glk__render_basic__vs_send_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Sampler 1 Bottleneck */
static float
glk__render_basic__sampler1_bottleneck__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: VS FPU1 Pipe Active */
static float
glk__render_basic__vs_fpu1_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: GS Threads Dispatched */
static uint64_t
glk__render_basic__gs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: L3 Sampler Throughput */
static uint64_t
glk__render_basic__l3_sampler_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: $SamplerL1Misses 64 UMUL */
   uint64_t tmp0 = glk__render_basic__sampler_l1_misses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
glk__render_basic__hi_depth_test_fails__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: FS Both FPU Active */
static float
glk__render_basic__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: VS Threads Dispatched */
static uint64_t
glk__render_basic__vs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: FS Threads Dispatched */
static uint64_t
glk__render_basic__ps_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Sampler 0 Busy */
static float
glk__render_basic__sampler0_busy__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Sampler 1 Busy */
static float
glk__render_basic__sampler1_busy__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Samplers Busy */
static float
glk__render_basic__samplers_busy__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: $Sampler0Busy $Sampler1Busy FMAX */
   double tmp0 = glk__render_basic__sampler0_busy__read(brw, query, accumulator);
   double tmp1 = glk__render_basic__sampler1_busy__read(brw, query, accumulator);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic Gen9 :: GTI Fixed Pipe Throughput */
static uint64_t
glk__render_basic__gti_vf_throughput__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: B 6 READ B 7 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: Shader Barrier Messages */
static uint64_t
glk__render_basic__shader_barriers__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Sampler 0 Bottleneck */
static float
glk__render_basic__sampler0_bottleneck__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Sampler Texels */
static uint64_t
glk__render_basic__sampler_texels__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Pixels Failing Tests */
static uint64_t
glk__render_basic__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GPU Time Elapsed */
static uint64_t
glk__render_basic__gpu_time__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__render_basic__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__render_basic__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__render_basic__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Render Metrics Basic Gen9 :: Sampler Texels Misses */
static uint64_t
glk__render_basic__sampler_texel_misses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: CS Threads Dispatched */
static uint64_t
glk__render_basic__cs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Shader Memory Accesses */
static uint64_t
glk__render_basic__shader_memory_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: L3 Lookup Accesses w/o IC */
static uint64_t
glk__render_basic__l3_lookups__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
   uint64_t tmp0 = glk__render_basic__sampler_l1_misses__read(brw, query, accumulator) + glk__render_basic__shader_memory_accesses__read(brw, query, accumulator);

   return tmp0;
}

/* Render Metrics Basic Gen9 :: SLM Bytes Read */
static uint64_t
glk__render_basic__slm_bytes_read__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GTI Read Throughput */
static uint64_t
glk__render_basic__gti_read_throughput__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: PS FPU1 Pipe Active */
static float
glk__render_basic__ps_fpu1_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: PS Send Pipeline Active */
static float
glk__render_basic__ps_send_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Rasterized Pixels */
static uint64_t
glk__render_basic__rasterized_pixels__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GPU Busy */
static float
glk__render_basic__gpu_busy__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: GTI Depth Throughput */
static uint64_t
glk__render_basic__gti_depth_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 0 READ C 1 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = accumulator[query->c_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: VS FPU0 Pipe Active */
static float
glk__render_basic__vs_fpu0_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: PS FPU0 Pipe Active */
static float
glk__render_basic__ps_fpu0_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: DS Threads Dispatched */
static uint64_t
glk__render_basic__ds_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Samples Written */
static uint64_t
glk__render_basic__samples_written__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: EU Stall */
static float
glk__render_basic__eu_stall__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Samples Blended */
static uint64_t
glk__render_basic__samples_blended__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Early Depth Test Fails */
static uint64_t
glk__render_basic__early_depth_test_fails__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Samplers Bottleneck */
static float
glk__render_basic__sampler_bottleneck__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
   double tmp0 = glk__render_basic__sampler0_bottleneck__read(brw, query, accumulator);
   double tmp1 = glk__render_basic__sampler1_bottleneck__read(brw, query, accumulator);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic Gen9 :: GTI HDC TLB Lookup Throughput */
static uint64_t
glk__render_basic__gti_hdc_lookups_throughput__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GTI RCC Throughput */
static uint64_t
glk__render_basic__gti_rcc_throughput__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 2 READ C 3 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = accumulator[query->c_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: HS Threads Dispatched */
static uint64_t
glk__render_basic__hs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: GTI Write Throughput */
static uint64_t
glk__render_basic__gti_write_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: SLM Bytes Written */
static uint64_t
glk__render_basic__slm_bytes_written__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: L3 Shader Throughput */
static uint64_t
glk__render_basic__l3_shader_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__render_basic__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Samples Killed in FS */
static uint64_t
glk__render_basic__samples_killed_in_ps__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__render_basic__shader_atomics__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_render_basic_mux_regs[80];
static struct brw_perf_query_register_prog glk_render_basic_b_counter_regs[5];
static struct brw_perf_query_register_prog glk_render_basic_flex_regs[7];

static struct brw_perf_query_counter glk_render_basic_query_counters[52];
static struct brw_perf_query_info glk_render_basic_query = {
   .kind = OA_COUNTERS,
   .name = "Render Metrics Basic Gen9",
   .guid = "d72df5c7-5b4a-4274-a43f-00b0fd51fc68",
   .counters = glk_render_basic_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_render_basic_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_render_basic_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_render_basic_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_render_basic_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_render_basic_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x166C00F0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x12120280 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x12320280 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11930317 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x159303DF };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x3F900C00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x419000A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x082D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A2D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E0800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E5900 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C4F0010 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A6C0053 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x106C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C6C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0FCC00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F0002 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C2C0040 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00101000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04101000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00114000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08114000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00120020 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08120021 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00141000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08141000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02308000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04302000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06318000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08318000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06320800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08320840 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00320000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06344000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08344000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D931831 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F939F3F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01939E80 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x039303BC };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0593000E };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1993002A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07930000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09930000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D900177 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F900187 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x35900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x27904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53901110 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900423 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900111 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900C02 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49900020 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59901111 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900421 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900821 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__l3_misses__read;
      counter->name = "L3 Misses";
      counter->desc = "The total number of L3 misses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_l3_throughput__read;
      counter->name = "GTI L3 Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__sampler_l1_misses__read;
      counter->name = "Sampler Cache Misses";
      counter->desc = "The total number of sampler cache misses in all LODs in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x12) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__render_basic__sampler1_bottleneck__read;
         counter->name = "Sampler 1 Bottleneck";
         counter->desc = "The percentage of time in which Sampler 1 has been slowing down the pipe when processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 52;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__l3_sampler_throughput__read;
      counter->name = "L3 Sampler Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 88;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x09) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__render_basic__sampler0_busy__read;
         counter->name = "Sampler 0 Busy";
         counter->desc = "The percentage of time in which Sampler 0 has been processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 112;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x12) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__render_basic__sampler1_busy__read;
         counter->name = "Sampler 1 Busy";
         counter->desc = "The percentage of time in which Sampler 1 has been processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 116;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__samplers_busy__read;
      counter->name = "Samplers Busy";
      counter->desc = "The percentage of time in which samplers have been processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 120;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_vf_throughput__read;
      counter->name = "GTI Fixed Pipe Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between 3D Pipeline (Command Dispatch, Input Assembly and Stream Output) and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x09) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__render_basic__sampler0_bottleneck__read;
         counter->name = "Sampler 0 Bottleneck";
         counter->desc = "The percentage of time in which Sampler 0 has been slowing down the pipe when processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 144;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__render_basic__avg_gpu_core_frequency__max(brw);
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__l3_lookups__read;
      counter->name = "L3 Lookup Accesses w/o IC";
      counter->desc = "The total number of L3 cache lookup accesses w/o IC.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 232;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 236;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 248;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_depth_throughput__read;
      counter->name = "GTI Depth Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between depth caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 264;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 268;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 288;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_basic__sampler_bottleneck__read;
      counter->name = "Samplers Bottleneck";
      counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 312;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_hdc_lookups_throughput__read;
      counter->name = "GTI HDC TLB Lookup Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between GTI and HDC, when HDC is doing TLB lookups.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_rcc_throughput__read;
      counter->name = "GTI RCC Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between render color caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 328;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 336;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 344;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 352;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 360;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 368;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_basic__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 376;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Basic Gen9 :: GPU Core Clocks */
static uint64_t
glk__compute_basic__gpu_core_clocks__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: EU Active */
static float
glk__compute_basic__eu_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: Untyped Bytes Read */
static uint64_t
glk__compute_basic__untyped_bytes_read__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 6 READ B 7 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: EU Both FPU Pipes Active */
static float
glk__compute_basic__eu_fpu_both_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: Typed Bytes Written */
static uint64_t
glk__compute_basic__typed_bytes_written__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 3 READ B 4 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = accumulator[query->b_offset + 4];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: EU FPU0 Pipe Active */
static float
glk__compute_basic__fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: EU FPU1 Pipe Active */
static float
glk__compute_basic__fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: EU AVG IPC Rate */
static float
glk__compute_basic__eu_avg_ipc_rate__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics Basic Gen9 :: GS Threads Dispatched */
static uint64_t
glk__compute_basic__gs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
glk__compute_basic__hi_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: VS Threads Dispatched */
static uint64_t
glk__compute_basic__vs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: FS Threads Dispatched */
static uint64_t
glk__compute_basic__ps_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: Shader Barrier Messages */
static uint64_t
glk__compute_basic__shader_barriers__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: Sampler Texels */
static uint64_t
glk__compute_basic__sampler_texels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Pixels Failing Tests */
static uint64_t
glk__compute_basic__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: GPU Time Elapsed */
static uint64_t
glk__compute_basic__gpu_time__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_basic__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__compute_basic__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_basic__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Basic Gen9 :: Sampler Texels Misses */
static uint64_t
glk__compute_basic__sampler_texel_misses__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: CS Threads Dispatched */
static uint64_t
glk__compute_basic__cs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: SLM Bytes Read */
static uint64_t
glk__compute_basic__slm_bytes_read__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: GTI Read Throughput */
static uint64_t
glk__compute_basic__gti_read_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Untyped Writes */
static uint64_t
glk__compute_basic__untyped_bytes_written__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: C 1 READ C 2 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = accumulator[query->c_offset + 2];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: GPU Busy */
static float
glk__compute_basic__gpu_busy__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: Rasterized Pixels */
static uint64_t
glk__compute_basic__rasterized_pixels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Typed Bytes Read */
static uint64_t
glk__compute_basic__typed_bytes_read__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: B 0 READ B 1 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp4 = tmp2 * tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: DS Threads Dispatched */
static uint64_t
glk__compute_basic__ds_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: EU Thread Occupancy */
static float
glk__compute_basic__eu_thread_occupancy__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL  $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0 * 8;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = brw->perfquery.sys_vars.eu_threads_count;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Compute Metrics Basic Gen9 :: EU Stall */
static float
glk__compute_basic__eu_stall__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: Samples Blended */
static uint64_t
glk__compute_basic__samples_blended__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Early Depth Test Fails */
static uint64_t
glk__compute_basic__early_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Shader Memory Accesses */
static uint64_t
glk__compute_basic__shader_memory_accesses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: HS Threads Dispatched */
static uint64_t
glk__compute_basic__hs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: GTI Write Throughput */
static uint64_t
glk__compute_basic__gti_write_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: SLM Bytes Written */
static uint64_t
glk__compute_basic__slm_bytes_written__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: L3 Shader Throughput */
static uint64_t
glk__compute_basic__l3_shader_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__compute_basic__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: Samples Killed in FS */
static uint64_t
glk__compute_basic__samples_killed_in_ps__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Samples Written */
static uint64_t
glk__compute_basic__samples_written__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__compute_basic__shader_atomics__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: EU Send Pipe Active */
static float
glk__compute_basic__eu_send_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_register_prog glk_compute_basic_mux_regs[72];
static struct brw_perf_query_register_prog glk_compute_basic_b_counter_regs[5];
static struct brw_perf_query_register_prog glk_compute_basic_flex_regs[7];

static struct brw_perf_query_counter glk_compute_basic_query_counters[39];
static struct brw_perf_query_info glk_compute_basic_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Basic Gen9",
   .guid = "814285f6-354d-41d2-ba49-e24e622714a0",
   .counters = glk_compute_basic_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_compute_basic_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_compute_basic_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_compute_basic_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_compute_basic_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_compute_basic_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x104F00E0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x124F1C00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x39900340 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x3F900C00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x41900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x082D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A2D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E1400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E5100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102E0114 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x104C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x124C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x164C2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004F6B42 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064F6200 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084F4100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4F0061 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4F6C4C };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4F4B00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A4F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C4F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F8800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F08A2 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x182C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C2C1451 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E2C0001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C0010 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19938A28 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19900177 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B900178 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D900125 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F900123 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x35900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x27904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53901000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900111 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00000003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00002001 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00778008 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00088078 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00808708 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00A08908 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__untyped_bytes_read__read;
      counter->name = "Untyped Bytes Read";
      counter->desc = "The total number of typed memory bytes read via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__typed_bytes_written__read;
      counter->name = "Typed Bytes Written";
      counter->desc = "The total number of untyped memory bytes written via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 44;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__compute_basic__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__untyped_bytes_written__read;
      counter->name = "Untyped Writes";
      counter->desc = "The total number of untyped memory bytes written via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__typed_bytes_read__read;
      counter->name = "Typed Bytes Read";
      counter->desc = "The total number of typed memory bytes read via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__eu_thread_occupancy__read;
      counter->name = "EU Thread Occupancy";
      counter->desc = "The percentage of time in which hardware threads occupied EUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 204;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_basic__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_basic__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 288;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GPU Core Clocks */
static uint64_t
glk__render_pipe_profile__gpu_core_clocks__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: EU Active */
static float
glk__render_pipe_profile__eu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: VS Bottleneck */
static float
glk__render_pipe_profile__vs_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Hi-Depth Bottleneck */
static float
glk__render_pipe_profile__hi_depth_bottleneck__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GS Bottleneck */
static float
glk__render_pipe_profile__gs_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GS Threads Dispatched */
static uint64_t
glk__render_pipe_profile__gs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
glk__render_pipe_profile__hi_depth_test_fails__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: VS Threads Dispatched */
static uint64_t
glk__render_pipe_profile__vs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: FS Threads Dispatched */
static uint64_t
glk__render_pipe_profile__ps_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: BC Bottleneck */
static float
glk__render_pipe_profile__bc_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: HS Stall */
static float
glk__render_pipe_profile__hs_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Shader Barrier Messages */
static uint64_t
glk__render_pipe_profile__shader_barriers__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Sampler Texels */
static uint64_t
glk__render_pipe_profile__sampler_texels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Pixels Failing Tests */
static uint64_t
glk__render_pipe_profile__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GPU Time Elapsed */
static uint64_t
glk__render_pipe_profile__gpu_time__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__render_pipe_profile__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__render_pipe_profile__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__render_pipe_profile__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Sampler Texels Misses */
static uint64_t
glk__render_pipe_profile__sampler_texel_misses__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: CS Threads Dispatched */
static uint64_t
glk__render_pipe_profile__cs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: VF Bottleneck */
static float
glk__render_pipe_profile__vf_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SLM Bytes Read */
static uint64_t
glk__render_pipe_profile__slm_bytes_read__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Strip-Fans Bottleneck */
static float
glk__render_pipe_profile__sf_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SF Stall */
static float
glk__render_pipe_profile__sf_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GPU Busy */
static float
glk__render_pipe_profile__gpu_busy__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: HS Bottleneck */
static float
glk__render_pipe_profile__hs_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: CL Stall */
static float
glk__render_pipe_profile__cl_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SO Bottleneck */
static float
glk__render_pipe_profile__so_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Rasterized Pixels */
static uint64_t
glk__render_pipe_profile__rasterized_pixels__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: DS Threads Dispatched */
static uint64_t
glk__render_pipe_profile__ds_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Samples Written */
static uint64_t
glk__render_pipe_profile__samples_written__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: DS Bottleneck */
static float
glk__render_pipe_profile__ds_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: EU Stall */
static float
glk__render_pipe_profile__eu_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Clipper Bottleneck */
static float
glk__render_pipe_profile__cl_bottleneck__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: DS Stall */
static float
glk__render_pipe_profile__ds_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Early Depth Bottleneck */
static float
glk__render_pipe_profile__early_depth_bottleneck__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: B 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Samples Blended */
static uint64_t
glk__render_pipe_profile__samples_blended__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Early Depth Test Fails */
static uint64_t
glk__render_pipe_profile__early_depth_test_fails__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Shader Memory Accesses */
static uint64_t
glk__render_pipe_profile__shader_memory_accesses__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: HS Threads Dispatched */
static uint64_t
glk__render_pipe_profile__hs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SLM Bytes Written */
static uint64_t
glk__render_pipe_profile__slm_bytes_written__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: L3 Shader Throughput */
static uint64_t
glk__render_pipe_profile__l3_shader_throughput__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__render_pipe_profile__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Samples Killed in FS */
static uint64_t
glk__render_pipe_profile__samples_killed_in_ps__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SO Stall */
static float
glk__render_pipe_profile__so_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__render_pipe_profile__shader_atomics__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_render_pipe_profile_mux_regs[94];
static struct brw_perf_query_register_prog glk_render_pipe_profile_b_counter_regs[21];
static struct brw_perf_query_register_prog glk_render_pipe_profile_flex_regs[7];

static struct brw_perf_query_counter glk_render_pipe_profile_query_counters[43];
static struct brw_perf_query_info glk_render_pipe_profile_query = {
   .kind = OA_COUNTERS,
   .name = "Render Metrics for 3D Pipeline Profile Gen9",
   .guid = "07d397a6-b3e6-49f6-9433-a4f293d55978",
   .counters = glk_render_pipe_profile_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_render_pipe_profile_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_render_pipe_profile_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_render_pipe_profile_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_render_pipe_profile_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_render_pipe_profile_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E001F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A2F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x10186800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11810019 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15810013 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13820020 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11830020 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17840000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11860007 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21860000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x178703E0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2D8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022E5400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002E0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x082F0040 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06143000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06174000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06180012 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00180000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D804000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F804000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05804000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09810200 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B810030 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03810003 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21819140 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23819050 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25810018 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B820980 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03820D80 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11820000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0182C000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07828000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09824000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F828000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D830004 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0583000C };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F831000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01848072 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11840000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07848000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09844000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F848000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07860000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09860092 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F860400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01869100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F870065 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01870000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19930800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B952000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D955055 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F951455 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0992A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F928000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1192A800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1392028A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B92A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D922000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x27908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x29908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900C01 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49900863 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900061 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900C22 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x0007FFEA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x00007FFC };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x0007AFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000F5FD };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x00079FFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000F3FB };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x0007BF7A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000F7E7 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x0007FEFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000F7CF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x00077FFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000EFDF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A0, .val = 0x0006FFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A4, .val = 0x0000CFBF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A8, .val = 0x0003FFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027AC, .val = 0x00005F7F };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00025024 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00035034 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00045044 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00055054 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00065064 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__vs_bottleneck__read;
      counter->name = "VS Bottleneck";
      counter->desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__hi_depth_bottleneck__read;
      counter->name = "Hi-Depth Bottleneck";
      counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__gs_bottleneck__read;
      counter->name = "GS Bottleneck";
      counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__bc_bottleneck__read;
      counter->name = "BC Bottleneck";
      counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__hs_stall__read;
      counter->name = "HS Stall";
      counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 60;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__render_pipe_profile__avg_gpu_core_frequency__max(brw);
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__vf_bottleneck__read;
      counter->name = "VF Bottleneck";
      counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__sf_bottleneck__read;
      counter->name = "Strip-Fans Bottleneck";
      counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__sf_stall__read;
      counter->name = "SF Stall";
      counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 140;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__hs_bottleneck__read;
      counter->name = "HS Bottleneck";
      counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__cl_stall__read;
      counter->name = "CL Stall";
      counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__so_bottleneck__read;
      counter->name = "SO Bottleneck";
      counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__ds_bottleneck__read;
      counter->name = "DS Bottleneck";
      counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 188;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__cl_bottleneck__read;
      counter->name = "Clipper Bottleneck";
      counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__ds_stall__read;
      counter->name = "DS Stall";
      counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 196;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__early_depth_bottleneck__read;
      counter->name = "Early Depth Bottleneck";
      counter->desc = "The percentage of time in which early depth test pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__render_pipe_profile__so_stall__read;
      counter->name = "SO Stall";
      counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__render_pipe_profile__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Memory Reads Distribution Gen9 :: GPU Core Clocks */
static uint64_t
glk__memory_reads__gpu_core_clocks__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: EU Active */
static float
glk__memory_reads__eu_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__memory_reads__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank0Reads */
static uint64_t
glk__memory_reads__gti_l3_bank0_reads__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GS Threads Dispatched */
static uint64_t
glk__memory_reads__gs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiRingAccesses */
static uint64_t
glk__memory_reads__gti_ring_accesses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
glk__memory_reads__hi_depth_test_fails__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: VS Threads Dispatched */
static uint64_t
glk__memory_reads__vs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: FS Threads Dispatched */
static uint64_t
glk__memory_reads__ps_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank3Reads */
static uint64_t
glk__memory_reads__gti_l3_bank3_reads__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Shader Barrier Messages */
static uint64_t
glk__memory_reads__shader_barriers__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiRsMemoryReads */
static uint64_t
glk__memory_reads__gti_rs_memory_reads__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Sampler Texels */
static uint64_t
glk__memory_reads__sampler_texels__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: Pixels Failing Tests */
static uint64_t
glk__memory_reads__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiHizMemoryReads */
static uint64_t
glk__memory_reads__gti_hiz_memory_reads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GPU Time Elapsed */
static uint64_t
glk__memory_reads__gpu_time__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Reads Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__memory_reads__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__memory_reads__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__memory_reads__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Memory Reads Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__memory_reads__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Memory Reads Distribution Gen9 :: Sampler Texels Misses */
static uint64_t
glk__memory_reads__sampler_texel_misses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiRccMemoryReads */
static uint64_t
glk__memory_reads__gti_rcc_memory_reads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: CS Threads Dispatched */
static uint64_t
glk__memory_reads__cs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: SLM Bytes Read */
static uint64_t
glk__memory_reads__slm_bytes_read__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank1Reads */
static uint64_t
glk__memory_reads__gti_l3_bank1_reads__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 5 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GPU Busy */
static float
glk__memory_reads__gpu_busy__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__memory_reads__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Reads Distribution Gen9 :: GtiCmdStreamerMemoryReads */
static uint64_t
glk__memory_reads__gti_cmd_streamer_memory_reads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank2Reads */
static uint64_t
glk__memory_reads__gti_l3_bank2_reads__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 6 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiMemoryReads */
static uint64_t
glk__memory_reads__gti_memory_reads__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 0];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Rasterized Pixels */
static uint64_t
glk__memory_reads__rasterized_pixels__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiRczMemoryReads */
static uint64_t
glk__memory_reads__gti_rcz_memory_reads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: DS Threads Dispatched */
static uint64_t
glk__memory_reads__ds_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Samples Written */
static uint64_t
glk__memory_reads__samples_written__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: EU Stall */
static float
glk__memory_reads__eu_stall__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__memory_reads__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution Gen9 :: Samples Blended */
static uint64_t
glk__memory_reads__samples_blended__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: Early Depth Test Fails */
static uint64_t
glk__memory_reads__early_depth_test_fails__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiMscMemoryReads */
static uint64_t
glk__memory_reads__gti_msc_memory_reads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiVfMemoryReads */
static uint64_t
glk__memory_reads__gti_vf_memory_reads__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiStcMemoryReads */
static uint64_t
glk__memory_reads__gti_stc_memory_reads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Shader Memory Accesses */
static uint64_t
glk__memory_reads__shader_memory_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: HS Threads Dispatched */
static uint64_t
glk__memory_reads__hs_threads__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Samples Killed in FS */
static uint64_t
glk__memory_reads__samples_killed_in_ps__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: SLM Bytes Written */
static uint64_t
glk__memory_reads__slm_bytes_written__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiL3Reads */
static uint64_t
glk__memory_reads__gti_l3_reads__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: $GtiL3Bank0Reads $GtiL3Bank1Reads $GtiL3Bank2Reads $GtiL3Bank3Reads UADD UADD UADD */
   uint64_t tmp0 = glk__memory_reads__gti_l3_bank2_reads__read(brw, query, accumulator) + glk__memory_reads__gti_l3_bank3_reads__read(brw, query, accumulator);
   uint64_t tmp1 = glk__memory_reads__gti_l3_bank1_reads__read(brw, query, accumulator) + tmp0;
   uint64_t tmp2 = glk__memory_reads__gti_l3_bank0_reads__read(brw, query, accumulator) + tmp1;

   return tmp2;
}

/* Memory Reads Distribution Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__memory_reads__shader_atomics__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_memory_reads_mux_regs[44];
static struct brw_perf_query_register_prog glk_memory_reads_b_counter_regs[32];
static struct brw_perf_query_register_prog glk_memory_reads_flex_regs[7];

static struct brw_perf_query_counter glk_memory_reads_query_counters[41];
static struct brw_perf_query_info glk_memory_reads_query = {
   .kind = OA_COUNTERS,
   .name = "Memory Reads Distribution Gen9",
   .guid = "1a356946-5428-450b-a2f0-89f8783a302d",
   .counters = glk_memory_reads_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_memory_reads_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_memory_reads_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_memory_reads_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_memory_reads_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_memory_reads_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19800343 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x39900340 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x3F901000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x41900003 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03803180 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x058035E2 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0780006A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11800000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2181A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2381000A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D950550 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B928000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D92A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F922000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13900170 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21900171 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23900172 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25900173 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x27900174 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x29900175 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B900176 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D900177 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F90017F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31900125 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15900123 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17900121 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x35900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47901080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900004 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000272C, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002728, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000271C, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002718, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000274C, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002748, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00006667 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000275C, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002758, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002754, .val = 0x00006465 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002750, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x0007F81A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x0007F82A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x0007F872 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x0007F8BA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x0007F87A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x0007F8EA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A0, .val = 0x0007F8E2 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A4, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A8, .val = 0x0007F8F2 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027AC, .val = 0x0000FE00 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00025024 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00035034 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00045044 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00055054 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00065064 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__memory_reads__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_l3_bank0_reads__read;
      counter->name = "GtiL3Bank0Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 0 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_ring_accesses__read;
      counter->name = "GtiRingAccesses";
      counter->desc = "The total number of all accesses from GTI to the ring.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_l3_bank3_reads__read;
      counter->name = "GtiL3Bank3Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 3 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_rs_memory_reads__read;
      counter->name = "GtiRsMemoryReads";
      counter->desc = "The total number of GTI memory reads from Resource Streamer.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_hiz_memory_reads__read;
      counter->name = "GtiHizMemoryReads";
      counter->desc = "The total number of GTI memory reads from Hierarchical Depth Cache (Hi-Depth Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__memory_reads__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_rcc_memory_reads__read;
      counter->name = "GtiRccMemoryReads";
      counter->desc = "The total number of GTI memory reads from Render Color Cache (Render Color Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_l3_bank1_reads__read;
      counter->name = "GtiL3Bank1Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 1 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__memory_reads__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_cmd_streamer_memory_reads__read;
      counter->name = "GtiCmdStreamerMemoryReads";
      counter->desc = "The total number of GTI memory reads from Command Streamer.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_l3_bank2_reads__read;
      counter->name = "GtiL3Bank2Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 2 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_memory_reads__read;
      counter->name = "GtiMemoryReads";
      counter->desc = "The total number of GTI memory reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_rcz_memory_reads__read;
      counter->name = "GtiRczMemoryReads";
      counter->desc = "The total number of GTI memory reads from Render Depth Cache (Render Depth Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__memory_reads__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 232;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_msc_memory_reads__read;
      counter->name = "GtiMscMemoryReads";
      counter->desc = "The total number of GTI memory reads from Multisampling Color Cache (Multisampling Color Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_vf_memory_reads__read;
      counter->name = "GtiVfMemoryReads";
      counter->desc = "The total number of GTI memory reads from Vertex Fetch.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_stc_memory_reads__read;
      counter->name = "GtiStcMemoryReads";
      counter->desc = "The total number of GTI memory reads from Stencil Cache (Stencil Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__gti_l3_reads__read;
      counter->name = "GtiL3Reads";
      counter->desc = "The total number of GTI memory reads from L3 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_reads__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Memory Writes Distribution Gen9 :: GPU Core Clocks */
static uint64_t
glk__memory_writes__gpu_core_clocks__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: EU Active */
static float
glk__memory_writes__eu_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__memory_writes__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Writes Distribution Gen9 :: GtiMemoryWrites */
static uint64_t
glk__memory_writes__gti_memory_writes__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 0];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GS Threads Dispatched */
static uint64_t
glk__memory_writes__gs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiRingAccesses */
static uint64_t
glk__memory_writes__gti_ring_accesses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
glk__memory_writes__hi_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: VS Threads Dispatched */
static uint64_t
glk__memory_writes__vs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: FS Threads Dispatched */
static uint64_t
glk__memory_writes__ps_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiMscMemoryWrites */
static uint64_t
glk__memory_writes__gti_msc_memory_writes__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Shader Barrier Messages */
static uint64_t
glk__memory_writes__shader_barriers__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiCmdStreamerMemoryWrites */
static uint64_t
glk__memory_writes__gti_cmd_streamer_memory_writes__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Sampler Texels */
static uint64_t
glk__memory_writes__sampler_texels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Pixels Failing Tests */
static uint64_t
glk__memory_writes__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank0Writes */
static uint64_t
glk__memory_writes__gti_l3_bank0_writes__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank1Writes */
static uint64_t
glk__memory_writes__gti_l3_bank1_writes__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 5 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 5];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank2Writes */
static uint64_t
glk__memory_writes__gti_l3_bank2_writes__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 6 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 6];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank3Writes */
static uint64_t
glk__memory_writes__gti_l3_bank3_writes__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Writes */
static uint64_t
glk__memory_writes__gti_l3_writes__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: $GtiL3Bank0Writes $GtiL3Bank1Writes $GtiL3Bank2Writes $GtiL3Bank3Writes UADD UADD UADD */
   uint64_t tmp0 = glk__memory_writes__gti_l3_bank2_writes__read(brw, query, accumulator) + glk__memory_writes__gti_l3_bank3_writes__read(brw, query, accumulator);
   uint64_t tmp1 = glk__memory_writes__gti_l3_bank1_writes__read(brw, query, accumulator) + tmp0;
   uint64_t tmp2 = glk__memory_writes__gti_l3_bank0_writes__read(brw, query, accumulator) + tmp1;

   return tmp2;
}

/* Memory Writes Distribution Gen9 :: GPU Time Elapsed */
static uint64_t
glk__memory_writes__gpu_time__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Writes Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__memory_writes__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__memory_writes__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__memory_writes__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Memory Writes Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__memory_writes__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Memory Writes Distribution Gen9 :: Sampler Texels Misses */
static uint64_t
glk__memory_writes__sampler_texel_misses__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: CS Threads Dispatched */
static uint64_t
glk__memory_writes__cs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: SLM Bytes Read */
static uint64_t
glk__memory_writes__slm_bytes_read__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: GtiRccMemoryWrites */
static uint64_t
glk__memory_writes__gti_rcc_memory_writes__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiSoMemoryWrites */
static uint64_t
glk__memory_writes__gti_so_memory_writes__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GPU Busy */
static float
glk__memory_writes__gpu_busy__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__memory_writes__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Writes Distribution Gen9 :: GtiStcMemoryWrites */
static uint64_t
glk__memory_writes__gti_stc_memory_writes__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Rasterized Pixels */
static uint64_t
glk__memory_writes__rasterized_pixels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: DS Threads Dispatched */
static uint64_t
glk__memory_writes__ds_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Samples Written */
static uint64_t
glk__memory_writes__samples_written__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: EU Stall */
static float
glk__memory_writes__eu_stall__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__memory_writes__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Writes Distribution Gen9 :: Samples Blended */
static uint64_t
glk__memory_writes__samples_blended__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Early Depth Test Fails */
static uint64_t
glk__memory_writes__early_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Shader Memory Accesses */
static uint64_t
glk__memory_writes__shader_memory_accesses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: HS Threads Dispatched */
static uint64_t
glk__memory_writes__hs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiRczMemoryWrites */
static uint64_t
glk__memory_writes__gti_rcz_memory_writes__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: SLM Bytes Written */
static uint64_t
glk__memory_writes__slm_bytes_written__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: L3 Shader Throughput */
static uint64_t
glk__memory_writes__l3_shader_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__memory_writes__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Memory Writes Distribution Gen9 :: Samples Killed in FS */
static uint64_t
glk__memory_writes__samples_killed_in_ps__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: GtiHizMemoryWrites */
static uint64_t
glk__memory_writes__gti_hiz_memory_writes__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__memory_writes__shader_atomics__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_memory_writes_mux_regs[44];
static struct brw_perf_query_register_prog glk_memory_writes_b_counter_regs[32];
static struct brw_perf_query_register_prog glk_memory_writes_flex_regs[7];

static struct brw_perf_query_counter glk_memory_writes_query_counters[41];
static struct brw_perf_query_info glk_memory_writes_query = {
   .kind = OA_COUNTERS,
   .name = "Memory Writes Distribution Gen9",
   .guid = "5299be9d-7a61-4c99-9f81-f87e6c5aaca9",
   .counters = glk_memory_writes_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_memory_writes_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_memory_writes_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_memory_writes_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_memory_writes_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_memory_writes_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19800343 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x39900340 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x3F900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x41900080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03803180 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x058035E2 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0780006A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11800000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2181A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2381000A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D950550 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B928000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D92A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F922000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13900180 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21900181 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23900182 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25900183 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x27900184 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x29900185 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B900186 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D900187 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F900170 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31900125 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15900123 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17900121 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x35900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47901080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900004 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000272C, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002728, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000271C, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002718, .val = 0xFFFFFFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000274C, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002748, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00006667 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000275C, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002758, .val = 0x86543210 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002754, .val = 0x00006465 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002750, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x0007F81A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x0007F82A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x0007F822 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x0007F8BA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x0007F87A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x0007F8EA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A0, .val = 0x0007F8E2 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A4, .val = 0x0000FE00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A8, .val = 0x0007F8F2 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027AC, .val = 0x0000FE00 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00025024 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00035034 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00045044 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00055054 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00065064 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__memory_writes__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_memory_writes__read;
      counter->name = "GtiMemoryWrites";
      counter->desc = "The total number of GTI memory writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_ring_accesses__read;
      counter->name = "GtiRingAccesses";
      counter->desc = "The total number of all GTI accesses to the ring.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_msc_memory_writes__read;
      counter->name = "GtiMscMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Multisampling Color Cache (Multisampling Color Cache invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_cmd_streamer_memory_writes__read;
      counter->name = "GtiCmdStreamerMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Command Streamer.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_l3_bank0_writes__read;
      counter->name = "GtiL3Bank0Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 0 (L3 Bank 0 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_l3_bank1_writes__read;
      counter->name = "GtiL3Bank1Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 1 (L3 Bank 1 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_l3_bank2_writes__read;
      counter->name = "GtiL3Bank2Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 2 (L3 Bank 2 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_l3_bank3_writes__read;
      counter->name = "GtiL3Bank3Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 3 (L3 Bank 3 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_l3_writes__read;
      counter->name = "GtiL3Writes";
      counter->desc = "The total number of GTI memory writes from L3 (L3 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__memory_writes__avg_gpu_core_frequency__max(brw);
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_rcc_memory_writes__read;
      counter->name = "GtiRccMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Render Color Cache (Render Color Cache invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_so_memory_writes__read;
      counter->name = "GtiSoMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Stream Output.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__memory_writes__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_stc_memory_writes__read;
      counter->name = "GtiStcMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Stencil Cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__memory_writes__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 240;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_rcz_memory_writes__read;
      counter->name = "GtiRczMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Render Depth Cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__gti_hiz_memory_writes__read;
      counter->name = "GtiHizMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Hierarchical Depth Cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__memory_writes__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Extended Gen9 :: GPU Core Clocks */
static uint64_t
glk__compute_extended__gpu_core_clocks__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EU Active */
static float
glk__compute_extended__eu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU Both FPU Pipes Active */
static float
glk__compute_extended__eu_fpu_both_active__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU FPU0 Pipe Active */
static float
glk__compute_extended__fpu0_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU FPU1 Pipe Active */
static float
glk__compute_extended__fpu1_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU AVG IPC Rate */
static float
glk__compute_extended__eu_avg_ipc_rate__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics Extended Gen9 :: Typed Writes 0 */
static uint64_t
glk__compute_extended__typed_writes0__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuTypedAtomics0 */
static uint64_t
glk__compute_extended__eu_typed_atomics0__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Typed Atomics 0 */
static uint64_t
glk__compute_extended__typed_atomics0__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: TypedAtomicsPerCacheLine */
static float
glk__compute_extended__typed_atomics_per_cache_line__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: $EuTypedAtomics0 $TypedAtomics0 FDIV */
   double tmp0 = glk__compute_extended__eu_typed_atomics0__read(brw, query, accumulator);
   double tmp1 = glk__compute_extended__typed_atomics0__read(brw, query, accumulator);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended Gen9 :: EuUntypedReads0 */
static uint64_t
glk__compute_extended__eu_untyped_reads0__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Untyped Writes 0 */
static uint64_t
glk__compute_extended__untyped_writes0__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 1 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 1];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuUntypedAtomics0 */
static uint64_t
glk__compute_extended__eu_untyped_atomics0__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuUntypedWrites0 */
static uint64_t
glk__compute_extended__eu_untyped_writes0__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuA64UntypedWrites0 */
static uint64_t
glk__compute_extended__eu_a64_untyped_writes0__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: UntypedWritesPerCacheLine */
static float
glk__compute_extended__untyped_writes_per_cache_line__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: $EuUntypedWrites0 $EuA64UntypedWrites0 UADD $UntypedWrites0 FDIV */
   uint64_t tmp0 = glk__compute_extended__eu_untyped_writes0__read(brw, query, accumulator) + glk__compute_extended__eu_a64_untyped_writes0__read(brw, query, accumulator);
   double tmp1 = tmp0;
   double tmp2 = glk__compute_extended__untyped_writes0__read(brw, query, accumulator);
   double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended Gen9 :: Shader Barrier Messages */
static uint64_t
glk__compute_extended__shader_barriers__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Sampler Texels */
static uint64_t
glk__compute_extended__sampler_texels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: GPU Time Elapsed */
static uint64_t
glk__compute_extended__gpu_time__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Extended Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_extended__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__compute_extended__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_extended__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Extended Gen9 :: Sampler Texels Misses */
static uint64_t
glk__compute_extended__sampler_texel_misses__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: CS Threads Dispatched */
static uint64_t
glk__compute_extended__cs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: SLM Bytes Read */
static uint64_t
glk__compute_extended__slm_bytes_read__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: EuTypedWrites0 */
static uint64_t
glk__compute_extended__eu_typed_writes0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: TypedWritesPerCacheLine */
static float
glk__compute_extended__typed_writes_per_cache_line__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: $EuTypedWrites0 $TypedWrites0 FDIV */
   double tmp0 = glk__compute_extended__eu_typed_writes0__read(brw, query, accumulator);
   double tmp1 = glk__compute_extended__typed_writes0__read(brw, query, accumulator);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended Gen9 :: Typed Reads 0 */
static uint64_t
glk__compute_extended__typed_reads0__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: C 2 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 2];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Untyped Reads 0 */
static uint64_t
glk__compute_extended__untyped_reads0__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 3 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 3];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuA64UntypedReads0 */
static uint64_t
glk__compute_extended__eu_a64_untyped_reads0__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EU Thread Occupancy */
static float
glk__compute_extended__eu_thread_occupancy__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0 * 8;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = brw->perfquery.sys_vars.eu_threads_count;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Compute Metrics Extended Gen9 :: EU Stall */
static float
glk__compute_extended__eu_stall__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EuTypedReads0 */
static uint64_t
glk__compute_extended__eu_typed_reads0__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: UntypedReadsPerCacheLine */
static float
glk__compute_extended__untyped_reads_per_cache_line__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: $EuUntypedReads0 $EuA64UntypedReads0 UADD $UntypedReads0 FDIV */
   uint64_t tmp0 = glk__compute_extended__eu_untyped_reads0__read(brw, query, accumulator) + glk__compute_extended__eu_a64_untyped_reads0__read(brw, query, accumulator);
   double tmp1 = tmp0;
   double tmp2 = glk__compute_extended__untyped_reads0__read(brw, query, accumulator);
   double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended Gen9 :: Shader Memory Accesses */
static uint64_t
glk__compute_extended__shader_memory_accesses__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: TypedReadsPerCacheLine */
static float
glk__compute_extended__typed_reads_per_cache_line__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: $EuTypedReads0 $TypedReads0 FDIV */
   double tmp0 = glk__compute_extended__eu_typed_reads0__read(brw, query, accumulator);
   double tmp1 = glk__compute_extended__typed_reads0__read(brw, query, accumulator);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended Gen9 :: SLM Bytes Written */
static uint64_t
glk__compute_extended__slm_bytes_written__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: L3 Shader Throughput */
static uint64_t
glk__compute_extended__l3_shader_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__compute_extended__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Compute Metrics Extended Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__compute_extended__shader_atomics__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EU Send Pipe Active */
static float
glk__compute_extended__eu_send_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_register_prog glk_compute_extended_mux_regs[93];
static struct brw_perf_query_register_prog glk_compute_extended_b_counter_regs[21];
static struct brw_perf_query_register_prog glk_compute_extended_flex_regs[7];

static struct brw_perf_query_counter glk_compute_extended_query_counters[38];
static struct brw_perf_query_info glk_compute_extended_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Extended Gen9",
   .guid = "bc9bcff2-459a-4cbc-986d-a84b077153f3",
   .counters = glk_compute_extended_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_compute_extended_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_compute_extended_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_compute_extended_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_compute_extended_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_compute_extended_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x104F00E0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x141C0160 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x161C0015 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x181C0120 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x082D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E5400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E5515 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102E0155 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x104C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x124C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x144C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x164C2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4F4B41 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004F4200 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024F404C };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C4F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A4F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x001B4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x061B8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x081BC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A1BC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C1BC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x041BC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x001C0031 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x061C1900 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x081C1A33 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A1C1B35 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C1C3337 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x041C31C7 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0FA8AA };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F0AAA };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x182C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C2C6AAA };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E2C0001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C2950 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1993AAAA };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x27904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x29904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900420 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900001 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x0007FC2A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x0007FC6A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x0007FC92 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x0007FCA2 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x0007FC32 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x0007FC9A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A0, .val = 0x0007FE6A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A4, .val = 0x0000BF00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A8, .val = 0x0007FE7A };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027AC, .val = 0x0000BF00 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00000003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00002001 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00778008 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00088078 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00808708 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00A08908 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__typed_writes0__read;
      counter->name = "Typed Writes 0";
      counter->desc = "The subslice 0 typed writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_typed_atomics0__read;
      counter->name = "EuTypedAtomics0";
      counter->desc = "The subslice 0 EU Typed Atomics subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__typed_atomics0__read;
      counter->name = "Typed Atomics 0";
      counter->desc = "The subslice 0 typed atomics.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__typed_atomics_per_cache_line__read;
      counter->name = "TypedAtomicsPerCacheLine";
      counter->desc = "The ratio of EU typed atomics requests to L3 cache line writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_untyped_reads0__read;
      counter->name = "EuUntypedReads0";
      counter->desc = "The subslice 0 EU Untyped Reads subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__untyped_writes0__read;
      counter->name = "Untyped Writes 0";
      counter->desc = "The subslice 0 untyped writes (including SLM writes).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_untyped_atomics0__read;
      counter->name = "EuUntypedAtomics0";
      counter->desc = "The subslice 0 EU Untyped Atomics subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_untyped_writes0__read;
      counter->name = "EuUntypedWrites0";
      counter->desc = "The subslice 0 EU Untyped Writes subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_a64_untyped_writes0__read;
      counter->name = "EuA64UntypedWrites0";
      counter->desc = "The subslice 0 EU A64 Untyped Writes subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__untyped_writes_per_cache_line__read;
      counter->name = "UntypedWritesPerCacheLine";
      counter->desc = "The ratio of EU untyped write requests to L3 cache line writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__compute_extended__avg_gpu_core_frequency__max(brw);
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_typed_writes0__read;
      counter->name = "EuTypedWrites0";
      counter->desc = "The subslice 0 EU Typed Writes subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__typed_writes_per_cache_line__read;
      counter->name = "TypedWritesPerCacheLine";
      counter->desc = "The ratio of EU typed write requests to L3 cache line writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__typed_reads0__read;
      counter->name = "Typed Reads 0";
      counter->desc = "The subslice 0 typed reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__untyped_reads0__read;
      counter->name = "Untyped Reads 0";
      counter->desc = "The subslice 0 untyped reads (including SLM reads).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_a64_untyped_reads0__read;
      counter->name = "EuA64UntypedReads0";
      counter->desc = "The subslice 0 EU A64 Untyped Reads subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__eu_thread_occupancy__read;
      counter->name = "EU Thread Occupancy";
      counter->desc = "The percentage of time in which hardware threads occupied EUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 208;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 212;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__eu_typed_reads0__read;
      counter->name = "EuTypedReads0";
      counter->desc = "The subslice 0 EU Typed Reads subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__untyped_reads_per_cache_line__read;
      counter->name = "UntypedReadsPerCacheLine";
      counter->desc = "The ratio of EU untyped read requests to L3 cache line reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__typed_reads_per_cache_line__read;
      counter->name = "TypedReadsPerCacheLine";
      counter->desc = "The ratio of EU typed read requests to L3 cache line reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extended__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extended__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 272;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics L3 Cache Gen9 :: GPU Core Clocks */
static uint64_t
glk__compute_l3_cache__gpu_core_clocks__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: EU Active */
static float
glk__compute_l3_cache__eu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 03 Accesses */
static uint64_t
glk__compute_l3_cache__l3_bank03_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Accesses */
static uint64_t
glk__compute_l3_cache__l3_accesses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: C 0 READ C 1 READ B 2 READ B 3 READ UADD UADD UADD 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = accumulator[query->c_offset + 1];
   uint64_t tmp2 = accumulator[query->b_offset + 2];
   uint64_t tmp3 = accumulator[query->b_offset + 3];
   uint64_t tmp4 = tmp2 + tmp3;
   uint64_t tmp5 = tmp1 + tmp4;
   uint64_t tmp6 = tmp0 + tmp5;
   uint64_t tmp7 = tmp6 * 2;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU Both FPU Pipes Active */
static float
glk__compute_l3_cache__eu_fpu_both_active__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Sampler Throughput */
static uint64_t
glk__compute_l3_cache__l3_sampler_throughput__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Pipe Active */
static float
glk__compute_l3_cache__fpu0_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Pipe Active */
static float
glk__compute_l3_cache__fpu1_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU AVG IPC Rate */
static float
glk__compute_l3_cache__eu_avg_ipc_rate__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Binary Instruction */
static float
glk__compute_l3_cache__eu_binary_fpu0_instruction__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: GS Threads Dispatched */
static uint64_t
glk__compute_l3_cache__gs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Shader Memory Accesses */
static uint64_t
glk__compute_l3_cache__shader_memory_accesses__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
glk__compute_l3_cache__hi_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: VS Threads Dispatched */
static uint64_t
glk__compute_l3_cache__vs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: FS Threads Dispatched */
static uint64_t
glk__compute_l3_cache__ps_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Hybrid Instruction */
static float
glk__compute_l3_cache__eu_hybrid_fpu0_instruction__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Misses */
static uint64_t
glk__compute_l3_cache__l3_misses__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: C 4 READ C 5 READ UADD */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Compute Metrics L3 Cache Gen9 :: Shader Barrier Messages */
static uint64_t
glk__compute_l3_cache__shader_barriers__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 00 Accesses */
static uint64_t
glk__compute_l3_cache__l3_bank00_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: C 0 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Move Instruction */
static float
glk__compute_l3_cache__eu_move_fpu0_instruction__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 19 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 19];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: Sampler Texels */
static uint64_t
glk__compute_l3_cache__sampler_texels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: Pixels Failing Tests */
static uint64_t
glk__compute_l3_cache__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Hybrid Instruction */
static float
glk__compute_l3_cache__eu_hybrid_fpu1_instruction__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 14 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 14];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: GPU Time Elapsed */
static uint64_t
glk__compute_l3_cache__gpu_time__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_l3_cache__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__compute_l3_cache__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics L3 Cache Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_l3_cache__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics L3 Cache Gen9 :: Sampler Texels Misses */
static uint64_t
glk__compute_l3_cache__sampler_texel_misses__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: CS Threads Dispatched */
static uint64_t
glk__compute_l3_cache__cs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: SLM Bytes Read */
static uint64_t
glk__compute_l3_cache__slm_bytes_read__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: GTI Read Throughput */
static uint64_t
glk__compute_l3_cache__gti_read_throughput__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: GTI L3 Throughput */
static uint64_t
glk__compute_l3_cache__gti_l3_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 4 READ C 5 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 00 IC Accesses */
static uint64_t
glk__compute_l3_cache__l3_bank00_ic_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 0 READ B 1 READ UADD 2 UMUL $L3Bank00Accesses UMIN */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 2;
   uint64_t tmp4 = MIN(tmp3, glk__compute_l3_cache__l3_bank00_accesses__read(brw, query, accumulator));

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 00 IC Hits */
static uint64_t
glk__compute_l3_cache__l3_bank00_ic_hits__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 2 UMUL $L3Bank00IcAccesses UMIN */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 2;
   uint64_t tmp2 = MIN(tmp1, glk__compute_l3_cache__l3_bank00_ic_accesses__read(brw, query, accumulator));

   return tmp2;
}

/* Compute Metrics L3 Cache Gen9 :: Sampler Accesses */
static uint64_t
glk__compute_l3_cache__sampler_accesses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 28 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 28];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 01 Accesses */
static uint64_t
glk__compute_l3_cache__l3_bank01_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: C 1 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: GPU Busy */
static float
glk__compute_l3_cache__gpu_busy__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Ternary Instruction */
static float
glk__compute_l3_cache__eu_ternary_fpu0_instruction__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
glk__compute_l3_cache__shader_atomics__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Rasterized Pixels */
static uint64_t
glk__compute_l3_cache__rasterized_pixels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: DS Threads Dispatched */
static uint64_t
glk__compute_l3_cache__ds_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Samples Written */
static uint64_t
glk__compute_l3_cache__samples_written__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Move Instruction */
static float
glk__compute_l3_cache__eu_move_fpu1_instruction__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 20 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 20];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU Stall */
static float
glk__compute_l3_cache__eu_stall__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: Samples Blended */
static uint64_t
glk__compute_l3_cache__samples_blended__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: Early Depth Test Fails */
static uint64_t
glk__compute_l3_cache__early_depth_test_fails__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 02 Accesses */
static uint64_t
glk__compute_l3_cache__l3_bank02_accesses__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: HS Threads Dispatched */
static uint64_t
glk__compute_l3_cache__hs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Total Throughput */
static uint64_t
glk__compute_l3_cache__l3_total_throughput__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: $L3Accesses 64 UMUL */
   uint64_t tmp0 = glk__compute_l3_cache__l3_accesses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: GTI Write Throughput */
static uint64_t
glk__compute_l3_cache__gti_write_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: SLM Bytes Written */
static uint64_t
glk__compute_l3_cache__slm_bytes_written__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Shader Throughput */
static uint64_t
glk__compute_l3_cache__l3_shader_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__compute_l3_cache__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: Samples Killed in FS */
static uint64_t
glk__compute_l3_cache__samples_killed_in_ps__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Binary Instruction */
static float
glk__compute_l3_cache__eu_binary_fpu1_instruction__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Ternary Instruction */
static float
glk__compute_l3_cache__eu_ternary_fpu1_instruction__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU Send Pipe Active */
static float
glk__compute_l3_cache__eu_send_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_register_prog glk_compute_l3_cache_mux_regs[68];
static struct brw_perf_query_register_prog glk_compute_l3_cache_b_counter_regs[13];
static struct brw_perf_query_register_prog glk_compute_l3_cache_flex_regs[7];

static struct brw_perf_query_counter glk_compute_l3_cache_query_counters[54];
static struct brw_perf_query_info glk_compute_l3_cache_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics L3 Cache Gen9",
   .guid = "88ec931f-5b4a-453a-9db6-a61232b6143d",
   .counters = glk_compute_l3_cache_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_compute_l3_cache_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_compute_l3_cache_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_compute_l3_cache_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_compute_l3_cache_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_compute_l3_cache_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x166C03B0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1593001E };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x3F900C00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x41900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x082D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E0400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E1500 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102E0140 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x144C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x164C2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A4F4001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C4F5005 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x006C0051 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x066C5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x086C5C5D };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E6C5E5F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x106C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x146C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A6C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C6C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0FA800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F0A00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x182C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C2C4015 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E2C0001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03931980 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05930032 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11930000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x01938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1993A00A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07930000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09930000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D900177 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F900178 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x35900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x21904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53901000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900111 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x57900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x49900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900400 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x30800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x30800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x0007FFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000FEFE };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x0007FFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000FEFD };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x0007FFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000FBEF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x0007FFFA };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000FBDF };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00000003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00002001 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00101100 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00201200 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00301300 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00401400 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_bank03_accesses__read;
         counter->name = "L3 Bank 03 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 03.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 16;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_accesses__read;
      counter->name = "L3 Accesses";
      counter->desc = "The total number of L3 accesses from all entities.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_sampler_throughput__read;
      counter->name = "L3 Sampler Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 52;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_binary_fpu0_instruction__read;
      counter->name = "EU FPU0 Binary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing binary instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 60;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_hybrid_fpu0_instruction__read;
      counter->name = "EU FPU0 Hybrid Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 104;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_misses__read;
      counter->name = "L3 Misses";
      counter->desc = "The total number of L3 misses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_bank00_accesses__read;
         counter->name = "L3 Bank 00 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 00.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 128;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_move_fpu0_instruction__read;
      counter->name = "EU FPU0 Move Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing move instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_hybrid_fpu1_instruction__read;
      counter->name = "EU FPU1 Hybrid Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__compute_l3_cache__avg_gpu_core_frequency__max(brw);
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__gti_l3_throughput__read;
      counter->name = "GTI L3 Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_bank00_ic_accesses__read;
         counter->name = "L3 Bank 00 IC Accesses";
         counter->desc = "The total number of accesses to L3 Bank 00 from IC cache.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 224;
         counter->size = sizeof(uint64_t);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_bank00_ic_hits__read;
         counter->name = "L3 Bank 00 IC Hits";
         counter->desc = "The total number of hits in L3 Bank 00 from IC cache.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 232;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__sampler_accesses__read;
      counter->name = "Sampler Accesses";
      counter->desc = "The total number of messages send to samplers.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_bank01_accesses__read;
         counter->name = "L3 Bank 01 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 01.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 248;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 256;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_ternary_fpu0_instruction__read;
      counter->name = "EU FPU0 Ternary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 260;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_move_fpu1_instruction__read;
      counter->name = "EU FPU1 Move Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing move instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 296;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 300;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_bank02_accesses__read;
         counter->name = "L3 Bank 02 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 02.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 320;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 328;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_total_throughput__read;
      counter->name = "L3 Total Throughput";
      counter->desc = "The total number of GPU memory bytes transferred via L3.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 336;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 344;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 352;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 360;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_l3_cache__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 368;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_binary_fpu1_instruction__read;
      counter->name = "EU FPU1 Binary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing binary instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 376;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_ternary_fpu1_instruction__read;
      counter->name = "EU FPU1 Ternary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 380;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_l3_cache__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 384;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set HDCAndSF :: GPU Core Clocks */
static uint64_t
glk__hdc_and_sf__gpu_core_clocks__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set HDCAndSF :: EU Active */
static float
glk__hdc_and_sf__eu_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
static float
glk__hdc_and_sf__eu_fpu_both_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS Send Pipe Active */
static float
glk__hdc_and_sf__vs_send_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
static float
glk__hdc_and_sf__vs_fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: GS Threads Dispatched */
static uint64_t
glk__hdc_and_sf__gs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
static uint64_t
glk__hdc_and_sf__hi_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: FS Both FPU Active */
static float
glk__hdc_and_sf__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS Threads Dispatched */
static uint64_t
glk__hdc_and_sf__vs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set HDCAndSF :: Polygon Data Ready */
static float
glk__hdc_and_sf__poly_data_ready__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: FS Threads Dispatched */
static uint64_t
glk__hdc_and_sf__ps_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set HDCAndSF :: Shader Barrier Messages */
static uint64_t
glk__hdc_and_sf__shader_barriers__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set HDCAndSF :: Sampler Texels */
static uint64_t
glk__hdc_and_sf__sampler_texels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Pixels Failing Tests */
static uint64_t
glk__hdc_and_sf__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: GPU Time Elapsed */
static uint64_t
glk__hdc_and_sf__gpu_time__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
static uint64_t
glk__hdc_and_sf__avg_gpu_core_frequency__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__hdc_and_sf__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
static uint64_t
glk__hdc_and_sf__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set HDCAndSF :: Sampler Texels Misses */
static uint64_t
glk__hdc_and_sf__sampler_texel_misses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
static float
glk__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 5 READ C 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = accumulator[query->c_offset + 4];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: CS Threads Dispatched */
static uint64_t
glk__hdc_and_sf__cs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set HDCAndSF :: SLM Bytes Read */
static uint64_t
glk__hdc_and_sf__slm_bytes_read__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
static float
glk__hdc_and_sf__ps_fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: PS Send Pipeline Active */
static float
glk__hdc_and_sf__ps_send_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
static float
glk__hdc_and_sf__vs_fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: GPU Busy */
static float
glk__hdc_and_sf__gpu_busy__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: Rasterized Pixels */
static uint64_t
glk__hdc_and_sf__rasterized_pixels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
static float
glk__hdc_and_sf__ps_fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: DS Threads Dispatched */
static uint64_t
glk__hdc_and_sf__ds_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set HDCAndSF :: Samples Written */
static uint64_t
glk__hdc_and_sf__samples_written__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: EU Stall */
static float
glk__hdc_and_sf__eu_stall__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: Samples Blended */
static uint64_t
glk__hdc_and_sf__samples_blended__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Early Depth Test Fails */
static uint64_t
glk__hdc_and_sf__early_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Shader Memory Accesses */
static uint64_t
glk__hdc_and_sf__shader_memory_accesses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set HDCAndSF :: HS Threads Dispatched */
static uint64_t
glk__hdc_and_sf__hs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set HDCAndSF :: SLM Bytes Written */
static uint64_t
glk__hdc_and_sf__slm_bytes_written__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set HDCAndSF :: L3 Shader Throughput */
static uint64_t
glk__hdc_and_sf__l3_shader_throughput__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__hdc_and_sf__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set HDCAndSF :: Samples Killed in FS */
static uint64_t
glk__hdc_and_sf__samples_killed_in_ps__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
static float
glk__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ C 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = accumulator[query->c_offset + 6];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = glk__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
static uint64_t
glk__hdc_and_sf__shader_atomics__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_hdc_and_sf_mux_regs[42];
static struct brw_perf_query_register_prog glk_hdc_and_sf_b_counter_regs[8];
static struct brw_perf_query_register_prog glk_hdc_and_sf_flex_regs[7];

static struct brw_perf_query_counter glk_hdc_and_sf_query_counters[38];
static struct brw_perf_query_info glk_hdc_and_sf_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set HDCAndSF",
   .guid = "530d176d-2a18-4014-adf8-1500c6c60835",
   .counters = glk_hdc_and_sf_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_hdc_and_sf_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_hdc_and_sf_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_hdc_and_sf_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_hdc_and_sf_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_hdc_and_sf_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x104F0232 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x124F4640 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11834400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0055 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024F6100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044F416B };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064F004B };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A4F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F02A8 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C5500 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F808000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x25810020 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F8305C0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F951000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x13920200 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900003 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x10800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x00000002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000FDFF };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__poly_data_ready__read;
      counter->name = "Polygon Data Ready";
      counter->desc = "The percentage of time in which geometry pipeline output is ready";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__hdc_and_sf__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss1)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss1)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 120;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__hdc_and_sf__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss0)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss0)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 256;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__hdc_and_sf__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_1 :: GPU Core Clocks */
static uint64_t
glk__l3_1__gpu_core_clocks__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_1 :: EU Active */
static float
glk__l3_1__eu_active__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
static float
glk__l3_1__l30_bank1_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: EU Both FPU Pipes Active */
static float
glk__l3_1__eu_fpu_both_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS Send Pipe Active */
static float
glk__l3_1__vs_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS FPU1 Pipe Active */
static float
glk__l3_1__vs_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: GS Threads Dispatched */
static uint64_t
glk__l3_1__gs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
static uint64_t
glk__l3_1__hi_depth_test_fails__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: FS Both FPU Active */
static float
glk__l3_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS Threads Dispatched */
static uint64_t
glk__l3_1__vs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
static float
glk__l3_1__l30_bank1_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: FS Threads Dispatched */
static uint64_t
glk__l3_1__ps_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_1 :: Shader Barrier Messages */
static uint64_t
glk__l3_1__shader_barriers__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_1 :: Sampler Texels */
static uint64_t
glk__l3_1__sampler_texels__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Pixels Failing Tests */
static uint64_t
glk__l3_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: GPU Time Elapsed */
static uint64_t
glk__l3_1__gpu_time__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: AVG GPU Core Frequency */
static uint64_t
glk__l3_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__l3_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_1 :: AVG GPU Core Frequency */
static uint64_t
glk__l3_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_1 :: Sampler Texels Misses */
static uint64_t
glk__l3_1__sampler_texel_misses__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: CS Threads Dispatched */
static uint64_t
glk__l3_1__cs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_1 :: SLM Bytes Read */
static uint64_t
glk__l3_1__slm_bytes_read__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_1 :: PS FPU1 Pipe Active */
static float
glk__l3_1__ps_fpu1_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: PS Send Pipeline Active */
static float
glk__l3_1__ps_send_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS FPU0 Pipe Active */
static float
glk__l3_1__vs_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: GPU Busy */
static float
glk__l3_1__gpu_busy__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
static float
glk__l3_1__l30_bank0_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Rasterized Pixels */
static uint64_t
glk__l3_1__rasterized_pixels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: PS FPU0 Pipe Active */
static float
glk__l3_1__ps_fpu0_active__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
static float
glk__l3_1__l30_bank0_stalled__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: DS Threads Dispatched */
static uint64_t
glk__l3_1__ds_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_1 :: Samples Written */
static uint64_t
glk__l3_1__samples_written__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: EU Stall */
static float
glk__l3_1__eu_stall__read(struct brw_context *brw,
                          const struct brw_perf_query_info *query,
                          uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Samples Blended */
static uint64_t
glk__l3_1__samples_blended__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Early Depth Test Fails */
static uint64_t
glk__l3_1__early_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Shader Memory Accesses */
static uint64_t
glk__l3_1__shader_memory_accesses__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_1 :: HS Threads Dispatched */
static uint64_t
glk__l3_1__hs_threads__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_1 :: SLM Bytes Written */
static uint64_t
glk__l3_1__slm_bytes_written__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_1 :: L3 Shader Throughput */
static uint64_t
glk__l3_1__l3_shader_throughput__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__l3_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_1 :: Samples Killed in FS */
static uint64_t
glk__l3_1__samples_killed_in_ps__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
static uint64_t
glk__l3_1__shader_atomics__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_l3_1_mux_regs[77];
static struct brw_perf_query_register_prog glk_l3_1_b_counter_regs[22];
static struct brw_perf_query_register_prog glk_l3_1_flex_regs[7];

static struct brw_perf_query_counter glk_l3_1_query_counters[39];
static struct brw_perf_query_info glk_l3_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_1",
   .guid = "fdee5a5a-f23c-43d1-aa73-f6257c71671d",
   .counters = glk_l3_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_l3_1_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_l3_1_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_l3_1_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_l3_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_l3_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x12643400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x12653400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x106C6800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x126C001E };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x166C0010 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102E0154 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0055 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x104C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x124C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x144C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x164C2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C4F5500 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A4F1554 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A640024 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x10640000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04640000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C650024 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x10650000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06650000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C6C5327 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E6C5425 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x006C2A00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x026C285B };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x046C005C };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C6C0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A6C0900 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F0AA0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F02AA };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C2C5400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E2C0001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C5550 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1993AA00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900421 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900420 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900021 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x00100070 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000FFF1 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x00014002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000C3FF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x00010002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000C7FF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x00004002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000D3FF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x00100700 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000FF1F };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x00001402 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000FC3F };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A0, .val = 0x00001002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A4, .val = 0x0000FC7F };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A8, .val = 0x00000402 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027AC, .val = 0x0000FD3F };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__l3_1__l30_bank1_active__read;
         counter->name = "Slice0 L3 Bank1 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank1 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__l3_1__l30_bank1_stalled__read;
         counter->name = "Slice0 L3 Bank1 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank1 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__l3_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__l3_1__l30_bank0_active__read;
         counter->name = "Slice0 L3 Bank0 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank0 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__l3_1__l30_bank0_stalled__read;
         counter->name = "Slice0 L3 Bank0 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank0 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 180;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__l3_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__l3_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
static uint64_t
glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: EU Active */
static float
glk__rasterizer_and_pixel_backend__eu_active__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
static float
glk__rasterizer_and_pixel_backend__eu_fpu_both_active__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
static float
glk__rasterizer_and_pixel_backend__vs_send_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
static float
glk__rasterizer_and_pixel_backend__vs_fpu1_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
static uint64_t
glk__rasterizer_and_pixel_backend__gs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
static uint64_t
glk__rasterizer_and_pixel_backend__hi_depth_test_fails__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
static float
glk__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                                               const struct brw_perf_query_info *query,
                                                               uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
static uint64_t
glk__rasterizer_and_pixel_backend__vs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
static uint64_t
glk__rasterizer_and_pixel_backend__ps_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
static float
glk__rasterizer_and_pixel_backend__pixel_values0_ready__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
static uint64_t
glk__rasterizer_and_pixel_backend__shader_barriers__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
static uint64_t
glk__rasterizer_and_pixel_backend__sampler_texels__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
static uint64_t
glk__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                                      const struct brw_perf_query_info *query,
                                                                      uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
static uint64_t
glk__rasterizer_and_pixel_backend__gpu_time__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
static uint64_t
glk__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__rasterizer_and_pixel_backend__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
static uint64_t
glk__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
static uint64_t
glk__rasterizer_and_pixel_backend__sampler_texel_misses__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
static uint64_t
glk__rasterizer_and_pixel_backend__cs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
static float
glk__rasterizer_and_pixel_backend__rasterizer0_input_available__read(struct brw_context *brw,
                                                                     const struct brw_perf_query_info *query,
                                                                     uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
static float
glk__rasterizer_and_pixel_backend__pixel_data0_ready__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
static uint64_t
glk__rasterizer_and_pixel_backend__slm_bytes_read__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
static float
glk__rasterizer_and_pixel_backend__ps_fpu1_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
static float
glk__rasterizer_and_pixel_backend__ps_send_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
static float
glk__rasterizer_and_pixel_backend__vs_fpu0_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
static float
glk__rasterizer_and_pixel_backend__gpu_busy__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
static uint64_t
glk__rasterizer_and_pixel_backend__rasterized_pixels__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
static float
glk__rasterizer_and_pixel_backend__ps_fpu0_active__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
static uint64_t
glk__rasterizer_and_pixel_backend__ds_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Samples Written */
static uint64_t
glk__rasterizer_and_pixel_backend__samples_written__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: EU Stall */
static float
glk__rasterizer_and_pixel_backend__eu_stall__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
static float
glk__rasterizer_and_pixel_backend__rasterizer0_output_ready__read(struct brw_context *brw,
                                                                  const struct brw_perf_query_info *query,
                                                                  uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
static uint64_t
glk__rasterizer_and_pixel_backend__samples_blended__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
static uint64_t
glk__rasterizer_and_pixel_backend__early_depth_test_fails__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
static uint64_t
glk__rasterizer_and_pixel_backend__shader_memory_accesses__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
static uint64_t
glk__rasterizer_and_pixel_backend__hs_threads__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
static uint64_t
glk__rasterizer_and_pixel_backend__slm_bytes_written__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
static uint64_t
glk__rasterizer_and_pixel_backend__l3_shader_throughput__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__rasterizer_and_pixel_backend__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
static uint64_t
glk__rasterizer_and_pixel_backend__samples_killed_in_ps__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
static float
glk__rasterizer_and_pixel_backend__ps_output0_available__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
static uint64_t
glk__rasterizer_and_pixel_backend__shader_atomics__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_rasterizer_and_pixel_backend_mux_regs[41];
static struct brw_perf_query_register_prog glk_rasterizer_and_pixel_backend_b_counter_regs[10];
static struct brw_perf_query_register_prog glk_rasterizer_and_pixel_backend_flex_regs[7];

static struct brw_perf_query_counter glk_rasterizer_and_pixel_backend_query_counters[40];
static struct brw_perf_query_info glk_rasterizer_and_pixel_backend_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set RasterizerAndPixelBackend",
   .guid = "6617623e-ca73-4791-b2b7-ddedd0846a0c",
   .counters = glk_rasterizer_and_pixel_backend_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_rasterizer_and_pixel_backend_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_rasterizer_and_pixel_backend_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_rasterizer_and_pixel_backend_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_rasterizer_and_pixel_backend_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_rasterizer_and_pixel_backend_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102D7800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x122D79E0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2F0004 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x100E3800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F0005 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D0940 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D802F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D4013 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0050 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022F0010 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x040E0480 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x000E0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x060F0027 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x100F0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F0040 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x439014A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x459000A4 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x30800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x00000002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000EFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x00006000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000F3FF };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__pixel_values0_ready__read;
         counter->name = "Slice0 Pixel Values Ready";
         counter->desc = "The percentage of time in which slice0 pixel values are ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__rasterizer0_input_available__read;
         counter->name = "Slice0 Rasterizer Input Available";
         counter->desc = "The percentage of time in which slice0 rasterizer input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 128;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__pixel_data0_ready__read;
         counter->name = "Slice0 Post-EarlyZ Pixel Data Ready";
         counter->desc = "The percentage of time in which slice0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 132;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__rasterizer0_output_ready__read;
         counter->name = "Slice0 Rasterizer Output Ready";
         counter->desc = "The percentage of time in which slice0 rasterizer output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 196;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__rasterizer_and_pixel_backend__ps_output0_available__read;
         counter->name = "Slice0 PS Output Available";
         counter->desc = "The percentage of time in which slice0 PS output is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 256;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__rasterizer_and_pixel_backend__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set Sampler :: GPU Core Clocks */
static uint64_t
glk__sampler__gpu_core_clocks__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set Sampler :: EU Active */
static float
glk__sampler__eu_active__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
static float
glk__sampler__sampler02_input_available__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: EU Both FPU Pipes Active */
static float
glk__sampler__eu_fpu_both_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: VS Send Pipe Active */
static float
glk__sampler__vs_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
static float
glk__sampler__sampler00_input_available__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: VS FPU1 Pipe Active */
static float
glk__sampler__vs_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: GS Threads Dispatched */
static uint64_t
glk__sampler__gs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set Sampler :: Early Hi-Depth Test Fails */
static uint64_t
glk__sampler__hi_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: FS Both FPU Active */
static float
glk__sampler__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: VS Threads Dispatched */
static uint64_t
glk__sampler__vs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
static float
glk__sampler__sampler02_output_ready__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: FS Threads Dispatched */
static uint64_t
glk__sampler__ps_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set Sampler :: Shader Barrier Messages */
static uint64_t
glk__sampler__shader_barriers__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
static float
glk__sampler__sampler01_input_available__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Sampler Texels */
static uint64_t
glk__sampler__sampler_texels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Pixels Failing Tests */
static uint64_t
glk__sampler__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: GPU Time Elapsed */
static uint64_t
glk__sampler__gpu_time__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: AVG GPU Core Frequency */
static uint64_t
glk__sampler__avg_gpu_core_frequency__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__sampler__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set Sampler :: AVG GPU Core Frequency */
static uint64_t
glk__sampler__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set Sampler :: Sampler Texels Misses */
static uint64_t
glk__sampler__sampler_texel_misses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: CS Threads Dispatched */
static uint64_t
glk__sampler__cs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set Sampler :: SLM Bytes Read */
static uint64_t
glk__sampler__slm_bytes_read__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler :: PS FPU1 Pipe Active */
static float
glk__sampler__ps_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: PS Send Pipeline Active */
static float
glk__sampler__ps_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: VS FPU0 Pipe Active */
static float
glk__sampler__vs_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: GPU Busy */
static float
glk__sampler__gpu_busy__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Rasterized Pixels */
static uint64_t
glk__sampler__rasterized_pixels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: PS FPU0 Pipe Active */
static float
glk__sampler__ps_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: DS Threads Dispatched */
static uint64_t
glk__sampler__ds_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set Sampler :: Samples Written */
static uint64_t
glk__sampler__samples_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: EU Stall */
static float
glk__sampler__eu_stall__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: Samples Blended */
static uint64_t
glk__sampler__samples_blended__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Early Depth Test Fails */
static uint64_t
glk__sampler__early_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
static float
glk__sampler__sampler00_output_ready__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
static float
glk__sampler__sampler01_output_ready__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Shader Memory Accesses */
static uint64_t
glk__sampler__shader_memory_accesses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set Sampler :: HS Threads Dispatched */
static uint64_t
glk__sampler__hs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set Sampler :: SLM Bytes Written */
static uint64_t
glk__sampler__slm_bytes_written__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler :: L3 Shader Throughput */
static uint64_t
glk__sampler__l3_shader_throughput__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__sampler__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set Sampler :: Samples Killed in FS */
static uint64_t
glk__sampler__samples_killed_in_ps__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Shader Atomic Memory Accesses */
static uint64_t
glk__sampler__shader_atomics__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_sampler_mux_regs[93];
static struct brw_perf_query_register_prog glk_sampler_b_counter_regs[12];
static struct brw_perf_query_register_prog glk_sampler_flex_regs[7];

static struct brw_perf_query_counter glk_sampler_query_counters[41];
static struct brw_perf_query_info glk_sampler_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set Sampler",
   .guid = "f3b2ea63-e82e-4234-b418-44dd20dd34d0",
   .counters = glk_sampler_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_sampler_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_sampler_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_sampler_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_sampler_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_sampler_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x121300A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x141600AB };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x123300A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x143600AB };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x125300A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x145600AB };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102E01A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0065 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x164C2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F0800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F023F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E2C0003 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2CC030 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04132180 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02130000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C148000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E142000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04148000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E150140 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C150040 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C163000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E160068 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x10160000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x18160000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A164000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04330043 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02330000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0234A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04342000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C350015 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02363460 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x10360000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04360000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06360000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08364000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06530043 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02530000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E548000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00548000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06542000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E550400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A552000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C550100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E563000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00563400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x10560000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x18560000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02560000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C564000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1993A800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B9014A0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900820 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45901022 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x70800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x0000C000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x0000E7FF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x00003000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x0000F9FF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x00000C00 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000FE7F };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__sampler__sampler02_input_available__read;
         counter->name = "Slice0 Subslice2 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice2 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__sampler__sampler00_input_available__read;
         counter->name = "Slice0 Subslice0 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice0 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 24;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 28;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__sampler__sampler02_output_ready__read;
         counter->name = "Slice0 Subslice2 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice2 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__sampler__sampler01_input_available__read;
         counter->name = "Slice0 Subslice1 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice1 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 88;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__sampler__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__sampler__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__sampler__sampler00_output_ready__read;
         counter->name = "Slice0 Subslice0 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice0 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 224;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__sampler__sampler01_output_ready__read;
         counter->name = "Slice0 Subslice1 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice1 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 228;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__sampler__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set TDL_1 :: GPU Core Clocks */
static uint64_t
glk__tdl_1__gpu_core_clocks__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set TDL_1 :: EU Active */
static float
glk__tdl_1__eu_active__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
static float
glk__tdl_1__eu_fpu_both_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS Send Pipe Active */
static float
glk__tdl_1__vs_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
static float
glk__tdl_1__vs_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: GS Threads Dispatched */
static uint64_t
glk__tdl_1__gs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
static uint64_t
glk__tdl_1__hi_depth_test_fails__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: FS Both FPU Active */
static float
glk__tdl_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS Threads Dispatched */
static uint64_t
glk__tdl_1__vs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set TDL_1 :: FS Threads Dispatched */
static uint64_t
glk__tdl_1__ps_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
static float
glk__tdl_1__non_ps_thread02_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Barrier Messages */
static uint64_t
glk__tdl_1__shader_barriers__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set TDL_1 :: Sampler Texels */
static uint64_t
glk__tdl_1__sampler_texels__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Pixels Failing Tests */
static uint64_t
glk__tdl_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: GPU Time Elapsed */
static uint64_t
glk__tdl_1__gpu_time__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: AVG GPU Core Frequency */
static uint64_t
glk__tdl_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__tdl_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set TDL_1 :: AVG GPU Core Frequency */
static uint64_t
glk__tdl_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set TDL_1 :: Sampler Texels Misses */
static uint64_t
glk__tdl_1__sampler_texel_misses__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
static float
glk__tdl_1__non_ps_thread00_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: CS Threads Dispatched */
static uint64_t
glk__tdl_1__cs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set TDL_1 :: SLM Bytes Read */
static uint64_t
glk__tdl_1__slm_bytes_read__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
static float
glk__tdl_1__ps_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: PS Send Pipeline Active */
static float
glk__tdl_1__ps_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
static float
glk__tdl_1__vs_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: GPU Busy */
static float
glk__tdl_1__gpu_busy__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 */
static float
glk__tdl_1__ps_thread00_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Rasterized Pixels */
static uint64_t
glk__tdl_1__rasterized_pixels__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
static float
glk__tdl_1__ps_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: DS Threads Dispatched */
static uint64_t
glk__tdl_1__ds_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set TDL_1 :: Samples Written */
static uint64_t
glk__tdl_1__samples_written__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: EU Stall */
static float
glk__tdl_1__eu_stall__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: Samples Blended */
static uint64_t
glk__tdl_1__samples_blended__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Early Depth Test Fails */
static uint64_t
glk__tdl_1__early_depth_test_fails__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 */
static float
glk__tdl_1__ps_thread01_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Memory Accesses */
static uint64_t
glk__tdl_1__shader_memory_accesses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set TDL_1 :: HS Threads Dispatched */
static uint64_t
glk__tdl_1__hs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 */
static float
glk__tdl_1__ps_thread02_ready_for_dispatch__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: SLM Bytes Written */
static uint64_t
glk__tdl_1__slm_bytes_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_1 :: L3 Shader Throughput */
static uint64_t
glk__tdl_1__l3_shader_throughput__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__tdl_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set TDL_1 :: Samples Killed in FS */
static uint64_t
glk__tdl_1__samples_killed_in_ps__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
static uint64_t
glk__tdl_1__shader_atomics__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
static float
glk__tdl_1__non_ps_thread01_ready_for_dispatch__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_register_prog glk_tdl_1_mux_regs[86];
static struct brw_perf_query_register_prog glk_tdl_1_b_counter_regs[18];
static struct brw_perf_query_register_prog glk_tdl_1_flex_regs[7];

static struct brw_perf_query_counter glk_tdl_1_query_counters[41];
static struct brw_perf_query_info glk_tdl_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set TDL_1",
   .guid = "14411d35-cbf6-4f5e-b68b-190faf9a1a83",
   .counters = glk_tdl_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_tdl_1_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_tdl_1_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_tdl_1_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_tdl_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_tdl_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x141A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x143A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x145A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x102E0150 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E006A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x124C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x144C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x164C2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C4E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E4EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C0F0BC0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F0302 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E2C0003 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C00F0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x021A3080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x041A31E5 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02148000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0414A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C150054 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06168000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08168000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A168000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C3A3280 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E3A0063 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x063A0061 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x023A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C348000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E342000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06342000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E350140 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C350100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x18360028 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C368000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E5A3080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x005A3280 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x025A0063 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E548000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00548000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02542000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1E550400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A552000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C550001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x18560080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02568000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04568000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1993A800 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x2F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x31904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x59900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4B900420 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x4D900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45901084 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900001 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x30800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x00000002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x00007FFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x00009FFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x00000002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x0000EFFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000F3FF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x00000002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000FDFF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000FE7F };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_1__non_ps_thread02_ready_for_dispatch__read;
         counter->name = "NonPS Thread Ready For Dispatch on Slice0 Subslice2";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__tdl_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_1__non_ps_thread00_ready_for_dispatch__read;
         counter->name = "NonPS Thread Ready For Dispatch on Slice0 Subslice0";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 120;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_1__ps_thread00_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice0";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_1__ps_thread01_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice1";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 224;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_1__ps_thread02_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice2";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 248;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_1__non_ps_thread01_ready_for_dispatch__read;
         counter->name = "NonPS Thread Ready For Dispatch on Slice0 Subslice1";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 288;
         counter->size = sizeof(float);
      }

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set TDL_2 :: GPU Core Clocks */
static uint64_t
glk__tdl_2__gpu_core_clocks__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set TDL_2 :: EU Active */
static float
glk__tdl_2__eu_active__read(struct brw_context *brw,
                            const struct brw_perf_query_info *query,
                            uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
static float
glk__tdl_2__eu_fpu_both_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS Send Pipe Active */
static float
glk__tdl_2__vs_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
static float
glk__tdl_2__vs_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: GS Threads Dispatched */
static uint64_t
glk__tdl_2__gs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
static uint64_t
glk__tdl_2__hi_depth_test_fails__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: FS Both FPU Active */
static float
glk__tdl_2__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS Threads Dispatched */
static uint64_t
glk__tdl_2__vs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set TDL_2 :: FS Threads Dispatched */
static uint64_t
glk__tdl_2__ps_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set TDL_2 :: Shader Barrier Messages */
static uint64_t
glk__tdl_2__shader_barriers__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set TDL_2 :: Sampler Texels */
static uint64_t
glk__tdl_2__sampler_texels__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Pixels Failing Tests */
static uint64_t
glk__tdl_2__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 0 */
static float
glk__tdl_2__thread_header01_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Port 1 */
static float
glk__tdl_2__thread_header01_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: GPU Time Elapsed */
static uint64_t
glk__tdl_2__gpu_time__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: AVG GPU Core Frequency */
static uint64_t
glk__tdl_2__avg_gpu_core_frequency__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__tdl_2__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set TDL_2 :: AVG GPU Core Frequency */
static uint64_t
glk__tdl_2__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set TDL_2 :: Sampler Texels Misses */
static uint64_t
glk__tdl_2__sampler_texel_misses__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: CS Threads Dispatched */
static uint64_t
glk__tdl_2__cs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set TDL_2 :: SLM Bytes Read */
static uint64_t
glk__tdl_2__slm_bytes_read__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
static float
glk__tdl_2__ps_fpu1_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: PS Send Pipeline Active */
static float
glk__tdl_2__ps_send_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
static float
glk__tdl_2__vs_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: GPU Busy */
static float
glk__tdl_2__gpu_busy__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 1 */
static float
glk__tdl_2__thread_header02_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Port 0 */
static float
glk__tdl_2__thread_header02_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Rasterized Pixels */
static uint64_t
glk__tdl_2__rasterized_pixels__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
static float
glk__tdl_2__ps_fpu0_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: DS Threads Dispatched */
static uint64_t
glk__tdl_2__ds_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set TDL_2 :: Samples Written */
static uint64_t
glk__tdl_2__samples_written__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: EU Stall */
static float
glk__tdl_2__eu_stall__read(struct brw_context *brw,
                           const struct brw_perf_query_info *query,
                           uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: Samples Blended */
static uint64_t
glk__tdl_2__samples_blended__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Early Depth Test Fails */
static uint64_t
glk__tdl_2__early_depth_test_fails__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Shader Memory Accesses */
static uint64_t
glk__tdl_2__shader_memory_accesses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set TDL_2 :: HS Threads Dispatched */
static uint64_t
glk__tdl_2__hs_threads__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set TDL_2 :: SLM Bytes Written */
static uint64_t
glk__tdl_2__slm_bytes_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_2 :: L3 Shader Throughput */
static uint64_t
glk__tdl_2__l3_shader_throughput__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = glk__tdl_2__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set TDL_2 :: Samples Killed in FS */
static uint64_t
glk__tdl_2__samples_killed_in_ps__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 0 */
static float
glk__tdl_2__thread_header00_ready_port0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
static uint64_t
glk__tdl_2__shader_atomics__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Port 1 */
static float
glk__tdl_2__thread_header00_ready_port1__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = glk__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_register_prog glk_tdl_2_mux_regs[58];
static struct brw_perf_query_register_prog glk_tdl_2_b_counter_regs[6];
static struct brw_perf_query_register_prog glk_tdl_2_flex_regs[7];

static struct brw_perf_query_counter glk_tdl_2_query_counters[41];
static struct brw_perf_query_info glk_tdl_2_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set TDL_2",
   .guid = "ffa3f263-0478-4724-8c9f-c911c5ec0f1d",
   .counters = glk_tdl_2_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_tdl_2_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_tdl_2_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_tdl_2_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_tdl_2_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_tdl_2_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x141A026B };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x143A0173 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x145A026B };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x002D4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x022D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C2E5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0069 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044C8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A4C4000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x004E8000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x024EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x064E2000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x180F6000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F030A };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C03C0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x041A37E7 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x021A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0414A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C150050 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08168000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A168000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x003A3380 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x063A006F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x023A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x00348000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06342000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A352000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C350100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x02368000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C368000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x025A37E7 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0254A000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C550005 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04568000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06568000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x03938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x05938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x15904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x17904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x53900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x43900020 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45901080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900001 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00010003 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00012011 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00015014 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00051050 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00053052 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00055054 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_2__thread_header01_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice1 Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 88;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_2__thread_header01_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice1 Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 92;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__tdl_2__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 140;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_2__thread_header02_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice2 Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 152;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_2__thread_header02_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice2 Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 156;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__tdl_2__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_2__thread_header00_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice0 Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 256;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__tdl_2__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = glk__tdl_2__thread_header00_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice0 Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 272;
         counter->size = sizeof(float);
      }

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Extra Gen9 :: GPU Core Clocks */
static uint64_t
glk__compute_extra__gpu_core_clocks__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Extra Gen9 :: EU FPU1 Pipe Active */
static float
glk__compute_extra__fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = glk__compute_extra__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extra Gen9 :: GPU Time Elapsed */
static uint64_t
glk__compute_extra__gpu_time__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Extra Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_extra__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__compute_extra__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__compute_extra__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extra Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__compute_extra__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Extra Gen9 :: EU FPU1 Pipe Active including Ext Math */
static float
glk__compute_extra__fpu1_active_adjusted__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 8 READ  C 7 READ C 6 READ FADD C 5 READ FADD 8 FMUL FADD 100 FMUL $EuCoresTotalCount FDIV $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = accumulator[query->c_offset + 7];
   uint64_t tmp2 = accumulator[query->c_offset + 6];
   double tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->c_offset + 5];
   double tmp5 = tmp3 + tmp4;
   double tmp6 = tmp5 * 8;
   double tmp7 = tmp0 + tmp6;
   double tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = brw->perfquery.sys_vars.n_eus;
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;
   double tmp12 = tmp11;
   double tmp13 = glk__compute_extra__gpu_core_clocks__read(brw, query, accumulator);
   double tmp14 = tmp13 ? tmp12 / tmp13 : 0;

   return tmp14;
}

static struct brw_perf_query_register_prog glk_compute_extra_mux_regs[37];
static struct brw_perf_query_register_prog glk_compute_extra_b_counter_regs[6];
static struct brw_perf_query_register_prog glk_compute_extra_flex_regs[7];

static struct brw_perf_query_counter glk_compute_extra_query_counters[5];
static struct brw_perf_query_info glk_compute_extra_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Extra Gen9",
   .guid = "15274c82-27d2-4819-876a-7cb1a2c59ba4",
   .counters = glk_compute_extra_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_compute_extra_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_compute_extra_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
   .flex_regs = glk_compute_extra_flex_regs,
   .n_flex_regs = 0, /* Determined at runtime */
};

static void
register_compute_extra_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_compute_extra_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x141A001F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x143A001F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x145A001F };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x042D5000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x062D1000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0E2E0094 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x084CC000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x044EA000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A0F00E0 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1A2C0C00 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x061A0063 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x021A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x06142000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C150100 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0C168000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x043A3180 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x023A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04348000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C350040 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0A368000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x045A0063 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x025A0000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x04542000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1C550010 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x08568000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x09938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0B938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0D938000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1B904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F904000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x45900400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900004 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0x00800000 };

      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E458, .val = 0x00001000 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E558, .val = 0x00003002 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E658, .val = 0x00005004 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E758, .val = 0x00011010 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E45C, .val = 0x00050012 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E55C, .val = 0x00052051 };
      query->flex_regs[query->n_flex_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000E65C, .val = 0x00000008 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extra__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extra__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extra__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__compute_extra__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__compute_extra__avg_gpu_core_frequency__max(brw);
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = glk__compute_extra__fpu1_active_adjusted__read;
      counter->name = "EU FPU1 Pipe Active including Ext Math";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing including Extended Math processing";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* MDAPI testing set Gen9 :: TestCounter7 */
static uint64_t
glk__test_oa__counter7__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* MDAPI testing set Gen9 :: GPU Time Elapsed */
static uint64_t
glk__test_oa__gpu_time__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* MDAPI testing set Gen9 :: GPU Core Clocks */
static uint64_t
glk__test_oa__gpu_core_clocks__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* MDAPI testing set Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__test_oa__avg_gpu_core_frequency__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = glk__test_oa__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = glk__test_oa__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* MDAPI testing set Gen9 :: AVG GPU Core Frequency */
static uint64_t
glk__test_oa__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* MDAPI testing set Gen9 :: TestCounter8 */
static uint64_t
glk__test_oa__counter8__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter4 */
static uint64_t
glk__test_oa__counter4__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter5 */
static uint64_t
glk__test_oa__counter5__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter6 */
static uint64_t
glk__test_oa__counter6__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter3 */
static uint64_t
glk__test_oa__counter3__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter0 */
static uint64_t
glk__test_oa__counter0__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter1 */
static uint64_t
glk__test_oa__counter1__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* MDAPI testing set Gen9 :: TestCounter2 */
static uint64_t
glk__test_oa__counter2__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

static struct brw_perf_query_register_prog glk_test_oa_mux_regs[12];
static struct brw_perf_query_register_prog glk_test_oa_b_counter_regs[22];

static struct brw_perf_query_counter glk_test_oa_query_counters[12];
static struct brw_perf_query_info glk_test_oa_query = {
   .kind = OA_COUNTERS,
   .name = "MDAPI testing set Gen9",
   .guid = "dd3fd789-e783-4204-8cd0-b671bbccb0cf",
   .counters = glk_test_oa_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
   .mux_regs = glk_test_oa_mux_regs,
   .n_mux_regs = 0, /* Determined at runtime */
   .b_counter_regs = glk_test_oa_b_counter_regs,
   .n_b_counter_regs = 0, /* Determined at runtime */
};

static void
register_test_oa_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &glk_test_oa_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009840, .val = 0x00000080 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x19800000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x07800063 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x11800000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x23810008 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1D950400 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x0F922000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x1F908000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x37900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x55900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x47900000 };
      query->mux_regs[query->n_mux_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00009888, .val = 0x33900000 };

      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002740, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002744, .val = 0x00800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002714, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002710, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002724, .val = 0xF0800000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002720, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002770, .val = 0x00000004 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002774, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002778, .val = 0x00000003 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000277C, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002780, .val = 0x00000007 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002784, .val = 0x00000000 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002788, .val = 0x00100002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000278C, .val = 0x0000FFF7 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002790, .val = 0x00100002 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002794, .val = 0x0000FFCF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x00002798, .val = 0x00100082 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x0000279C, .val = 0x0000FFEF };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A0, .val = 0x001000C2 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A4, .val = 0x0000FFE7 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027A8, .val = 0x00100001 };
      query->b_counter_regs[query->n_b_counter_regs++] = (struct brw_perf_query_register_prog) { .reg = 0x000027AC, .val = 0x0000FFE7 };


      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter7__read;
      counter->name = "TestCounter7";
      counter->desc = "HW test counter 7. Factor: 0.666";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 8;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = glk__test_oa__avg_gpu_core_frequency__max(brw);
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter8__read;
      counter->name = "TestCounter8";
      counter->desc = "HW test counter 8. Should be equal to 1.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter4__read;
      counter->name = "TestCounter4";
      counter->desc = "HW test counter 4. Factor: 0.333";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter5__read;
      counter->name = "TestCounter5";
      counter->desc = "HW test counter 5. Factor: 0.333";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter6__read;
      counter->name = "TestCounter6";
      counter->desc = "HW test counter 6. Factor: 0.166";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter3__read;
      counter->name = "TestCounter3";
      counter->desc = "HW test counter 3. Factor: 0.5";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter0__read;
      counter->name = "TestCounter0";
      counter->desc = "HW test counter 0. Factor: 0.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter1__read;
      counter->name = "TestCounter1";
      counter->desc = "HW test counter 1. Factor: 1.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = glk__test_oa__counter2__read;
      counter->name = "TestCounter2";
      counter->desc = "HW test counter 2. Factor: 1.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

void
brw_oa_register_queries_glk(struct brw_context *brw)
{
   register_render_basic_counter_query(brw);
   register_compute_basic_counter_query(brw);
   register_render_pipe_profile_counter_query(brw);
   register_memory_reads_counter_query(brw);
   register_memory_writes_counter_query(brw);
   register_compute_extended_counter_query(brw);
   register_compute_l3_cache_counter_query(brw);
   register_hdc_and_sf_counter_query(brw);
   register_l3_1_counter_query(brw);
   register_rasterizer_and_pixel_backend_counter_query(brw);
   register_sampler_counter_query(brw);
   register_tdl_1_counter_query(brw);
   register_tdl_2_counter_query(brw);
   register_compute_extra_counter_query(brw);
   register_test_oa_counter_query(brw);
}
