# 0.0.18

**Version:** 0.0.18
**Published:** 2023-04-02T19:43:54Z

## Release Notes

🎉 We're excited to announce the new release of Rust coreutils! This release brings several improvements and new features, including updates to the GNU test suite compatibility, and refinements in various utilities such as cksum, chmod, chroot, comm, cp, cut, and many more.

## General changes
* GNU/coreutils: update reference to 9.2 by @cakebaker in https://github.com/uutils/coreutils/pull/4601
* MSRV 1.64 & Workspace inheritance for dependencies by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4344
* Fuzzing deployed for some programs and functions
* For most of the programs, the help and description are using dedicated markdown files.
* Adjust -i behavior for ln, cp & mv by @sylvestre in https://github.com/uutils/coreutils/pull/4630
* Refactor signal handling in yes, tee, and timeout by @anastygnome in https://github.com/uutils/coreutils/pull/4588
* Migrate from `atty` to `is-terminal` by @souzaguilhermea in https://github.com/uutils/coreutils/pull/4382

## GNU test suite compatibility

Many utils have gotten minor changes to improve GNU compatibility. Below is a summary of the progress. See https://github.com/uutils/coreutils-tracking/ for more details
The numbers changes in every category because of the GNU/Coreutils upgraded to 9.2

| result | 0.0.17 | 0.0.18 | change |
|--------|-------:|-------:|-------:|
| pass   |    338 |    340 |    +2 |
| skip   |     48 |     50 |    +2 |
| fail   |    204 |    210 |    +6 |
| error  |      3 |      2 |    +-1 |

### Detailed changes

### cksum 
* Implement -a by @howjmay in https://github.com/uutils/coreutils/pull/4356

### chmod
* change permissions for files present even when there is a missing file by @dmatos2012 in https://github.com/uutils/coreutils/pull/4359
* suppress verbose output when not verbose by @dmatos2012 in https://github.com/uutils/coreutils/pull/4402
* allow verbose and quiet flags to be used more than once by @dmatos2012 in https://github.com/uutils/coreutils/pull/4410
* Fix GNU test 'chmod/usage' by @bbara in https://github.com/uutils/coreutils/pull/4442

### chroot
* Fix unused import on Android by @miles170 in https://github.com/uutils/coreutils/pull/4571

### comm
* Implement --total by @cakebaker in https://github.com/uutils/coreutils/pull/4300
* Enable "no_arguments" & "one_argument" tests by @cakebaker in https://github.com/uutils/coreutils/pull/4330
* Use delimiter on "total" line by @cakebaker in https://github.com/uutils/coreutils/pull/4314
* Implement --zero-terminated by @cakebaker in https://github.com/uutils/coreutils/pull/4449
* Allow multiple occurrence of --zero-terminated by @cakebaker in https://github.com/uutils/coreutils/pull/4452


### cp
* Modify archive flag to copy dir contents rather than dir by @dmatos2012 in https://github.com/uutils/coreutils/pull/3954
* Use PathBuf instead of String for paths by @tmccombs in https://github.com/uutils/coreutils/pull/4348
* Stop saying --sparse is not implemented for cp by @tmccombs in https://github.com/uutils/coreutils/pull/4349

### cut
* Refactor by @TechHara in https://github.com/uutils/coreutils/pull/4255

### date
* Show error when reading dirs for -f arg by @shanmukhateja in https://github.com/uutils/coreutils/pull/4572
* Added default value for `date --i`. by @kidrigger in https://github.com/uutils/coreutils/pull/4522
* fix: match date -I error messages with GNU date by @shanmukhateja in https://github.com/uutils/coreutils/pull/4499
* Added tests for date ISO8601 formats. by @kidrigger in https://github.com/uutils/coreutils/pull/4520
* Make sure 'invalid date' message also returns exit code 1 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4526
* Fix invalid argument error for RFC 3339 by @shanmukhateja in https://github.com/uutils/coreutils/pull/4535
* A better handler for `./coreutils date -f aze` by @AbhinavMir in https://github.com/uutils/coreutils/pull/4482

### dd
* Move dd_out() function up to module level by @jfinkels in https://github.com/uutils/coreutils/pull/4428
* Allow skipping and seeking in FIFOs by @jfinkels in https://github.com/uutils/coreutils/pull/4164
* Fix precision for display of total time spent by @jfinkels in https://github.com/uutils/coreutils/pull/4498
* Fix unused imports on FreeBSD by @miles170 in https://github.com/uutils/coreutils/pull/4512
* Open stdin from file descriptor when possible by @jfinkels in https://github.com/uutils/coreutils/pull/4189


### du
* threshold error message fix by @haciek in https://github.com/uutils/coreutils/pull/4637
* Update the GNU error message to our for tests/du/threshold.sh by @sylvestre in https://github.com/uutils/coreutils/pull/4656
* Run test_du_time with TZ=UTC.  by @eggpi in https://github.com/uutils/coreutils/pull/4446
* Fix unnecessary boolean operation by @papparapa in https://github.com/uutils/coreutils/pull/4548

### env
* start about text with uppercase char by @cakebaker in https://github.com/uutils/coreutils/pull/4324
* docs: document env -f/--file in GNU extensions by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4331

### expand
* Improve plus specifier handling by @sbentmar in https://github.com/uutils/coreutils/pull/4260

### factor
* Remove `paste` dev dependency by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4631

### hashsum

* Add `--zero`  option (#4612) by @0xMRTT in https://github.com/uutils/coreutils/pull/4632

### install
* Fix bad target directory permissions by @kylemanna in https://github.com/uutils/coreutils/pull/4364
* Add missing directory chown by @kylemanna in https://github.com/uutils/coreutils/pull/4365

### ln
* Fix format of help text by @cakebaker in https://github.com/uutils/coreutils/pull/4327

### ls
* Cannot find function `expected_result` in this scope by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/4580
* Handling case sensitive ls output by @jparag in https://github.com/uutils/coreutils/pull/4524

### mktemp
* uncomment fixed test case by @jfinkels in https://github.com/uutils/coreutils/pull/4297

### mv
* Update of fs_extra - address the new warnings by @sylvestre in https://github.com/uutils/coreutils/pull/4320

### nice
* Support legacy argument syntax for nice by @eds-collabora in https://github.com/uutils/coreutils/pull/4271

### nproc
* Replace num_cpus crate with thread::available_parallelism by @souzaguilhermea in https://github.com/uutils/coreutils/pull/4352

### od
* Remove "width = width" from format strings by @cakebaker in https://github.com/uutils/coreutils/pull/4263
* Fix some minor details suggested by clippy::pedantic by @cakebaker in https://github.com/uutils/coreutils/pull/4492

### ptx
* Fix warning from unnecessary_join lint by @cakebaker in https://github.com/uutils/coreutils/pull/4313

### pwd
* Small refactor of some match expressions by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4508

### rm
* Remove remove_dir_all dependency by @howjmay in https://github.com/uutils/coreutils/pull/4340

### shred
* Refactor to clean up code and reduce syscalls by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4493
* Enable `test_shred_force` on FreeBSD by @miles170 in https://github.com/uutils/coreutils/pull/4523
* Fix `permissions_set_readonly_false` clippy error by @miles170 in https://github.com/uutils/coreutils/pull/4488

### sleep
* Fix parsing of multiple inputs panics on overflow, some whitespace issues ... by @Joining7943 in https://github.com/uutils/coreutils/pull/4439
* Replace uucore::parse_time::from_str with fundu by @Joining7943 in https://github.com/uutils/coreutils/pull/4448


### stdbuf
* Get profile from the end of the path by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4638

### stty
* Basic support for --file/-F by @VorpalBlade in https://github.com/uutils/coreutils/pull/4401

### tail
* Fix GNU test 'misc/tail' by @bbara in https://github.com/uutils/coreutils/pull/4347
* Fix argument parsing of sleep interval by @Joining7943 in https://github.com/uutils/coreutils/pull/4239
* `tests/tail`: Disable `test_follow_with_pid` on freebsd by @Joining7943 in https://github.com/uutils/coreutils/pull/4307
* `tail`: Cargo.toml: Remove unneeded features of uucore and the nix dependency by @Joining7943 in https://github.com/uutils/coreutils/pull/4376

### touch
* Add underscores to long number in test by @cakebaker in https://github.com/uutils/coreutils/pull/4577

### timeout
* Add a test to verify that it fails as expected by @sylvestre in https://github.com/uutils/coreutils/pull/4419
* Fix subprocess is never terminated by @miles170 in https://github.com/uutils/coreutils/pull/4315

### tr
* Remove the extra newline in stderr by @howjmay in https://github.com/uutils/coreutils/pull/4339

### uname

* Use the same version of platform-info as arch by @sylvestre in https://github.com/uutils/coreutils/pull/4290

### uniq
* Remove suppression of use_self lint by @cakebaker in https://github.com/uutils/coreutils/pull/4354
* Remove `strum` dependency by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4629

### uptime
* correctly calculate boot-time by @zanbaldwin in https://github.com/uutils/coreutils/pull/4440

### utmpx
* arch/os-independent timeval handling by @bbara in https://github.com/uutils/coreutils/pull/4405

### wc
* Implement --total by @cakebaker in https://github.com/uutils/coreutils/pull/4695

### uucore
* util: fix publish order of uucore_procs and uucore by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4287
* `uucore`: Fix #4298: Fails to build on s390x (and riscv64) by @Joining7943 in https://github.com/uutils/coreutils/pull/4299
* parser: fix index out of bounds error by @papparapa in https://github.com/uutils/coreutils/pull/4484
* uucore: fix help section doesn't render 3+ level headers by @piotrkwiecinski in https://github.com/uutils/coreutils/pull/4569
* Fix panic in multi-byte characters by @howjmay in https://github.com/uutils/coreutils/pull/4388
* uucore_procs: extract "about" and "usage" info from new help structure by @cakebaker in https://github.com/uutils/coreutils/pull/4385
* uucore: indent multiline usage info by @cakebaker in https://github.com/uutils/coreutils/pull/4393
* replace VERSION string with clap::crate_version by @akhilerm in https://github.com/uutils/coreutils/pull/4462

### CI

* CICD maintainence by @rivy in https://github.com/uutils/coreutils/pull/4292
* Use sccache to cache build results by @sylvestre in https://github.com/uutils/coreutils/pull/4486
* use sccache action 0.0.3 - automatically uses the most recent version of sccache by @sylvestre in https://github.com/uutils/coreutils/pull/4582
* Extend the stale bot to 3 years by @sylvestre in https://github.com/uutils/coreutils/pull/4312
* End the current execution if there is a new changeset in the PR by @sylvestre in https://github.com/uutils/coreutils/pull/4386
* GNU: Ignore some intermittent by @sylvestre in https://github.com/uutils/coreutils/pull/4296
* `cicd`: Fix #4322 toolchain overrides must begin with + by @Joining7943 in https://github.com/uutils/coreutils/pull/4323
* Linting and formatting checks for FreeBSD by @miles170 in https://github.com/uutils/coreutils/pull/4668
* utils: create a script to explore binary sizes by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4441
* Install some missing dependencies for the GNU tests by @sylvestre in https://github.com/uutils/coreutils/pull/4451
* Remove duplicated x86_64-unknown-linux-gnu target from build job by @kamilogorek in https://github.com/uutils/coreutils/pull/4648
* Move freebsd & android jobs in separate workflows by @sylvestre in https://github.com/uutils/coreutils/pull/4628
* Remove outdated comments by @cakebaker in https://github.com/uutils/coreutils/pull/4649
* Also ignore intermittent when starting to pass by @sylvestre in https://github.com/uutils/coreutils/pull/4541
* util/show-utils: fix script not working as intended by @miles170 in https://github.com/uutils/coreutils/pull/4560
* Remove android from the job name (as it is now a workspace) by @sylvestre in https://github.com/uutils/coreutils/pull/4671
* manage an potential error in util/remaining-gnu-error.py when GNU isn't up to date by @sylvestre in https://github.com/uutils/coreutils/pull/4626
* `release-fast` and `release-small` profiles and a page on packaging in the docs. by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4470

### Test
* test: add a test matching what busybox is doing by @sylvestre in https://github.com/uutils/coreutils/pull/4265
* Remove `keep_env` from the test framework by @miles170 in https://github.com/uutils/coreutils/pull/4594
* Implement enhancements of `CmdResult` #4259 by @Joining7943 in https://github.com/uutils/coreutils/pull/4261
* Small Refactor/Fixes of `UCommand` and add method to run a `UCommand` in a shell platform independently by @Joining7943 in https://github.com/uutils/coreutils/pull/4293
* Fix tr.pl and stat-printf.pl don't show up in gnu-full-result by @miles170 in https://github.com/uutils/coreutils/pull/4503
* Fix path resolution of test executable by @Joining7943 in https://github.com/uutils/coreutils/pull/4256
* Don't trim output in `CmdResult::stdout_matches` and `stdout_does_not_match` by @Joining7943 in https://github.com/uutils/coreutils/pull/4304
* Replace panic in favor of ParseError by @leon3s in https://github.com/uutils/coreutils/pull/4558
* Fix unused import "rstest::rstest" warning by @cakebaker in https://github.com/uutils/coreutils/pull/4644
* Default environment variables for tests by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4593
* tests: expand wildcard imports by @cakebaker in https://github.com/uutils/coreutils/pull/4561

### Code quality
* clippy: fix warnings introduced with Rust 1.67.0 by @cakebaker in https://github.com/uutils/coreutils/pull/4303
* clippy: fix unnecessary return warnings by @ctsk in https://github.com/uutils/coreutils/pull/4308
* Fixes from nightly version of clippy by @jfinkels in https://github.com/uutils/coreutils/pull/4363
* fix unnecessary boolean not operations by @daviddwk in https://github.com/uutils/coreutils/pull/4578
* remove dependabot configuration. we are using renovatebot by @sylvestre in https://github.com/uutils/coreutils/pull/4599
* Fix some simple clippy warnings by @sylvestre in https://github.com/uutils/coreutils/pull/4532
* build.rs: ignore a clippy warning: match_same_arms by @sylvestre in https://github.com/uutils/coreutils/pull/4536
* fix: clippy long literal lacking separators by @leon3s in https://github.com/uutils/coreutils/pull/4546
* lint: Enable clippy::if_not_else and fix all lint issues by @kamilogorek in https://github.com/uutils/coreutils/pull/4647

### Documentation

* docs: fix invalid test status in gnu-full-result by @miles170 in https://github.com/uutils/coreutils/pull/4317
* Start about texts with uppercase char by @cakebaker in https://github.com/uutils/coreutils/pull/4326
* fix typo by @howjmay in https://github.com/uutils/coreutils/pull/4328
* Document how to build in release mode by @sylvestre in https://github.com/uutils/coreutils/pull/4467
* Freebsd pkg has been remamed to rust-coreutils by @sylvestre in https://github.com/uutils/coreutils/pull/4420
* refresh the installation doc with new distros by @sylvestre in https://github.com/uutils/coreutils/pull/4374
* Add OpenMandriva Lx to the documentation by @tpgxyz in https://github.com/uutils/coreutils/pull/4431
* gentoo has renamed the package by @sylvestre in https://github.com/uutils/coreutils/pull/4418
* Generate manpages and check them in the CI by @sylvestre in https://github.com/uutils/coreutils/pull/4459
* Various improvements in the docs by @sylvestre in https://github.com/uutils/coreutils/pull/4457
* Add FreeBSD to documentation by @pkubaj in https://github.com/uutils/coreutils/pull/4397
* readme: advise using --locked with cargo install by @samueltardieu in https://github.com/uutils/coreutils/pull/4502
* Updating README.md & CONTRIBUTING.md (and removing DEVELOPER_INSTRUCTIONS.md) by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4511
* readme: remove LOC badge by @cakebaker in https://github.com/uutils/coreutils/pull/4559
* References the other implementations by @sylvestre in https://github.com/uutils/coreutils/pull/4463
* fix: to show the name of utility instead of 'manpages' by @SSJDeathSpawn in https://github.com/uutils/coreutils/pull/4566
* Replace get_long_usage fns with const by @cakebaker in https://github.com/uutils/coreutils/pull/4367



### Dependency update
* build(deps): bump gcd from 2.1.0 to 2.2.0 by @dependabot in https://github.com/uutils/coreutils/pull/4180
* build(deps): bump blake3 from 1.3.1 to 1.3.2 by @dependabot in https://github.com/uutils/coreutils/pull/4171
* chore(deps): update rust crate hex-literal to 0.4.0 by @renovate in https://github.com/uutils/coreutils/pull/4699
* fix(deps): update rust crate data-encoding to 2.3 by @renovate in https://github.com/uutils/coreutils/pull/4689
* chore(deps): update rust crate rstest to 0.17.0 by @renovate in https://github.com/uutils/coreutils/pull/4677
* fix(deps): update rust crate windows-sys to 0.45.0 by @renovate in https://github.com/uutils/coreutils/pull/4691
* build(deps): bump regex from 1.7.0 to 1.7.1 by @dependabot in https://github.com/uutils/coreutils/pull/4311
* chore(deps): update rust crate crossterm to >=0.26.1 by @renovate in https://github.com/uutils/coreutils/pull/4660
* chore(deps): update rust crate half to 2.2 by @renovate in https://github.com/uutils/coreutils/pull/4665
* chore(deps): update rust crate fs_extra to 1.3.0 by @renovate in https://github.com/uutils/coreutils/pull/4663
* fix(deps): update rust crate libc to 0.2.140 by @renovate in https://github.com/uutils/coreutils/pull/4653
* chore(deps): update rust crate notify to v5.1.0 by @renovate in https://github.com/uutils/coreutils/pull/4666
* chore(deps): update rust crate is-terminal to 0.4.6 by @renovate in https://github.com/uutils/coreutils/pull/4673
* chore(deps): update rust crate clap to 4.2 by @renovate in https://github.com/uutils/coreutils/pull/4674
* chore(deps): update rust crate gcd to 2.3 by @renovate in https://github.com/uutils/coreutils/pull/4664
* chore(deps): update rust crate exacl to 0.10.0 by @renovate in https://github.com/uutils/coreutils/pull/4662
* chore(deps): update rust crate unicode-segmentation to 1.10.1 by @renovate in https://github.com/uutils/coreutils/pull/4684
* chore(deps): update rust crate fundu to 0.5.0 by @renovate in https://github.com/uutils/coreutils/pull/4683
* chore(deps): update rust crate clap_complete to 4.2 by @renovate in https://github.com/uutils/coreutils/pull/4676
* chore(deps): update rust crate unindent to 0.2 by @renovate in https://github.com/uutils/coreutils/pull/4687
* chore(deps): update rust crate once_cell to 1.17.1 by @renovate in https://github.com/uutils/coreutils/pull/4669
* chore(deps): update rust crate walkdir to 2.3 by @renovate in https://github.com/uutils/coreutils/pull/4688
* chore(deps): update rust crate num_cpus to 1.15 by @renovate in https://github.com/uutils/coreutils/pull/4667
* fix(deps): update rust crate wild to 2.1 by @renovate in https://github.com/uutils/coreutils/pull/4690
* chore(deps): update rust crate xattr to v1 by @renovate in https://github.com/uutils/coreutils/pull/4692
* chore(deps): update rust crate zip to 0.6.4 by @renovate in https://github.com/uutils/coreutils/pull/4635
* chore(deps): update rust crate nom to 7.1.3 by @renovate in https://github.com/uutils/coreutils/pull/4605
* fix(deps): update rust crate itertools to 0.10.5 by @renovate in https://github.com/uutils/coreutils/pull/4652
* chore(deps): update rust crate bstr to 1.4 by @renovate in https://github.com/uutils/coreutils/pull/4655
* chore(deps): update rust crate byteorder to 1.4.3 by @renovate in https://github.com/uutils/coreutils/pull/4658
* chore(deps): update rust crate clap_complete to 4.1 by @renovate in https://github.com/uutils/coreutils/pull/4659
* chore(deps): update rust crate ctrlc to 3.2 by @renovate in https://github.com/uutils/coreutils/pull/4661
* chore(deps): update rust crate is-terminal to 0.4.5 by @renovate in https://github.com/uutils/coreutils/pull/4604
* chore(deps): update rust crate sha2 to 0.10.6 by @renovate in https://github.com/uutils/coreutils/pull/4622
* chore(deps): update rust crate unicode-width to 0.1.10 by @renovate in https://github.com/uutils/coreutils/pull/4633
* fix(deps): update rust crate dns-lookup to 1.0.8 by @renovate in https://github.com/uutils/coreutils/pull/4636
* fix(deps): update rust crate glob to 0.3.1 by @renovate in https://github.com/uutils/coreutils/pull/4640
* chore(deps): update rust crate ouroboros to 0.15.6 by @renovate in https://github.com/uutils/coreutils/pull/4617
* chore(deps): update rust crate regex to 1.7.3 by @renovate in https://github.com/uutils/coreutils/pull/4620
* chore(deps): update rust crate signal-hook to 0.3.15 by @renovate in https://github.com/uutils/coreutils/pull/4623
* chore(deps): update rust crate num-bigint to 0.4.3 by @renovate in https://github.com/uutils/coreutils/pull/4616
* chore(deps): update rust crate fundu to 0.4.3 by @renovate in https://github.com/uutils/coreutils/pull/4602
* chore(deps): update rust crate sha1 to 0.10.5 by @renovate in https://github.com/uutils/coreutils/pull/4621
* chore(deps): update rust crate hex-literal to 0.3.4 by @renovate in https://github.com/uutils/coreutils/pull/4603
* chore(deps): update rust crate chrono to ^0.4.24 by @renovate in https://github.com/uutils/coreutils/pull/4597
* deps: bump `time` from 0.3.17 to 0.3.20 by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4643
* chore(deps): update rust crate blake3 to 1.3.3 by @renovate in https://github.com/uutils/coreutils/pull/4596
* Fix some double deps by @tertsdiepraam in https://github.com/uutils/coreutils/pull/4333
* Bump tempfile from 3.3.0 to 3.4.0 by @cakebaker in https://github.com/uutils/coreutils/pull/4483
* Bump rayon from 1.6.0 to 1.7.0 by @cakebaker in https://github.com/uutils/coreutils/pull/4497
* Bump clap from 4.0.26 to 4.1.8 & fix broken tests by @cakebaker in https://github.com/uutils/coreutils/pull/4478
* Bump procfs from 0.14.1 to 0.15.1 by @cakebaker in https://github.com/uutils/coreutils/pull/4500
* Bump terminal_size from 0.2.2 to 0.2.5 by @cakebaker in https://github.com/uutils/coreutils/pull/4501
* Bump fts-sys to 0.2.4 & selinux-sys to 0.6.2 by @cakebaker in https://github.com/uutils/coreutils/pull/4504
* Bump clap from 4.1.8 to 4.1.13 by @cakebaker in https://github.com/uutils/coreutils/pull/4595
* Updated selinux dependency to version 0.4 by @koutheir in https://github.com/uutils/coreutils/pull/4427

## New Contributors
* @howjmay made their first contribution in https://github.com/uutils/coreutils/pull/4328
* @tmccombs made their first contribution in https://github.com/uutils/coreutils/pull/4349
* @souzaguilhermea made their first contribution in https://github.com/uutils/coreutils/pull/4352
* @papparapa made their first contribution in https://github.com/uutils/coreutils/pull/4372
* @kylemanna made their first contribution in https://github.com/uutils/coreutils/pull/4364
* @pkubaj made their first contribution in https://github.com/uutils/coreutils/pull/4397
* @jhowww made their first contribution in https://github.com/uutils/coreutils/pull/4403
* @chenchiii made their first contribution in https://github.com/uutils/coreutils/pull/4411
* @zleyyij made their first contribution in https://github.com/uutils/coreutils/pull/4373
* @bbara made their first contribution in https://github.com/uutils/coreutils/pull/4405
* @tpgxyz made their first contribution in https://github.com/uutils/coreutils/pull/4431
* @VorpalBlade made their first contribution in https://github.com/uutils/coreutils/pull/4401
* @zanbaldwin made their first contribution in https://github.com/uutils/coreutils/pull/4440
* @eggpi made their first contribution in https://github.com/uutils/coreutils/pull/4446
* @schoki040 made their first contribution in https://github.com/uutils/coreutils/pull/4456
* @curtainp made their first contribution in https://github.com/uutils/coreutils/pull/4391
* @akhilerm made their first contribution in https://github.com/uutils/coreutils/pull/4461
* @chusteven made their first contribution in https://github.com/uutils/coreutils/pull/4458
* @IZUMI-Zu made their first contribution in https://github.com/uutils/coreutils/pull/4471
* @wuseyu made their first contribution in https://github.com/uutils/coreutils/pull/4472
* @aiye123 made their first contribution in https://github.com/uutils/coreutils/pull/4491
* @samueltardieu made their first contribution in https://github.com/uutils/coreutils/pull/4502
* @ValentinyFilip made their first contribution in https://github.com/uutils/coreutils/pull/4516
* @shanmukhateja made their first contribution in https://github.com/uutils/coreutils/pull/4499
* @kidrigger made their first contribution in https://github.com/uutils/coreutils/pull/4520
* @jparag made their first contribution in https://github.com/uutils/coreutils/pull/4524
* @AbhinavMir made their first contribution in https://github.com/uutils/coreutils/pull/4482
* @piotrkwiecinski made their first contribution in https://github.com/uutils/coreutils/pull/4549
* @leon3s made their first contribution in https://github.com/uutils/coreutils/pull/4546
* @daviddwk made their first contribution in https://github.com/uutils/coreutils/pull/4578
* @SSJDeathSpawn made their first contribution in https://github.com/uutils/coreutils/pull/4566
* @kamilogorek made their first contribution in https://github.com/uutils/coreutils/pull/4648
* @haciek made their first contribution in https://github.com/uutils/coreutils/pull/4637
* @0xMRTT made their first contribution in https://github.com/uutils/coreutils/pull/4632

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.17...0.0.18
