/**********************************************************
 * This file has been automatically created by "typemaker2"
 * from the file "account.xml".
 * Please do not edit this file, all changes will be lost.
 * Better edit the mentioned source file instead.
 **********************************************************/

#ifndef AB_ACCOUNT_ACCOUNT_P_H
#define AB_ACCOUNT_ACCOUNT_P_H

#include "./account.h"


#ifdef __cplusplus
extern "C" {
#endif

struct AB_ACCOUNT {
  GWEN_INHERIT_ELEMENT(AB_ACCOUNT)
  GWEN_LIST_ELEMENT(AB_ACCOUNT)
  int _refCount;
  int accountType;
  uint32_t uniqueId;
  char *backendName;
  char *ownerName;
  char *bankName;
  char *accountName;
  char *currency;
  char *memo;
  char *iban;
  char *bic;
  char *country;
  char *bankCode;
  char *branchId;
  char *accountNumber;
  char *subAccountId;
  uint32_t userId;
  AB_PROVIDER *provider; /* volatile */
  AB_ACCOUNT_READFROMDB_FN readFromDbFn;
  AB_ACCOUNT_WRITETODB_FN writeToDbFn;
};

/** 
 * Find an account info object in a list of account info objects. 
 * @param a account info object with which to start searching 
 * @param backendName name of the banking backend (wildcards and jokers allowed) 
 * @param country ISO code of the country (wildcards and jokers allowed) 
 * @param bankId bank code to search for (wildcards and jokers allowed) 
 * @param accountNumber account number to search for (wildcards and jokers allowed) 
 * @param subAccountId sub account number (wildcards and jokers allowed) 
 * @param iban IBAN to search for (wildcards and jokers allowed) 
 * @param currency currecny the account uses (wildcards and jokers allowed) 
 * @param ty account type (use AB_AccountType_Unknown as wildcard) 
 */ 
 AB_ACCOUNT *AB_Account_List__FindInternal(AB_ACCOUNT *a, const char *backendName, const char *country, const char *bankId, const char *accountNumber, const char *subAccountId, const char *iban, const char *currency, int ty);
/** 
 */ 
 int AB_Account__ReadFromDb(AB_ACCOUNT *a, GWEN_DB_NODE *db);
/** 
 */ 
 int AB_Account__WriteToDb(const AB_ACCOUNT *a, GWEN_DB_NODE *db);
#ifdef __cplusplus
}
#endif

#endif

