-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1},{0,0,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-1,0},{0,1},{1,0}};
ineqrhsPd = matrix {{0},{0},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 2, vertices: 1, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3},{4}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,0},{0,-1}};
eqrhsPd = matrix {{-3},{-4}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 11, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,0,1,0},{0,0,1,1,0,0,1,1,0,0,1},{1,1,1,1,0,0,0,0,0,0,0},{0,0,0,0,1,1,1,1,0,0,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0},{-1,0,0,0},{0,-1,0,0},{1,1,-1,-1},{0,0,0,-1},{0,1,0,0},{1,0,0,0},{0,0,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 5, vertices: 11, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,0,1,0},{0,0,1,1,0,0,1,1,0,0,1},{1,1,1,1,0,0,0,0,0,0,0},{0,0,0,0,1,1,1,1,0,0,0},{0,0,0,0,0,0,0,0,1,1,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0,0},{-1,0,0,0,0},{0,-1,0,0,0},{1,1,-1,-1,0},{0,0,0,-1,0},{0,1,0,0,0},{1,0,0,0,0},{0,0,1,1,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{0},{1},{1},{1}};
eqlhsPd = matrix {{0,0,-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 7, facets: 7
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,1,1,3},{0,0,1,1,0,0,4},{1,1,1,1,0,0,0},{0,0,0,0,1,0,0},{0,0,0,0,0,1,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,-3,-2,-2},{0,-1,-4,-4,-4},{1,0,2,2,2},{0,1,3,4,4},{0,0,0,0,-1},{0,0,0,-1,0},{0,0,1,1,1}};
ineqrhsPd = matrix {{-3},{-4},{3},{4},{0},{0},{1}};
eqlhsPd = map(QQ^0, QQ^5, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0},{0,0,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 5, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,1,3},{0,0,1,1,0,4},{1,1,1,1,0,0},{0,0,0,0,1,0},{0,0,0,0,0,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,-3,-2,0},{0,-1,-4,-4,0},{1,0,2,2,0},{0,1,3,4,0},{0,0,0,-1,0},{0,0,1,1,0}};
ineqrhsPd = matrix {{-3},{-4},{3},{4},{0},{1}};
eqlhsPd = matrix {{0,0,-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 2, vertices: 1, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,0},{0,-1}};
eqrhsPd = matrix {{-1},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 4, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,1,0,0,0},{1,0,0,1,1,0},{0,1,0,1,0,1},{0,0,1,0,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0,0},{0,0,1,0},{-1,0,0,0},{-1,-1,-1,0},{0,1,0,0},{0,0,-1,0},{1,1,1,0},{1,0,0,0}};
ineqrhsPd = matrix {{0},{1},{0},{-1},{1},{0},{2},{1}};
eqlhsPd = matrix {{-1,-1,-1,-1}};
eqrhsPd = matrix {{-2}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 10, facets: 30
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,-1,0,0,0,1,-1},{0,1,0,0,0,-1,0,0,1,-1},{0,0,1,0,0,0,-1,0,1,-1},{0,0,0,1,0,0,0,-1,1,-1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,-1,-1},{1,0,-1,-1},{1,-1,1,-1},{1,-1,0,-1},{1,-1,-1,1},{1,-1,-1,0},{-1,-1,1,1},{-1,-1,1,0},{0,-1,1,-1},{-1,0,1,-1},{-1,0,-1,1},{0,-1,-1,1},{-1,-1,0,1},{0,1,-1,-1},{-1,1,-1,0},{-1,1,-1,1},{-1,1,0,-1},{-1,1,1,-1},{-1,0,1,1},{-1,1,0,1},{-1,1,1,0},{0,1,1,-1},{0,1,-1,1},{0,-1,1,1},{1,-1,0,1},{1,-1,1,0},{1,0,-1,1},{1,1,-1,0},{1,0,1,-1},{1,1,0,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 11, facets: 26
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,0,-1,0,0,0,0,1},{0,1,0,0,0,0,-1,0,0,0,1},{0,0,1,0,0,0,0,-1,0,0,1},{0,0,0,1,0,0,0,0,-1,0,1},{0,0,0,0,1,0,0,0,0,-1,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,-1,-1,-1},{1,-1,1,-1,-1},{1,-1,-1,1,-1},{1,-1,-1,-1,-1},{1,-1,-1,-1,1},{-1,-1,1,1,-1},{-1,-1,1,-1,-1},{-1,-1,1,-1,1},{-1,-1,-1,-1,-1},{-1,-1,-1,-1,1},{-1,-1,-1,1,1},{-1,-1,-1,1,-1},{-1,1,-1,-1,1},{-1,1,-1,-1,-1},{-1,1,-1,1,-1},{-1,1,1,-1,-1},{-1,1,1,1,-1},{-1,1,1,-1,1},{-1,1,-1,1,1},{-1,-1,1,1,1},{1,-1,-1,1,1},{1,-1,1,-1,1},{1,-1,1,1,-1},{1,1,-1,-1,1},{1,1,-1,1,-1},{1,1,1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^5, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 6, vertices: 13, facets: 102
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,0,0,-1,0,0,0,0,0,1},{0,1,0,0,0,0,0,-1,0,0,0,0,1},{0,0,1,0,0,0,0,0,-1,0,0,0,1},{0,0,0,1,0,0,0,0,0,-1,0,0,1},{0,0,0,0,1,0,0,0,0,0,-1,0,1},{0,0,0,0,0,1,0,0,0,0,0,-1,1}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,-1,-1,-1},{1,1,-1,1,-1,-1},{1,1,-1,-1,1,-1},{1,1,-1,-1,-1,-1},{1,1,-1,-1,-1,1},{1,-1,1,1,-1,-1},{1,-1,1,-1,1,-1},{1,-1,1,-1,-1,-1},{1,-1,1,-1,-1,1},{1,-1,-1,1,1,-1},{1,-1,-1,1,-1,-1},{1,-1,-1,1,-1,1},{1,-1,-1,-1,1,-1},{1,-1,-1,-1,1,1},{1,-1,-1,-1,-1,-1},{1,-1,-1,-1,-1,1},{-1,-1,1,1,1,-1},{-1,-1,1,1,-1,-1},{-1,-1,1,1,-1,1},{-1,-1,1,-1,1,-1},{-1,-1,1,-1,1,1},{-1,-1,1,-1,-1,-1},{-1,-1,1,-1,-1,1},{-1,-1,-1,-1,1,-1},{-1,-1,-1,-1,1,1},{-1,-1,-1,-1,-1,1},{-1,-1,-1,-1,-1,-1},{-1,-1,-1,1,-1,1},{-1,-1,-1,1,-1,-1},{-1,-1,-1,1,1,1},{-1,-1,-1,1,1,-1},{-1,1,-1,-1,-1,1},{-1,1,-1,-1,-1,-1},{-1,1,-1,-1,1,1},{-1,1,-1,-1,1,-1},{-1,1,-1,1,-1,1},{-1,1,-1,1,-1,-1},{-1,1,-1,1,1,-1},{-1,1,1,-1,-1,1},{-1,1,1,-1,-1,-1},{-1,1,1,-1,1,-1},{-1,1,1,1,-1,-1},{-1,-1,0,1,1,1},{-1,-1,1,0,1,1},{-1,-1,1,1,0,1},{-1,-1,1,1,1,0},{-1,0,1,1,1,-1},{-1,0,1,1,-1,1},{-1,0,1,-1,1,1},{-1,0,-1,1,1,1},{-1,1,-1,0,1,1},{-1,1,-1,1,0,1},{-1,1,-1,1,1,0},{-1,1,0,-1,1,1},{-1,1,1,-1,0,1},{-1,1,1,-1,1,0},{-1,1,0,1,-1,1},{-1,1,1,0,-1,1},{-1,1,1,1,-1,0},{-1,1,0,1,1,-1},{-1,1,1,0,1,-1},{-1,1,1,1,0,-1},{0,1,1,1,-1,-1},{0,1,1,-1,1,-1},{0,1,1,-1,-1,1},{0,1,-1,1,1,-1},{0,1,-1,1,-1,1},{0,1,-1,-1,1,1},{0,-1,1,1,1,-1},{0,-1,1,1,-1,1},{0,-1,1,-1,1,1},{0,-1,-1,1,1,1},{1,-1,-1,0,1,1},{1,-1,-1,1,0,1},{1,-1,-1,1,1,0},{1,-1,0,-1,1,1},{1,-1,1,-1,0,1},{1,-1,1,-1,1,0},{1,-1,0,1,-1,1},{1,-1,1,0,-1,1},{1,-1,1,1,-1,0},{1,-1,0,1,1,-1},{1,-1,1,0,1,-1},{1,-1,1,1,0,-1},{1,0,-1,-1,1,1},{1,1,-1,-1,0,1},{1,1,-1,-1,1,0},{1,0,-1,1,-1,1},{1,1,-1,0,-1,1},{1,1,-1,1,-1,0},{1,0,-1,1,1,-1},{1,1,-1,0,1,-1},{1,1,-1,1,0,-1},{1,0,1,-1,-1,1},{1,1,0,-1,-1,1},{1,1,1,-1,-1,0},{1,0,1,-1,1,-1},{1,1,0,-1,1,-1},{1,1,1,-1,0,-1},{1,0,1,1,-1,-1},{1,1,0,1,-1,-1},{1,1,1,0,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^6, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,-1,0,0,1,-1},{0,1,0,0,-1,0,1,-1},{0,0,1,0,0,-1,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-1,-1},{-1,-1,1},{-1,1,-1},{-1,1,1},{1,-1,1},{1,1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 7, vertices: 19, facets: 11
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1},{0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1},{0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0},{0,1,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0},{1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0,1},{1,1,1,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,0},{1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,0,0,1,0},{-1,0,0,0,0,0,0},{-1,-1,0,0,-1,-1,0},{0,-1,0,0,0,0,0},{0,0,0,0,1,0,0},{0,1,0,0,0,0,0},{0,0,0,0,-1,-1,0},{1,0,0,0,0,0,0},{0,0,-1,0,0,0,0},{0,0,0,-1,0,0,0},{1,1,1,1,1,1,0}};
ineqrhsPd = matrix {{1},{0},{-2},{0},{1},{1},{-1},{1},{0},{0},{3}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 7, vertices: 35, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,1},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,1,0,0,0,1,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,0,1,0,0},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,0,0}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0,0,0,0},{0,0,0,1,0,0,0},{0,0,0,0,0,1,0},{0,-1,0,0,0,0,0},{-1,0,0,0,0,0,0},{-1,-1,-1,-1,-1,-1,0},{0,0,0,0,1,0,0},{0,0,0,-1,0,0,0},{0,0,1,0,0,0,0},{0,0,0,0,-1,0,0},{0,0,0,0,0,-1,0},{1,1,1,1,1,1,0},{0,1,0,0,0,0,0},{1,0,0,0,0,0,0}};
ineqrhsPd = matrix {{0},{1},{1},{0},{0},{-2},{1},{0},{1},{0},{0},{3},{1},{1}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 7, vertices: 30, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0},{0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1},{1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,1,0,1,0},{1,1,1,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,0,1,1,0,1,0,0,1,0,0,0,0}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,0,0,1,0},{0,0,0,0,-1,0,0},{0,0,0,1,0,0,0},{-1,0,0,0,0,0,0},{-1,-1,-1,-1,-1,-1,0},{0,0,1,0,0,0,0},{0,-1,0,0,0,0,0},{0,0,0,0,1,0,0},{0,0,0,0,0,-1,0},{0,1,0,0,0,0,0},{0,0,-1,-1,-1,-1,0},{1,0,0,0,0,0,0},{0,0,-1,0,0,0,0},{1,1,1,1,1,1,0},{0,0,0,-1,0,0,0},{1,1,1,1,0,0,0}};
ineqrhsPd = matrix {{1},{0},{1},{0},{-2},{1},{0},{1},{0},{1},{-1},{1},{0},{3},{0},{2}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,1/2},{0,0,11/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{11,1},{0,-1},{-11,1}};
ineqrhsPd = matrix {{11},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2},{1/2,1/2,3/2,-1/2,1/2,1/2,1/2,1/2},{1/2,1/2,1/2,1/2,3/2,-1/2,1/2,1/2},{1/2,1/2,1/2,1/2,1/2,1/2,3/2,-1/2}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,1,1,-1},{-1,1,1,1},{-1,1,-1,-1},{-1,1,-1,1},{-1,-1,-1,-1},{-1,-1,-1,1},{-1,-1,1,1},{-1,-1,1,-1},{1,-1,-1,1},{1,-1,-1,-1},{1,-1,1,1},{1,-1,1,-1},{1,1,-1,1},{1,1,-1,-1},{1,1,1,1},{1,1,1,-1}};
ineqrhsPd = matrix {{1},{2},{0},{1},{-1},{0},{1},{0},{1},{0},{2},{1},{2},{1},{3},{2}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,1,0,1,0,1},{1,1,0,0,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{0,-1,0},{-1,0,0},{1,0,0},{0,1,0},{0,0,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,1},{0,0,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-1,0},{1,0},{0,1}};
ineqrhsPd = matrix {{0},{0},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,1/2},{0,0,5}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-10,1},{10,1}};
ineqrhsPd = matrix {{0},{0},{10}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 24, facets: 32
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,2/3,2/3,1/3,1/2,1/2,2/3,2/3,1/3,1/3,1/3,2/3,1/3,2/3,1/2,1/3,1/3,0,2/3,1/3,2/3,1/2,1/2,1/2},{1/2,1/3,2/3,2/3,0,1/2,1/3,2/3,1/3,2/3,1/3,1/3,1/3,1/3,1/2,2/3,1/3,1/2,2/3,2/3,2/3,1,1/2,1/2},{1/2,2/3,2/3,1/3,1/2,0,1/3,1/3,1/3,1/3,1/3,1/3,2/3,2/3,1/2,2/3,2/3,1/2,1/3,2/3,2/3,1/2,1,1/2},{1/2,2/3,1/3,2/3,1/2,1/2,2/3,1/3,2/3,1/3,1/3,1/3,1/3,1/3,0,1/3,2/3,1/2,2/3,2/3,2/3,1/2,1/2,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,-1,-1},{-1,0,-1,-1},{-1,-1,0,-1},{-1,-1,-1,0},{1,0,-1,-1},{1,-1,0,-1},{1,-1,-1,0},{0,1,-1,-1},{0,-1,1,-1},{0,-1,-1,1},{-1,1,0,-1},{-1,1,-1,0},{-1,0,1,-1},{-1,0,-1,1},{-1,-1,1,0},{-1,-1,0,1},{1,1,0,-1},{1,1,-1,0},{1,0,1,-1},{1,0,-1,1},{1,-1,1,0},{1,-1,0,1},{0,1,1,-1},{0,1,-1,1},{0,-1,1,1},{-1,1,1,0},{-1,1,0,1},{-1,0,1,1},{1,1,1,0},{1,1,0,1},{1,0,1,1},{0,1,1,1}};
ineqrhsPd = matrix {{-1},{-1},{-1},{-1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{2},{2},{2},{2}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3/2,-1/2,1/2,1/2},{1/2,1/2,3/2,-1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1},{-1,1},{1,1},{1,-1}};
ineqrhsPd = matrix {{0},{1},{2},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{0},{1},{0},{1},{0},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,0},{0,-1,0,0},{0,1,0,0},{0,0,-1,0},{0,0,1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 2, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,-1},{1/2,-1/2}};
eqrhsPd = matrix {{0},{1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 0, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^0, QQ^1, 0);
raysP = map(QQ^0, QQ^0, 0);
linealityP = map(QQ^0, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^1, QQ^0, 0);
ineqrhsPd = matrix {{1}};
eqlhsPd = map(QQ^0, QQ^0, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 2, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = matrix {{0},{1}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,0}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1,3/2,5/2,5/2},{0,1/2,5/2,5/2,0,1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-1,0},{-4,2},{0,1},{2,1},{1,0}};
ineqrhsPd = matrix {{0},{0},{1},{5/2},{11/2},{5/2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{5/3,-1/3,-1,1,1/3},{1/3,-5/3,1,-1,5/3}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-2},{-4,-1},{-1,2},{1,1},{2,-1}};
ineqrhsPd = matrix {{3},{3},{3},{2},{3}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 2, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,0},{0,-1}};
eqrhsPd = matrix {{-1},{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1},{-1},{-1}};
raysP = matrix {{1,0,0},{0,1,0},{0,0,1}};
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,15}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1},{-1}};
ineqrhsPd = matrix {{15},{0}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,0}};
raysP = matrix {{0},{1}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1}};
ineqrhsPd = matrix {{0},{1},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: -1, ambientDim: 1, vertices: 0, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^1, QQ^0, 0);
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^1, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: -1, ambientDim: 2, vertices: 0, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^2, QQ^0, 0);
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^2, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: -1, ambientDim: 1, vertices: 0, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^1, QQ^0, 0);
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^1, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 2, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0},{0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = matrix {{1},{1}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{1,-1}};
eqrhsPd = matrix {{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: -1, ambientDim: 2, vertices: 0, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^2, QQ^0, 0);
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^2, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 8, ambientDim: 9, vertices: 12, facets: 36
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,2,2,3,3,0,0,0,0,0,0},{2,3,1,3,1,2,0,0,0,0,0,0},{3,2,3,1,2,1,0,0,0,0,0,0},{1,0,0,0,0,0,1,0,0,0,0,0},{0,1,0,0,0,0,0,1,0,0,0,0},{0,0,1,0,0,0,0,0,1,0,0,0},{0,0,0,1,0,0,0,0,0,1,0,0},{0,0,0,0,1,0,0,0,0,0,1,0},{0,0,0,0,0,1,0,0,0,0,0,1}};
raysP = map(QQ^9, QQ^0, 0);
linealityP = map(QQ^9, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,1,1,1,1,1,0},{-5,1,7,-18,-12,-12,0,0,0},{1,-5,1,0,0,0,0,0,0},{-1,-7,5,0,0,-6,0,0,0},{-1,-1,2,-3,0,-3,0,0,0},{-7,-1,5,-6,0,0,0,0,0},{-5,1,1,0,0,0,0,0,0},{-1,-1,1,0,0,0,0,0,0},{-1,1,-1,0,0,0,0,0,0},{-7,5,-1,0,-6,0,0,0,0},{-2,1,1,-3,-3,0,0,0,0},{-5,7,1,-12,-18,0,-12,0,0},{-1,2,-1,0,-3,0,-3,0,0},{-1,5,-7,0,0,0,-6,0,0},{1,1,-5,0,0,0,0,0,0},{1,-1,-1,0,0,0,0,0,0},{5,-1,-7,6,6,6,6,6,0},{5,-7,-1,0,0,0,0,-6,0},{2,-1,-1,3,3,3,3,0,0},{1,1,-2,3,3,3,0,3,0},{7,1,-5,18,18,18,6,6,0},{1,-2,1,0,0,-3,0,-3,0},{7,-5,1,12,12,0,12,-6,0},{1,-5,7,-12,0,-18,0,-12,0},{-1,-1,5,-12,-6,-12,0,-6,0},{1,-1,1,0,2,-2,2,-2,0},{1,7,-5,12,0,12,-6,12,0},{-1,1,1,-4,-4,-2,-2,0,0},{-1,5,-1,0,-6,6,-6,6,0},{1,1,-1,4,2,4,0,2,0},{5,-1,-1,12,12,6,6,0,0},{0,0,0,0,0,0,0,-1,0},{0,0,0,0,0,0,-1,0,0},{0,0,0,-1,0,0,0,0,0},{0,0,0,0,-1,0,0,0,0},{0,0,0,0,0,-1,0,0,0}};
ineqrhsPd = matrix {{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{6},{0},{3},{3},{18},{0},{12},{0},{0},{2},{12},{0},{6},{4},{12},{0},{0},{0},{0},{0}};
eqlhsPd = matrix {{0,0,0,-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 10, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3330883453830711/4503599627370496,853624150927223/2251799813685248,-2356553346050111/18014398509481984,8539723551892617/9007199254740992,-851543628576541/1125899906842624,5316837853882195/9007199254740992,-6538305985494021/9007199254740992,-1749267935005635/4503599627370496,7424579411304029/9007199254740992,-6887392800778413/18014398509481984},{-2298030817950255/18014398509481984,7698990389472477/9007199254740992,5054138723166979/9007199254740992,-4611252879029533/72057594037927936,7431314160210763/36028797018963968,3306083656494553/4503599627370496,-5119504026856145/9007199254740992,3819013085252451/4503599627370496,4143898238679627/9007199254740992,-5765394822723937/9007199254740992},{-5952332624486941/9007199254740992,-1596589986555531/4503599627370496,-7361860108925987/9007199254740992,-1402721951416725/4503599627370496,-1397989901669917/2251799813685248,3023262654016433/9007199254740992,-6977355308041419/18014398509481984,3248144300909891/9007199254740992,-1486048987021867/4503599627370496,-6002567455236229/9007199254740992}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{51894724291563534050210877879505/44579928701577317537651253200841,1,-184914068801775237924440155455677/89159857403154635075302506401682},{1,15701373045711447922845966302445/15404771123625084781539131855594,-26933806422179042513723576438601/15404771123625084781539131855594},{21859749371173593885550183008062/2404747912716946201299872316723,24507876296948960756894875847431/2404747912716946201299872316723,-1},{1,55228066624563312478254429271949/6621599294598900589652414097938,7629217969444610664921388076327/6621599294598900589652414097938},{-1,-120142383507582197243199728437381/8084188145793725279203688369944,115580771581373778595914316892651/4042094072896862639601844184972},{-307888710630698160800930201114164/175792615486297400307821108914777,445367236960222658287647234346636/175792615486297400307821108914777,-1},{-29609553812244423504592728106921/7297571300091599151751392189772,-1,-214868202830604470995803376144337/14595142600183198303502784379544},{-151189885071826254692495399928433/57582004016524483838099502969478,-1,-171320946886386780877737144372595/57582004016524483838099502969478},{-53700167453247199213158679994849/3307137770655639630104724597440,1,98822397682530192523626532018309/18189257738606017965575985285920},{-1,116803526287883759434174588839635/34580975135927942243574654312938,-36007901243263107943040099596727/34580975135927942243574654312938},{1,-13850085013344855522773355887391/6818528060217462587852947510909,-197756724530638510637354434024943/13637056120434925175705895021818},{1036135618271528606489034912963057307981344407552/581537443638615074354745762480279589568458618937,-4327653905728583935255115385385967640039770816512/581537443638615074354745762480279589568458618937,5910231771534213223026164067443076355213980860416/581537443638615074354745762480279589568458618937},{1054880121932942658506222715788325980197860933632/534035911503027033021959037060208471395088331547,-1281627460961420112686943019512565527775396495360/178011970501009011007319679020069490465029443849,762141108438165580312953028897043765493543993344/178011970501009011007319679020069490465029443849},{231975478494261133288862020400920/46126130931291503571272729738481,-169100958277387977102335510026312/15375376977097167857090909912827,-1},{10937629307262539547157488890951/2680744756838196321854157910496,1,9595609196525214890978161704275/9382606648933687126489552686736},{119597613426197722851154758944867/25570123189749367929383738810624,1,-6911323054769947339261622162401/2324556653613578902671248982784}};
ineqrhsPd = matrix {{844822554186341186269726002874502975268217280911/401540300577253773676892664419639444784411574272},{259488750129937520885302663064968598812539952375/138753842984171417584403220243956156918816309248},{271004736937658571397159379076252143550481633717/21660043607264033902846299161076252312355209216},{423448316443658173490576444001806454714909083095/59642064231504695724840812927973958165511274496},{-34630449549038960368831490461075377896727262675/18203973360494801078813096920473943068599386112},{3907886527366795718565487502314225730876766478645/1583399115197147713009168145831525123113336438784},{788920134410405211829833976643041257432385113137/65730678775604303964119646763830352431571533824},{3762001182033049909826590173319852249022590795111/1037305167328264277638954820505228106547542884352},{93325951612417297252353420723381015737315530589/10239641796716496655605735175750105074541527040},{896172313316093959034626764131762762974160675273/311477733472546935902002230399753906396904554496},{81236788406770564894193769464202668062514900579/7676980107802658855434829539982379117986185216},{-1},{1},{800941153401737356903768825435157970937740883067/138489084049471416744915206981758066949183504384},{589174034570303102921008420525643417063558720297/169022015231606766094385546579987883038787764224},{1219874388473548040026806220057750201529214825065/230315194538345863983135500535513255463257899008}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 19, facets: 34
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3/32,7/64,3/4,-3/16,-5/32,-3/4,-1/4,1/64,-7/8,-1,5/8,5/32,-3/4,3/64,-7/32,-3/8,3/8,-1,-1/32},{5/8,5/8,3/8,-1/2,1,1/2,-3/32,-1/4,7/256,-1/4,-3/4,-7/128,5/8,-3/8,-7/128,-7/8,5/8,3/16,1},{-3/4,-3/4,-5/8,-3/4,1/4,1/4,1,1,-1/2,-3/16,3/8,-1,7/256,7/8,1,-3/8,3/4,5/64,5/16}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{344/37,-1,365/37},{1,-29/8,31/8},{1,-604/449,-917/898},{1,-11/7,-15/14},{-1,-239/56,229/112},{0,1,-87/32},{-327/232,1,-1425/464},{-249/88,-1,-363/64},{-1,1330/597,-216/199},{-1,35528/30447,-216/199},{0,0,1},{-1,19/16,2437/1536},{-3/2,57/32,1},{-5/4,1,13/8},{-1013/704,-1,-515/352},{-3447/544,1,-28/17},{-373/128,57/32,1},{-17109/6208,283/194,-1},{-53/16,1,3},{-979/408,-1,28/17},{-73/58,-226/145,1},{-199/144,-1,-487/288},{-1,40/27,2},{-592/547,-868/547,1},{-1,-17/10,29/20},{1,145/24,-2},{0,8/3,-1},{-1,740/417,681/278},{1,6/5,451/80},{32/21,143/42,-1},{16,37/2,1},{1,170/151,-3471/1208},{872/629,-656/629,-1},{115/13,1,29/13}};
ineqrhsPd = matrix {{3037/296},{307/64},{8987/7184},{157/112},{2995/896},{341/128},{20759/7424},{14881/2816},{40361/19104},{1412371/974304},{1},{10693/6144},{145/64},{59/32},{11057/5632},{3479/544},{1703/512},{9161/3104},{239/64},{955/408},{3389/2320},{519/256},{1847/864},{6211/4376},{119/64},{517/96},{29/12},{4289/1668},{1713/320},{341/112},{293/16},{28683/9664},{377/296},{73/13}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,0,1,1,1,1,0,0,1,1,0,0,1},{0,0,2,0,2,2,0,0,2,2,2,2,2,0,0,0},{0,4,4,0,0,4,4,0,0,4,0,4,0,4,0,4},{0,0,8,8,0,8,0,8,0,0,8,0,8,8,0,8}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{0},{8},{4},{2},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 72, facets: 68
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,4,5,-1,1,4,3,2,5,0,-5,0,-2,1,-3,4,-7,-3,-2,-4,5,-9,-4,2,5,-11,2,-1,-10,-12,2,-7,0,3,-2,-4,0,0,-9,-12,0,-12,-3,-6,2,-1,-7,-6,-7,-9,-4,-4,-1,-11,-9,-12,-9,-11,-3,-5,-8,-6,-7,-10,-5,-3,-8,-4,-7,-3,-6,-9},{-2,0,1,-4,-1,3,4,-3,-1,6,-3,-3,-3,1,-4,2,-3,7,-1,-4,2,-1,7,-2,0,0,5,7,-1,1,4,-1,-2,0,6,-1,0,4,6,4,2,2,-3,-4,4,6,6,7,1,5,6,1,3,3,-2,3,5,1,-2,6,4,-3,5,3,4,4,2,5,3,2,0,-1},{0,-1,0,0,-3,0,0,2,2,1,-1,4,-3,-5,2,-3,1,0,-5,2,3,-2,0,5,5,2,-3,-2,2,-1,4,-4,7,7,3,-6,9,6,0,0,8,2,6,4,-6,-5,-2,2,-6,2,-4,-8,-8,3,5,-3,-3,5,9,5,5,7,-5,-5,7,8,7,-7,-7,10,10,8}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{2,-1,-1},{5/4,-7/4,-1},{4/3,-2,-1},{1,-1,-1},{7/5,-1,-8/5},{7,10,1},{5/3,3,-1},{1,3,-3},{6/5,-9/5,-1},{1,-3/2,-3/2},{1,-3/2,-5/3},{1,4,1},{1,-9/2,3/2},{-1,9,-3},{0,1,0},{-1,6,-3/2},{-1,3/2,-6},{1,11/2,3/2},{-1,-13/4,-3/2},{-1,2,2},{1,-9,3},{-1,-3,3},{-1,9/2,-3/2},{-1,-3/2,-3/2},{-4/3,-1,-2},{-1,-4,-1},{-4/3,2,1},{-5/3,-3,1},{-1,3,-1},{-1,1,1},{-5/4,7/4,1},{-2,3,-1},{-2,1,1},{-1,0,0},{-6,-3,1},{-1,-1,0},{-9/2,-3,1},{-4,-11/2,-1},{-1,-1,-1},{-1,3/2,-1},{-7,-10,-1},{-7/5,1,8/5},{-1,-5/2,-1},{-6/5,9/5,1},{-1,3/2,3/2},{-1,3/2,-3/2},{-1,5,-1},{-1,3/2,5/3},{1,-2,-2},{0,-1,0},{-1,-11/2,-3/2},{1,-6,3/2},{1,-3/2,6},{1,13/4,3/2},{1,3/2,3/2},{1,-5,1},{1,-3,1},{1,5/2,1},{1,-3/2,3/2},{4/3,1,2},{9/2,3,-1},{1,-3/2,1},{2,-3,1},{1,1,1},{1,1,0},{4,11/2,1},{6,3,-1},{1,0,0}};
ineqrhsPd = matrix {{9},{6},{20/3},{5},{42/5},{61},{64/3},{32},{6},{7},{47/6},{25},{39/2},{70},{7},{46},{107/2},{71/2},{65/4},{27},{42},{36},{37},{29/2},{61/3},{18},{24},{26},{27},{17},{22},{36},{28},{12},{68},{11},{103/2},{87/2},{12},{39/2},{78},{122/5},{27/2},{109/5},{43/2},{22},{39},{68/3},{10},{4},{23},{24},{54},{22},{15},{19},{13},{16},{27/2},{18},{27},{10},{15},{10},{7},{34},{33},{5}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1/2,-1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2},{-1,-1,1,1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1},{-2,-2,-2,-2,2,2,2,2,2,-2,-2,-2,-2,2,2,2},{-4,-4,-4,-4,-4,4,4,4,4,4,4,4,4,-4,-4,-4}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{-2,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0},{2,0,0,0}};
ineqrhsPd = matrix {{4},{1},{1},{2},{4},{2},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,1,-1,0,0},{1,-1,0,0,1,-1},{0,0,-1,1,-1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0},{-1,-1,0},{-1,0,0},{0,1,0},{1,1,0},{1,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = matrix {{-1,-1,-1}};
eqrhsPd = matrix {{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 12, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,2,0,2,0,2,0,2,0,2,0,2},{0,0,2,2,4,4,0,0,2,2,4,4},{0,0,2,2,0,0,-2,-2,-4,-4,-2,-2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1,-1},{0,-1,-1},{-1,0,0},{0,-1,0},{0,-1,1},{0,1,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{6},{2},{0},{0},{0},{4},{4},{2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-7/2,7/2,-3/2,3/2},{-5,5,-2,2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-6,4},{14,-10},{6,-4},{-14,10}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,-1,1},{-3/2,3/2,-7/2,7/2},{-2,2,-5,5}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{2,-1,0},{-5,1,0},{-2,1,0},{5,-1,0}};
ineqrhsPd = matrix {{3/2},{3/2},{3/2},{3/2}};
eqlhsPd = matrix {{1/3,4/3,-1}};
eqrhsPd = matrix {{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,2,2,0,1,0},{-1,-1,0,1,1,0},{0,-1,-2,-1,-2,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0},{-1,-1,0},{-1,0,0},{0,1,0},{1,1,0},{1,0,0}};
ineqrhsPd = matrix {{1},{0},{0},{1},{2},{2}};
eqlhsPd = matrix {{-1,-1,-1}};
eqrhsPd = matrix {{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 5, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0,0},{1,0,0,0,0},{0,0,1,0,2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{2,2,1},{-1,0,0},{0,-1,0}};
ineqrhsPd = matrix {{0},{2},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0},{1,0,0,0},{0,0,1,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,0,0},{0,-1,0},{0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 27, facets: 9
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-4/29,-1/2,0,1/19,1/12,19/30,-7/12,1/2,2/3,1/6,4/29,3/19,2/3,2/29,0,0,1/2,7/12,-1/19,-2/29,-19/30,-1/12,-1/2,-2/3,-1/6,-2/3,-3/19},{2/29,-1/2,0,3/19,1/6,2/3,2/3,1/2,-19/30,-1/12,-2/29,-1/19,7/12,4/29,0,0,-1/2,-2/3,-3/19,-4/29,-2/3,-1/6,1/2,19/30,1/12,-7/12,1/19},{-5/29,2,1,3/19,1/4,19/10,-7/4,2,-19/10,-1/4,-5/29,-3/19,7/4,5/29,0,-1,-2,-7/4,3/19,5/29,19/10,1/4,-2,-19/10,-1/4,7/4,-3/19},{8/29,-1/2,0,5/19,1/4,-1/2,-1/2,-1/2,-1/2,1/4,8/29,5/19,-1/2,8/29,1/3,0,-1/2,-1/2,5/19,8/29,-1/2,1/4,-1/2,-1/2,1/4,-1/2,5/19}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-3,3,1,2},{3,-3,1,2},{2,-1,1,3},{-2,1,1,3},{3,3,-1,2},{-3,-3,-1,2},{-1,-2,-1,3},{1,2,-1,3},{0,0,0,-2}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 4, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0},{0,1},{0,1},{1,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0,0},{-1,0,0,0}};
ineqrhsPd = matrix {{1},{0}};
eqlhsPd = matrix {{-1,-1,0,0},{-1/2,1/2,-1,0},{1/3,-1/3,-1/3,-1}};
eqrhsPd = matrix {{-1},{-1/2},{-2/3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,1,1,-1,-1,-1,-1},{-1,-1,1,1,1,1,-1,-1},{-1,1,1,-1,1,-1,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,2,2,1,0},{0,0,2,2,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-1,1},{-1,0},{0,1},{1,0}};
ineqrhsPd = matrix {{0},{1},{0},{2},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,2,1},{0,0,1,1,1,2},{0,0,0,3,3,3}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-3,0,1},{0,0,-1},{0,0,1},{0,-3,1},{3/2,3/2,-1}};
ineqrhsPd = matrix {{0},{0},{3},{0},{3/2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,5/2,0},{0,0,5/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{5/2},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 9, vertices: 6, facets: 9
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,1,0,0},{0,1,0,0,1,0},{0,0,1,0,0,1},{0,1,1,0,0,0},{1,0,0,0,0,1},{0,0,0,1,1,0},{0,0,0,0,1,1},{0,0,1,1,0,0},{1,1,0,0,0,0}};
raysP = map(QQ^9, QQ^0, 0);
linealityP = map(QQ^9, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1,0,-1,-1,0,0,0,0},{-1,0,0,0,0,0,0,0,0},{0,0,0,0,-1,0,0,0,0},{1,0,0,1,0,0,0,0,0},{1,1,0,0,0,0,0,0,0},{0,0,0,1,1,0,0,0,0},{0,1,0,0,1,0,0,0,0},{0,-1,0,0,0,0,0,0,0},{0,0,0,-1,0,0,0,0,0}};
ineqrhsPd = matrix {{-1},{0},{0},{1},{1},{1},{1},{0},{0}};
eqlhsPd = matrix {{-1,-1,-1,0,0,0,0,0,0},{0,0,0,-1,-1,-1,0,0,0},{-2/3,1/3,1/3,-2/3,1/3,1/3,-1,0,0},{1/7,-4/7,3/7,1/7,-4/7,3/7,-2/7,-1,0},{1/5,1/5,-2/5,1/5,1/5,-2/5,-2/5,-2/5,-1}};
eqrhsPd = matrix {{-1},{-1},{-1/3},{-3/7},{-3/5}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,5/2,0},{0,0,5/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{5/2},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 2, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1},{0},{0}};
raysP = matrix {{1},{0},{0}};
linealityP = matrix {{0,0},{1,0},{0,1}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1/2,1/2,-1/2,1/2},{-1/2,-1/2,1/2,1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-2},{-2,0},{0,2},{2,0}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,0,-1,-1},{0,1,1,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-2},{-1,1},{-1,0},{0,1},{1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 2, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,3},{2,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{2,1}};
ineqrhsPd = matrix {{0},{5}};
eqlhsPd = matrix {{-1,-1}};
eqrhsPd = matrix {{-2}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,0,-1,-1},{0,1,1,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-2},{-1,1},{-1,0},{0,1},{1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,0,-1},{0,1,1,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-2,1},{1,-2},{1,0},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,4}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1},{-1}};
ineqrhsPd = matrix {{4},{-1}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,0,0},{0,1,0,0,0,0},{0,0,1,0,0,0},{0,0,0,1,0,0},{0,0,0,0,1,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1,1},{-1,0,0,0,0},{0,-1,0,0,0},{0,0,-1,0,0},{0,0,0,-1,0},{0,0,0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^5, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1},{0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{0},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,1,1,-1},{-1,1,1,1},{-1,1,-1,-1},{-1,1,-1,1},{-1,-1,-1,-1},{-1,-1,-1,1},{-1,-1,1,1},{-1,-1,1,-1},{1,-1,-1,1},{1,-1,-1,-1},{1,-1,1,1},{1,-1,1,-1},{1,1,-1,1},{1,1,-1,-1},{1,1,1,1},{1,1,1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,2,1,0},{0,0,1,3,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-2,1},{-1,0},{0,-1},{1,-1},{2,1}};
ineqrhsPd = matrix {{1},{0},{0},{1},{5}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3,5/3,1},{3,1,5/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-9,-4},{3,-2},{-1,4}};
ineqrhsPd = matrix {{-19},{3},{9}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 5, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3,1,5/3},{3,5/2,1},{0,0,0},{2,4,1},{3,5,2}};
raysP = matrix {{0},{0},{1},{0},{0}};
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1,0,0,-2},{0,0,-1,0,0},{0,-2,0,0,1},{0,4/15,0,0,1/15}};
ineqrhsPd = matrix {{-3},{0},{0},{1}};
eqlhsPd = matrix {{-27/20,7/5,0,-1,0},{-540/1913,560/1913,0,1513/1913,-1}};
eqrhsPd = matrix {{-37/20},{-2653/1913}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0},{0,1,0},{0,0,1},{-1,0,0},{0,0,-1},{0,-1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 12, facets: 20
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,910872158600853/1125899906842624,-910872158600853/1125899906842624,1/2,-1/2,1/2,-1/2,910872158600853/1125899906842624,-910872158600853/1125899906842624,0,0},{910872158600853/1125899906842624,910872158600853/1125899906842624,1/2,1/2,0,0,0,0,-1/2,-1/2,-910872158600853/1125899906842624,-910872158600853/1125899906842624},{1/2,-1/2,0,0,910872158600853/1125899906842624,910872158600853/1125899906842624,-910872158600853/1125899906842624,-910872158600853/1125899906842624,0,0,1/2,-1/2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{391725578400125525240351555584/829688089314177501862572327609,-1125899906842624/910872158600853,0},{-391725578400125525240351555584/829688089314177501862572327609,-1125899906842624/910872158600853,0},{-1125899906842624/1473822112022165,-1125899906842624/1473822112022165,-1125899906842624/1473822112022165},{0,-391725578400125525240351555584/829688089314177501862572327609,-1125899906842624/910872158600853},{1125899906842624/1473822112022165,-1125899906842624/1473822112022165,-1125899906842624/1473822112022165},{1125899906842624/910872158600853,0,391725578400125525240351555584/829688089314177501862572327609},{1125899906842624/910872158600853,0,-391725578400125525240351555584/829688089314177501862572327609},{1125899906842624/1473822112022165,1125899906842624/1473822112022165,-1125899906842624/1473822112022165},{1125899906842624/1473822112022165,1125899906842624/1473822112022165,1125899906842624/1473822112022165},{391725578400125525240351555584/829688089314177501862572327609,1125899906842624/910872158600853,0},{0,391725578400125525240351555584/829688089314177501862572327609,1125899906842624/910872158600853},{-391725578400125525240351555584/829688089314177501862572327609,1125899906842624/910872158600853,0},{-1125899906842624/1473822112022165,1125899906842624/1473822112022165,1125899906842624/1473822112022165},{-1125899906842624/1473822112022165,1125899906842624/1473822112022165,-1125899906842624/1473822112022165},{0,391725578400125525240351555584/829688089314177501862572327609,-1125899906842624/910872158600853},{-1125899906842624/910872158600853,0,-391725578400125525240351555584/829688089314177501862572327609},{-1125899906842624/910872158600853,0,391725578400125525240351555584/829688089314177501862572327609},{-1125899906842624/1473822112022165,-1125899906842624/1473822112022165,1125899906842624/1473822112022165},{1125899906842624/1473822112022165,-1125899906842624/1473822112022165,1125899906842624/1473822112022165},{0,-391725578400125525240351555584/829688089314177501862572327609,1125899906842624/910872158600853}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992},{-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992,-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992},{-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,-5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992,5200308914369309/9007199254740992}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-9007199254740992/5200308914369309},{-9007199254740992/5200308914369309,0,0},{0,-9007199254740992/5200308914369309,0},{0,0,9007199254740992/5200308914369309},{0,9007199254740992/5200308914369309,0},{9007199254740992/5200308914369309,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,-2,2,-2,2,-2,2,-2},{-2,-2,2,2,-2,-2,2,2},{-2,-2,-2,-2,2,2,2,2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{2},{2},{2},{2},{2},{2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,1,0,1,0,1},{3/4,1,0,1/4,0,1/4,1,3/4},{3/16,1/4,0,1/16,1,15/16,3/4,13/16}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{1/4,-1,0},{1/4,1,0},{0,1/4,-1},{0,1/4,1}};
ineqrhsPd = matrix {{0},{1},{0},{1},{0},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0},{0,1,1,-1,0,0},{0,0,0,0,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1,1},{-2,-1,1},{-2,-1,-1},{0,1,-1},{1,1,-1},{1,1,1},{1,-1,1},{1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,0,1,1,0,0,-4},{1,0,1,-2,1,1,-3,1},{0,0,-1,1,1,1,1,-3}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-1,-2},{1,0,0},{1,0,-1},{0,1,0},{0,0,1},{-1,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0},{1,0,0,0},{0,0,1,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,0,0},{0,-1,0},{0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,0},{0,-1,0,0},{0,1,0,0},{0,0,-1,0},{0,0,1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,0},{0,-1,0,0},{0,1,0,0},{0,0,-1,0},{0,0,1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 34, facets: 19
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-593934448380038187629003561336244223315615416320/581295835759584558808312033228316509435714702879,-779973149963902010794106307206482951439877406720/1148181310580490847889443245285958332842937431117,-834911336348711971508916753479457864880196943872/1033279699092212080961238485377359834950104619125,-451351638156153469675449537298017167288402182144/661074666395213201954148779083788761647422101087,-11875211446039377815154684977628597209263677374464/28146830865538587708960983240939498061618358464803,-1066404108435779557262026998475926048840047656960/2663035629934843887354436756168725949136781115679,-286667771360306766448084578481195066846882037760/1070022436834922326869526480917927343294110940591,-101857867966402892552331775300708148248320147456/313078221326677069773728886384385920072137617303,-247647508815704899421824604945096989996604194816/4715350869261984712862393959738846535578964133343,-231354719769776038518069933565989679675543126016/448263694500983649316778464851002479369071878087,1173995576268867024101222385236247095587712794624/1063363920455119185533336766028459859555986812289,10919588709302286410864254853031789456928047890432/201086830318867823857028347393140421252269033251,7737382246988530702401719335728566856035340386304/302903591957417203012304489947529736347874762775,-208965238551936641108002108112096334628087922688/969015032110259826352173485095262980905288420413,-859290202182082173684458899037542304891078180864/5007207875503957243795218944333844953080912307477,-10197621225091634689632545083717720162533638144/34796618359701895270882545993358473009022808147,-164860432541172988012500288848677826630810337280/369527502856320347152283004429443120261713839807,-4788459856255095265270714418435572229295055044608/17794019300086801999024109977398818324480077290739,-121768151542727502417327058247524448316084453376/214725024102500251121085398955994353664526185507,-4695507374188243411505217745040521455703542464512/8239742805158896400827962926559115961918687751871,-85837091223178700317543387027914465534606835712/134535282588166625496077801426867389035530698279,-580435442581073966343298317053478125353981444096/601721064087771031599502474452759076861582344741,-4399086184007617290603389456832361923188004749312/5587846899827315228018162025780624481889822155377,-8946398221587728817626161242544128840325987827712/11324914804645713522973305338138304500811523904485,-2380243102799262291488880640371567860996900913152/2500718746193551593444075481086648309079292861499,-2101645623657309528239208136369819998420526432256/2575644869312600520837378718018929479143740845201,-1478893849222614588217813826634995473583454552064/1537865163739176575553792502864197330470575328727,-1650966813993801114766861815173619324152071585792/1477194555638248894623263976557986753178854006673},{-22818873475658756052383747193627849323869896704/581295835759584558808312033228316509435714702879,976998916289555033383810311596041748929302233088/1148181310580490847889443245285958332842937431117,7586383608487890572942933955429067934453511225344/9299517291829908728651146368396238514550941572125,1714126851978983796318065960745923606019303276544/1983223999185639605862446337251366284942266303261,9175789268262439599570487075487982327846387318784/28146830865538587708960983240939498061618358464803,2118822138322137696317075292329089245204883439616/2663035629934843887354436756168725949136781115679,-1035135536219048502230860487599639901808833331200/1070022436834922326869526480917927343294110940591,-2151310265872916459076542960878097013057267957760/2191547549286739488416102204690701440504963321121,-4629211660552619529874925514650714422269913858048/4715350869261984712862393959738846535578964133343,-30783432736003875979750701542967690016264814592/64037670642997664188111209264428925624153125441,-293529744116052320987137638985152910776380424192/1063363920455119185533336766028459859555986812289,1818696859734868465859909813538812606321256300544/201086830318867823857028347393140421252269033251,-8797965056266683176252475579552797508633440026624/2726132327616754827110740409527767627130872864975,950884402381782865481050691257735479637701558272/969015032110259826352173485095262980905288420413,4910313066152228029763916645661983662521781846016/5007207875503957243795218944333844953080912307477,200489647855657583570731698405731449071592275968/521949275395528429063238189900377095135342122205,-264064968691283956425736981033314113190331678720/369527502856320347152283004429443120261713839807,3237718166968952441032952974617210505523697287168/17794019300086801999024109977398818324480077290739,-690405230055092879748857330835757135958038806528/1503075168717501757847597792691960475651683298549,-3750862582827464504403021450241614596972344246272/8239742805158896400827962926559115961918687751871,-103079032796038331763922255286326302856768913408/134535282588166625496077801426867389035530698279,-399722854162767122647551157340747551288997183488/6618931704965481347594527218980349845477405792151,-4191403943173474617574437652497846669758179573760/5587846899827315228018162025780624481889822155377,-8544545583914319080093878921340161755887043608576/11324914804645713522973305338138304500811523904485,-1570702742277753177347654238016256171368196866048/2500718746193551593444075481086648309079292861499,3067136313122161735618404786018771451266004418560/7726934607937801562512136154056788437431222535603,8017251242771651453532827175785619515969990819840/13840786473652589179984132525777775974235177958543,-210009175232972847106184266082692189666278375424/1477194555638248894623263976557986753178854006673},{292015572736985309319079896593271243862274211840/581295835759584558808312033228316509435714702879,406448713537773738248476345065189171331470458880/1148181310580490847889443245285958332842937431117,-2419017046828958004959018541626998047413981151232/9299517291829908728651146368396238514550941572125,605841361880050239986422753184209142956366495744/1983223999185639605862446337251366284942266303261,26376580871057029152502082943918053696927447384064/28146830865538587708960983240939498061618358464803,1829625818811552520540966823773129831638487793664/2663035629934843887354436756168725949136781115679,355357895910219463637798838165319385714427691008/1070022436834922326869526480917927343294110940591,-400465054874798630522403667777820192393459138560/2191547549286739488416102204690701440504963321121,2282559012109495953069810963444182641650457116672/4715350869261984712862393959738846535578964133343,361986275197950306925085973513804365362903384064/448263694500983649316778464851002479369071878087,4294441423989885021499182554914770621993064595456/3190091761365357556600010298085379578667960436867,-122506588092093177848048518135056155612152856576/201086830318867823857028347393140421252269033251,470849944371399163319599630506760597200342876160/109045293104670193084429616381110705085234914599,127886593915226235025779439534246475699425640448/969015032110259826352173485095262980905288420413,-1505216801932142153130468954670392960833913094144/5007207875503957243795218944333844953080912307477,-613844172024470845003066640846993936060801613824/521949275395528429063238189900377095135342122205,-254819809966568204935607306891143779378352095232/369527502856320347152283004429443120261713839807,127281167770811709473005771620679312072431894528/124433701399208405587581188653138589681678862173,1197126379723621998890849251275759964883179798528/1503075168717501757847597792691960475651683298549,6562719208971136758614765103246540865130763124736/8239742805158896400827962926559115961918687751871,42417100986611552576579593815379552102260932608/134535282588166625496077801426867389035530698279,3814345438454256446950114483520119135859390808064/6618931704965481347594527218980349845477405792151,-2796281770744980650596513001246509959046460604416/5587846899827315228018162025780624481889822155377,-1110906015150491879853805652350360710054221447168/2264982960929142704594661067627660900162304780897,-162999463660340098562820645803440974937427279872/2500718746193551593444075481086648309079292861499,-7039471309045169588769443884563022662595116007424/7726934607937801562512136154056788437431222535603,-7720896340977146716264447239622474994632773074944/13840786473652589179984132525777775974235177958543,319771745064582453583006035182977561718765387776/1477194555638248894623263976557986753178854006673}};
raysP = matrix {{1,1,1,1,1,1},{251112891175366054364274580161127/1742729142036330334599966324909420,-34025299559200432416283693893587/344714124034586031771472840661500,-166072625277962181545693392506793/1856806596362728607273125232693112,128406741685128773958560033805701/869050463315085459389094472964712,6841838086192401798777624145777/204686637756790519442275767776536,2131537604361729521355148099871/57850743173374257358441466703168},{-28909925018099237201050958950312/118822441502477068268179522152915,-11929325663257510348818223910588/86178531008646507942868210165375,24333199372073205901955950761380/232100824545341075909140654086639,-7193367473035672524891855261596/325893923743157047270910427361767,-1842628407698070068212035118957/4498607423226165262467599291792,-47544614283236920077152578537201/115701486346748514716882933406336}};
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-4741371086824893/9007199254740992,-7647497920718555/144115188075855872,7643335962122821/9007199254740992},{-1078387572567719/2251799813685248,-1969043944499017/2251799813685248,1398252369236353/18014398509481984},{-4545080756734037/18014398509481984,8712378752251247/9007199254740992,-3907903642428347/144115188075855872},{-3812755930250863/9007199254740992,-6613900702997815/9007199254740992,597505859304803/1125899906842624},{-528415934779725/562949953421312,-4929203444735165/36028797018963968,-5702589786781073/18014398509481984},{-7844636121648267/18014398509481984,-5639193008728887/18014398509481984,-475143625477287/562949953421312},{-8197550089758337/9007199254740992,1703653972479579/4503599627370496,3046350937582833/18014398509481984},{-3615904728084257/72057594037927936,4243949184108969/9007199254740992,7931849752919691/9007199254740992},{-3034309338522589/18014398509481984,-5763735044348673/9007199254740992,6753313147092495/9007199254740992},{-5164178031720289/18014398509481984,-7125750769402285/36028797018963968,8443277472466113/9007199254740992},{-8820475294483955/36028797018963968,7356267017525943/9007199254740992,-2353318133783607/4503599627370496},{-5322465915783559/36028797018963968,-8008288277152163/9007199254740992,-1951052092499811/4503599627370496},{-6143462652402181/9007199254740992,1656098959042419/4503599627370496,5693579717943775/9007199254740992},{-781114321112795/2251799813685248,-6104924401936087/18014398509481984,-7877174595240857/9007199254740992},{-6725670116260403/9007199254740992,-4552485229651157/9007199254740992,7789705549160769/18014398509481984},{-2639153864504731/18014398509481984,8908792931407259/9007199254740992,-4720801535434569/288230376151711744},{-3349280896922509/36028797018963968,-560106062785759/562949953421312,5461605447630899/144115188075855872},{-4940367677971645/36028797018963968,2144252301938057/2251799813685248,4914915834536135/18014398509481984},{0,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0,1,0},{0,0,1,0,0,1},{0,0,0,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{0,0,-1},{0,0,1},{0,-1,0},{1,1,0}};
ineqrhsPd = matrix {{0},{0},{1},{0},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 5, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,3,0,0,1},{0,0,3,0,1},{0,0,0,3,-5}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-5,0,-1},{-1,0,0},{1,1,1},{5,5,-1},{0,-1,0},{0,-5,-1}};
ineqrhsPd = matrix {{0},{0},{3},{15},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 10, facets: 12
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,1},{-1,-1,-1,-1,1,1,1,1,-1,1},{0,0,0,0,0,0,0,0,2,-2}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,1},{0,-1,0,0},{0,1,0,1},{0,0,-1,0},{0,0,1,1},{-1,0,0,-1},{1,0,0,0},{0,-1,0,-1},{0,1,0,0},{0,0,-1,-1},{0,0,1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,3,0},{0,0,3}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{3},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 5, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,3,0,1,1},{0,0,3,1,1},{0,0,0,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,-1},{-1,0,1},{1,1,1},{1,1,-1},{0,-1,1},{0,-1,-1}};
ineqrhsPd = matrix {{0},{0},{3},{3},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 5, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1/2,-1/2,3/4,2,100},{2/3,2/3,2/3,3,200},{3/4,-3/4,1/2,4,300}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-3/2,0},{28/25,27/25,-28/25},{28/3,-19,28/3},{121/20,-753/50,401/50},{1,3294/2941,-3166/2941},{-299/100,-3/2,299/150}};
ineqrhsPd = matrix {{-1},{1},{-1},{-1},{3100/2941},{-1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1},{-1,1,1,1},{1,-1,1,1},{-1,-1,1,1},{1,1,-1,1},{-1,1,-1,1},{1,-1,-1,1},{-1,-1,-1,1},{1,1,1,-1},{-1,1,1,-1},{1,-1,1,-1},{-1,-1,1,-1},{1,1,-1,-1},{-1,1,-1,-1},{1,-1,-1,-1},{-1,-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 10, facets: 7
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1,1,1,1,-1,-1,-1,-1},{1,0,1,-1,0,1,1,-3,-1,1},{-1,-1,1,1,0,0,1,1,-1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-1,-1},{1,0,0},{1,0,-1},{0,1,0},{0,0,-1},{0,0,1},{-1,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,1,0,-1,-1},{1,1,0,-1,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-1},{0,-1},{-1,0},{-1,1},{0,1},{1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,-1,1,-1,1,-1,-1},{1,-1,1,1,-1,-1,1,-1},{1,-1,-1,-1,1,1,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 10, facets: 9
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,1,1,0,0,1,1,0,1},{1,1,1,0,0,0,0,1,0,1},{0,0,1,0,1,1,0,0,0,0},{0,0,1,0,1,1,0,1,1,1},{0,1,1,1,0,1,0,0,1,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0,0},{-1,0,-1,0,-1},{-1,0,0,-1,0},{1,0,1,0,-1},{0,0,1,-1,0},{1,0,0,0,0},{0,0,0,0,1},{1,-1,0,1,0},{-1,1,0,0,0}};
ineqrhsPd = matrix {{0},{-1},{-1},{1},{0},{1},{1},{1},{0}};
eqlhsPd = map(QQ^0, QQ^5, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,-1,0,0},{0,1,0,0,-1,0},{0,0,1,0,0,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 10, facets: 9
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,1,0,1,1,1,0,1,1},{1,0,0,0,1,1,0,0,1,1},{0,1,0,0,0,0,0,1,0,1},{1,1,0,1,0,1,0,1,0,1},{0,0,0,1,0,1,1,1,1,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0,0},{-1,0,-1,0,-1},{-1,0,0,-1,0},{1,0,1,0,-1},{0,0,1,-1,0},{1,0,0,0,0},{0,0,0,0,1},{1,-1,0,1,0},{-1,1,0,0,0}};
ineqrhsPd = matrix {{0},{-1},{-1},{1},{0},{1},{1},{1},{0}};
eqlhsPd = map(QQ^0, QQ^5, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 24, facets: 24
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,1,0,0,1,1,0,1,0,-1,-1,0,0,1,0,0,-1,0,-1,0,0,-1},{0,0,0,-1,0,0,0,-1,0,0,-1,0,0,-1,0,-1,0,-1,1,1,1,1,1,1},{-1,1,1,0,0,0,0,0,1,-1,1,1,0,0,-1,-1,-1,0,0,0,1,-1,0,0},{-1,1,-1,-1,-1,1,-1,0,0,0,0,0,1,0,0,0,1,1,1,-1,0,0,0,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0},{1,1,0,1},{1,0,0,1},{0,-1,0,0},{1,0,1,1},{-1,-1,-1,0},{-1,0,0,-1},{0,0,1,0},{0,0,0,1},{-1,-1,0,0},{-1,0,0,0},{-2,-1,-1,-1},{-1,0,-1,0},{1,1,1,1},{0,1,0,0},{-1,-1,0,-1},{-1,-1,-1,-1},{-1,0,-1,-1},{0,0,0,-1},{1,1,1,0},{1,0,1,0},{2,1,1,1},{1,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 24, facets: 24
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,0,0,0,0,0,0,1/2,1/2,1/2,1/2,1/2,1/2,1/2,1/2,1},{0,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,-1,0,0,0,0,1,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,0},{0,-1/2,-1/2,1/2,1/2,-1/2,-1/2,1/2,1/2,0,-1,0,0,1,0,-1/2,-1/2,1/2,1/2,-1/2,-1/2,1/2,1/2,0},{0,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,0,0,-1,1,0,0,-1/2,1/2,-1/2,1/2,-1/2,1/2,-1/2,1/2,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1,1,0},{0,0,1,1},{0,1,0,1},{0,1,-1,0},{0,0,-1,1},{0,-1,1,0},{0,-1,0,1},{0,-1,-1,0},{-1,1,0,0},{-1,0,0,1},{-1,0,-1,0},{-1,-1,0,0},{-1,0,0,-1},{-1,0,1,0},{0,-1,0,-1},{0,0,-1,-1},{0,1,0,-1},{0,0,1,-1},{1,0,0,-1},{1,-1,0,0},{1,0,-1,0},{1,0,0,1},{1,0,1,0},{1,1,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 24, facets: 24
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,-1,-1,-1,-1,-1,-1},{-1,0,-1,-1,0,1,1,1,-1,0,0,1,0,0,1,0,-1,0,0,1,0,0,0,-1},{-1,-1,0,1,1,-1,0,1,0,0,0,0,1,-1,0,1,0,-1,0,0,1,0,-1,0},{0,-1,-1,0,-1,0,-1,0,0,-1,1,0,0,0,1,1,1,1,1,0,0,-1,0,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{-1/2,-1/2,-1/2,-1/2},{-1/2,-1/2,-1/2,1/2},{-1/2,-1/2,1/2,-1/2},{-1/2,-1/2,1/2,1/2},{-1/2,1/2,-1/2,-1/2},{-1/2,1/2,-1/2,1/2},{-1/2,1/2,1/2,-1/2},{-1/2,1/2,1/2,1/2},{0,-1,0,0},{0,0,-1,0},{0,0,0,-1},{0,0,0,1},{0,0,1,0},{0,1,0,0},{1/2,-1/2,-1/2,-1/2},{1/2,-1/2,-1/2,1/2},{1/2,-1/2,1/2,-1/2},{1/2,-1/2,1/2,1/2},{1/2,1/2,-1/2,-1/2},{1/2,1/2,-1/2,1/2},{1/2,1/2,1/2,-1/2},{1/2,1/2,1/2,1/2},{1,0,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 7, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,9007199254740992/7286977268806823,-1,29472066294954575717671549009920/77158871278881291906588116670641,0,0,29472066294954575717671549009920/77158871278881291906588116670641},{6223821613304664/8566355544790271,0,-6223821613304664/8566355544790271,-90705693242519399071460246945792/77158871278881291906588116670641,0,0,90705693242519399071460246945792/77158871278881291906588116670641},{0,0,0,0,1,-1,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,1},{-347922205179541/1125899906842624,-8566355544790271/9007199254740992,1},{7286977268806823/9007199254740992,-5294298886396511/9007199254740992,1},{7286977268806823/9007199254740992,5294298886396511/9007199254740992,1},{-347922205179541/1125899906842624,8566355544790271/9007199254740992,1},{-1,0,-1},{-347922205179541/1125899906842624,-8566355544790271/9007199254740992,-1},{7286977268806823/9007199254740992,-5294298886396511/9007199254740992,-1},{7286977268806823/9007199254740992,5294298886396511/9007199254740992,-1},{-347922205179541/1125899906842624,8566355544790271/9007199254740992,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{1}};
raysP = matrix {{-1,0},{0,-1}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0},{0,1}};
ineqrhsPd = matrix {{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 4, vertices: 1, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1/6},{-1/6},{-1/6},{-1/6}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^4, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = matrix {{0,-1,-2,-3},{0,-1/14,-8/7,11/14},{0,-10/9,2/9,2/9},{-1,0,0,0}};
eqrhsPd = matrix {{1},{1/14},{1/9},{1/6}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 7, vertices: 35, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0},{1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,0,0,0,0,1,1,1,1,0},{1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,0,0,1,1,1,0,1,1,1,0,1},{0,1,0,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,1,0,1,1},{0,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,1,0,1,1,1,0,1,1,1},{0,0,0,1,0,0,1,0,1,1,0,0,1,0,1,1,0,1,1,1,0,0,1,0,1,1,0,1,1,1,0,1,1,1,1}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0,0,0,0,0},{-1,0,0,0,0,0,0},{0,1,0,0,0,0,0},{0,-1,0,0,0,0,0},{0,0,1,0,0,0,0},{0,0,-1,0,0,0,0},{0,0,0,1,0,0,0},{0,0,0,-1,0,0,0},{0,0,0,0,1,0,0},{0,0,0,0,-1,0,0},{0,0,0,0,0,1,0},{0,0,0,0,0,-1,0},{0,0,0,0,0,0,1},{0,0,0,0,0,0,-1}};
ineqrhsPd = matrix {{1},{0},{1},{0},{1},{0},{1},{0},{1},{0},{1},{0},{1},{0}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-4}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 6, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-211,21,20,-1176/5,-1,0},{1160/121,105/11,-1,1050/121,1055/121,0},{-1,-1281/5,-22,-21,-232,0},{1171/121,1176/121,1,1281/121,116/11,0},{1,-210,22,21,-1171/5,0},{-1276/5,-21,-20,-231,1,0}};
ineqrhsPd = matrix {{10},{1105/121},{-11},{1226/121},{11},{-10}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 6, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-211,21,20,-1176/5,-1,0},{1160/121,105/11,-1,1050/121,1055/121,0},{-1,-1281/5,-22,-21,-232,0},{1171/121,1176/121,1,1281/121,116/11,0},{1,-210,22,21,-1171/5,0},{-1276/5,-21,-20,-231,1,0}};
ineqrhsPd = matrix {{10},{1105/121},{-11},{1226/121},{11},{-10}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 4, vertices: 6, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,1,1,1},{1,1,1,0,0,0},{1,1,2,1,1,2},{1,2,1,1,2,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{1,-1,0,0},{0,0,-1,0},{-1,1,0,0},{0,0,1,1}};
ineqrhsPd = matrix {{-1},{1},{-1},{1},{3}};
eqlhsPd = matrix {{-1,-1,0,0}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 5, vertices: 10, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,1,1,0,0,0,1,1},{0,0,1,0,1,0,1,1,0,0},{0,1,1,0,0,1,0,0,0,1},{1,1,0,0,0,0,0,1,1,0},{1,0,0,1,0,1,1,0,0,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0,0,0},{0,0,1,0,0},{-1,0,0,0,0},{-1,-1,-1,-1,0},{0,0,0,1,0},{0,1,0,0,0},{1,0,0,0,0},{0,0,-1,0,0},{0,0,0,-1,0},{1,1,1,1,0}};
ineqrhsPd = matrix {{0},{1},{0},{-1},{1},{1},{1},{0},{0},{2}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-2}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,-1,0},{1,0,0,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1},{-1,1},{1,1},{1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 5, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1},{0,0,1,1},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0,0},{0,-1,0,0,0},{0,1,0,0,0},{1,0,0,0,0}};
ineqrhsPd = matrix {{0},{0},{1},{1}};
eqlhsPd = matrix {{0,0,-1,0,0},{0,0,0,-1,0},{0,0,0,0,-1}};
eqrhsPd = matrix {{0},{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 6, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-5,-5,0,0,5,6},{0,6,-5,5,-5,0},{-5,0,6,-5,0,5},{6,5,0,0,-5,-5},{0,-5,5,-5,6,0},{5,0,-5,6,0,-5}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-211,21,20,-1176/5,-1,0},{1160/121,105/11,-1,1050/121,1055/121,0},{-1,-1281/5,-22,-21,-232,0},{1171/121,1176/121,1,1281/121,116/11,0},{1,-210,22,21,-1171/5,0},{-1276/5,-21,-20,-231,1,0}};
ineqrhsPd = matrix {{10},{1105/121},{-11},{1226/121},{11},{-10}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1},{0,1,0},{1,0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,0},{-1,0,0},{0,-1,0}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = matrix {{-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 4, vertices: 0, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^4, QQ^0, 0);
raysP = map(QQ^4, QQ^0, 0);
linealityP = matrix {{-1},{-1},{1},{1}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^4, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = matrix {{0,-1,0,-1},{0,-1/2,-1,1/2},{-1,1/3,-1/3,-1/3},{0,0,0,0}};
eqrhsPd = matrix {{1},{1/2},{2/3},{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,0,0,1},{0,-1,1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1},{-1,1},{1,1},{1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1},{0,1,0},{1,0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,0},{-1,0,0},{0,-1,0}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = matrix {{-1,-1,-1}};
eqrhsPd = matrix {{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 12, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,-1,1,0,-1,1,0,-1,-1,1,1,0},{-1,0,0,1,-1,-1,-1,1,0,1,0,1},{-1,-1,-1,-1,0,0,1,0,1,0,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,1},{1,-1,1},{0,-1,0},{-1,1,-1},{-1,0,0},{-1,-1,-1},{-1,-1,1},{-1,1,1},{1,-1,-1},{0,0,-1},{1,1,-1},{1,1,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{1},{2},{1},{2},{1},{2},{2},{2},{2},{1},{2},{2},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 6, vertices: 64, facets: 12
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0,0,0},{1,0,0,0,0,0},{0,-1,0,0,0,0},{0,1,0,0,0,0},{0,0,-1,0,0,0},{0,0,1,0,0,0},{0,0,0,-1,0,0},{0,0,0,1,0,0},{0,0,0,0,-1,0},{0,0,0,0,1,0},{0,0,0,0,0,-1},{0,0,0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^6, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,1,-1,0},{-1,-1,1,1,2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{1,0},{0,-1},{-1,0},{-1,1}};
ineqrhsPd = matrix {{2},{1},{1},{1},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0},{0,0,1,-1,0,0},{0,0,0,0,1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 4, vertices: 24, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4},{2,2,3,3,4,4,1,1,3,3,4,4,1,1,2,2,4,4,1,1,2,2,3,3},{3,4,2,4,2,3,3,4,1,4,1,3,2,4,1,4,1,2,2,3,1,3,1,2},{4,3,4,2,3,2,4,3,4,1,3,1,4,2,4,1,2,1,3,2,3,1,2,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1,0},{0,-1,-1,0},{-1,-1,-1,0},{-1,0,-1,0},{-1,0,0,0},{-1,-1,0,0},{0,1,1,0},{0,0,1,0},{0,1,0,0},{0,-1,0,0},{1,0,1,0},{1,1,1,0},{1,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{-1},{-3},{-6},{-3},{-1},{-3},{7},{4},{4},{-1},{7},{9},{7},{4}};
eqlhsPd = matrix {{-1,-1,-1,-1}};
eqrhsPd = matrix {{-10}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 48, facets: 26
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,2,-2,3,-3,3,-3,3,-3,3,-3,3,-3,3,-3,3,-3,3,-3},{2,2,-2,-2,2,2,-2,-2,3,3,-3,-3,3,3,-3,-3,1,1,-1,-1,1,1,-1,-1,3,3,-3,-3,3,3,-3,-3,1,1,-1,-1,1,1,-1,-1,2,2,-2,-2,2,2,-2,-2},{3,3,3,3,-3,-3,-3,-3,2,2,2,2,-2,-2,-2,-2,3,3,3,3,-3,-3,-3,-3,1,1,1,1,-1,-1,-1,-1,2,2,2,2,-2,-2,-2,-2,1,1,1,1,-1,-1,-1,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,-1},{1,0,-1},{1,-1,-1},{0,0,-1},{0,1,-1},{0,-1,-1},{-1,1,-1},{-1,-1,-1},{-1,0,-1},{-1,0,0},{-1,-1,0},{-1,0,1},{-1,1,0},{-1,-1,1},{-1,1,1},{0,-1,1},{0,1,1},{0,-1,0},{0,0,1},{0,1,0},{1,-1,0},{1,-1,1},{1,0,1},{1,1,1},{1,1,0},{1,0,0}};
ineqrhsPd = matrix {{6},{5},{6},{3},{5},{5},{6},{6},{5},{3},{5},{5},{5},{6},{6},{5},{5},{3},{3},{3},{5},{6},{5},{6},{5},{3}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 5, vertices: 120, facets: 30
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5},{2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,4,4,4,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,5,5,5,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4},{3,3,4,4,5,5,2,2,4,4,5,5,2,2,3,3,5,5,2,2,3,3,4,4,3,3,4,4,5,5,1,1,4,4,5,5,1,1,3,3,5,5,1,1,3,3,4,4,2,2,4,4,5,5,1,1,4,4,5,5,1,1,2,2,5,5,1,1,2,2,4,4,2,2,3,3,5,5,1,1,3,3,5,5,1,1,2,2,5,5,1,1,2,2,3,3,2,2,3,3,4,4,1,1,3,3,4,4,1,1,2,2,4,4,1,1,2,2,3,3},{4,5,3,5,3,4,4,5,2,5,2,4,3,5,2,5,2,3,3,4,2,4,2,3,4,5,3,5,3,4,4,5,1,5,1,4,3,5,1,5,1,3,3,4,1,4,1,3,4,5,2,5,2,4,4,5,1,5,1,4,2,5,1,5,1,2,2,4,1,4,1,2,3,5,2,5,2,3,3,5,1,5,1,3,2,5,1,5,1,2,2,3,1,3,1,2,3,4,2,4,2,3,3,4,1,4,1,3,2,4,1,4,1,2,2,3,1,3,1,2},{5,4,5,3,4,3,5,4,5,2,4,2,5,3,5,2,3,2,4,3,4,2,3,2,5,4,5,3,4,3,5,4,5,1,4,1,5,3,5,1,3,1,4,3,4,1,3,1,5,4,5,2,4,2,5,4,5,1,4,1,5,2,5,1,2,1,4,2,4,1,2,1,5,3,5,2,3,2,5,3,5,1,3,1,5,2,5,1,2,1,3,2,3,1,2,1,4,3,4,2,3,2,4,3,4,1,3,1,4,2,4,1,2,1,3,2,3,1,2,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1,0},{0,0,-1,-1,0},{0,-1,-1,-1,0},{0,-1,0,-1,0},{-1,-1,-1,-1,0},{-1,0,-1,-1,0},{-1,-1,0,-1,0},{-1,0,0,-1,0},{-1,0,0,0,0},{-1,-1,0,0,0},{-1,0,-1,0,0},{0,1,1,1,0},{-1,-1,-1,0,0},{0,0,1,1,0},{0,1,0,1,0},{0,1,1,0,0},{0,0,0,1,0},{0,0,1,0,0},{0,1,0,0,0},{0,-1,0,0,0},{0,-1,-1,0,0},{1,0,1,1,0},{1,0,0,1,0},{1,0,1,0,0},{0,0,-1,0,0},{1,1,0,1,0},{1,1,1,1,0},{1,1,1,0,0},{1,1,0,0,0},{1,0,0,0,0}};
ineqrhsPd = matrix {{-1},{-3},{-6},{-3},{-10},{-6},{-6},{-3},{-1},{-3},{-3},{12},{-6},{9},{9},{9},{5},{5},{5},{-1},{-3},{12},{9},{9},{-1},{12},{14},{12},{9},{5}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-15}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 5, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^4, QQ^0, 0);
raysP = matrix {{-1,-1,-1,-1},{-1,0,0,-1},{-1,-1,0,0},{0,0,0,0}};
linealityP = matrix {{1},{1},{1},{1}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-1,0,0},{1,0,-1,0},{0,1,0,-1},{0,0,1,-1}};
ineqrhsPd = matrix {{0},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,1,-1},{0,1,-1,-1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{0,1},{-2,-1},{1,1},{1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 2, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1/2},{1/2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,0},{0,-1}};
eqrhsPd = matrix {{-1/2},{-1/2}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 3, vertices: 2, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0},{-1},{-1}};
raysP = matrix {{1},{0},{0}};
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0}};
ineqrhsPd = matrix {{0}};
eqlhsPd = matrix {{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{1},{1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: -1, ambientDim: 4, vertices: 0, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^4, QQ^0, 0);
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^4, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 3, vertices: 2, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0},{1},{1}};
raysP = matrix {{1},{0},{0}};
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0}};
ineqrhsPd = matrix {{0}};
eqlhsPd = matrix {{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{-1},{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 7, vertices: 7, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3,37/6,1,79/48},{0,43/6,2,65/48},{4,0,0,31/24},{0,31/3,0,0},{65/2,0,0,0},{0,0,31/2,0},{1,-52/3,-7,-53/12}};
raysP = matrix {{1,1,0},{1,0,0},{0,1,0},{2,1,0},{3,27/2,1},{0,0,1},{-2,1,0}};
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0,0,0,0,0},{0,0,-1,0,0,0,0},{0,0,0,-1,0,0,0},{0,0,0,0,-1,0,0},{0,0,0,0,0,-1,0}};
ineqrhsPd = matrix {{0},{0},{0},{0},{0}};
eqlhsPd = matrix {{-1,1,1,0,0,0,0},{-1/3,-5/3,4/3,0,0,0,-1},{15/17,7/17,8/17,-1,0,0,-6/17},{87/26,-1/26,44/13,43/13,-1,1,45/13}};
eqrhsPd = matrix {{1},{10/3},{71/17},{-71/13}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 7, vertices: 4, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{0},{0},{4},{43/2},{0},{3}};
raysP = matrix {{1,1,0},{0,1,0},{1,0,0},{1,2,0},{27/2,3,1},{0,0,1},{1,-2,0}};
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0,0,0,0,0},{0,0,-1,0,0,0,0},{0,0,0,0,0,-1,0}};
ineqrhsPd = matrix {{0},{0},{0}};
eqlhsPd = matrix {{-1,1,1,0,0,0,0},{-1/3,-5/3,4/3,0,0,0,-1},{15/17,7/17,8/17,-1,0,0,-6/17},{87/26,-1/26,44/13,43/13,-1,1,45/13}};
eqrhsPd = matrix {{-1},{-10/3},{-71/17},{71/13}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 6, vertices: 4, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0},{1},{0},{5},{0},{1}};
raysP = matrix {{1,0,0},{1,0,0},{0,1,0},{0,1,0},{0,0,1},{0,0,1}};
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0,0,0},{0,0,-1,0,0,0},{0,0,0,0,-1,0}};
ineqrhsPd = matrix {{0},{0},{0}};
eqlhsPd = matrix {{-1,1,0,0,0,0},{0,0,-1,1,0,0},{0,0,0,0,-1,1}};
eqrhsPd = matrix {{1},{5},{1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0},{0,0,1}};
raysP = matrix {{1},{1}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{-1,1},{1,-1},{0,-1}};
ineqrhsPd = matrix {{0},{1},{1},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 6, vertices: 4, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{0},{5},{0},{1},{0}};
raysP = matrix {{1,0,0},{1,0,0},{0,1,0},{0,1,0},{0,0,1},{0,0,1}};
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1,0,0,0,0},{0,0,0,-1,0,0},{0,0,0,0,0,-1}};
ineqrhsPd = matrix {{0},{0},{0}};
eqlhsPd = matrix {{-1,1,0,0,0,0},{0,0,-1,1,0,0},{0,0,0,0,-1,1}};
eqrhsPd = matrix {{-1},{-5},{-1}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 4, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{29,7,41/2,40,40,40,40,40},{7,7,21/2,21/2,7,21/2,7,245/24},{22,0,0,39/2,0,0,11,165/8},{2,2,3,3,2,3,2,35/12}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,1,1,10},{1,-3,1,0},{1,0,0,0},{0,0,-1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{20},{30},{40},{0},{-2},{3}};
eqlhsPd = matrix {{0,-1,0,7/2}};
eqrhsPd = matrix {{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,0},{0,-1,0,0},{0,1,0,0},{0,0,-1,0},{0,0,1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,1,-1,-2,-1,1},{0,1,1,0,-1,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1},{-1,-1},{-1,1},{0,-1},{1,-1},{1,1}};
ineqrhsPd = matrix {{1},{2},{2},{1},{2},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,-2,-1},{0,0,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,-1},{0,1},{-1,-1}};
ineqrhsPd = matrix {{0},{0},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 6, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,1,-1,-2,-1,1},{0,1,1,0,-1,-1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1},{-1,-1},{-1,1},{0,-1},{1,-1},{1,1}};
ineqrhsPd = matrix {{1},{2},{2},{1},{2},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,-1,-2},{0,1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{0,-1},{-1,1}};
ineqrhsPd = matrix {{0},{0},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,0},{0,-1,0,0},{0,1,0,0},{0,0,-1,0},{0,0,1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0},{0,0,1,0},{0,0,0,2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{0,-1,0},{0,0,-1},{2,2,1}};
ineqrhsPd = matrix {{0},{0},{0},{2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1},{-1,1,1,1},{1,-1,1,1},{-1,-1,1,1},{1,1,-1,1},{-1,1,-1,1},{1,-1,-1,1},{-1,-1,-1,1},{1,1,1,-1},{-1,1,1,-1},{1,-1,1,-1},{-1,-1,1,-1},{1,1,-1,-1},{-1,1,-1,-1},{1,-1,-1,-1},{-1,-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{5/8,-5/8,0,0,0,0,0,0},{0,0,5/8,-5/8,0,0,0,0},{0,0,0,0,5/8,-5/8,0,0},{0,0,0,0,0,0,5/8,-5/8}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1},{-1,1,1,1},{1,-1,1,1},{-1,-1,1,1},{1,1,-1,1},{-1,1,-1,1},{1,-1,-1,1},{-1,-1,-1,1},{1,1,1,-1},{-1,1,1,-1},{1,-1,1,-1},{-1,-1,1,-1},{1,1,-1,-1},{-1,1,-1,-1},{1,-1,-1,-1},{-1,-1,-1,-1}};
ineqrhsPd = matrix {{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8},{5/8}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1,-1,0,0},{0,1,0,0,-1,0},{1,0,0,0,0,-1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,1,-1},{-1,1,1},{1,1,1},{-1,-1,1},{1,-1,1},{1,1,-1},{-1,-1,-1},{1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 24, facets: 26
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1/4,-1/4,-1/4,-1/4,1/4,1/4,1/4,1/4,1/2,1/2,1/2,1/2,1/4,1/4,1/4,1/4,-1/4,-1/4,-1/4,-1/4,-1/2,-1/2,-1/2,-1/2},{-1/2,-1/2,-1/4,1/4,-1/2,-1/2,-1/4,1/2,-1/4,1/4,1/4,-1/4,1/2,1/4,1/4,-1/4,1/2,1/2,1/4,-1/4,1/4,1/4,-1/4,-1/4},{1/4,-1/4,1/2,1/2,-1/4,1/4,1/2,-1/4,1/4,1/4,-1/4,-1/4,1/4,1/2,-1/2,-1/2,1/4,-1/4,-1/2,-1/2,-1/4,1/4,1/4,-1/4}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1},{2,0,0},{-2,0,0},{0,2,0},{0,-2,0},{0,0,2},{0,0,-2},{4/3,4/3,0},{4/3,-4/3,0},{4/3,0,4/3},{4/3,0,-4/3},{-4/3,4/3,0},{-4/3,-4/3,0},{-4/3,0,4/3},{-4/3,0,-4/3},{0,4/3,4/3},{0,4/3,-4/3},{0,-4/3,4/3},{0,-4/3,-4/3}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 3, vertices: 1, facets: 0
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1/2},{0},{0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^0, QQ^3, 0);
ineqrhsPd = map(QQ^0, QQ^1, 0);
eqlhsPd = matrix {{-1,0,0},{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{-1/2},{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 12, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,-1/2,0,1/2,1/2,1/2,1/2,0,-1/2,-1/2,0,-1/2},{-1/2,0,1/2,-1/2,0,1/2,0,1/2,1/2,0,-1/2,-1/2},{1/2,1/2,1/2,0,-1/2,0,1/2,-1/2,0,-1/2,-1/2,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1,1},{1,-1,-1},{-1,1,-1},{1,1,-1},{1,-1,1},{-1,1,1},{1,1,1},{-1,-1,-1},{0,0,1},{0,1,0},{1,0,0},{-1,0,0},{0,-1,0},{0,0,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1/2},{1/2},{1/2},{1/2},{1/2},{1/2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1},{-1,-1,1,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0},{1,0},{0,-1},{0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 10, facets: 7
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,1,1/2},{0,0,1,1,0,0,1,1,1/2,1},{0,0,0,0,1,1,1,1/2,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0},{1,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1},{5/2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,1,1,0,0},{1,0,0,1,0,1},{0,0,1,1,1,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0},{1,-1,-1},{-1,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1},{0},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,-1},{1,0,-1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1},{1,-1},{-1,1},{1,1}};
ineqrhsPd = matrix {{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 3, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,0},{0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0},{-1,0,0}};
ineqrhsPd = matrix {{1},{0}};
eqlhsPd = matrix {{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 3, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,0},{0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0},{-1,0,0}};
ineqrhsPd = matrix {{1},{0}};
eqlhsPd = matrix {{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 12, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1,0,1,1,2/3,1,1,0,0,1/3},{0,1,1,0,0,1,0,1/3,0,1,2/3,1},{0,0,0,1,1,1,0,0,1/3,2/3,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0},{1,-1,-1},{-1,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1},{2/3},{5/3}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,0,1,1},{1,1/2,0,0,0,1,1/2,1},{0,0,0,1/2,1,1,1,1/2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0},{1/2,-1,-1},{1/2,1,-1},{1/2,-1,1},{1/2,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1},{0},{1},{1},{2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 16, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,0,1/2,1,1,1,1/2,1,1,1/2,1,1,1,1/2},{0,1,0,1,0,1/4,0,3/4,1,1,0,0,1/4,1,3/4,1},{0,0,1,1,0,0,1/4,0,0,1/4,3/4,1,1,3/4,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0},{1/2,-1,-1},{1/2,1,-1},{1/2,-1,1},{1/2,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1},{1/4},{5/4},{5/4},{9/4}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 12, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1/2,1/2,1/2,1/2,-1/2,-1/2,-1/2,-1/2,0,0,0,0},{1/2,-1/2,0,0,1/2,-1/2,0,0,1/2,1/2,-1/2,-1/2},{0,0,1/2,-1/2,0,0,1/2,-1/2,1/2,-1/2,1/2,-1/2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1},{2,0,0},{-2,0,0},{0,2,0},{0,-2,0},{0,0,2},{0,0,-2}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 3, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1/2,1},{0,0},{0,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0},{-1,0,0}};
ineqrhsPd = matrix {{1},{-1/2}};
eqlhsPd = matrix {{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0},{1,0,0,0},{0,0,1,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,0,0},{0,-1,0},{0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 6, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{3/2,-3/2,0,0,0,0},{0,0,3/2,-3/2,0,0},{0,0,0,0,3/2,-3/2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,1,1},{1,-1,1},{-1,-1,1},{1,1,-1},{-1,1,-1},{1,-1,-1},{-1,-1,-1}};
ineqrhsPd = matrix {{3/2},{3/2},{3/2},{3/2},{3/2},{3/2},{3/2},{3/2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 24, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1/3,-1/3,0,0,-1/3,0,0,1/3,1/3,2/3,2/3,2/3,2/3,1/3,1/3,0,0,0,0,-1/3,-2/3,-2/3,-2/3,-2/3},{-2/3,0,-2/3,-1/3,2/3,1/3,2/3,-2/3,2/3,0,1/3,0,-1/3,0,0,2/3,1/3,-1/3,-2/3,0,1/3,0,0,-1/3},{0,-2/3,-1/3,-2/3,0,-2/3,-1/3,0,0,1/3,0,-1/3,0,2/3,-2/3,1/3,2/3,2/3,1/3,2/3,0,1/3,-1/3,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,1,-1},{-1,1,1},{-1,-1,1},{-1,-1,-1},{1,-1,1},{1,-1,-1},{1,1,1},{1,1,-1},{0,0,-1},{-1,0,0},{0,-1,0},{0,0,1},{0,1,0},{1,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{2/3},{2/3},{2/3},{2/3},{2/3},{2/3}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 10, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,-468/2581,-1716/5077,-156/359,-1/2,-156/359,-1716/5077,-468/2581,0,15600/2029},{156/329,1092/2581,1716/5077,468/2513,0,-468/2513,-1716/5077,-1092/2581,-156/329,0},{173/329,1333/2581,2581/5077,1265/2513,1/2,1265/2513,2581/5077,1333/2581,173/329,1873/2029}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,3,3},{-1,5/3,11/6},{-5/3,1,11/6},{-3,-1,3},{-3,1,3},{-5/3,-1,11/6},{-1,-5/3,11/6},{-1,-3,3},{1,-100,100},{1,100,100}};
ineqrhsPd = matrix {{3},{11/6},{11/6},{3},{3},{11/6},{11/6},{3},{100},{100}};
eqlhsPd = matrix {{-34/3,0,658/3}};
eqrhsPd = matrix {{346/3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,1},{0,0,1,0},{0,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{0,0,-1},{0,-1,0},{0,1,0},{1,0,0},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 5, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0},{1,0,0,1,0},{0,0,1,1,2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1,-1},{0,-1,0},{-1,0,0},{-1,2,1},{2,-1,1},{1,1,-1}};
ineqrhsPd = matrix {{-1},{0},{0},{2},{2},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0},{1,0,0,0},{0,0,1,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1},{-1,0,0},{0,-1,0},{0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{1,0,0},{0,-1,0},{0,1,0},{0,0,-1},{0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2},{2}};
raysP = matrix {{1,1},{-1,1}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0},{-1,1},{-1,-1}};
ineqrhsPd = matrix {{1},{0},{-4}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,2,2},{0,2,0,2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-1,0},{0,1},{1,0}};
ineqrhsPd = matrix {{0},{0},{2},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,1}};
raysP = matrix {{1},{0}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1},{-1,1},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1},{0,1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 12, facets: 7
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,0,0,0,0,0,1,1,1,1},{0,0,0,0,1,1,1,1,0,0,0,0},{0,0,2,2,0,0,2,2,0,0,2,2},{0,2,0,2,0,2,0,2,0,2,0,2}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-1},{-1,0,0,0},{0,0,-1,0},{0,0,0,1},{0,0,1,0},{0,-1,0,0},{1,1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{2},{2},{0},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,1},{2,2},{2,2}};
raysP = matrix {{1,0,0},{0,0,0},{0,1,1},{0,-1,1}};
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1,0,0},{-1,1,0,0},{0,-1,0,0},{0,0,-1,1},{0,0,-1,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0},{-4}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,1}};
raysP = matrix {{1},{0}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1},{-1,1},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2},{2}};
raysP = matrix {{1,1},{-1,1}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0},{-1,1},{-1,-1}};
ineqrhsPd = matrix {{1},{0},{-4}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,2,2},{0,2,0,2}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-1},{-1,0},{0,1},{1,0}};
ineqrhsPd = matrix {{0},{0},{2},{2}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1},{0,1},{2,2},{2,2}};
raysP = matrix {{1,0,0},{0,0,0},{0,1,1},{0,-1,1}};
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,1,0,0},{-1,1,0,0},{0,-1,0,0},{0,0,-1,1},{0,0,-1,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0},{-4}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1},{0,1,0}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1},{-1}};
ineqrhsPd = matrix {{1},{1}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1},{-1}};
ineqrhsPd = matrix {{1},{1}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 9, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1/2,0,1/2,0,1,1/2,1/2,0},{0,1/2,0,-1/2,0,0,-1/2,1/2,0},{1/2,0,0,0,1/2,0,1/2,1/2,1},{1/2,0,0,0,-1/2,0,1/2,-1/2,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1},{-1,-1,0,0},{0,0,-1,-1},{1,-1,1,-1},{-1,1,0,0},{0,0,-1,1}};
ineqrhsPd = matrix {{1},{0},{0},{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0},{0,0,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,1,-1,1,-1,1,-1},{2,0,0,2,-2,0,-2,0},{0,-2,0,2,0,2,-2,0}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,0,0},{-1,0,0},{1,1,0},{-1,-1,0},{1,0,1},{-1,0,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0},{0,0,1}};
raysP = map(QQ^2, QQ^0, 0);
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1},{-1,0},{0,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0},{0,0,1,0},{0,0,0,2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0},{0,-1,0},{0,0,-1},{2,2,1}};
ineqrhsPd = matrix {{0},{0},{0},{2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{1,0,0,0},{0,-1,0,0},{0,1,0,0},{0,0,-1,0},{0,0,1,0},{0,0,0,-1},{0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 3, vertices: 10, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,-468/2581,-1716/5077,-156/359,-1/2,-156/359,-1716/5077,-468/2581,0,15600/2029},{156/329,1092/2581,1716/5077,468/2513,0,-468/2513,-1716/5077,-1092/2581,-156/329,0},{173/329,1333/2581,2581/5077,1265/2513,1/2,1265/2513,2581/5077,1333/2581,173/329,1873/2029}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{2029/32900,1,0},{2029/32900,-1,0},{-278/987,-1,0},{-1787/3290,-1,0},{-3103/1974,-1,0},{-936/329,1,0},{-936/329,-1,0},{-3103/1974,1,0},{-1787/3290,1,0},{-278/987,1,0}};
ineqrhsPd = matrix {{156/329},{156/329},{156/329},{858/1645},{286/329},{468/329},{468/329},{286/329},{858/1645},{156/329}};
eqlhsPd = matrix {{-34/3,0,658/3}};
eqrhsPd = matrix {{346/3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 4, vertices: 6, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,3/2},{3,2},{4,5/2},{5,3}};
raysP = matrix {{1,-1,0,0},{-1,1,0,0},{2,-2,1,0},{-2,2,-1,0}};
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,0,0},{-1,-1,0,0},{7,1,-3,0}};
ineqrhsPd = matrix {{5},{-7/2},{5}};
eqlhsPd = matrix {{7/3,7/3,-1,-1}};
eqrhsPd = matrix {{8/3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1}};
raysP = matrix {{1}};
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0},{-1}};
ineqrhsPd = matrix {{1},{-1}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 5, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,3/2},{3,2},{4,5/2},{5,3}};
raysP = matrix {{1,-1,0},{3/2,2,0},{2,9/2,1},{3,-7/2,-1}};
linealityP = matrix {{1},{-1},{2},{-2}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,-1,-1},{30/13,2,-15/13,-1},{0,0,0,0},{-2,-2,1,1},{0,-2,0,1},{-7/3,-7/3,1,1}};
ineqrhsPd = matrix {{-2},{41/26},{1},{-1},{-1},{-8/3}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 2, ambientDim: 2, vertices: 3, facets: 3
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0},{0}};
raysP = matrix {{0,1},{1,1}};
linealityP = map(QQ^2, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0},{-1,0},{1,-1}};
ineqrhsPd = matrix {{1},{0},{0}};
eqlhsPd = map(QQ^0, QQ^2, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 1, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1}};
eqrhsPd = matrix {{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1},{1}};
ineqrhsPd = matrix {{1},{1}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 72, facets: 37
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2,3/2,3/2,3/2,3/2,3/2,3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2,3/2,3/2,3/2,3/2,3/2,3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-3/2,-1/2,-1/2,-1/2,-1/2,-1/2,-1/2,1/2,1/2,1/2,1/2,1/2,1/2,3/2,3/2,3/2,3/2,3/2,3/2},{-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2,-5/2,-3/2,-1/2,1/2,3/2,5/2},{19/18,11/18,7/18,7/18,11/18,19/18,5/6,7/18,1/6,1/6,7/18,5/6,5/6,7/18,1/6,1/6,7/18,5/6,19/18,11/18,7/18,7/18,11/18,19/18,17/18,1/2,5/18,5/18,1/2,17/18,13/18,5/18,1/18,1/18,5/18,13/18,13/18,5/18,1/18,1/18,5/18,13/18,17/18,1/2,5/18,5/18,1/2,17/18,19/18,11/18,7/18,7/18,11/18,19/18,5/6,7/18,1/6,1/6,7/18,5/6,5/6,7/18,1/6,1/6,7/18,5/6,19/18,11/18,7/18,7/18,11/18,19/18}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,2,2,-9},{1,2,-2,-9},{0,0,-1,0},{2,0,4,-18},{2,0,-4,-18},{1,-2,2,-9},{1,-2,-2,-9},{-1,2,2,-9},{-1,2,-2,-9},{-2,0,4,-18},{-2,0,-4,-18},{-1,-2,2,-9},{-1,-2,-2,-9},{-1,0,0,0},{-1,-2,-4,-9},{-2,-4,0,-18},{-1,-2,4,-9},{-1,0,-4,-9},{-2,0,0,-18},{-1,0,4,-9},{-1,2,-4,-9},{-2,4,0,-18},{-1,2,4,-9},{0,-1,0,0},{1,-2,-4,-9},{2,-4,0,-18},{1,-2,4,-9},{1,0,-4,-9},{2,0,0,-18},{1,0,4,-9},{1,2,-4,-9},{2,4,0,-18},{0,0,1,0},{0,0,0,1},{1,2,4,-9},{0,1,0,0},{1,0,0,0}};
ineqrhsPd = matrix {{3/2},{3/2},{5/2},{1},{1},{3/2},{3/2},{3/2},{3/2},{1},{1},{3/2},{3/2},{1},{9/2},{1},{9/2},{7/2},{-1},{7/2},{9/2},{1},{9/2},{3/2},{9/2},{1},{9/2},{7/2},{-1},{7/2},{9/2},{1},{5/2},{19/18},{9/2},{3/2},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 4, facets: 4
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,0,1},{0,0,2,2},{0,3,3,3}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,1},{-1,0,0},{2,-1,0},{0,3/2,-1}};
ineqrhsPd = matrix {{3},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0,0},{0,0,1,0,0},{0,0,0,1,0},{0,0,0,0,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 6, vertices: 7, facets: 7
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,0,0,-1},{0,1,0,0,0,0,-1},{0,0,1,0,0,0,-1},{0,0,0,1,0,0,-1},{0,0,0,0,1,0,-1},{0,0,0,0,0,1,-1}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1,1,1},{1,1,1,1,1,-6},{1,-6,1,1,1,1},{1,1,-6,1,1,1},{1,1,1,-6,1,1},{1,1,1,1,-6,1},{-6,1,1,1,1,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^6, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,5/8,0,0,0},{0,0,5/8,0,0},{0,0,0,5/8,0},{0,0,0,0,5/8}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{8/5,8/5,8/5,8/5},{-1,0,0,0},{0,-1,0,0},{0,0,-1,0},{0,0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 0, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = map(QQ^0, QQ^1, 0);
raysP = map(QQ^0, QQ^0, 0);
linealityP = map(QQ^0, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = map(QQ^1, QQ^0, 0);
ineqrhsPd = matrix {{1}};
eqlhsPd = map(QQ^0, QQ^0, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 8, facets: 6
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1},{0,0,1,1,0,0,1,1},{0,0,0,0,1,1,1,1}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{0,-1,0},{-1,0,0},{0,0,1},{1,0,0},{0,1,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 9, facets: 9
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0,1,0,1,1/2},{0,0,1,1,0,0,1,1,1/2},{0,0,0,0,1,1,1,1,3/2}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-1},{0,-1,0},{-1,0,0},{-1,0,1},{0,-1,1},{1,0,0},{0,1,0},{1,0,1},{0,1,1}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1},{1},{1},{2},{2}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 9, ambientDim: 16, vertices: 24, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,1,0,0,0,0,1,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0},{0,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1},{0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0},{0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,1,0,0,1,0,0},{0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0},{1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0},{0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1},{0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0},{0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0},{0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0},{1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0},{0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1},{0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0},{0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};
raysP = map(QQ^16, QQ^0, 0);
linealityP = map(QQ^16, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0},{-1,-1,-1,0,-1,-1,-1,0,-1,-1,-1,0,0,0,0,0},{-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0},{0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0},{0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0},{0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0},{0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0},{0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0},{0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0},{0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0},{1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0},{1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0}};
ineqrhsPd = matrix {{0},{-2},{0},{0},{1},{1},{0},{0},{1},{1},{0},{0},{0},{0},{1},{1}};
eqlhsPd = matrix {{-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0},{-3/4,1/4,1/4,1/4,-3/4,1/4,1/4,1/4,-3/4,1/4,1/4,1/4,-1,0,0,0},{1/13,-9/13,4/13,4/13,1/13,-9/13,4/13,4/13,1/13,-9/13,4/13,4/13,-3/13,-1,0,0},{1/10,1/10,-3/5,2/5,1/10,1/10,-3/5,2/5,1/10,1/10,-3/5,2/5,-3/10,-3/10,-1,0},{1/7,1/7,1/7,-3/7,1/7,1/7,1/7,-3/7,1/7,1/7,1/7,-3/7,-3/7,-3/7,-3/7,-1}};
eqrhsPd = matrix {{-1},{-1},{-1},{-1/4},{-4/13},{-2/5},{-4/7}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 9, ambientDim: 16, vertices: 12, facets: 64
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,0,0,0,1,0,1,0,0,0,0,0},{0,0,1,0,0,1,0,0,0,0,1,0},{0,1,0,0,0,0,0,0,1,0,0,1},{0,0,0,1,0,0,0,1,0,1,0,0},{0,1,0,0,0,1,0,1,0,0,0,0},{1,0,0,1,0,0,0,0,0,0,0,1},{0,0,1,0,0,0,1,0,0,1,0,0},{0,0,0,0,1,0,0,0,1,0,1,0},{0,0,1,1,0,0,0,0,1,0,0,0},{0,1,0,0,1,0,0,0,0,1,0,0},{1,0,0,0,0,0,0,1,0,0,1,0},{0,0,0,0,0,1,1,0,0,0,0,1},{0,0,0,0,0,0,0,0,0,1,1,1},{0,0,0,0,0,0,1,1,1,0,0,0},{0,0,0,1,1,1,0,0,0,0,0,0},{1,1,1,0,0,0,0,0,0,0,0,0}};
raysP = map(QQ^16, QQ^0, 0);
linealityP = map(QQ^16, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1,-1,0,-1,-1,-1,0,-1,-1,-1,0,0,0,0,0},{-1,-1,-2,0,-1,-2,-1,0,0,-1,-1,0,0,0,0,0},{-1,-1,0,0,-1,-2,-1,0,-2,-1,-1,0,0,0,0,0},{0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0},{-1,0,-1,0,-2,-1,-1,0,-1,-1,-2,0,0,0,0,0},{0,1,1,0,-1,-1,0,0,-1,0,-1,0,0,0,0,0},{-1,-2,-1,0,0,-1,-1,0,-1,-1,-2,0,0,0,0,0},{0,-1,-1,0,1,-1,0,0,1,0,-1,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0},{-2,-1,-1,0,-1,-1,0,0,-1,-2,-1,0,0,0,0,0},{-1,0,1,0,0,-1,1,0,-1,-1,0,0,0,0,0,0},{-1,-1,0,0,1,0,1,0,0,-1,-1,0,0,0,0,0},{-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{-1,1,0,0,-1,0,-1,0,0,1,-1,0,0,0,0,0},{-1,0,-1,0,0,-1,-1,0,1,1,0,0,0,0,0,0},{-2,-1,-1,0,-1,-1,-2,0,-1,0,-1,0,0,0,0,0},{0,1,1,0,1,1,0,0,1,0,1,0,0,0,0,0},{1,2,1,0,0,1,-1,0,1,1,0,0,0,0,0,0},{1,1,0,0,1,0,-1,0,2,1,1,0,0,0,0,0},{0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0},{-1,1,0,0,1,2,1,0,0,1,1,0,0,0,0,0},{-1,0,1,0,0,1,1,0,1,1,2,0,0,0,0,0},{0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0},{0,1,-1,0,1,1,0,0,1,2,1,0,0,0,0,0},{-1,0,-1,0,0,1,-1,0,-1,1,0,0,0,0,0,0},{0,1,1,0,-1,1,0,0,1,2,1,0,0,0,0,0},{0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0},{-1,-1,0,0,-1,0,-1,0,0,1,1,0,0,0,0,0},{1,0,1,0,2,1,1,0,1,-1,0,0,0,0,0,0},{1,1,2,0,1,0,1,0,0,-1,1,0,0,0,0,0},{0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0},{2,1,1,0,1,1,0,0,1,0,-1,0,0,0,0,0},{1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0},{1,-1,0,0,1,0,-1,0,0,-1,-1,0,0,0,0,0},{1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,0,0,-1,0,-1,0,0,-1,-1,0,0,0,0,0},{2,1,1,0,1,-1,0,0,1,0,1,0,0,0,0,0},{1,0,1,0,0,-1,-1,0,-1,-1,0,0,0,0,0,0},{1,0,-1,0,0,-1,-1,0,1,-1,0,0,0,0,0,0},{0,-1,-1,0,-1,-1,-2,0,-1,-2,-1,0,0,0,0,0},{0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0},{0,1,1,0,1,1,2,0,-1,0,1,0,0,0,0,0},{-1,0,-1,0,0,1,1,0,-1,-1,0,0,0,0,0,0},{1,1,0,0,1,2,1,0,0,1,-1,0,0,0,0,0},{1,0,-1,0,2,1,1,0,1,1,0,0,0,0,0,0},{0,-1,-1,0,1,1,0,0,-1,0,-1,0,0,0,0,0},{1,2,1,0,0,1,1,0,-1,1,0,0,0,0,0,0},{0,1,-1,0,-1,1,0,0,-1,0,-1,0,0,0,0,0},{1,1,0,0,1,0,1,0,0,1,1,0,0,0,0,0},{0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0},{0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0},{-1,-1,-2,0,-1,0,-1,0,-2,-1,-1,0,0,0,0,0},{0,-1,1,0,1,1,2,0,1,0,1,0,0,0,0,0},{0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0},{-1,-1,0,0,-1,0,1,0,0,-1,1,0,0,0,0,0},{1,0,1,0,0,1,1,0,1,1,0,0,0,0,0,0},{1,-1,0,0,1,0,1,0,2,1,1,0,0,0,0,0},{0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0},{1,1,2,0,-1,0,1,0,0,1,1,0,0,0,0,0},{0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0},{1,0,1,0,0,-1,1,0,1,1,2,0,0,0,0,0},{0,-1,1,0,-1,-1,0,0,-1,0,1,0,0,0,0,0},{0,-1,-1,0,-1,-1,0,0,1,0,1,0,0,0,0,0},{-1,-2,-1,0,-2,-1,-1,0,-1,-1,0,0,0,0,0,0}};
ineqrhsPd = matrix {{-2},{-2},{-2},{0},{-2},{0},{-2},{0},{0},{-2},{0},{0},{0},{0},{0},{-2},{2},{2},{2},{0},{2},{2},{1},{2},{0},{2},{1},{0},{2},{2},{0},{2},{1},{0},{1},{0},{2},{0},{0},{-2},{1},{2},{0},{2},{2},{0},{2},{0},{2},{0},{0},{-2},{2},{1},{0},{2},{2},{0},{2},{0},{2},{0},{0},{-2}};
eqlhsPd = matrix {{-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0},{0,0,0,0,-1,-1,-1,-1,0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,0,0},{-3/4,1/4,1/4,1/4,-3/4,1/4,1/4,1/4,-3/4,1/4,1/4,1/4,-1,0,0,0},{1/13,-9/13,4/13,4/13,1/13,-9/13,4/13,4/13,1/13,-9/13,4/13,4/13,-3/13,-1,0,0},{1/10,1/10,-3/5,2/5,1/10,1/10,-3/5,2/5,1/10,1/10,-3/5,2/5,-3/10,-3/10,-1,0},{1/7,1/7,1/7,-3/7,1/7,1/7,1/7,-3/7,1/7,1/7,1/7,-3/7,-3/7,-3/7,-3/7,-1}};
eqrhsPd = matrix {{-1},{-1},{-1},{-1/4},{-4/13},{-2/5},{-4/7}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 4, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{2,4},{4,2},{4,2},{2,4}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,-2,0,0},{0,0,0,-2}};
ineqrhsPd = matrix {{-4},{-4}};
eqlhsPd = matrix {{-1,-1,-1,-1},{1,-1,1,-1},{1,1,-1,-1}};
eqrhsPd = matrix {{-12},{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 8, vertices: 22, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{4,4/3,20/3,4,4,4/3,4/3,4/3,20/3,4/3,4,4,4/3,4,4,20/3,4,20/3,4,4/3,20/3,28/3},{4/3,4,4,4,4/3,20/3,4,20/3,4/3,4,20/3,20/3,28/3,20/3,4,4,4/3,4/3,4/3,4,4,4/3},{4/3,4,4/3,4/3,4,4,20/3,20/3,4/3,4,4/3,4,4,4/3,20/3,4,20/3,4,20/3,28/3,4,4/3},{28/3,20/3,4,20/3,20/3,4,4,4/3,20/3,20/3,4,4/3,4/3,4,4/3,4/3,4,4,4,4/3,4/3,4},{20/3,28/3,4,20/3,20/3,4,4,20/3,4/3,20/3,4,4/3,4,4/3,4/3,4/3,4,4,4/3,4,4,4/3},{4,4/3,4/3,4/3,4,4,20/3,4/3,20/3,4,4/3,4,4/3,4,20/3,4,20/3,4,28/3,20/3,4/3,4},{4,4/3,4,4,4/3,20/3,4,4/3,20/3,4,20/3,20/3,20/3,28/3,4,4,4/3,4/3,4,4/3,4/3,4},{4/3,4,20/3,4,4,4/3,4/3,20/3,4/3,4/3,4,4,4,4/3,4,20/3,4,20/3,4/3,4,28/3,20/3}};
raysP = map(QQ^8, QQ^0, 0);
linealityP = map(QQ^8, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,-2,-2,0,0,0,0},{0,-2,0,-2,0,0,0,0},{0,-2,0,0,0,-2,0,0},{0,0,-2,0,-2,0,-4,-2},{0,-2,0,0,-2,-4,0,-2},{0,-2,-2,-4,0,0,0,-2},{0,0,0,-2,0,-2,-2,-4},{0,0,0,-2,0,0,0,-2},{-2,0,0,0,-4,-2,-2,0},{0,0,0,0,0,-2,0,-2},{-2,0,-4,-2,0,0,-2,0},{0,0,0,0,0,0,-2,-2},{-2,-4,0,-2,0,-2,0,0},{-4,-2,-2,0,-2,0,0,0}};
ineqrhsPd = matrix {{-32/3},{-32/3},{-32/3},{-104/3},{-104/3},{-104/3},{-104/3},{-32/3},{-104/3},{-32/3},{-104/3},{-32/3},{-104/3},{-104/3}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1,-1,-1},{1,-1,1,-1,1,-1,1,-1},{1,1,-1,-1,1,1,-1,-1},{1,1,1,1,-1,-1,-1,-1}};
eqrhsPd = matrix {{-32},{0},{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 8, vertices: 132, facets: 20
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,24483034171371085553952995391895/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,12738103345051545/9007199254740992,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,9553577508788659/4503599627370496,38824863540916338353528385288599/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,38824863540916338353528385288599/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,9553577508788659/4503599627370496,1592262918131443/2251799813685248,1592262918131443/2251799813685248,44765443775022755566307833752773/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,24483034171371086679852902234519/10141204801825835211973625643008,53166692910461591153103775185303/20282409603651670423947251286016,9553577508788659/4503599627370496,38824863540916338353528385288599/20282409603651670423947251286016,1592262918131443/2251799813685248,9553577508788659/4503599627370496,1592262918131443/2251799813685248,38824863540916338353528385288599/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,12738103345051545/9007199254740992,1592262918131443/2251799813685248,24483034171371085553952995391895/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,24483034171371085553952995391895/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,24483034171371085553952995391895/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,34483405944844081/18014398509481984,48966068342742172439602104088983/20282409603651670423947251286016,47221509289895627/18014398509481984,48966068342742172439602104088983/20282409603651670423947251286016,34483405944844081/18014398509481984,47221509289895627/18014398509481984,34483405944844081/18014398509481984,34483405944844081/18014398509481984,1592262918131443/1125899906842624,1592262918131443/1125899906842624,1592262918131443/1125899906842624,1592262918131443/1125899906842624,12738103345051545/4503599627370496,53166692910461588901303961500055/20282409603651670423947251286016,53166692910461588901303961500055/20282409603651670423947251286016,24483034171371085553952995391895/10141204801825835211973625643008,38824863540916336101728571603351/20282409603651670423947251286016,19107155017577317/9007199254740992,38824863540916336101728571603351/20282409603651670423947251286016,19107155017577317/9007199254740992,38824863540916336101728571603351/20282409603651670423947251286016,19107155017577317/9007199254740992,38824863540916336101728571603351/20282409603651670423947251286016,19107155017577317/9007199254740992,21745302599792537/9007199254740992},{3730904090310553/18014398509481984,1592262918131443/2251799813685248,3730904090310553/18014398509481984,1592262918131443/2251799813685248,21745302599792537/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,9553577508788659/4503599627370496,38824863540916338353528385288599/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,53166692910461591153103775185303/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,12738103345051545/9007199254740992,12738103345051545/9007199254740992,34483405944844083/18014398509481984,48966068342742174691401917774231/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,12738103345051545/4503599627370496,47221509289895627/18014398509481984,9553577508788659/4503599627370496,38824863540916338353528385288599/20282409603651670423947251286016,48966068342742172439602104088983/20282409603651670423947251286016,53166692910461588901303961500055/20282409603651670423947251286016,19107155017577317/9007199254740992,47221509289895627/18014398509481984,21745302599792537/9007199254740992,12738103345051545/9007199254740992,34483405944844081/18014398509481984,34483405944844083/18014398509481984,12738103345051545/9007199254740992,34483405944844081/18014398509481984,19107155017577317/9007199254740992,21745302599792537/9007199254740992,1592262918131443/2251799813685248,34483405944844081/18014398509481984,9553577508788659/4503599627370496,47221509289895627/18014398509481984,19107155017577317/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,34483405944844081/18014398509481984,19107155017577317/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,34483405944844083/18014398509481984,21745302599792537/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,39759701109274521/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,34483405944844083/18014398509481984,6369051672525773/9007199254740992,1592262918131443/2251799813685248,9553577508788659/4503599627370496,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,6369051672525773/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,12738103345051545/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,12738103345051545/9007199254740992,21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984},{9553577508788659/4503599627370496,38824863540916340605328198973847/20282409603651670423947251286016,9553577508788659/4503599627370496,38824863540916340605328198973847/20282409603651670423947251286016,9553577508788659/4503599627370496,9553577508788659/4503599627370496,38824863540916340605328198973847/20282409603651670423947251286016,38824863540916340605328198973847/20282409603651670423947251286016,6369051672525773/4503599627370496,24483034171371087805752809077143/10141204801825835211973625643008,34483405944844083/18014398509481984,48966068342742174691401917774231/20282409603651670423947251286016,6369051672525773/4503599627370496,53166692910461591153103775185303/20282409603651670423947251286016,34483405944844083/18014398509481984,48966068342742174691401917774231/20282409603651670423947251286016,6369051672525773/4503599627370496,53166692910461591153103775185303/20282409603651670423947251286016,34483405944844083/18014398509481984,47221509289895627/18014398509481984,34483405944844083/18014398509481984,6369051672525773/4503599627370496,21745302599792537/9007199254740992,47221509289895627/18014398509481984,12738103345051545/4503599627370496,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,38824863540916338353528385288599/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,38824863540916338353528385288599/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,19107155017577317/9007199254740992,19107155017577317/9007199254740992,19107155017577317/9007199254740992,53166692910461588901303961500055/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,19107155017577317/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,38824863540916338353528385288599/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,44765443775022757818107647438021/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,12738103345051545/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,12738103345051545/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,12738103345051545/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992},{21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,12738103345051545/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,34483405944844083/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/9007199254740992,34483405944844083/18014398509481984,6369051672525773/9007199254740992,39759701109274521/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,19107155017577317/9007199254740992,34483405944844081/18014398509481984,19107155017577317/9007199254740992,34483405944844081/18014398509481984,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,21745302599792537/9007199254740992,9553577508788659/4503599627370496,47221509289895627/18014398509481984,1592262918131443/2251799813685248,9553577508788659/4503599627370496,34483405944844081/18014398509481984,12738103345051545/9007199254740992,19107155017577317/9007199254740992,47221509289895627/18014398509481984,34483405944844083/18014398509481984,34483405944844081/18014398509481984,21745302599792537/9007199254740992,12738103345051545/9007199254740992,19107155017577317/9007199254740992,38824863540916338353528385288599/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,48966068342742174691401917774231/20282409603651670423947251286016,34483405944844083/18014398509481984,12738103345051545/9007199254740992,12738103345051545/9007199254740992,9553577508788659/4503599627370496,47221509289895627/18014398509481984,48966068342742172439602104088983/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,12738103345051545/4503599627370496,53166692910461591153103775185303/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,53166692910461588901303961500055/20282409603651670423947251286016,9553577508788659/4503599627370496,24483034171371086679852902234519/10141204801825835211973625643008,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,12738103345051545/9007199254740992,6369051672525773/9007199254740992,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,12738103345051545/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,3730904090310553/18014398509481984},{1592262918131443/2251799813685248,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,24483034171371085553952995391895/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,24483034171371085553952995391895/20282409603651670423947251286016,9553577508788659/4503599627370496,9553577508788659/4503599627370496,53166692910461591153103775185303/20282409603651670423947251286016,1592262918131443/2251799813685248,38824863540916338353528385288599/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,1592262918131443/2251799813685248,38824863540916338353528385288599/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,44765443775022755566307833752773/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,38824863540916338353528385288599/20282409603651670423947251286016,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,38824863540916338353528385288599/20282409603651670423947251286016,1592262918131443/2251799813685248,9553577508788659/4503599627370496,9553577508788659/4503599627370496,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,24483034171371085553952995391895/20282409603651670423947251286016,24483034171371085553952995391895/20282409603651670423947251286016,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,24483034171371085553952995391895/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,4200624567719415541598157031017/20282409603651670423947251286016,48966068342742172439602104088983/20282409603651670423947251286016,34483405944844081/18014398509481984,34483405944844081/18014398509481984,34483405944844081/18014398509481984,48966068342742172439602104088983/20282409603651670423947251286016,34483405944844081/18014398509481984,47221509289895627/18014398509481984,47221509289895627/18014398509481984,12738103345051545/4503599627370496,53166692910461588901303961500055/20282409603651670423947251286016,53166692910461588901303961500055/20282409603651670423947251286016,24483034171371085553952995391895/10141204801825835211973625643008,1592262918131443/1125899906842624,1592262918131443/1125899906842624,1592262918131443/1125899906842624,1592262918131443/1125899906842624,38824863540916336101728571603351/20282409603651670423947251286016,19107155017577317/9007199254740992,19107155017577317/9007199254740992,38824863540916336101728571603351/20282409603651670423947251286016,38824863540916336101728571603351/20282409603651670423947251286016,19107155017577317/9007199254740992,19107155017577317/9007199254740992,38824863540916336101728571603351/20282409603651670423947251286016,21745302599792537/9007199254740992},{3730904090310553/18014398509481984,3730904090310553/18014398509481984,1592262918131443/2251799813685248,1592262918131443/2251799813685248,21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,21745302599792537/18014398509481984,9553577508788659/4503599627370496,53166692910461588901303961500055/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,38824863540916338353528385288599/20282409603651670423947251286016,53166692910461591153103775185303/20282409603651670423947251286016,12738103345051545/4503599627370496,47221509289895627/18014398509481984,9553577508788659/4503599627370496,38824863540916338353528385288599/20282409603651670423947251286016,48966068342742172439602104088983/20282409603651670423947251286016,12738103345051545/9007199254740992,12738103345051545/9007199254740992,34483405944844083/18014398509481984,48966068342742174691401917774231/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,19107155017577317/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,21745302599792537/9007199254740992,34483405944844081/18014398509481984,34483405944844083/18014398509481984,47221509289895627/18014398509481984,19107155017577317/9007199254740992,34483405944844081/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,34483405944844083/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,39759701109274521/18014398509481984,21745302599792537/9007199254740992,6369051672525773/9007199254740992,34483405944844083/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,19107155017577317/9007199254740992,19107155017577317/9007199254740992,34483405944844081/18014398509481984,34483405944844081/18014398509481984,21745302599792537/9007199254740992,47221509289895627/18014398509481984,9553577508788659/4503599627370496,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,9553577508788659/4503599627370496,1592262918131443/2251799813685248,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984},{9553577508788659/4503599627370496,9553577508788659/4503599627370496,38824863540916340605328198973847/20282409603651670423947251286016,38824863540916340605328198973847/20282409603651670423947251286016,9553577508788659/4503599627370496,38824863540916340605328198973847/20282409603651670423947251286016,9553577508788659/4503599627370496,38824863540916340605328198973847/20282409603651670423947251286016,24483034171371087805752809077143/10141204801825835211973625643008,6369051672525773/4503599627370496,48966068342742174691401917774231/20282409603651670423947251286016,34483405944844083/18014398509481984,53166692910461591153103775185303/20282409603651670423947251286016,6369051672525773/4503599627370496,48966068342742174691401917774231/20282409603651670423947251286016,34483405944844083/18014398509481984,53166692910461591153103775185303/20282409603651670423947251286016,6369051672525773/4503599627370496,47221509289895627/18014398509481984,34483405944844083/18014398509481984,47221509289895627/18014398509481984,12738103345051545/4503599627370496,21745302599792537/9007199254740992,34483405944844083/18014398509481984,6369051672525773/4503599627370496,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,38824863540916338353528385288599/20282409603651670423947251286016,6369051672525773/9007199254740992,6369051672525773/9007199254740992,24483034171371086679852902234519/10141204801825835211973625643008,38824863540916338353528385288599/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,19107155017577317/9007199254740992,53166692910461588901303961500055/20282409603651670423947251286016,19107155017577317/9007199254740992,19107155017577317/9007199254740992,6369051672525773/9007199254740992,19107155017577317/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,24483034171371086679852902234519/10141204801825835211973625643008,38824863540916338353528385288599/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,44765443775022757818107647438021/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,24483034171371087805752809077143/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,6369051672525773/9007199254740992,6369051672525773/9007199254740992,4200624567719417793397970716265/20282409603651670423947251286016,12738103345051545/9007199254740992},{21745302599792537/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,12738103345051545/9007199254740992,3730904090310553/18014398509481984,1592262918131443/2251799813685248,3730904090310553/18014398509481984,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,1592262918131443/2251799813685248,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,3730904090310553/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,1592262918131443/2251799813685248,6369051672525773/9007199254740992,12738103345051545/9007199254740992,1592262918131443/2251799813685248,12738103345051545/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,1592262918131443/2251799813685248,1592262918131443/2251799813685248,1592262918131443/2251799813685248,12738103345051545/9007199254740992,12738103345051545/9007199254740992,12738103345051545/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,1592262918131443/2251799813685248,21745302599792537/9007199254740992,34483405944844081/18014398509481984,1592262918131443/2251799813685248,1592262918131443/2251799813685248,34483405944844081/18014398509481984,9553577508788659/4503599627370496,47221509289895627/18014398509481984,19107155017577317/9007199254740992,19107155017577317/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,21745302599792537/9007199254740992,34483405944844083/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,39759701109274521/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,34483405944844083/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,9553577508788659/4503599627370496,1592262918131443/2251799813685248,19107155017577317/9007199254740992,47221509289895627/18014398509481984,34483405944844081/18014398509481984,12738103345051545/9007199254740992,34483405944844083/18014398509481984,34483405944844081/18014398509481984,12738103345051545/9007199254740992,21745302599792537/9007199254740992,19107155017577317/9007199254740992,53166692910461588901303961500055/20282409603651670423947251286016,48966068342742172439602104088983/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,9553577508788659/4503599627370496,47221509289895627/18014398509481984,12738103345051545/4503599627370496,34483405944844083/18014398509481984,12738103345051545/9007199254740992,38824863540916338353528385288599/20282409603651670423947251286016,48966068342742174691401917774231/20282409603651670423947251286016,12738103345051545/9007199254740992,38824863540916338353528385288599/20282409603651670423947251286016,53166692910461591153103775185303/20282409603651670423947251286016,38824863540916338353528385288599/20282409603651670423947251286016,9553577508788659/4503599627370496,24483034171371086679852902234519/10141204801825835211973625643008,12738103345051545/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,3730904090310553/18014398509481984,21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,12738103345051545/9007199254740992,3730904090310553/18014398509481984,3730904090310553/18014398509481984,6369051672525773/9007199254740992,6369051672525773/9007199254740992,6369051672525773/9007199254740992,3730904090310553/18014398509481984,6369051672525773/9007199254740992,3730904090310553/18014398509481984,12738103345051545/9007199254740992,21745302599792537/18014398509481984,21745302599792537/18014398509481984,12738103345051545/9007199254740992,3730904090310553/18014398509481984}};
raysP = map(QQ^8, QQ^0, 0);
linealityP = map(QQ^8, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0,-9007199254740993/9007199254740992,-2,-21745302599792537/9007199254740992,-2,-9007199254740991/9007199254740992},{0,0,0,0,-2,-15376250927266765/4503599627370496,-21745302599792537/6369051672525772,-2},{0,-1592262918131443/2251799813685248,-1,-1592262918131443/2251799813685248,0,0,0,0},{0,-2,-21745302599792537/6369051672525772,-15376250927266765/4503599627370496,-2,0,0,0},{0,-9007199254740991/9007199254740992,-2,-21745302599792537/9007199254740992,-2,-9007199254740993/9007199254740992,0,0},{-1,0,0,0,-1,-2,-3844062731816691/1592262918131443,-2},{-2,0,0,0,0,-2,-21745302599792537/6369051672525772,-15376250927266765/4503599627370496},{-1,0,0,0,0,0,-6369051672525773/6369051672525772,-6369051672525773/4503599627370496},{0,0,-2,-3844062731816691/1125899906842624,-21745302599792537/6369051672525773,-2,0,0},{0,0,-1,-2,-15376250927266765/6369051672525773,-2,-1,0},{-2,-9007199254740993/9007199254740992,0,0,0,-9007199254740991/9007199254740992,-2,-21745302599792537/9007199254740992},{-21745302599792537/6369051672525773,-2,0,0,0,0,-2,-3844062731816691/1125899906842624},{-1,-6369051672525773/9007199254740992,0,0,0,0,0,-6369051672525773/9007199254740992},{0,0,0,-2,-21745302599792537/6369051672525773,-3844062731816691/1125899906842624,-2,0},{-15376250927266765/6369051672525773,-2,-1,0,0,0,-1,-2},{-21745302599792537/6369051672525773,-3844062731816691/1125899906842624,-2,0,0,0,0,-2},{-1,-6369051672525773/4503599627370496,-6369051672525773/6369051672525772,0,0,0,0,0},{-2,-21745302599792537/9007199254740992,-2,-9007199254740991/9007199254740992,0,0,0,-9007199254740993/9007199254740992},{-2,-15376250927266765/4503599627370496,-21745302599792537/6369051672525772,-2,0,0,0,0},{-1,-2,-3844062731816691/1592262918131443,-2,-1,0,0,0}};
ineqrhsPd = matrix {{-1390735264807440175688666356357489/162259276829213363391578010288128},{-1263141805282976595730656393454296059875634256959/129179714808990451881365335705143949221903204352},{-34624238973196921219667310126139/20282409603651670423947251286016},{-1263141805282976595730656393454296059875634256959/129179714808990451881365335705143949221903204352},{-1390735264807440175688666356357489/162259276829213363391578010288128},{-276802023886324979020895840658481896763905387605/32294928702247612970341333926285987305475801088},{-1263141805282976595730656393454296059875634256959/129179714808990451881365335705143949221903204352},{-311867419475353320469282520724398592111640124479/129179714808990451881365335705143949221903204352},{-1263141805282976718866540485255142372683213511743/129179714808990472163774939356814373169154490368},{-1107208095545300078044330995351112253391586093803/129179714808990472163774939356814373169154490368},{-1390735264807440175688666356357489/162259276829213363391578010288128},{-1263141805282976718866540485255142372683213511743/129179714808990472163774939356814373169154490368},{-138496955892787688609573330815109/81129638414606681695789005144064},{-1263141805282976718866540485255142372683213511743/129179714808990472163774939356814373169154490368},{-1107208095545300078044330995351112253391586093803/129179714808990472163774939356814373169154490368},{-1263141805282976718866540485255142372683213511743/129179714808990472163774939356814373169154490368},{-311867419475353320469282520724398592111640124479/129179714808990451881365335705143949221903204352},{-1390735264807440175688666356357489/162259276829213363391578010288128},{-1263141805282976595730656393454296059875634256959/129179714808990451881365335705143949221903204352},{-276802023886324979020895840658481896763905387605/32294928702247612970341333926285987305475801088}};
eqlhsPd = matrix {{-1,-1,-1,-1,-1,-1,-1,-1},{-1,-6369051672525773/9007199254740992,0,6369051672525773/9007199254740992,1,6369051672525773/9007199254740992,0,-6369051672525773/9007199254740992},{0,-1592262918131443/2251799813685248,-1,-1592262918131443/2251799813685248,0,1592262918131443/2251799813685248,1,1592262918131443/2251799813685248}};
eqrhsPd = matrix {{-38214310035154635/4503599627370496},{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 32, facets: 10
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0,0},{1,0,0,0,0},{0,-1,0,0,0},{0,1,0,0,0},{0,0,-1,0,0},{0,0,1,0,0},{0,0,0,-1,0},{0,0,0,1,0},{0,0,0,0,-1},{0,0,0,0,1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^5, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 7, ambientDim: 7, vertices: 8, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,0,0,0,0,0},{0,0,1,0,0,0,0,0},{0,0,0,1,0,0,0,0},{0,0,0,0,1,0,0,0},{0,0,0,0,0,1,0,0},{0,0,0,0,0,0,1,0},{0,0,0,0,0,0,0,1}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1,1,1,1},{-1,0,0,0,0,0,0},{0,-1,0,0,0,0,0},{0,0,-1,0,0,0,0},{0,0,0,-1,0,0,0},{0,0,0,0,-1,0,0},{0,0,0,0,0,-1,0},{0,0,0,0,0,0,-1}};
ineqrhsPd = matrix {{1},{0},{0},{0},{0},{0},{0},{0}};
eqlhsPd = map(QQ^0, QQ^7, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 1, ambientDim: 1, vertices: 2, facets: 2
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,2}};
raysP = map(QQ^1, QQ^0, 0);
linealityP = map(QQ^1, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1},{1}};
ineqrhsPd = matrix {{0},{2}};
eqlhsPd = map(QQ^0, QQ^1, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 5, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,1,0,1,0},{0,0,1,1,0},{0,0,0,0,1},{0,0,0,0,0},{0,0,0,0,0}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0,0},{0,0,-1,0,0},{0,-1,0,0,0},{0,1,1,0,0},{1,0,1,0,0}};
ineqrhsPd = matrix {{0},{0},{0},{1},{1}};
eqlhsPd = matrix {{0,0,0,-1,0},{0,0,0,0,-1}};
eqrhsPd = matrix {{0},{0}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-1,-1,-1},{-1,1,-1,-1},{-1,-1,-1,1},{1,1,1,1},{1,-1,-1,1},{-1,1,1,-1},{1,-1,-1,-1},{-1,1,1,1},{-1,-1,1,1},{-1,1,-1,1},{1,-1,1,-1},{1,-1,1,1},{1,1,-1,1},{1,1,-1,-1},{-1,-1,1,-1},{1,1,1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 8, facets: 16
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1,-1,0,0,0,0,0,0},{0,0,1,-1,0,0,0,0},{0,0,0,0,1,-1,0,0},{0,0,0,0,0,0,1,-1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1,1,1,1},{-1,1,1,1},{1,-1,1,1},{-1,-1,1,1},{1,1,-1,1},{-1,1,-1,1},{1,-1,-1,1},{-1,-1,-1,1},{1,1,1,-1},{-1,1,1,-1},{1,-1,1,-1},{-1,-1,1,-1},{1,1,-1,-1},{-1,1,-1,-1},{1,-1,-1,-1},{-1,-1,-1,-1}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 6, ambientDim: 6, vertices: 64, facets: 12
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^6, QQ^0, 0);
linealityP = map(QQ^6, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0,0,0},{0,0,-1,0,0,0},{0,-1,0,0,0,0},{0,0,1,0,0,0},{0,0,0,0,-1,0},{0,0,0,-1,0,0},{0,0,0,1,0,0},{0,1,0,0,0,0},{0,0,0,0,0,-1},{1,0,0,0,0,0},{0,0,0,0,0,1},{0,0,0,0,1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^6, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 3, ambientDim: 3, vertices: 5, facets: 5
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{55},{1250},{2800}};
raysP = matrix {{-1,0,1,0},{0,-1,0,1},{-80,0,140,5000}};
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{0,0,0},{140,0,-1},{80,0,-1},{140,5000,-1},{80,5000,-1}};
ineqrhsPd = matrix {{1},{4900},{1600},{6254900},{6251600}};
eqlhsPd = map(QQ^0, QQ^3, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 7, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1},{-5/2,-1,-1,1/2,-2,-1/2,-1/2,1,-1,1/2,1/2,2,-1/2,1,1,5/2},{-5/4,1/4,1/4,7/4,-5/4,1/4,1/4,7/4,-1/4,5/4,5/4,11/4,-1/4,5/4,5/4,11/4},{-1,-1,1/2,1/2,-1/2,-1/2,1,1,-1/2,-1/2,1,1,0,0,3/2,3/2}};
raysP = map(QQ^7, QQ^0, 0);
linealityP = map(QQ^7, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-4121/1206,64/67,-1/804,913/804,-200/201,-257/201,1},{-3/1732,324/433,-23169/3464,1537/3464,-675/866,677/866,-1},{192/347,-1732/1041,108/347,236/347,-85/347,-171/347,-1},{4121/1206,-64/67,1/804,-913/804,200/201,257/201,-1},{-2739/124,-708/31,-1537/248,19521/248,1475/62,351/62,1},{2739/124,708/31,1537/248,-19521/248,-1475/62,-351/62,-1},{-192/347,1732/1041,-108/347,-236/347,85/347,171/347,1},{3/1732,-324/433,23169/3464,-1537/3464,675/866,-677/866,1}};
ineqrhsPd = matrix {{10645/2412},{25875/3464},{9775/4164},{14065/2412},{25825/248},{23595/248},{14935/4164},{23545/3464}};
eqlhsPd = matrix {{3/4,3/4,1/4,3/4,-1,0,0},{15/44,15/44,-3/22,1/11,6/11,-1,0},{-603/2192,1041/2192,433/2192,31/2192,115/548,43/274,-1}};
eqrhsPd = matrix {{0},{-3/4},{-145/1096}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 12, facets: 14
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{0,0,1,1,1,1,0,0,-1,-1,-1,-1},{-1,1,-1,1,0,0,1,-1,0,1,0,-1},{-1,-1,0,0,1,-1,1,1,1,0,-1,0},{0,0,0,0,0,0,0,0,0,0,0,0}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = matrix {{-1},{-1},{-1},{1}};
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{1/2,1/2,1/2,3/2},{0,0,1,1},{0,1,0,1},{-1/2,1/2,1/2,1/2},{1,0,0,1},{1/2,-1/2,1/2,1/2},{-1,0,0,-1},{-1/2,-1/2,1/2,-1/2},{1/2,1/2,-1/2,1/2},{0,0,-1,-1},{-1/2,-1/2,-1/2,-3/2},{1/2,-1/2,-1/2,-1/2},{0,-1,0,-1},{-1/2,1/2,-1/2,-1/2}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 4, ambientDim: 4, vertices: 16, facets: 8
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1,-1,1},{-1,-1,1,1,-1,-1,1,1,-1,-1,1,1,-1,-1,1,1},{-1,-1,-1,-1,1,1,1,1,-1,-1,-1,-1,1,1,1,1},{-1,-1,-1,-1,-1,-1,-1,-1,1,1,1,1,1,1,1,1}};
raysP = map(QQ^4, QQ^0, 0);
linealityP = map(QQ^4, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,0,0,0},{0,0,-1,0},{0,-1,0,0},{1,0,0,0},{0,0,0,1},{0,0,0,-1},{0,1,0,0},{0,0,1,0}};
ineqrhsPd = matrix {{1},{1},{1},{1},{1},{1},{1},{1}};
eqlhsPd = map(QQ^0, QQ^4, 0);
eqrhsPd = map(QQ^0, QQ^1, 0);
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 0, ambientDim: 3, vertices: 1, facets: 1
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{1},{2},{3}};
raysP = map(QQ^3, QQ^0, 0);
linealityP = map(QQ^3, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{-1,-2,-3}};
ineqrhsPd = matrix {{1}};
eqlhsPd = matrix {{-1,0,0},{0,-1,0},{0,0,-1}};
eqrhsPd = matrix {{-1},{-2},{-3}};
Pd = polyhedronFromHData(ineqlhsPd, ineqrhsPd, eqlhsPd, eqrhsPd);
assert(Pd == P)
assert(isEmpty Pd === isEmpty P)
assert(isCompact Pd === isCompact P)
assert(isLatticePolytope Pd === isLatticePolytope P)
assert(isNormal Pd === isNormal P)
assert(numColumns vertices Pd == numColumns vertices P)
assert(numColumns rays Pd == numColumns rays P)
assert(numColumns linealitySpace Pd == numColumns linealitySpace P)
facetsP = facets P;
facetsPd = facets Pd;
assert(numRows (facetsPd#0) == numRows (facetsP#0))
assert(numRows (facetsPd#1) == numRows (facetsP#1))
hyperplanesP = hyperplanes P;
hyperplanesPd = hyperplanes Pd;
assert(numRows (hyperplanesPd#0) == numRows (hyperplanesP#0))
assert(numRows (hyperplanesPd#1) == numRows (hyperplanesP#1))
///

-- Test dim: 5, ambientDim: 5, vertices: 74, facets: 1106
-- Checking representation vs dual representation
TEST ///
verticesP = matrix {{6730902641522717314961998953235/104776506286137515566857289990144,-390280997608381835232697072991/1864397174641101581339368357888,-28661454104902942433939732686875/599213099946195397458372881022976,-15406128800245753276724909349157/30099827352902650724266352312320,-1348940276325668500074957593851/2697085334304636491828689895424,-75141446950690149587759747394937/165616557448512116164343317397504,-4127179246096640907403890265885/41904101308994666459112740487168,2163445037703968508482316572317/8272174879337969639020747030528,-450191691851794455064904918875/9911153521006773458158718287872,2279981434851121779512083749439/17676604320812387688659128680448,-27824252277803128204504832190717/58693645000177121121239226646528,432519296535220584799240474927507/1077260866563456139894848957186048,3765428054130167415452303705125/222125502036585245242532474912768,-10521689461745455177822871802093/85753133669755553209037369638912,-1615106097963036509945373835895/10989631586614384549803648352256,-153859104600774931051039606447/20406035371046271441470712971264,4095357961966490213093023541807/10600428188431546152758393438208,-37556954633350929381541664662061/120997085920833975034182430097408,296286671065291413809687610328321/1053538385342145802784220758671360,-10037572016285418472076457697283/34633413130182945354295273324544,997853003413383634343654437239/28057515132355876009082573815808,1582119868326493885513507218639/8407088162979660786601711108096,-81569316783071114122199918965583/121058810132428827263998000889856,1120789335983075619818326397155/4134944818141064063042084405248,7914014844818656873551204740075/22266590606652141677541010178048,25236149475136229335454327319069/79666744713521896378976557858816,34436819126181817978168993557249/82379817115275568750484537737216,1075237021510564600709996702909/17773044687234827937178204504064,-23175127494363607504616048277949/210988502108587902922675355385856,-262546879473029603707919740754503/1622551957453061927871757233946624,-19280515772323983437962092252821/35728275856999840664389622431744,-218131885003462022022715316659/469355616747114736836851793920,-32956926220711635100663405748243/449227965645187879958530102394880,-995867185257037157829295479027/13278017017308155570887822671872,-34890800420277220429041632861991/74325346191872223061463382622208,4881578075620478161802803758307/43604575931687752643748567187456,-20580810229325881370831876823683/230674452417758719947424114147328,-18559593442819017269644306113629/108009397080680772287604176453632,88458460007120463175689674713969/220978085925343540969004637093888,-37800542459003165953439084708129/195948843722016143991203635920896,758858976223275895833211232655/2363840771607767955197225074688,66614867809015005947115586555/1881417544855809094232601264128,9691421936173397280519865426369/48606240382070450486122702176256,-234129344117733669655521557354443/488479183229913383369921964015616,572772271277166369007899321289/4213292614681816007099019165696,-17725253852189936798796711715609/73625179114097004834733902790656,-2467413306791997788510344280955/8988565927180644761690706018304,-85229655145351274060232228811983/280192885126197765903285898706944,-628404180535349928731333609701/3709936664406618205468571467776,-642280552501046512786290404317/6459758645495573539114734059520,-327315657767793243998783766913/3134175500792059494205132636160,3323722793616802310017784382157/8990617413053070246706828804096,1407830498052662806322035048261/2881077377630623370955825610752,35711980245977968636464561209/10093496863672162882410132799488,-1803712978445146309490912595779/48179111502188368715192056414208,-4272000456244429145286834506875/6149444231630612191866909622272,-1899152396436366206979095160857/14913336393539997612264159969280,-79885633539449837090851846233/323468803175407180235067621376,-167630647380197786990945515144791/657217633371141849077965278674944,-749163246137013580167389662235/1658390490567448669885812441088,-5658485928621560047787578053135/20374235221048913858078802182144,21899128469814271135939613863441/45568617888980620247557090574336,8995083771771060735599094535787/24917620553257582720908074680320,-4659018797769907867302859829157/45788183250861295204600509366272,6182761421693475070225869587551/60832267043382222623616446496768,-95181007750031517664768387896297/141956724170309861478622472175616,-2532845396902464879676112717701/9542449889035840280145808064512,-3617307262047392943548475040639/70268006390052649658190697332736,-74121539530598398873606680775621/192839276433825988720292456824832,-49879226967660407713626026523023/584973119586817781864237061111808,-49522201761274099182019521066591/78952935354379874649010377588736,-14421542476081339814983748532481/53054540356761081813775547367424,667312808131112830515958873725/1695014187846971091419750465536,-551749439197412304463264245357805/2671042971747034365646309863456768},{7965064963571047990661974269879/13097063285767189445857161248768,2229088198582871639444364821867/29830354794257625301429893726208,-1151744064633648628088591931673/2340676171664825771321769066496,2145096958654462396472974670829/6019965470580530144853270462464,-10525723290363199551782593673797/86306730697748367738518076653568,-31881212010323691645997977395683/82808278724256058082171658698752,20882301837660656381405878009049/83808202617989332918225480974336,-3247489166253543566073686098855/6204131159503477229265560272896,-48189951258451377090286032216733/2537255301377734005288631881695232,193422173033721230934552429571343/2262605353063985624148368471097344,1664452692166777604995330538197/3668352812511070070077451665408,-349178708316418480086063324531239/1077260866563456139894848957186048,-4137667214039165408457690077963/13882843877286577827658279682048,36628341422630448695173972988305/171506267339511106418074739277824,-104270031989255405946445474888353/703336421543320611187433494544384,-4287408942114899427190338576911/81624141484185085765882851885056,1044531660056480550698210323335/10158743680580231729726793711616,122870349026601083185477506377683/241994171841667950068364860194816,-3064238193395914605517733535229/13169229816776822534802759483392,7121989971065341008516212447887/25975059847637209015721454993408,1607187210814660852458271891653/28057515132355876009082573815808,5974129575653224600489116374775/33628352651918643146406844432384,-27576546548265815473564379749289/242117620264857654527996001779712,10895075389827495465482092520049/33079558545128512504336675241984,29490743568262358155021760113843/66799771819956425032623030534144,22882169707515382444261727501521/79666744713521896378976557858816,-1027137756604630684155139079641/20594954278818892187621134434304,-33787938972684823589097355832555/284368714995757246994851272065024,709700154888250295073392607591/52747125527146975730668838846464,-228753373493680613220504777671/1584523395950255788937262923776,-11609384448259671752805283511119/44660344821249800830487028039680,4951449166715010318244791285653/9011627841544602947267554443264,-5749845985147907118554383737101/14038373926412121248704065699840,-607520463481970650216388406289/3319504254327038892721955667968,1583274583421674849338627977345/5308953299419444504390241615872,-31391449607091359924774996275781/54505719914609690804685708984320,-11555679008077558368969397222637/57668613104439679986856028536832,-2608701412841068154625078007003/6750587317542548267975261028352,1481586222944295658850823100921/55244521481335885242251159273472,-3007045330251727214901715433149/48987210930504035997800908980224,-108240639898642410653474213424931/378214523457242872831556011950080,2075036137626593180757888594613/7525670179423236376930405056512,-5061705390633347433157125601825/48606240382070450486122702176256,-4515290081362007265787106032939/15264974475934793230310061375488,248186171944610231946489491591/1296397727594404925261236666368,382747169834834998861276615505/18406294778524251208683475697664,-479593785294655215245696025383417/2301072877358245058992820740685824,5135289724553075263003159276727/70048221281549441475821474676736,-13279245757276656800060650422041/35244398311862872951951428943872,30325921334999442226877079934151/103356138327929176625835744952320,-107839038677592866986291244713069/401174464101383615258256977428480,8878203957537922206357026747511/35962469652212280986827315216384,674059909643007544673679137861/5762154755261246741911651221504,6669803676586111336491149098487/40373987454688651529640531197952,-13773573518448295337824773687363/192716446008753474860768225656832,-231463636747097253361586597425/12298888463261224383733819244544,52000938440254358608783646009/5592501147577499104599059988480,-23562677087222900245816100187885/66877175056515434513600230719488,-21660451933343641272278053192615/82152204171392731134745659834368,94148550224331818453108899944373/424547965585266859490767984918528,79665672352385144871400198763971/325987763536782621729260834914304,-4046169211321087859962148351051/22784308944490310123778545287168,-4718857893936659579984888877001/24917620553257582720908074680320,-40123600378327465056037029412677/366305466006890361636804074930176,3966006532539263535186966481861/15208066760845555655904111624192,-61744958048349796754460953041/8872295260644366342413904510976,1462184541536367936666149952673/4771224944517920140072904032256,-517523027417861842895135851573499/2248576204481684789062102314647552,29230891278611954387812151423/48209819108456497180073114206208,-5879415085666183789715223121129/9140204993544027841628704079872,-820259240608481307307693487755/19738233838594968662252594397184,3928915770255929627217575343551/53054540356761081813775547367424,-191861865212527600876268409985853/1735694528355298397613824476708864,534768793649473304007534010009/869480134032237749233824825344},{-3342652359699167139022539790471/13097063285767189445857161248768,-1534665979565667194785895009701/3728794349282203162678736715776,8333638905581478487649145193153/37450818746637212341148305063936,227099350507606258171259080649/1881239209556415670266647019520,-2549189918856456235279214270633/21576682674437091934629519163392,-3391055148694122261161421520801/165616557448512116164343317397504,4126594342041522852890080789749/13968033769664888819704246829056,-25553532659770934830940661851423/99266098552055635668248964366336,5611796467550617950615919653593/13214871361342364610878291050496,9117296580989591680997009490247/17676604320812387688659128680448,-1436234466833322011675678050943/7336705625022140140154903330816,6702309251531395125465372072179/16832201040054002185857014956032,-1191375422275600760421122131231/6941421938643288913829139841024,-3714838494133717175410872105647/10719141708719444151129671204864,3601528570793678479734188322871/10989631586614384549803648352256,4124308810249996578507623462813/5101508842761567860367678242816,-8276048895725174667756567107057/15238115520870347594590190567424,7835751045453304933163940987397/15124635740104246879272803762176,8779360110100023196809004789615/26338459633553645069605518966784,-271312425918379852558854083675/811720620238662781741295468544,-654489203874942421078944987163/7014378783088969002270643453952,173707664538688098341627228479/4203544081489830393300855554048,40011078672628179149395582213523/121058810132428827263998000889856,6476870628947590114352801910269/16539779272564256252168337620992,16348225413394055150040310271585/66799771819956425032623030534144,1412423539468898929430913210631/19916686178380474094744139464704,-15560074540843728627741726644121/41189908557637784375242268868608,11413196293167785450985319588221/35546089374469655874356409008128,-311185536419451160233993844703/1198798307435158539333382701056,-183154853190352416769378505685/3169046791900511577874525847552,9527964545234817714684521427921/89320689642499601660974056079360,1579767994401995619705563030509/120155037887261372630234059243520,-58983201425072442429570396645023/112306991411296969989632525598720,7546869778526812900451591245475/53112068069232622283551290687488,-10854321791226946298691499424689/74325346191872223061463382622208,-627983529694430921828919399057/6813214989326211350585713623040,-3601608239468940029746861235859/7208576638054959998357003567104,53825733865033525595133408767513/108009397080680772287604176453632,-363638222449790908339937182019/1649090193472712992306004754432,-2772896998307541263493490388279/12246802732626008999450227245056,78704501027233941700112017267317/236384077160776795519722507468800,-4441638733411078661282566836787/7525670179423236376930405056512,-1753983517695115260870924084057/4418749125642768226011154743296,-1983015490753760259194503607515/30529948951869586460620122750976,29795778558961735941298899667/2808861743121210671399346110464,-821730522190183876889418301579/1150393423657765700542717231104,43622254775655200789644696661961/71908527417445158093525648146432,-2229190949124792244296451655047/35024110640774720737910737338368,75585774919127201135954373455/1958022128436826275108412719104,-99741781664673517904615660281/1291951729099114707822946811904,6483423107591433836871080431083/12536702003168237976820530544640,-108826859649811573355633862181/2247654353263267561676707201024,-3708115436847593006902357490845/23048619021044986967646604886016,3870532237408438547643378079637/20186993727344325764820265598976,23458458620045304127588238297139/48179111502188368715192056414208,-88963458112695015782697589019/878492033090087455980987088896,-3871980035763002169953081979227/11185002295154998209198119976960,-1112963538455023576784955779837/66877175056515434513600230719488,12936122378001387600986836735115/20538051042848182783686414958592,-13388686370365297202034685008483/106136991396316714872691996229632,687461546063083194339580772613/1273389701315557116129925136384,-25805768785268132047843931364717/182274471555922480990228362297344,3035961123884614377973000809937/33223494071010110294544099573760,16833355465486492538105681170713/183152733003445180818402037465088,-1964970727894378894803910954259/5069355586948518551968037208064,-711541546661849495453097131897/8872295260644366342413904510976,2753469344034912002988429924169/14313674833553760420218712096768,163965830150859070435754838739267/281072025560210598632762789330944,-851477847073082923708235893731/24104909554228248590036557103104,8631081558121231969359032165547/73121639948352222733029632638976,12855502019727594208123394296261/78952935354379874649010377588736,46112584465630507570974453164301/212218161427044327255102189469696,12901935126394094592232124130935/27120227005551537462716007448576,-3082081120485313123433067687901/10433761608386852990805897904128},{-12308668566877594927456986443287/52388253143068757783428644995072,12092521140967957947599219546835/29830354794257625301429893726208,-14083213712596794813343921883225/37450818746637212341148305063936,92003761259524493894298939875499/481597237646442411588261636997120,7679610560756775980194537637027/43153365348874183869259038326784,340123136112772266489599412873/20702069681064014520542914674688,-579058088656906051659917785793/2619006331812166653694546280448,1252597485851790063258510952783/3102065579751738614632780136448,1341426339432260279014904680505/19822307042013546916317436575744,1659762896389895632197456817775/70706417283249550754636514721792,4478680683340412049888900924293/117387290000354242242478453293056,-65818921124676081288586434901577/718173911042304093263232638124032,-17504752861222139751849206810273/55531375509146311310633118728192,14649609555556855783947125895503/85753133669755553209037369638912,5568244772200243418893459174713/21979263173228769099607296704512,4200029788309206216566429766083/163248282968370171531765703770112,958594560982315267324351401251/15238115520870347594590190567424,5866249943065863810320309015959/120997085920833975034182430097408,-184317331904959610807944722893841/2107076770684291605568441517342720,30493121432348587108320401197039/207800478781097672125771639947264,1916735419076947913376569417777/3507189391544484501135321726976,3027698756661366163018180830937/8407088162979660786601711108096,-7011527632143303094731617535407/60529405066214413631999000444928,-10482756091357278639441333963869/33079558545128512504336675241984,-965159233335537536425991905875/5566647651663035419385252544512,13376309246470951690545806114677/39833372356760948189488278929408,4564343773297586122039171452141/10297477139409446093810567217152,-15793527673123056144393926185453/71092178748939311748712818016256,-8221354054328067582757245587123/13186781381786743932667209711616,-2437813634252807701634925328085/12676187167602046311498103390208,-5140406134677040923539796454051/22330172410624900415243514019840,2458042923071639438442846292825/12015503788726137263023405924352,-3789094791399207327344993018767/14038373926412121248704065699840,6257144472287756017976805089781/13278017017308155570887822671872,-25783464512443489029188959979481/297301384767488892245853530488832,-3577775900968243460824476776259/13626429978652422701171427246080,-3225170165795349114600139599791/14417153276109919996714007134208,-6432237948330146725059274949787/27002349270170193071901044113408,-21980387199943016908202571578563/55244521481335885242251159273472,-1312598781402932334774240231143/24493605465252017998900454490112,771757724628389191007802759489/2954800964509709943996531343360,9252093020603125071725395118413/30102680717692945507721620226048,-3421517553588920851685218338275/6075780047758806310765337772032,-8036692178797023757605686441179/15264974475934793230310061375488,-1408547819020415528245761608033/8426585229363632014198038331392,-2888163320153565192792228189619/12270863185682834139122317131776,23666511371301369207549433700949/71908527417445158093525648146432,-17078200532190162108467175815925/70048221281549441475821474676736,-241158834857542647841603800665/8811099577965718237987857235968,1756547047062910353758907256195/5167806916396458831291787247616,3779762897251443412558726104807/25073404006336475953641061089280,2643594180021758600993361882637/4495308706526535123353414402048,7610427779577871392135493157/53353284770937469832515289088,-2356843676264837408634841390545/3364498954557387627470044266496,-2177432058634588749259083610997/24089555751094184357596028207104,-4665103526396426826200607265355/12298888463261224383733819244544,3201280806535036264196416067891/6391429882945713262398925701120,-161410608806950031197631073443/33438587528257717256800115359744,-141494208217268747366687361844545/1314435266742283698155930557349888,6021384781784930924475174971111/13267123924539589359086499528704,-1655063961840823909702848247403/20374235221048913858078802182144,8988879397989892264729788732879/22784308944490310123778545287168,17744240311776549859226518620683/49835241106515165441816149360640,3438262254087837165761280257337/5723522906357661900575063670784,15612377421943600808208043925621/60832267043382222623616446496768,-3256399937752352010456499227899/70978362085154930739311236087808,15792262983678394082376576142625/57254699334215041680874848387072,3811510477950869497280327681637/17567001597513162414547674333184,-50068557148236607658434945148185/96419638216912994360146228412416,-13800659133274797838172586886319/73121639948352222733029632638976,-621573735873454894736962112211/19738233838594968662252594397184,6030553951047768716924652303703/13263635089190270453443886841856,1105281663047271165454543376475/13560113502775768731358003724288,-4674699382006748209107495645715/41735046433547411963223591616512},{-327090633368046710171817382863/6548531642883594722928580624384,-1928047323478650571023557651423/7457588698564406325357473431552,-38234825510460434284189486821189/149803274986548849364593220255744,54747255947442246721669274435367/240798618823221205794130818498560,-216360402801461882898321272223/899028444768212163942896631808,4566015640403201130497595752895/20702069681064014520542914674688,-13909016036490644168562640661/25182753190501602439370637312,3141853344303619397229010260155/12408262319006954458531120545792,-18124542204482580065490405959935/39644614084027093832634873151488,-14618519850078241260678126794613/35353208641624775377318257360896,1482277437748954265127115941285/7336705625022140140154903330816,5565741942240903048049263617465/16832201040054002185857014956032,-19316195528464694586189049558627/55531375509146311310633118728192,13226066968572548015649946813/24033950019550323208810921984,-422274162265081296426255910799/1569947369516340649971949764608,-10482044688123605201385002249193/40812070742092542882941425942528,79009004507382614075163551839/5079371840290115864863396855808,-16351177517542272701364681898109/241994171841667950068364860194816,7726833739981561283835420578501/16461537270971028168503449354240,-9577766025658476406273604205847/34633413130182945354295273324544,3806812011997473757560783794885/14028757566177938004541286907904,-29412767781422284820792927730351/67256705303837286292813688864768,453393697925145878680721718811/15132351266553603407999750111232,11084083906989750041877375683/2362825610366322321738333945856,625915513667224567086643593015/2783323825831517709692626272256,9276379344889143309582885882551/19916686178380474094744139464704,73619022840303847331269059147/1287184642426180761726320902144,-55436741810449693628088929205/85447330227090518928741367808,17918628642906192932714862944827/52747125527146975730668838846464,-125315512742708073340229170281/198065424493781973617157865472,-6829019627452042968832442503237/44660344821249800830487028039680,27820155563622905575970201135261/360465113661784117890702177730560,15402786769052944015222277137987/112306991411296969989632525598720,-3009941685238754566062742757929/26556034034616311141775645343744,8441472729460510318066805448919/18581336547968055765365845655552,-16813803054441753609274960402473/54505719914609690804685708984320,19037085525017915915875680386053/57668613104439679986856028536832,627836482731444500857295588945/6750587317542548267975261028352,2335964884941219689184684227051/55244521481335885242251159273472,-26448241258577331568840314535005/48987210930504035997800908980224,-8863733085185177392277640807817/59096019290194198879930626867200,10918244757363458004678526681627/60205361435385891015443240452096,-397534564754024870790283002653/24303120191035225243061351088128,-39405774445668880447962453644741/122119795807478345842480491003904,3798321395834457122561332312559/6319938922022724010648528748544,-1025485779675473928142144807117/18406294778524251208683475697664,-295767610448657779564284015499/17977131854361289523381412036608,37253938373714922339479386493781/70048221281549441475821474676736,-1310013180864663971210484602345/5874066385310478825325238157312,1485082796732771939007534744163/2583903458198229415645893623808,-636137699796072280092797278787/6268351001584118988410265272320,26243836625394543169050790180455/143849878608849123947309260865536,-9672532141615173430492521223657/23048619021044986967646604886016,-1041222262092852620536555515131/10093496863672162882410132799488,9474362114689639953516487011965/24089555751094184357596028207104,-9870434576839988586954657496459/49195553853044897534935276978176,2615880358783174991751526209/6172738573485098349447086080,20777384628099139059579445752377/66877175056515434513600230719488,8171789141744145496993783981963/20538051042848182783686414958592,16147102055873167428354725952079/53068495698158357436345998114816,-1466999801344784960215450971011/20374235221048913858078802182144,1838616233596830228992213630619/22784308944490310123778545287168,-3049329233826455655772343254479/33223494071010110294544099573760,713752394277660764529756261667/45788183250861295204600509366272,1086316353360918510614733210983/2534677793474259275984018604032,-7961259621682300617364187955299/35489181042577465369655618043904,885863592338455966172965004989/2385612472258960070036452016128,285107274827231882339149210485/4391750399378290603636918583296,-13095012353813071510715969444249/48209819108456497180073114206208,10514190166624570382995689741163/146243279896704445466059265277952,6685455902168210414679764080331/19738233838594968662252594397184,510783025398787368764031926989/3315908772297567613360971710464,-7206245859511174300594948413631/108480908022206149850864029794304,-4782249048013131528346721170603/13911682144515803987741197205504}};
raysP = map(QQ^5, QQ^0, 0);
linealityP = map(QQ^5, QQ^0, 0);
P = convexHull(verticesP,raysP,linealityP);
ineqlhsPd = matrix {{2718108068393957120806950927944657154061353343423374196761135146085876918926088326461642357399749528204190056214113897232400855734331088393748/1496709828282151714460836196004197859519264143535443258849938814783658398067385935682102532250277149673120488600223367899186253599726374317719,2928125215191945503501558226313890040627242413249265430791058478231020645400305345502261990203161827421407735073431756007854694965915372526820/1496709828282151714460836196004197859519264143535443258849938814783658398067385935682102532250277149673120488600223367899186253599726374317719,-913787399993851004732055010036937328052901836145256673729837209727582307045785327726977109858176477910071238871375265735994855866582065460368/1496709828282151714460836196004197859519264143535443258849938814783658398067385935682102532250277149673120488600223367899186253599726374317719,-4188757583773855847478963740635095830691379535701566783217496469209765545071368361641983931274340894765668619212791577070248895156122003195222/1496709828282151714460836196004197859519264143535443258849938814783658398067385935682102532250277149673120488600223367899186253599726374317719,1},{-124361222108020482774963838991065804941353667433136449658791145352129071353230430951545549761290266774603230500336580422711787873673002369857/470604877405097083172841221294013132479416327158544670105151097943695654928460245969561908885571207337087237221648777243973342861313738816232,223145136663297645385346793608121065934885572986775966181757469331683459947745417859644094236662387363003174575789953777305758198121144991399/235302438702548541586420610647006566239708163579272335052575548971847827464230122984780954442785603668543618610824388621986671430656869408116,492797373757685870124632071274318037849897492414135873397719635815276833499154441664929652683118805243562151883989649416425259372766089169549/470604877405097083172841221294013132479416327158544670105151097943695654928460245969561908885571207337087237221648777243973342861313738816232,-246656032459488564731284540768796828698441364636425608466888988818307197876809174251814597225660446754552506213765045207425880401247624121017/235302438702548541586420610647006566239708163579272335052575548971847827464230122984780954442785603668543618610824388621986671430656869408116,1},{648631605978716660345186856868081272800716206814503965469004234762170108751233557227980541021900512017083404834561963417499889020654542878360/596510452616638752462792652696911423384913359807698062496546938475563214901951889168159921847602367586004879998670842705975094160511419651601,-57523105567761760886949734446970762519281230795815068080835673507268372781620812672287286776979517108097578275813920394378022415062155276726/596510452616638752462792652696911423384913359807698062496546938475563214901951889168159921847602367586004879998670842705975094160511419651601,-351137047052221962202595643015363011750086070288704645067185850832584559867326347124484627582561822147473627425524025387656026616119357235860/596510452616638752462792652696911423384913359807698062496546938475563214901951889168159921847602367586004879998670842705975094160511419651601,1135440379857462707819967400356081952826676270334033112735077406279528390552833027550750802496064596943570984000922027529656005715151518486/66278939179626528051421405855212380376101484423077562499616326497284801655772432129795546871955818620667208888741204745108343795612379961289,1},{409131331689486269665477612223676201289043531725047547041253216837291922218586521689437765971845314051732127205790274005082876948208157805/525654718208585083855325634326001286124048202183743316723462891732578936662328666721507804881882969036143108712132592013670715166443941882,2442905983044320435372569105593693502533584494675250573473928092692830033677527121852614188879701340243746802164060220427083576149788615517/7359166054920191173974558880564018005736674830572406434128480484256105113272601334101109268346361566506003521969856288191390012330215186348,-108037770874617021732885217618197473866378297442070825174233221967834642225889706376540775240550815228661602135906121180044468927051152363043/95669158713962485261669265447332234074576772797441283643670246295329366472543817343314420488502700364578045785608131746488070160292797422524,61365030445572367459923772684376913721996442922970916430212275003301645410831779443268386384508466613016428166047589576977435704042538720819/47834579356981242630834632723666117037288386398720641821835123147664683236271908671657210244251350182289022892804065873244035080146398711262,1},{-61448861602730427728835696499230929331895092876793440416732342509084493751809043269215517044012260857094794656421882025543494601337075310877288/69693801495487765980313465726164790376495612404343232931969864276515256304117183459265969790678554121317821534007839182816564756006913906078579,-25007017073642265167978520086854418836377676368727227080610792961161104350271466486084414228715403490810971143618313349007990747302052699766784/69693801495487765980313465726164790376495612404343232931969864276515256304117183459265969790678554121317821534007839182816564756006913906078579,39246359507674827044416824799115580659177202889948931981098188851426903795151400105405648387192462040345676545972116130612221817851092444637708/69693801495487765980313465726164790376495612404343232931969864276515256304117183459265969790678554121317821534007839182816564756006913906078579,1655037887982760517330071700229446244190475911901085554640138280760522749058039142062317553061249353041185166547218736764093914146699528605616/6335800135953433270937587793287708216045055673122112084724533116046841482192471223569633617334414011028892866727985380256051341455173991461689,-1},{-41452554033043791034269044391350494784392411650211840683402113266507853908192932091680438353065828248760252171632850684377146646971156732878/12704609298235076988602088109353882874166456473385282399535885454139843073375225910144563553427197807429673795127741468641479743029990774763,-38741180435360594444243821271070054103149948159646851168348775373630155608283811287614236064464411549735892896588867788841868727181901452816/12704609298235076988602088109353882874166456473385282399535885454139843073375225910144563553427197807429673795127741468641479743029990774763,-9603520235689028032432318458158065525164347657981517060761023345854050119273632275866503384645906553703222730183053580649089443994383766407/12704609298235076988602088109353882874166456473385282399535885454139843073375225910144563553427197807429673795127741468641479743029990774763,36351080433437036330623798602268962232223152143019762571613719684101779656936446528719323513887960755564770796441012334261007257628589067063/50818437192940307954408352437415531496665825893541129598143541816559372293500903640578254213708791229718695180510965874565918972119963099052,-1},{754876432374588993972082092615970717007493277937792744935062532000459104447523272461950113234626512996675332889749178645307248827265085720069/749706717036241976173021951822680451487015698955451544676895374706104532528928450450249436335889020871448107563381017531617876373865276401747,1359235682327875088657096303737199791363595935652977024186746381985707287995957666819598313560581906891938570084145216044089748258612372604285/1499413434072483952346043903645360902974031397910903089353790749412209065057856900900498872671778041742896215126762035063235752747730552803494,-1633260525051575530642003850354181029278738682362956971636171915106832003554412095692944097319268364306179072986275185537214066418452803983493/1499413434072483952346043903645360902974031397910903089353790749412209065057856900900498872671778041742896215126762035063235752747730552803494,-823300437570676546948385673072902361768450070383145560286526101061396267213737823365386819568298280497532076955782169417268070696361806193413/999608956048322634897362602430240601982687598607268726235860499608139376705237933933665915114518694495264143417841356708823835165153701868996,1},{-25314831000874155100647585480481613434273156717220329021387367772209672339002069427250362440804164860009325086962084991918156619877892028316105/32823515659478739344645115528818452776341426488735015637839943640378012110188201080357073279521634887703156682918351157629359798717670860227642,5234776934916417850076803150049823334484135487907327257274404133966594583647064436082059455481796704104431441286443650668879344522826734563872/16411757829739369672322557764409226388170713244367507818919971820189006055094100540178536639760817443851578341459175578814679899358835430113821,6310137374504789207644977982923662617556403104083006792829118275879672862672856780879177623683690735805155024076105842588361166148039089751818/16411757829739369672322557764409226388170713244367507818919971820189006055094100540178536639760817443851578341459175578814679899358835430113821,5325172465598512615660743693105028826688223725027389381477514832738066618326514556446303336921442257036126700483692249357114248757955569977145/5470585943246456557440852588136408796056904414789169272973323940063002018364700180059512213253605814617192780486391859604893299786278476704607,-1},{-351329504655511048422796033912116497716926604340503888619631136117949300130736271045448435259990249755814846847291034270241727994416632616140/4419952017379487022286420366826499051441810098657312526934480099406041473830286047485481579060815099997272983525202475368181414148250091985747,-8733481980947879068196210032058475047045628762749161827278699704018388977183146698782639717677659938839713295381078931578418011719513907763520/4419952017379487022286420366826499051441810098657312526934480099406041473830286047485481579060815099997272983525202475368181414148250091985747,7794680268654303273924460513014804188507280072288478089570389218326401720748757294024523263253620843595403453541844588139122573700179889970321/8839904034758974044572840733652998102883620197314625053868960198812082947660572094970963158121630199994545967050404950736362828296500183971494,1849079233695486427443629130404868807358584731842271260720821818757301369962475434092023728877741621973939432144299718265388676669838205708117/2946634678252991348190946911217666034294540065771541684622986732937360982553524031656987719373876733331515322350134983578787609432166727990498,-1},{38493262647254930644529597565895974036866224766110536568604853500776023780272867395957475442151913956587191707644357530205122885377652254090484/13377126136813585027378155451414044247846381827358657636290016488676103234736375009321616875351867026377690828892153432924527960101917174711317,-2208712362281773402832827420557139560919554704545819429622808933969483485827197699486037004208644306025581627727337013469223847706853356203584/1911018019544797861054022207344863463978054546765522519470002355525157604962339287045945267907409575196812975556021918989218280014559596387331,14088923704544046327153444000424098424672227097609946035902482003932402620612578404981641679245570739629127581768251314766666021352461532296057/13377126136813585027378155451414044247846381827358657636290016488676103234736375009321616875351867026377690828892153432924527960101917174711317,-32831825911477534610124696070809114266428925806167006364425352725791609443891489635577088582397494078698590487715362366131994447236785198664648/13377126136813585027378155451414044247846381827358657636290016488676103234736375009321616875351867026377690828892153432924527960101917174711317,-1},{-56470230219575680624295826795535827050486451645144973866388980151319648300820251550534145203042418919167317033550544174164953384072733853724789/81921440333843189565723038183430873515925275530169867856172637490070545184370590165587577772990766848698062054947585675516661274031301548831942,15322958889931358455740423223144796307894830991135662802549211214466057746189121141909150546347576448844996400872025374616841834185032735067328/40960720166921594782861519091715436757962637765084933928086318745035272592185295082793788886495383424349031027473792837758330637015650774415971,20342363729022131597117442481295787782858104310644247467196785891703043516541840458278889908206275082655646235645960418834162741620152339134585/81921440333843189565723038183430873515925275530169867856172637490070545184370590165587577772990766848698062054947585675516661274031301548831942,28362750849386651019379309425610065247829277721653483939432652711735682067807678330358683421997197483973743354875112835093605292651547530153252/40960720166921594782861519091715436757962637765084933928086318745035272592185295082793788886495383424349031027473792837758330637015650774415971,-1},{1094300744040175485417172826316478357386064277344475074468633637541480295925105214737059729729033831587533786193947006803601391495879517843969316/4416647921713561479448016905512623423288475176336521570816871472706723845528335094397925904172754885828189756003003386648657860202387840345474797,-16345939334107103268858702857739963031768453541172586418468525219437711979309782765299889143198759412071848992447969877961380103529908259620190336/4416647921713561479448016905512623423288475176336521570816871472706723845528335094397925904172754885828189756003003386648657860202387840345474797,2867043564580721948965932015023145273287223365339366778288281617530377616251961468504141107440822726628813804300617763200020404841190362935525296/1472215973904520493149338968504207807762825058778840523605623824235574615176111698132641968057584961942729918667667795549552620067462613448491599,6763326410822334521806314494028527748994012354262547510380291937571166926986415019249192228382907252505500987821986929041936815243876554025437384/4416647921713561479448016905512623423288475176336521570816871472706723845528335094397925904172754885828189756003003386648657860202387840345474797,1},{-13026625095157353083522903989556857953456521345144869833591625639862321582030488809263712711353407404721792509623289665388909588839635524081/25554129649041141617997307801964221877052922904104952129884714234179743107960678545557717585122134779359230712469381176936085078324070534253,26812120368524578389586619558340772760087066887210431274528806125878675533769709603381067514972074311107608782814977326305396316527634694888/25554129649041141617997307801964221877052922904104952129884714234179743107960678545557717585122134779359230712469381176936085078324070534253,-25609358729523805434895946358813765745365330808760912207830919249956044298005854106847617841408325851705608020743816129386125463244021442640/25554129649041141617997307801964221877052922904104952129884714234179743107960678545557717585122134779359230712469381176936085078324070534253,183667136143543741568787757634475790729200378643176087863931903040743478402471750318147445629018589854243633718384141778192629492536732018502/178878907543287991325981154613749553139370460328734664909192999639258201755724749818904023095854943455514614987285668238552595548268493739771,1},{80538605725059753696710468359407128381977676853263277160505323169209763144793136124792491732623745251430291791280012985465616224324822801656/814072822526220781787876018306519089109427912830610044397934643155900877773018228093447435130474428366689048445381343120304061385221365663925,274244338632116725286552002693374383752985358448882227687105618312577119031237807208159494519993274002599669350746737053557607673941440374057/814072822526220781787876018306519089109427912830610044397934643155900877773018228093447435130474428366689048445381343120304061385221365663925,-419638531461477579247696927193519835895661916297763495782855012416524335135831439727002431922696144575384415857376700261017858740430846664182/814072822526220781787876018306519089109427912830610044397934643155900877773018228093447435130474428366689048445381343120304061385221365663925,-4305303219098812208822253950579950806245715267662315653992271332060324033284752400572228028793972906789210952450273439722919970433626950468523/4070364112631103908939380091532595445547139564153050221989673215779504388865091140467237175652372141833445242226906715601520306926106828319625,-1},{138880814688861271539890551506244931033879642110726500320370228455708895695556500904795012619301301216414270886634907478557234915041394800896/81322103937199778207488253475460937766744890725971025828718696529388440500513784114858906708921647352359587364082681665893356000826109653103,5176730477759277767841319080699310360045567305341730166487836047532993579902112938604907775295608552746456073926591212801981366254748289067989/1301153662995196451319812055607375004267918251615536413259499144470215048008220545837742507342746357637753397825322906654293696013217754449648,-16164219036907232332796092483105457421604589298283492949627580853593925559886022478113371464036234887601636900175419109429284311070118957822971/2602307325990392902639624111214750008535836503231072826518998288940430096016441091675485014685492715275506795650645813308587392026435508899296,-572927127502090463174708036027790458243236771524864121770518379484771361421024951932348277489323179279557047649837875957874671545069550972811/650576831497598225659906027803687502133959125807768206629749572235107524004110272918871253671373178818876698912661453327146848006608877224824,-1},{-1250093810958126053653459845747442279164072256503541448323615664087823630841597755560582443679737455174891238528251292280710846393537007497319/2487694650987856535189745194384736449431721225366113777661170005452806167007215587449657026039659135841574100734414065870874012879491401125591,4555416696921883607384788973267197733584987948303431156030334396027399464457135343418006060111237700840853772169565915955242649114531626565563/2487694650987856535189745194384736449431721225366113777661170005452806167007215587449657026039659135841574100734414065870874012879491401125591,22243364802772657992783595645522362737701800152414354370601777705002356140188030898958801799114653801006036937243139465874749747157421508037671/4975389301975713070379490388769472898863442450732227555322340010905612334014431174899314052079318271683148201468828131741748025758982802251182,-7571432321322287072630019228896949058050546604018071397109359334267877112788968694172075326401467810194632021223875784799757918978464224013358/2487694650987856535189745194384736449431721225366113777661170005452806167007215587449657026039659135841574100734414065870874012879491401125591,1},{3084756172932457599110685793235886553200749632988432528838240727841726880058974310099627102351364794079388600939830403136312568788822152931738/3805027445109359785658291798712257901280169813597612101336692725128592706451295629226763600403309934396735146151731367000145237714343105381073,2671218212318971476984886890763408758352197586438775593392423349884696988373314449716313020850266344446633503168762561840028237844867111907904/3805027445109359785658291798712257901280169813597612101336692725128592706451295629226763600403309934396735146151731367000145237714343105381073,4760182858239919851561294875725857044713762734710353132808990163255068845621245402411487698315918992728847934041663682651284398923507735064870/3805027445109359785658291798712257901280169813597612101336692725128592706451295629226763600403309934396735146151731367000145237714343105381073,-3210338253756300382557739570845696229643425219412081011936522495198026088207814967677519432110306320568021098601698651055277411361859844083156/3805027445109359785658291798712257901280169813597612101336692725128592706451295629226763600403309934396735146151731367000145237714343105381073,-1},{-86015053898291413891942531417939756062823369588140910994535539717978837624615715017850356038341000037859422202588951301697537953526917812078912/124258234568503569335469062015502397554341492677284401520424418747293081574084225940940375849225468084674544785046836294598604597043725350628989,56841002496280516575866690182438194103540582806302116747347299531662403946083028833690784299932760671628407904712828670988165935611265275883697/124258234568503569335469062015502397554341492677284401520424418747293081574084225940940375849225468084674544785046836294598604597043725350628989,44728750677717838419820867553135528769403703592048225351942133901794775439557872512928177045378915122094447151441447840078422044173555962196489/248516469137007138670938124031004795108682985354568803040848837494586163148168451881880751698450936169349089570093672589197209194087450701257978,82835408791416289433005492518445595660220667581822376475947107019753776547827986145922016140199267141866727964417131857212047587503020250821002/124258234568503569335469062015502397554341492677284401520424418747293081574084225940940375849225468084674544785046836294598604597043725350628989,-1},{-1262002724744332938497224624543478042670563603232293296484819215562979809311915801380649634054054682121598041084200490475443145992561665022562/906031161699014762796333114799566420435978955879524550317837720178062988216366222344641757848983654984524739319543862078982866689244231446203,2874582975561658511148737816036653052979630501879886628796861570368026043239050666110508616931075057459665682836379017272641784928225612749724/906031161699014762796333114799566420435978955879524550317837720178062988216366222344641757848983654984524739319543862078982866689244231446203,1488148209010569647318121642909910468393322036751023240913467344637849390710875738734596641855388154340315474894803320075533603279534047686517/906031161699014762796333114799566420435978955879524550317837720178062988216366222344641757848983654984524739319543862078982866689244231446203,5501430678636107785157572103556786243841733039119609598725728047869150144872815585619918589762812420166398904170433064912988753626192919689479/906031161699014762796333114799566420435978955879524550317837720178062988216366222344641757848983654984524739319543862078982866689244231446203,-1},{1408384172598150309169120179821185913820525113694275929761510266554262209093917268885617924998635776931388608476708048900208082319769029681668/259723696331545155382799160307706464064944990492475672687499510831127379884484345470837688717043688817169721208981048437781996783495137775501,-1156154361742988710083874521642203751142206474397480011926998597037550667654824161485747481715603885694909078104536285298333319973359358179888/259723696331545155382799160307706464064944990492475672687499510831127379884484345470837688717043688817169721208981048437781996783495137775501,-1308537100137227794535982097379958408672507304856366445426313550771467791729648476670176531938762680560782879961954900766944238318704434892130/259723696331545155382799160307706464064944990492475672687499510831127379884484345470837688717043688817169721208981048437781996783495137775501,-330663413617023495269305597274315874341288379486280236550939447188699159703957096623865644518686114249212448580694658826071769914584173152969/259723696331545155382799160307706464064944990492475672687499510831127379884484345470837688717043688817169721208981048437781996783495137775501,-1},{-32730881638743912135182113686914392195334447684933487056968649984297157814157533437822969631453159141752683687065909611037614575166808218309/127299737918098017969561505521029673773381430078532011547631758896366359942239478857920058762577000084894563519617167528770663551979205716486,32770024269979145237872097610744010053994466342944298252493043293779761271370354525630089450210828876840521336752947276284498066890404901632/63649868959049008984780752760514836886690715039266005773815879448183179971119739428960029381288500042447281759808583764385331775989602858243,249690303278903177701930287299411940988821714204949974614105804463994393719736950144058901676230563531994538194681580846614448344539372522475/381899213754294053908684516563089021320144290235596034642895276689099079826718436573760176287731000254683690558851502586311990655937617149458,35787862790602060290768084784873445710034185003832891769987926460090650677813216095651189878789330577682056775839578635217102778649850949780/63649868959049008984780752760514836886690715039266005773815879448183179971119739428960029381288500042447281759808583764385331775989602858243,-1},{34568938505965332999424311082704710019963888467230286967750215433542882519647169144847768623564878133806596593240312074102316134398019472/170471928141796814680719074640230919955762360167475195399102929430321627654723182495364669827324969245665445626341563197785476206651283237,23523266691140930719178188708825600420781735958629143362370833525729376677052669491188510140152576397971507941774909253753111682549293085898/8353124478948043919355234657371315077832355648206284574556043542085759755081435942272868821538923493037606835690736596691488334125912878613,8817191639158470418755875566622703376622415603452644200973541234931488794030300999489507408483648039798777204528526640878988054855652284279/8353124478948043919355234657371315077832355648206284574556043542085759755081435942272868821538923493037606835690736596691488334125912878613,-26985989677670076531367686637645575694810531721384902435113668965075422112877293486103501850295623059931683494001039176054515253583920263253/16706248957896087838710469314742630155664711296412569149112087084171519510162871884545737643077846986075213671381473193382976668251825757226,-1},{-5223280158148706751168696604790107078406950197686145479048222765371919489008139955509319288905112052895730574000542245328856475093993761324134/102027886835169929954787775173030824502063562039259043995806156654046623916127175546524802085177955678069375539061297797057766520279335501798563,-46567942814902868651561163695400847608300094288160213785954168370524540163600419195554842233022804028040231981830537490342215624457525221782912/102027886835169929954787775173030824502063562039259043995806156654046623916127175546524802085177955678069375539061297797057766520279335501798563,54683577823404925333910001064068976836168310573589431233407246637610531621791466380851392170182231685181100510975630833275811104278527281589732/102027886835169929954787775173030824502063562039259043995806156654046623916127175546524802085177955678069375539061297797057766520279335501798563,105353787443374662852800672719013608157071861289020333591390432412182089693392620308426694541151485827540114077436844004067297352089803674669780/102027886835169929954787775173030824502063562039259043995806156654046623916127175546524802085177955678069375539061297797057766520279335501798563,1},{-7372535209599977215601845544477084517370759427731280731992440475149932697288744671873314596211346306883262055502956759701893840722410978943596/9833144917509425182003409088685183839280611563069878697368630916654256059306097470523508071913828776990948092743560335440889559115314560066419,-13285144852879802090427791492157083714832174079831488124543108905903889016467262116304594321831889220047109999437480382362464279489407960868612/29499434752528275546010227266055551517841834689209636092105892749962768177918292411570524215741486330972844278230681006322668677345943680199257,-5376205633167692062620599058049523442028032985450436543629486361016805010200806327550567282515919079888927552487697685477151788059836802754060/9833144917509425182003409088685183839280611563069878697368630916654256059306097470523508071913828776990948092743560335440889559115314560066419,618480004058386534310650622968021663410081771779476366047834156834644558502025291660971680585314103133910631933267281032148776198517083372024/9833144917509425182003409088685183839280611563069878697368630916654256059306097470523508071913828776990948092743560335440889559115314560066419,1},{-5279933947441881491782883928058073807752129611375252905033700118320375626122014902787017291846889649457639054976166890411041021469364038803404/12589914908491046532987918695438695242890857878736120105764541675079943403086403215322714442488643853393107099839468320857432367319283567351987,-14240434343139352762667546715617619939733150572036683543621920858174170678021235906913170126907709561416956917247801059636812875680866300019826/12589914908491046532987918695438695242890857878736120105764541675079943403086403215322714442488643853393107099839468320857432367319283567351987,64969505409760048479609513830828055932622187057004866687784170270720332844603472908835528943387710289343976684575077627881342931029552400096117/201438638535856744527806699127019123886253726059777921692232666801279094449382451445163431079818301654289713597431493133718917877108537077631792,54515920146448899746065662236067332595551282381600392718818736180343766142806159217973021593655804830631263835467035116158326702890245612846325/100719319267928372263903349563509561943126863029888960846116333400639547224691225722581715539909150827144856798715746566859458938554268538815896,-1},{-130899249775157431491937084173939129657256827078449825629724843716693929346159536750598765726234901811672426258334768779409009599376647694824/292896443118049860011572166485283141037227004608175199731199670290521508203467667147491638510251795700229966678678383644030164502723222267133,1346602284072203496339400863367137676392566046967315704909289562055103166995698362539128412809708673136213197288467943537925913809431560212344/878689329354149580034716499455849423111681013824525599193599010871564524610403001442474915530755387100689900036035150932090493508169666801399,-1472569072171462891213205320182738480529839356593616635392750420545311106580400944312269254603802327820651654378803505957705131981726411213008/878689329354149580034716499455849423111681013824525599193599010871564524610403001442474915530755387100689900036035150932090493508169666801399,-502728103039986709260484584816697907906208158145245106564867000764117033902578820846993186216871408692843784004525585841236235655596995080032/878689329354149580034716499455849423111681013824525599193599010871564524610403001442474915530755387100689900036035150932090493508169666801399,1},{-1863293070677956086277236826374723160956997469379144278007531272472519728673267022649860372137543714819019720639905878618585800922906193828180/778498977285961938796859797578928629713117131605223454500689335933292602343950276647016081417898048836880039289272093178355526469258979729309,-2668445189329329079271175953456827146701303586793856505851530223375492013629271255412638880897962468257083255446007316268461330579565841946280/778498977285961938796859797578928629713117131605223454500689335933292602343950276647016081417898048836880039289272093178355526469258979729309,1368528911174938247308313497745284234881650751593563469870580125992545854877413895492345988119011618159494809831252436362395042604294124384412/778498977285961938796859797578928629713117131605223454500689335933292602343950276647016081417898048836880039289272093178355526469258979729309,-403288343626648569150693438216947632390704964654453426608327601616089310902369507746589932052167098800008108557604387565091953884539634864398/778498977285961938796859797578928629713117131605223454500689335933292602343950276647016081417898048836880039289272093178355526469258979729309,-1},{275841380215428074587009557051759913883915939559053400274077758587208869359976313075324218188596038119168775222825898072787559111901791575442/257005826761377679225924603246719411590221025992708539830179914291935875934253277663383684686024807595036822320025158946119932692165980708695,190364921779018840736909466122301213151932355155316659171463415106220239375173524852110458265705682483469868985078687549041436905980886725024/257005826761377679225924603246719411590221025992708539830179914291935875934253277663383684686024807595036822320025158946119932692165980708695,45489522242933339623029710146801935222482225286502399279939680114996309382701184124422146930318187254664680597111914694951816743769782975854/257005826761377679225924603246719411590221025992708539830179914291935875934253277663383684686024807595036822320025158946119932692165980708695,-225270395829656909150134344911607450334818258078692734537750937409755337821430121990623010754752668439959292974786066304376274470895777165116/257005826761377679225924603246719411590221025992708539830179914291935875934253277663383684686024807595036822320025158946119932692165980708695,-1},{339878630471322462373894858374377643192824330875494122454792684494442668797192372760547853082357719997224369197999545021948388481679191901012/432168144701135074080984324917830838841673664619373071276825151498876374928012483248574784504112887659283193395109689710931938030089726555505,-100512255898543788398492589448912094996232404022855278208300644527658250168464643863677809158863538359643671078010576403991006777696705280851/432168144701135074080984324917830838841673664619373071276825151498876374928012483248574784504112887659283193395109689710931938030089726555505,-608742378457027302419671803411097086935608798512791175982010348831345347370919619903992646500702445425100658356343946226397311610289283410574/432168144701135074080984324917830838841673664619373071276825151498876374928012483248574784504112887659283193395109689710931938030089726555505,4247610952185853691010977963040611115941719314547579888016854294146029462391858605479911260941695269833579317976296336290923717648679417489/12347661277175287830885266426223738252619247560553516322195004328539324997943213807102136700117511075979519811288848277455198229431135044443,1},{119386781949265351208702234665306041253188789798366758122427326259752701094857388916246301322607263583238257776299622575410771421411847976733012/229066383572867593481887191256890537885515393020218639478667622562626409912014397541479910278449624316722044268093574896382260915052758398564893,-356578233745563139564925315441094590939990297814408934039979467726189359286787444664588413540283958938747282686817011725229629068775502481714480/229066383572867593481887191256890537885515393020218639478667622562626409912014397541479910278449624316722044268093574896382260915052758398564893,182074711409408932810619099967591961631992231970316320040590284832802911339444210919123222298955782567493175989494818883818784815488002825377152/229066383572867593481887191256890537885515393020218639478667622562626409912014397541479910278449624316722044268093574896382260915052758398564893,-562449719990039215875537592085866872961482870297261710742675831309510793968953082977910363197181030436687420158830570206144110352650780913527416/229066383572867593481887191256890537885515393020218639478667622562626409912014397541479910278449624316722044268093574896382260915052758398564893,1},{59605362079456153587322528008059919786527501766007253005808237938413279661825369454188860452660458177508245035862961492269808338245292965221804/34490059867667185776007574229530942860520222261487795944037244003329616621304601568782516889387655296620388647820446130023695351016662181497413,16970404466545355816266947978125156587378916645995057807156721504161366039474769078844940710496461246426821933535515713859692363167318957593584/103470179603001557328022722688592828581560666784463387832111732009988849863913804706347550668162965889861165943461338390071086053049986544492239,-20516018679721209928422185538366361096059736703668427929444686904042317988160422338306297925276835910477216225698147417613542204802549892351796/103470179603001557328022722688592828581560666784463387832111732009988849863913804706347550668162965889861165943461338390071086053049986544492239,-12412447045845141911297094967760825378488808115651312609088713907640319660525095012649261657135149171666165987379600015396116834320159526366088/34490059867667185776007574229530942860520222261487795944037244003329616621304601568782516889387655296620388647820446130023695351016662181497413,1},{-89746290961073795319127951736956094388090873627379767061975542364008089221076868774309204566803156514452269715264824984704170815906980320656412/104027858147756084025450024146840820919001985530965407085676828991350133685772835261015956355514601599634690468893982309592012232149917586085983,-35794329418040487531352726503266946610410801489752801880184218194006802781626082184280949501622306492727734865535942268923111883964950907291584/34675952715918694675150008048946940306333995176988469028558942997116711228590945087005318785171533866544896822964660769864004077383305862028661,83720852447826045801744754772997166409635401088553677195836616946573922614902778107711119596026032198767297132873483320412866896188002873467158/104027858147756084025450024146840820919001985530965407085676828991350133685772835261015956355514601599634690468893982309592012232149917586085983,3964977599993318394875505552266550340776957707140295700376995471145966653233239067863349386469939120137927539929427056923739715267991639254892/104027858147756084025450024146840820919001985530965407085676828991350133685772835261015956355514601599634690468893982309592012232149917586085983,-1},{-701306077670736130035012363348174022798909079106488951654303559895435938450215565931673110398669248117232103506176759942425149109025312379762/274392593839690015407168597611175807977369966261006889577732128833908765904989575322182344581044910903939338825323000143246936015435357971223,-136841049817215192332324945948724451483075386015848663086486533123552320643803419836237115367046922191169056070348682841218141818764315681117/99779125032614551057152217313154839264498169549457050755538955939603187601814391026248125302198149419614305027390181870271613096521948353172,-1288463082426716020205000753276123663877341995837253787991700363592893094031454981848852566749285968016157014437804751010299596937279828929097/548785187679380030814337195222351615954739932522013779155464257667817531809979150644364689162089821807878677650646000286493872030870715942446,-5637736156018662428337545914633337241719328468296187239500704872167088102790430793709780171232854613662967634449339333301993697147613713357099/2195140750717520123257348780889406463818959730088055116621857030671270127239916602577458756648359287231514710602584001145975488123482863769784,1},{42076110250123310145213874601119358853267501114984383874344271639039765731275608413463822147554683047153554869932680181308254528283099287049/154482787195310720426987536166095434914913280981838520120344167263751317283510745689687435636568152300740784749835552908914809518145313146710,-18609002606136553028510753954595408149346454916156662099114072619757808243879946161012450820793913012241718430466672058728819294740443016007/25747131199218453404497922694349239152485546830306420020057361210625219547251790948281239272761358716790130791639258818152468253024218857785,-4150564745433110162281858952317362722151038497980229068902401250154445069770933796030787191349195073885553588635978873179930365248195419411/154482787195310720426987536166095434914913280981838520120344167263751317283510745689687435636568152300740784749835552908914809518145313146710,202422030650843780811822147331670556312510911723356755854143081097931949582199487320864432344840053040293159268056439766177904555304626346801/61793114878124288170795014466438173965965312392735408048137666905500526913404298275874974254627260920296313899934221163565923807258125258684,1},{22658182796958838339859052663821573686875091056251691422495504943839014016333921826830238678374403135420868172101722352310634373158938094533147/64460734991228090306521638799796760003582446176262326346769581507016857497687738557444076116419934123752459332972007665185320436234726466694756,-5384181354035391894771847986663094493866037180694217500800470027186098229103339972389023867511570756206030299210781247947993555709170239661600/16115183747807022576630409699949190000895611544065581586692395376754214374421934639361019029104983530938114833243001916296330109058681616673689,8641061262327298366584642016881806165291491291050778391735584426972813816159182059667700637178573678286904203232474061728082954764475806275619/16115183747807022576630409699949190000895611544065581586692395376754214374421934639361019029104983530938114833243001916296330109058681616673689,11515381574149199487592065242531868274212303300469125118814634895093231053515208101629937957894313330275499346985250349045924429626123756131430/16115183747807022576630409699949190000895611544065581586692395376754214374421934639361019029104983530938114833243001916296330109058681616673689,-1},{-26158582156825723675423085970606059583092950019161126135012244078761704320868685225777008207416158018999173913132930280117185101880722782067883/1284690463554995456830688828539932279065563085756222056906076810512856200080098566365413317767179850486889811061177280082193979293465409938189,2673333532478790682365686344570887054096058271109015102603583675434982225984900087341631235223770304415118916589473615741650027611834453695114/428230154518331818943562942846644093021854361918740685635358936837618733360032855455137772589059950162296603687059093360731326431155136646063,1358005336087098334218173556523753194937097888750289483261421980145208419739632523985447531116958129336829209783099846220829159292434742536825/1284690463554995456830688828539932279065563085756222056906076810512856200080098566365413317767179850486889811061177280082193979293465409938189,539681040993355944019082500679130357669850872798107222042814388531890351149793507327984139578389504357269616699961018143882679672584993838494/428230154518331818943562942846644093021854361918740685635358936837618733360032855455137772589059950162296603687059093360731326431155136646063,1},{-165426755745030357051913929220664156495738957408019973062955895976814018356404342658117274122283211440400000546796800139212939447223065745610/177105822401833985959025888097984958541944340595610783669339054172218515247123353818667374373942530315446211495931541371663695684295030750331,20031127574917433190896436827715767140252858060714093800086228309946217797216674949430689233620365472233931941116028644911663603261237783743/177105822401833985959025888097984958541944340595610783669339054172218515247123353818667374373942530315446211495931541371663695684295030750331,-1336702872582738390914659543950892916415545487399764185130148858548036218115143327846859765699834252783824282945242101015023379761560050663261/1416846579214671887672207104783879668335554724764886269354712433377748121976986830549338994991540242523569691967452330973309565474360246002648,29307938129676812890035971067743693547804280310195910947462212338611872625227600312087531605798723236851600385298664146256839536776163710498/177105822401833985959025888097984958541944340595610783669339054172218515247123353818667374373942530315446211495931541371663695684295030750331,-1},{92972613186272151757945561151935846832634649823218741799182153764689050444057338634881227300657400624152322873652301474610763643460645155700/781505146845236172056561866757575452619487952827929904728786799196299036222959576481605011497458601548706182521900191039005951715605514098357,-3560191010562613161393822599502536770998723645096099706851107983987885849275376019782165052380930260334043810853575224508305675308226465807158/781505146845236172056561866757575452619487952827929904728786799196299036222959576481605011497458601548706182521900191039005951715605514098357,-2000362923579016925603569200115485130374449995478775101405220358153139032170134602713018620386590387252153061930399567321389676001825220241592/2344515440535708516169685600272726357858463858483789714186360397588897108668878729444815034492375804646118547565700573117017855146816542295071,-12968266265758672585640108447261179659932165553365021926567145892099797156070914761442474126872921460951500881108975811552616492927745750165850/2344515440535708516169685600272726357858463858483789714186360397588897108668878729444815034492375804646118547565700573117017855146816542295071,1},{488867705520036575944849537371203431723088090246313366261441531542398252208718321876517945521747615699275043182630046608040113499949639498/87481415950594221116074162843614738180998918441406141522090201486162049451564703862217383318581596115917876985186661607646199692330399084117,50527928592612035123884210299004804289805084788240493331000239011143040497381569853754074441905165781265713769270707894801089340165736798936/87481415950594221116074162843614738180998918441406141522090201486162049451564703862217383318581596115917876985186661607646199692330399084117,21756190601291985146492090475201292906195039781215200626305706494148517130658798892609133733976769347812914398105761051768812778668753778136/29160471983531407038691387614538246060332972813802047174030067162054016483854901287405794439527198705305958995062220535882066564110133028039,1966561266818023070157326082196159184847159713393952732006177672691575166201577064736161310688027006445094522652966838877607721316776571748/29160471983531407038691387614538246060332972813802047174030067162054016483854901287405794439527198705305958995062220535882066564110133028039,1},{-155473355972301760823245322096420369673739783116948185381602480851836737491811913569671828481438903703581408729270565354173437886333164845279361/177578427711393221842263141654077642822169249617003691214332816163367607720060976109440321627606225987543176574043885166695145416362182875817454,35324168540592549052409523805096288299104071953638353076473608816139032974607698057227098770823141251397143648724011661675341509902850953041696/88789213855696610921131570827038821411084624808501845607166408081683803860030488054720160813803112993771588287021942583347572708181091437908727,33864016394049782137053321868824188497106412768241662666802027444114321946432342702543449823933163583901422655879281231237764949141097921438293/88789213855696610921131570827038821411084624808501845607166408081683803860030488054720160813803112993771588287021942583347572708181091437908727,105572182550088404536164665779599087410562729892172368607416742063589038921273870482724418722584503332007002968847030065073844905302354042728004/88789213855696610921131570827038821411084624808501845607166408081683803860030488054720160813803112993771588287021942583347572708181091437908727,-1},{-497228470374884912573612216220209849085904435885963165636414851363500453904034821761291069227301698747577249270166611936587018550310044871348/811880471768452133752062707069609126314331058196888472239170734919372060863013520512854390101698691716198430832011997657961656305527351026069,-458786558125943762299321586431136904730361409596651736643738748952558696356471807166122537781380704161949077838371494857776722192432602082432/811880471768452133752062707069609126314331058196888472239170734919372060863013520512854390101698691716198430832011997657961656305527351026069,1420761197634039228254031918035912337470278304098545402826394527936540099108155913008468421672898752440965375489225185599955941558091769962122/811880471768452133752062707069609126314331058196888472239170734919372060863013520512854390101698691716198430832011997657961656305527351026069,-1523442699270330656213930932234455528831172726165919250528081053143160002392685329567499423564824946350749880639080394576288848694109339324380/811880471768452133752062707069609126314331058196888472239170734919372060863013520512854390101698691716198430832011997657961656305527351026069,-1},{-821194387156718364254710955373008370210859108608810789135872751492065159610720988428722298327044054710224680679423933829253690936616608495009/228152133736349049861654413101512818010151653500156693614353491767284060581674909748611303842633938355632630881257600080806712835483822099721,3339667412573537242515224609653758729505806871390983801614813933715449739637332983905436811600434329693974735222506274786999102820380842735481/912608534945396199446617652406051272040606614000626774457413967069136242326699638994445215370535753422530523525030400323226851341935288398884,-709587413380799654957304329950641004503663725461966952400702508017365559156954216531191843716058010940667433911804872716452045844189408452945/228152133736349049861654413101512818010151653500156693614353491767284060581674909748611303842633938355632630881257600080806712835483822099721,-891757003001609054620881135260832219796421305433275840552326469142653311742289923786331675094757120789568965262469187616603829832640402592122/228152133736349049861654413101512818010151653500156693614353491767284060581674909748611303842633938355632630881257600080806712835483822099721,1},{21981787842543640345853055985594560584538858004446729683090243336644316862242938333299901468007918497241443306931250084204333857626839619701/230495136924894945002922815740524871388944803407094203586965009008232765106889647136402870366195688394581594213823274324770608716170470116012,-184830389938517426902363793519080729018966739967858862022455565352878669449264308856394705649048871264937494198164106719310044020463552375712/403366489618566153755114927545918524930653405962414856277188765764407338937056882488705023140842454690517789874190730068348565253298322703021,32662411620567219915832822635711885086377093112665214019843295621956885521364646721287997975143375698583298054722972240588523194082589175773/57623784231223736250730703935131217847236200851773550896741252252058191276722411784100717591548922098645398553455818581192652179042617529003,420606090679120521605555782873475655320225864042822273199584348562919929526324083945805707748359937657792041625997730917812149668867200575382/403366489618566153755114927545918524930653405962414856277188765764407338937056882488705023140842454690517789874190730068348565253298322703021,-1},{177998441714009666326596579188876725881489511677097365704605904711978468436963551430333421531500960826667062927640617864722776700975431683529/670965865236181892489620208546558821124710460549964431008848057633273834459775997813479984340067640059282454619951311291914644686363116127578,-52940038676784313491754521569913000758962388303914980462329063783520296524450371106923795710657394115010010255789401211000733922451650851733/111827644206030315414936701424426470187451743424994071834808009605545639076629332968913330723344606676547075769991885215319107447727186021263,507430481197891359321139187881329404568906895095627129560942470627006252688353129020608136568585509925687854484784516953255862372628567689767/670965865236181892489620208546558821124710460549964431008848057633273834459775997813479984340067640059282454619951311291914644686363116127578,3621750947400482420852686525395299718975387239578312255574096129767571515577140935066945317746502487152016226537653874559454680051529625099741/2683863460944727569958480834186235284498841842199857724035392230533095337839103991253919937360270560237129818479805245167658578745452464510312,1},{-30635402810260112940559219815844882924214615703575906766850742114366767398001185895345050281319087875688028106903890593615075980638402923023452/61563853076272047500427806388621997168303818560567504685406783611018700797873120244144623638284490460280618013927624041465673808515146944458405,-52794595759060699853086426354448517675788253416536803361168383799725528647263973491213847308634051882111368208243210283236222822569227735652422/61563853076272047500427806388621997168303818560567504685406783611018700797873120244144623638284490460280618013927624041465673808515146944458405,-13454922017813823771865919364253467247727953268104347324004558433572994539521274867726493781443121961296867354191275087883894211491879230551416/184691559228816142501283419165865991504911455681702514056220350833056102393619360732433870914853471380841854041782872124397021425545440833375215,-108596618968028083144521716110869348898359127457876288217292243025980143191910435511919130515984128782162495718805709366162426061436689040880712/184691559228816142501283419165865991504911455681702514056220350833056102393619360732433870914853471380841854041782872124397021425545440833375215,1},{190543254304531373639860750765239032508490244817986359145071372079895136547417863891358278275441688017209098618975842631065715497067600390528/154456418531805023779718771345486888915593507573123882444755321397408320186784800557188919968185266316853177183540287017851036939532145429657,-87895433469963268234129924985414434386853285691913145958704582928849304847905011237855619625663605882214387176816384415524031340228485769251/617825674127220095118875085381947555662374030292495529779021285589633280747139202228755679872741065267412708734161148071404147758128581718628,-56400684827675954347469035003237096364553308784946925415067181542091905309306308133184697264323511300485939151331240616322995627883760567817/154456418531805023779718771345486888915593507573123882444755321397408320186784800557188919968185266316853177183540287017851036939532145429657,826427346634531578677771698955140687411984403696268063170758940539980197183382551131693180914950020550609702285817214135308722506393622946565/1235651348254440190237750170763895111324748060584991059558042571179266561494278404457511359745482130534825417468322296142808295516257163437256,1},{-6766393440184862130814123276561444037244298560653236595224505133603250795462422201872832868901297806853433592699960817352245066829959946768384/20292888805473285496559038873747664276871844776602021335668820819845596793267506773080926106514500586449290806573861962161080052896920403675543,-9084151561270757869168110618718240300539920123426108491865123858846229806755760154488084252337113515021432051407889641124966617422466422954560/20292888805473285496559038873747664276871844776602021335668820819845596793267506773080926106514500586449290806573861962161080052896920403675543,832436444702272682081632127305803569249238108428123325104837361380297317944606056643923372511153200801055995048088967214879447985432389835398/20292888805473285496559038873747664276871844776602021335668820819845596793267506773080926106514500586449290806573861962161080052896920403675543,15988288790444803985962765441324362216706864125463229363606333898590852896131030842624595725658466141842929385215764841421534457370650673529540/20292888805473285496559038873747664276871844776602021335668820819845596793267506773080926106514500586449290806573861962161080052896920403675543,-1},{18304594556468900655881500476054775241956422112468133751010858414990749505107286719451334395539818964977256804214834591926322581961451132932639/9878761480803333891007133101301176381520993163507248639655799066857110007947496671714656631913828397625795130662823700450711960489525382476168,208044025707844009775237685835549504749924799089566678153026007534888355768219241664970215595907291749529419594089958912703166874870941452656/1234845185100416736375891637662647047690124145438406079956974883357138750993437083964332078989228549703224391332852962556338995061190672809521,7339171331898696977888448569268144462396636134356502602939885888648678807375459972489253439721625984827267067144239842148236218897156516138743/4939380740401666945503566550650588190760496581753624319827899533428555003973748335857328315956914198812897565331411850225355980244762691238084,-1082528049497912559550464465661808596868800643512220757252995431700044447634590524793659280446002289499567782486011043199707775365859873957015/1234845185100416736375891637662647047690124145438406079956974883357138750993437083964332078989228549703224391332852962556338995061190672809521,-1},{16700481110609690465398058099767426982741955252119019131642657089680320018074958532162162313133580866481142010118038854971213995538353502065076/5775425668879074571738714456952093843249507192338641123896181990065192607803809027966594856228591292088199928167347631989155114067205343045125,-1304675200003996818165618748132614001591414930325734705954677183340111717358385986853941191233512783831300923613243918255831205678244274502656/1155085133775814914347742891390418768649901438467728224779236398013038521560761805593318971245718258417639985633469526397831022813441068609025,5912683116107929551337947774477126095661735789602461338831946411556815435550069789724482511278908931731153491770254447922539886850111290056309/5775425668879074571738714456952093843249507192338641123896181990065192607803809027966594856228591292088199928167347631989155114067205343045125,-14048399686538815812793525879742647046752741187385087468931528007242888236842533699925328462876118847871727624735859646390621262989753822288264/5775425668879074571738714456952093843249507192338641123896181990065192607803809027966594856228591292088199928167347631989155114067205343045125,-1},{-295750694071393884273004512299766996692653738730708976121998212880075367141312743033867338340627961892223177332841531983546544780863167295974/442491177408144672589429653085434340874693644149347969223936842285463563818011072956215809065414037902333269185246782016682237668775465426233,185806324173470963455674304514520397442471234635493100854193654290875657074494650661128319903694205681336805274257025383733779439729131824546/442491177408144672589429653085434340874693644149347969223936842285463563818011072956215809065414037902333269185246782016682237668775465426233,23801289566326516935895608750989943083037986027845586012028996055690599824618428434902518243312437836086913879445343823114435913730258492073/147497059136048224196476551028478113624897881383115989741312280761821187939337024318738603021804679300777756395082260672227412556258488475411,287500988661778703789993542742962009885643575143088697187113229706902361685860464965396271591573395161282662327302053702592332769353399231234/442491177408144672589429653085434340874693644149347969223936842285463563818011072956215809065414037902333269185246782016682237668775465426233,-1},{887494625312507896950859780629697215715685147217133987557584575480163031855024024201323479004900104100703922907750303618626060033618036199/6291872318147132405045178433746405578338589381556151892681352819589061821361856742845321892832489402254488792208142678465460752699772251322,-298922940829572769210142388374819082277821066947649518298945817026116037772934658124991959710668412326134026779008484052338527774239642596/1048645386357855400840863072291067596389764896926025315446892136598176970226976123807553648805414900375748132034690446410910125449962041887,2547995864187866149356675709050218378269602621272286139782756312569795269390402811040149371423528323871082425282323742196146848953424750671/3145936159073566202522589216873202789169294690778075946340676409794530910680928371422660946416244701127244396104071339232730376349886125661,5145040460149259108552409055146328401863451618537388438982941204411843884457749992301790735567801647418612125536400846239570519404891754647/3595355610369789945740101962140803187622051075174943938675058754050892469349632424483041081618565372716850738404652959123120430114155572184,1},{-1781817926215102194721787442532916437122180246872573916301842995547626308405784009460277259358013807812789629699170675403920089511218044689462430/2142538907094139448961835245080591494308169817332330161374981036786350566169318642087105757617907210618886208595997000045522408781646645862960579,-1761982800161548466703478833892583840009652584155113646142702577329932453492494445918299082859349528165350589584065536638814317873145127842192448/2142538907094139448961835245080591494308169817332330161374981036786350566169318642087105757617907210618886208595997000045522408781646645862960579,237058381626325533504070275702147094862431496751848978963722206442581904929174541589458799696671492770871626339712735488554768256072895114638122/714179635698046482987278415026863831436056605777443387124993678928783522056439547362368585872635736872962069531999000015174136260548881954320193,2213859308647198427370545209512844488149377459495216233095416459288606272769873983198459565715007869205529716902230470517121458939123792133767268/2142538907094139448961835245080591494308169817332330161374981036786350566169318642087105757617907210618886208595997000045522408781646645862960579,1},{-150210298062783744746389779400662485629337570377972014819405458160891489347284451579858101691473353822227257083969790031777330883920638802920503/35110787169859259043651840628992961950761812784374776163954235369525840661988508829538220055327622396261355834880655987879726025921901802908436,47601163669540454770429223271405420356238980318080534581044333773966234860201106759694545380800795442882299374652561161175573311371657503060809/17555393584929629521825920314496480975380906392187388081977117684762920330994254414769110027663811198130677917440327993939863012960950901454218,392815881571851293218228989986774471764305642736644206028449690387617294531618633551760988630489551997610766078556770273365618541882723656519/302679199740166026238377936456835878885877696417023932447881339392464143637831972668432931511445020657425481335178068861032120913119843128521,-14783692270380868630473407815940312864764596412976680446543158767631410004960674093216316909067116031588192342154503688380863376706871343563937/8777696792464814760912960157248240487690453196093694040988558842381460165497127207384555013831905599065338958720163996969931506480475450727109,1},{691571938889610394989280861307196410677551635996726140078165044465999545577802849348937757323778109204056308460198506768129257300992453967424/1481096461331177381419620198273611565169529731629246214112529098677868344067247205049736127946908609115864990357267062522628994028995508424595,-91495308364235399550910807815730085475864521069187238338213954552101082923429664890812487155530933612923246372752055330591257271671245964376/296219292266235476283924039654722313033905946325849242822505819735573668813449441009947225589381721823172998071453412504525798805799101684919,-209632425560578332981183869549395144396440909339474559690255878891243442916581637108755077915859506158949252706185116266003863847299698611474/211585208761596768774231456896230223595647104518463744873218442668266906295321029292819446849558372730837855765323866074661284861285072632085,-14161233467337305113376420667399624117120185558136997589187237954576951854136669866152734905824193802965769795997065797362018652880761200499/42317041752319353754846291379246044719129420903692748974643688533653381259064205858563889369911674546167571153064773214932256972257014526417,-1},{1596523259400900279513546295055653952536580929297763863233639017596261972723865172154684307334860678940034306379042072637345529288170738023499/203191162201859130905771880041374548768605493303511344558325665124829728036311891834714464972125221294549863196697878528605476771036299635146,-39658271593099925050950105210751361615652114323153703658004626802610479858067959561144782060544924525561010190264420706510017920771789492339568/1117551392110225219981745340227560018227330213169312395070791158186563504199715405090929557346688717120024247581838331907330122240699647993303,35242137947250548686272056979783496563687847719417873077641739743603249266410880377471262040240873267795432861878300293718503809690458319211953/1117551392110225219981745340227560018227330213169312395070791158186563504199715405090929557346688717120024247581838331907330122240699647993303,4781445329879976341499696293965071344060263204353064904433863052099691992331687950724481425976191534334227394010085910955577155363806657382489/1117551392110225219981745340227560018227330213169312395070791158186563504199715405090929557346688717120024247581838331907330122240699647993303,1},{58480375858089060273353513187057644540566102636958713419347013485151318351731879212050642419339726397966730595629810251668791791230495939665/655419615142286065483640539554893811181914004079918457373407645721620675049528910664725385522250851380973879869315088521627640065331995204964,-78274811331621283696231092416285555463644054630786867152127020011461282857894290182546860135514540082460451958584190016863990468806666029288/163854903785571516370910134888723452795478501019979614343351911430405168762382227666181346380562712845243469967328772130406910016332998801241,10020415104549808276041880910107889454094078666889034456091753049388830345065881241070152893049634464605711331600486719686046574174936941794/18206100420619057374545570543191494755053166779997734927039101270045018751375803074020149597840301427249274440814308014489656668481444311249,706158953113169071535090861276223296359726895855148263620507675709954408846020382230139673153550431169502303553692558589116610215384994591935/655419615142286065483640539554893811181914004079918457373407645721620675049528910664725385522250851380973879869315088521627640065331995204964,-1},{1267199718596307935215117445433001733958256208158658008632797311259409719105570050893878094472104095639644463058663289361169896632249039807711/1278552253102366824656068107812963654268426727910108958128343481309122907693919317822700034846119850601886452781194320922548663147382450435764,583921857749525055695144766164797507270505528717862942032323562032356236499869942344722929405065389033464681969916656402081025996609089473808/319638063275591706164017026953240913567106681977527239532085870327280726923479829455675008711529962650471613195298580230637165786845612608941,892983371327109277787452765087738996187819719133767038756425002973102011420287914442441251709444995575677004870536860063316629973006573454925/1278552253102366824656068107812963654268426727910108958128343481309122907693919317822700034846119850601886452781194320922548663147382450435764,152871554441870829178208598259494705717174325561855754983688071935037467030679126419243073576672899124618033722819283629396447501216833082463/639276126551183412328034053906481827134213363955054479064171740654561453846959658911350017423059925300943226390597160461274331573691225217882,-1},{-33876233077509723164797889655812533394309040613390747696188557571127883297749792178822955202551231459299164942587526269530912902855082835820214/38317232920867305139913992739847598624294742083310956486028540552828086709076105926066774519028980710782593781923484681837431434882795620504067,-13191073319077984754054622120688397889370793786235955297859743267368728599743809923724540656270128834621764638661018142430422707878164257182912/38317232920867305139913992739847598624294742083310956486028540552828086709076105926066774519028980710782593781923484681837431434882795620504067,23198737501439133421714157610675981046282412290813211012189710120536563695420011463552450535093495869843795201665285963962891532348076905600154/38317232920867305139913992739847598624294742083310956486028540552828086709076105926066774519028980710782593781923484681837431434882795620504067,9204121915060685687779862999924109476482754932077134106070294489914905674643344144262151222539267232970513012992768427237492655266039056468188/38317232920867305139913992739847598624294742083310956486028540552828086709076105926066774519028980710782593781923484681837431434882795620504067,-1},{-103105581337288541924407028294281593862537809994106043392101325867326511513800841002691176003994692664421599063251340394619541488863051894676/552682489527298563772781846255991044040424291489962354412321815987020572109753129184052738358398451631400379450319922322054018894252549616339,8891784461089074070115878878799926850836132607279856969869547159347192469020359248776146095211819487307853421089782215058935303997528986435676/6079507384800284201500600308815901484444667206389585898535539975857226293207284421024580121942382967945404173953519145542594207836778045779729,67485295314447101559536763819328692286855328445982062918465916261673218211497308408090581059292318496814250718271585131322323840046798156306/357618081458840247147094135812700087320274541552328582266796469168072134894546142413210595408375468702670833761971714443682012225692826222337,-2339408837213287554034937399688623498176133282078674832910402405311282698748825648081808992689581046503108284451868757245163679882428015344192/2026502461600094733833533436271967161481555735463195299511846658619075431069094807008193373980794322648468057984506381847531402612259348593243,1},{1706476031036551752179691097508117808547127744091796934863604902180060491051064110360830760273995437075464883924396784794510239661042754504/4558926217620325987294275966063169946504089810907203522391054949755363583630981972238489594016023977919436124134248410301770808459596195263,-379917962731596250576990389861306176774771930739759542020275823103181241867662181042219507856795930385311914500240934525490519169902261112/4558926217620325987294275966063169946504089810907203522391054949755363583630981972238489594016023977919436124134248410301770808459596195263,-1413945004628719057850211051487081623447289057034995912296540467164575146770512840213790499725268764439687382148226499950117560843553646643/4558926217620325987294275966063169946504089810907203522391054949755363583630981972238489594016023977919436124134248410301770808459596195263,1538326973431995988663991063040433949544146901419280666190585932539094131414499268673795270124270087613505875121324765909874526884568823324/4558926217620325987294275966063169946504089810907203522391054949755363583630981972238489594016023977919436124134248410301770808459596195263,1},{-216250443912900035065347978815105604939007111813462613518432169355913901336159426813473259951483218558667689726202361449787368563416803855098/2726336229679017741360605085498822884471941566783269868394638329850754229505505718698299606991771634743612971214185596761178747488624595496201,-450340969662918590630969398849320298923825529250374684905911350651278010064672933692630702001867772921458643486552397974594782561534215219968/908778743226339247120201695166274294823980522261089956131546109950251409835168572899433202330590544914537657071395198920392915829541531832067,113684690988809117123677677818958963862168384600610372191072281994936456092724212589168747604591704578694837313266105343169325192725598687268/209718171513770595489277314269140221882457043598713066799587563834673402269654286053715354383982433441816382401091199750859903652971122730477,3108618467768434051493786045571796289834883691407725619908634455724983153170684435184591215530154787003248607348298390464481032065376316651680/2726336229679017741360605085498822884471941566783269868394638329850754229505505718698299606991771634743612971214185596761178747488624595496201,1},{113523160780416903708992186058519424788129264281526693654173739960654929702234277103404399363085230696374863003493114805478930549745652448900/68867194434289849827358681521626293054371223981536294205020243216192063296899400774010947128326199826208804333499794271615540459064326879383,79416026090210578936796351185601434548003581958455533836228492153588952750008474416071446483455470084372733954338598172777597813039952809620/68867194434289849827358681521626293054371223981536294205020243216192063296899400774010947128326199826208804333499794271615540459064326879383,-2542768722271903290308705419190547876709973154448248804366574982394790255358525309659425009899401284224706665394721181526333489417149951980/22955731478096616609119560507208764351457074660512098068340081072064021098966466924670315709442066608736268111166598090538513486354775626461,-9979560090176916325697383596178543272504445229711583519431983245930217333134594471950805151069843932915788355967698322633748959465383826160/7651910492698872203039853502402921450485691553504032689446693690688007032988822308223438569814022202912089370388866030179504495451591875487,-1},{-391833513638921241084274522074013799172552850785745438008529398112505573006057374425451925086214600816771535914842625576159346887121890394396/1332225336223761143757730055756084097213409171871013076105854790530363096535107690114063991676593709206420480158988630458431688013449497655889,-1191984104773505435403099060587213639275741890037814112599956199063944383328633812894837692057640412438361676740171368743333046176774590012022/1332225336223761143757730055756084097213409171871013076105854790530363096535107690114063991676593709206420480158988630458431688013449497655889,-417554873313968608615751241825461353338628104454142645369248508033460944823877012846094572135444878029162347168859330792439211083445313958040/1332225336223761143757730055756084097213409171871013076105854790530363096535107690114063991676593709206420480158988630458431688013449497655889,-70209235161812410537868178324946785494657415253803038979368864468468713183156361975580175839797423360844716325602279405545321459777162887654/1332225336223761143757730055756084097213409171871013076105854790530363096535107690114063991676593709206420480158988630458431688013449497655889,1},{-133297237024388649751045758493874814315937583590634709535291296686866855469449686413424758484386026848441512885316556325894657225588436065612/90433557648212819045293959149561415642201806948551363897451945923094578414880588587966712387401437028057055986521587802417938899639161305667,-3025504184933190943458354934072028960008742480602454469525104397627082368001827744172567593091563625038675513655700215968286003940182596797/2740410837824630880160423004532164110369751725713677693862180179487714497420623896605051890527316273577486545046108721285392087867853372899,-18686400190168850359967654569439137975472278827854755909171385822267636677397227289388988871705622347400607837596787928873691081662264660164/30144519216070939681764653049853805214067268982850454632483981974364859471626862862655570795800479009352351995507195934139312966546387101889,-384067700342406721032921614246830048828742232324185630865586000230931726394694751845455914445246995661620042192950868128239512658898201659827/361734230592851276181175836598245662568807227794205455589807783692378313659522354351866849549605748112228223946086351209671755598556645222668,1},{211102960534315402812557906652790336172326030281842921561367242449340874696158257276983798060553370111694620994730111676013027009031498352658556/90738892993275405290033776774068687699894869892932870841285991254739925598500569550684859907871759633876621897176418640010151671506250116502137,-7377248233932822374169513775826321824736043525463454030561422626226621576746135327516048434175710681322088216546999442050159547188230547788227696/695664846281778107223592288601193272365860669179152009783192599619672762921837699888583925960350157193054101211685876240077829481547917559849717,11890137473374470512172026369916433493253009672689757294440021789028095346095930295898198459097530853537391924148614259413492402300822053102853794/2086994538845334321670776865803579817097582007537456029349577798859018288765513099665751777881050471579162303635057628720233488444643752679549151,8528864028110205713500084150757468893891375459687847419941708856611600679247314190624885132257270714738865692169920424003232353377679311413441992/2086994538845334321670776865803579817097582007537456029349577798859018288765513099665751777881050471579162303635057628720233488444643752679549151,1},{388691153365718829320778212948610161418170047455717918600641487066939088004186228864676453075204533878435080295526632452025693319141625032695332/931576944148322554192687501586513877498007485664062245128755230168866102221173418468862609366933020633496355776222113376347809918804185386087505,-2923495588340173640085705243846028367597316173227273880050185872446751815779950646803555248990516197169048232669956073103148377836151518612541184/2794730832444967662578062504759541632494022456992186735386265690506598306663520255406587828100799061900489067328666340129043429756412556158262515,-458848892166630007420937059585055901520495932141078456458267305771161383954890752101808188504246566947291278263532431059227011032962476456501984/2794730832444967662578062504759541632494022456992186735386265690506598306663520255406587828100799061900489067328666340129043429756412556158262515,-787318339929372191327453532429372394954767830691325035747710079013124103182502405526656746658578752113535688094398640974163363371160603703386296/931576944148322554192687501586513877498007485664062245128755230168866102221173418468862609366933020633496355776222113376347809918804185386087505,1},{-32255981726642136530368538886701693123771344984896268048633985251414069021018357349743992512414653905367354905609263309654386645770057352652/4041076101745033858408147409619396380589039424535382699683317686046006420466386965046000158854025540155115616366404004481151615325947893979,-380332767603510692164610608178706241656687296983533956517697383685897344675583568581961906003216962736492105274489988959413142942740915307016/109109054747115914177019980059723702275904064462455332891449577523242173352592448056242004289058689584188121641892908120991093613800593137433,-157505884995156456600209584273704640306510797188038422704228392627846937218713875677679280261297314473146140157627934511193475737748175040866/109109054747115914177019980059723702275904064462455332891449577523242173352592448056242004289058689584188121641892908120991093613800593137433,62969621170090537124668440179842688193138566017139910493039613039141228141000533183503822359276659883427193950375171380013485156903413379723/72739369831410609451346653373149134850602709641636888594299718348828115568394965370828002859372459722792081094595272080660729075867062091622,1},{-1055613123123695417129686862588210807280616684454158043326975807581633031413933890067667019669785907123583520221596297612123200229585401907117/12078335017855424505515256829589548589158831733292341038008404065665543667478855920065301462777152933607663828984187990297295786788524433217999,-28568837954852410886464327388584461656486478500041253699126853923469975427962105810799920794116066975633934434114355256539407872758439906424769/48313340071421698022061027318358194356635326933169364152033616262662174669915423680261205851108611734430655315936751961189183147154097732871996,-556562819079135342887305281561547971613612187473451087468808432442416067773569271523296362606553936326815198115527529502921266043949276808088/4026111672618474835171752276529849529719610577764113679336134688555181222492951973355100487592384311202554609661395996765765262262841477739333,-962241650109076520383389786146866853941424503177528882899737716209286664682929013456647577016408353418281025936574659922782109022750611933362/12078335017855424505515256829589548589158831733292341038008404065665543667478855920065301462777152933607663828984187990297295786788524433217999,1},{-95894090885917293263628825609065478895828892525329251853093276201459943959457800017489767410265501842397083186268605748132930187294729364276/210798554596176979952869799246138080092325612855977561908488160190535996662711590749323370745365501576628967498656129807690732945229565481685,-261125770914843690625191173204372633955802728985348982158923172377600161891005716481765745554180721098755215684839188123947711910605066351366/210798554596176979952869799246138080092325612855977561908488160190535996662711590749323370745365501576628967498656129807690732945229565481685,-92585101481526255902935602603418689054857426739406116225898166566017880874211794736812800423826055851784714955340984016425817017975302694136/70266184865392326650956599748712693364108537618659187302829386730178665554237196916441123581788500525542989166218709935896910981743188493895,91185487093816166704862196144265311559493863670572559648515584778850858983219041111727238238325010357523178041166449003000369121506273741074/210798554596176979952869799246138080092325612855977561908488160190535996662711590749323370745365501576628967498656129807690732945229565481685,-1},{-17704777152958911533860043793727752029136389656971928314434654088707804193562960735937404666452839044292831589382593758212684740720531531221408/42567816426240100072609550265103206487670870372585401847332815821066533106052280267962680615967116386447630219932372053917161745018224265170291,-8737870073462235494174551438867608453093749902858059863419154969281114315588462793079302821606054964189717480640820321527393292401700001477456/42567816426240100072609550265103206487670870372585401847332815821066533106052280267962680615967116386447630219932372053917161745018224265170291,22702219877957877366776538102535111395229521376633195351398590667398723992482734347831701605275606776330561318354819422198491476302978002892023/170271265704960400290438201060412825950683481490341607389331263284266132424209121071850722463868465545790520879729488215668646980072897060681164,60691836456826539832480972311459027755357826412467897334735942046323409571366404116132522264556649831259874718370838420282306500309128817427839/85135632852480200145219100530206412975341740745170803694665631642133066212104560535925361231934232772895260439864744107834323490036448530340582,-1},{-55621907840631011782228262932707117296574683389561601145374184353821310249192070401984100025818247880286325880651470532835966112435468214422021/128427867468208588830524281643534296489420807083487669326319784757771185513290694873465628414982673469989220844613306452485731549237370947912380,-12287159720791183449256338458334766302529159364924650510239229621772962395439860038435408616461284952742729724916097449683442571494116336067408/32106966867052147207631070410883574122355201770871917331579946189442796378322673718366407103745668367497305211153326613121432887309342736978095,3137689178941000239757354629492413588431176243329080464450332260909340759804984926571977271982855082807001822476462654167600875476122157048888/6421393373410429441526214082176714824471040354174383466315989237888559275664534743673281420749133673499461042230665322624286577461868547395619,64454961138523765587925323489518305043979575264065888812754288935284258406634292856873829849724251914586850518370792144115725526309932100969507/64213933734104294415262140821767148244710403541743834663159892378885592756645347436732814207491336734994610422306653226242865774618685473956190,1},{4234907939976858267164364737662844486843021264301493258955111470464378387915597916573659956211106275123310303759580692924292703314892400782769/4989614712311459629553273319502241051598443656297039067485921323549796467103560855282637457253488946003478095529358867505136448461116169489296,-175220666764171768199112941984409770873346954169267699661952644988729017364407403047134305544171414320593699380421499489610750527894080451008/311850919519466226847079582468890065724902728518564941717870082721862279193972553455164841078343059125217380970584929219071028028819760593081,43159704658675742820828588363598059418640874965575851193368400763375647127358082605900176813011172459983793708182587909420623241170656133381/1247403678077864907388318329875560262899610914074259766871480330887449116775890213820659364313372236500869523882339716876284112115279042372324,2778439324675246548756799846030088923722530501564281808508433571215116565025016500185967713487956960178289500591068178492170747159410792994415/1247403678077864907388318329875560262899610914074259766871480330887449116775890213820659364313372236500869523882339716876284112115279042372324,-1},{-52859336211494686830971446920125157398754149554816566376892711995469415985733950541017521130074162614495466612016497440600611791940360244421849/54394873419504901099664914993158481068281884635317365080460334324995722887665305558669223155564282687205785262883507689671801950808747142273558,3939202240005785510321166585618375679049498984818184411266468882863555776414817270975035600478078982399033785335354304152690220666118482740168/27197436709752450549832457496579240534140942317658682540230167162497861443832652779334611577782141343602892631441753844835900975404373571136779,109027749587779026307029883726893658289606619081335545786823472035154741054594984968688644909754142098479263877184647913299939811681721742126513/163184620258514703298994744979475443204845653905952095241381002974987168662995916676007669466692848061617355788650523069015405852426241426820674,9344709356458988984149577473134316980293473972676453300416619756458828709718006280368741054989286529054116986683244072218956591039239903718669/27197436709752450549832457496579240534140942317658682540230167162497861443832652779334611577782141343602892631441753844835900975404373571136779,-1},{335887043615910985377780469573984162017193941445639414540090365696258853512437272786602588540373430344640378185175934194447439476235837292968115/92537271998878710811137448200343153086449034646856187928552301898077174808823931722026792996428527688566651397225262741947170610952941197246496,-2947509540133138767197711830820450593028417386552253770728277242172028776555369030236208393480319664497700152574341086904223528373821354407244/2891789749964959712848045256260723533951532332714255872767259434314911712775747866313337281138391490267707856163289460685849081592279412413953,51718293732386052897790267484127780280248002962114520766927063993072496642341857621840403036782198492725841322599810592452397480134477622717911/23134317999719677702784362050085788271612258661714046982138075474519293702205982930506698249107131922141662849306315685486792652738235299311624,125527558880192900524117256540633857439986530599912758940667375724195466545098897762499779985126024061106685296802044585007028241102153391259115/46268635999439355405568724100171576543224517323428093964276150949038587404411965861013396498214263844283325698612631370973585305476470598623248,1},{243159631951316801693292689379810081299168294746619069552580665241246719530745858676858610536274585463134104925029457812051490529162305385940/553053581016550458837202463025313818154736723003462595226881755975312611740996731675421466147880407145592866685754338465756468315561249185053,-306079750342580879870298438503049552918698909163973244252637895694319833798537363657269398869049540790225484128891780745466450268974381940354/553053581016550458837202463025313818154736723003462595226881755975312611740996731675421466147880407145592866685754338465756468315561249185053,-4424752986666008736814322777300678777867536606233518591872214946328181415093501390106786505137706929900069027153504962437808526237074227628/553053581016550458837202463025313818154736723003462595226881755975312611740996731675421466147880407145592866685754338465756468315561249185053,-1680659195855808365349215537972584525704664128011514716507308691338349451525764108892612695995029161050399868804475334687238203815579517142913/1106107162033100917674404926050627636309473446006925190453763511950625223481993463350842932295760814291185733371508676931512936631122498370106,-1},{-13445303176235439926084975045456311078610802059118296547155969227827054741504265634692972371525679819272143100612882448491148511004882820130272/44613884597988329745718896400165852391776847956386116620962535607205665182900340585908652990493416583820337475364353722108244399701547447488019,-18934478898959276975321982353036656906575777688584126468038038729184648597980387006960605805067033162069190998693453290780936689445198576420304/44613884597988329745718896400165852391776847956386116620962535607205665182900340585908652990493416583820337475364353722108244399701547447488019,662147344953507520464767767609806558405562729764897106412424060996040287898216586966942210582209217138960898375659389357232730969013817072138/14871294865996109915239632133388617463925615985462038873654178535735221727633446861969550996831138861273445825121451240702748133233849149162673,34976375769152791894478852276344026759326210993447422311534211430633379410160382657749717768608864435324494506619732984058581696029253994153284/44613884597988329745718896400165852391776847956386116620962535607205665182900340585908652990493416583820337475364353722108244399701547447488019,-1},{11448731627858411494752283131026959227703700555532142569699459008563920801473549447237257957581091054404873904081966353236188364481905818304/160748602596078189196597445194038876041989288745399713157894100334030497576034492732012482747013414768750682481127364770767762796742942927665,270726977729351419511503668101629154650928692180281809845664526602521437583243006920203775823979496699005540507970104970156818003500830248173/160748602596078189196597445194038876041989288745399713157894100334030497576034492732012482747013414768750682481127364770767762796742942927665,767625738335527259784732287055727512482195181692666543302237590304911852936112527676619314189382056431746737871295159514474490658697408418741/321497205192156378393194890388077752083978577490799426315788200668060995152068985464024965494026829537501364962254729541535525593485885855330,-278610165082615625402475382660264532722966440460115338034863889315741989708108265486756073051296638729888080223657633677152835009753345606642/160748602596078189196597445194038876041989288745399713157894100334030497576034492732012482747013414768750682481127364770767762796742942927665,-1},{-40590793594302910511057934852789850175674908601154776685335927999912068010262906413119268392574486054137982937969072266318422137026605323107/8204346890283448907021136250286293941620800637165364890902012688312188474376374938894796509706402058084516137177373034928252181400676733477,70219066835352295990924980711759577069734053695035234163645114349099636948027570296127005235073388096073426887448126649454305898832564144023/32817387561133795628084545001145175766483202548661459563608050753248753897505499755579186038825608232338064548709492139713008725602706933908,2668487990296885634719502718319577136074245967851471947400595928591127256126403250595838916331636277157630621369336850516526390043092333020/8204346890283448907021136250286293941620800637165364890902012688312188474376374938894796509706402058084516137177373034928252181400676733477,-5727919451548932758990883535132708066071418375031054935297992411681928387647384250649198410565696624617081589728529505778937445274074252318/8204346890283448907021136250286293941620800637165364890902012688312188474376374938894796509706402058084516137177373034928252181400676733477,1},{-247986432737665870600505291260986066605914402174485561085117939847567489293832140813467196233339350568975918337587066182758079660330638195139/101822180610488351202390680253740732137085464848822346719975627480413332046300359897312476013843217338012522561268123358492517465388714768984,-381311726856715711255246557529318941276319023652475748633059521796733071954387962970895585648512287436028510169451351568629361139791231690529/585477538510308019413746411459009209788241422880728493639859858012376659266227069409546737079598499693572004727291709311331975425985109921658,-3851977870785564913514876749488443914835325904728515905041394041969313294450923260941985492813977283793238442250979657849868412436617035916719/2341910154041232077654985645836036839152965691522913974559439432049506637064908277638186948318393998774288018909166837245327901703940439686632,14665934845875079078662135452989985866505598697339887353434454853747511301498821896385967929059804778104066837135945496057800900842509241743/45036733731562155339518954727616093060633955606209884126143066000952050712786697646888210544584499976428615748253208408563998109691162301666,1},{3215078369693142403836601762322679894499900320094908347714555062862805956613813617700922529043486039356868849742013270761527089338033600267699141/2780897174381611129973782019457295400000934465031928257296275400794748973314449112371128207977036951393458944766202513128740980379803377253423472,-161975676212124401504343915826174962419735235389271381736123173967601081918658235399086761291096967547045108905804243912552912706726808411282720/173806073398850695623361376216080962500058404064495516081017212549671810832153069523195512998564809462091184047887657070546311273737711078338967,988178914299919367446499120187916961301139124745487417902706569918040428940002291342011263738463337577139467016127899935758588459166971527171497/695224293595402782493445504864323850000233616257982064324068850198687243328612278092782051994259237848364736191550628282185245094950844313355868,2765517554740799220938328573805890819480058280786412904646213906163279000653299186192843072603535608281833187900181728134422428211102414254401165/1390448587190805564986891009728647700000467232515964128648137700397374486657224556185564103988518475696729472383101256564370490189901688626711736,1},{129112691897903040468734523478467958705384579619483674911331451040642979654042161225970030154621426838126949417797422866299247097598219968709/2512958166606618408903294364848941006050386684852310895766954258169622445264249987687481184315317328921176694811356865751086983874924945446206,-798903744184836012950060779824468110069470952906139869750109874965120446884433672392267635287937376416232104222451929439918501743155570724592/1256479083303309204451647182424470503025193342426155447883477129084811222632124993843740592157658664460588347405678432875543491937462472723103,269921704171809514542496894185154198178431621846111793099671211333344892178947207658619136921559856913396688008101077885972805853327735661368/1256479083303309204451647182424470503025193342426155447883477129084811222632124993843740592157658664460588347405678432875543491937462472723103,978575327389566543394409384860825032643339011700967965962624968126318540775166411509233164555591876999678772996522367626762230978089539484146/1256479083303309204451647182424470503025193342426155447883477129084811222632124993843740592157658664460588347405678432875543491937462472723103,-1},{-13134791319947322426631668778180038990968962144823380143300131723598915675800379866695739530275292763050584798969546845234411446312650975044004/14370089730350923531181018217906353546069508788487867459453876050792299962716972390290025610376042280867662181374578828216598344892174792230841,-11339299836126024230136029528368108666561426679201200321110442889993374935111314003480361066458591901049175284141162021974485738793902660490896/14370089730350923531181018217906353546069508788487867459453876050792299962716972390290025610376042280867662181374578828216598344892174792230841,10972895388969891835444426948230058931248593818229932013864456044939406538623189948247762829505738451403706742314085106132060293084882060938964/14370089730350923531181018217906353546069508788487867459453876050792299962716972390290025610376042280867662181374578828216598344892174792230841,574847371707992317357227862198063972421026621737228046783455731121757518818913131639948330789056250190219781313695539635165852463307074151604/14370089730350923531181018217906353546069508788487867459453876050792299962716972390290025610376042280867662181374578828216598344892174792230841,-1},{825458205512186508855608217971739539935820058876181585136332816140261557957681970122314846036958258016383956888468439606621942796702105099356/911846866227452253369265227430252866972891363705456782362331419586827740010426590705132708778115345727321200364366961624645517439009153799711,-3957458071340721167195351541399474664245308027357166270737868865319548141618653268771879789630015574916378824575578020523109554027133384478204/8206621796047070280323387046872275802756022273349111041260982776281449660093839316346194379003038111545890803279302654621809656951082384197399,-4106113495584127924835511256941654834592026396233707411371772382700958580871221419838880712111693003688822062336282018636529610569968673586814/8206621796047070280323387046872275802756022273349111041260982776281449660093839316346194379003038111545890803279302654621809656951082384197399,-4424306502995068291782052379981849889393275878747045023478344298621890500647966251112806772396479932680351654725932178418804289909110698159400/8206621796047070280323387046872275802756022273349111041260982776281449660093839316346194379003038111545890803279302654621809656951082384197399,1},{-214771469011801598641955390893219917221461924537336825252721957573619753494346455711000786730253986356883114987741314026968741187689642414/1548675306829101526591227536514668726067340134066011849828993659907374699169686373971030587729526458472897246804895035764674180911471080527,1289242423658071772243651601010114029574185261650370803597399423790586601692921232784804658172166340143324119725715452992224623143817619092/1548675306829101526591227536514668726067340134066011849828993659907374699169686373971030587729526458472897246804895035764674180911471080527,-2753437232596193080938722090888401906244274850950579506266211304627749132991616464349144300537568730334256759673417196625904129257555964819/3097350613658203053182455073029337452134680268132023699657987319814749398339372747942061175459052916945794493609790071529348361822942161054,9731832229994609256189831793652239984819948120347900835161474637862415725695410099163938346894549260478509387040625896817330126259892710787/10840727147803710686138592755602681082471380938462082948802955619351622894187804617797214114106685209310280727634265250352719266380297563689,1},{2471297312797322425907286452168412440770850317364035939506106352706753825066665383023545184383356589580830028648341641360834530491625783105294747/4084415040514691848999462411722047876463493951551570886258432078481793555279010536462359507378925413999190406107168342560539305827911412657385812,-587015690339446911429823506450571885937776681397580486929204395349810259620152166730228236709839102222807017148691846402686752974525641735967020/1021103760128672962249865602930511969115873487887892721564608019620448388819752634115589876844731353499797601526792085640134826456977853164346453,1941243334673336500522810948676902628561780323505620117895913637798855820610461770542824971746754239061170043436398076342718927903028101585797773/2042207520257345924499731205861023938231746975775785443129216039240896777639505268231179753689462706999595203053584171280269652913955706328692906,2764867179891504478034475369171214173974544730701413048376690130295201351273281473786296832520528985955916286836846285804773810613923052719625395/2042207520257345924499731205861023938231746975775785443129216039240896777639505268231179753689462706999595203053584171280269652913955706328692906,1},{3639773467508683708903856212777840419785333906757769897483177593593967201606809773567242134586085268486698862101319623704346285616885806580/4046220813212620376797990589680394183710494546531802660822902515798418822924827994080072269255869162088363632728502191739573656404367101937,-236442558270547799020332047366968684526767092893872095158840014661259591157076478640617807668277192515440690957257456399675159522488181176/36415987318913583391181915307123547653394450918786223947406122642185769406323451946720650423302822458795272694556519725656162907639303917433,-31511656684575733825654872480395009438707918027979917024481521748325099729229198124320534421769090699198510359673059205750545277943116545734/36415987318913583391181915307123547653394450918786223947406122642185769406323451946720650423302822458795272694556519725656162907639303917433,-18917945064124008356466463235578384785922562649428784798792248455262429232452063828618684129694618766071285227094884053945863160689545940154/36415987318913583391181915307123547653394450918786223947406122642185769406323451946720650423302822458795272694556519725656162907639303917433,1},{137838045765316596565753029455082074259151949726820580455483640350161765850729194665412321466955468248865555071162644050765052577006347459328648/322703598480356472759861108028346640477799803290189184517162876955108131153959238224670293472210054627390719937756340997833568122866471829047493,-81529479585474146583903506253216754761557681400107151646926938496280947268455047491786764038217880920985808647698392355346332464502193297863200/322703598480356472759861108028346640477799803290189184517162876955108131153959238224670293472210054627390719937756340997833568122866471829047493,339092315108125996782561516163410053612644269545704198210245538513177746149311115159749195482262579220537703364414040712710485357645473335209004/322703598480356472759861108028346640477799803290189184517162876955108131153959238224670293472210054627390719937756340997833568122866471829047493,301551414805852566487798763182552443257572940259288018260399521188382881624824864271249166288943247063901108497070902405037459568939772235123920/322703598480356472759861108028346640477799803290189184517162876955108131153959238224670293472210054627390719937756340997833568122866471829047493,1},{-10444533386301524973448658458644901267945188187261176204883738148813873216434285108305349541419308527006449726311128229072035763699024750370289/46163465402394034480678911750986306189905617157033195964926547041999767876406340700367877032115698526944314875281956165611984884807228791990478,12331252047400432321861986020746813038976938827361510334863500536865898267652297524528652964428858701169502056984358865316393526052991292339712/23081732701197017240339455875493153094952808578516597982463273520999883938203170350183938516057849263472157437640978082805992442403614395995239,31193455499830068360331859344504675942763074446705190858073658453703646801169078246214670452177949257586071479784250504465746844078012473767139/46163465402394034480678911750986306189905617157033195964926547041999767876406340700367877032115698526944314875281956165611984884807228791990478,17889842489812620578905266778733527885016851673920985530911585555385291128166033486033559510666967679496770936624274520591171328414517329269756/23081732701197017240339455875493153094952808578516597982463273520999883938203170350183938516057849263472157437640978082805992442403614395995239,-1},{1872624786130979579859292732624999581481895068772320543907868129379938801142691300623487424654860457007259136448363559489157881201777371328/788265433476149000025776046864505468953888521484306766862037918145771055957203150783295161140593391378676050411009081478312002314537808835695,-623097290634377095982433218495146628525081312155322799111817361029795959440287917901211033412571424591727938463420929093411753730793354197056/788265433476149000025776046864505468953888521484306766862037918145771055957203150783295161140593391378676050411009081478312002314537808835695,28059433181869519131691125119314397180810879465648013892575525840562576587614794303325146369470914876553184941179687783411787037270294144082/52551028898409933335051736457633697930259234765620451124135861209718070397146876718886344076039559425245070027400605431887466820969187255713,195336112284091612196639974758833551196956122267824326288950025730167074652516771294430538308195711902446479531539005547782721547732126362756/262755144492049666675258682288168489651296173828102255620679306048590351985734383594431720380197797126225350137003027159437334104845936278565,-1},{-17574031773949226760558239961914672849103375669354622372321477753411136000817702694113447953833676603246710292835029614010350870482254163149700/51315886273945073521321176226010621953343165338765837373724046424667369131016373518066377911079279019047613990316720254533185655286582307653289,-24464595870689651915895162563808003304218810425036567138931122949455336741031867248121913419777338475942447910219917247405611125537672267127844/51315886273945073521321176226010621953343165338765837373724046424667369131016373518066377911079279019047613990316720254533185655286582307653289,-2419270083634208601782397004030867215174871702328686790612083825881820225943623132582559226944156550457894578067616170159173142846441424193820/51315886273945073521321176226010621953343165338765837373724046424667369131016373518066377911079279019047613990316720254533185655286582307653289,8598381670018063976358017234339559254857059197277120101396678353960091458900722574756747043353242004645927496252463935458484455171006942243000/51315886273945073521321176226010621953343165338765837373724046424667369131016373518066377911079279019047613990316720254533185655286582307653289,1},{-1922546321701985315686017835329663184407724684488115285902747793033419306588849932204926031900626437978931500850507060777461938415126149959412/17357973863007637901660445918198265269975222844738100303792768456415711116465543568542609328416743922860467794650513511300429526805287151284979,-12622151599587029061807874656784819227235001387691336126927674653330133661308033724473768316187689762901365655871348755155963617021238515722410/17357973863007637901660445918198265269975222844738100303792768456415711116465543568542609328416743922860467794650513511300429526805287151284979,-4143765683058118410361710682477014587585208319604429397136191739461868287680834700031314027373684611048380851928840802538702962330023393255494/52073921589022913704981337754594795809925668534214300911378305369247133349396630705627827985250231768581403383951540533901288580415861453854937,-21196308598495943467121093631814424042102318715913553260604050293354010820025657033281617472032047785310043799030429122481459608205160055949336/52073921589022913704981337754594795809925668534214300911378305369247133349396630705627827985250231768581403383951540533901288580415861453854937,1},{-420634434044389005002735626856131109864860817154571155269082536204984676072007598121258183844713702744024951473150949452028031626085463126879756/264144316012654072037036032101179738510114414675887788651627141632048922564117272081128563185913418679639199770429740457207535427063584639727943,-843038677677367587665387302172301462669213636362383274413798037226853588628739833515079663240140763828195274707459589075868059976773727241463616/264144316012654072037036032101179738510114414675887788651627141632048922564117272081128563185913418679639199770429740457207535427063584639727943,7366314469348884895472140694187293219783775761265322777777360062930050932021239470906706854286430114550794898720585663463516064868948890670236/264144316012654072037036032101179738510114414675887788651627141632048922564117272081128563185913418679639199770429740457207535427063584639727943,502146363395792259627205489775246505736345980879646727317892139502991258467581781377653397123352967940903227021189101467962037737435784201323118/264144316012654072037036032101179738510114414675887788651627141632048922564117272081128563185913418679639199770429740457207535427063584639727943,-1},{434807366282935511411944974281994858753775443520271802337036831262191936223645715160613209303813198043252709620271246456611619924207385251424/3912864949889078393659937028497834882281377449004300099072232061779749269123785139748189231725966417622579255611155144383417976166301959278907,1283813721817775580883046243600521589943491362901917726962911895524672679284775367524125148476207620135235643098403196953244714027061164222037/3912864949889078393659937028497834882281377449004300099072232061779749269123785139748189231725966417622579255611155144383417976166301959278907,-105471901835048469018062812353601772082577002760621181934449066953333655404491964628018502007259732018672468943596221241665707861778165200865/711429990888923344301806732454151796778432263455327290740405829414499867113415479954216223950175712295014410111119117160621450212054901687074,42189842933779075045227569546111262662972308109079852826790313784870745396165908501997259664043821351992019221123223482407551327340661640323/355714995444461672150903366227075898389216131727663645370202914707249933556707739977108111975087856147507205055559558580310725106027450843537,-1},{-3504145091536768481943930948007162624987329495452377208688171499613341872121276191677338876805658871220857269881010754802633104441912198301092/69772397076752746072208710980481041292393051339740701017189972803461495339572101780360875047214853521724214800834552694693420969854940709097,-1245038971128539961387758144561940720018047269651186420660690158620090937017835799935233093314128260083154131923006856549764296291126802138051/23257465692250915357402903660160347097464350446580233672396657601153831779857367260120291682404951173908071600278184231564473656618313569699,-3994171251852394440099971485910792585230575285143880797008429499884142748419152231093176214091148750863731973521175271609789557434652576997514/69772397076752746072208710980481041292393051339740701017189972803461495339572101780360875047214853521724214800834552694693420969854940709097,2686156821120017634089047267181482082568322356988504224221224408050958147351016635423915603961179985323059735805770571259536527173122289066549/69772397076752746072208710980481041292393051339740701017189972803461495339572101780360875047214853521724214800834552694693420969854940709097,1},{-2381438764278606404471453374556916112226345785904671917821312777785120545837597822014927634385300220059621392102493595413630079406052432358414175/642794191437582885646340607616143258301461946503939755418607216477663656337262823800857658582817553466813477919030894885885446580734410329009766,2127547781086650426081792213381895543361919590762753756502492542976681563111552003348130358272191033188291460591535739653897338298157831695584/2416519516682642427241881983519335557524293031969698328641380513073923520064897833837810746551945689724862698943725168743930250303512820785751,531753482905760006374471426699236435156193033661328645279306565753091421862231114027138657406000293639972546210201897368492825450788517830995539/321397095718791442823170303808071629150730973251969877709303608238831828168631411900428829291408776733406738959515447442942723290367205164504883,765119828502610055784977192787475201734560579594077367044236080257617174384190551171389199617984627877735475845653861650622653613462427807603024/321397095718791442823170303808071629150730973251969877709303608238831828168631411900428829291408776733406738959515447442942723290367205164504883,-1},{-2592263108682496131481731688777546967651010472461562430409947742885601446616688132851759435291783844152758668852667080200738622917719714081680/2837262849228475669854909418343321603826615085229697742174447329371008454676060279174312429418900776090911274848353254280035030716374323021899,-9674946971993358975756732148472395373058021473342434217490260690341736438610633738921573374321146791585774429421051003362185823310759098379984/19860839944599329688984365928403251226786305596607884195221131305597059182732421954220187005932305432636378923938472779960245215014620261153293,10139647639772610510770857575387777313031099823742084037272071353511782550806858290341343953119085657432470100925556000998460714264915449482554/19860839944599329688984365928403251226786305596607884195221131305597059182732421954220187005932305432636378923938472779960245215014620261153293,5963719584014002966298793287113726813763780240936092824076094672075878590756859034009136268994445567880219827534655286208108687327946436921689/39721679889198659377968731856806502453572611193215768390442262611194118365464843908440374011864610865272757847876945559920490430029240522306586,-1},{-18318324354664912192590373327469250025434030219492039466666016308969968683093636505519108341912099444104479417091252800188341556152837267261388/67660478803967326211484721479707535879870662862835104020933535107868665590622250747209584072152583312743471860875564732893899908035298000990193,-68066396416272192942415136082882718560258918384895516582366571030317374674361447939391252704703578605151646236420021500873616033290696970332034/67660478803967326211484721479707535879870662862835104020933535107868665590622250747209584072152583312743471860875564732893899908035298000990193,645328158316576372364651927498207153185125795853897763497880285271507145961039699157559078894794477497722177656816647445148991216809888221312/67660478803967326211484721479707535879870662862835104020933535107868665590622250747209584072152583312743471860875564732893899908035298000990193,4189441613920892154008095032149327277777129661766396412469562828836490235736609384066057311793511807581246498172095045290665832795275293881032/67660478803967326211484721479707535879870662862835104020933535107868665590622250747209584072152583312743471860875564732893899908035298000990193,1},{401725099691838582358892420387090731472787123182570709873873361263612002875398270583021789877350773619112868465280036466162246272559599254299/249495428980602571321720580353876846271172026159882079353849537990989631386913782444485035844869571606694573519576822940746597726682439358924,679297050427637206450112685255186019122077694112033762752974726990026913937590917084697349889564264190305826848261500913592159539792688833761/997981715922410285286882321415507385084688104639528317415398151963958525547655129777940143379478286426778294078307291762986390906729757435696,-475227389032710801408973769967984176692286532695515289451834523955067262096936063540184534434681043906137496137118778780463069631633650304103/498990857961205142643441160707753692542344052319764158707699075981979262773827564888970071689739143213389147039153645881493195453364878717848,442791856619481886312252139496417942183917929035163380386987713889454123387669142110587307495665319003461397928787524076762745858674060892125/997981715922410285286882321415507385084688104639528317415398151963958525547655129777940143379478286426778294078307291762986390906729757435696,1},{-1937731697620692796161159394960074110733995660353030967037045449495973224033355080395722852164381551404908412865708698333818895179572756730193/1259215613324267789729577884685472807718711241028026509642724805555349448207538630909407138543130876931759763763960002225621708438538877790365,675148610140872110058195257583805440631202309056956633438667460479463453410052017211921205762067560030755149879882536094101026429803401856656/1259215613324267789729577884685472807718711241028026509642724805555349448207538630909407138543130876931759763763960002225621708438538877790365,2245960240608002940958718007040486605528081661932161917334889989008077297042253637015112644855167971235768529876284207677052515960812692085326/3777646839972803369188733654056418423156133723084079528928174416666048344622615892728221415629392630795279291291880006676865125315616633371095,1021610124492388456249514283372082057972857449208086517401115928813380873260461046592476104809842384922642270577594211574523737183019784274045/503686245329707115891831153874189123087484496411210603857089922222139779283015452363762855417252350772703905505584000890248683375415551116146,-1},{-495726102944980371911208758549872119571081993609508078305344766300623752798528366869679190716403229401926013667381358010624025286719098191060/235590629644961809083918165083046882130903437414977694567125327484641201367596593595130388132874691683976733298904043438933693094729040523461,-886244741023031296257124687799552081794965273651712394837692804792050344571980183829697780362380678478682197614628970006373233892186425668446/235590629644961809083918165083046882130903437414977694567125327484641201367596593595130388132874691683976733298904043438933693094729040523461,-124399811056082043842118817531563567177765632994795629413794995086154812569627488965722402499897860755802314123308877690195892093699220541248/78530209881653936361306055027682294043634479138325898189041775828213733789198864531710129377624897227992244432968014479644564364909680174487,48019757690640954008701295485434838318821132234216145480610451995621260787310769040225155054817445862183875791377730530983712426295207176426/78530209881653936361306055027682294043634479138325898189041775828213733789198864531710129377624897227992244432968014479644564364909680174487,-1},{145568008942095811210845996289209300892558261768785237113295772917369443568435492086264913815171473524518595137639264149347019673869403908756/660367815218482096714671567440208913987098856521542407710658106684335306377032788639651551602279652313734910244715906342431300681400025836331,-714586025159232650956800868192304877691504411278763965530198613038626794829652013093176169406866765156848599304783595035245254488307758344786/660367815218482096714671567440208913987098856521542407710658106684335306377032788639651551602279652313734910244715906342431300681400025836331,-1021940340090668321259941421640424632648705039123291582909021743579671769506377352582934902083237567535213382930624765100818117890928060121040/660367815218482096714671567440208913987098856521542407710658106684335306377032788639651551602279652313734910244715906342431300681400025836331,326812357433743419533275000711570708012738390560011088783790143381909309896452895367162848775037773965393377223678974710532607080382586190534/660367815218482096714671567440208913987098856521542407710658106684335306377032788639651551602279652313734910244715906342431300681400025836331,-1},{3338506963924372504564268650259404754005455973512315740948290573652475985720445204687951213980945668251032404853429488095524386203046431739689/3312251511627812178812707876721167739881063454856470424041157090417516645930406374804186495011534758912099216219450033693370406924373338619142,2902797967370065700433172564501300304001310945534882075390757641761567977034035468319114435665291568317810595071688595583554097056602814975808/1656125755813906089406353938360583869940531727428235212020578545208758322965203187402093247505767379456049608109725016846685203462186669309571,2195086670189849738722720109439059916400031214368718257068571993306826813138694176718148694057439733396627920435679932821431632843539243370835/3312251511627812178812707876721167739881063454856470424041157090417516645930406374804186495011534758912099216219450033693370406924373338619142,341354840379562870398199912255687849097065941024603197874088956118537421348635468217411539535974286108039224036122527755238762941212859442830/1656125755813906089406353938360583869940531727428235212020578545208758322965203187402093247505767379456049608109725016846685203462186669309571,-1},{-3492150319857262703281636918067658226960966210239402213645241214250060288376347240847847563920499379593090410953661938823532799942631139723862/973945657183411879433731238216558033328314874446895187990318897516704549469610296145812549359678054168929168988766604521752667051737081285919,-513757228213374933642395017891815247326699934700113624017743113461015865384327383708172395290302786869118273624165678439614637570552600415360/973945657183411879433731238216558033328314874446895187990318897516704549469610296145812549359678054168929168988766604521752667051737081285919,5975023132270418616753736519615855116327097343695157609019144591833790001334934295552292192175846112607075964435725732478229964087592541520270/973945657183411879433731238216558033328314874446895187990318897516704549469610296145812549359678054168929168988766604521752667051737081285919,-5487376336939934202126225565565598586399989727520834110446101337851155803980087798075822806568942825452888039357608890320549800837155331156492/973945657183411879433731238216558033328314874446895187990318897516704549469610296145812549359678054168929168988766604521752667051737081285919,-1},{-50964344032090449122596317470788687019561519263952449594386919424774315714127115597474243707631680944449273148961408151480707796138266747319/41561877866417093488830465458653417763424260039126327352946481311285426109299275718474852527241363199035772520763771980056908640681230189120,10498323973595550297377699691393490468596223018789467383767793189667844292630972697537023871124065495234863732175358999490902808149038412571/2597617366651068343051904091165838610214016252445395459559155081955339131831204732404678282952585199939735782547735748753556790042576886820,87398421760933890686353297435820393935474976701860015572561702942887244916690935837649828957481750511780171738101374430974763175069813317267/31171408399812820116622849093990063322568195029344745514709860983464069581974456788856139395431022399276829390572828985042681480510922641840,376072942451670856435939552655160576244175464992668676281202367726471486888812739928837136786771039879491848624145440627019652439565649263381/62342816799625640233245698187980126645136390058689491029419721966928139163948913577712278790862044798553658781145657970085362961021845283680,1},{-4885023756213084162257828618225925862760595879522620124796209124934077725437256788450084323181712165214117981828165076972438544123917549707084/820413439002799197772869227069871180823567366945278723144730400272202112360795058116697226192216566810611524961829887248158235404174917126985,4699788547064744532181584246290536744792880717957159708984446821215682049333514097826933354534806447399183610835631343273113062859334099366252/820413439002799197772869227069871180823567366945278723144730400272202112360795058116697226192216566810611524961829887248158235404174917126985,-5636761431277510711819224446505751990652267586243497596370783624892894848727389305818677712011361619416868024595276827157270982185262727927269/820413439002799197772869227069871180823567366945278723144730400272202112360795058116697226192216566810611524961829887248158235404174917126985,4030540553494092808463435092251947591392912510390245486896586213575915823617060317165118617317850635884652742646670367381791327524718799070408/820413439002799197772869227069871180823567366945278723144730400272202112360795058116697226192216566810611524961829887248158235404174917126985,-1},{337048067113352836628452348077722014671620651017455804337629951417942571233717135193431148473798985823661122405763289348290717884457950078400/822938415817529986364590615466429610930038841695179160017807658746527950806119772906905766588638806050622325139218740807287031003268693163111,-53606221555048574691680566032426692257935159839315226266027342943867411912168213232589516854811950141362099909038305181525523029418852366027/74812583256139089669508237769675419175458076517743560001618878067866177346010888446082342417148982368238393194474430982480639182115335742101,-1065560885637222284337289332145768159835598837384203247663561048337688670017322357316218614826390988598496947548069178445426665232578325494654/822938415817529986364590615466429610930038841695179160017807658746527950806119772906905766588638806050622325139218740807287031003268693163111,288527629708123428361017395725350626278533002507269140661543158509753826785732812927995903080334529704044438629177153868573835956853049880869/822938415817529986364590615466429610930038841695179160017807658746527950806119772906905766588638806050622325139218740807287031003268693163111,-1},{-6870844022804929435722311292538605499548585873179885922608059266019624315646298235402356281886846835412750683552077116208430765886343411837584/7344856464802098176314570861044324608633229075266520844578221765639845466899696820461244389390572435942601927276459484486814994204828520568347,-5588164520090945547958059069020678522151398048270620709472271181085315323600666986605636068840360761381395513705219864829711989220056129400480/7344856464802098176314570861044324608633229075266520844578221765639845466899696820461244389390572435942601927276459484486814994204828520568347,2221461864212245684639030891571914048606175453495771725070656793606689252656398901437606345774935641349158885291098621409542284207992488570870/7344856464802098176314570861044324608633229075266520844578221765639845466899696820461244389390572435942601927276459484486814994204828520568347,4397268462014982914200855652916877315494336699157257440794669114016071231547145256027974044127303713717831385852856084988272910483196968268079/14689712929604196352629141722088649217266458150533041689156443531279690933799393640922488778781144871885203854552918968973629988409657041136694,-1},{105138383610066406394037564819789782698267698228558277460373199361536560539253841364621260399723890723670801337455087049691496073016212119424/81768732681590949693556260232588079671627814130188668032642459041278947445801274794528525291086255281321097562625973703421696693606512163439,-11510616031380330197112682885228776874787884695415622325755824501202642346611438467911969273223084595778121231849958232352548456957649739414/81768732681590949693556260232588079671627814130188668032642459041278947445801274794528525291086255281321097562625973703421696693606512163439,-42958926695146056636348427135606880260377783777672902421712737944664903956990070579422922980843663483191123393427684179544408195316009084400/81768732681590949693556260232588079671627814130188668032642459041278947445801274794528525291086255281321097562625973703421696693606512163439,-3655921415878529061189820473610851748768371276310759425114379382999005796499988349528430220443249323986269312694602198958947147203785841309/81768732681590949693556260232588079671627814130188668032642459041278947445801274794528525291086255281321097562625973703421696693606512163439,1},{-1310521158104161060822868102036753614828107065433132704321949396809620969162598369910377342701117860511124846432350552641862549193572095229776/4870228665028548653303558512900104068804298068642506458896897441750059779803176260864333724175178375742991223037934490311272287147717700005469,-5052684113159077100564361505768157249456237035388747424225027939114195102632554135192948305547646155727976746733316603461690105037253103118183/4870228665028548653303558512900104068804298068642506458896897441750059779803176260864333724175178375742991223037934490311272287147717700005469,-1240287482587030189159809182386542424705967977394063975243240180874461266018923422913200042193280317129521334894118229446484726974822010829746/4870228665028548653303558512900104068804298068642506458896897441750059779803176260864333724175178375742991223037934490311272287147717700005469,4062635989006155083259158129636067116994863094326968304204621186659633807151666049210513238625226867541689992814125301213313258275372816048571/4870228665028548653303558512900104068804298068642506458896897441750059779803176260864333724175178375742991223037934490311272287147717700005469,-1},{209690494136966182764846227035058954846175126220900548312412846219875633216869415025264747202417554384926780714134306830109463837020500678848/121100389551856520986844197218579267275334384522312784314589972465397872079572981589358155073411801211699037786786299826614971271513311927887,40942399749981435753242772500040557220132125130010921544977036568866952587197510812923436600797817499488370043952138464029050547188881719072/121100389551856520986844197218579267275334384522312784314589972465397872079572981589358155073411801211699037786786299826614971271513311927887,36263251393704039992327583519173105072213793328278129947001796834228099262383744039031305807943860009355494730613509090534841235475123910530/121100389551856520986844197218579267275334384522312784314589972465397872079572981589358155073411801211699037786786299826614971271513311927887,-148598021450916944103959174127505744061583888129661626731806424698987990068458284368562622428964129497513773715880645235829304066388779250204/121100389551856520986844197218579267275334384522312784314589972465397872079572981589358155073411801211699037786786299826614971271513311927887,-1},{12903457983763591598767116261389460488957818105134759943621728158233926895171226095243164253217848482579334945195162070690047335908621092771/4760085546039960930981012767089429687579073744102490886196644677903989162482914334592432014560375746043705765956887438130659151373018577497685,-3764518873387766670576312260325354453580616823791661549503529300623976949196348536241292813685364761305339520748026080197412483248538131654912/4760085546039960930981012767089429687579073744102490886196644677903989162482914334592432014560375746043705765956887438130659151373018577497685,508361461418333257736326238133659176721038804601258829692893148376823374927713335733676511729673998299140580837489964131062445836919780039288/952017109207992186196202553417885937515814748820498177239328935580797832496582866918486402912075149208741153191377487626131830274603715499537,3539299131659133210239014439061188214756177876753959433655387725489840855536232903132307032519282567358174235120861077685730138176071215663516/4760085546039960930981012767089429687579073744102490886196644677903989162482914334592432014560375746043705765956887438130659151373018577497685,-1},{43865751098942554829555159949675083818879421063856845077666796664323478152071167563760941780579693310197270387037950245326606850367608708942/178136999627789548099098196064795172096784291809444270309920561738204472095260706510051774355565339577927972873019903674821716325800496471749,-28054177032323644071509167956454080973401702878287343681822749195465957378869904315094195183204476480018296861287535454869091303968728056448/59378999875929849366366065354931724032261430603148090103306853912734824031753568836683924785188446525975990957673301224940572108600165490583,133830597820837196378354244566491798596001145373461508902179974008102506983194874707361351382658148630495113676908504536061801254872459492676/178136999627789548099098196064795172096784291809444270309920561738204472095260706510051774355565339577927972873019903674821716325800496471749,235352835975504205843721684711277235900735893458400379415740567424005684716510866467806875860684576703960441308215245022364459359195832868092/178136999627789548099098196064795172096784291809444270309920561738204472095260706510051774355565339577927972873019903674821716325800496471749,1},{-213521773048971545954332326343698984284611039592426099888447938599875968660992995990717545616760422227502014692330445992533868402927827909453472/383256156541809868041130482530318315900219834720779474774907092161314898623188848114436667008592040767967287326162208714489958370070581891807829,79343783944364037153684694345449167249482932844745251449483028683871698402585580214353099189522959807869918342112956757238858096539460850618016/383256156541809868041130482530318315900219834720779474774907092161314898623188848114436667008592040767967287326162208714489958370070581891807829,54587255123346318872174371220244286946558748927987687270518314663309127672953187730049624240708108677999630310206151868207330812769128217829188/383256156541809868041130482530318315900219834720779474774907092161314898623188848114436667008592040767967287326162208714489958370070581891807829,214772128917893672466932129586829501689847887931954022900652334701510671399749131321945842833733092943216669228113730155425499536116200817264563/383256156541809868041130482530318315900219834720779474774907092161314898623188848114436667008592040767967287326162208714489958370070581891807829,-1},{155904060286221234680540658933023401907863912761316364741452575909757311753028167295536667924884669901492311123372689180549689940542121611112/120354733362953339238596775134803170731593948348569471003082403726018422674249839041590391540031865644649646725485356902370589031239786021637,139462309607747037905703488939835733282287771474756231480635637246447876593275539919539788121854360505954593664075339808620112129302590604472/120354733362953339238596775134803170731593948348569471003082403726018422674249839041590391540031865644649646725485356902370589031239786021637,-103288121351321673082385914536257705395953913070196823055405594442868400984068504141639212912546690619654548027679786690453705672834446896258/120354733362953339238596775134803170731593948348569471003082403726018422674249839041590391540031865644649646725485356902370589031239786021637,-19428468014008997282468206611199785232459258289170515330691803891978443780593256550574296858505230121353860674980233154278157190826684445862/40118244454317779746198925044934390243864649449523157001027467908672807558083279680530130513343955214883215575161785634123529677079928673879,1},{-2294992672860039755888550979570931398481241625471929272336328224620939229178118409950593432595416082005824781283114223586982244698867483320148560/3284524323228618964152449055440676769281690881699762884646845561586614687099250713540389104474711744027200567171913135959231305827828709272296351,-3182811166345460505708316832494271801907833025567879777716387632640016873402170240736283051099446925761678671850441630196927170093209302980931456/3284524323228618964152449055440676769281690881699762884646845561586614687099250713540389104474711744027200567171913135959231305827828709272296351,1061805623750370168067436028845118823620741966277635601858227752595972209077508427506850543472997567053190549853444645814848190512339742493752664/3284524323228618964152449055440676769281690881699762884646845561586614687099250713540389104474711744027200567171913135959231305827828709272296351,3472703295143872113975252988595145552044431777349646737896566928727200368031024582509921257922550055983532447627792794326875569469024445943977376/3284524323228618964152449055440676769281690881699762884646845561586614687099250713540389104474711744027200567171913135959231305827828709272296351,1},{18530274347159420563846034015198486049751577794548665695471086764750072034718044051347139013490243759140807170360571888666188981961566132047230/7566406007568551658594538579170826110312123901696404034307294919370421232041489523222021648006501088829832906327661817183683532048535240303291,-12683576366104419872641232489473916488224873984812562730318157952591568895673486197808796369630474892506863184257172417558322951105264487076768/7566406007568551658594538579170826110312123901696404034307294919370421232041489523222021648006501088829832906327661817183683532048535240303291,16844336354630790663227091776317622455408428251615086841502478886096765586849134291230081747978997440546124345620556026095924415284607555029374/2522135335856183886198179526390275370104041300565468011435764973123473744013829841074007216002167029609944302109220605727894510682845080101097,-14943781893280009110963201803080587312148647190126828353601117860868866321078384531393142383407054112029644648453188791181825969680831939970572/2522135335856183886198179526390275370104041300565468011435764973123473744013829841074007216002167029609944302109220605727894510682845080101097,1},{-3228896732932891394980874576884562656111096670318023276690208087276825809963286968327245615768200963893810993192180883816693703585697554348163/3890127809434110290586923683973280885514879932140222396032532270525414167588244087504750547387367732634203459090668580401885206420167431235919,3794514018781281551745817676449152219619613350856898174073741566093013240158788450107271503142526875825066386327577815069827218391693768808444/3890127809434110290586923683973280885514879932140222396032532270525414167588244087504750547387367732634203459090668580401885206420167431235919,183705336313658521720734277451657415760048129559728766102791044743121542820484093436555202964778677170068948217993734496900519276139722511355/3890127809434110290586923683973280885514879932140222396032532270525414167588244087504750547387367732634203459090668580401885206420167431235919,1715287502847957193033982259174273079502626194264020217603234350965831386072333564907094943230461904990335604752964098565424790061072947764742/3890127809434110290586923683973280885514879932140222396032532270525414167588244087504750547387367732634203459090668580401885206420167431235919,1},{1553170053271117136637490080390852511413790438199760241641401991167490247162333667369655013994995958816404337625131165437087975171769197437856/2394084292390222728763304230794449907414053599979186618647339660161697398730074956926885917036373882052031195134412165315778797032218916912167,14115103763267632660886619344405310465934251494753724060605092947642513972980651024959532463047718997393486214798120228649694408448911137821265/9576337169560890915053216923177799629656214399916746474589358640646789594920299827707543668145495528208124780537648661263115188128875667648668,-9775252288141084411254800263212279892122052829717359635212528589262092837747738696181038924365090513165347926915660667581226940999629131684735/9576337169560890915053216923177799629656214399916746474589358640646789594920299827707543668145495528208124780537648661263115188128875667648668,12955486740136585201278453506499253217627417350964604091697421791535290226809760897690117972132508014332107965938983807596798751564782673470377/9576337169560890915053216923177799629656214399916746474589358640646789594920299827707543668145495528208124780537648661263115188128875667648668,-1},{-255061847744233652637707128323854622365026607596293368535493425956907996668943911139025963993547222133390198870573828979295139659510778115317856/198583549864046913098141732301069796919662514128055084481411314090679932765605081667460802220582152472634184916166695533492990577570591203525915,78358992989117598472721334952732609610513428417140707509595956736842682638904401968117091868032117781786874510996798730441723343821310819675824/198583549864046913098141732301069796919662514128055084481411314090679932765605081667460802220582152472634184916166695533492990577570591203525915,100766412283600893823213486479248011986362400097484000284662771055702346448476986074540595081271454715401991840323733371113548159951621642269674/198583549864046913098141732301069796919662514128055084481411314090679932765605081667460802220582152472634184916166695533492990577570591203525915,473915686509686301379444252294823984342705400571990224081530356040963519683566904571513981537959213990065707836643449808011142370220582227703131/397167099728093826196283464602139593839325028256110168962822628181359865531210163334921604441164304945268369832333391066985981155141182407051830,-1},{-517926557646584883718306159769710602423599046566822038456561629437616888178744207906465358549575915208359937989339568104595264937504724825520/702609048877083204252864998301246214789399707395840037020872615140242716774326887276919107921562732104224845059388082240949106799739943124833,-854138580545202324123591025710870345536150270075591909589482974404808353187805011683496890258105137127421961917386651395842078900178301043415/702609048877083204252864998301246214789399707395840037020872615140242716774326887276919107921562732104224845059388082240949106799739943124833,-171798365644825921972698518039560679375388853890500599942923789385589748798080377397252928513616753952524403399685360974706816067034189601714/234203016292361068084288332767082071596466569131946679006957538380080905591442295758973035973854244034741615019796027413649702266579981041611,79447678723735695450663785697932193931349087038433708286961999254831972229562936144856871350012832647605741396721335614839755440053390721512/234203016292361068084288332767082071596466569131946679006957538380080905591442295758973035973854244034741615019796027413649702266579981041611,-1},{-22883814529449099627323140963783938398644967956453231430265442123637212402202216534912325039308982983802355439481018150200712956474322509755/542365603779123009773654901157701743954248781026221857952343809618535634037306686048419687945554662746420902266095413317961276535115346203674,647894899543540036822094561713298908706459608418820057364633759641386096878549768083450218183386634216351105021796453745911812230326552229960/271182801889561504886827450578850871977124390513110928976171904809267817018653343024209843972777331373210451133047706658980638267557673101837,270932613941976072328091655310374739423222664845371541701272736908358575637633822298915289420108985926936188936733749111138073040255454729259/271182801889561504886827450578850871977124390513110928976171904809267817018653343024209843972777331373210451133047706658980638267557673101837,440511526127738836745143231327744211855045776392497280470091982043411257691272842544540577976256425395048376843297535099291955859724088430521/271182801889561504886827450578850871977124390513110928976171904809267817018653343024209843972777331373210451133047706658980638267557673101837,1},{-72455441080193584523971175511562091213587873814798485260548241318312937857262833653621331442521043958813916967837106419498400551898478218309/194851413503499093362558612226970418544511798495638518386342264076314551959055538082616136434242757043784163549264061653350333386875798457016,981317004806037503154575998190835507097788398458440211885913207271923061764205001531642695335187821213402181504566438535205776726989091394441/876831360765745920131513755021366883450303093230373332738540188343415483815749921371772613954092406697028735971688277440076500240941093056572,1284311395336822359296580326285458043148497535576021998019630214287736532992611337432501572070423010353999896888309006623996348988340625201519/1753662721531491840263027510042733766900606186460746665477080376686830967631499842743545227908184813394057471943376554880153000481882186113144,-226729326569827597463628775973149907683577680403914888157040282161932960989022206259448975521473026668482247873459565760775759882260825422584/219207840191436480032878438755341720862575773307593333184635047085853870953937480342943153488523101674257183992922069360019125060235273264143,1},{-20479733698012733366423809719688557735333491023298683024647212517428851936453448430865116396801881456617626071212159683970960256485855301052538/5327601842591028091900114602869543672196237185083241388957159580019928192541342635163767771949103134789643456821156908176013762181574009141293,9325465560126828238751723051509505169233225080294548812959386255637113761996077886932906243264938547051640959471219588528475758949055616930432/5327601842591028091900114602869543672196237185083241388957159580019928192541342635163767771949103134789643456821156908176013762181574009141293,5633473887140680364312329818445731460856093362765745141969090645187921208383825281823661326911661437933952734661913772057245661743184802473666/5327601842591028091900114602869543672196237185083241388957159580019928192541342635163767771949103134789643456821156908176013762181574009141293,840714780091324261196627454769387803384875331453042981406958014586511425357755414679529694319349842185809542472508277534118018972351369182313/10655203685182056183800229205739087344392474370166482777914319160039856385082685270327535543898206269579286913642313816352027524363148018282586,-1},{4081643098431795406664227235858952393235174507350753888814613759177876722203579340974221211369476117935399516187926202928754202027164928439832/2932432265432466015492199140328588012465077862172889802017257406953724363588348766273792928865682769309430197482209541668381792060851721456741,1084697510749219112549453575497339553537508751885426456237714710190419570659492901604093757303600591948167727676126119604257107541188136475080/977477421810822005164066380109529337488359287390963267339085802317908121196116255424597642955227589769810065827403180556127264020283907152247,-882081284230560283587389358045612981628645646870204343454044699012800566709401532505515990812284942661967255291449336732969144588242810320434/977477421810822005164066380109529337488359287390963267339085802317908121196116255424597642955227589769810065827403180556127264020283907152247,-2095634482588524220430428092024254480054129827811831123647522764622349472715490905071403361476970490082819229978818959094007045894955059295398/2932432265432466015492199140328588012465077862172889802017257406953724363588348766273792928865682769309430197482209541668381792060851721456741,1},{33789115090623646241884407936239655874783315884202404015818161042553697825221460901392584724606464117033933530533950839542104333484379622077/12031889821867406401799013585950273143619821008723366567222316691810993318726168648094076440740606577954494384940323659332454035558667373122275,-9511437168535819001441109795589690224116962735582658761031137000798667204076865211500192978159124820362782118845402571516752195508685210535744/12031889821867406401799013585950273143619821008723366567222316691810993318726168648094076440740606577954494384940323659332454035558667373122275,428270642167222147292858439109144185272317811592823191675395885163497572599859567467250663972109526434276772943316667435076098580886611819424/802125988124493760119934239063351542907988067248224437814821112787399554581744576539605096049373771863632958996021577288830269037244491541485,426043995758894554776796371119181478450098738202436174473512504794257728919084195795269068028893189725446674318916841200404462110059085563972/572947134374638400085667313616679673505705762320160312724872223419571110415531840385432211463838408474023542140015412349164477883746065386775,-1},{234057041354048850929348713736038009313722757553188203788266832544454380837455346280801975097710914074574681941836575175520680610797593816228/853738870681955031954629702358266795956043838615124154120763661505668522541763269279538121845610327892835543487104215345792383095284840880845,-4534967664283931425034661911803122116272553367654232696529073564739166778106748692835098772942406325718657627735767357968580346360539851443923/6829910965455640255637037618866134367648350708920993232966109292045348180334106154236304974764882623142684347896833722766339064762278727046760,-191743062589984653082296581705310656675281618308701585582621034534803891385864592210503516860822082157300296101712377242808827928142894562413/1707477741363910063909259404716533591912087677230248308241527323011337045083526538559076243691220655785671086974208430691584766190569681761690,3208121717065237910554374029414525858754532751034648525936414754335144777405534601447678962131174451007014501433316958742996358352676008849777/5463928772364512204509630095092907494118680567136794586372887433636278544267284923389043979811906098514147478317466978213071251809822981637408,-1},{36941603665136113910643841935934658603665012688617019278271853135277278149447570232728294962396271977713085970929266430184195414150774889888811/37334872774794829234183132211752802362376789733829362496174971669460857976660614022531854000541176326448595137383805987573342598939396337608648,8543789312069633229265869663460419731540097647021244953649473300043838560271837154642655030165139005580777852777727569346272795198371529047020/4666859096849353654272891526469100295297098716728670312021871458682607247082576752816481750067647040806074392172975748446667824867424542201081,26155734323305631228954286015391271628784455645845607019511927181595444786820474718264406599480535922049680898450395801800512605256201364023937/37334872774794829234183132211752802362376789733829362496174971669460857976660614022531854000541176326448595137383805987573342598939396337608648,9011314770523814730081602563023248696947988627250245026797828981746867485973333713841810698472340247413037812606963063068316319455353316688277/37334872774794829234183132211752802362376789733829362496174971669460857976660614022531854000541176326448595137383805987573342598939396337608648,-1},{-9451796955374159617993412218714379226724022366845006154057517340280201569635387858395718867247520308249183873645970570673035280099302584869667/42942049048716699093527951003786708594950063564718347260041516268140552658319404827401770611630944329244914085093887830463645220140270016012706,11811530035526670856448107058164000331053450805437328129505625969470058913355488198134433250606879709431725923751244628317756466515565944744384/21471024524358349546763975501893354297475031782359173630020758134070276329159702413700885305815472164622457042546943915231822610070135008006353,24594087587830731039496573470093753793182952738439997659520428427921127116273339956704620580894133404269403276532597013867776815343085352501535/42942049048716699093527951003786708594950063564718347260041516268140552658319404827401770611630944329244914085093887830463645220140270016012706,13408549885510950990008703527981242208046160120791437293066193283281740794400669051284653932059324733550769531718937846754270504344270460729066/21471024524358349546763975501893354297475031782359173630020758134070276329159702413700885305815472164622457042546943915231822610070135008006353,-1},{423476790914025031930460366202267503749551576462836897773841308449104972183269368501880266243987855281439546610630778553913710906444472104700/1160925888793101491836018647250431820900137266335940577851563984276977976319625925675930910870137428172170990755099906803078569574529347463829,1177436312322315449488969464217053202909007189189169573562516906233435953801375312772949117641167545669810019317979906549268182982919760754184/3482777666379304475508055941751295462700411799007821733554691952830933928958877777027792732610412284516512972265299720409235708723588042391487,3073688713244641614046555177998455877656722045756880804821611731221250299389999644311608354583371861938455363100119596503580728991173081308024/3482777666379304475508055941751295462700411799007821733554691952830933928958877777027792732610412284516512972265299720409235708723588042391487,-2745233437563744772846086940210792860461326020574675021004983706201394139379091401579298821162913478974230348387039258744935046707008066889624/3482777666379304475508055941751295462700411799007821733554691952830933928958877777027792732610412284516512972265299720409235708723588042391487,1},{-920364484037584622720614588371154880834372270650736557896620987228710510395137808036017537864508254941243128068637727425451899837198418808776/1610069695434250685894170943376916303364980234881841248142392079298347958956555684732678544108282556596716835860461156788817450711173017474099,40626591473673340882950585403331691078290369364482402856778851370857243631079103037344209540604571494426428907152289268069246277480067009115/123851515033403898914936226413608946412690787298603172934030159946026766073581206517898349546790965892055141220035473599139803900859462882623,12350538912059165060087279620899242697159429668951413113475294087951404877664864638981882936481776221856597679532109222723950032062134999725/247703030066807797829872452827217892825381574597206345868060319892053532147162413035796699093581931784110282440070947198279607801718925765246,829868840120796470709453272654270846211538250080960514596649376737770917652096836982423059845902989841452470994315556138729894941744964464369/1610069695434250685894170943376916303364980234881841248142392079298347958956555684732678544108282556596716835860461156788817450711173017474099,-1},{-11374813442529308093554650706646823696460375087665743223096035317151269983361193085844043483297491734863248329331646661247261836538155793499049/18541581965924963819376998319242576444515834587153156259138863413932905779890612754252629378825490077045906516083425886045018923057257425176432,3215822037845247477912936700333458443913306535306227298100995370043939813036934221228103466662304214166457078129988189988890899891276669473203/4635395491481240954844249579810644111128958646788289064784715853483226444972653188563157344706372519261476629020856471511254730764314356294108,54957875537281601428131412491541776025025897299888868948768194932394834708022976419662152538163935531618617865758246697474395536661251100746485/74166327863699855277507993276970305778063338348612625036555453655731623119562451017010517515301960308183626064333703544180075692229029700705728,-1236541797459021719747263173716957929679026838929857107287260152844304738506255829296647726775933627875358970955032885930321185490207021856677/9270790982962481909688499159621288222257917293576578129569431706966452889945306377126314689412745038522953258041712943022509461528628712588216,1},{-3400448918168167463074922780344558313382498151339377798885339693475492938795622279747702127764844245024859230600536359164404509144717629132496/2338135516220513846522177118772310596289505143995546210174364178561885114974564613776508344570658039420360045832914080435546718799510565830699,4326381609693665168918200274364925492565135259144777853480734074793075994263069072917582444920429095746860444003056432829314157879661814287314/2338135516220513846522177118772310596289505143995546210174364178561885114974564613776508344570658039420360045832914080435546718799510565830699,1728754257465942727118195944706245055539790846177552073960722699814340597826046972562156597587071126125886563740885624503229532511839385796447/2338135516220513846522177118772310596289505143995546210174364178561885114974564613776508344570658039420360045832914080435546718799510565830699,-8092093738254648047970666429037556803772509271155034126208486375104756611923289693204662712970771295459698255728850171867811329407541997906599/4676271032441027693044354237544621192579010287991092420348728357123770229949129227553016689141316078840720091665828160871093437599021131661398,-1},{271553792886595377124953282475012637151959871494525944412177892416267182353194142985829236923973390863011216316401513475625141704407502262303766/97994837024433604659333442626805913233815463470169475841363500589494697111359435268121353483210471549060285000209209655974867844296207698036797,-72454055738937108755386880166747020147243990854013247355845576995595054988062390577749079122525216076635810922154506790910995885629322714439120/97994837024433604659333442626805913233815463470169475841363500589494697111359435268121353483210471549060285000209209655974867844296207698036797,244991070174031729102061509952344568918973902495395316097103360297885345485857567450034524215021999565544092105638028921394661953445654838479960/97994837024433604659333442626805913233815463470169475841363500589494697111359435268121353483210471549060285000209209655974867844296207698036797,-232822660956339246483903997231070098248658425614059923625776376596850358764812160127303103338778933611742448658156018202301239186737911642075924/97994837024433604659333442626805913233815463470169475841363500589494697111359435268121353483210471549060285000209209655974867844296207698036797,-1},{-5030523479691894692579060442429371957364752907516747873427061280622924012222101172357136317841122545580619779648648030237986767069160180262345/3053563380092411452952071957795949441558753594709988448560629757005841446713566420977068891220717434386465398969878552005035947152748722617801,680593964511609141638745234525347312670438856101005346704166761449028618405775262687278343805843563108234101388470351170993193758770552202120/1017854460030803817650690652598649813852917864903329482853543252335280482237855473659022963740239144795488466323292850668345315717582907539267,-6398437687295657071808902936562112237307435439794616923263102435264012531818154134586982301498129018277802086848198818861067842639933509351428/3053563380092411452952071957795949441558753594709988448560629757005841446713566420977068891220717434386465398969878552005035947152748722617801,576655741013556022480255750750478675025577746070996790235581614379198104108358297669084664203571669477426677556150723643832977804967019510266/1017854460030803817650690652598649813852917864903329482853543252335280482237855473659022963740239144795488466323292850668345315717582907539267,1},{-648788569216819935549553400108130032565871135408700363041920178702948535371584102914533729241587703777309686414684898871644523572715743537461/256407392024585024443856219529460977144498748442926269461902659511797573430577467850923491636996358765072222821927778685049383233900311581094,194593444178386557780477521245024914876067137947026449471059659884361574274761511396083845842330102075224918849582127057251157509020067005042/42734565337430837407309369921576829524083124740487711576983776585299595571762911308487248606166059794178703803654629780841563872316718596849,170164966926783544984790108199987678318485925802564674060232475944845702239562949341179753830670714047850502293764135972246003473068115973571/256407392024585024443856219529460977144498748442926269461902659511797573430577467850923491636996358765072222821927778685049383233900311581094,-446117087624340020323642883089086468667990846701193801167997083049848081186904990208080567948904480440163285443838145797345504685843581792821/128203696012292512221928109764730488572249374221463134730951329755898786715288733925461745818498179382536111410963889342524691616950155790547,1},{-109713583960328826332905977070311638937537274143913219885350536473238645846661807732288202924796691619492220374298383025473290617070267041452/263213997764955983847244833925067683138725012112076169481190903785535757526759496060452464276698183486191210740175844788699551628453253641185,-222736168792607037338673030348651423922204703369037399153468116171835537199470261770466258650064066420200849037888802471832485384024533179372/263213997764955983847244833925067683138725012112076169481190903785535757526759496060452464276698183486191210740175844788699551628453253641185,-118014071901771514172990425434887008586489706212490034682610934381022802079857642778072797591424987186672721038021921102270435432704466309076/789641993294867951541734501775203049416175036336228508443572711356607272580278488181357392830094550458573632220527534366098654885359760923555,-401835704998158728126175364045272058372590452647799689397238382739773827897645511076623854644993894322852843838865551532812500436819432480222/789641993294867951541734501775203049416175036336228508443572711356607272580278488181357392830094550458573632220527534366098654885359760923555,1},{22711451942361541131790605428299638982504349928138465227115376149048695973829531785510133154262148714754985588501545851255700762812203440936321/34519632530687395461925187436749905040946121451574672650907900267734427450506554424917097567025079638402105726241536515960899493743846127132402,26253715185367081640132148737086484034964129093778147401688335032263730770909325856858996340834048199893730692177425209451347486405849541756032/17259816265343697730962593718374952520473060725787336325453950133867213725253277212458548783512539819201052863120768257980449746871923063566201,53949106443244975700486417264945140053307344250671260600988666585769083073070721870529020153868038605560283320070964328827831498209777074827403/34519632530687395461925187436749905040946121451574672650907900267734427450506554424917097567025079638402105726241536515960899493743846127132402,-7497618753398064365426559119217088994719374765592780466374322743052210324160128638903242879600755597635070528800052196715149085062332614547580/17259816265343697730962593718374952520473060725787336325453950133867213725253277212458548783512539819201052863120768257980449746871923063566201,-1},{1545513404849823850720984709202143219741245895686003503387692813826329487774910162811102679183960878859313965872045138408664656476162512303133308/492415498959967968956325544090845078341906723766893653619746364007564482534552149223870174183160086552828604258062102134251501825557194635078275,-6540312454999774331288997491417865432870301207003782198330815062711421693971857824154233809974963553241290034645704619461093382858621955226664656/492415498959967968956325544090845078341906723766893653619746364007564482534552149223870174183160086552828604258062102134251501825557194635078275,4911251106538325018727485923544290955895085704646818710365067869225874594278475859518255107106322916894498361699188184946257408400715448687832658/492415498959967968956325544090845078341906723766893653619746364007564482534552149223870174183160086552828604258062102134251501825557194635078275,889271007730984650237919146356142045800116694856393654191907211498649360026063668570906609490305077791679324014510197615938795178870603421193208/492415498959967968956325544090845078341906723766893653619746364007564482534552149223870174183160086552828604258062102134251501825557194635078275,-1},{-2702239977019587622414371610736575863435358317301525101746444411812531390340477025024300331688681292515546159748210275598634325262599615691929/3727269565685659603899481171557790093191532138488401451138683605170775701265390956736270826904204529070680105657283093495106079813380958052268,214199707850861198959961814453094184027980342556573237138329674929225214313783620487369105395912369175497370773608353800438368273793418086112/931817391421414900974870292889447523297883034622100362784670901292693925316347739184067706726051132267670026414320773373776519953345239513067,336455001425844055532656220250562685361780927736375810511970978262942594966777786224045472853083004201951368888127869194012906656258840750122/931817391421414900974870292889447523297883034622100362784670901292693925316347739184067706726051132267670026414320773373776519953345239513067,899846560076745570463588433514035703743327579562863070613494764394612370700610269868376047063256950386264590141323097207893175491671040912911/931817391421414900974870292889447523297883034622100362784670901292693925316347739184067706726051132267670026414320773373776519953345239513067,-1},{-7668141462730279335999633433802224016620309038143603277607971915545088101224159408689357345685451970687402534308195716413733771589181687691312/23748572986495435766963906271781847263449936718418514442536430223291422138273659080367061045806050077719648540688612468176905977814200351418223,5766521532952464617154921090639706251066899278642947116962669431027585339874023173544662459311568373310226335074599175632436075673799564594839/7916190995498478588987968757260615754483312239472838147512143407763807379424553026789020348602016692573216180229537489392301992604733450472741,1707095252642460100398940163657827444780723824861114119693509137972353030988578567277164498972881225615575385155555561393496630955727375025799/2499849788052151133364621712819141817205256496675633099214361076135939172449858850564953794295373692391541951651432891387042734506757931728234,-5780914914050575003519322578229860735110568091186084680749587610128167629961925511747669459601294069369411965942879085191472322424186867539648/23748572986495435766963906271781847263449936718418514442536430223291422138273659080367061045806050077719648540688612468176905977814200351418223,1},{-169940321842266570859990221953265694860042317322607767320355545656510117643941573771748412169599701011424159090065799159857074349122874264087653/197353803561718391512988384368800759341404315537894956701067254202518023990360805236754185928720941883454553045170471439622881404040739904166486,40817239038375007064123824849970080151985646122444115125702492387098473168099041696898473340352488885687899638302292747646523638414007052247968/98676901780859195756494192184400379670702157768947478350533627101259011995180402618377092964360470941727276522585235719811440702020369952083243,38425594773658296921889474340871072671611578954358606469337377783990856295752320189695561664085348367738248770934422530807265926256974868607145/98676901780859195756494192184400379670702157768947478350533627101259011995180402618377092964360470941727276522585235719811440702020369952083243,120876650490333708949625090478352668662290480083653954258821478000244109677169549650219930842409506355779720068584085548636211151093042047316116/98676901780859195756494192184400379670702157768947478350533627101259011995180402618377092964360470941727276522585235719811440702020369952083243,-1},{2396340401036938205247063364658437960907991073723939936217378449241092570704636944641550942620192340631857741754009115177101582488173274164340516/1428314404256644629812469978475745856806290744482495515639272052071769591921633007252884588959456633043015979819290418697212453781363761055865791,-6708162719760182231740172806656929065512072060655520909071581568526264016080137669924776208563940307098001079768783502192088608538095804772361640/1428314404256644629812469978475745856806290744482495515639272052071769591921633007252884588959456633043015979819290418697212453781363761055865791,4728654103728739590890495504625182306332761692802310256174066310034342908252692098450221234295883803373270608325948735849236642225170764799385241/1428314404256644629812469978475745856806290744482495515639272052071769591921633007252884588959456633043015979819290418697212453781363761055865791,196505204658195761877483950705972420577354176452283867227054318687494756532808342309812160536116594803408603616119339288794482611765418850180792/1428314404256644629812469978475745856806290744482495515639272052071769591921633007252884588959456633043015979819290418697212453781363761055865791,-1},{1000600414510431957530559131492204504726856102725214895719862360523028244923661452078636514392083985862089285788278725852447392041386566905567704/2662772869363679527920070949198465832906029151904789703063047013300448460824684609835074836153744117452431067084322048278937728807399847613797099,-1370251030912410772783882338818099387397577799829913782954079906221681862049889552832230735604486574788163421962396643235890345094925959734137600/2662772869363679527920070949198465832906029151904789703063047013300448460824684609835074836153744117452431067084322048278937728807399847613797099,2095889746321262878350861623213033806835932063361702873804077597831064097072088171113205152969923275709235619978457301171220695730315138121150672/2662772869363679527920070949198465832906029151904789703063047013300448460824684609835074836153744117452431067084322048278937728807399847613797099,171834407297250733580185087911748036639896417991939768092424849476684496492234993233174073198545099435929957412524664452482897859517870588252720/156633698197863501642357114658733284288589950112046453121355706664732262401452035872651460950220242203084180416724826369349278165141167506693947,1},{-310037252631994005910001675804591530445449259960060343653567137396383898271849513229200962966780889312640885301396631095054871465416089039328/554742416065045422836054030511866133841172491592340584050347312434909590807263789538381489459793299069208928119959286840966127881742019856485,251696931947989349673187650031884504176107586666135630955151091190125518972861513489845381146419372544416727305449780659380065652025701040911/1109484832130090845672108061023732267682344983184681168100694624869819181614527579076762978919586598138417856239918573681932255763484039712970,266550067636080998497346476040579141302691436718101420075698137930896123185323969044997260245179380118889609521965962886861684156115552201543/2218969664260181691344216122047464535364689966369362336201389249739638363229055158153525957839173196276835712479837147363864511526968079425940,1229184873054856276738588612604460690244989178476261756233035263017367493418472551697993587595805775785465358761827634828630976623039577855963/2218969664260181691344216122047464535364689966369362336201389249739638363229055158153525957839173196276835712479837147363864511526968079425940,-1},{31945563723063070290723384686265687010079209700052249151684428455276839672544032712238236075868955839428062865165825151960390405480676529619948/35689155086554299459162800877000775161006032597366071011307919102270240008163432132583422194139866498537588919029280264411308309969668711946777,-70925245597939621627505286189518797778729243415656389690723772294006917059446259284422420725043188151971528446800815837918377036033640350403248/107067465259662898377488402631002325483018097792098213033923757306810720024490296397750266582419599495612766757087840793233924929909006135840331,-4802356703338679130836140874034950459074562942196052030937167243477634080524370788309828896935820801064909682556715368824380335994899010820066/9733405932696627125226218421000211407547099799281655730356705209710065456771845127068206052947236317782978796098894617566720448173546012349121,-21297163842565306638945341229101473469703860448417038101047306136379656791553652231460171265769207278746338270943597249061081083638599521587848/35689155086554299459162800877000775161006032597366071011307919102270240008163432132583422194139866498537588919029280264411308309969668711946777,1},{947553050935707798904208830689909587495444282070263971326179815593680925410677539625173748952907479794140793436056944291948327487091773464894036/348548912253811914401410021601008083777778986740523603670506673391070841897868059681100191068388680333793920334694331557640409618586308377665825,-5626762930579334821303487576494623520406400669699952913430082303307894120128252771176242694182924904249168208156173502175273258057761421450762912/348548912253811914401410021601008083777778986740523603670506673391070841897868059681100191068388680333793920334694331557640409618586308377665825,4117379055914590753649117610470657305540843560134786908190513492158026127991047189582625956680459067330308389849077068594595146945947372570747276/348548912253811914401410021601008083777778986740523603670506673391070841897868059681100191068388680333793920334694331557640409618586308377665825,933877752239028007566765262838427137957485140755190418248308290656667569924067660008457663927654003440287022256398580009948936061384629152248616/348548912253811914401410021601008083777778986740523603670506673391070841897868059681100191068388680333793920334694331557640409618586308377665825,1},{-5118853962979511230116088639396002563000568961145450474173582239954448875720016890883396935492363942633269663276948158052327490122002215304947/10337300305818650784081427854159003646513574863220483087334865147102185736137310034157158560717710919541291329615625835516546063273661834940020,-499693794520784938302155508022591578276838789385766862952176456051801089626426137174993009519844020542430785456816277357723004942906358280496/2584325076454662696020356963539750911628393715805120771833716286775546434034327508539289640179427729885322832403906458879136515818415458735005,1579961987132048648567382996559135619155591226395834111961705911608332032598243484414203517798958174004798840366078797459420614693981521547632/2584325076454662696020356963539750911628393715805120771833716286775546434034327508539289640179427729885322832403906458879136515818415458735005,5083724953162014138323492733133440915856635685504477144460925908903250526833900869472588829415077922435528255771030613119332750230920478562213/5168650152909325392040713927079501823256787431610241543667432573551092868068655017078579280358855459770645664807812917758273031636830917470010,1},{-5526241048882104028701779963022628873579321747372721629708567147703186061269630254714142862627777478798681401633591541255248211305692663625522/8019420122058337948136515527925156561603438703881319761451739875062282176088786987377399285905181299512721584658874029890406227390879551004889,3617761154623412973764963396411368565612070764959549255743825438479660349652199231165087471028374504981140681570354193208543747188542169869353/8019420122058337948136515527925156561603438703881319761451739875062282176088786987377399285905181299512721584658874029890406227390879551004889,418220850216912996909952344032359286789863586664563322831696944038796334440683129963986014931477822251198038019034061817471927138290329315883/2291262892016667985181861579407187589029553915394662788986211392874937764596796282107828367401480371289349024188249722825830350683108443144254,771066776382453605391910107333624459090150353117642651640581902744006778229560017750570759884391019742644195732308379507172619309383696531622/1145631446008333992590930789703593794514776957697331394493105696437468882298398141053914183700740185644674512094124861412915175341554221572127,-1},{-9449429115972662404504582762566367802394590532374639296357352009174402077754280138179535086911077930906295027910720494142268617449541727910848/10340931043479943880131990007637984377340624424653639477704948363373283248182699977881021687622063414794729227348076373634807223227626489206271,1926921603805647455354921660829420838050686900188959041376355677599197232177446164049052659324641213013929010251779076579178027793503445782101/10340931043479943880131990007637984377340624424653639477704948363373283248182699977881021687622063414794729227348076373634807223227626489206271,-18609242108536213232194792477290748359351817344311202818424506357775437778390683080647472079917946833378451154217360007835790119513247270673551/20681862086959887760263980015275968754681248849307278955409896726746566496365399955762043375244126829589458454696152747269614446455252978412542,786987137672903968632657762188742629169457304090323135484880464891243593262888668452638601846236710702303113202645441639144423616093427741566/10340931043479943880131990007637984377340624424653639477704948363373283248182699977881021687622063414794729227348076373634807223227626489206271,-1},{192517943579598757413240910423579149689944930764295228171121641787554778890507448849652317243927008364928400431165941910179497913157762920816926/76574100460793876292942042937508238439628661685911458970181662006363183372433109720095295817858868289562842009030427464372677342336856343765271,4236573597444789847786897378210601339736336297627130331043419101649688645186934474202494536383916686920332236585164449329351544917374476349552/4504358850634933899584826055147543437625215393288909351187156588609599021907829983535017401050521664091931882884142792021922196608050373162663,259911807151958769326295753279701713613500648560027236378566083888273421017107258870012994072987205332942191610811648414978398070781214016810640/76574100460793876292942042937508238439628661685911458970181662006363183372433109720095295817858868289562842009030427464372677342336856343765271,-20959218973969984883471385436915812025768857057247207222576815328635620412589791965784118523205461179988822839598701718670681274844999080445956/76574100460793876292942042937508238439628661685911458970181662006363183372433109720095295817858868289562842009030427464372677342336856343765271,1},{-7915769771917219752941471062128716543437528847858597010090180482905017833203004612964012155643527207991363944598276591743535210663347558392873/11335376431563177932856715577655993017742649067713655251160520139143150515184019339419757196490667105010911531838851089123409232683900055281348,312161891207925485272190488832300320750428082175174100826408453478794567274158155916740310840917468003910637476844198645335227649929171918080/2833844107890794483214178894413998254435662266928413812790130034785787628796004834854939299122666776252727882959712772280852308170975013820337,875430041760666748523874848447712703242715152062687902236992624339262723527405781171042216977947584045965531331799692576662596056601206354019/2833844107890794483214178894413998254435662266928413812790130034785787628796004834854939299122666776252727882959712772280852308170975013820337,3138406338215345411559753595014664423759807345380618596374640763106129195747147378414912462665608332184468688171517813454910459444372702426959/2833844107890794483214178894413998254435662266928413812790130034785787628796004834854939299122666776252727882959712772280852308170975013820337,-1},{-3762024606223050732991555692794788865759323142213227926263505547493634819109064776205120265436352559697148094608960030231703835236626604218384/265047315892921828715160415683047020228293098068550332274547945517719940045105323000701014806367740991472309464409423752504414946316781485321,-3260392261105670003407998234534465447670170850557783054250062060992908277470230914368205642865887638134477341306380202029016526541934107052680/265047315892921828715160415683047020228293098068550332274547945517719940045105323000701014806367740991472309464409423752504414946316781485321,-1365592589748528159791678460193340442515026276708426072975418752917466160850208963013437103512413062639322612032867536209596951182573579034084/265047315892921828715160415683047020228293098068550332274547945517719940045105323000701014806367740991472309464409423752504414946316781485321,1386277187972176793956464084779101620468464149342267349087855875880521365054668503455182622326734205635103447779255871640680679802808555006267/88349105297640609571720138561015673409431032689516777424849315172573313348368441000233671602122580330490769821469807917501471648772260495107,1},{-85695631166184241421498437167979557298329196005330948667991059220505988519089520574374483318006800889420864434201698770507551287250997134004900/75786552614833082854924718216541018151653955889645010715343125118988476428112544325415955359040502755124264083011533607183220380695160959652623,-83908374655623619477098417680655801834776043505446105395266731414367873951514708585148920817543101940228708237763262193880425917264256770037018/75786552614833082854924718216541018151653955889645010715343125118988476428112544325415955359040502755124264083011533607183220380695160959652623,4764561009519785437827514750792269162829059638459033422055397697155762667027374637283725119179019176203190714445039074865661616016829755508120/75786552614833082854924718216541018151653955889645010715343125118988476428112544325415955359040502755124264083011533607183220380695160959652623,-85970119137753438896070788535302207834896732377265768400238275822211767028100406608556636687392926672146029618618645392032761566825686195204200/75786552614833082854924718216541018151653955889645010715343125118988476428112544325415955359040502755124264083011533607183220380695160959652623,1},{391909300579592120120239849674690346382614321089027160259532812487885785974721804336971881707209714532686582081834779814334591838275595062924/394667622513195057520770139449016513934908754000313813501846627550929460528077865049352627502563966900239690184614160772960493567755425671917,1430001747560500234577241646488288670605249226900699547687144373026643439514389992278618122447725563234804241738492285029667185933614101510863/789335245026390115041540278898033027869817508000627627003693255101858921056155730098705255005127933800479380369228321545920987135510851343834,986576963155994888702096736620165227976168944749012757864750642210061837424598342390699342673225478441785957959916220552172901477503203667315/1578670490052780230083080557796066055739635016001255254007386510203717842112311460197410510010255867600958760738456643091841974271021702687668,9026389878488006904908466414454491373487281528610879409230659580468571725959159707594655251498586434119996163759463175147491585993994606448033/44202773721477846442326255618289849560709780448035147112206822285704099579144720885527494280287164292826845300676786006571575279588607675254704,-1},{57436867107997573495280339511627287770803562286253313174835240622620682350002545531114142681698634214107100075375464615810221667680847367400/173809574893546674761193708823616923889070424604645243684657777460822257064628689661683770357127853034055638274667313008766000980302305651933,-98155614708666404235990364242397588340128078669887749573923207951479243828663747553356896346611475880757060148663955518354647909666192821880/521428724680640024283581126470850771667211273813935731053973332382466771193886068985051311071383559102166914824001939026298002940906916955799,-101595793481032064739928182041509412674807190053821869503391075976842373949712163266388759187922359709174044073768845459669768199249052486784/521428724680640024283581126470850771667211273813935731053973332382466771193886068985051311071383559102166914824001939026298002940906916955799,109136830496370684289667851281263635852634948994235392905289247412021676077666050302083115607899205171821724967137337912450513315202469493464/521428724680640024283581126470850771667211273813935731053973332382466771193886068985051311071383559102166914824001939026298002940906916955799,1},{249883069583008120940618240988313991464208452434071760571880896992037356141284791288667989680922721371602813813881385499052934408068548512920/141087358699654467563152403999967194717972912072563361278119200304595568828230631216472082577775956155712670971803499385021790860868728384733,156614681985913451644767853824236993354761739025803179133874924636559175460559934333426351436457520119275324164753180133679849639689466464984/141087358699654467563152403999967194717972912072563361278119200304595568828230631216472082577775956155712670971803499385021790860868728384733,-1391465027860744361201343719492079550017091749878085078828858837457440524470458438225471122068144369180153115844137021513726349653915407190734/987611510897581272942066827999770363025810384507943528946834402132168981797614418515304578044431693089988696802624495695152536026081098693131,-1159305888638192585150883579679952998544262771663289773254239488487962744538090091429409585171402356877352994171390321744281431252336827909090/987611510897581272942066827999770363025810384507943528946834402132168981797614418515304578044431693089988696802624495695152536026081098693131,-1},{-111838785036864199081745389496442167317475891958266567089996438496679853007644470219436852489361231878934388144528468453941619535490254426928/579906164221101647300358782163391959527196538771188945108889250573606233203699943773678333296315738215626048516599565086049598633304960969745,-364462428286502873511448797780677122800320330186802185961655013391369446297703711393233201103634525042116870976917666298283382583985610409128/193302054740367215766786260721130653175732179590396315036296416857868744401233314591226111098771912738542016172199855028683199544434986989915,-1926701508695027842688604709866587303370981757102331561396110101451380230021266250875917307448641755673161795468428763500044301303677882981744/579906164221101647300358782163391959527196538771188945108889250573606233203699943773678333296315738215626048516599565086049598633304960969745,4809790247791128301312899416835953741755712422783039139337331413457160851297423466066940715705299743920349295999387299101978255518179803043684/579906164221101647300358782163391959527196538771188945108889250573606233203699943773678333296315738215626048516599565086049598633304960969745,-1},{-9035602222263864837890395816076955956631769563152680759772216652150505345638866617452189843164950446695676210608324903791246532597421731405099668/9165315591078035744948412569654375772069906586903093125611930956439474093685359934702287885013928031959689502605725238934265669926358478338326475,-4744727372944703817371176346609454727213960079335057110279379689554943322156977595503133194075581964018386595886503822500050995060028102298870528/1833063118215607148989682513930875154413981317380618625122386191287894818737071986940457577002785606391937900521145047786853133985271695667665295,6911781569002264699925911977481965827793686462679970852203213901840158726531300753355413216294893754742359289040947647356564647954695084514188916/9165315591078035744948412569654375772069906586903093125611930956439474093685359934702287885013928031959689502605725238934265669926358478338326475,11660436785296381259833267536461933517045244208534506592915448207441612108208216916092115616460088215830778569529311405219927466422258631565815192/9165315591078035744948412569654375772069906586903093125611930956439474093685359934702287885013928031959689502605725238934265669926358478338326475,1},{11313422905855691689575929503162074375168113045834773591930258954161248684141103648193208197438606122353916691359999940500857823282219538622279/4380323884553554320598576422254849001366925990587098218227427265184785101225268607864960458607089877428584861313683878061890895827164187143496,832396059852856325970557748844887629230417646508965570611720596241681652119166916733556784746556703582429314286007080654342271499000725383552/547540485569194290074822052781856125170865748823387277278428408148098137653158575983120057325886234678573107664210484757736361978395523392937,6659361729274503568353485343011732561172328222565158421123336804161057455357869134711566976538753265292108468659280839700520213484348386866175/4380323884553554320598576422254849001366925990587098218227427265184785101225268607864960458607089877428584861313683878061890895827164187143496,140156376532505196913239164355276087816810771068644270826393551031726409073076622429082972666347224907828805864871247184628106388137066824203/365026990379462860049881368521237416780577165882258184852285605432065425102105717322080038217257489785715405109473656505157574652263682261958,-1},{6356719764657979675507651502012404266514320973082911304833180155374112652496170410688418409482891659342711584800778571354694406640477298743216/3053376115081916554211431469403406354399698751487284752628228171811940654227654968341561723941882412565128602404064836447032713240312559861397,526457784936826146755448074859931985483992822421121627120849204164473196007412871813867479010471876252750120752351497072260247614638822901712/3053376115081916554211431469403406354399698751487284752628228171811940654227654968341561723941882412565128602404064836447032713240312559861397,2147455866097577346583956194749153753012891012511059572243577882471617259034896686380070361614712523707769127006598643046495843495142956091554/3053376115081916554211431469403406354399698751487284752628228171811940654227654968341561723941882412565128602404064836447032713240312559861397,-6635499064728070796866435006959241636033937826567770686844024202537355329681156505550934722060198945739795751375722749472482321368126566250368/3053376115081916554211431469403406354399698751487284752628228171811940654227654968341561723941882412565128602404064836447032713240312559861397,1},{18310316399163725945534887690700076722397661822014791492706892791304294013638555723016480996091426475377680543733303454430067505772077273732849/52054683181933229465941596825756602566278511998167909017730447722124437142253875116318651778608867415181477901885663827601675936876684597163816,-2175217423752523449209879556164101486430852020586749091594801077799589712358375725111072624309725755332505254812848473113321533801543486783552/6506835397741653683242699603219575320784813999770988627216305965265554642781734389539831472326108426897684737735707978450209492109585574645477,6967685141871662922879053539592436740398600753980861684704191011013172382626521959873710600629873043438056411677275683433333180139645272575069/13013670795483307366485399206439150641569627999541977254432611930531109285563468779079662944652216853795369475471415956900418984219171149290954,9284703855327099856751492738678300896918145463812513332021983328971481943738549943573377171494197807569891141087627784256226418692774691732907/13013670795483307366485399206439150641569627999541977254432611930531109285563468779079662944652216853795369475471415956900418984219171149290954,-1},{-2241173893791944450697956721673896499027689457924548549460343256318527260407105167736782301196887070158259947114171319534306416910720692422308/5478863323564724101066768293383170369418139955527228729013301560715340296806012729425778602358596285931307604306636198353746987882383995062137,199526085222849755726638633036604117705757240539746519633403336202893189735858560094185181254698935949371931730453279043722398628706190652408/5478863323564724101066768293383170369418139955527228729013301560715340296806012729425778602358596285931307604306636198353746987882383995062137,-3855691767086405828077755630313734042682638733014831109653286010309072453119573175062969331840137660758078629910416407088741909826199671372730/5478863323564724101066768293383170369418139955527228729013301560715340296806012729425778602358596285931307604306636198353746987882383995062137,-1961447515842380632388295516294555422712847214459313689881457406828757550375236069483324640363730199365166064512113203229798659724892998121048/5478863323564724101066768293383170369418139955527228729013301560715340296806012729425778602358596285931307604306636198353746987882383995062137,1},{-719352783728172611618978151196460906170163719145111629054815451425396350386383041430715544690962478586846741978249654174876132650678355591824/134723109929459273113577113996602749191911422294378016836902623495843351901058086319457667542340259423287465851133555388818672520318053270289,87059858082896182613350841265656253986546886353125062030393067355147271481169664248023000473090213996744264015928174546269177824702886505827539/11990356783721875307108363145697644678080116584199643498484333491130058319194169682431732411268283088672584460750886429604861854308306741055721,27358495859184319999282446037025135503332989053237054960238515091166083885825760988510210489020392297431236138398776339657343434874731056235329/23980713567443750614216726291395289356160233168399286996968666982260116638388339364863464822536566177345168921501772859209723708616613482111442,-73180500000266153844158035799411387376323138919108715903866589854166665264869744314069896506240248872762585432986959570696233309440824883160632/11990356783721875307108363145697644678080116584199643498484333491130058319194169682431732411268283088672584460750886429604861854308306741055721,1},{-1642527888451131096001773525199662775960803716360207749351241405404263230163419424185029469162435428117656791118984311224711079246407170276384/2228113411904030383917445252722099809308007075237810180586833643742518672327774254819170962772995760630731333685104651909587160630456042645911,2280366573278576480331090942185978505141476146502992379423293963411020273378066266488943399419263393601509519570623529224124857003554652333032/2228113411904030383917445252722099809308007075237810180586833643742518672327774254819170962772995760630731333685104651909587160630456042645911,-1392684665310372072315226522108935888113023688584259454661538903563412702141435463613734620292703867415822974402376581034925613061853280591012/2228113411904030383917445252722099809308007075237810180586833643742518672327774254819170962772995760630731333685104651909587160630456042645911,1045937826961457549447271575370093308954529399548869182298282050333089114910531876114325435249784174725591382047625214497770257638576068304016/2228113411904030383917445252722099809308007075237810180586833643742518672327774254819170962772995760630731333685104651909587160630456042645911,1},{-10919081748712364838591786855712463674245409584989828693298596456877777670468972040047338088660735254856508683447969345419531717305437817488/33132970281959442169870375498407560801180817910096182777906659854476664443281223810648659495458308621327181021584676272756099880407505995099,-34898793087822431506408992573139563897374984879737960316884696965691943595744147737760266212456946633569289268213383747113611995841737276389/33132970281959442169870375498407560801180817910096182777906659854476664443281223810648659495458308621327181021584676272756099880407505995099,-8472464607111238676097613725371832790340255504336852005383752729017724704616616080930342158069724026125420384040620867450818324145569077359/22088646854639628113246916998938373867453878606730788518604439902984442962187482540432439663638872414218120681056450848504066586938337330066,8381284638087402062028126439765044775783873670237293878630949113039651235482572610524689764305386640228654637184557143525505005310491142279/11044323427319814056623458499469186933726939303365394259302219951492221481093741270216219831819436207109060340528225424252033293469168665033,-1},{-359675590205501724882489980419286727130502277501906227639456925509963181801925036866973238317455385563372974032880710137571638698818714868631/3207478446718788228974902851019936784007805820864912714461582154913266743498045969948138398444530403018110437896850369815635769959046109232341,5528003882818630410777014493640217110607411942624049977850737883483430774817880591991759736635380542446978640169649156717931987836164851844068/3207478446718788228974902851019936784007805820864912714461582154913266743498045969948138398444530403018110437896850369815635769959046109232341,-202693195103465646844818289586248376606345954770416373945201584835329038988739235730218781358459834309179933139627666673480500595009749519319/3207478446718788228974902851019936784007805820864912714461582154913266743498045969948138398444530403018110437896850369815635769959046109232341,-498497611567448711993429670262252727500314592531212063211085092034404069255405369497478167128992587667146762955499913037315205097182725390302/3207478446718788228974902851019936784007805820864912714461582154913266743498045969948138398444530403018110437896850369815635769959046109232341,1},{-1422873105228862882696076699534964727896699617177294166097717823476750314458009251624422485956790705217912146004378846608567090039318904111136/260348647551936398850271414527185830758266914002035479549752493006312907424731404589711714858090102191290479452145911004095015530490806409901,1068360716546528898344979982637052535180982520120520621902797278034598863100192263425500283489554189525401260107020872215510656430247129170151/260348647551936398850271414527185830758266914002035479549752493006312907424731404589711714858090102191290479452145911004095015530490806409901,-14387760284746560084753214936148063359451379273752141525224897305739418797911936274019581312954056974361503547609161424931833742425234187055621/2082789180415491190802171316217486646066135312016283836398019944050503259397851236717693718864720817530323835617167288032760124243926451279208,747153681286492298652749169144971154194282312465312902020845111200997057945939304833242667459191277845031954668121114543162090476728379973018/260348647551936398850271414527185830758266914002035479549752493006312907424731404589711714858090102191290479452145911004095015530490806409901,-1},{5021755019730617509627013976048558689675442294163309597504272300237885721428451263784923437735623382024903549319336200919745274568008469087/8050352030576906936469087590053455602875937541420970150585192136771944563457554930870062868279276099416503904824218337589907757470426632936,14296883802819896599706435877045278009884586414824037980177061568962183624173109557007478442449129957587884030200818770356836561185602491995/12075528045865360404703631385080183404313906312131455225877788205157916845186332396305094302418914149124755857236327506384861636205639949404,-12887764385926620167805437855278853726844824377916847141572719068002867493076530280389295952991440790137475966691636489969814742470968452919/12075528045865360404703631385080183404313906312131455225877788205157916845186332396305094302418914149124755857236327506384861636205639949404,5806332831795540895421721234377669017602649454327224543041819783755959446362998673024973489194172805977790440301253392480271343726577060511/4025176015288453468234543795026727801437968770710485075292596068385972281728777465435031434139638049708251952412109168794953878735213316468,-1},{38784114917358011320780844847080674273532716677875315951539695862868144055593491322529527758498978497201929602560341950176966523062898603027716/14801342230804572059370698525709259679757045447297359146482518077379048585274024624886704552856129823920053389887379967188420395038286011246289,-2581148261135241251350171980417412552422890342859871720927756546251989448611788763612733041730745517922453148152818072389144196551446881020944/14801342230804572059370698525709259679757045447297359146482518077379048585274024624886704552856129823920053389887379967188420395038286011246289,11174625728337709159461640231288648704113859391819146471878828483174344315362465664042167481134489204782306175735719023862124286066787219095288/14801342230804572059370698525709259679757045447297359146482518077379048585274024624886704552856129823920053389887379967188420395038286011246289,-19790774091355672951235747663568660449493759146504728644749208533581378387266702247318542745688241625122209844222756465059936105977568686126764/14801342230804572059370698525709259679757045447297359146482518077379048585274024624886704552856129823920053389887379967188420395038286011246289,-1},{-221741045442238748199527449646790343805290892875512502956776837439963085277053284050972181200936976587727310692924684454972349154719409742674/1758068275850316212672635515044464358007300561992199668785901250981426329982963160924291940588722663784808793631814863266638975750219863120623,435841849211157865979078183395322203848831881832948106568827371929663718637795870217825638356766838794980379015424930351334411537828517280832/1758068275850316212672635515044464358007300561992199668785901250981426329982963160924291940588722663784808793631814863266638975750219863120623,1038865094663564920424892154270905946589988995821139514105013972949062761570473449587166696319084395737130170362978531735882122419977725541626/1758068275850316212672635515044464358007300561992199668785901250981426329982963160924291940588722663784808793631814863266638975750219863120623,559857042989382033542554228986267057015914821594279710590917439487249405449744808693221491055528764322696933793149447496827545111920834236396/1758068275850316212672635515044464358007300561992199668785901250981426329982963160924291940588722663784808793631814863266638975750219863120623,-1},{-3060867457398506634716696179023027120067011237615893896279348309017574554790618187587415810629744432444110813294567715425976809805988266590116/965183691815485313522491887133810687798365914657411560883945233788070338978339463266219878674537185162591489649379025523161755632100133845745,-1405457053657554153221753317680927339394431405508390230675962274858844703218548185570600624953804048778566146042437261868638510447774276829128/321727897271828437840830629044603562599455304885803853627981744596023446326113154422073292891512395054197163216459675174387251877366711281915,2102776481534412808462360117808959088253106362242327463086883841611604877473132046483770615482790341524549113699605428588263813707526703474348/965183691815485313522491887133810687798365914657411560883945233788070338978339463266219878674537185162591489649379025523161755632100133845745,-155652336470131464876715187563257563293384242930569293032406675613060944775299606123968726872120199370919849056583297991779420063243172868814/193036738363097062704498377426762137559673182931482312176789046757614067795667892653243975734907437032518297929875805104632351126420026769149,-1},{-8628861361405309815158613514486753979915770329432555584378652871421390555642317599524041494685794455531708369442611303257779995156944878170396/5027334716563152475013147425092431085552907744257449543761725814108442929107853100997019503797395844529125953294531163200490420954652416081103,-16685940166421543585988362987607506586427728832928509636483128024726873588723478230006186339685513866028116792987461777844410034351793716508558/5027334716563152475013147425092431085552907744257449543761725814108442929107853100997019503797395844529125953294531163200490420954652416081103,-2661455960292526175094162436048917500220209791871813337524162025475328825577831346902268833834864565810295492659096903943686157653326585222992/1675778238854384158337715808364143695184302581419149847920575271369480976369284366999006501265798614843041984431510387733496806984884138693701,5508904518832155420318103350217802405189197208287246090269154435884025843998249240293054756574860291283574286771948651695675750727052784486963/5027334716563152475013147425092431085552907744257449543761725814108442929107853100997019503797395844529125953294531163200490420954652416081103,-1},{-150738539083035908321597544631568035964635333043019705968302894577806792915386600426873470325727348347515957713770108556812650881117103660011/7708768046574399980285300879868076605551270437924094327107394593940654800103822442660828557346086180499387686793215957295215990000867115246372,179976448953092132453284597583549789076384018777005412167731531769524694361250975163834462822244171307786648679792546598226771162867688529104/642397337214533331690441739989006383795939203160341193925616216161721233341985203555069046445507181708282307232767996441267999166738926270531,3060874484269143648492578054274417616047396461716942549189338687873219935158800108621503128848264485029437568459857988119964994917621933491439/7708768046574399980285300879868076605551270437924094327107394593940654800103822442660828557346086180499387686793215957295215990000867115246372,1601747917961963023947459176184588529616729193315292960513568169320694346056512883270734665593418292431331830530944132241463724881098954844297/3854384023287199990142650439934038302775635218962047163553697296970327400051911221330414278673043090249693843396607978647607995000433557623186,-1},{16110963373420360633633927101759870845942103161189798027014634079979434881842820347104669949750648130545024947784378135953937693365832951523455/4939862420347454522241350803986563367439587563144444337009169626433169435801780594796237869894090139619082054265265357467051078346800710368664,72095141054129858431786159498675889382591420459089382011753946468949362690213700973471807278658075648584534105278102918998906603939349636782953/4939862420347454522241350803986563367439587563144444337009169626433169435801780594796237869894090139619082054265265357467051078346800710368664,9233089383149244413459180077448127954905709817079088349149857782662409604692573824945724470652494035534345953788237307053885497312467617557803/4939862420347454522241350803986563367439587563144444337009169626433169435801780594796237869894090139619082054265265357467051078346800710368664,43906710319345196341887732363189017228673292590355685328554648542579907237198410637991042302019435305018391352513173359203260651325178695508413/9879724840694909044482701607973126734879175126288888674018339252866338871603561189592475739788180279238164108530530714934102156693601420737328,1},{25985001607015142595669280898223625062536602021370436553530571695182372054044905793421299673264270819635954351715731798613641824691534473114490/30981040996207307255548020990879200582289643264104114287603461654836679368583079470571930199317211289865232586937264702808647962687199926835149,90493857627740722191993885945616958397874916445238280298269455754386399642572300934637212690540890462041734145311699217389018445144746639085432/154905204981036536277740104954396002911448216320520571438017308274183396842915397352859650996586056449326162934686323514043239813435999634175745,274902808780680191273957483089577763240077809995045472470706076259207840379851800866575573891982595518915525855413033458431150470579776161471976/154905204981036536277740104954396002911448216320520571438017308274183396842915397352859650996586056449326162934686323514043239813435999634175745,57838105752921719125403057806389573018368949852473533179405959317941768449142934350719116381318675597915557688631981256826186224893618417823732/154905204981036536277740104954396002911448216320520571438017308274183396842915397352859650996586056449326162934686323514043239813435999634175745,1},{-1036651282955134031430865230732173251636177031864078664617598251990662875526020122250511594775799184888831032460191867401506492201211612838201/1501022744147355958387138021979677991125631918887719543846622337292854319426045806886730790473872658692469669722326351363062648240158729421700,575607193848339841076636686801879771982087649801250541132788201044508007294465007980619761691443898653708227807052427807859182839444123488011/1501022744147355958387138021979677991125631918887719543846622337292854319426045806886730790473872658692469669722326351363062648240158729421700,28693224130754925757517621858282937551895651877620324326852247062048260786537024444943540889447315604026532199100185319216830192585661699685/120081819531788476670971041758374239290050553511017563507729786983428345554083664550938463237909812695397573577786108109045011859212698353736,2071839055811958636946310776224608128111629691035180658340207831078690713758482185377590872006317959438367574973588535649224011163346722728687/3002045488294711916774276043959355982251263837775439087693244674585708638852091613773461580947745317384939339444652702726125296480317458843400,-1},{-229031971962298852995202316006275093698441732906421291180203140572440681679268244327439029177390569822212793186965860964451743134922259541781/163204406339019794572831976859650864194607285124707986226941340437903320846303952821060077032287980967446276251565186824500567238600240742970,-407963553615455159654561716575069384697294727652323152759765553183037517255109839204716763013821467573779186420440107044643065623039370179049/652817625356079178291327907438603456778429140498831944907765361751613283385215811284240308129151923869785105006260747298002268954400962971880,-64897547808837144851858001739280141427120678428404971559762690051991686308099081960234104406101281646355071667227422992870555463037242810549/81602203169509897286415988429825432097303642562353993113470670218951660423151976410530038516143990483723138125782593412250283619300120371485,-38921982456519482343493353355911183623177179765667339617097449471557228561885304377341931517930408545280668816418456652033535856398226850577/54401468779673264857610658953216954731535761708235995408980446812634440282101317607020025677429326989148758750521728941500189079533413580990,1},{158936636464161854640268779248469143206192680356267870632783433158486584423030033829505763536164237124074268787488330363873429249554427132573068/55675732453231356987444442620203107048540138047052649204513111689081911846792617425402303300725287365996793003541214162180191644259076784404573,13412906647785732539526853535569649911707849134014336329821150355678964313015122649155151453513388483129351834670898382225176249022776195877075/55675732453231356987444442620203107048540138047052649204513111689081911846792617425402303300725287365996793003541214162180191644259076784404573,-11630286806928406292660702679784344891812843189155838940483828893463301725658156231259331290355492892139784223573590361658552606316565711197156/55675732453231356987444442620203107048540138047052649204513111689081911846792617425402303300725287365996793003541214162180191644259076784404573,-14180952204951192089846399554907469300454546221810909910497913567566259648503378363496949500836635261838464556020967337093599591677622950462790/55675732453231356987444442620203107048540138047052649204513111689081911846792617425402303300725287365996793003541214162180191644259076784404573,1},{13244145960416695362318644718960913908245283346574940758519255677857473977444512592188040426441039909162717763277384219254497026430410560451740/10578888287074186213730498411982835457323543610801917642894951623144629611599018240364611519165964997328766644688651257693895276345203621555797,-12884086817121578371087319388551815022606883487906901386057822211806203334624337492403994934543212747584462514160171959438032686419342975128832/10578888287074186213730498411982835457323543610801917642894951623144629611599018240364611519165964997328766644688651257693895276345203621555797,-1809239316470319663841549218635591975601931944373125508312636688998435359757162859446552653923572843577486124293309944706925438107258721655508/10578888287074186213730498411982835457323543610801917642894951623144629611599018240364611519165964997328766644688651257693895276345203621555797,13020700719193410483300207886695193253096558854408914578081853959110256870881309535145198852207485155526515519725625661819539291563697634079297/21157776574148372427460996823965670914647087221603835285789903246289259223198036480729223038331929994657533289377302515387790552690407243111594,-1},{-45116349780488935755461431939557634090425845079428914470306355466204663231511422409329579165410932575820257395185525432191880529770771766174/3956789468753212930783034440374065306891115657790181413607650172421951293410997981352915029142977322124607786899136618515741527969989878185,-20094127071924334833558413915479000520356832558167263715539474953622075163847495689093859593985320749374201982414406664042491028209169671174/3956789468753212930783034440374065306891115657790181413607650172421951293410997981352915029142977322124607786899136618515741527969989878185,-79680191203101475270102984806949947834029530759799546240731714601851565785302837481898418841399910639625849856130884118045617111943429588513/7913578937506425861566068880748130613782231315580362827215300344843902586821995962705830058285954644249215573798273237031483055939979756370,23979141911546043926056327039272901836566383507490058900648607422658461609760852753813680808400358318288054719186009106280057852708655358766/3956789468753212930783034440374065306891115657790181413607650172421951293410997981352915029142977322124607786899136618515741527969989878185,1},{15836069533997721377847690951664153500598828130491308299319735090426277516553846314541988900872753944574881866434670175599110710131228479976169/6829406250485471906563035622415788822427956802895747133760141403347390360566136456181544322775981494093398250554565961448758867545185871502626,10802285526308671256337942983892972346779021369347997328037934707848659093699391957447682982459174127907511038103471459233936330964069765099648/3414703125242735953281517811207894411213978401447873566880070701673695180283068228090772161387990747046699125277282980724379433772592935751313,21185096647095576971219241262029547139105032647177972647537507389929886597042442979371282728394820814757830774753745496572924826942313440890785/6829406250485471906563035622415788822427956802895747133760141403347390360566136456181544322775981494093398250554565961448758867545185871502626,8953423259362134912779450299306766583167131075187096817095310993018638367960688343590192759909339303674095097668772372964046609734393401319204/10244109375728207859844553433623683233641935204343620700640212105021085540849204684272316484163972241140097375831848942173138301317778807253939,-1},{6624319098148169728486987394090540423341248588550062286898282696305204313591501042245448457279849366493356201497792046644638778915431590319768/760279213530018584095295081082586197132947404741448355044634198045028123997159686747194894889450298156973923151558860253638947119790430253739,-3634077730060354788151340438810005890299441566021760618320814268721117888282474492977689563854143923139433943035270861867815072563074538078799/760279213530018584095295081082586197132947404741448355044634198045028123997159686747194894889450298156973923151558860253638947119790430253739,-2910585418254197616748685351053709973421320968710504943858541704967073689776098455522757524141525599235759987200269098987348019869768765064928/760279213530018584095295081082586197132947404741448355044634198045028123997159686747194894889450298156973923151558860253638947119790430253739,-1281705424042915233083760734929855634829357893540806977392855057413907924566744584947364843389715014310198103744105603706842591435423355573986/760279213530018584095295081082586197132947404741448355044634198045028123997159686747194894889450298156973923151558860253638947119790430253739,-1},{-102489038012864606882413995693067118925549953876265310920384483465711181911930615455575788556737584857237398488861524520962766093925151692816/173048374749501236113484940241840077091347179275094948466837131869303430764738830354930306053079333053056286099955181273816234045787265092845,461235947787733361314990121444107867407353640748303672934074676486228863897902519238459627302918486821375729340357814219076129190311523962376/1903532122244513597248334342660240848004818972026044433135208450562337738412127133904233366583872663583619147099506994011978574503659916021295,202060537642080233064205271419880891385460968856003030138046867251636641486859619701546005270095265495424723699146240493338532037850686144234/1903532122244513597248334342660240848004818972026044433135208450562337738412127133904233366583872663583619147099506994011978574503659916021295,1980582216883294943629457514666266073501845812680964657322866066840376085723965831122545901158546997532725057394782293858504482024513692426133/3807064244489027194496668685320481696009637944052088866270416901124675476824254267808466733167745327167238294199013988023957149007319832042590,-1},{-1225259097096613018117508313326813957111317331043892669022286861042377882090156112785635307600702741011973639778049902732215623837239935324208/2308994181032354915809986676940567653450603514916531816767728098592639580007239571759483756434738759034259206821589096026287563669815517325187,-2788409816687388288476459879125538218110803216525881038166980117012849696398378763941294898560506024192850785596330969850849533356040955826192/2308994181032354915809986676940567653450603514916531816767728098592639580007239571759483756434738759034259206821589096026287563669815517325187,2155246173245298533339634688973679514380972194097726571531862821409521435430454004346088096490710697565224028791197423563020869438130815320559/9235976724129419663239946707762270613802414059666127267070912394370558320028958287037935025738955036137036827286356384105150254679262069300748,5739657490800393317057510092069980477587805273198413844028699466834193526651537189500930743148992768638441832837001932280767831399283644713403/9235976724129419663239946707762270613802414059666127267070912394370558320028958287037935025738955036137036827286356384105150254679262069300748,-1},{113776307188308386915845211217050675914022306688299779621453396163602206028436318668962792522775840728471516299355097597978913500122729148336/214713959299233560197673518438906490819864896414690389765179776324180433523158766152555677355812920595580933333039957443404658965843001246879,120832395996806139701249368953689384779981400669124667560547899311501764267512744770768365871425259647208602903624704141638229346155478704799/214713959299233560197673518438906490819864896414690389765179776324180433523158766152555677355812920595580933333039957443404658965843001246879,-1291384027476411005733344880335831412814798196435281789778555934113117639238182084796876833872138421269066246655549383568381953840309258797167/858855837196934240790694073755625963279459585658761559060719105296721734092635064610222709423251682382323733332159829773618635863372004987516,-18563577910445770441613237255095118728108718903511593624117626632959634757471830943930026314962189779979291729604221572852900661573488336898/30673422757033365742524788348415212974266413773527198537882825189168633360451252307507953907973274370797276190434279634772094137977571606697,1},{-59451731894317882030527761669435970210986695692490528420907729543332082342417194277069025883543518170510678255658508496953094314670328817/1042965635000639288417287706527310645047161040677801913192983453584316784146385531315079714103933310486743403597997350981823387056619317321,-412992276234571098237901695117656502605222188079486117256107737986784417451634078170778531950940268216467506299231277755954781628095165064/1042965635000639288417287706527310645047161040677801913192983453584316784146385531315079714103933310486743403597997350981823387056619317321,-171329181376659595108638543421133298190896396495845433633986758340653527200010729987412898017553735975950104554770678577319657618799136066/3128896905001917865251863119581931935141483122033405739578950360752950352439156593945239142311799931460230210793992052945470161169857951963,430390144431409910559436192948234742655967669517815546509055312420926056421327252080657213651642016759917851081537156745867273865908768602/3128896905001917865251863119581931935141483122033405739578950360752950352439156593945239142311799931460230210793992052945470161169857951963,1},{-199928462687911630950395667413418188066270243630853023694025410418747972234643538012634062418428997201956272934440431990909622757359943045127/351335541150234845670038098628492710065105235415962612595457044085802980504054112020174372201520784913818152107133609913332529657588173334600,-7078154778154184429819661519857649457852078219182951764086158399186554276519681464048883997529716653085485981325993592419582169535265113384/43916942643779355708754762328561588758138154426995326574432130510725372563006764002521796525190098114227269013391701239166566207198521666825,17626067897417921633292686081599685111755843891229376598199356827400914436291634948929798728159886336905324786130784250294942866507930708173/87833885287558711417509524657123177516276308853990653148864261021450745126013528005043593050380196228454538026783402478333132414397043333650,45998913529456107945816501694091762082423510210861154534379974161737550966809567128152797446963055148773383744690553214803428630422441015994/43916942643779355708754762328561588758138154426995326574432130510725372563006764002521796525190098114227269013391701239166566207198521666825,-1},{-3584355053315890794047194672151058987141166032227379124090543903958702288088087900606844960799953249584227208626043757743286788209166180032999/4855914132049784144699498827994810553447422729133642653791516736729635161301327140935163290974178402259208313709054494175718744753846376086439,2146006073092992746924621463962562340045301188470806858282440401159432585897622757290352981828603985113260013891810169181757566681247250246959/4855914132049784144699498827994810553447422729133642653791516736729635161301327140935163290974178402259208313709054494175718744753846376086439,1008321806262824283878201690426208298595573176700649618948885533639081753452522866201562260838532898416066430654075397906357443235258554857903/4855914132049784144699498827994810553447422729133642653791516736729635161301327140935163290974178402259208313709054494175718744753846376086439,3646926368143118353228741072281955262050752959469335587143763360237317890284899451303509971202555001253629888591459744252889348737403398040405/4855914132049784144699498827994810553447422729133642653791516736729635161301327140935163290974178402259208313709054494175718744753846376086439,-1},{-519365265250651589114920062675651610969774469977756927517945759672681647662587540893245530639359231713207531010855626484684544244356559697056/1707583516322498569290776190910201478436393180691392075922873897029369644896672534856453713167152032940061936071775830476830533109894946583615,533140944342867068560553024078984054350384987359534616031923928867394235946048057503399807061504613298211079456900304421169076002440127819183/1707583516322498569290776190910201478436393180691392075922873897029369644896672534856453713167152032940061936071775830476830533109894946583615,-121480792092051006948417330464052166528843486553009853113318136840597278790084639481602095980896954142664975086506144626704504596126590389601/3415167032644997138581552381820402956872786361382784151845747794058739289793345069712907426334304065880123872143551660953661066219789893167230,633067566540083669655064353597413535491206230417156798335759468520549294358311917472610549326174040912187977408776325827973760827711324521241/1707583516322498569290776190910201478436393180691392075922873897029369644896672534856453713167152032940061936071775830476830533109894946583615,-1},{-208704240570736396201289670367413939132971975747620410685309469923671274911163406979057637819031549443706368645126298972703620210996662211104/268424869254825449666747470453575135163597972077705370111825400242043557347268236355569175625754891406886411239142849110697324631953702624713,307180007475341828565259591135114780106416222256258430356390794305270726831571282044377540772678636457188087495745878683651644846270766985572/268424869254825449666747470453575135163597972077705370111825400242043557347268236355569175625754891406886411239142849110697324631953702624713,114858817822561656564656789092994994766398922673911190300984794476362179070337535321342215259100662463067671085754389555683492607792560645837/268424869254825449666747470453575135163597972077705370111825400242043557347268236355569175625754891406886411239142849110697324631953702624713,234335686503689825586012379140504373892183063306141807204486626934259184650795217017259879387287429718904215554805177446618447795992597526698/268424869254825449666747470453575135163597972077705370111825400242043557347268236355569175625754891406886411239142849110697324631953702624713,1},{1081955404034588931008093518903825859436953470906678903110429858559845543703917563478012969850031446238948589163513031659158357732327460154324/1071062967216935698722285853696129925275649031510765924966678638528502718625272874026700954530327364574418264050915421869242510985309710928453,-345940238015276775461860284095151334275670806062711931981099912814757534237856085514553715541304909707640042328811989412249094032064936569972/1071062967216935698722285853696129925275649031510765924966678638528502718625272874026700954530327364574418264050915421869242510985309710928453,-739885861233205365881436473464816031100238955879308994729174984909073430776915711625604959238719537115022690400481073223890818345405269567474/1071062967216935698722285853696129925275649031510765924966678638528502718625272874026700954530327364574418264050915421869242510985309710928453,-366032608535280490310400460649752131616202284731755708941919935140233136836350886941481261296604252423872563073641678406616189413085448163328/1071062967216935698722285853696129925275649031510765924966678638528502718625272874026700954530327364574418264050915421869242510985309710928453,1},{-88631958878402149701649973299953776707396227076810981029335155017587394876806614689963873459145806064902413855047707715207077660286624759668368/116662380911463324242505764821354605310032187645677413061108632604678891476683432390551025259736897281226352409507404790574892244628486187950635,-356725983089814475494286224208904064430499083364873968195499675516649828220159613606829609188381939178041545393573494161493563403278417596096/340123559508639429278442463036019257463650692844540562860375022171075485354762193558457799591069671373837762126843745745116303920199668186445,57681742080475036743966762701347884043266142753361189067963556340448010733376032026004530894828622411921235597140562658891489270305382592088108/116662380911463324242505764821354605310032187645677413061108632604678891476683432390551025259736897281226352409507404790574892244628486187950635,30188392708515043182475550742500746390084811931334630073190697344482976899279968003495126248164815136318656101092640397610707390569404894401438/116662380911463324242505764821354605310032187645677413061108632604678891476683432390551025259736897281226352409507404790574892244628486187950635,-1},{257980830442766799445949656988598670805503033448142209162025143487895494293963985133054839396199899981266729870551443181219078475198045841091/372806971601137736983330646110178418589344272304608675509919637464365318994226009874384907979687196906282940609371107293581643302017309576020,-25890379394063236216160009241870411294063918050459182633152802754955431112022260672431654994999220578479026495662677816707621923454678426753/745613943202275473966661292220356837178688544609217351019839274928730637988452019748769815959374393812565881218742214587163286604034619152040,-197013130717339639667752474128214072410742145043906645113413420775831547266652708839451341090343211784917762908652298043506662216649057731253/372806971601137736983330646110178418589344272304608675509919637464365318994226009874384907979687196906282940609371107293581643302017309576020,107724210909796193754505941909942748744365191681642636751014760138461316591000574315536086954856042161203943979866947355669654088218301311855/149122788640455094793332258444071367435737708921843470203967854985746127597690403949753963191874878762513176243748442917432657320806923830408,1},{-7367329828243302568655483477622484190504375340585665143713354290016714305566149429019652092171338949281606236141695211825240876538793039398027/10564308369772428123054920304544583766913621218232891416494729557560424691584546341200982582981385122299009643626023432478128754210549882740384,2460442734237228463737675934997281641101923478909339197382739707475257108910799463849282645036665287639962384382822717946815752591180350662461/5282154184886214061527460152272291883456810609116445708247364778780212345792273170600491291490692561149504821813011716239064377105274941370192,479173597980343919206958167907951142323278752068945417293397434395879749072405127309552716037862865555677273909171577578537824480572165966705/2641077092443107030763730076136145941728405304558222854123682389390106172896136585300245645745346280574752410906505858119532188552637470685096,3698302725704096827089022762430535787589487786985685136048952911908464846804325680911299837015414013743914419440025515930818208042835078340627/5282154184886214061527460152272291883456810609116445708247364778780212345792273170600491291490692561149504821813011716239064377105274941370192,-1},{2769620239895104110833817274068537386372232394598064958205467744880179801450645074443805067126802223128638691137141644679815638750180878397982/34217240245767179323228743464544033918713867625431039884582924228105742315424506432274288571166354577432988593351422536648966721238014028927101,-102207490754152192743806619197899297721560985313331025175586380201012885104310009647895761334559361491804986027699026723235037630113705499943040/239520681720370255262601204251808237430997073378017279192080469596740196207971545025920019998164482042030920153459957756542767048666098202489707,145538391826438012717841342891754690634006751051417209411345391977281113269893807326046122515055569880421284973908448506187309888049307622405244/239520681720370255262601204251808237430997073378017279192080469596740196207971545025920019998164482042030920153459957756542767048666098202489707,248750347505135323474273496768109417998977217238834215337724191629363920364247698164138528629125923230472133999751041751903474092847914795960388/239520681720370255262601204251808237430997073378017279192080469596740196207971545025920019998164482042030920153459957756542767048666098202489707,1},{-354439495181924910914453751655887993964730399766037044447571055388859656312484393844039097862070282314471817504711182706932676513087172074319/2042674408336678793892164030308402680955330897245201630694266579778145133755459871340106697864574140293708648819892645107192667243127578830360,-1950586979291432029205022607030043762382665443874450427819091174432432239823575110804452723625169216257172326471898053796091244345459866200403/1021337204168339396946082015154201340477665448622600815347133289889072566877729935670053348932287070146854324409946322553596333621563789415180,610814971451103565208772716389875734228384638234136379977408189032248239414495385423754571561914247633756005822431732410941493079038405821681/1634139526669343035113731224246722144764264717796161304555413263822516107004367897072085358291659312234966919055914116085754133794502063064288,36768350982686733212169584943286292682282376531097159023611148647245695821045753603231484297135549143746102060328714969205380172319241285684941/32682790533386860702274624484934442895285294355923226091108265276450322140087357941441707165833186244699338381118282321715082675890041261285760,-1},{-531006296032950685361050618991840000595141741145939126719104716280716159387194128563606679482472730049515833845373439076595913523453934848120/3477905121700380480927641844425475343944451492541380836486385997681432973399375318199585024044527513931025667431249962382423921456876049229831,-4594428518803797319018610924353293670898527091704897009318810403824726128005811906474561205080131761916940143288307625693673459108345999029448/3477905121700380480927641844425475343944451492541380836486385997681432973399375318199585024044527513931025667431249962382423921456876049229831,376635349529726107530781574335479679904249118234160862418179105775638795771839314371247286396387536454467760903768266143398639030211100785887/1159301707233460160309213948141825114648150497513793612162128665893810991133125106066528341348175837977008555810416654127474640485625349743277,11555730230245440059477944309200825844714033087747372486948318832352387873299954645289352287385426031834687020545479008651174394852270995632415/13911620486801521923710567377701901375777805970165523345945543990725731893597501272798340096178110055724102669724999849529695685827504196919324,-1},{-44359100544910207212606279699526032012545240486082222691366995811696603095263114607101739351263554557345828466676501749659130993767497928614/8957829783402235698571924067992656536090879220808209842388717068623432636327085815066258295554926606451920402831749419662924396867872694121,655705946702723891550840837980153422075709454953004723465484076628989660861995577107203108641149261006862152195011706346039053034556486806455/286650553068871542354301570175765009154908135065862714956438946195949844362466746082120265457757651406461452890615981429213580699771926211872,15678890714652785474637928355401532707337959310088421113797075458536731894004256264122490692048757426048114168074111789677516678447218377457/35831319133608942794287696271970626144363516883232839369554868274493730545308343260265033182219706425807681611326997678651697587471490776484,-7503353902673727391778353021815458875701190443802043585582971634114504340267142827212303520168100239872389399351646628493271391323675367471/8957829783402235698571924067992656536090879220808209842388717068623432636327085815066258295554926606451920402831749419662924396867872694121,1},{-372764724415082659852639978327965605505697615124144668370370051029627732736599578926701665833599308533947219686165373447806365520628495334906208/420368974560427035903865468502652486689572074144517147721342348699229449967106631245622843062015279870884043957054995052912418600726237503635409,-239260495452956348576688483980262327573769120574977089767576779944846355160251863382197766720058958068717105441813326159656765971517228712844096/420368974560427035903865468502652486689572074144517147721342348699229449967106631245622843062015279870884043957054995052912418600726237503635409,224908192309696432101545774360226693684279807527184116029788652493466446509563945947462917569258296937057598628112221413289090211254779173118722/420368974560427035903865468502652486689572074144517147721342348699229449967106631245622843062015279870884043957054995052912418600726237503635409,100262327419067459911839010808254459062674596482168355848770682402847562706728534872682346201148435239354628385648935990681127173359625152254264/420368974560427035903865468502652486689572074144517147721342348699229449967106631245622843062015279870884043957054995052912418600726237503635409,-1},{16557210327405081380863672327485423205374433917452923589431193723023784879759129155911455007483951628301940996947552163086045342942164828096991/9479104443673622758004798490663730271831204289702453733141864683279134863341863716148685921196399846468394706875476592565735190973971264331312,4546420162420906123590364523784139207981318114721818691665854932056945399427555340801728540933971397497390563188789547792853376733173192238242/1777332083188804267125899716999449425968350804319210074964099628114837786876599446777878610224324971212824007539151861106075348307619612062121,45627285655338153886588600171632478164371089439405756406782760681163711244679823784353627597244416919471436853033616881712634387966903063371087/28437313331020868274014395471991190815493612869107361199425594049837404590025591148446057763589199539405184120626429777697205572921913792993936,11213671271888590325832389882827677831290871836237412027209022468316358291951570922634200706525826812058863384165093081844940493585414525431829/9479104443673622758004798490663730271831204289702453733141864683279134863341863716148685921196399846468394706875476592565735190973971264331312,-1},{-41049543596839263397889878018183230853044471312747364954740905170683864977908495612622557347544761502824922861044906021585465980822000329134592/69801499997178817595269929660326174419921716910339600923864229505277136395237542272801605391154702166573874017657847251464174390371611978880021,-38892926362791417329137973247372437924288376977094560309119651603712495789913707629997618043525650818357458067696218690123910312658348871251648/69801499997178817595269929660326174419921716910339600923864229505277136395237542272801605391154702166573874017657847251464174390371611978880021,26507539701808718146483623701536034777546416399626585184346455420428319758631953859959433740888979585332145203157629968770871535661106182662266/69801499997178817595269929660326174419921716910339600923864229505277136395237542272801605391154702166573874017657847251464174390371611978880021,35066922156712398651861787676567649198305188935601081655927012036827037921384720761962907992008249105233714702372101625865307957519471567977540/69801499997178817595269929660326174419921716910339600923864229505277136395237542272801605391154702166573874017657847251464174390371611978880021,-1},{-63767439302735663539652772685063311083662798515545710643838834273200112242884014288177995887232735904821065265646303964022488454430498077055902/43466927082604111457122292913748196582014404447832441646724793877738980827229472214768020017464823493097839808406294700261788739217483378265863,5705239690171091578735674487179389117297058667521122559625799666035767345478492189158674835917465277488999205583709677134734996254511435377552/14488975694201370485707430971249398860671468149277480548908264625912993609076490738256006672488274497699279936135431566753929579739161126088621,6477184066349348008989722527152694327626990964645783384749716846058707458277926869946640387862419886040631476555030189527851314053499914535234/14488975694201370485707430971249398860671468149277480548908264625912993609076490738256006672488274497699279936135431566753929579739161126088621,152561408984561982903410958361428211731970863492353530679220058403385302928147234837583542222521249855802407288982551553843826269206061261110851/86933854165208222914244585827496393164028808895664883293449587755477961654458944429536040034929646986195679616812589400523577478434966756531726,-1},{59645427262806182388914334345963117911204712312665395324709543770507762332394738265221869947672665999308402618392476238549408588174726449454620/76113740054083566710078371340925167814891290189836904129055155569344216763536620116470727042792658776182921849396501162670956346250072562887363,-319730803529723236499935592583347773698957444647199046090300529398742251787967144832897622115729134479198950459707501854832678072223136527273346/228341220162250700130235114022775503444673870569510712387165466708032650290609860349412181128377976328548765548189503488012869038750217688662089,-50759933112154452507298411098869200050616612005518780605566660653175162327775051269345362817014209841932617931799193647800060785209700355199308/228341220162250700130235114022775503444673870569510712387165466708032650290609860349412181128377976328548765548189503488012869038750217688662089,-102782502809682492948945087091653829203952948510813480522504970584490745252622736815621601484065382582798038247390560825819173434923958127617580/76113740054083566710078371340925167814891290189836904129055155569344216763536620116470727042792658776182921849396501162670956346250072562887363,1},{988680083278401258631044042064376461895519766209835881774485255625056468187177380549363848186239971861821824374835416724180502533584000003/383657325377702684036606301769191936639026973970851431535609967884929937185901498222769079312811892886860051232702052706658800754273300986,25796780481961827696354043257087655130451986399106619868394039970840127009860416392797226533888491305317376782058402062635660297647215510921/8440461158309459048805338638922222606058593427358731493783419293468458618089832960900919744881861643510921127119445159546493616594012621692,-115092895592861159299034427004510444509853940933215049797148529450120996021170599030262059111113318228371067011555651105463895336416893487427/67523689266475672390442709111377780848468747418869851950267354347747668944718663687207357959054893148087369016955561276371948932752100973536,8966610048027599820226818480575835065381276148400363912134096316953342065500604015663604007608699924351202946929232644437809056905223526665/16880922316618918097610677277844445212117186854717462987566838586936917236179665921801839489763723287021842254238890319092987233188025243384,1},{-1464393513059955537360413373514706072787733802270534498150099429546725298686104421601808766147638381655072660990390521988783054852734958269684/24657912341045412275485364296010987114693113910100495108856064811325551395701685246922563340419195068922270197135432204668833505970116100701733,-67915910801329629323069356902284028941600499693847609003249079734800374009680036998225805187636440083522175576926947289777289322842803746331840/24657912341045412275485364296010987114693113910100495108856064811325551395701685246922563340419195068922270197135432204668833505970116100701733,42851215412017634956841585818496622781886677384671593496269467672105655583846070811677886363487706247669390049432577683983822390254420324829066/24657912341045412275485364296010987114693113910100495108856064811325551395701685246922563340419195068922270197135432204668833505970116100701733,11854629561967407706719314581460297588578910340440246676891358028693888387226120499654348687654662957552285858110165662780835019589472388728292/24657912341045412275485364296010987114693113910100495108856064811325551395701685246922563340419195068922270197135432204668833505970116100701733,-1},{61947409266988367706940583109256946977269564013853663882525258456070275306380299346012380108572662295225042477731339196906129067910703865171921/47372301316615371951004871654910260391796225710099976748032844990176067162834148615888172145878184255747985776841244832708706926873959732396036,-22488623455239498964634561250775135623964750181059998270466152046880117948886388289787996166562478198424536530817179519746022169247839120695425/47372301316615371951004871654910260391796225710099976748032844990176067162834148615888172145878184255747985776841244832708706926873959732396036,6101742490011610455095023834252986040868277102018446938556675086275043183486768310481806779550220677669837110514387879246297629270601828604727/11843075329153842987751217913727565097949056427524994187008211247544016790708537153972043036469546063936996444210311208177176731718489933099009,12039271546046455891346555636266539909258266262797486026812885389058332468213771565991690649488442091377343847918543870309724904551025675943215/11843075329153842987751217913727565097949056427524994187008211247544016790708537153972043036469546063936996444210311208177176731718489933099009,1},{-115031346536282580594932693242084392966591007128192831492839814411294549486346643616737664838621311933651602955980081730749990782521302043852467/254082669464775338764390335645002844771134703294963879302517645493852392159197183687507658793500117158807430022000521240878805281984607481782874,53798963291837896113505723803556713865469954584567278570530003301195359971065709396737814629013748259815336615301557657166586104509821479753312/127041334732387669382195167822501422385567351647481939651258822746926196079598591843753829396750058579403715011000260620439402640992303740891437,91862524873448144012125892124153042396046683898195087629297764302328040585674951800390998374912481895189819542265191761018775077358801167262287/127041334732387669382195167822501422385567351647481939651258822746926196079598591843753829396750058579403715011000260620439402640992303740891437,138797918035250291884848178618422276434622436799459737539077888949049032020498427265734864938585751480555970905003362489160098079269015898976356/127041334732387669382195167822501422385567351647481939651258822746926196079598591843753829396750058579403715011000260620439402640992303740891437,-1},{-296087675161668865157374458962476251400704106919665389547308084392614927605428315532340198379175195673160145559570044883637482313394094349648/592771481639870122476196002295649606141608715500244319874045373393839754023046451607488216182692144698252794560072507324370915024804524139767,213759068584922906882780413434852341338899610820804734005290544324497703056474534309743977523184045675202558252754750436255523440496744099088/592771481639870122476196002295649606141608715500244319874045373393839754023046451607488216182692144698252794560072507324370915024804524139767,-79837225684999420498216306854689971637467689575509078284145293472740760053703425119392237223116648797131830405832143675295687281212218110494/592771481639870122476196002295649606141608715500244319874045373393839754023046451607488216182692144698252794560072507324370915024804524139767,-363775119378179737331555890698389308642283347776973943608516112406910438360510111005753239754490691086955237572260893697026288955704009282752/592771481639870122476196002295649606141608715500244319874045373393839754023046451607488216182692144698252794560072507324370915024804524139767,-1},{14363024578901406694310550115135330733728545260827709514708678676612492197189524328537095738422803886931625411660551327921272677619880311826737/2516755689008981853654874866258336035551783518437390507759212784100940671893987979852081899847007276166226250638406462485564484596610729576432,11452190571173920639397659626471890822511504601265137051198328557026807193407736922514546362726659950739920441302356994823003978769214696480405/15100534134053891121929249197550016213310701110624343046555276704605644031363927879112491399082043656997357503830438774913386907579664377458592,4087906391311792687879027368039864408675913926295877560911521116313216973560984757665059713986814551629782224154308722944936249061952203826879/3775133533513472780482312299387504053327675277656085761638819176151411007840981969778122849770510914249339375957609693728346726894916094364648,4224496936262532865244604972696355275237714833411088535030584205210519439428081171498853875258536002374366688163751727185363734965692749969085/7550267067026945560964624598775008106655350555312171523277638352302822015681963939556245699541021828498678751915219387456693453789832188729296,1},{-1307242702325361550210537827277096607806666733648014365703369786670604051059307619934380654353976210419372717402125866683273492437948522212976992/1896999007137011092509471532724498227188695194943811109486498934571400359383377761312503809267388394682481894906927086828387645027262676873588163,905200569346915589369107424370022158698698668883854882655812308479335891832149481456127513694784543157786970293876087312338662866974458797137975/1896999007137011092509471532724498227188695194943811109486498934571400359383377761312503809267388394682481894906927086828387645027262676873588163,337143006259035204250775742493064808320391479540913457515539006864046704366831745252809841908854039576393850497004056770702354659026891020819517/1896999007137011092509471532724498227188695194943811109486498934571400359383377761312503809267388394682481894906927086828387645027262676873588163,1315183995102166187128025959441935651974517364087268253511502439000019331511096711475327569162925872653704308769041293748950674790442592843217154/1896999007137011092509471532724498227188695194943811109486498934571400359383377761312503809267388394682481894906927086828387645027262676873588163,-1},{1736047295525075158325930461989104558327087270188635341893329537419100259952567046272251279990413115082846452492424449105744558298080443063748/1257185053781422049493170437677045212944320898791679034617377776810269681778950206642516714038084174120698047015533764772524749446068107979345,-48444937234099027630119663126260750610444665462183739966710226621435343218483792256334782121795491307332259012869973357950782274974900937061016/23886516021847018940370238315863859045942097077041901657730177759395123953800053926207817566723599308293262893295141530677970239475294051607555,17211813277936012769361368000446551074996876438821943941677465348112339290022541077493533912696690245353889196176415954809217278360281679570042/23886516021847018940370238315863859045942097077041901657730177759395123953800053926207817566723599308293262893295141530677970239475294051607555,-4386859119136491045686521406012087386354493505935452209412542518547839785970782407718113972792147639407733749918820622693118039273695130506536/1257185053781422049493170437677045212944320898791679034617377776810269681778950206642516714038084174120698047015533764772524749446068107979345,1},{38682144300428907872237688048284800293724968865669368566954245884398906444857991205562923854876701680017696521949372302871891225398970537458231/52227738117378563220894856644171176777693893747526752034282004739517828571461936628331828617295908495771913530892982670045723391396736086436305,26654946034861748620332946074349598710660846650992228131752696451904268940489220538384818092135741495177745377019371195266233622824742820515528/52227738117378563220894856644171176777693893747526752034282004739517828571461936628331828617295908495771913530892982670045723391396736086436305,78410876577628541174296044673660417632065688050640909833944532829309602714213680371984377639267167821848746183201566555217432801456490737647294/52227738117378563220894856644171176777693893747526752034282004739517828571461936628331828617295908495771913530892982670045723391396736086436305,13070641255474545561667726836532797104865910939714456972792546666711169369128380678165276010373626388993781624412428518277479841579563552191022/52227738117378563220894856644171176777693893747526752034282004739517828571461936628331828617295908495771913530892982670045723391396736086436305,1},{26265514382992283474480304575983806510528341601399748092960915556752352613255510374662414079720830410733258997297024450744913005896143286506036/27493405669902237775944956301107766266520361309500445524929651310743553445477284229482593696600840025857160742882266278568825801062432089598997,-13090788124754512593904195089251711957979025486203870117612379247311768760281059339585335384727307268646073346630972847820926438679282430442068/27493405669902237775944956301107766266520361309500445524929651310743553445477284229482593696600840025857160742882266278568825801062432089598997,-14765865141471296738563987874963010640487191610508034521156990129590690087913912292942233458914394697917839152461440537568988636609278254206346/27493405669902237775944956301107766266520361309500445524929651310743553445477284229482593696600840025857160742882266278568825801062432089598997,-12352340604351771916187053079442860201951529698638251583396597247726481610521526715089035135034052853245100334872242568873866951677745940945272/27493405669902237775944956301107766266520361309500445524929651310743553445477284229482593696600840025857160742882266278568825801062432089598997,1},{174718818235656260588592955968730595070245043064779629181017126699182769152854582553372962942130479083955243205358085825195730996615127722880/134756116695012380948915181873414327670173115432905487478234708147805317155588775612417605603080621933167892652979901623094181867421782215573,-21712107308449961803824002707223156844300193421395435168198376213769771052514381012446245958337212960324818184714994431419017570206425220466/134756116695012380948915181873414327670173115432905487478234708147805317155588775612417605603080621933167892652979901623094181867421782215573,-66030353237126283018592650957732058880464085811613553535424858671476415282249493249262010594626931756677471318462796116198347398857233978576/134756116695012380948915181873414327670173115432905487478234708147805317155588775612417605603080621933167892652979901623094181867421782215573,-14527515202854840559501526712475442468253141817878404756454346497434425475966327887210857863965927746326909974494696175537870676127543386783/134756116695012380948915181873414327670173115432905487478234708147805317155588775612417605603080621933167892652979901623094181867421782215573,1},{540116337048346956135558637925631117374093804379981370441782309262974700904821645178620774591150601427894251201247335305363041829594776535138/598314384767479396106223316341233863982564516025707670079201451475943011660056073713058377055208190717175550158262570719538060823654374631303,-271906451684163403821484407931379952793101830688765605181288910969435907232490181562900792210904134668895594813868882032781677899911263848008/598314384767479396106223316341233863982564516025707670079201451475943011660056073713058377055208190717175550158262570719538060823654374631303,-794950279373791644110384447076202874423045566075171647784202856871943566321955082746246084466852486124303257489607735329474204093776045036102/1794943154302438188318669949023701591947693548077123010237604354427829034980168221139175131165624572151526650474787712158614182470963123893909,-1111764108813494614710325144839406826463157053040755714684985005334111099137225374175510018373547180176452000084889623608919474887549900936020/1794943154302438188318669949023701591947693548077123010237604354427829034980168221139175131165624572151526650474787712158614182470963123893909,1},{-2619478815987796474173269973649492784929704131869152398305769433241267081748492635044532356716692969131418836584549341242313632609597588365516/5176071201818584320609739964704470735056348582251565128222525011689627958970784865857736421228326688321810289154902120684138340272133686880227,1485901863207605185594263507072428796122398617701535006547514754875020930105923740045650249869350763605973150270792254013705069110336249866504/5176071201818584320609739964704470735056348582251565128222525011689627958970784865857736421228326688321810289154902120684138340272133686880227,-827308930104973873286488736347577276464013769802545670800923964503241768986847014709932747633652903371591516712460940982486224678165900321152/739438743116940617229962852100638676436621226035937875460360715955661136995826409408248060175475241188830041307843160097734048610304812411461,-2423325519992702492459852123064502618068686092768355509627982453980434215249391085866563633385482065389427203313624060617363280304346668665056/5176071201818584320609739964704470735056348582251565128222525011689627958970784865857736421228326688321810289154902120684138340272133686880227,1},{3068329293670754018558607463291196631120675567665840137923251814439320815895204414734566388284426290384875492423137452149861229833050046484000/3257271245807486794272069019109003306927552946319848839335819453398223999863367559991408577635623079377131147386037731242071126405331796310573,4790174058941749754994889156079330979041543228084577285994285407663787329393326592073601167418960486465119689467121787995236003942320667965019/6514542491614973588544138038218006613855105892639697678671638906796447999726735119982817155271246158754262294772075462484142252810663592621146,-8195014006935580494145513747797468130851229907404125269458092962718366668158294996793236418989571579294419509852062759655060927536948873562357/6514542491614973588544138038218006613855105892639697678671638906796447999726735119982817155271246158754262294772075462484142252810663592621146,-2498714456199648068922180174865000367501860294954175765069050589622116136826255502613259405553903624565207997630499068858614277233367093867821/3257271245807486794272069019109003306927552946319848839335819453398223999863367559991408577635623079377131147386037731242071126405331796310573,-1},{-6298903266850507249827387444208129814963471210409962744180945128589493193662081103745663233457398991135448940610273805348888620287953881077/5678906202211717381794378030596229733208489293548890274469690245633204827793924662536402293438044401181946948104049296538359597277772915794,51695078709258428088427246832856445239959293537035691756066397140809354718565726382510097849237842679339157867192928705982513446606598322398/53949608921011315127046591290664182465480648288714457607462057333515445864042284294095821787661421811228496006988468317114416174138842700043,238603507399558880357720661279667371968670287000788555841458735574568481673631247189385521285048478359903346533368659830747711391073615191587/107899217842022630254093182581328364930961296577428915214924114667030891728084568588191643575322843622456992013976936634228832348277685400086,-32713901507566193890974511260200007602152419251762654038942034627327430936878735950071412171162109217776372354117554886219252409021779470963/17983202973670438375682197096888060821826882762904819202487352444505148621347428098031940595887140603742832002329489439038138724712947566681,-1},{-47616920016964379953476249011495324411785048834854736620452759312325659929643860784872943545911893159847624205622801023109513046644271207148/171160866343653945560432297657228251170896886940295797033188850102611311152959562272582743865458401343870684566718022668024891077844590766037,-176918236263131974904933181541736938196823674682032722515699927469735404482009315680405838519984272926003372817219106835716867782492560039106/171160866343653945560432297657228251170896886940295797033188850102611311152959562272582743865458401343870684566718022668024891077844590766037,-45564830836242581317845064788800172820170621829804577909686200064339162349283779248285919478458903263525713763057175218604899336395949049840/171160866343653945560432297657228251170896886940295797033188850102611311152959562272582743865458401343870684566718022668024891077844590766037,-17605028343455404168138991618503782671210127337753660286141787036312611331215577703250192724929770702714933240067125306301961057106156047922/171160866343653945560432297657228251170896886940295797033188850102611311152959562272582743865458401343870684566718022668024891077844590766037,1},{184648705813070097615336217233345881639454955525743518124396482932437075245669238972071718182803167418942589928913326745734569484186166901932/634176562905093636383387762485558401190939564358052991185311380279924238864456564030604795396846412710945756698143038198807592040317032087459,-1179545434433600837792430702394295806271524652205836318757461244333731841286454520919429270857493780997939433022547589963949327202916228516562/211392187635031212127795920828519467063646521452684330395103793426641412954818854676868265132282137570315252232714346066269197346772344029153,-609059299047403345048898734760926105397602638554457360200602910938104073764801346384158766244971573894645804878353149150387135130315216262212/634176562905093636383387762485558401190939564358052991185311380279924238864456564030604795396846412710945756698143038198807592040317032087459,-1422231392046535832093674957429489976603698755742307075097461664992062334309423303570830446774079847964314037039375351598162424387972154784578/211392187635031212127795920828519467063646521452684330395103793426641412954818854676868265132282137570315252232714346066269197346772344029153,1},{11456724038086870841596326060542792128626347431619399736898388753356445527998959731428894900946272375376652026178366544705455297146628322146081/6286429717564815975369414859724928981471921207285894342326599371369626638126878039238441545888362639119758168191416835439132658327866990247704,270952269538443571547671994464200580383247344204250005727922951714062572628651951406313844038530165921172119512031138211790167174835559759152/785803714695601996921176857465616122683990150910736792790824921421203329765859754904805193236045329889969771023927104429891582290983373780963,2820315248135437729770146550194485425578102258178884742346865930296106255061164989280888216163450637597427635718730737102286617509568304954619/3143214858782407987684707429862464490735960603642947171163299685684813319063439019619220772944181319559879084095708417719566329163933495123852,-143612381254689357197500048963193949315003666929689758090900975253919502614254774357612748672072614678997835151177422461396721001157384633736/261934571565200665640392285821872040894663383636912264263608307140401109921953251634935064412015109963323257007975701476630527430327791260321,-1},{-27850288106426957312102925269824570035284357849577175141380636842244757504315339780297682603593539634190253467420480068153832120362633780959748/21802660208698794693251670335195199237274376561211125462420433215177614083401345996671024865439486453371923699549518983201478591509234198264361,3564155668799246446862487643629236327210940132011901029061510996221905295645636337455481958608220773617325430913923214340241905219146406461804/7267553402899598231083890111731733079091458853737041820806811071725871361133781998890341621813162151123974566516506327733826197169744732754787,18555599352930928737062636591810795226423377922343392094532134411361934149923819974216689065116865186584155772619429594579431297112639071730280/21802660208698794693251670335195199237274376561211125462420433215177614083401345996671024865439486453371923699549518983201478591509234198264361,-12184071913678536427682153061282227072319242454560092359087998978996519405115919477613005112781559544905106656893150111462071573361213693207192/7267553402899598231083890111731733079091458853737041820806811071725871361133781998890341621813162151123974566516506327733826197169744732754787,1},{3936535641195034002036185233397828232227277762888358604019349762356090017796714953773317324129154764005709594811749834073589851906388019933909/3977794361584362339092060379023952800017902136193330368016497402520278483056831531119917541155803074601579210326355895263868428964955822568758,1560685437251651874816140794205080169794881609663445225877185622957613972086144901745797708265176280412622381327826835923658378333268915165280/852384506053791929805441509790847028575264743469999364574963729111488246369321042382839473104814944557481259355647691842257520492490533407591,8375098903146193132267227763428700316626764044943748729796066280731429115309506707521581214018027614082722490006755554975946520356765727069293/11933383084753087017276181137071858400053706408579991104049492207560835449170494593359752623467409223804737630979067685791605286894867467706274,84320148761935757783042292628488416466148884596379262502131788834156746738610380834179162673995067368591746807792896278683574242034510528561/350981855433914324037534739325642894119226659075882091295573300222377513210896899804698606572570859523668753852325520170341331967496101991361,-1},{-3006237704335140318512683355433909874635678413266100612344188295632247425308219817753344180601213996922345684855290830756807714426374699983888/4876002780450380306801045111382600767811754797711553243996539868070872594636308163612405460476279853006234577297094891717937286131401594751131,831547521515793181156189611061489554021459183121798155779827423371015252346023347849193425639622504632812071562975778574102642617098075109616/4876002780450380306801045111382600767811754797711553243996539868070872594636308163612405460476279853006234577297094891717937286131401594751131,927027972462965659387913255592303966131645871354614631116409176454052580184024599665140727941983884522071344271034649514190334701664453443594/4876002780450380306801045111382600767811754797711553243996539868070872594636308163612405460476279853006234577297094891717937286131401594751131,5032835154646541613031330220637757612036452437790494577691322415594815588365967108898661582868021646503578879019514587389425510213706927807735/9752005560900760613602090222765201535623509595423106487993079736141745189272616327224810920952559706012469154594189783435874572262803189502262,-1},{-8414023565138789967394762232019907593604744759748127336410799629310259670753002156410673855983424783518999514673758734968536933051207738308272/9859301720046452669462454045855858131858784235357276616629612783165239330973875898469205105828050130230244329837995819542948638184644961028207,-733414170708716436116235720575474768099318561148487561394902513341415086788528116750681877120919700854685581401175586081485445419493499092870/9859301720046452669462454045855858131858784235357276616629612783165239330973875898469205105828050130230244329837995819542948638184644961028207,4540275980844763458981188363018624065494618773764027185573991737932985840735974503214633398522256944139842325163341118895340182964440514264347/9859301720046452669462454045855858131858784235357276616629612783165239330973875898469205105828050130230244329837995819542948638184644961028207,-701223885032459665827930670931626808325592471310643956702172408892481508390747448095061246184664753316824763019599695728485726292199056315707/19718603440092905338924908091711716263717568470714553233259225566330478661947751796938410211656100260460488659675991639085897276369289922056414,-1},{77077004474060883790391475044677403584341746274522364224330641008748478113170711171872427793462376214305638604402985229250598054861956370744/73600122247527304917558850051033897841284555905700092702342795785731774417575543573368369490033120738421899280087132539170772449763946596139,72010783970220390842969460117156606156210866674549162163948906292814366839302371598501477068011229301586392126781570898422399438868661253209/73600122247527304917558850051033897841284555905700092702342795785731774417575543573368369490033120738421899280087132539170772449763946596139,8479160971097533666781336456628938504509067154796208296343572918212721922804357934800948345414410446665692522660645753716542308866544807529/147200244495054609835117700102067795682569111811400185404685591571463548835151087146736738980066241476843798560174265078341544899527893192278,-66083347194097847308986384803930199635863259978298609076900177989924493815855877886030224025635690492157104462334107391445239902898944268597/73600122247527304917558850051033897841284555905700092702342795785731774417575543573368369490033120738421899280087132539170772449763946596139,-1},{-165194370340443128869706852688968093020656526275675046950531071906032150041090986430611953359588863432508888894108647028422668598472569042664/1878480680271041039939290060127742261414168983139731603141716455382564176459967309421962317998536448156031316233128951699942315121694908333811,37039033464279265782640133389904282325614983871605458241615757935323890811166320607968219546084873830329720940093060753759536160977457448248/23778236459127101771383418482629648878660366875186475989135651333956508562784396321796991367070081622228244509280113312657497659768289978909,-891570594295390928191169619415487178338637011314799132452618622572266042892789202179425214370179680334655460432249771063229439237026451572736/1878480680271041039939290060127742261414168983139731603141716455382564176459967309421962317998536448156031316233128951699942315121694908333811,-210183095432616776111962964928448572767819041114495545592353894844492292165599435157694417676884977140486673625900623852563204793445229455744/1878480680271041039939290060127742261414168983139731603141716455382564176459967309421962317998536448156031316233128951699942315121694908333811,1},{1826364055884736338146401612955306218886872031187327515633740175700441809955380765398647722105041472702401267408919496305659073925178955420443/1733103921260666581215304987568361437397971059287978833211409521369007743650571838609788169530471925246637880845372857801914676375819650530958,1542376590358790979264431139249867959020444817041953761882038363100386244478409037882559231222557454711758039810391503390010104657785169673152/866551960630333290607652493784180718698985529643989416605704760684503871825285919304894084765235962623318940422686428900957338187909825265479,1201399625690252139660617923551488417835110990749004528327865740932801458743296602824159304866823937104590101812485044068219704073368846552143/1733103921260666581215304987568361437397971059287978833211409521369007743650571838609788169530471925246637880845372857801914676375819650530958,11906793279565909387342300417750152969782894093070800478180003481629842692415132562940406240591295393769472129191651649943586574604412234622/50973644742960781800450146693187101099940325273175848035629691804970815989722701135582004986190350742548172966040378170644549305171166192087,-1},{49396106479013760619872160861680012595121155495809942514885494495218658169910517504420065577112245760828584940892000761152204805950362273848721/30251893185314893976846222205999996010335629879895001899385773528212790403823453249117441934602521057261748288942555698594922539386281118387470,-9313638124235050766700699585378476840233429084655778318689330334117049399626434372303553999455284680244693468545104090033359204297732415798312/15125946592657446988423111102999998005167814939947500949692886764106395201911726624558720967301260528630874144471277849297461269693140559193735,6337613751166007672887954879111828717948215478381961086571963586594442566887750519471967718162607038524038638695783684550668820771917903485468/3025189318531489397684622220599999601033562987989500189938577352821279040382345324911744193460252105726174828894255569859492253938628111838747,33098315989835571230085740209098021461745036071673653958869546145149437492385350218191380809225529721605398496096295159482703380634613510331729/15125946592657446988423111102999998005167814939947500949692886764106395201911726624558720967301260528630874144471277849297461269693140559193735,1},{70317882141435001049272970401446046308007374253472520251179665894522690400288057842607234102706404989329366773080477391867256569286999561106296/51340498484943912068416955789421259748626888476567040172246667527626532908860753307343115266797059827146212698722887530781186940802953273590917,630158457314077912663278218343589112768006080939988894327316561827528402870610422325547078351830057506243159557471890240750703482622645633977771/205361993939775648273667823157685038994507553906268160688986670110506131635443013229372461067188239308584850794891550123124747763211813094363668,148957588836677805351881701858424542784781571688509181001685533975442803389595958438765466935792288301078343125961701985240972139781174554162275/205361993939775648273667823157685038994507553906268160688986670110506131635443013229372461067188239308584850794891550123124747763211813094363668,403358608054157508952020499202275094155126355610757112278593780288194876393813236077375005983451822595733240766422155989418314459481809409422285/410723987879551296547335646315370077989015107812536321377973340221012263270886026458744922134376478617169701589783100246249495526423626188727336,-1},{452643271767528386756629901791550909160119923255307223267098529901543584971007838248222022993644188972534926497998779940945986489836069156404/12776650762970953319027831513306411565865715536109567114347055929259282840619255814175827344073637404420670700934552005686129012193787222019469,4438443082093240495866889966143609109197330435101571878583512312661294934529833567643868489424755118535433117311650620633745811123478055286412/4258883587656984439675943837768803855288571845369855704782351976419760946873085271391942448024545801473556900311517335228709670731262407339823,-1225547844367945111372732620594832523683216775794435892017282799306024039543408590546219624294077448203984116712627422821825132233001835386454/1825235823281564759861118787615201652266530790872795302049579418465611834374179402025118192010519629202952957276364572240875573170541031717067,-7674417391689501142333045532591088541133856477270605196550942921354271534335852570760887172415725097933128728058269766290822139371576745545136/12776650762970953319027831513306411565865715536109567114347055929259282840619255814175827344073637404420670700934552005686129012193787222019469,1},{-188798231231052437481874562943658240503197808480974932665322911390993845323281043891756159804426455546597581035955746203489062825427681551452/20749525478202489754955341724395446192456054827097182793680024046502912079330025546123108699332174703426424740997433339564471729322788687506475,-6154720408946361821923808762914420359460812552932057668061472671042692894376983584042367130222093312390869102825076444166096598103962543839192/20749525478202489754955341724395446192456054827097182793680024046502912079330025546123108699332174703426424740997433339564471729322788687506475,9749543083477903967364237241106301031711736117508867956030456450103810600881959384129397340075351900672677355672058496424357369731377727144584/62248576434607469264866025173186338577368164481291548381040072139508736237990076638369326097996524110279274222992300018693415187968366062519425,-33912036615673491628345124170668558545929796691572860386790780454749678921767325175279579784165441194603386355264668554848335187616762238495912/62248576434607469264866025173186338577368164481291548381040072139508736237990076638369326097996524110279274222992300018693415187968366062519425,1},{-2856660103299695344169575046075681968667252293969486665507946023642726982136934562062077360808435382176078208310614086939923088074582724574848/4115355053683402470649293335983424367721610176938379012397148279016391969111651656670309946025801508792408633460591510346794583575885273603547,1526113501385819317683422233078954031470691823906389734209751525052255802124019820413709307855962111395801394555440504657522528150184842113584/4115355053683402470649293335983424367721610176938379012397148279016391969111651656670309946025801508792408633460591510346794583575885273603547,1037846415661138948230867448906948661962991485494258459623545544711604872477226725336544606615254533792383299509984213851249713201620949322322/4115355053683402470649293335983424367721610176938379012397148279016391969111651656670309946025801508792408633460591510346794583575885273603547,5667406781583471331598804377500049459402439984919831297842298962163464166574544430182379145979963631783605604452094859106242320030402123821275/8230710107366804941298586671966848735443220353876758024794296558032783938223303313340619892051603017584817266921183020693589167151770547207094,-1},{-889225450274012651010750438844167499109186789473616192288885670908464708185956850930522011939598596509010473432585159439818597852666283217205/1340703297970550592069159966270954466451334598710728050325959811766636773396565749324568070947351490316238105189821721821631991509150808695846,1281519866659195312289528052900653677143193708518099612744690194924996548868018837404390523047416363926803536459541403544717422094601450290070/670351648985275296034579983135477233225667299355364025162979905883318386698282874662284035473675745158119052594910860910815995754575404347923,6402069073237045395963219214621395593949762902777426113096860909613042112296864869904360357992126564117498042771917845210338538550234146910083/1340703297970550592069159966270954466451334598710728050325959811766636773396565749324568070947351490316238105189821721821631991509150808695846,-2199038199753085876038929206005824712782603399544504628917761014541611432228280391850512279270060067745903754531800006466957646519853402619253/670351648985275296034579983135477233225667299355364025162979905883318386698282874662284035473675745158119052594910860910815995754575404347923,1},{-11968331509370981095882076849420144358285560254606405998526743112603004913759436955046994613742837049405635209790913210771740960876251076033011/4204903486746760330853096187775831898281081902904128666157907023951097136338066698539493671914449487209183803509678443229513723050229078044314,-437642731076486962193443950144174817651516689859584713480396791623032467910493608153192393991052984476216169318994670575358128871149897448370/700817247791126721808849364629305316380180317150688111026317837325182856056344449756582278652408247868197300584946407204918953841704846340719,-7692826490161806180229352713045627825767719447910966851835505490871080125069954242645178912937726759921428367965962300952839477814156738635505/4204903486746760330853096187775831898281081902904128666157907023951097136338066698539493671914449487209183803509678443229513723050229078044314,735178263824744476702015370378046878594916065015809763292381719644509037493373820438807132514998009834997035025952224272428466408672363699226/2102451743373380165426548093887915949140540951452064333078953511975548568169033349269746835957224743604591901754839221614756861525114539022157,1},{-7862656423587420078963315530031915737659413962168717168833973591007234366609212117360400992238714153957792114033022493039752428818952038951416/8225045551079253919666951362076932255491023619878757084996886261673759841073300319063081060187330611289569609973776990260866292353343488656633,-737048148678116463409023977227469148052448447638307218522902504887549021481994903445619482277379453166118642120172932456882253885181064796288/8225045551079253919666951362076932255491023619878757084996886261673759841073300319063081060187330611289569609973776990260866292353343488656633,5305575235766559026854783587980036600341203625543531912708104954736044056605589652188549753787363365226725662761679425727675958173370188545268/8225045551079253919666951362076932255491023619878757084996886261673759841073300319063081060187330611289569609973776990260866292353343488656633,2748742013384842364637843229347887449933284192890171751396436816405688681086486605386796946334172819216461393938901140422370007064260911781772/8225045551079253919666951362076932255491023619878757084996886261673759841073300319063081060187330611289569609973776990260866292353343488656633,-1},{-96402834308189300364208439409530893521651296713787439046385474486764956091176607109842173209828467219403299356971977075603400060196186972262/4510186001388446129992926473239956994416191846100093534543058164069211888066428671344174736489776030276307887595916803189499963912236786019,-86690175717991093607069941522770347682382847842220420946815757990572559704790446311192885032619745167325618147252275653070642664440516245082/4510186001388446129992926473239956994416191846100093534543058164069211888066428671344174736489776030276307887595916803189499963912236786019,-210078334726683691821596338223401180014813642561361986424465831865411224393732463423658831465563281428413951353346868654668595704795556428459/9020372002776892259985852946479913988832383692200187069086116328138423776132857342688349472979552060552615775191833606378999927824473572038,63078902524549107036455189513172610912758903849779511832865938463032987625404392806024301231575125139084954569834587043456937201093156582674/4510186001388446129992926473239956994416191846100093534543058164069211888066428671344174736489776030276307887595916803189499963912236786019,1},{-483531186579077448013004869869098816974674431278140920756361840751463569313702970473931662816049579987453226765244919217668225134673807884640/88053186425801267578039447795401117676926314904594723716828897375111518505540125343864225861014345300304410608426667146650633471934325717927,725778880850744625988063846852528483549209084631154090873833462534761795553543774890115426731811503069726680959267519385737332555416574409695/176106372851602535156078895590802235353852629809189447433657794750223037011080250687728451722028690600608821216853334293301266943868651435854,-4884557929698681929385827316578476318159388986666398521943519680233165987144762969569500990613094170441565497984645229692384226481737207089445/704425491406410140624315582363208941415410519236757789734631179000892148044321002750913806888114762402435284867413337173205067775474605743416,253661777494058477154846172183450412060061458075467400062074724259732756401760417414943962428985616929382366608935810807817553265296418135298/88053186425801267578039447795401117676926314904594723716828897375111518505540125343864225861014345300304410608426667146650633471934325717927,-1},{21485787139517427126321567007102400881644295303830174538396958047557511844017047629072313989325945758740641617646970892895326496104069051608/512703708920531207892165704999937299951074728261199370780472107376872910330287365194903718817009813094486044247213517920570003234360024034851,676413052364686625421502652729190429756258385841536053538404674009691787722201636900095469355759828119018247631260317739443696686433620127176/512703708920531207892165704999937299951074728261199370780472107376872910330287365194903718817009813094486044247213517920570003234360024034851,-8006805655057005932444265560351329652804007025066050919502659875229200034439974187787137359873025357523024227666293212796830426898749468936/24414462329549105137722176428568442854813082298152350989546290827470138587156541199757319943667133956880287821295881805741428725445715430231,-42872211615250481866504661040753972430227775744606821877897108881220132041238295395894592552728581157413297963921475923259435671605663002144/170901236306843735964055234999979099983691576087066456926824035792290970110095788398301239605669937698162014749071172640190001078120008011617,1},{-129219812522231203379880763857773398119837759297466570554999337019475023364867865613782206370946363838588262891773194415930006592930863286481/90213857896215612340883637697075286957724531714316394599298962237693708389512054801566052243426776197018216211475293451632274308593065912739,-601825710101591882851589172062081613204857979158835349759567984907883897715446983239001927389891607761480255978438758598366788388127648625007/1082566294754587348090603652364903443492694380571796735191587546852324500674144657618792626921121314364218594537703521419587291703116790952868,-230185979544444927664406987340093099343748467072611654146224155067948719426501197028816583418920634136609417667359581995134724681766205728590/270641573688646837022650913091225860873173595142949183797896886713081125168536164404698156730280328591054648634425880354896822925779197738217,-179539302880739556799887678972436670467704053829622643585900178189616985498382260937437022559002791421192528952504552471437666090360374358014/270641573688646837022650913091225860873173595142949183797896886713081125168536164404698156730280328591054648634425880354896822925779197738217,1},{-5147186188738162613576556561048152280871268448913810539532866760903124534300654464873957400785882180041371473655515377844248062661048448538608/1293381807433362342584936261316464854718463173629587806035379417411629125172445810534700920533168844152164040147626239316586602099053132408931,4125277691326709885129546126485439768746629249326026438624578717912476425151974047933171835859330153309579504768299021338352157672654892462764/1293381807433362342584936261316464854718463173629587806035379417411629125172445810534700920533168844152164040147626239316586602099053132408931,-15302988457586512922891415271575155629384213935456072173307854546235467887308664353401436234199367493740001123962533580484246466980776234719825/3880145422300087027754808783949394564155389520888763418106138252234887375517337431604102761599506532456492120442878717949759806297159397226793,10044742309712325746755379614800222328347884856512177256760939111993623396448421596315514723463362880701851720447813074838431041947337973171328/3880145422300087027754808783949394564155389520888763418106138252234887375517337431604102761599506532456492120442878717949759806297159397226793,-1},{-226873830259852906671892853883506101350703299838151627082197527921503387853018060007766565109165370287386632008131775852966761087004929697184448/100350155065014904980274958603058850338331824890625378567870431175968737472963217714699799225013865524188520075280244331092015267083007380086371,499395200354136824890418510227309885603819885465879060022194439259046029095779436669028347227513438976127951744593339125629854571154629011201885/100350155065014904980274958603058850338331824890625378567870431175968737472963217714699799225013865524188520075280244331092015267083007380086371,56033987259046629089759772207750463898678304788102546755963576010490098996824275657080643307329286350108228008843110828646320364136395599270359/100350155065014904980274958603058850338331824890625378567870431175968737472963217714699799225013865524188520075280244331092015267083007380086371,-269590557817796453151997273262670189088083699818044493077379389322373813996429345973154114317462457497072869991320592102525811275928830374540800/100350155065014904980274958603058850338331824890625378567870431175968737472963217714699799225013865524188520075280244331092015267083007380086371,1},{1948241832252703578058560621944231473433494404966267898631452559693367732616406882691557296216015231353714097758998632253595873751271630391281/470362267190134660259909218580300495364430644593572162321123609223012711625786909714383688294885565175615491622032831457196052581115150559832,505379871929154605909190669805866713165800999468349403168986305551071994551010975676168362268781902093137508609826119910804083078871894179856/137188994597122609242473522085920977814625604673125214010327719356712040890854515333361909086008289842887851723092909175015515336158585579951,4594196405378218302699736781861803442668425166884926401303445097838713846238716686087588977227930779569433530760313101865101878929379370064521/1097511956776980873939788176687367822517004837385001712082621754853696327126836122666895272688066318743102813784743273400124122689268684639608,995863507218792048867673427100449317051725881236545716870364208663573648174008764921286395401689270984935875139595860159256227483882112113140/411566983791367827727420566257762933443876814019375642030983158070136122672563546000085727258024869528663555169278727525046546008475756739853,-1},{-1375069304136826483285209504785874135504562070228430673372904289654568925592339437578691406722367664410844302830823592997219185540453273403236/6761404791523679230097874963020345624329815376043440372698412925321987772565048910910559807004465840842975809803852555928265810710481156012113,-1168863559624657269636017241938851037093641391605466522977615620872883910967606915749906040211409596308137302410851801901353352362254022144480/2253801597174559743365958321006781874776605125347813457566137641773995924188349636970186602334821946947658603267950851976088603570160385337371,-1586430468285005296747118651730611137880082252751291881363112744648805357196294519614179810344609697306597916493561113317877971479081308771128/6761404791523679230097874963020345624329815376043440372698412925321987772565048910910559807004465840842975809803852555928265810710481156012113,404303799433531758569100360545398073253394462953125978097927208717338656012754175156595604281200953424043584031824193760414854749105290276572/6761404791523679230097874963020345624329815376043440372698412925321987772565048910910559807004465840842975809803852555928265810710481156012113,1},{-58346374610650765827214420009863185580592124363979533303036144730174974483804725321085205477344738875680819731845444370285496015925206333834480/64734093567102456080812547536454149924713488521381242928043871066799535519185590534378986094776709386847170164810321118742801629139578874795413,-110086357750959097321549746975159651551379550626565621864153256045484973307146066679116979258467962462036832605052897292332153207286804332335056/194202280701307368242437642609362449774140465564143728784131613200398606557556771603136958284330128160541510494430963356228404887418736624386239,99022653053741303667715332059967521599273646375429652983593022044640358512488191000432386305243718743864642597608397359197710670507413527418046/194202280701307368242437642609362449774140465564143728784131613200398606557556771603136958284330128160541510494430963356228404887418736624386239,34654492105985099634692831649608130042848767924121187142835188338369206791974840945710290673776697547467109689116409448784920852549802619850425/129468187134204912161625095072908299849426977042762485856087742133599071038371181068757972189553418773694340329620642237485603258279157749590826,-1},{-17617203139278102987296383205843167470722044071485503618693934529793401868497064638611986833144186369886477781967922770745162461657759573986463/20759866303749455107226691796366131894928885795121959691016498711753760391828540839372061744415317307343875713537135902559219628514396944218018,4018597685988715086142564159009606356494219225406205597142117841925400186309948923485594565329826653205581427565719489432648036661737993611760/10379933151874727553613345898183065947464442897560979845508249355876880195914270419686030872207658653671937856768567951279609814257198472109009,7845717303456636878326011424374095486839185652202045415552442118303537693637982529463339151796397320645792208038576328395698029277697655280927/20759866303749455107226691796366131894928885795121959691016498711753760391828540839372061744415317307343875713537135902559219628514396944218018,12034382294783956957131984379791057091301315521249101107280646297569860957498968149802432711369832340385222043647813952510984033675329358315624/10379933151874727553613345898183065947464442897560979845508249355876880195914270419686030872207658653671937856768567951279609814257198472109009,-1},{23356260232643387583814747141912597114598116705616651938775326484568628040926249878646593344232843098063475364761792151103581287974635355152273/24757498767921368350681277522462084811225697077718865404814503393840479640329479945318365943357480577752228584739835158773206559344407589791120,-668730479336249687310043981601272612773833917226994906829705458902375933517463778042013561252744828203352096831757821632954197433304038693168/1547343672995085521917579845153880300701606067357429087800906462115029977520592496582397871459842536109514286546239697423325409959025474361945,829146416964727199574042443655673128722662221440955240603479706559577941878879920775467498956350497018542009629763454328014271860857894850817/1237874938396068417534063876123104240561284853885943270240725169692023982016473997265918297167874028887611429236991757938660327967220379489556,14623689978448213128858101652451169163017521974987201655060971232911435080705806861529598196650252374746681471923676487188556305280286298249151/6189374691980342087670319380615521202806424269429716351203625848460119910082369986329591485839370144438057146184958789693301639836101897447780,-1},{1106109034955455007426171043379710435694897648061028945559276399392861526960228044308508412497016786524020586713822920956388072650394847410312/1237853689492134539069308120332505181127435624947818710098631246621875070172577798867329558939399430861702147708740442064564998665900227691183,1490949646802977659083402382981751506817796341871682317315850262898713908412316880332083025613277309925328711599466164187500955137782448016783/1237853689492134539069308120332505181127435624947818710098631246621875070172577798867329558939399430861702147708740442064564998665900227691183,-2656579524963844101925060275400745244509979827896702849113664088863918781601307256906449326017487659923002662395520223003809452993026392060351/1237853689492134539069308120332505181127435624947818710098631246621875070172577798867329558939399430861702147708740442064564998665900227691183,-1506559359941208238438068326217471719460550007567827103585121758408595300539805113660401779273055940628138335670715940511437494834431790472812/1237853689492134539069308120332505181127435624947818710098631246621875070172577798867329558939399430861702147708740442064564998665900227691183,1},{451409637832391524015348690558514952439351064623023648969593643586468477688650815942221721960709182749921273094202050015078407060039184192218/1232853382440580591067235151344529277932809730446731585076735440757362455492997375207412267409120038188139651933529148948928045592171321467399,174094862658773025073265372023750747131163878167417116980791525761252694308174114022443880039413999859140029589524633882571920895218028436696/410951127480193530355745050448176425977603243482243861692245146919120818497665791735804089136373346062713217311176382982976015197390440489133,7080238328247159885828514456355692540774631933796591426234895602422718795397874294525137511548634028704247633471804397913185504395315500512/8743641010216883624590320222301626084629856244303060887069045679130230180801399824166044449710071192823685474705880488999489685050860435939,-49943253779798225696055558919767837182781144875034060913370635142291987348598889917797956593446958156656431874676948709894709207304784862732/1232853382440580591067235151344529277932809730446731585076735440757362455492997375207412267409120038188139651933529148948928045592171321467399,1},{-4539938758551556156635050990606862921585877355959943553569192011027150850362362246739319016867296124790603640131828557351535872382086219600416/12638940543701846749388054288061240964215937498994490886449474357885865623758554454052480478600413418663717841840447934158163940122538973784093,-4213374199958166935227886455759939134884874826544175876796257989998776113653246488407872822583336542259527123499230065764578297944754320925328/12638940543701846749388054288061240964215937498994490886449474357885865623758554454052480478600413418663717841840447934158163940122538973784093,1831485856805279545512619688396918442806049671217438221064958251640693110953904482531148575532948476461826702463925800862198129250860659279911/25277881087403693498776108576122481928431874997988981772898948715771731247517108908104960957200826837327435683680895868316327880245077947568186,9637689213865542742709504485628432862108909847466662099315399527795100664983422832116984497419370116550450907254003134639259948617396350160304/12638940543701846749388054288061240964215937498994490886449474357885865623758554454052480478600413418663717841840447934158163940122538973784093,-1},{45184808688751713911950147613662038137105877021665572434846579737686704056576064955221614858755408601720603309134837262970324385893630162414/94593871673461040932664264282808863145165180365360512395666309187909760328334900315416132528825351931541206954143477220368688625741296627261,-62093809088697515034609648630918565891491771386861578295048720257577498951312120755483748503438531667368726142835234767879676750143999520789/189187743346922081865328528565617726290330360730721024791332618375819520656669800630832265057650703863082413908286954440737377251482593254522,-190365703104960440739584787577260995066186869622374939826444932551275739566855174936745416364935848893873062244894939068457655904464991378521/189187743346922081865328528565617726290330360730721024791332618375819520656669800630832265057650703863082413908286954440737377251482593254522,-62019598003852918939996549122458714941147373364299918559188931460416714448376020959996750666123692187494184799111799962895654487965700493969/189187743346922081865328528565617726290330360730721024791332618375819520656669800630832265057650703863082413908286954440737377251482593254522,-1},{117097205383727204776989888412067090052171877427868840908878523721556074271147611596456774910585186912675382142017653928544323593980307369241012/45410733238547121012352440729761414864293288403969925892798290442731337738834673679506983228372925873432084006268480155458020171009065187588671,-59992397357487510078218260438765628141995902595026973327506033212890935330668757406698422703292599380187755852340552538549159517314583676020144/45410733238547121012352440729761414864293288403969925892798290442731337738834673679506983228372925873432084006268480155458020171009065187588671,130533877221765122274865125234765199239263333932517235099219346513190444340209245023400196519211648021180494767507270041683468719544353586293876/45410733238547121012352440729761414864293288403969925892798290442731337738834673679506983228372925873432084006268480155458020171009065187588671,-136658372109407205475138313995904461032151032411582275857624505458403125598040528205855125952869922972858719017590095531131121107900000173871704/45410733238547121012352440729761414864293288403969925892798290442731337738834673679506983228372925873432084006268480155458020171009065187588671,-1},{62144502969095151884177659439367475735868920114560749188398617045671572670607849236221619983836047907513125304746149816524569523402794892360/459263318324639415262518727243676704699021938915426751594850840458004480766620726702879677707465709507218158916528329811954717083402164265179,-374200748303222595953021407058467973488827524781295747052392309907880546804252560555071881379371099942071007891265728561659810830994162493255/459263318324639415262518727243676704699021938915426751594850840458004480766620726702879677707465709507218158916528329811954717083402164265179,-113392758965669420277060591914340441738454445103718223496216618810136409345964451598947387992023840538290054300565508536669568080726684861158/459263318324639415262518727243676704699021938915426751594850840458004480766620726702879677707465709507218158916528329811954717083402164265179,374527164666331239698409034308864162046776739447479778850767956246665778718558009880708977486248902849634220565148957179627053925881103086515/459263318324639415262518727243676704699021938915426751594850840458004480766620726702879677707465709507218158916528329811954717083402164265179,-1},{69327487263826812163907754051574436348489121669697362718688425519926689891327291249350409520153132262486778768796452484474096676499428185044/109629834955700378203656055401908164155580085734762479438946058705601858699788125673635746938311523061847669731525830094702331954080690328553,113812676959394270624117306535987992675004087125368594988521257183997511079607648870977372756594807129275342157831071685638145960139650450693/219259669911400756407312110803816328311160171469524958877892117411203717399576251347271493876623046123695339463051660189404663908161380657106,-166668990459239719490553122674136061243589826310790226101915186546472973854298040055461228535738964467490227195088368208135873415078166512269/109629834955700378203656055401908164155580085734762479438946058705601858699788125673635746938311523061847669731525830094702331954080690328553,203061272440200043638576413995793362130264755376680278187777081089323777583793832960846959844173838005282013198575371126025390418234644795195/219259669911400756407312110803816328311160171469524958877892117411203717399576251347271493876623046123695339463051660189404663908161380657106,-1},{989204742626192332457115177296576667689785324613733308985250288749503676007747650617754695544345318510365694043893547737043169991978337455904/980230521463849623575776603851061546420398520002824698755823858908714384323760936422443131553361573104202568532574493250890063207995281839799,1592867494459342052863664019830705266777617490666066079959319329618281782256609827785802832765619298342107100610682732277553752984631535040819/980230521463849623575776603851061546420398520002824698755823858908714384323760936422443131553361573104202568532574493250890063207995281839799,878478609703940499065240346689131305966358069802362770972947070691981098435024641250143459359165929870309093420638902209985311712354984856339/1960461042927699247151553207702123092840797040005649397511647717817428768647521872844886263106723146208405137065148986501780126415990563679598,-109335556466049543701244896177537110496376914758661871773082915701808537444989395261615512312192277629494379064071411950914623226666855326287/980230521463849623575776603851061546420398520002824698755823858908714384323760936422443131553361573104202568532574493250890063207995281839799,-1},{-217299687023391630559895561369344612128114662824133128619516312054408369670592659396972564777301014458097340429586109513575146614549257517632/936800784386721014845061708545312978542511912755377870598984263644883948110435639190620903049992957578994348353447387538896278203780169803871,-46022693581031142661156833098139855074224689697546050240278225579805181025452371345471422984429116366279041221263424045290672861552914161155/85163707671520092258641973504119361685682901159579806418089478513171268010039603562783718459090268870817668032131580685354207109434560891261,-219986904576050778318120136292855824948589518394299259819782248612166672318733235249494272655749983406538375212497173992803634431325357936592/936800784386721014845061708545312978542511912755377870598984263644883948110435639190620903049992957578994348353447387538896278203780169803871,60552242963778005538400426271205333013092488499778771583113898821210567169330917284352196945588418113274279324652836102600970597922391936500/936800784386721014845061708545312978542511912755377870598984263644883948110435639190620903049992957578994348353447387538896278203780169803871,1},{274295448912353462063424767047906993431227716975042050563570847128334233347706758571167738622186087697319770330017408896118102094305611956077564/101027758310565071076299487495013861350842267055122393824609167784460561085212197375685574772117732875618472063876585985460928479836234935076423,-89684613843651056197039980401964158837289074798843110042506818170812280740553012158835621059469892851418463360242879545947875221387465663869440/101027758310565071076299487495013861350842267055122393824609167784460561085212197375685574772117732875618472063876585985460928479836234935076423,63570512013552584300458212864834239854769610938084135336050941367733378548150646504650533869254346442363082876986175887012639975005733539773835/101027758310565071076299487495013861350842267055122393824609167784460561085212197375685574772117732875618472063876585985460928479836234935076423,-137151684900909358950460830328491123767572373150751777490909778604482702421908755976708173159880736312711768616885361617708190340981714763091736/101027758310565071076299487495013861350842267055122393824609167784460561085212197375685574772117732875618472063876585985460928479836234935076423,-1},{-14807160935296856751014899834654537963079796124845794052475390915805021821109618526224032882408278742143557741812166801741864639358275939151500/18164489753162730186139885941774668312318424494792253109245241911344476890652691946403979011990277646464275914945127786399632188578558039620441,-15588233404630791341581615132877872684561472354485842349798560856436821055908380801347288823260885932801111499335573922228074840667855170399406/18164489753162730186139885941774668312318424494792253109245241911344476890652691946403979011990277646464275914945127786399632188578558039620441,-36313940962279077465430728147182871358738903532979305275027079331981697505534129578506259119302098695515889782938445987822309687187334391080/2868077329446746871495771464490737101945014393914566280407143459685970035366214517853259843998464891546990933938704387326257713986088111519017,-42587181271306099741245463751154385882372778356893489329490478335479114394369634614623060025519376935744940104314136719342329608446327167049960/54493469259488190558419657825324004936955273484376759327735725734033430671958075839211937035970832939392827744835383359198896565735674118861323,1},{-17172228347548718801321265334603238143213394762908073761350078459273123783420977760150004458325359411393271495537434886300992873684330678246052/16640293406990133150145234111856655932318352933936750784535038806517484071540339976930400259716118946715600965620467693756691340762131043669641,-19766342197663090161437936515696784855655392025289608131752687275097446792552173120241496446940681148055027683009997707259500899394511602500976/16640293406990133150145234111856655932318352933936750784535038806517484071540339976930400259716118946715600965620467693756691340762131043669641,16892998864840715563023603200748229245201768719716484984470698849566687880226281227939793487550664086251502151789562303917203029133293644714964/16640293406990133150145234111856655932318352933936750784535038806517484071540339976930400259716118946715600965620467693756691340762131043669641,-1356327283122281644253242314626215914843860256603550727842666332588534300547680993443744010855855828385026886816914688340829461035170252598316/16640293406990133150145234111856655932318352933936750784535038806517484071540339976930400259716118946715600965620467693756691340762131043669641,-1},{-1174201688077732018819749936707779288143639101690023513689260635330820547724428292749917361565314678985164433386477985504282672491567724147544/1376854694352048068340973211605746382352862429786320354417010709762137266110747505991113525901714634663025773997886461520678393194343780998691,-2603709935402237386205770959458511813520623997749593601764562614695782809608506615334848742603619335613536061933791824580988737914903393005191/1376854694352048068340973211605746382352862429786320354417010709762137266110747505991113525901714634663025773997886461520678393194343780998691,-644719304391959923856293542267341676456985642989887330142365022265855738716605767032988535445548637316539700018305981715251863117885141930245/458951564784016022780324403868582127450954143262106784805670236587379088703582501997037841967238211554341924665962153840226131064781260332897,60504940678415320644873565203984834932320117099834640562519300931475241546176893907776256246268084908489437568757660324141066520633396504681/72466036544844635175840695347670862229098022620332650232474247882217750847934079262690185573774454455948724947257182185298862799702304263089,-1},{-9627175966636897889495550241782084634651583796772107939178304125383404606625536880983132661505000402395134292505699391530544840854390412988/439336606901379390874484702156956386629590879892522487477883296272099514024160321716006805320877336857689242101490426022369345705038640309,-4511425798225497535289933376872438655681892874486563781267340273841515289651147889518930724136343868777971905933724132066203778802090752888/227243072535196236659216225253598131015305627530615079729939636002810093460772580197934554476315863891908228673184703115018627088813089815,-52500261143666998453705701093845849024942020994795063123782865662821229661253719992443749092494552759613237584886754319735215477005132033196/2196683034506896954372423510784781933147954399462612437389416481360497570120801608580034026604386684288446210507452130111846728525193201545,19023290682950133408506628675340429285445170530911127729094401659241061223585130215943630053350896608662369890850123646899943649751997498180/1318009820704138172623454106470869159888772639677567462433649888816298542072480965148020415962632010573067726304471278067108037115115920927,1},{-1196388108702907196356145216693923653270690951795585430900739291672839512541396016132226095991658064462249917678925383104167590646003968320218/1296277878874158775116984043979750155207354187607567807676677399774220765910286266443089534457088451160925434177620421241909993836218841900333,-124533899501709318541591706655065966636012027528245502925739840907481996443936357098771967483915025730399832556682459070983999404181728550590/1296277878874158775116984043979750155207354187607567807676677399774220765910286266443089534457088451160925434177620421241909993836218841900333,752299847589181297247639164157238086656142448268218618806693191601192202555086296293741370173228624534914278115399649805739379135502054028933/1296277878874158775116984043979750155207354187607567807676677399774220765910286266443089534457088451160925434177620421241909993836218841900333,-96744714847047340624258544541835561592191885664094498785305205803039436199499076948184711194364210361262421783515353358662379088677429326023/2592555757748317550233968087959500310414708375215135615353354799548441531820572532886179068914176902321850868355240842483819987672437683800666,-1},{-19898877023532105638609276523724204263902474197088609289551351950738809380316881424643727632349949059637771373112182549526856722736142650695596/20409947555023457102204780935524409330745919972690780917013707717794021102293212308098812253119452341415255386457008981530070789576880314154611,-1946180879881147109997257150709110560614793847721268978045110206250084334734959175310240563607420307851882975610620131090648466223251653695728/20409947555023457102204780935524409330745919972690780917013707717794021102293212308098812253119452341415255386457008981530070789576880314154611,6103154224877330359002797806585548875296011504304610980403135928609352661577794622159315430539947744192968322790977578105573177289045107579452/6803315851674485700734926978508136443581973324230260305671235905931340367431070769366270751039817447138418462152336327176690263192293438051537,-2889403408076465822894275142532932240022438511774591124208365896029588171895818607254306043655841350805612277149591890840594193948901340019804/6803315851674485700734926978508136443581973324230260305671235905931340367431070769366270751039817447138418462152336327176690263192293438051537,-1},{-47639456150049722093833374509458658383512259963781594151435321541799798862431101490252727297888121822045697403605268304498663531536826872131584/70336854762113531170198225387178253565964456447258530122253958288503986500989561168062671937413313510094788109115436743995777810274688551133585,-30863433256080550976633280887670437446129220304813066929445515578601102311826865124267064997313204948631848535783164550753017717533189383183296/70336854762113531170198225387178253565964456447258530122253958288503986500989561168062671937413313510094788109115436743995777810274688551133585,458334536226739947141570219035517799468580065104222732356972989624771517294415172767802464305465034145542281174648640766582962476023354218950/1278851904765700566730876825221422792108444662677427820404617423427345209108901112146594035225696609274450692893007940799923232914085246384247,36917155701138822685877996613085152245981609914401977614502025483436846976374246322562846110834024090401952743562901383417805743653829519921308/70336854762113531170198225387178253565964456447258530122253958288503986500989561168062671937413313510094788109115436743995777810274688551133585,-1},{36699682880770892078183506379087099297701089164901896385297331998832523091037966649991453151634760766357331304564016618494830409728452836789523/44817071353025801673288342703281537706131499144421870791850261458862184078406377303410013781428040968285142603756230211118751537490576556608432,363257385751189922702628232343737894240739280467183884236970152457312145409667407039578714306981448172642377866170552046953365160925498714840/2801066959564112604580521418955096106633218696526366924490641341178886504900398581463125861339252560517821412734764388194921971093161034788027,18489051597250157296193505778650560588410948077705245910496053025340061287381254163437757059327826974791288650077679357289784232542483396974271/11204267838256450418322085675820384426532874786105467697962565364715546019601594325852503445357010242071285650939057552779687884372644139152108,14998069734471013539955259869454025638384886232711702337163520543824208606531292360347651290456919188180021529040041586741041596531247649376643/5602133919128225209161042837910192213266437393052733848981282682357773009800797162926251722678505121035642825469528776389843942186322069576054,-1},{-9960453366824978655896826451811156860207781967168506187174346203809606108187426851258634943138311362186044837281686807928535354261529607113028/33619033625293923684874914578938343734504002688008487541719819926483764922715231008212287439439616899992586584143764687445582933766317697164507,66427867394871705144549051748466903800026059494753184717097725899551258505090400804250806510899974044024155514404956268728195035209616549357237/33619033625293923684874914578938343734504002688008487541719819926483764922715231008212287439439616899992586584143764687445582933766317697164507,11945759643573539729769758898832879422317931310019374784929183227642661443648448128198180444327408014307729592055057588956876164335281825221431/33619033625293923684874914578938343734504002688008487541719819926483764922715231008212287439439616899992586584143764687445582933766317697164507,-20133288033602994730584470204829326121360083306084641289585528708115463066707051137653591672655594646075126131972248959256409128036788121937244/33619033625293923684874914578938343734504002688008487541719819926483764922715231008212287439439616899992586584143764687445582933766317697164507,1},{386959642436077897895275923591631944878517756901118498851432791742290030781308335740411587138893098482142894709385294195590242237056739936704/1189446062243981297171698337591730871332276596726921574759322967279264544408450535798098203736029898378933944835297754209503293374199842888791,209400213678155125725147974145973171524992411466435757343183646067868244792301488531140733144872544194480384000620697248586194908105253878261/1189446062243981297171698337591730871332276596726921574759322967279264544408450535798098203736029898378933944835297754209503293374199842888791,-1008476477719033774974894037550049309658696520191903955814468594942194693515895315934632487445369875417442345810398803058812972423615053533088/1189446062243981297171698337591730871332276596726921574759322967279264544408450535798098203736029898378933944835297754209503293374199842888791,-468685430499501666373302635638791331939337596213127765533578243631914815663950921001956877547436631571455130329009504700793582662834275210261/1189446062243981297171698337591730871332276596726921574759322967279264544408450535798098203736029898378933944835297754209503293374199842888791,-1},{-1973288240027404853865947778052270615694706227925903966624860069994996587251592781096584385412142795836022717431283352751070263760536078749946/1133143191438675631464327990368110241383258029961656230358296280375525022379367892301900502317362926647709644419595815412770294303770424452663,-2011648443248954760864632663907525309756242417572706869385223872581670491328758779756307655611036636468745069923123454457455982531212561215024/3399429574316026894392983971104330724149774089884968691074888841126575067138103676905701506952088779943128933258787446238310882911311273357989,-100416897103952935954825624299248631461396906497724942599209869119835839289480584826236794162063620026061581310041103894108772758717227612750/72328288815234614774318807895836823918080299784786567895210400875033512066768163338419180998980612339215509218272073324219380487474707943787,114036163528356450745298908800007212483305393157525488420687885634224488623810608970836704646936236403634124770644122151794819317979217435784/377714397146225210488109330122703413794419343320552076786098760125175007459789297433966834105787642215903214806531938470923431434590141484221,1},{-28029871499535314848304422158586676516547514182636020301949901951907110822784152343402559281796182973065226399478021141448418274536203620808052/4292225268087635089948028313330125366867070007452925507202269914994152905246619309856736020804590618948113784251757272971204564367256425028633,-12579997165853816506183065925266525926815246442750083830820784077237654493837770896939595404594104584378193815026329228315415592908435926882248/4292225268087635089948028313330125366867070007452925507202269914994152905246619309856736020804590618948113784251757272971204564367256425028633,-21835940341444403446474074089169862191988497734130338438053358375034117439617914051963533340846755071344512453833950130607405957408480976028292/4292225268087635089948028313330125366867070007452925507202269914994152905246619309856736020804590618948113784251757272971204564367256425028633,11479529002260556179109897490379801476309697816726171053701570944479043605316582058749095079087428868942090152389382621152152845740348719666388/4292225268087635089948028313330125366867070007452925507202269914994152905246619309856736020804590618948113784251757272971204564367256425028633,1},{-13401895068598159019266386612208786919560770977028290387512698966821360903116863126571004343956532101182003956202838277181573798606044234974644/763735807827440626339566719946305869394585266797655776223786083810917778567068663169207098244527313182560145346675982207214940257550632606781,584575203172708668525995239802181637603314856807047857694200252633184317824439847367724729186155668354259415280332313723235231736233238509080/254578602609146875446522239982101956464861755599218592074595361270305926189022887723069032748175771060853381782225327402404980085850210868927,610380920640792993089134739238059315394326154652506273852709389251853316086191716079877184851152196130224117925852934801679566751128791930784/763735807827440626339566719946305869394585266797655776223786083810917778567068663169207098244527313182560145346675982207214940257550632606781,1437366298622024636643705206787793685598167981737238172164012483058775464455806861713996347148634658572025584386263803245654950461174163905626/254578602609146875446522239982101956464861755599218592074595361270305926189022887723069032748175771060853381782225327402404980085850210868927,1},{-33473549776642096602234157139767294521718377606468492199408667943929520436826461417092569358226861219225109717028293438606580244110493681579852/26487988728895742023764775323755813428243676384966764008306466439735582333060752097987831563941635191942197586398486991901753923438066382220115,-36064648767981030564128763434193511765439635004878942556351136331141340658124615183696601271353140043587626387891689663938160484601815628662944/26487988728895742023764775323755813428243676384966764008306466439735582333060752097987831563941635191942197586398486991901753923438066382220115,40050116686222605300865002037283011072124784910220536793441554200607961291924357582161239638369987949689575635945764504320360304855255261712484/26487988728895742023764775323755813428243676384966764008306466439735582333060752097987831563941635191942197586398486991901753923438066382220115,-15702113590614531273487193084723882570540483488737548705446370720295600405252046753114794683428565768948729647016129302486608911278897189680452/26487988728895742023764775323755813428243676384966764008306466439735582333060752097987831563941635191942197586398486991901753923438066382220115,-1},{-5894768421550747151054753224724430169023898023615277133179361875280713360619427976922797530184368484559995493031943144634707647770918542498732/46035563933233208230708787764140494274413511184928583732824868397297283827088960327280090460054069864029194359538398066662380229127064719651811,-64532546654575264763320034893988340474577972411113682274600455026178805569540380241206089071494271826160681673754098905073415571416194665667136/46035563933233208230708787764140494274413511184928583732824868397297283827088960327280090460054069864029194359538398066662380229127064719651811,34318113732908157407392350562918105261963740333423965697817148501564005572553534664140298857903356682688449591910487819568891460506252748887742/46035563933233208230708787764140494274413511184928583732824868397297283827088960327280090460054069864029194359538398066662380229127064719651811,20956564060242105713267677827778125603757675414017056166693986413594156353533472968419953874251093047716944578071815110309766397214479111410364/46035563933233208230708787764140494274413511184928583732824868397297283827088960327280090460054069864029194359538398066662380229127064719651811,-1},{6472646946167899677656603095622603602168029734864328697166073163914946953686572827963730521396569623296434640540789739465068927316465094462155/35866221065043173482045017135559079409076926841902178125373101095206622483505876015872399512107828247316262667268366868209326639419597173468464,11962605980807411141026350944035810434434133086950214372993606743525813608714225246325686367006919475944690599148972076211185539438561358896337/8966555266260793370511254283889769852269231710475544531343275273801655620876469003968099878026957061829065666817091717052331659854899293367116,563771193328545112880858878188596497655228756174336944389839476503777330405504365978270287276141736113624399795412293570367431262881643463172449/286929768520345387856360137084472635272615414735217425002984808761652979868047008126979196096862625978530101338146934945674613115356777387747712,26394420685075009833576443596129717901299227972458767105995232102277624887152204341113866985589154598322188449472338637146781694530505627027399/8966555266260793370511254283889769852269231710475544531343275273801655620876469003968099878026957061829065666817091717052331659854899293367116,-1},{25082027279559219256816328080245966547777602669517414382160416290864525052133067734739815750505606435321025191493682598048510514379136928421318/20876314194557021729133285234053394559651549638744464532759892169562387648382459426256936154426563561330667990915862305035213154470627815485755,-12463167285457376130392909199984988784725518286580123579036223259656626034505203360595370989080346446708429203132142867679876144539025548489232/62628942583671065187399855702160183678954648916233393598279676508687162945147378278770808463279690683992003972747586915105639463411883446457265,-23471263729790580088803131182512917592173600151525021277909814893689540630298604798777517552294586398157860709370379797823392894034552605618596/62628942583671065187399855702160183678954648916233393598279676508687162945147378278770808463279690683992003972747586915105639463411883446457265,-1674697444851268531708351067928979132052556398108040787511823163130352660578662974141754772066020441888926755604553498036876237314083013176564/20876314194557021729133285234053394559651549638744464532759892169562387648382459426256936154426563561330667990915862305035213154470627815485755,1},{-5525126192480036047527339616766177364296357534586930073501025906073286172203798289375657701548502366291006912275291483886960083310112471271252/6764572415798293894252757790693837013029649586023877627887790434172621320920108448978173011259688974329030285094016069750787874117920510692895,78288331377728734504161455529540306922188316072586332698206145876095261046870203637441160748345586447748883303171056229126967542205265740592/6764572415798293894252757790693837013029649586023877627887790434172621320920108448978173011259688974329030285094016069750787874117920510692895,9535867307077766792609603820262987440247491161366625903540731824615109365630897138833568790748301050449494556829298685686505474406305723870376/6764572415798293894252757790693837013029649586023877627887790434172621320920108448978173011259688974329030285094016069750787874117920510692895,-9590119473472436405947855584229969809201824570285892583449520369177325992009769467433613818004984161254919976645042320699727146379669861509616/6764572415798293894252757790693837013029649586023877627887790434172621320920108448978173011259688974329030285094016069750787874117920510692895,-1},{-305903681790759508986244469454847474669839314300269618671024775933499392636780519644922296172983413973923963068124273877005756235468234853959135/252205006910278398889897986372886216957628926254884299821305424824935707848673445431931125796708823033100117664265377196698064650879539222787444,34482452274342336806504041479991936491939538216134804690546338655046271573646095277483264104054209502707464542736146824976229136013313102550542/63051251727569599722474496593221554239407231563721074955326356206233926962168361357982781449177205758275029416066344299174516162719884805696861,1485939984220170097807312072683505075333713628281479839819155667448270614669261455072245767605606107814115731928205139881714066349071119500286415/1008820027641113595559591945491544867830515705019537199285221699299742831394693781727724503186835292132400470657061508786792258603518156891149776,113972448775507648575803410972060937245597306193265890001956614499265136821389616864801503307904398035800065433291516440297072248854232540840173/126102503455139199444948993186443108478814463127442149910652712412467853924336722715965562898354411516550058832132688598349032325439769611393722,1},{-156081454999529880675553281864954474546952358796802071988943762853421795809891393574882003227227259252663804091051134286750994213723690119/62049559427534862766214363288947422922291358743577681286304381403500848175059331339257121798244959158465473501960634024535188190505736789819,35481069318478938490472660109432226808929129448617439659224959754750356194769893049593593505881887500803747117936285320397195889619963173912/62049559427534862766214363288947422922291358743577681286304381403500848175059331339257121798244959158465473501960634024535188190505736789819,1178188283577624172220006026921825239391015042381611867964763446089082005612693408265834563601309610844249417481158266137033517382386774996/1591014344295765711954214443306344177494650224194299520161650805217970466027162342032233892262691260473473679537452154475261235653993251021,1321131371438676264487694835928464671331557998260023141704369344237214382702941832057169807782161301061373525435972287933704773055340994806/20683186475844954255404787762982474307430452914525893762101460467833616058353110446419040599414986386155157833986878008178396063501912263273,1},{-481596216356832011097352416063080966867040216371087715631652118231680496600899045705881329619211474997498679599013950431285347546468729155872/550443234150510535904249343524071733396950811317357551225034096367124489617432614777121779225797478292926708486727419309804356777130290339679,5712344682289490574037398689309793963267245741990436293009381024986408961884257957835045431797558133589270820600651717008520910656648720021493/2201772936602042143616997374096286933587803245269430204900136385468497958469730459108487116903189913171706833946909677239217427108521161358716,-1513805888173591136858290251972402358299549920827855012758611966853276163887852108616556202823106811077786138369488607619497068235117513203736/550443234150510535904249343524071733396950811317357551225034096367124489617432614777121779225797478292926708486727419309804356777130290339679,-320035909822927620175067825686605095114640996549322829272508926007636820125965680985846349978085126539661498199524149107657922404965782810456/550443234150510535904249343524071733396950811317357551225034096367124489617432614777121779225797478292926708486727419309804356777130290339679,1},{87101337523181480480984778737288884409123495309691756592496270701145319178847823966392548259639099028832431448187647514851403825343088004160/2659277266050737643507488874130262334996389942300024295713629096132592945733617713461782322168910851525884694128001990319093127448725529282313,-1436347552779619243294404178622695163761151610068913174685273804296173414580998930948778366409656113693027913295066723295753556912919600390997/2659277266050737643507488874130262334996389942300024295713629096132592945733617713461782322168910851525884694128001990319093127448725529282313,-10352301731040591335587169719757761519089029211170054984059751660118614612981188396240500888286443119101161417266982732502452137672809464427797/10637109064202950574029955496521049339985559769200097182854516384530371782934470853847129288675643406103538776512007961276372509794902117129252,-1843538355211144410156763413868106815639506154621629940405340880262737989233136319928755559896184263113249567979206000701713058790558636655121/2659277266050737643507488874130262334996389942300024295713629096132592945733617713461782322168910851525884694128001990319093127448725529282313,-1},{-5879933002968179968514830697689124876968775311773859679575038758177569329126216740928747797851365858281193052155500183389327370298681710315480/13556772885086649922114078074464720696552211158681658929917224558602422973385755764785639706479677702584194911060338693393982624588805630605529,-5218100690414701140979462875569070291221046931320152061173827883887411059860792142886270071304358568078965710443655768701646459585197455837268/4518924295028883307371359358154906898850737052893886309972408186200807657795251921595213235493225900861398303686779564464660874862935210201843,1163041071484374085642996868958718590486233107807064976668257206863419323212810900375105477172913722711444483670402885540300483871391016756951/13556772885086649922114078074464720696552211158681658929917224558602422973385755764785639706479677702584194911060338693393982624588805630605529,40471201604865040034941606336200651041381344763516286781588808840929115803199668718338053750631942465661528991597500117937229256484355900394485/54227091540346599688456312297858882786208844634726635719668898234409691893543023059142558825918710810336779644241354773575930498355222522422116,-1},{-19158672127599212534516971254055428198237374505722371593212309642330496507100479784111605601721606447868668960043401139799077328593317798635588/54941066456991301619497736358137582656899814355047365292790706948856742397845291411801076832811423353469354489554442008176212790274993003057395,-44118309043999350543301462247021733689872283701304234621258355951354774830965798812680723189239500063203106869832127838090640272427256228857514/54941066456991301619497736358137582656899814355047365292790706948856742397845291411801076832811423353469354489554442008176212790274993003057395,-15364143312937977485799443176907434939393580039943937223211419995571931894958411351432851830874481641627020606858283269270329841048851930883528/164823199370973904858493209074412747970699443065142095878372120846570227193535874235403230498434270060408063468663326024528638370824979009172185,-66421738433664961153127586886211998281805833973060522769902993292548295229112657900432484909286156705384445473586616804395129351099658107787896/164823199370973904858493209074412747970699443065142095878372120846570227193535874235403230498434270060408063468663326024528638370824979009172185,1},{177262859027715517338651343936285399930087827825222086396225985655790844324657267666428445300443807291166637797589807239901340335732368111112/121243493807781951682820074154102821716650749660003802888091909763751882375522969464177878837100123046973375243170935729240805092556274421347,-1181318182035840414584145765807397754942709004436111733753219468959771923155174332830750484186135685668448204876030889008257212360845980885293/484973975231127806731280296616411286866602998640015211552367639055007529502091877856711515348400492187893500972683742916963220370225097685388,-305083286140049227032847185305322054263990577080874384488462635506406398431119472137305205694604172652387101071812782509914118761638907932923/40414497935927317227606691384700940572216916553334600962697303254583960791840989821392626279033374348991125081056978576413601697518758140449,819445607225924600846668978704560023084867638514815515684733556948970907582664126497276189063844713895084471494804733316447198381193607314997/484973975231127806731280296616411286866602998640015211552367639055007529502091877856711515348400492187893500972683742916963220370225097685388,1},{201023527686071294409848435492454626028668571414247837385828081162517105541581728653215472557567362582138967464264803240119130368423605054684/931140878083893018941799929517493828739443574728177386604176054163180318338163449917171977746157021379239437147498734459548385241297652417743,-1447224394887256661556615292207281133451811685801768142150725090862926753942394650797819097533950590107421308870554641960353985052001803078494/310380292694631006313933309839164609579814524909392462201392018054393439446054483305723992582052340459746479049166244819849461747099217472581,-635077633222009680496039048962482066585793033026683093428306862824627969302349590623090137356260851375727899602228606588913253688623675449424/931140878083893018941799929517493828739443574728177386604176054163180318338163449917171977746157021379239437147498734459548385241297652417743,-1814920040400193889463209965669630015964842757929198387289090102769605618065526674449511205109585932874021117809239654945978369889664481247846/310380292694631006313933309839164609579814524909392462201392018054393439446054483305723992582052340459746479049166244819849461747099217472581,1},{4252108923307094695414481966663910125969950565526241676427247838250062813027813292952438759384518776171978477740652755543136298923679134178588/4913041774134838806643450346437390786601308566475426346691930989247368413343629455819228575935759622188993237867794442338363840221290810201357,-7136787519026853876047483002673973399779783418075205935754711612541382487107081435422106897781106977908787178450849304347280761805820502257564/14739125322404516419930351039312172359803925699426279040075792967742105240030888367457685727807278866566979713603383327015091520663872430604071,-2349393364694875664061594002871123557433120349277265593623878656253482985351817580783196650757457940786986189022283278951966293030639557414614/4913041774134838806643450346437390786601308566475426346691930989247368413343629455819228575935759622188993237867794442338363840221290810201357,-8354192022420742750180037972302478175607416141355810059503714372752650629059986588291785115944057302821285790060338192996892475695136689776184/14739125322404516419930351039312172359803925699426279040075792967742105240030888367457685727807278866566979713603383327015091520663872430604071,1},{-9417591205347484617198517259761235738657428868716048361515159412841290325790699205559974341581189856353471280905919065010416371585590327043040/13966194181595494476208912525829286771843824757997325377264156939208599817073349097479169997602615426651174144578358164997739657925608591703429,-17871776085090817696777782160826702351367113054489022381244803736168542669605219177994451538534955489733365636027975863634531256979914143610936/13966194181595494476208912525829286771843824757997325377264156939208599817073349097479169997602615426651174144578358164997739657925608591703429,9278539752607244592013716438588611799178456215877730074209314694068972962005665277609542009320117775657946672190352839419192920515353723870769/27932388363190988952417825051658573543687649515994650754528313878417199634146698194958339995205230853302348289156716329995479315851217183406858,25453243535655062738864492888619957607336098684484492209681830460620003537073836186436000919023421491328560989285168542172090020279552737886099/55864776726381977904835650103317147087375299031989301509056627756834399268293396389916679990410461706604696578313432659990958631702434366813716,-1},{-229910961375688283788593621906344306190983999226125278116317074323358180693574258482117750377844230725235399180626928435807028671008383952137005/55624677972543261445740163785637252426331496254342675663614878813788653083780466889361720625934399705179341429512552570091474616091119778745424,72507876101708870313907301412439849600712370762633165486292926889074386572005974297535713265750882465747446353731167875839613211332045736498161/27812338986271630722870081892818626213165748127171337831807439406894326541890233444680860312967199852589670714756276285045737308045559889372712,8870188552086273858665496452212699390741192359148609566498865252732895374316554525213174664762771570197596431673218302533455554597095902100621/6953084746567907680717520473204656553291437031792834457951859851723581635472558361170215078241799963147417678689069071261434327011389972343178,-11016644043863150230134436471469046618665443639179651938945239928951736888008994937769490464249124500001272964157389263700066847368502411675599/6953084746567907680717520473204656553291437031792834457951859851723581635472558361170215078241799963147417678689069071261434327011389972343178,1},{486457085532833314196927465257282835794094760256578946429986645328176820824842150499035554182709814474348144549334088855535171979836300775872/1052332751212965087053864895372437985277704404157038773124494952048834465887880224852297993101913531768922619436275077097338735444831388633803,-344936992916955258330087041847446817092307862737274348547206835638500907069825673778723842462762719038937746146861330899459036341605551445453/1052332751212965087053864895372437985277704404157038773124494952048834465887880224852297993101913531768922619436275077097338735444831388633803,-1048558796791072860273429187727883899367206746745243395837621813227784707579943727453339855627656506205227882463360355500706286572597176052860/1052332751212965087053864895372437985277704404157038773124494952048834465887880224852297993101913531768922619436275077097338735444831388633803,-328926076120501279042801548135024882812788230282426691028492570513093860788059091274889250212794101865019765513617661802382567551955028470553/1052332751212965087053864895372437985277704404157038773124494952048834465887880224852297993101913531768922619436275077097338735444831388633803,-1},{-18986859668580660389798281033909486856069766233599673014052956468326346114423793088733697384199099790866608637769162800098580798872837132658336/27719650612095049883476475853050850477761978207316241542448093981394276229009163516782995265692609476505714554353044953103819475460910579461655,1046965290665544123340737829562462912751378312367256644537316304636638077773775347002590479389232819912495843873942231700378149343502895235066/2132280816315003837190498142542373113673998323639710887880622613953405863769935655137153481976354575115824196488695765623370728881608506112435,13795578664992790375333334395622147446811694475708383531701406531205301559712351407754361405861617810737530732491297399006454133567482440600307/83158951836285149650429427559152551433285934621948724627344281944182828687027490550348985797077828429517143663059134859311458426382731738384965,59132493789263461784867410405865985473512270704053221587454477004385388402649961708556420018341981446870081622298903913140984126017748148038558/83158951836285149650429427559152551433285934621948724627344281944182828687027490550348985797077828429517143663059134859311458426382731738384965,-1},{-44572641062032524414125456090222614954253506623348258155584250083888940372226362644088182280866147217718364922196498271289466216721489212800392/41254071756544706999944821946131699374811925658458206870876214188955567892502108069921542916702119044298658430483597242386885437603781923729841,-96919532112460102238647494939573299309902777782823231561529667391021757141115626988474758400830963782047230061669713174096430078774704725529991/82508143513089413999889643892263398749623851316916413741752428377911135785004216139843085833404238088597316860967194484773770875207563847459682,7129833546612030863488484104080368142700261054132651770178114732028342398785410370503703098736041546188984215231793141637764693979403573183073/123762215269634120999834465838395098124435776975374620612628642566866703677506324209764628750106357132895975291450791727160656312811345771189523,-142005195124679141192369578709495042426914541829073005471586435170743458704566355141003572477730352610853740818716188307645764582882955236714056/123762215269634120999834465838395098124435776975374620612628642566866703677506324209764628750106357132895975291450791727160656312811345771189523,1},{-1599868990455796366700681876772688219649031737511874401429087563347516668770678854288166528521785639675681867387031341299423479278385370453876/26065176154249470494567610804522773543655775152050189996116660385309707685017504852885825217109859872708521708056448809643806581722201581161,-583783590317810785123713280437300780006456145740902315138245810288890923635014556452768523642923404848862118427373878767744837937677737235740/8688392051416490164855870268174257847885258384016729998705553461769902561672501617628608405703286624236173902685482936547935527240733860387,-164541404808880843208085906248174314462305682878120494738780739033554718278068647547273895823585558654363104792247064320417748840621089099148/2369561468568133681324328254956615776695979559277289999646969125937246153183409532080529565191805442973501973459677164513073325611109234651,1223181076530380964641828927951100284319130598187470370231457828292497324610855513571246641029393120767040622019593366014629109813096789368544/26065176154249470494567610804522773543655775152050189996116660385309707685017504852885825217109859872708521708056448809643806581722201581161,-1},{5571350297627309933532368446610304326958776796281647410912756031417261301391744059259021743597646637622177033801667517242594462257236019819/8550976706587139768770563314732325835007155598490902871959499888461891925864207674007174395896188350937358352707986368046478898552969675166,5292083091685570019531305696016030595957532598733846621442551607394198723659804733983184842402468658878428055474564399432134021671923395019/5700651137724759845847042209821550556671437065660601914639666592307927950576138449338116263930792233958238901805324245364319265701979783444,-17552981767875626188551247374022522217862256748528341326001700262281530015265337644745979398200322267111279289092197349081216848517010959343/17101953413174279537541126629464651670014311196981805743918999776923783851728415348014348791792376701874716705415972736092957797105939350332,181262618796113563983254574789027025094540492269314015434753352819194244714853285758966386042344078631845973042521634031748370225253701558201/119713673892219956762787886406252561690100178378872640207432998438466486962098907436100441542546636913123016937911809152650704579741575452324,-1},{258990108512017509092567765690354009262984301947535385323642511502349612486787381097937459673223752935078275673834093481418533262811695064048/647752119634369125815133282547810054849426285238045555354088415889175523136081558733000785012132629465555953813515370457517068166983725801261,302837486231469717805117981883905797620542460298747069688532471207964870262968754436185132195805818792159431067312248109471715633782294252952/215917373211456375271711094182603351616475428412681851784696138629725174378693852911000261670710876488518651271171790152505689388994575267087,-214997653330348266949496155240109209715001637053042908523087345954098031544728142417107247806651174147615335603205789389513760190064482625476/647752119634369125815133282547810054849426285238045555354088415889175523136081558733000785012132629465555953813515370457517068166983725801261,-66163560673370114911033078959376995440737475290332371470657334788818284097478862159946943913722668204199350164267513032577483199927919035812/647752119634369125815133282547810054849426285238045555354088415889175523136081558733000785012132629465555953813515370457517068166983725801261,1},{2911513293057327253987067575161434698278451280730709180565402265004286461915552214058292317415911051403738128071583760793683901677685706852004/3014178524055026845718100162057503414036231939989969228989017566251613628533481431096044468045376439992430294357991159294175644158185576294721,-17953278132893319435082042107156128838470923532734323905470577112796200400698144916089531785513420508653511884425711566868077965676114076367438/27127606716495241611462901458517530726326087459909723060901158096264522656801332879864400212408387959931872649221920433647580797423670186652489,-14618495203155699194204038591706943865961149890435587020499233074008821886368408764371477594340125650655884496385221676843334937541969351719624/27127606716495241611462901458517530726326087459909723060901158096264522656801332879864400212408387959931872649221920433647580797423670186652489,-4974281601187401407863023987012167631968246049669079651846865680894935071926160844569387987538097237430144374096310863665685915837534280249956/9042535572165080537154300486172510242108695819969907686967052698754840885600444293288133404136129319977290883073973477882526932474556728884163,1},{-4592068031245546071855527005002531348935760985293178056334805730786412113871212053323153974934812313704703440712298099251857469401240186037358/1842190329305858806812111843742801416846434547836216190894035739945343429015778229155400341767878963923704737363916529697235032196423544779609,-5098724461601902663475103689127352451058357201935730481464547469104788478653201624111656022187613009445749282902824589697864429411388783679656/1842190329305858806812111843742801416846434547836216190894035739945343429015778229155400341767878963923704737363916529697235032196423544779609,916378388292619628538996789469388660642063370371341451152273065894658058393470692429271114854564704946711372015054919450667007820530681283477/1842190329305858806812111843742801416846434547836216190894035739945343429015778229155400341767878963923704737363916529697235032196423544779609,9107300051185885695578239838671391454104074957287049419282154255190655259938722190234721761277077516544571506492017413748698729581767371825491/7368761317223435227248447374971205667385738191344864763576142959781373716063112916621601367071515855694818949455666118788940128785694179118436,-1},{-2138605840872895246863599049966994310618628020291575649355646586076113062149757911465521176160347681556696970769719756689741733643822048739470/113498400677538993378638947136532198002785764486077924719763732689973217619765599421645325175473838784403270875395327341025877470185223025141,-626601079984547500680473122617083245031182072216900835912424973134196114846036700420107311875765147954809369246625902634403354024749568311296/113498400677538993378638947136532198002785764486077924719763732689973217619765599421645325175473838784403270875395327341025877470185223025141,5823396228697165642055771664869971656851716957261658054534820387425196180996091779212517921082669076935678636884623086804932780348620509292515/226996801355077986757277894273064396005571528972155849439527465379946435239531198843290650350947677568806541750790654682051754940370446050282,-3441966288103988983995061683805324411952650151773289395806212060337734345096259685860077376179197445367286167169413032848097483314710481194868/113498400677538993378638947136532198002785764486077924719763732689973217619765599421645325175473838784403270875395327341025877470185223025141,-1},{-303194701206686897711327781515302073631549942242367822080569776806065021187605229624122556632343666173610242657645731299250856237933187830943824/191491318839815669599726896828712850266866065809271506092139186955873985136444056968311739374376095813866953312029385012112108504954717931557115,207871802339147050902043184004022406245512321373000996284663008156173457599151305765827980385920899741861865280231055832370822478263138933948538/191491318839815669599726896828712850266866065809271506092139186955873985136444056968311739374376095813866953312029385012112108504954717931557115,54213173253179769470477494735313209521332197086454581121280382750009902633010750890001891642608600197122825950572639624468191133485987144659676/191491318839815669599726896828712850266866065809271506092139186955873985136444056968311739374376095813866953312029385012112108504954717931557115,-4835665459941112175488049417745283924742238134228235786589518557662584800980411575801310571187760780824136544956589678370617112668321004225007/382982637679631339199453793657425700533732131618543012184278373911747970272888113936623478748752191627733906624058770024224217009909435863114230,-1},{1276446567581051096174176473324017898735364580744967340612549237582612567075902891035946163687704417835723204864503355274388515117627486443873/1930697891297326994827257835156382545589217652849459771271354824807485109037109592080108817762896703349614197244396734729162543344976132351895,2313520266512147275060576375573639111610911730443805256363760267109128401185182572860237517011614265036675882060085030770823570249864607494592/5792093673891980984481773505469147636767652958548379313814064474422455327111328776240326453288690110048842591733190204187487630034928397055685,8318847114260818268882962096511967603814952195519144648764923630437087782083988441940777103514574878375538126492287842223083762878693976592891/5792093673891980984481773505469147636767652958548379313814064474422455327111328776240326453288690110048842591733190204187487630034928397055685,-3601732988819823653264794417906935733826218294625614934161353923301780161267748855279183509015094935206277924695181417213357609822371220405002/5792093673891980984481773505469147636767652958548379313814064474422455327111328776240326453288690110048842591733190204187487630034928397055685,1},{52843634814672084199804783302816517374805667498834803643655507386419515986690244437621167806489459151072727717128668263467667329161935055287972/39045853945536243989128643097607744390795992187620294644235354702211297555444903754402539887753460025826723576269591804508385002079889831180457,-9003951823221192305259801710905769958713250662164944349988702900164570996766490972173799037621469166780759000669095185656217613811987809578852/39045853945536243989128643097607744390795992187620294644235354702211297555444903754402539887753460025826723576269591804508385002079889831180457,-6450621323275914590391715543791452254160137310964712143850165994935431223651999007160543416805180391745368799891969879836447415351369604060286/13015284648512081329709547699202581463598664062540098214745118234070432518481634584800846629251153341942241192089863934836128334026629943726819,-2732365259461868494877848158642954841795451169693704062390403258607752186377643982252554130440900216848536254642029069762371262846731428309264/13015284648512081329709547699202581463598664062540098214745118234070432518481634584800846629251153341942241192089863934836128334026629943726819,1},{-6890538608718364899547268351074263089405103989377897630660562131875042310087554136376905296461032074508946736987206684308456164036237603222036/3629574945195309358687124649554534955331813510715352517633350193386473271166736204285832622374960197848223013452073913317881718236884314285799,284139400216651596762785248758533622383810274394141737794706827181647042084346275020467973167889150678671309490373723468073649225704490060684/518510706456472765526732092793504993618830501530764645376192884769496181595248029183690374624994313978317573350296273331125959748126330612257,-718414794798159659347651925869625902008359417780527602218918842394394051072235067974385044693011504365461402418833688380004438522113323061619/3629574945195309358687124649554534955331813510715352517633350193386473271166736204285832622374960197848223013452073913317881718236884314285799,5879051800415188154501978239659290688728269030251534800010043784979079188509574958871158125099295515775139593863228970353671213052063124805784/3629574945195309358687124649554534955331813510715352517633350193386473271166736204285832622374960197848223013452073913317881718236884314285799,-1},{1151184601450839004488328600062330055467167617501084770819392505616436348731328511824666480069069417084972023349603090386548090073399321493504/9371967270752729000650235547682001261730888970526974317900386364916664933311120625167904263429267947215246420522837650709611671752684184237485,2868676762720382949170722431448474217708148461663139282495267428616726026963882469790801400734057041485629523178072188466830812023727376058817/9371967270752729000650235547682001261730888970526974317900386364916664933311120625167904263429267947215246420522837650709611671752684184237485,-2356487966491861053843636466303615695254669841764317565074132366901971835113882985386398784478101925960694143159908841831813920780401022771559/18743934541505458001300471095364002523461777941053948635800772729833329866622241250335808526858535894430492841045675301419223343505368368474970,899507254411962832393329777627943282792882569679569915262355079738278865602388817618895116302034381604909692522669664225835300685585639474297/7497573816602183200520188438145601009384711176421579454320309091933331946648896500134323410743414357772197136418270120567689337402147347389988,-1},{-742239544357532089490360991714071661479844077576117367969314334580915630267788453142082744733472300344615033936031482749037689863859647403797/797503873894476877146977627881516915145637196363350951988623884083033745921059290508191877419248329804134381182087822411480388164934518244657,732569848429620632731654800676657066388889831139759452485210660570865565232103648216650382444244718146695397787011794966960711197399707488731/265834624631492292382325875960505638381879065454450317329541294694344581973686430169397292473082776601378127060695940803826796054978172748219,319946657526449833666084769185150015504317272238402299696460440288236651467271438145604762423553879266388343009908982779578324434646612822077/797503873894476877146977627881516915145637196363350951988623884083033745921059290508191877419248329804134381182087822411480388164934518244657,-1025807946587235429474877751613240706891188154040651059451505428774520375888489182570297249405658398724007775075203204568003008495696141124762/797503873894476877146977627881516915145637196363350951988623884083033745921059290508191877419248329804134381182087822411480388164934518244657,1},{14173695235458953962258933611842607738237244768421367485262346304518123003490775503538190830487032308033820145938673449415183779664197609556/9810115255903525191779175320872846810299478046559554048872095079254757654258484692616912242703471849825895871667749942600334943495447433345,-87806635312991427527092099923746514806860462446868110327801534915830587890337362146213855558404104090633356016369316043981525567882246425308/9810115255903525191779175320872846810299478046559554048872095079254757654258484692616912242703471849825895871667749942600334943495447433345,6288820462560436656067637013206391405658501107480572370545064453654913832806509949845884472020181618721573801860203084538613143406873842066/9810115255903525191779175320872846810299478046559554048872095079254757654258484692616912242703471849825895871667749942600334943495447433345,-171625056024747690232930344423538287371791825921364034374263390505444380420465707805996761051130364330313557173369994322902452705044642592767/9810115255903525191779175320872846810299478046559554048872095079254757654258484692616912242703471849825895871667749942600334943495447433345,1},{-37582157117816414837652594011365247847780375774408988225799500098920073813995223385066613042469030611450186745030050613778338790628882128828/67507668437966778186934547252646021925622555432008904704239006468660726532985778841638819282091073906010656143492619438534910183311879225319,8968498682283116502342429142395194168377332080289585501250650641702341317738533706180805578852754361163490052097210330074836841459084363663/60006816389303802832830708669018686156108938161785693070434672416587312473765136748123394917414287916453916571993439500919920162943892644728,-804453036516107676005065542365618281044185201742674177461700780934809793866098871631790419072054796090295997073857509063347513955345828668847/1080122695007468450990952756042336350809960886912142475267824103498571624527772461466221108513457182496170498295881911016558562932990067605104,-486676628514056352494672891872657935921963445785345337582641468345966159550808266229008989663880214516701328267852306276738451356467930647367/1080122695007468450990952756042336350809960886912142475267824103498571624527772461466221108513457182496170498295881911016558562932990067605104,-1},{-11292348080041017080289500202100999873522452089028734359126682666210493132542633253948476540332720790874157438415827632482176965461312134815101/5857294175415804484491015192979740654110311079856156585770571884304796569362731073816239251560271865393356642909073232199172962193044363415775,1278613378214084730813632046811612803086397126391227455878363853555255172641605274439572285580625635425898027514187346942043798185198651734156/1171458835083160896898203038595948130822062215971231317154114376860959313872546214763247850312054373078671328581814646439834592438608872683155,-1272223120685328949862028148305443654443217673930264639951619093411152879206581576688204780078522764024760945245431854038774190496595192915301/5857294175415804484491015192979740654110311079856156585770571884304796569362731073816239251560271865393356642909073232199172962193044363415775,2946283354889163859613399695206146022034236100552940809756712948588062820451089361133287763812506381364162976894760393150812141254268705198198/5857294175415804484491015192979740654110311079856156585770571884304796569362731073816239251560271865393356642909073232199172962193044363415775,1},{35486839106419788590707433246554138303985611213974293897857631378114410618161501074859887419369167631773996920743294768533783420813044828038828/60944632314390220732689238511120343331600596711214623159849213991901790791610182142432515213808080045658352551898681957101250321491629469070195,-93466956696005363502519942725680396029565355661401724311941562251324881251518561483767893604305517403957715859355266341929269358357875361025724/60944632314390220732689238511120343331600596711214623159849213991901790791610182142432515213808080045658352551898681957101250321491629469070195,54937104897232049640837051879246889407370344034856705765661676056385786281435565794372684392661428165905280995215976677861630646325226529611768/60944632314390220732689238511120343331600596711214623159849213991901790791610182142432515213808080045658352551898681957101250321491629469070195,-160365973098203434248782778995720005969211715071879010829104220935231983517336025883507452389473391481867279653722230886334119234664259783620816/60944632314390220732689238511120343331600596711214623159849213991901790791610182142432515213808080045658352551898681957101250321491629469070195,1},{-39841054165582326215714008878978511579591254430888200618750757718780539463847363082659815073671035225820615422830573492738621161492120550426738/33710150436185492383544446436193997324834648511344782889445704956142659778845603568928317781924284070997612828835711407572860676422174637269033,5728109367690443139685466924408093870894465686902541679457812518943229452914662403479096584162149290125420865995492583709475007401173639679616/33710150436185492383544446436193997324834648511344782889445704956142659778845603568928317781924284070997612828835711407572860676422174637269033,33476366385858267882078729613953421991726847993599401819594012611649221792967190764971730655034326616937701350079345111242904341570682401597534/33710150436185492383544446436193997324834648511344782889445704956142659778845603568928317781924284070997612828835711407572860676422174637269033,33621542911490802780289802475053155983786074780278486151911953602387458938217519536492788018918226269491119214691158859851343238370881654584234/33710150436185492383544446436193997324834648511344782889445704956142659778845603568928317781924284070997612828835711407572860676422174637269033,1},{16441086846981442169038194984584401883259855034971147640783354636665833909064697931785970875845526415488435322732422178739169254814180418856641/37625344935321011363683199391907464083800748052612838154594699705653978382032260120683718032359387970450693845829861563412910550392790997593213,29503178187319450970614147265919503913214986870450127607779715592427142292642909033220752257640372896258522053585585216986581537005319126251497/37625344935321011363683199391907464083800748052612838154594699705653978382032260120683718032359387970450693845829861563412910550392790997593213,263277724418123373809507882194167008309109973572045888192287197952289030641380627967353536666642886376986294192386719908368391253360785269476761/150501379741284045454732797567629856335202992210451352618378798822615913528129040482734872129437551881802775383319446253651642201571163990372852,19350876397950320778475452855474216816930672799669369380649347951374970538703511921327808863903602784134477372121106583392476088360866898622706/37625344935321011363683199391907464083800748052612838154594699705653978382032260120683718032359387970450693845829861563412910550392790997593213,1},{2683732711440359699991433393169321366482276701336982935871668277826074129050822517502772316776512262141911562251712906705555750265622828941/5659401904649901116662171975044617997566843477694435313852910994797353697184560104192552927916555982611186832381862957566713536851415497055,4623336401443027151430609930847303575282000427255809363067090925041906832449612886812399273424200697507130208602066447513698819065517762062/16978205713949703349986515925133853992700530433083305941558732984392061091553680312577658783749667947833560497145588872700140610554246491165,14264019047303203714881815218269681185677804124480442897125119703056368515058600727128674930204681497534242879609438249764630029809128715799/16978205713949703349986515925133853992700530433083305941558732984392061091553680312577658783749667947833560497145588872700140610554246491165,-6599316413275649056089372061814565976016796595089218946530604085961435197951818115078061115650656696042538080130243650097761436678892727638/5659401904649901116662171975044617997566843477694435313852910994797353697184560104192552927916555982611186832381862957566713536851415497055,1},{-91936063764444647663291589741521447228716730666825212137949122146004249592349133293142028113596735039713528037237869052628188193139673926252/102654784398820197066026025659525356015591617409065579364993393838495261408259221032089409141391585720567364602788575568919620351181910737493,-149183588472954884520619623086522702263935096295194128767642140183435421053566566781964532908059344212335404520560559121446732866419357182366/307964353196460591198078076978576068046774852227196738094980181515485784224777663096268227424174757161702093808365726706758861053545732212479,-185841535933304098379402679862539395098432987404711138118389778302976101883305731896738338804787594438599124624405242717064656713833778703320/307964353196460591198078076978576068046774852227196738094980181515485784224777663096268227424174757161702093808365726706758861053545732212479,-22011701414749145660968129173122846873035196935079870683198892669278963832461022338086117850160369360052231413913401354807451539165741990968/307964353196460591198078076978576068046774852227196738094980181515485784224777663096268227424174757161702093808365726706758861053545732212479,1},{-1685921916494971236418187849658406115986991529942907784845137272303016986524883430943821890104128736658142441028868396356139588086146836461052/3111041875546811585123516805564467192761884178481624532817710345788350170310819135292308377706650624858005574271391007437926241170698386309207,-4143602543622333977879090079263908240917085372265389706907630866742645398465339283632624395267916068623249912617721922095964677144800253041216/3111041875546811585123516805564467192761884178481624532817710345788350170310819135292308377706650624858005574271391007437926241170698386309207,468101206358958242037151000362290044160390186674035989211211302066117489833220084849157285320915710413420156229437930781347224232595140334678/3111041875546811585123516805564467192761884178481624532817710345788350170310819135292308377706650624858005574271391007437926241170698386309207,2516479544289335570825583157750025873106530388720770780982046651662356433209998101804420619878098461211722003042604168642723873361906938241556/3111041875546811585123516805564467192761884178481624532817710345788350170310819135292308377706650624858005574271391007437926241170698386309207,-1},{-169231316254833541842751719181075281142204497818812219853315032317054619201012074806888718043851282280459951539031207105064525694493914102562/209957320126821301950238585204902481399295533257844696064544477678177277551073967900629749082259971625694915731561638989580936347106148520059,-875495632795850291285008177530117910857002865089798911717982777079442148393792269255104668765453153753365414125067732823916795256720778262051/419914640253642603900477170409804962798591066515689392129088955356354555102147935801259498164519943251389831463123277979161872694212297040118,-6115647773921801819857357219473359342298690213958428714722861407483241577513832463154022243837507649542757598310602812218794553881118645791/209957320126821301950238585204902481399295533257844696064544477678177277551073967900629749082259971625694915731561638989580936347106148520059,991723445158825180428296097018931673505502238750704450328357046658435896305414663173134048634547061918287564655110315213545230154918704691609/839829280507285207800954340819609925597182133031378784258177910712709110204295871602518996329039886502779662926246555958323745388424594080236,-1},{5757475626430987374031916936433634950033731491692908728439065637593401690281898926072088271973151124326006250987886592805319886533630273272/8885056060066817031100857457784767126736290903565919577927311787846012686128460799563099983543319057272873237914192290643176217227752490617,-11229198273703046984048588589487125997471853946476095756243296138867185014842439153670855278868226850173139343740070342455355291740508342414/62195392420467719217706002204493369887154036324961437045491182514922088802899225596941699884803233400910112665399346034502233520594267434319,-79655306577827873080205305019713053949593975294408213052642620606846314146905366140624178407292006804061990503414660627134203071391560752738/62195392420467719217706002204493369887154036324961437045491182514922088802899225596941699884803233400910112665399346034502233520594267434319,40963274973337097056976225684090275762227910308625104803516373021932369964962133427089194972572908794802296451201017430403330028741833665365/62195392420467719217706002204493369887154036324961437045491182514922088802899225596941699884803233400910112665399346034502233520594267434319,1},{3687622132437172547946637536143891446889544021727539504146237214681641032734388739809792535308698879501367456078489621260020047499162061760/7666136194028895221526022201016175411984365990072834654764864981267779195907947719334669534064750072213490750926900653760736764051565307607,-18398580752886402254240640979180172092441346189199390536529834610370250299237336459229887980210188997346321297303474231034757862449415965635/30664544776115580886104088804064701647937463960291338619059459925071116783631790877338678136259000288853963003707602615042947056206261230428,-48016547762449885908641459890979001927150406458098413754275344490577320053555886805836068702054258126061161932575272349113402574850176408761/15332272388057790443052044402032350823968731980145669309529729962535558391815895438669339068129500144426981501853801307521473528103130615214,36491569456207820094531414001353063652973319702052223396702081984726286093879209479836347777206129806246837615762602896743525981246475139323/30664544776115580886104088804064701647937463960291338619059459925071116783631790877338678136259000288853963003707602615042947056206261230428,-1},{121473684717542666084764436092215640771277353504515667776096118902838240355173874721308180010125673158611096571734872350585062644206640304959/249163230996834631925378326575196189817885995649738813661311275703771126536334281673606565418872151973096071448862952926820064652352848666970,61611969360928554377942149300580299993904206497277564436644372126992089651056455998186559684120396116789809108869926298623647789535748922912/124581615498417315962689163287598094908942997824869406830655637851885563268167140836803282709436075986548035724431476463410032326176424333485,79490117196586661829552114793092251901334625623321921788710752477566696462213474098281810027974594877182319626105093660467306814655574374373/249163230996834631925378326575196189817885995649738813661311275703771126536334281673606565418872151973096071448862952926820064652352848666970,19649336510836339228866055451947132085268896566280550555326797985570187309419892917368329574435917265439149674542788732073843724879965499063/124581615498417315962689163287598094908942997824869406830655637851885563268167140836803282709436075986548035724431476463410032326176424333485,-1},{122809658722445414607748409741461109188152702376710076248271120533624125851638764531361518349302644745997440997899708221370426854907774048500034/8094640238974281857355879796046331772092378772524747619776062023929216541733045848878341605231979477005064188737038172813312726425632776989289,85809639337654686042589848440683410034137588810511208138224183754221878061678336602887118471008119334704553330348707438730990797811843555774192/56662481672819973001491158572324322404646651407673233338432434167504515792131320942148391236623856339035449321159267209693189084979429438925023,127985337127305444491055663901746515852719707454997502673915006292479685040348801185613528048536520649929188358981867816766583671675845862942760/56662481672819973001491158572324322404646651407673233338432434167504515792131320942148391236623856339035449321159267209693189084979429438925023,16604037428361783732442647356099280754560039262051308830938755340911628920585099222774739685543480500240880331331106042730663461719249523079956/169987445018459919004473475716972967213939954223019700015297302502513547376393962826445173709871569017106347963477801629079567254938288316775069,1},{2819751671925932588340788257312739308791210443968331204380680622130848076390022210922722970039471245322719892128787212926769778765874130303100/1684003109087364038098284520839650614696279376258596093466377995132052732830976791447889472623251387542894260876841973735541773038349586187377,-29079628580859850261402271225610509966836880045243954896430894141125897490980452368451364798574105281002257299474849203394510865696100440287992/11788021763611548266687991645877554302873955633810172654264645965924369129816837540135226308362759712800259826137893816148792411268447103311639,-7251627763116157712031058325002639126715873525748516491911627455168184715112776843189602096913895410411319098960372964206459252549217275075478/11788021763611548266687991645877554302873955633810172654264645965924369129816837540135226308362759712800259826137893816148792411268447103311639,-13874870824651088632311968757298648150861215891900978412803233793410479261846192101061492086884741930559498056945229241370188945570140816034472/11788021763611548266687991645877554302873955633810172654264645965924369129816837540135226308362759712800259826137893816148792411268447103311639,1},{2074940057276954483749685295358779173880982982454442819910133915293499221523467259588901067261120362837339447715275231961562187602955427742880/1075994586388463960531340775252531393367642074331348916877602872320686041698307675566952040736158242005828464971500939633999845938389417461041,6126945765150527932219106043851884919610774231267807081091611334012235897250972310159163595452613673462106398745501559614018709127775058324439/2151989172776927921062681550505062786735284148662697833755205744641372083396615351133904081472316484011656929943001879267999691876778834922082,-4260037040505207235985403449478550941070526167993689850635083121191972344333053801862266113585035585734528791944643527856523863518455089217017/2151989172776927921062681550505062786735284148662697833755205744641372083396615351133904081472316484011656929943001879267999691876778834922082,1131443722797599509662266177327109504968899021945590183903805292812733207596742072009549719517038533697173959733536354248559019459846908983599/1075994586388463960531340775252531393367642074331348916877602872320686041698307675566952040736158242005828464971500939633999845938389417461041,-1},{39838232926606777789391649130795137417927659000555056567126070505651125510094792492383451677550788133178896059258441731934733579453947670444/66011247422495244405038388982002372936105573319816010841789032962118056051839300836865214015900740824669516035459202484141652704781545085783,-355812268785139621019526075962609636435509580578357405462465325793876116682517639095926588922115747712117340107461183511063251834327895308418/330056237112476222025191944910011864680527866599080054208945164810590280259196504184326070079503704123347580177296012420708263523907725428915,-563659285632149642713711652709515287497522471436681922044068374544724300728784898125885420965137260975319844389557691927754908442530418798762/330056237112476222025191944910011864680527866599080054208945164810590280259196504184326070079503704123347580177296012420708263523907725428915,48695899598415976199504164356351400975221264545029462080602084881020438062995205629752966330780180125914307804785282834681229218028337415017/132022494844990488810076777964004745872211146639632021683578065924236112103678601673730428031801481649339032070918404968283305409563090171566,-1},{-10593197426537588517383511229777259077854414217539860045938205834474690380105763651974887809628287203460267245637846977558135365240909575205088/2889938076186723334468114741778711145827910471639681617445102702273563116335032162791867799330542745772007905965923703854713748062706234373825,21772788935605366084309303971288020024388375841338821065395838802563671672704839782245160460651008808578922997033843986817451183696601003073631/5779876152373446668936229483557422291655820943279363234890205404547126232670064325583735598661085491544015811931847407709427496125412468747650,-73429894282845250387815185954460341719054497080151272264547131304951539542058698039902147592526728474463402129361922256711802809431829593611257/23119504609493786675744917934229689166623283773117452939560821618188504930680257302334942394644341966176063247727389630837709984501649874990600,-2317876005431182762386938365781658270604163912901275985192623529053108296375057101694417481535224405098997769681477915300875470300050121811198/577987615237344666893622948355742229165582094327936323489020540454712623267006432558373559866108549154401581193184740770942749612541246874765,1},{-1674402351561730748783510470718695575794845019321168771434498876895850333021971740222446122054038201991012227792876098507028261872492246963472/510260977687179151962899600920126338083973995490781183654344391137086760375641465882819848282717341161894698989071361967090437644925872695127,4661302294606129786642572927449053546831930791966824092740860076268633772353691352659019329308885231148966327610423388174545947925633408927177/1020521955374358303925799201840252676167947990981562367308688782274173520751282931765639696565434682323789397978142723934180875289851745390254,-868786437547221781623955869892272841168105762817785420967284948136954688252268798992947789910211883520897268295455930213691386711278641900777/291577701535530943978799771954357907476556568851874962088196794935478148786080837647325627590124194949654113708040778266908821511386212968644,-3846454041893491915245224848322236652478577785651125268584160974656675180655838610446289076970370862443805144471352573605786467943629773225036/510260977687179151962899600920126338083973995490781183654344391137086760375641465882819848282717341161894698989071361967090437644925872695127,-1},{-837516810433142064501007201569563760742487116872148492019403439150065184889011774873695170311389153762988415031479689058774604713850771428/1402297583516726360840370327334750738189197084842538402495746518534561322939294954565928654214526275395258702277435615140475717426591490029,2248961457480297620927527638666711399148612131309216016053880332088677101438454516958973916533570131359088012190914680452772155356784689386/7011487917583631804201851636673753690945985424212692012478732592672806614696474772829643271072631376976293511387178075702378587132957450145,84998299940788622052764317200356335597368873209283848688721790763685769565068989899298256430335940103139692900342891882450792661543637109/1402297583516726360840370327334750738189197084842538402495746518534561322939294954565928654214526275395258702277435615140475717426591490029,730600409209918741182762729631686559445355328215723248812210518310649950776059730644718168431906721118535001444809761195534969333105735202/1402297583516726360840370327334750738189197084842538402495746518534561322939294954565928654214526275395258702277435615140475717426591490029,-1},{-60391181169629681289068483661329503569270777658254282827230711774749197717688524724437444248273721194156509230155321440001691753140354981360/122253965042418645945770099892495164590326491801768622715738652629649812833688233237962989226020847553667357198890744659192486951453064361379,88702732286767931114280590124731850569379218369221108207705287588128814819703920481724709149692763255876614250745649119816923199656977068133/244507930084837291891540199784990329180652983603537245431477305259299625667376466475925978452041695107334714397781489318384973902906128722758,-42241416468482145960146619739413925569267053446968152101124178632120608867671175220217572312841556052445014860784809550286965898072425696301/244507930084837291891540199784990329180652983603537245431477305259299625667376466475925978452041695107334714397781489318384973902906128722758,-75686696782468659970000133801242999581650685844883707056677346988914580986198832327136279818391323205953253968914972358507267988467589840603/122253965042418645945770099892495164590326491801768622715738652629649812833688233237962989226020847553667357198890744659192486951453064361379,-1},{-2786137707195903095563002570495266680901483125734164178694725926111521353808170313672314844894583380774082931410898817882728344310854904229174/3107540852004915319821881818549246218456735432226976432057504445519828314733686218725319223087999378100432389287409636357035892567561103195613,-1282151660318173666597214161989602180142825497423187127384972936504335047175844771884420485385207017792890845699585089142006410032867925073024/15537704260024576599109409092746231092283677161134882160287522227599141573668431093626596115439996890502161946437048181785179462837805515978065,1922547470649869827191385345452312557583799124282909122745792512937120032778807926151279168991032652988733640623047807881057316391891108950358/3107540852004915319821881818549246218456735432226976432057504445519828314733686218725319223087999378100432389287409636357035892567561103195613,2187246004545174054043223475898693934296232145242867032711881857357317186482380451917425603149176759932254761305510334305312595952894600471308/15537704260024576599109409092746231092283677161134882160287522227599141573668431093626596115439996890502161946437048181785179462837805515978065,-1},{-906073881055576516249775406846477633379747007414245812451421667701445065549552562450354746663601442067174349850903878441311623752072550987940/20649560463278495659183955724121224077142951822895361094073818964499769416240304958276893838352952546049226766623289096579947785737108623976783,-19912217236440083294153721967390356975639802137589446943762439073847986746672181176089458861354103599896164515061139375333655930791129556478768/20649560463278495659183955724121224077142951822895361094073818964499769416240304958276893838352952546049226766623289096579947785737108623976783,1153142803859482952468028625010872443012783308668216537946866593273037094676506330062504621682426598438235217057818906218416106391492905839746/6883186821092831886394651908040408025714317274298453698024606321499923138746768319425631279450984182016408922207763032193315928579036207992261,4939305072470116486746916078786138548141959363361838008215952212414246989739812713870532927601181810341245616366638244791540599869706470835348/6883186821092831886394651908040408025714317274298453698024606321499923138746768319425631279450984182016408922207763032193315928579036207992261,-1},{87944786867165401051536103215413689474719673921770566099381505121630489360799615638879843562108771461172558519518930223192789251207433225027/91071010057132077559180260608661574830550964795565484461753915461029054566183783778744762795032711338379202901668338634238337524527086638657,8290269769121331390450368841539936778831562684549119964959469109016750198501933701961727962636591669359394544179686881553711744616259117378801/4371408482742339722840652509215755591866446310187143254164187942129394619176821621379748614161570144242201739280080254443440201177300158655536,5925182235985303172547220914593776483334470263876539445087016723468321385024820590334871694868105063191740965310356506803611702096491484132941/8742816965484679445681305018431511183732892620374286508328375884258789238353643242759497228323140288484403478560160508886880402354600317311072,1560412472814927027096334789576201929916898827819607467552383812732926154335887515568993097357770095074214770304709082376025375805431044308519/8742816965484679445681305018431511183732892620374286508328375884258789238353643242759497228323140288484403478560160508886880402354600317311072,-1},{156020929967413990919035494705324650694343726524206550372500510279373877317319212770275068394846022556806677389932293434886799903076878304952/23398346882970590727319341385745453060134354629725934669693861588179557156017390195876426743888988687372968468606247491257607411555614223101,1991799058511199365717576532493000446645560331819323163436238766520823591015365489119007096523132436708940041799896174613944051615634651354970/1708079322456853123094311921159418073389807887969993230887651895937107672389269484298979152303896174178226698208256066861805341043559838286373,-1048487963334096246768560880001761020825092813651252255611358193506198026877369682618255123195461505082323751615454968303778895531763609031288/1708079322456853123094311921159418073389807887969993230887651895937107672389269484298979152303896174178226698208256066861805341043559838286373,-618332334445175729302342531556484570107792677554215314183099010122685278058670355736046574591914944646722921084763637143131930168656252295013/1708079322456853123094311921159418073389807887969993230887651895937107672389269484298979152303896174178226698208256066861805341043559838286373,1},{112284319621912947876735095527436976077983479087562327545942407756764719267231456985667979931308449601940845593289050215311012906473979810809/111858193925683966386387645838655901236126291319764803181001152986780597102019594009335062286789468426346859552538369674584972507051497973530,100187601540698878295759396346875073012786323387866562327037617476244384719510857172704346246637678921548999701750894713689308185153774538854/55929096962841983193193822919327950618063145659882401590500576493390298551009797004667531143394734213173429776269184837292486253525748986765,72229960406753474148929223248879537235012603425642645144909861830234623446781139170257815312717314462832764320644597177763049924259166368873/111858193925683966386387645838655901236126291319764803181001152986780597102019594009335062286789468426346859552538369674584972507051497973530,11491482527433357212899101384019889032223723449298750401525858913491920616752184563121768966413006829321419908437579286375968287328512055104/55929096962841983193193822919327950618063145659882401590500576493390298551009797004667531143394734213173429776269184837292486253525748986765,-1},{-724432709325732011268183505403677753929755055676986358958645195603424132366887199198224354313007726152404542670776230066795380596678967725360/817428152393553009906304537102790664335345688633331311750934043695791711976232941874727060672446810589564774155429580930552924866600678203227,-496900709390257993439231361286481682400503066089028801617248251893524773590775903506532428804311077275143704376474938659215433917803885108790/817428152393553009906304537102790664335345688633331311750934043695791711976232941874727060672446810589564774155429580930552924866600678203227,-851345834337380584520904162998306360841704847768737435919295383250533182565283730801561554151198662604361934712233888594419844526225127341501/1634856304787106019812609074205581328670691377266662623501868087391583423952465883749454121344893621179129548310859161861105849733201356406454,328438946108560071848513497293552875068898425489143275493243534566877659426780364718451267342589126282672924219112458198784079107648269200453/1634856304787106019812609074205581328670691377266662623501868087391583423952465883749454121344893621179129548310859161861105849733201356406454,-1},{1977164581152894619648588547819158916630931160960937414525273559800430999701973999063724010690526530354140987058648440179009249448726683456688/10732406810858772747542179635689215928307109208937705714137327190356817819225328033065967261824720831557859700427375945242012512926568538081867,-31806000114840879302083868708285327780307398080625500019335498317595133019988916108000007123261636945981284632512358580194799549893064706538955/42929627243435090990168718542756863713228436835750822856549308761427271276901312132263869047298883326231438801709503780968050051706274152327468,-16225114979324144413378347036932852550687336038357514299641108939349231993590732735709958419557462424279425447122873159943720961102814839016081/343437017947480727921349748342054909705827494686006582852394470091418170215210497058110952378391066609851510413676030247744400413650193218619744,29075119182930811552526315884943709843903032683144307242018690821796126996407650417706309788370912069575017320653644374539343952375924488248031/42929627243435090990168718542756863713228436835750822856549308761427271276901312132263869047298883326231438801709503780968050051706274152327468,-1},{278085609831842656995374385370202256274665468597277622145077045748704297203685152340441560432511507775236317536995194247222358134858865037460336/20898682883508025412897461187228179657568299259782692117304844063726136644903448348998383206654214963938189824443932583195664432675073492041191,16997234896800682633448640153710546995252022923972282414090642925050161778352755414062605197232169613978683023755289737217383620530550228362768/20898682883508025412897461187228179657568299259782692117304844063726136644903448348998383206654214963938189824443932583195664432675073492041191,300244817597162744070907862843983837094210795150836567388530604359493931005926605120431891264784997443645472032839816169231155615208136530309682/104493414417540127064487305936140898287841496298913460586524220318630683224517241744991916033271074819690949122219662915978322163375367460205955,-416230090784272655754200683927736103798458157437751478539281319169172288196718243296713746765985046777732656489851327258776844047557353600768896/104493414417540127064487305936140898287841496298913460586524220318630683224517241744991916033271074819690949122219662915978322163375367460205955,-1},{-5093413317767877840520742774270610802038263135903083509962223835828816038321508417550351119228826040056665501939379983799067022998619953146494/65291171438249410844531763039758285077474916363160791562603605555695025880898937291125953132290301976114412444192369761205337728913718435605711,36807842885744645780745745598864571323592792239343959008263186281291683882997242443504640664610530093226879943711567818523207147220372992957344/21763723812749803614843921013252761692491638787720263854201201851898341960299645763708651044096767325371470814730789920401779242971239478535237,1857334142906070315537617390062610382342855863297060332247685303872519843947832330842275779490727280181265547830709159882061855920292548635921/21763723812749803614843921013252761692491638787720263854201201851898341960299645763708651044096767325371470814730789920401779242971239478535237,-13668285143664993359429516541012624419993029023683360431664864732536922316800558471888972111039510954778341051956677373170520772275300298742896/65291171438249410844531763039758285077474916363160791562603605555695025880898937291125953132290301976114412444192369761205337728913718435605711,1},{-103332619846406573088659544996402211470023501953769885972995477936009075400177394231060347708540526925515471306669719493266328183743858289574/104017005282922687192409860875851721711319122122883436185771447014551534927189790230243401571541431266972449246788923742234092239529153559313,-354048810380969427594389072226392959644642722228516059828676880059502728279742116853787249729538300262861604063398719898514888197596305409097/208034010565845374384819721751703443422638244245766872371542894029103069854379580460486803143082862533944898493577847484468184479058307118626,15001922682951888741320117609027483413612733800132695484887994598234489100070481424629422770949245926947961249710231863477824778081553762563/104017005282922687192409860875851721711319122122883436185771447014551534927189790230243401571541431266972449246788923742234092239529153559313,222992326184652077712282649863418921460262413823789514162091715469300840529865110236987396715533481813597923908065131325351886959169131764843/416068021131690748769639443503406886845276488491533744743085788058206139708759160920973606286165725067889796987155694968936368958116614237252,-1},{-151976726046489631166796915322834785335991819409311922431179183274021217531414776896395871941237005819728344427503107623662950840646139161280142/56368269395254212015598086481264048912257527561031920112380361759010558845641237116711136791501882029136815760932852122812408037357526863948455,-152329121480612285321569486882034499843289409714523193581718448746872953968938385962361599361080834012884809169021308179905686246506556982876992/56368269395254212015598086481264048912257527561031920112380361759010558845641237116711136791501882029136815760932852122812408037357526863948455,206478472208968893144604864649287831222227730050613902678906597633226655749862402866085334772727715171640690635914415571177286737201369310373358/56368269395254212015598086481264048912257527561031920112380361759010558845641237116711136791501882029136815760932852122812408037357526863948455,-29993716321233635574176463203307165377284928476631620431300646447407726669003444649922953496785071756633994169248611942134311495480352107363196/56368269395254212015598086481264048912257527561031920112380361759010558845641237116711136791501882029136815760932852122812408037357526863948455,-1},{409709111531485200681795104101799119902061051934199759172329118516664256317074700197883128015825565559882502601365859026495029248840449061/1874832530538981258401912052475826198348374831810210056429886445898574014880563490323669906412073879013625982313627553038447048494239512407,57526844643450927407431380519351495657766118558388082100343564379414371119946347352978701869442026800817355442908276861926516699073976932338/129363444607189706829731931620832007686037863394904493893662164767001607026758880832333223542433097651940192779640301159652846346102526356083,116129872246754707862867682546079907968084008132900865046530577013730355699898488617492541958945645589895585581598280585009791278040338144201/129363444607189706829731931620832007686037863394904493893662164767001607026758880832333223542433097651940192779640301159652846346102526356083,-47068446983688597051924493683148479463727187329039443978077168386294417497020940102411821876466812397165938703581781684007963070753869779594/43121148202396568943243977206944002562012621131634831297887388255667202342252960277444407847477699217313397593213433719884282115367508785361,1},{-173751296513396151911519377217417074115998114545551883693710692623127964099069631957860658716698915511756555926186728617106612779839159421054804/138994591352484576384817336506106593880285204409695801198758625749481061620619237398279916759026106401702939872587370019147778509473212683136557,-220323139916937460570653293929982913124431353003046034035352321238274283525257812708390490914967600972076222110521300011602426371164857177299712/138994591352484576384817336506106593880285204409695801198758625749481061620619237398279916759026106401702939872587370019147778509473212683136557,194896545489910986506141515392777980223623871071381364693575158926621260657076009005167430151162263800434532357668874819039826743202419902564624/138994591352484576384817336506106593880285204409695801198758625749481061620619237398279916759026106401702939872587370019147778509473212683136557,-26329614239625857838882743737252542259041698429090541918345042383937167957975037494263414905171947140512076701535489623655638281376180157241332/138994591352484576384817336506106593880285204409695801198758625749481061620619237398279916759026106401702939872587370019147778509473212683136557,-1},{119558112067218090423223467353672405976590223332922967780331715041612636221353121400099884805555018002368029121091856715919409864078470958541/326022065921993480269758814425948511404857790207216766587254879198344190695262917214174744251535240443754914386383227601397331583277256329646,-1249213755623799373842193976373985807548560044409389147637327645455980281208867886169216150279497592595031997430678257396054300514852559057773/1304088263687973921079035257703794045619431160828867066349019516793376762781051668856698977006140961775019657545532910405589326333109025318584,-8359647498621698897953127346448847920536865792105878582756270809134912872465389391857941120886752751443450996240314499961043622067391548785/5525797727491414919826420583490652735675555766224012993004319986412613401614625715494487190703987126165337531972597077989785281072495869994,601026550889954182943548325452934562093365723861916642568840780134217221113226039977141115051985253885417534919077500659311706129851037225045/1304088263687973921079035257703794045619431160828867066349019516793376762781051668856698977006140961775019657545532910405589326333109025318584,-1},{-24730567072901705616113960397682865356173800444111253211214191615086308876667298647992390810408209273644300211199757867492237794823866871596/7816260462133817216319966713014909950048986116734528729944223618443687211353637529749020376875394406903280984162237457910418444528251635558003,-16009019818854007461077102802271854273685605635658330322871361194273415468517926320624918623310786245480856257720159503923119746173541067120/36696058507670503363004538558755445774877869092650369624151284593632334325603932064549391440729551206118690066489377736668631194968317537831,-1497519987851633466201196979993590337542394280318889102173495520258753845350207566976840544057730610905149847535800067438141263802765642421848/7816260462133817216319966713014909950048986116734528729944223618443687211353637529749020376875394406903280984162237457910418444528251635558003,-205763066720005467334598413820462461536575820294802867159918542344066395127060757927017578864398288898520214023695039679982902713617433777148/7816260462133817216319966713014909950048986116734528729944223618443687211353637529749020376875394406903280984162237457910418444528251635558003,1},{-121704111108330143263622117135329075904510183644200360136182404534602209055411616660565953194010175790969455096344526986651667333808929320028/206347650097297348960596874442144459901978025053388110589119869941863259848429000092198074267155450683698609641298095214047889642186412704399,-1103780479791184003074094361868189557433517869040034982432503646434162184579795610792228047106521569389111158845974141174587092318318945384320/2269824151070270838566565618863589058921758275587269216480318569360495858332719001014178816938709957520684706054279047354526786064050539748389,-1009564213362849468348514894671900350578191182559390114273396174482761255145413712883308144539811579171048655895873630034252258506364655005684/2269824151070270838566565618863589058921758275587269216480318569360495858332719001014178816938709957520684706054279047354526786064050539748389,169353607504781810330292750185822640716722890453816088185130825981083473482273760415559146164709337852279706970066079439904814214410052930916/2269824151070270838566565618863589058921758275587269216480318569360495858332719001014178816938709957520684706054279047354526786064050539748389,1},{12691519377289433402452240227408603995976485912007526623248842263159483722858054514851264468428796533731530446116186938675041401725659509708924/12928312976824460729825093824195363317271218892561820431226444468686638108935745148084875273834262448082042604002843390787483281518775608219015,-22328515032695245612968515673966338815062512004431361053386574579049689640202464746651765823685074092826406658003491652437178382087714690158564/38784938930473382189475281472586089951813656677685461293679333406059914326807235444254625821502787344246127812008530172362449844556326824657045,-21028347641799881682757124817076481477468765997967864885735950039005493705626683749092346780525975983619099026160866886001161320780405024810666/38784938930473382189475281472586089951813656677685461293679333406059914326807235444254625821502787344246127812008530172362449844556326824657045,-6636027287407630331224572841872087213649995788204113344890853204312495471504623582119712729578110975986732455717389716998492748506693444853672/12928312976824460729825093824195363317271218892561820431226444468686638108935745148084875273834262448082042604002843390787483281518775608219015,1},{5027090221758993992993726244466118181807331367438271199017281290118083204144555411938557539385568006644787216394541741970811092044348002907692/1523704617735992052914320939408261755222588488435705179243846485120529766099055235553938603831411152143649299946480608562669352466447546747685,252112449271328890457633323314197642767705715144723181688661916138219594835300191336803761258232030265011020829369758176763147135263646480413/507901539245330684304773646469420585074196162811901726414615495040176588699685078517979534610470384047883099982160202854223117488815848915895,-210071150248624258418124113300768728613622253820947563021322221577053653625908529664130708670513213110001356729623642547700772446868279430204/507901539245330684304773646469420585074196162811901726414615495040176588699685078517979534610470384047883099982160202854223117488815848915895,-325234116484013301475513661265849345884161904084173102186954775410685813828088647828305199503566298316505816687076912370617798944371564659574/1523704617735992052914320939408261755222588488435705179243846485120529766099055235553938603831411152143649299946480608562669352466447546747685,1},{-418191965847363167131554072613408764106751190278036981979001956514294388495160116079848544469504556850636746485649816522592537670096513200608/11082695254848789677560287656185436705337211449968707025274253501383043237934838841403278589308957143813368557005955308351351103460181608300623,11045530099328563304355867859326895742785315836475184647455962635790267739988359295352199036486227734346008549158094053672675944365275008330445/44330781019395158710241150624741746821348845799874828101097014005532172951739355365613114357235828575253474228023821233405404413840726433202492,-33106328480424707543861121670853574434426666657726658706345106838585591760207135051448244947671577632502638448470501560003174159976796669392743/44330781019395158710241150624741746821348845799874828101097014005532172951739355365613114357235828575253474228023821233405404413840726433202492,-10958501193304304383384719548962149641154772381473790373088202710391529800905504786460027309938831784127549830113316369342906114099495216047688/11082695254848789677560287656185436705337211449968707025274253501383043237934838841403278589308957143813368557005955308351351103460181608300623,-1},{-274762197498483956749950350175103017760109073239419790975198729346108085911379872653392506752428219229846938984659624972574847818386423855522/263458222387080740953459835944870665017048519673803788379983610392939541241631801890970748701333412953589554735201927557981612621973700655697,-929159249913747763187641940215817603173901138180624007892329703095773368482055758860303675839204410025035370126195136650132827350243142795933/526916444774161481906919671889741330034097039347607576759967220785879082483263603781941497402666825907179109470403855115963225243947401311394,21416282011945648952780356007952453381987036395611985720074554670926587202005898216278370896590047245839921425487844812193550880075259820523/263458222387080740953459835944870665017048519673803788379983610392939541241631801890970748701333412953589554735201927557981612621973700655697,277616396530370691883526154531198545923902973731105390228349690935129505924312254437418518803711286140962477657936640615911602209621086246109/526916444774161481906919671889741330034097039347607576759967220785879082483263603781941497402666825907179109470403855115963225243947401311394,-1},{245433107991199744469922204947357068647665443438124270771691584086237943931195664013590300282322955193601515736603382972670018649473227446583924/36221464791078878690227286304902361998244227722435020059858051678649856692190297966269326721274457020444159125645528660852664675336373579238569,-112346409731162186621205117275167928071732391031555633052828358219245470065409345462481377495920675791332586759503506921933617923708141437336652/36221464791078878690227286304902361998244227722435020059858051678649856692190297966269326721274457020444159125645528660852664675336373579238569,-22655602840441937706828532229850935984194883258761630531989023231360146383471415547682096190920501267154155191583681037597989226065001104009760/36221464791078878690227286304902361998244227722435020059858051678649856692190297966269326721274457020444159125645528660852664675336373579238569,-49830637516904209579300625276086424350188795054379441020572054038578067459328585619901330633739901095802895467215398116659068662441292431649056/36221464791078878690227286304902361998244227722435020059858051678649856692190297966269326721274457020444159125645528660852664675336373579238569,-1},{34458006892897516071604589918077450560147954885099732375947549219042825830360986336891678682293229025468719613298352421028916166247629064960/86321869708116134761119060760059904772145898413447748592307435355246702712697271655173765993981052226251241904361372963870107925895423239243,-60355218194872209949090888805554808894527882990196515297090447019274529647815466093810410229372571577019636536820994132228220545622282408997/86321869708116134761119060760059904772145898413447748592307435355246702712697271655173765993981052226251241904361372963870107925895423239243,-111245364612899405511504464697879611894088087877623097334613201555148008615033192177879054845817886661600487215562351216666196840722720418654/86321869708116134761119060760059904772145898413447748592307435355246702712697271655173765993981052226251241904361372963870107925895423239243,28626334146733594137698730377529695703341705278341673006047291821702471307958431812709708451722275120238710491669760486027553946754326679585/86321869708116134761119060760059904772145898413447748592307435355246702712697271655173765993981052226251241904361372963870107925895423239243,-1},{124920491000612369105512864108121880364474860007430375393987390212408871388078410426040962810898205062003324822637980978157675870998720126768/487023584736386550364440302580223725797612289790221745646969752629542880175419399253447329440606847154943047997428789480920523470416525023219,-188655478185755852593946494536583502114659862511048855985142263623106496082996240954389138913455891105506294824751688147827421221170455254435/487023584736386550364440302580223725797612289790221745646969752629542880175419399253447329440606847154943047997428789480920523470416525023219,-249938554736135492967436497431723685793582582657597447277434586887783467547368519111440474468567284933459785605364630216008350129925984250155/487023584736386550364440302580223725797612289790221745646969752629542880175419399253447329440606847154943047997428789480920523470416525023219,-959345894855470487953959081260628283115898650670709721645205359337218738850511628008578608533731575879276843998583964644859277525912964223211/974047169472773100728880605160447451595224579580443491293939505259085760350838798506894658881213694309886095994857578961841046940833050046438,-1},{273286970368435099956394450544235725799875784728991029230735519989679986248065630929807342401965698194924334665352557936520725052283424041472/539181529265841568865633677225748259328038566130695491530653584438545447806820283267703166510814160859323212555821597918381092670973799063067,-159414267042316861698701087665831347506010875309833171811921657044337469483409585518987291876232172875334278850318405446780473426441820522189/539181529265841568865633677225748259328038566130695491530653584438545447806820283267703166510814160859323212555821597918381092670973799063067,-477672978050021652455868714173298656749032140543607681700780868238220357172915798679613368066667358944804414681004680669514643952538840150383/539181529265841568865633677225748259328038566130695491530653584438545447806820283267703166510814160859323212555821597918381092670973799063067,-23377539236519582271411833241705002346769711798275428583562008545271189552099205314948508896722710410050706585037647682377304649647561331383/59909058807315729873959297469527584369782062903410610170072620493171716422980031474189240723423795651035912506202399768709010296774866562563,-1},{33909927006368453354177168968851189838187071892434693347300900584815290857830386412079822246529117487434578265638784217107161713994694458724/63153393396255577887032796743829135804424439305250467267802279982033834694491711224556033674620207018118983923166405125017943529867045814137,-51025249097905304959819538140408868112994554397731292972697276196407406070500191746317021201597973359770037968126800134400403872682333489402/63153393396255577887032796743829135804424439305250467267802279982033834694491711224556033674620207018118983923166405125017943529867045814137,-4361265094922390441071795986673499330831015453491586829500263445906069568634263037795968844864584828587529606615804936159708292232122712584/63153393396255577887032796743829135804424439305250467267802279982033834694491711224556033674620207018118983923166405125017943529867045814137,-254359917357053694855687660539053441440554778737840808139031954113618678001121695555158230044516999743738350756865119723247699863200669699401/126306786792511155774065593487658271608848878610500934535604559964067669388983422449112067349240414036237967846332810250035887059734091628274,-1},{-98251065665466760564910457506522762842310970789621725220272540151646978409346449235732332038882644101541466743165970272368426166607113592608224/315718739506273073869439409553230543834247319050091419536011024007668143774107791536277852998363526239274203554397640480874564984452579308662323,43552845472457324459463420510691063063566377073500367647652221295216028793128079242598834743605706807041682301903767856409649461997626900571872/315718739506273073869439409553230543834247319050091419536011024007668143774107791536277852998363526239274203554397640480874564984452579308662323,52267726192206254089328298214739842317306050333098826697315299860821589830999005541720588926547131612960298382725466479795879007741760039036876/315718739506273073869439409553230543834247319050091419536011024007668143774107791536277852998363526239274203554397640480874564984452579308662323,139136990003842978081956987469777610767715015037552468624122112540339335616134904773547348213348836400489500983327676783210160305151797363710916/315718739506273073869439409553230543834247319050091419536011024007668143774107791536277852998363526239274203554397640480874564984452579308662323,-1},{4206757280999498841063700188063155113148439886325058343052926508171457704562292910435489918485113398579000567767928924841584608113362213797595/8197701557869626605681098953093737735584827135990759631416184868453111070162051116455233587893897816047673496032303281070222195580902340934346,17220519207832417288023635897247737063265479420880042053601620282774172285646793913230036201557042387611874866540331665328278524942359635275304/20494253894674066514202747382734344338962067839976899078540462171132777675405127791138083969734744540119183740080758202675555488952255852335865,36298929069326166361866953682205333733120170611813655545484594598929615083258300967706909273062837273251824923214770314661612234306568231539947/20494253894674066514202747382734344338962067839976899078540462171132777675405127791138083969734744540119183740080758202675555488952255852335865,8711164539823193201008367473259309278995241702765483034494215357010968368975347057560585156093352919375976834512846680546207691429131547191954/20494253894674066514202747382734344338962067839976899078540462171132777675405127791138083969734744540119183740080758202675555488952255852335865,1},{-813312227172758909331192289981671169631478926415119627477786054690343358020039091400091076268995075713651487383671103527174198806151305094080/972367329661706389261901906225481971120856600276853850481384716493375587977992322251879372354680247796541064903099288734756206550814175813287,8276798361988154160070897368670137892223440429653076151281504076914837968761283847851663147316493667931436214592746727590168155860321406176481/4861836648308531946309509531127409855604283001384269252406923582466877939889961611259396861773401238982705324515496443673781032754070879066435,-1273181332402405130474824178263604283648143531567670371273032630202216050335996541082580684418311248712911181058047948062941457912622444951289/648244886441137592841267937483654647413904400184569233654256477662250391985328214834586248236453498531027376602066192489837471033876117208858,-17670434539070979997108823531960269792628975030973456925360089378680042935673304719964674616357122756084919070024270043153754855760390123598434/4861836648308531946309509531127409855604283001384269252406923582466877939889961611259396861773401238982705324515496443673781032754070879066435,-1},{278225599936585335163229425236302361747940953170769741921510905201052769098213205396387341432834132790179141404817036462639908152228614959072/3874807334540051934230415154732798346536977304058949118233268841350407442098036584620490787933454441310304158487337010248224635520018698218515,-6957998045672946586143027720704133876174093486234627490573940531341440468812930021830384639871491785106403916299484382005982613160499497567211/15499229338160207736921660618931193386147909216235796472933075365401629768392146338481963151733817765241216633949348040992898542080074792874060,-14721170457448995008833737996502663453267361574972798018290288958998183058311308114973359105237875934955856840683143107935798511642740965103839/15499229338160207736921660618931193386147909216235796472933075365401629768392146338481963151733817765241216633949348040992898542080074792874060,-2992045841146547707236000312020684683127424742645257470729900536941951647603769636168114341311652068787469319544633184626062335604967906773193/3874807334540051934230415154732798346536977304058949118233268841350407442098036584620490787933454441310304158487337010248224635520018698218515,-1},{-27119514293674520370136160658510127618938814684276316715373327042807587284008701332743297560646200562903264268075794528983039177258536768701279/3272865254871612306642710124393310772035114068690136678743469780787435945235171470140429353907590804893359037468132136321170329680372030720761,6649178512245117545208949001415280079800076370820870792534366408325986332254591701695106823117367082774146856028659725171862530763634049216868/3272865254871612306642710124393310772035114068690136678743469780787435945235171470140429353907590804893359037468132136321170329680372030720761,-3872721196373217506638138377980055376928046956686459335184018137603458147840977717311898075990559343184546951170033013820480494208705703217947/3272865254871612306642710124393310772035114068690136678743469780787435945235171470140429353907590804893359037468132136321170329680372030720761,5009976822258860014682011168276009729375476807297260476015184686893816060220521753941245208331954613707299362588991566573049691829840265237394/3272865254871612306642710124393310772035114068690136678743469780787435945235171470140429353907590804893359037468132136321170329680372030720761,1},{177238758026747396925220533955497177363226534427264518873627321157873848649978470691751461603892568967616961478031546830779614336810825723942/281179441590461229339504006139207697146353093266306159726097825060047968081189568781460063906358949607118872118992787193929173664557539775723,290673340145789890178830731053115443908572713350113034026458448084794913994340510579746160720905688728977027488127696399529687814167652922018/281179441590461229339504006139207697146353093266306159726097825060047968081189568781460063906358949607118872118992787193929173664557539775723,-3943676170261358794363162037910546492604237655543635199724305925926017709240086271987488791553597423005849897048343395688050926119648306028063/2249435532723689834716032049113661577170824746130449277808782600480383744649516550251680511250871596856950976951942297551433389316460318205784,-473639530600302865338200515555261188535456682735466727215506102982303456462791549252076257578982292798609411751573568384544075059021066691449/562358883180922458679008012278415394292706186532612319452195650120095936162379137562920127812717899214237744237985574387858347329115079551446,1},{-2655616436315031017528555943455561769540360673129562500145839620147573788263225108235056795635481815478165269019005664514625357033909087019488/1285013486264907801345296258983309132910588130424850909513056394382734966265136611835009210049181787403509225863853255079144091648005203550467,6763083139977580146819170194285822658770800687669123361174788898446181959268260593984498483392297207836455573544268061160292401708350767768301/2570026972529815602690592517966618265821176260849701819026112788765469932530273223670018420098363574807018451727706510158288183296010407100934,-28523459799796544206032167501626067026150217629426689265268843247599500295710706345514871400439346023287299311256585768892908737101110241448321/10280107890119262410762370071866473063284705043398807276104451155061879730121092894680073680393454299228073806910826040633152733184041628403736,-12893355771974979067522634987156010156528752435425612061164624279205980820192002016912333249738295398369756540601731714016773029288131866532843/2570026972529815602690592517966618265821176260849701819026112788765469932530273223670018420098363574807018451727706510158288183296010407100934,-1},{-4625431714958429227833932438374801327683224178081545444265090767831564686635476839146371127118923855554619906190034875023825853521729823647940/3306861055416480133001978450251236535326671564769942724318075562449722247254172645272513074682235594517188719516857236207869146345975795000547,994421913717180598520655235313407872486336320745014803240803804052357440806106887518398243145972096011561661871567940651962703028029428641990/3306861055416480133001978450251236535326671564769942724318075562449722247254172645272513074682235594517188719516857236207869146345975795000547,1993302884499067071868160763436870692697459009043682102083243763994444339071443573655409802689075050923634673530346189114527543294147817279617/1102287018472160044333992816750412178442223854923314241439358520816574082418057548424171024894078531505729573172285745402623048781991931666849,-5550327267989764045940739841250249718607664656892945190021596662260281528837366303096479027511592739061072491932525221336664913747473182716796/3306861055416480133001978450251236535326671564769942724318075562449722247254172645272513074682235594517188719516857236207869146345975795000547,-1},{15542689946665469694270942598400151224489523491172431710907540958727019330823092035348995117657927285873163601502207512807813909752089424643857/55672586559899272786575952258058721482832940169598696635595129783105652512813570475061839264457025393956566679172472615691893878331625574804624,-560011021039439467323037029765891486061409610284056453585188878122221919949560291946903734704931360783232002845919905108695522873215500787243/1159845553331234849720332338709556697559019586866639513241565203814701094016949384897121651342854695707428472482759846160247789131908866141763,10834709805192847651943334502780349187425122213917369517538680785748423759713533246937197526989697699870401815941714885708460128132254326343939/13918146639974818196643988064514680370708235042399674158898782445776413128203392618765459816114256348489141669793118153922973469582906393701156,150931666451691473770185326294828700066101476660308558190978162010076977289955459551251377384678459087574575214109289638117020113839061513388899/111345173119798545573151904516117442965665880339197393271190259566211305025627140950123678528914050787913133358344945231383787756663251149609248,1},{-236362869669713775515001994515506854608103317043074603404326279212230715735455471609193713999393171606535678054858447503583249640191588081959/494736410616905529391014179458238917413663750171587536316358713326568695227749567597050871732845068695385746931743320199449793686716677708583,8811415055181736522387558587819362368117812406384889500042668909914267674183063637928796735927074215538883353378277326130429367937467398855771/4452627695552149764519127615124150256722973751544287826847228419939118257049746108373457845595605618258471722385689881795048143180450099377247,4989732442971891958114688032699198307334208670853889943856347396856271229212733165171672484203134289234662869845284829767138579627367418054713/8905255391104299529038255230248300513445947503088575653694456839878236514099492216746915691191211236516943444771379763590096286360900198754494,-6220058989736031469148460006122545400975694245459288534439831454037114041751143932076126756569304011705819421096990240181130359422625131043956/4452627695552149764519127615124150256722973751544287826847228419939118257049746108373457845595605618258471722385689881795048143180450099377247,1},{-33224536306969338282470777141976182556422250970969895122424753382425476898841870797134197466232311589433464814203178052593203915382428352940/31873433250808990467479676794960803587498951148126871061587740261629228609667926533455208353690660476170021226740442525055638447564574330953,-78074843993703104051895447500864670614088331872211914401711474156466023751070195638165268421591823677895449061807172184384507849061747122288/159367166254044952337398383974804017937494755740634355307938701308146143048339632667276041768453302380850106133702212625278192237822871654765,-15634856378534865616952078838256723853715096315354698032573219397234585204246950319940684480545745436762918546205202920504386474159667059114/14487924204913177485218034906800365267044977794603123209812609209831467549849057515206912888041209307350009648518382965934381112529351968615,45527596460411292596398968677142955367283913861041077206388262442153175184935348451200497644860849465068447623040090505557688373930807249308/159367166254044952337398383974804017937494755740634355307938701308146143048339632667276041768453302380850106133702212625278192237822871654765,-1},{-26153882329163772069767756258437032737963203610430677258046877436442163141133928039172567050142802505932253397916575794506831738255464622785216/28805654865877429705825763253617656477753884138813703199289340027215222731918054558150452855696888021311205704992714654099363159598964671731019,-22579625584163571557188544175052539834484968572540050968238179196920241883393387763217840871441339439628711038000973455076538345676967999940032/28805654865877429705825763253617656477753884138813703199289340027215222731918054558150452855696888021311205704992714654099363159598964671731019,21357919846382540818723327181650618876373199386225300684075414994564554944911435300897279050808722385492411304149973109568878351839374428419846/28805654865877429705825763253617656477753884138813703199289340027215222731918054558150452855696888021311205704992714654099363159598964671731019,2414332129568497040472624408648250689490860439172734556041815437688354940485680392240737514850288085373244178743241313561517609078864871769832/28805654865877429705825763253617656477753884138813703199289340027215222731918054558150452855696888021311205704992714654099363159598964671731019,-1},{-7006410409540998293641974789970708859363172918922954196093819856975230285464052361329782002446820608107702143645236214493626983847785431613216/39174737426057411323502745071942794367239729742620612961300802283074707331994999906203142664166858190770207580828503846271244006005521360100487,-16885953575805668641002227316550525638403880407567943773630876284870212396314318821439934319549076507467266628298948126499928233792543521800592/39174737426057411323502745071942794367239729742620612961300802283074707331994999906203142664166858190770207580828503846271244006005521360100487,22887352732345085160478333877765420172302284257402687552863201183253311789788038956670949403527051488157769290758675089610186550270111386279571/156698949704229645294010980287771177468958918970482451845203209132298829327979999624812570656667432763080830323314015385084976024022085440401948,54218478096607853601216377351679125630546326870729954060791194613704842033651184595339387123857173665986286563191039660901561756661295502048963/78349474852114822647005490143885588734479459485241225922601604566149414663989999812406285328333716381540415161657007692542488012011042720200974,-1},{-18838315928669604440160832700088413756344321783787797540914527637486214051150183070276587431966843797182575040579853839636333440443209330436140/36062053845739390970065767732019106980060104246341754215364292439512044193069748198855938892812880696029559685855168875752288072160765710041437,-42718253536657592575580767177030485957268661340591745071523972621435277896435485861966187574473907730305171211240776915523852831240309636522604/36062053845739390970065767732019106980060104246341754215364292439512044193069748198855938892812880696029559685855168875752288072160765710041437,109244769137132500105498383645295160931808623368094180886536973308839826964334290345493634377239971174525480497556274206595793297992023519393691/288496430765915127760526141856152855840480833970734033722914339516096353544557985590847511142503045568236477486841351006018304577286125680331496,63598436104602019165566090981108694584315688380484298834112905116152691044445398689734273641618587185481714511553420994509761839193331138392657/144248215382957563880263070928076427920240416985367016861457169758048176772278992795423755571251522784118238743420675503009152288643062840165748,-1},{-828645628881841108882912064032335291369487524883311680405111326877114040638912635122509658342544834640983573670037954921839686358551603271620/408052766020314658297616289039940485554585883604602326071949686185807565573506770416634392557880189018302618101833850168399814412258742553913,-1127180948323530295107242468366866733986964698561360957153183793814823600192127921891344713960025857495443311907300924982041686582479215415800/408052766020314658297616289039940485554585883604602326071949686185807565573506770416634392557880189018302618101833850168399814412258742553913,666556447703138685719430991966948412708450648028722491912155112355455641300327056518084484287045902725602440753664633122529532093297145649516/408052766020314658297616289039940485554585883604602326071949686185807565573506770416634392557880189018302618101833850168399814412258742553913,-184684028373405593548737680438851502640466456428272524182236657823574515611893081282575952297864852531385616853271074385611370278158088014878/408052766020314658297616289039940485554585883604602326071949686185807565573506770416634392557880189018302618101833850168399814412258742553913,-1},{158723117978239630911955914136428808473819561681145536381895695943293184132258237982323827189941421129219075691403959358607072799739124505088/469315379213820015670454877457949769962610991068845041162866116260574609214482462743526052311859598869041595002406261826649517069276328329669,-5030327335223147422543767713055379719058744010006497884348101766498767148866694425228850008338269093623309562244197103148449489156721365616243/15018092134842240501454556078654392638803551714203041317211715720338387494863438807792833673979507163809331040077000378452784546216842506549408,-1522936841078393797492945376247677616704110223151188346456482203512041250112787638772426381379853922066606535059572219330509139712494647637343/5006030711614080167151518692884797546267850571401013772403905240112795831621146269264277891326502387936443680025666792817594848738947502183136,-21841540438923789413834145370124515630598540575538915945648356648353905639704169496800617112639403911041523049252153616669871817438004548861697/20024122846456320668606074771539190185071402285604055089615620960451183326484585077057111565306009551745774720102667171270379394955790008732544,-1},{-8803622798057688214401144487801709900399361178851241309230154127010167686746985570529023365086455894622787458486121979658514262356933642137596/9821107640777295228268770509651841398835043863778741583420688788379983758409879404385925149184257682587185394447222129847315184289116623554219,-812484376686828512176694516245151163100408472509818736741452157349264017994916597983327064390630865704977538784970431112617769744792987407296/9821107640777295228268770509651841398835043863778741583420688788379983758409879404385925149184257682587185394447222129847315184289116623554219,6036486694006430722810079976516810384517266376034585285444754785523141948748813498077914585260096984252943808531352766493052657071027024039052/9821107640777295228268770509651841398835043863778741583420688788379983758409879404385925149184257682587185394447222129847315184289116623554219,1397992288853857632370750750547316222993072538676322726753594101300525297368865909994481110145410139271556539106781225432663156307192676571416/9821107640777295228268770509651841398835043863778741583420688788379983758409879404385925149184257682587185394447222129847315184289116623554219,-1},{-65467955834087720906478857006813210632012181814664312338694151609206627706248320978564284965406823513876899160068272423565852661634301078709296/86741516559063340796296458822559036730277514111682343431279558458495296089910392921418543397185957430144990836249477801091573000557385999344977,-13514098564506869293604959295402367014437463700390693591679687377866714010854052696155432684717172672242998229892730065914461169193338037424824/12391645222723334399470922688937005247182502015954620490182794065499328012844341845916934771026565347163570119464211114441653285793912285620711,41624479609501528182872957457743733788394121095552242201308494243467603192376470879277380952668966983160406116395959389052554381359597161931485/86741516559063340796296458822559036730277514111682343431279558458495296089910392921418543397185957430144990836249477801091573000557385999344977,94816261551625348136538657407668484877134839252426177161387512566619171498509148425359574038614462303064845166121518627608761675815628674842647/346966066236253363185185835290236146921110056446729373725118233833981184359641571685674173588743829720579963344997911204366292002229543997379908,-1},{-91530052502227115990857516241055226079366365620106319273408560687241213946066260075761507504334248749374432521454837954391118539868026795528732/102625597503769494166560296025321920575157229199604056419608478597711232405119125440738098920703827406628109379755007079121548799253246605187743,-162136196095039095720725044983740488268000179679913256809864141972824916740914695656607396815368824210272745814258793774409771423519673160348736/102625597503769494166560296025321920575157229199604056419608478597711232405119125440738098920703827406628109379755007079121548799253246605187743,36713310761551643526422732606923927275308467641493929656756291689136449188853349595923128107195730497876969463742771178156174148008389128794628/102625597503769494166560296025321920575157229199604056419608478597711232405119125440738098920703827406628109379755007079121548799253246605187743,50545461644253128477283114070284257314827883304538960931075937513934846241884761926729091395453686360602448264449299344368867362994887065206142/102625597503769494166560296025321920575157229199604056419608478597711232405119125440738098920703827406628109379755007079121548799253246605187743,-1},{-121505085238454631873985341297990491451946911187596156682888816006050265863639446050893899310632797629683419277593897600774280918082390254956/136331025647862291663787690742341185700294036029430295642788281993922293165971970870535786992464836547869458556933777201529181944006069732951,-204791611503279851174703362802161664297127303195282012420604979301467675925652047791755494019126515696138264006472082698498271586873730927042/136331025647862291663787690742341185700294036029430295642788281993922293165971970870535786992464836547869458556933777201529181944006069732951,23420229984659732163362173275749566657507743065746471847420680564819932673553972924489376026642504036830281758787544644750907868077235630228/136331025647862291663787690742341185700294036029430295642788281993922293165971970870535786992464836547869458556933777201529181944006069732951,64583773692127802563493642112375666928014949965852709665350338464925028349543409083365155758169362647030911807426851357668742660904993402107/136331025647862291663787690742341185700294036029430295642788281993922293165971970870535786992464836547869458556933777201529181944006069732951,-1},{-1439236063445550398320804142444281800659378874506440246254133706069959562890115212695993149612724203435287509644436517802278720608586201420996/47807391187524020220361135309705255284990618935727945140259081080659847144306891460664130643505285894223387148254908741643364966720584986247,-1727966465625427450591051935603518837243787243020397017047972320119684773953233845685720513352974474463043780682176403107674060744139368673976/47807391187524020220361135309705255284990618935727945140259081080659847144306891460664130643505285894223387148254908741643364966720584986247,-2453420687773479412631856023486323426833666881052955607774789165862252253316310070129828644357025936976020872565379142565647043017447785664536/47807391187524020220361135309705255284990618935727945140259081080659847144306891460664130643505285894223387148254908741643364966720584986247,1390309835886031599124295481590878455034149323876566750390824245113155215043912190663395761448387903946742903722826102726023873161511756386692/47807391187524020220361135309705255284990618935727945140259081080659847144306891460664130643505285894223387148254908741643364966720584986247,1},{36299904212168498871488845930102451063381732747860016711689501664434941416463418991196868320488046679865838026571302675396643357219723496817/148657916356831176146980798693086864713398432983247646460289327559946540319841488378460394459017210063270530271756001605946167341948428438434,-55404960369130372568673867238356731224543399353906749014738380160447354123590492541270067352133839270961560993269556599299873231905851150348/74328958178415588073490399346543432356699216491623823230144663779973270159920744189230197229508605031635265135878000802973083670974214219217,-22650263310870073009504853622191878693063849633311106526330657071629857814231310584239817890343291335803015381664942386144285827773045182948/74328958178415588073490399346543432356699216491623823230144663779973270159920744189230197229508605031635265135878000802973083670974214219217,100423855560769660293974773862066374488063133126691896227059825951240090930110647331573237956392080674158048659360116191029018402407845182464/74328958178415588073490399346543432356699216491623823230144663779973270159920744189230197229508605031635265135878000802973083670974214219217,-1},{83513753329805455354731594626196458671045436060160715925286903010330538585673156545281037932739986794505783616796667443438525659034061025807/165628659283441861853058115276805320466235596952923403715966258237347517353755524431052586318642655532838282323493684174442998829337618620784,-10810924768921412343502484073120479352619596632343421133114401313792755503043841376568848089243960002809893840363889261130434526607781954256/10351791205215116365816132204800332529139724809557712732247891139834219834609720276940786644915165970802392645218355260902687426833601163799,4329426990257092513216483699925695745938340936038780944746963764521599035933748096031826040861793794275194443213585999963746094738266479451/41407164820860465463264528819201330116558899238230850928991564559336879338438881107763146579660663883209570580873421043610749707334404655196,71761615103905180983390184872224644070894406087852442936868914891105636514676547463497678071966820426260235047979612701934840702682646675457/41407164820860465463264528819201330116558899238230850928991564559336879338438881107763146579660663883209570580873421043610749707334404655196,-1},{220537390092220978222662509689545771346657780644895634692460272205137201068161666930414835656816868263031613712287554744576773512357009298016/486405857978290804714627876753935377339756298957046486327450855797210373642631379004648981149677459170393635817591254145734760032696482935175,116882856683442689617590124827045941172399050395247970595541516609526613680594861093062447995881129965560580926718691253290189718891999822921/77824937276526528754340460280629660374361007833127437812392136927553659782821020640743836983948393467262981730814600663317561605231437269628,-3824010276788791449221216547973811351692001792070030333043471929863913564532546334984545205919707166813070413956559417560372375129308043690409/3891246863826326437717023014031483018718050391656371890619606846377682989141051032037191849197419673363149086540730033165878080261571863481400,2947458596781079999131588059396027897666231421077394573814801783404000715006685338222609181783764168929527959284796613216202913896784112469867/1945623431913163218858511507015741509359025195828185945309803423188841494570525516018595924598709836681574543270365016582939040130785931740700,-1},{-628439035060560698117541269557535337178828465290873281333224288196129179550208447985061310125226079359127600419934834323646846168239204511984/776652753898329106148535041279182312353555179745875604557548094133883236978261092250148881270633868805286533298784621005619259211565113000261,-44610359288106276729934974504087475615588022033299083342941995146538311269840109506500590642186298278530810974634548650439520813480130087784/776652753898329106148535041279182312353555179745875604557548094133883236978261092250148881270633868805286533298784621005619259211565113000261,110030225816331435964968859486925398922217224535739521398723415523727179927235850605737859179339408059026405935901486762892889673574647325342/258884251299443035382845013759727437451185059915291868185849364711294412326087030750049627090211289601762177766261540335206419737188371000087,-36766853264980145570942656367626462403227276411272436593155715853983649469306274868699038570586294312447119212585512797741965540735217908148/258884251299443035382845013759727437451185059915291868185849364711294412326087030750049627090211289601762177766261540335206419737188371000087,-1},{680603178368862689471234804819107362154287326162823998056120469916376332819937909836880712317442966369526430942380489228721866800295459992624/807050530991505244518843641534228411221849507593140075254283395132639229417665817227737541317676062622239813472884559934115659942407607741739,-227457931173344975666013150658632927546171139129764600260405838506423180956614126575283384430186699357286697343418245689882266945017420945379/269016843663835081506281213844742803740616502531046691751427798377546409805888605742579180439225354207413271157628186644705219980802535913913,-1379552723343068319841672407974367661161938405804281494603522025538368122635347675035671370508371150412654824314029654961920487599011639089027/807050530991505244518843641534228411221849507593140075254283395132639229417665817227737541317676062622239813472884559934115659942407607741739,-86211443012035566876869186770198971869198821728502616920215086199641914767196707503532874618413413073024550842070532535618640822194706659633/269016843663835081506281213844742803740616502531046691751427798377546409805888605742579180439225354207413271157628186644705219980802535913913,-1},{-153977880079233297466666806319795150630859324147885039660237254937567432585636770916650061873830403223795541312537900299003333585286591143918624/70710825133446849910239535817721510419691408216355740866949873854981951613300180189112541094734986523351192910053499024286878223186849295327741,27453903935327832890131173670903653688376129077825485265945402644886286439529001145390952828320447543434851196570774703410658266863075811675792/70710825133446849910239535817721510419691408216355740866949873854981951613300180189112541094734986523351192910053499024286878223186849295327741,45184279148595800395961987113273506618526987074985472619655175306323743673000590408915120624376444013320593087815917706334574391235957699629154/70710825133446849910239535817721510419691408216355740866949873854981951613300180189112541094734986523351192910053499024286878223186849295327741,267570633370416462625013063279175625941230607109887164144238592874157419450937458774425556357177920443625629547850771420459585907670545244301137/141421650266893699820479071635443020839382816432711481733899747709963903226600360378225082189469973046702385820106998048573756446373698590655482,-1},{-106917406642657897868391369935982320935551227406957489982787421586743085718455800863666817515835128053972199211476119491450129817090136672103/297880495702129032009835075863302588807625811174005568879123647731563931613910349883886088050775999399155743721490801775431383920528668569244,72416474485650882640923703834886330919520431565746067985738073455338024078910743391420399806599548569349065836651532776334633103938518703616/74470123925532258002458768965825647201906452793501392219780911932890982903477587470971522012693999849788935930372700443857845980132167142311,77316025527127530689576324456758903623805965822979044030256484833854517933038094091784833622546738208250557279158716856043800799811056533120/74470123925532258002458768965825647201906452793501392219780911932890982903477587470971522012693999849788935930372700443857845980132167142311,345711514065013510739299408578100856228321545586664857062734485131591380254213944892549189806391218140561892023197841233325821142339560606001/148940247851064516004917537931651294403812905587002784439561823865781965806955174941943044025387999699577871860745400887715691960264334284622,1},{-1018038002913344419934419915916774169945165418904970961165875974456297720717220981865873049288559772383290556246459187334113205675425403324596/566964474677153915963897571801261052220007562408333938192267360852635079399141497428691281179365099954307628275575032128420709232189432626533,-1722021352005766528422285525345004600405104175708868290284275790727383970947463243683492731185693699429034869436500025652408315920893736533322/566964474677153915963897571801261052220007562408333938192267360852635079399141497428691281179365099954307628275575032128420709232189432626533,-272029922349434241796043455921784815382907127851750861265101934546901315117560602244949465957574347673471342485211089590823212547002992880864/188988158225717971987965857267087017406669187469444646064089120284211693133047165809563760393121699984769209425191677376140236410729810875511,399215467371562600275745581337917660203032927652751803845489318867923457865734965841693807715576050320261415869135992394175356702352489453133/566964474677153915963897571801261052220007562408333938192267360852635079399141497428691281179365099954307628275575032128420709232189432626533,-1},{-183354147547676512044154529130439416687607193763832226143644687049241657449328497271251807817915437369586197771068496458895321695017037107766464/231765898769891266699106402575992296286034339317041117761891258634130750592868048225489190880358483058412950903693067086815517305524789555275449,-296927693754570371601178770621107644954998354228014010819916052321278124471613420803709850535664998226932209655720073958730294948486406579438848/231765898769891266699106402575992296286034339317041117761891258634130750592868048225489190880358483058412950903693067086815517305524789555275449,70959448200495695022986717922289496880018086228807724762627013295325132217370637994363963084711270419194865845559916781741020446766230082607942/231765898769891266699106402575992296286034339317041117761891258634130750592868048225489190880358483058412950903693067086815517305524789555275449,107385385070985359264801924417974967453481796998937710420603690073754264625820018186427275805365674067640438751918231072768995557097757470959678/231765898769891266699106402575992296286034339317041117761891258634130750592868048225489190880358483058412950903693067086815517305524789555275449,-1},{-427814497419674541902664916863350404291715986098198776733005138250667262557524200817172015878340160666151028493520962515551547476375552278431/259598511219718678944556253905897199216127917499436929362086201795962703843768526223340986699148936844162436766640094706133017937311673286573,-2900330666083144867678228829661604204181508405545621217341145395209530280252904713105501843594012675286682306912803200629480059380102929344293/1038394044878874715778225015623588796864511669997747717448344807183850815375074104893363946796595747376649747066560378824532071749246693146292,-75610698539772152287632310317380609977208340422618259266694592183019712792189990231116524853995154203788226118923782356089034160818990932934/86532837073239559648185417968632399738709305833145643120695400598654234614589508741113662233049645614720812255546698235377672645770557762191,239159688679186563761046197625202982083000138666549150402619124318389369538912594561828121553657345011818540235844367772162630833380260718769/346131348292958238592741671874529598954837223332582572482781602394616938458358034964454648932198582458883249022186792941510690583082231048764,-1},{-1050541086417713029838522724929658695520016538845649746920280658482159065217808911974648435600662780964302463035008555033234633608113148201616/695954272154561402019391533646429181644047040105647402794552507343168581853499155443347601162042433395361224077618140947183989161775424461497,365305706395261022435205089931842397151200487799065156249465544996590503331691517727290105747966900091548290093346942594255697134159016290191/463969514769707601346261022430952787762698026737098268529701671562112387902332770295565067441361622263574149385078760631455992774516949640998,2190644081325152769765507941785238937122766012519264490523829148889834827187973236146892094159007279558522929643439979925432533077756904311165/2783817088618245608077566134585716726576188160422589611178210029372674327413996621773390404648169733581444896310472563788735956647101697845988,-419667429270223945615605893428143488851798151086807544286527181214316598109998052188571304079610461534338460784470193176199059759526844074849/231984757384853800673130511215476393881349013368549134264850835781056193951166385147782533720680811131787074692539380315727996387258474820499,1},{745814940540631332145935984112666493887912178040697495962746430398041077542313243787882642891697080728831209950240142691057111634490479036004/7144839658201584993123337433779729753882452914627729269127189014035154791072822879848221649383697193419573596838152903204886687904489702524953,2108446849555310312253440810382062282815481372321278275642019499276164934848399635883470771020731924081677242300426371534851342024288371728264/21434518974604754979370012301339189261647358743883187807381567042105464373218468639544664948151091580258720790514458709614660063713469107574859,9666408325387658646546333835236581407047845903807903030632680481510454861774519076380305681102694370915295372039407616857989436288492538597144/21434518974604754979370012301339189261647358743883187807381567042105464373218468639544664948151091580258720790514458709614660063713469107574859,1132916926730128345245752403526800585632806138570161388805771543989783334404924538521688389382179116683864674096319199941641525498629212540232/7144839658201584993123337433779729753882452914627729269127189014035154791072822879848221649383697193419573596838152903204886687904489702524953,1},{1550944202820903676332031595078527709755780244709908026505874811181584769415250702094967622599296156304048118634400235196879032696771807292838/1534932712632459152041006970717184948697471384992471165104081615444241931146806389997971243665055071203224143390979706772247440574987362966155,-69524411896292195714877653009768502543858020766562211810893625780185761227914382111937565743626920296098727404941671551246902634861067100808/270870478699845732713118877185385579181906714998671382077190873313689752555318774705524337117362659624098378245467007077455430689703652288145,-719026032283188964692153015461227674549578289852231105267737034355319951696298505068783532408220694162248145179115244583485890256913368345906/4604798137897377456123020912151554846092414154977413495312244846332725793440419169993913730995165213609672430172939120316742321724962088898465,-1418791885578736942186807369277139023470902560837051207483234981241517620500120999880145946594819754408709396889886144317531275717838706585684/1534932712632459152041006970717184948697471384992471165104081615444241931146806389997971243665055071203224143390979706772247440574987362966155,1},{-60715396281326252007634874774663150235281657510806328846905684488597612560274804526725601059501598468234690041566587797007898313669892504798/822412719307244041238166928976108769491440533417775152800603477985896051921594106058877072985444133501759954150911491947160158702210864710581,180746208749847869536478929725831813938356276939387974787032166120493119871146375156417703507074671460768266498477819781775306126879141735264/74764792664294912839833357179646251771949139401615922981873043453263277447417646005352461180494921227432723104628317449741832609291896791871,-8150964427649297447946532671831422495349871993956638906434771823432731729428108928593513493980386197437923144127485068241112032431488450966781/9046539912379684453619836218737196464405845867595526680806638257844856571137535166647647802839885468519359495660026411418761745724319511816391,4477614205174996681013189335156078007256790602182649217369731851842612141407959116301787495036910614084947782953701452272574656485027142674604/9046539912379684453619836218737196464405845867595526680806638257844856571137535166647647802839885468519359495660026411418761745724319511816391,1},{-43540747130196634587227609774884026297932345545063578974987397852392194847598846864491294341904957560408521689917737211930023803394977378636/54574991611324684384476596519291592664094485541203298774444944690102933625885611978942523561576644729164240410158283488836140907287882856319,-74819825318731658763911599387216902543964507330466912418640083159880791537412711447221046793062814125717055608536570037490019166305480236298/54574991611324684384476596519291592664094485541203298774444944690102933625885611978942523561576644729164240410158283488836140907287882856319,15229976709689860007111985966070824498285293265169810495961982430377603570066967231196928606604411019159056247829768278306923465334262877484/54574991611324684384476596519291592664094485541203298774444944690102933625885611978942523561576644729164240410158283488836140907287882856319,22634484089169499228831615907855773454600420877892236906352268429774510057886231810139524918482097537869162477951741068267594932139022692721/54574991611324684384476596519291592664094485541203298774444944690102933625885611978942523561576644729164240410158283488836140907287882856319,-1},{1857489158882278338859157718696461675643365246644337708891447547929594012260439133210021917045122566065217884260961833152295729677456380890301412/4369654473570415456631185629010728770488064719198244442662642961955756292590940095983311011586817286880909034084847245926346356928801357266378209,-15740894898965326264733956515008001519525103381179421452065709995033576004685301977002054058409588101354863972314422822665296263368455667630114592/4369654473570415456631185629010728770488064719198244442662642961955756292590940095983311011586817286880909034084847245926346356928801357266378209,8530487967028689319634056769850643092955175638633208806854572813246084413906350847437420756949557230832450589269551973038864411994076891405891156/4369654473570415456631185629010728770488064719198244442662642961955756292590940095983311011586817286880909034084847245926346356928801357266378209,6163920307002877525114928410022194377266449999441985756422470188817775265844825815194528756679309399455699725761739282609987129890511238699803528/4369654473570415456631185629010728770488064719198244442662642961955756292590940095983311011586817286880909034084847245926346356928801357266378209,1},{13776699698415774191204517184692197722804372189243075780822473769176357017071571783302958259404722559004792868629401478851648943202613134333091/11713102130764925475220779547180609504943976161735203254948180125158429049337042872845556411976945553232399573262589553465828999585388629367392,1402136783320608121527745320871986904993693593692973630268806693933203674086413082821789735603243511648823602928859648413318528304319105288249/732068883172807842201298721698788094058998510108450203434261257822401815583565179552847275748559097077024973328911847091614312474086789335462,184780017709002315013649770472410574012632055993243737580878929631329384102039304425094278687127017231590725224233554011437947863317497076135847/93704817046119403801766236377444876039551809293881626039585441001267432394696342982764451295815564425859196586100716427726631996683109034939136,445349321649254660204464427436044935575774396223259010511652664677813207521723660112830403770356025767796358760058170156410947962784157315347/225251964053171643754245760522704028941230310802600062595157310099200558641096978323953007922633568331392299485819029874342865376642089026296,-1},{2407362916571330418252461838258675555899202372378979606040899782398492925530017236727667957018663189615504866827546450981340315591407140189509/391857559359196447525305591898131704034730439266369695409346064383810696884224151742988155353713487598873461114048563585559532786396032637964,1514955238273336787716648661314598864087994531961878971670243816255486652800398046423333053832366817534183991551891307893696887069172204698625/195928779679598223762652795949065852017365219633184847704673032191905348442112075871494077676856743799436730557024281792779766393198016318982,627187340615864293579219371494548821039779863149929381818154791935184955750205630920785260075443523137649543224475559984304033327299118775287/65309593226532741254217598649688617339121739877728282568224344063968449480704025290498025892285581266478910185674760597593255464399338772994,1649880667355954820144155648860845755428537693347418350141219938922292960716760554569040575937767146000906489048804234965809679997343684197880/293893169519397335643979193923598778026047829449777271557009548287858022663168113807241116515285115699155095835536422689169649589797024478473,1},{-67942049918832676925641946370886629371946755802165559290233827315718731618302603395767093826018192162749799633740572012901178230777287413917946/15279509311327300374947002117397742501149956722629297645980463895522109424242392534180098255062653500231207512666024887390817797287674979304119,9812998205270196877007436395566754466231046932436158821439666364837290265183496133179564369278157933615235053388388445337144690486809386802560/45838527933981901124841006352193227503449870167887892937941391686566328272727177602540294765187960500693622537998074662172453391863024937912357,97162651469201636896670567655725994982211693529428918482974365396565479750752936410674426193067526975841636161117730474293342164799818535339858/45838527933981901124841006352193227503449870167887892937941391686566328272727177602540294765187960500693622537998074662172453391863024937912357,43159603863875784154259400595523828802533700110262053196963603944472369403919106454491791729409167038155523010265052804714938452701295973916682/15279509311327300374947002117397742501149956722629297645980463895522109424242392534180098255062653500231207512666024887390817797287674979304119,1},{5869142506639525299982198653210458782073200966774201262130903001661294393336385567737519715525781696499054502947979572048293767988608025984732/3958325128263832678348038543981081634692367510038780623358215687879312701288745867898304688136981217679876516134437522048898947647408888744463,-1509812963003910736568994204424618093032968064914064079488615032757646382853710520587370766879105870165785612431893205937965552641255099936972/3958325128263832678348038543981081634692367510038780623358215687879312701288745867898304688136981217679876516134437522048898947647408888744463,-154621867582021448088066587487849700483854384812445595282327774614939694334527892627069150834698645599291744141439166279885857566668142365938/1319441709421277559449346181327027211564122503346260207786071895959770900429581955966101562712327072559958838711479174016299649215802962914821,-1346383321419138645150097405844704854428841886004739368172486020181173021286116912282613138721387083545896543371824246326964530530184745619045/1319441709421277559449346181327027211564122503346260207786071895959770900429581955966101562712327072559958838711479174016299649215802962914821,-1},{-51355179674368847784776508756045849907026942959443691189582134151410712480164299160595906505951809460638646434829709839007427352954193908812027/89322619717963212570480263548889097878850940563097847808976278742618779551539724401940824795312475570419829695046840896124391785365970179405120,7673778779842666262790353630909112010457365327741889042595042024099068976355284570400758839889782644889035409868857259651838455447997490196809/4466130985898160628524013177444454893942547028154892390448813937130938977576986220097041239765623778520991484752342044806219589268298508970256,43311363327722059428689019121497653772595833163434293463007397365801342200579672618013152218074408467804875521238693370500231932754014452153419/44661309858981606285240131774444548939425470281548923904488139371309389775769862200970412397656237785209914847523420448062195892682985089702560,271249850600162878556671437069954061143328079728443986559681811501091620482965490661161757468611219629344385460254686244331988125495383868520181/89322619717963212570480263548889097878850940563097847808976278742618779551539724401940824795312475570419829695046840896124391785365970179405120,-1},{-10834681898744329126401393048375438770854045545145239173792392616613014849549454006700402302242250110818814319757412454664973691619730259398/34984113645279103368948373936052096015234539672703014465257961834061533690004548658492618223790788338104481250857092940489690978709758882491,-30498048270135763451635599487847756177572703203281295162809166634495440854540629514736824978964236969841324737661102537930901516584032781752/244888795516953723582638617552364672106641777708921101256805732838430735830031840609448327566535518366731368755999650583427836850968312177437,132829406045062842489241611377703882978132199518636629980064015870874326623716221446634728828893306583909026153569505393380204511015919713680/244888795516953723582638617552364672106641777708921101256805732838430735830031840609448327566535518366731368755999650583427836850968312177437,54948298939779816959688580429081343000991397682677349986167658591563974484660620917139871476238663778226597284281785737771141404260816314856/34984113645279103368948373936052096015234539672703014465257961834061533690004548658492618223790788338104481250857092940489690978709758882491,1},{-153480161728810009458445268409414126184029871208538241600068111765327697645078207705314130386858889177882932610064920179236666696541299669460/9870047889026956041583724246103334408206538911129507119702252896692215762430035953046464048193969736589732903895519731744390827496907356813,-2086635738652227866057527789598629608548311955838398194300372109238934533485335793437760999959471450479772003592253599390013064286957775146046/108570526779296516457420966707136678490271928022424578316724781863614373386730395483511104530133667102487061942850717049188299102465980924943,-377148943085045223128242917760107364249249955060522896185008571238621789583196378287383324073591669227209919251947502247954239629710865998616/9870047889026956041583724246103334408206538911129507119702252896692215762430035953046464048193969736589732903895519731744390827496907356813,-5501626716299416564484111672854277837063825395379323189420860705790089837706092552457015182049174881523316122789175198813405510795319619844430/108570526779296516457420966707136678490271928022424578316724781863614373386730395483511104530133667102487061942850717049188299102465980924943,-1},{139586236039739092739000194014570372877184941382433463751164900274501083993234206662228401162607838268023935640953277054161966829018941776932/283087718911538464636057526041226624098197921828455654831835307710517131150498775774670013702564081026329578785849573439147290008777298291119,185667189818431795836131341720469454689703381802330383318349181524115363488315912190877198775630939371051731349279827153921041278252785385344/849263156734615393908172578123679872294593765485366964495505923131551393451496327324010041107692243078988736357548720317441870026331894873357,-246632203542578083969484873487792349376477257032391914649391098405624987898424853779954087934379533911253589360678299536168399846994752679224/283087718911538464636057526041226624098197921828455654831835307710517131150498775774670013702564081026329578785849573439147290008777298291119,-346198080403391217539995356439642770236506957597767465607432006662702284423633444015628393579020909720701458028220921990219014058679021618316/849263156734615393908172578123679872294593765485366964495505923131551393451496327324010041107692243078988736357548720317441870026331894873357,1},{-2424428917778400282297880388442193626929463094699643609895488464088246658683336224783924130116275749244765162300632168591893782269408976684914/65183341279333904120003841752640450449276620225713207795737284401748973637206745773882923776170438368265292135745820318754434742593247116555,-2504729960857835490757500221644311488707225974258052243247500332139311747940734181567450991270020399541781817351733918804679408206716231231364/65183341279333904120003841752640450449276620225713207795737284401748973637206745773882923776170438368265292135745820318754434742593247116555,-1134000543246264572868403609570397222040017141249559979558010314113028533221617658118490689389834819211221125605594766429861370358244576648826/65183341279333904120003841752640450449276620225713207795737284401748973637206745773882923776170438368265292135745820318754434742593247116555,2882206655216566191958982105101526502668003477648998392917264940387279083812156493966281674218388756835682552469231371654424213806065009313783/65183341279333904120003841752640450449276620225713207795737284401748973637206745773882923776170438368265292135745820318754434742593247116555,1},{-17769466930834059017920743696699062945828282033601666121834810166846052434005011098815823470471878399821207941948737366936862791113942618308596/133012103631443234998486995967454158895928964612678867812142372393373320702652137236849675079975664245462712053692822762400537269687622636979249,-59416344733660991645428468600142352942926427772993630883569900563091121085194369036053217310027657057018772289724145476264462442330691156718464/133012103631443234998486995967454158895928964612678867812142372393373320702652137236849675079975664245462712053692822762400537269687622636979249,-5152218207726911587300432302354206443949919760886928981810038718339183126940900183189091682572958693490050459431103150414904039190462577400528/133012103631443234998486995967454158895928964612678867812142372393373320702652137236849675079975664245462712053692822762400537269687622636979249,16457646129973420483339823862349369488000090666573679859773028168186674097756898264386887704236047356084865928470166258710990428088514657227800/133012103631443234998486995967454158895928964612678867812142372393373320702652137236849675079975664245462712053692822762400537269687622636979249,1},{-48936321462127438554462050050205771929589235848521362968376748178423778414679866086110569933592951787142088158294722930712516194804427580829/40997645917452681506721809434561638718814357291236922808097001570048374609542117597595822663943901652789061499548238556445237209993326688481,182690275346620828342642750338046926628705408388377168577916432945971404596990828251148531577122166818932672211405353669241725688962360209739/532969396926884859587383522649301303344586644786079996505261020410628869924047528768745694631270721486257799494127101233788083729913246950253,737552069305747879099193283760914497340024747821555720009975156965840427410285154952031932976419135828305661720982312706220500055797412252377/1065938793853769719174767045298602606689173289572159993010522040821257739848095057537491389262541442972515598988254202467576167459826493900506,-1653328148428551168978984660442091128947623987969407763144344395541055441256166381047097893685836042952396056671741534589353154947313222108/40997645917452681506721809434561638718814357291236922808097001570048374609542117597595822663943901652789061499548238556445237209993326688481,-1},{-1739081188396306550316585229147814485843428534628795148599796504251825167679816936537000444390060948189066120911006557100426872390366922779776/10044014756450413838025221777649381077749776885049983808341922395547575275175953817448036925102885893910597513659929966892674358154103633474431,-4801421990491709242919861947587988920232214704661389569822289750401501779885107593242229916641961770365732645849540989431883002806559560251277/10044014756450413838025221777649381077749776885049983808341922395547575275175953817448036925102885893910597513659929966892674358154103633474431,-517504298841352967803294164849292965135835931588077374369263806378080889107981136707639409399937659280839545537636211688636619712643003671496/10044014756450413838025221777649381077749776885049983808341922395547575275175953817448036925102885893910597513659929966892674358154103633474431,1261298024219812596307188866747832940628321976207563336567483658328610628107580935266342671024775639142482248903367072782069362701323693561584/10044014756450413838025221777649381077749776885049983808341922395547575275175953817448036925102885893910597513659929966892674358154103633474431,1},{-23107971536938765965784670536306316021917986712263700810858507528359127483760219931545347933246824651344977245322895659032494487984993018972/24086305395474742179224925943269999069841515185227296846375817554510367124881166005448230553306888496344362074816823644030565372320761360951,-1108502053025865102339981555699883254961496075033215355381946336859728812907802843008932065028695651260986969352097608772656352839704091189376/987538521214464429348221963674069961863502122594319170701408519734925052120127806223377452685582428350118845067489769405253180265151215798991,906300612629699193142664579665638362321008387010924253622949773465137741091761179118885369127272306997436889877739569997173974570413339398764/987538521214464429348221963674069961863502122594319170701408519734925052120127806223377452685582428350118845067489769405253180265151215798991,-17959153268851963661891375877315404715498979880929385999421494705830026394072682248410266883913498576385856244376736567923537872891905733716/987538521214464429348221963674069961863502122594319170701408519734925052120127806223377452685582428350118845067489769405253180265151215798991,-1},{-193368039602748836954185059970298081265426215459944170483043734001020187145071805788003975806433208231781354451633418431298482354554288133970/187416512885240378069674508812647990038628738442803731826190224718703494467355341415530237526498156362198125135593594900833429023713520108553,-11268755513475902178566792178595597954084253782626991069616207732040310184259163185751835052905317247312944856015726421248228640110597294363/20824056987248930896630500979183110004292082049200414647354469413189277163039482379503359725166461818022013903954843877870381002634835567617,-1521666169459418629923071451537881063500143512250893812299024398964546256927446960568325664667065227868965053456968188040014125356258327187217/1499332103081923024557396070501183920309029907542429854609521797749627955738842731324241900211985250897585001084748759206667432189708160868424,16346688744915737191112077030068677581089015779865443060518136067249156095542397827627857567933003684366075034569170882101518292189541130790/187416512885240378069674508812647990038628738442803731826190224718703494467355341415530237526498156362198125135593594900833429023713520108553,-1},{-262737741781242524907359208755165580830489517532343955391440064011413613890140784459094883970812767635496854297487651102969062031021842937572/167078850779192525505558008781858317117649393675845697830179238210253899142661558001525285917783429888279652680577764761850232443647076593761,145075504888844578820378623592053298189788679304359411634205369670374865095404855810633196780306763267611258346103500371159981590622390264734/167078850779192525505558008781858317117649393675845697830179238210253899142661558001525285917783429888279652680577764761850232443647076593761,142804409250391655287298827050094270997177195015489515126266535080600681481915855523521189745131911001203338278615071687741735078607507113200/167078850779192525505558008781858317117649393675845697830179238210253899142661558001525285917783429888279652680577764761850232443647076593761,-307065465541934936907805756368146269424904373844068651489949965991674765779771309187301112411663881927113622635609473535157790760257916925850/167078850779192525505558008781858317117649393675845697830179238210253899142661558001525285917783429888279652680577764761850232443647076593761,1},{32366149774375923054281080971481838148225721388426445838322414384299408097452656529124626449621297144059632248426913138485890037949390450228/49444045516486357879315437042882733302445772856216248001088518916722819939374522501068384590675828298783676254581705558928626525644204476245,-3363812887080664199320277477011356170488514010534820918788499898527185830455198088728088829194888618517140744088798538641085751085340503870139/17008751657671307110484510342751660256041345862538389312374450507352650059144835740367524299192484934781584631576106712271447524821606339828280,-7862979422791344519359704050897850116304883711578174503849820301960890305296824771838620870544871091876437343567415453449650731510729286763561/17008751657671307110484510342751660256041345862538389312374450507352650059144835740367524299192484934781584631576106712271447524821606339828280,-942100672666296496062452016746115223961384749200653492324820397581046727413156382580533470630456267597084963116243994559286630864953472003591/1511889036237449520931956474911258689425897410003412383322173378431346671923985399143779937705998660869474189473431707757462002206365007984736,-1},{-508040892769167177384684425330267534094200010341969261802730924167123718339148797132585201502398961756413065909146499430986983907618538615174/359806238699856095173417876162954983652881501570577518960436711775292486428699734185461163753698046546269644343393497511146337003303650951549,-1462438596332289424266904992548502920333975897105938058873899424184077442985949067528322197075150492902121763291877844772037945036315043198813/1439224954799424380693671504651819934611526006282310075841746847101169945714798936741844655014792186185078577373573990044585348013214603806196,-257310864114342822995839081007520650441421935016321017066307884930333175328521896553028868810503191987671884400279758906502615571353544176033/719612477399712190346835752325909967305763003141155037920873423550584972857399468370922327507396093092539288686786995022292674006607301903098,-3084863872740302001953182157554787424097498453103394973417564857448563217577211027604182771896614607064248625475183180372057219014860910322753/2878449909598848761387343009303639869223052012564620151683493694202339891429597873483689310029584372370157154747147980089170696026429207612392,1},{-2371870252907466449489488052211611615319535850495187323744194768577259451976287022829831725159967850132043206757033292388630680641046374714452/4758816111713759677767984142590714900935075743238968415123212547874032982991099628207964038859229157796846116506418707297963472196187588527417,-820882874244989789707908662706189955871873694553063369400665943464553703174416617377095369185064035595716850489090167654742825486597012817224/4758816111713759677767984142590714900935075743238968415123212547874032982991099628207964038859229157796846116506418707297963472196187588527417,-473511842683287599991423168796063914538584755348270012528209718809585580231608962456281561787594782746785719085497724800563985804877941425016/4758816111713759677767984142590714900935075743238968415123212547874032982991099628207964038859229157796846116506418707297963472196187588527417,780702870478126642857851452982771946302339723619693918246830884313956201075936494195569878180620746839431319308527772429250752658337863280128/4758816111713759677767984142590714900935075743238968415123212547874032982991099628207964038859229157796846116506418707297963472196187588527417,1},{-2341063863443844797384735984621097717903817653608143712560393873358591972242948035913442801804629029514193351424989352031100733794406350823744/3906071896668018814236650830618002161023530881995885773484419504673325718254328483725936510609965389727594471458958495141334595698517570011333,14043581158048637357495849298009235212261651503287953166485528739328667804029337158681699355692842193016511192522586431110522347127188214836133/42966790863348206956603159136798023771258839701954743508328614551406582900797613320985301616709619287003539186048543446554680552683693270124663,4497268858143530334933690739275780098141997722385038883476355107920063939530393899900270183331649432576892212884608956609021851686582394921437/85933581726696413913206318273596047542517679403909487016657229102813165801595226641970603233419238574007078372097086893109361105367386540249326,21712249079508908561347015182352170321787537665102831488048960709003054556868406089690905192802224995327293422728408559125714063205321944121838/42966790863348206956603159136798023771258839701954743508328614551406582900797613320985301616709619287003539186048543446554680552683693270124663,-1},{883613809145846494089882823507740517916961167173816833361671211122119445565000524315073066253741857691779043809568592585176248305775701376141/14679252267271432738615306478668715069006971818163009011866323865865145856964075378899251055824719257784155982832226868840240356439225221022866,5280679375510073878388750685282002331848749300804985142729892233928842386213798852882337890193070180653250781941716698451691435045919243920348/7339626133635716369307653239334357534503485909081504505933161932932572928482037689449625527912359628892077991416113434420120178219612610511433,7713583280235942928287262755789526850250201704867028529390369154631842058562454587502216107193234867801803051872636309180552398896494873458262/7339626133635716369307653239334357534503485909081504505933161932932572928482037689449625527912359628892077991416113434420120178219612610511433,1469389587709801675202197071308930501876735544754460170172113953018203757853719258803153450153806316931356240475852565114272575848491521447205/7339626133635716369307653239334357534503485909081504505933161932932572928482037689449625527912359628892077991416113434420120178219612610511433,1},{138374480998869417091334218046427161389965541561599094108472405158663728960807081327544734103909242734710823150738889496018789353582463231968188/168203110079084219226622156804101264753268618863138161999279077654135240301806989115499388147566865632067437217546736593466971824227803109003589,-358905470872431151735795031771900537817739597722444451338935554038419187401550997714427845110067573950080788184773375133033818740887490696230288/504609330237252657679866470412303794259805856589414485997837232962405720905420967346498164442700596896202311652640209780400915472683409327010767,-218910137852116189330773159115218255837126937195492296141409155442501428222156378249321428964204033123404724909670075062955033229306612113340678/504609330237252657679866470412303794259805856589414485997837232962405720905420967346498164442700596896202311652640209780400915472683409327010767,-115878723004475209191684423242610841225738288971475922395679953254686362450922508906521192922314876181464152442150306765451289585398353223401192/168203110079084219226622156804101264753268618863138161999279077654135240301806989115499388147566865632067437217546736593466971824227803109003589,1},{-1485635399027104362188109181054120420349809635380867690846138660966129249684688705410578305941828000678727557498955552604922288167036107859140/162003794966213419460422443110879228922717646211623235662076746640166987474697960231398832511270338454392209374023278823753282374414272507317,-1557049582806148700587733028928561237152755861019036356314094642387990054948011705727148814955416475227484202486963511824203128946204421563048/162003794966213419460422443110879228922717646211623235662076746640166987474697960231398832511270338454392209374023278823753282374414272507317,-135073219153480536669119074223098379495956062653187163658548535195557832786248134105826674224477430776261787199665597408338565339317897257416/23143399280887631351488920444411318417531092315946176523153820948595283924956851461628404644467191207770315624860468403393326053487753215331,2013733254856515568107593824970741573360102930638536856550529678320738436494568800413055497156202437366046672601982249497016334007388392606532/162003794966213419460422443110879228922717646211623235662076746640166987474697960231398832511270338454392209374023278823753282374414272507317,-1},{-80385663099520590954461173474960404240287398607018318605749719121099290808006882712412318091884313706034843632881357192649367764532992899436/420744415477650932310312573663330499929512127380741475277378502225864669433500269729725131236913527754838816494015068459810087819200314163527,102613119297443029288296059156860444873968737140237431528326905264454145203907834083120157228736677454104321604072827835184283012519838263368/420744415477650932310312573663330499929512127380741475277378502225864669433500269729725131236913527754838816494015068459810087819200314163527,-105385755852578976626573422742370350809044233102475457977932347195438332827598368063004647476653590987315651991517162742540173077878423428192/1262233246432952796930937720989991499788536382142224425832135506677594008300500809189175393710740583264516449482045205379430263457600942490581,-126724813559410907936227736197926997039337454762778746442753589180839268279289753892120472046855420984372800114281065395747192304991382843488/1262233246432952796930937720989991499788536382142224425832135506677594008300500809189175393710740583264516449482045205379430263457600942490581,1},{-86854128590551555534347219466066161439049367465419886439086048584861624864787296030161336017820863207068869381675643401571811082527921545608992/17455419095136464308246600208729726560506537767836545060536756170589485770652518628301997553993954413450023116300603304068512949096293233809855,87139368451778051006940567516958774900442479935756448218953810402544978277416664473018656934895456024134862209441532257369655166782111590877516/17455419095136464308246600208729726560506537767836545060536756170589485770652518628301997553993954413450023116300603304068512949096293233809855,-102556268474201365203565380260698465296352572069502094556742859222865119214059170502873352741814601702376882499771975400440715467398955868995347/17455419095136464308246600208729726560506537767836545060536756170589485770652518628301997553993954413450023116300603304068512949096293233809855,70384114758423802467134089572388001096396046315598850002877350001484004951718257851406629842293205603427771181485871235953141078857670001135904/17455419095136464308246600208729726560506537767836545060536756170589485770652518628301997553993954413450023116300603304068512949096293233809855,-1},{-314695416157719432476023504597578188656167472208440245702661770801538074376977531333070691319692386066317715867848249800611994585853440656853648/13373741841858194230915409631407047562755515150307489408129771320698903203356316922037373615762096326667756690186757612447465003780154603602381,367065521669929031649416034650529636996140927328394353538676138375574688521499270490122474997800461782961988485346918081366373833566812572581895/13373741841858194230915409631407047562755515150307489408129771320698903203356316922037373615762096326667756690186757612447465003780154603602381,53049032932882520478155889873347167515173597012348068264094824876263614656375100318419078907015058969517200771352284470035042394289351128362629/13373741841858194230915409631407047562755515150307489408129771320698903203356316922037373615762096326667756690186757612447465003780154603602381,-250073411609128316068977745724449185233998101323519921203948136449973033546120015937979545559486991225234970355615942094190909170935536382329760/13373741841858194230915409631407047562755515150307489408129771320698903203356316922037373615762096326667756690186757612447465003780154603602381,1},{-2914303882679868419242236722718907232919335393394188131947008831938776882271757217031325940656103750106469546841725115712309173685967006823603/2961326688280219379479681952248574321002291969149805535307898177957871132849697106224653942615192588973423387762399440849021389204407603453104,792066876039435408506220845259390663239655320433120420802513332737687985160031177113466320489468574388442178769446177103534054156902506757660/185082918017513711217480122015535895062643248071862845956743636122366945803106069139040871413449536810838961735149965053063836825275475215819,-369782798430527457356036816605812097069688125941705826133497703955829952255314865517411533666211421724800749560553171199618951903425883755841/185082918017513711217480122015535895062643248071862845956743636122366945803106069139040871413449536810838961735149965053063836825275475215819,77897643004112939125830353711066286784797211781693636325972887557840801743450955509927350866313399421214474374650794272996831959946121014165/14237147539808747016729240155041222697126403697835603535134125855566688138700466856849297801034579754679920133473074234851064371175036555063,-1},{-308027309963182476760698841011023055373796565907352378327362020390902264041450098914650155150308614899971804756573855041841772010762406884118/204348937418409001751753196210780004282769954075637847316586659182678081359013942063804054395559070073206184466052602960056284447279532278121,52801416701643522288223724174671105254900194994133189391556300720217057343102686381504221042528306906507391097308953977932050836863220343584/68116312472803000583917732070260001427589984691879282438862219727559360453004647354601351465186356691068728155350867653352094815759844092707,161571568820357807869322376293111032045757094180367547708335155901655630785469184006497305003214150194350915255479852219577214009168764115300/204348937418409001751753196210780004282769954075637847316586659182678081359013942063804054395559070073206184466052602960056284447279532278121,-246301414824825274524574846653599393804695472282911474060678723900549782458410796830884783750198298169366432119521416516733019405163037392479/136232624945606001167835464140520002855179969383758564877724439455118720906009294709202702930372713382137456310701735306704189631519688185414,1},{-117899004968206224768901447048140957164807720502803820995497850979668700197208725766872714385529604571545951047681064248372779927484762514236/78053207728514868649847477422730691976475137768547839606380706690195304054293764270086138860377679961266155440451321890620939420951200625727,552864889066168685068059441778776435316396796105691946521585005017726129946632362229190546335866661068716224967189416928377197079443169516786/702478869556633817848627296804576227788276239916930556457426360211757736488643878430775249743399119651395398964061897015588454788560805631543,556017372262224503061792110271598441291119097881859571593732976831460624155930798027504446903174452885238060943855038398547557138307423891120/702478869556633817848627296804576227788276239916930556457426360211757736488643878430775249743399119651395398964061897015588454788560805631543,-1269522594407139430271321432568797443375734444810419936674148593338108651773291246923629172704763302134994088246426756415936187572322012785878/702478869556633817848627296804576227788276239916930556457426360211757736488643878430775249743399119651395398964061897015588454788560805631543,1},{92203953313362658696861517388081360127791540356663443195357237920888742301284068418031456313973470340127861196327613395833854926133429693213228/50941736609927496476291086749198276723395161992464025618119185902098340471838322597271014484438678048178666354987479372141739592629599287726211,-47648025618000893482137581264028549204766119136915086222270349811496053160085783452016626799826582148123306360822078667119925497399520038633520/50941736609927496476291086749198276723395161992464025618119185902098340471838322597271014484438678048178666354987479372141739592629599287726211,7874957536504947388921696369247518994514016117169798706087627243226665347051058004713899767985731860221268070307082448443501370607676249902062/16980578869975832158763695583066092241131720664154675206039728634032780157279440865757004828146226016059555451662493124047246530876533095908737,-1578767190524534117023152358003775057889521389029233005966667875885900026071310252511284826095268618149630872043219046562466312729745029991472/5660192956658610719587898527688697413710573554718225068679909544677593385759813621919001609382075338686518483887497708015748843625511031969579,-1},{-720040491378189768514808704986113368104115712226493506833268664687225420549477497273896515667310370320245983833443212520663585421885666069916/1031699208660747554345790520353967030801088011457379339710161245039302487183484235532223544330310198335361753516213474269831258464068423997179,466654715946190236105574007178827850177266410854667096089263062092563408504915205953071295055417843892282579352615713165356766810653445573417/1031699208660747554345790520353967030801088011457379339710161245039302487183484235532223544330310198335361753516213474269831258464068423997179,506284476320415827170763758367588160180237296542896136508145692603120609619404960617549184983303212317630737337423570923913203712028480411987/2751197889761993478255441387610578748802901363886344905893763320104806632489291294752596118214160528894298009376569264719550022570849130659144,712586558021345280381860929055152769954459399207188349270769807178964253927701773367091965767986843924384790785978153049546575900209332828162/1031699208660747554345790520353967030801088011457379339710161245039302487183484235532223544330310198335361753516213474269831258464068423997179,-1},{2899438748795297677783513648270887324487031537144601069176050382182526192075089978041845270135657643522900509838671515960355343647109810061628/281691520001719507887981402905228286202919304920704168780910903945605016348907673269725233853935914916088654107603899587107673342055091345351,-1659664164590000707942751203885813799952794321898313261607740712689141405231893740765900681936548252698018717429785020580122150918133157834888/281691520001719507887981402905228286202919304920704168780910903945605016348907673269725233853935914916088654107603899587107673342055091345351,-1388892859682788623411778578736379269159295638935623202758174084462407841098131379083485443300731893471195782667238924238049295396763280323030/281691520001719507887981402905228286202919304920704168780910903945605016348907673269725233853935914916088654107603899587107673342055091345351,-627119826161088020146581078702523772949170579860740334515635225502546187278394897123826432391083183573138522346116863515873777667718563755794/281691520001719507887981402905228286202919304920704168780910903945605016348907673269725233853935914916088654107603899587107673342055091345351,-1},{616669066304680692603513295471042203087956099045254267540896812114304739943557347302253323914354022532814361106448327243288963711714460744564/11797779601487078847780430772243324636631451351775868392694052815934457486727442204542693660887784183109435228512596485958848666458928396031447,-5566797107126529239078091637284443435950638633524079657786919079600566991800354917394857006912541495470593184802865910183842193238060842549060/11797779601487078847780430772243324636631451351775868392694052815934457486727442204542693660887784183109435228512596485958848666458928396031447,-5509591528958700230966203727688151179711241642179010386306164849423978922054604971333640889116970511996032479105806825484614660553396905881042/35393338804461236543341292316729973909894354055327605178082158447803372460182326613628080982663352549328305685537789457876545999376785188094341,-11487654953219474686877346188935612528904203228922965450216464369141375107347396079738691954061354466132801453113632374479690568607937039120168/35393338804461236543341292316729973909894354055327605178082158447803372460182326613628080982663352549328305685537789457876545999376785188094341,1},{-1182467368690167351414071642837049411137622315463030498812595296679260491416384503763143369829806085037619963388070214479839697041570784669472/289102713596567552264956494788491851869250380341099042052754563546736141169425113583708433388452358844345820313257070273470874931670834895225,4247443821345539662921564012917604902200830942471040823670108934173825088251376576729534729317767273854090132275003129812037060061887876081831/2312821708772540418119651958307934814954003042728792336422036508373889129355400908669667467107618870754766562506056562187766999453366679161800,-14169679566572611502040726407065893067812427305709720846813053315840837075294373394519702317269247596333009214504086572414064229901853920033991/4625643417545080836239303916615869629908006085457584672844073016747778258710801817339334934215237741509533125012113124375533998906733358323600,20474020569682130650863376312573647058066042251069616049374571961048015093979331222070436881343213441869790396747451214094049000021848076163/57820542719313510452991298957698370373850076068219808410550912709347228233885022716741686677690471768869164062651414054694174986334166979045,-1},{23492477760381795283431368533586110043337492428611443679512396906316321840705778448681978943939603889536516653304827264747896386127578938172316/15609213687202965064815342927856659919732007430537682427406827132027837193058407424220914202965377075497314419966838256617699109494449317895777,-1855575684628627973780046836231985269761427519030907601280533672254046568117359966005927703293697354650054388136430882717534189825181739396077/15609213687202965064815342927856659919732007430537682427406827132027837193058407424220914202965377075497314419966838256617699109494449317895777,-6925610064776055201267007555202201931677747979879625474037026582764387879551378352106926701451316023870575319011294694514442809515120179993540/15609213687202965064815342927856659919732007430537682427406827132027837193058407424220914202965377075497314419966838256617699109494449317895777,-975094025206368270180691204357509720483937546516784659836248453404272707244392513908684897727065648232900763590746556190623304447540469435618/5203071229067655021605114309285553306577335810179227475802275710675945731019469141406971400988459025165771473322279418872566369831483105965259,1},{103283626701725856336956182926777150213446897774427796583658168084081730085510450001728649371640648357924907770913349471866220105251783790297/91647483316131381299925464282982402022462607125139918627839990302564247185242608516929333235529186903609529241623372157678994959634113846430,37440696875820300276987529312097171178873487104670430686504551754893805085529906579918395345210987584915320523567162944768424561424734005771/36658993326452552519970185713192960808985042850055967451135996121025698874097043406771733294211674761443811696649348863071597983853645538572,-254863751727897822805563494570154323672315008419814168086236642451640320943912263842460633326056484676247928558558793250132625849017927200089/183294966632262762599850928565964804044925214250279837255679980605128494370485217033858666471058373807219058483246744315357989919268227692860,-384843458264491505197690254652682880767439654789367667466650971637978553298622125352359151852155292183734294239916666267416655838410751976227/366589933264525525199701857131929608089850428500559674511359961210256988740970434067717332942116747614438116966493488630715979838536455385720,1},{-871265149887080871817345469511747714627756882121330961234863239065362438612855892169405901260433764024329395215833182368306962627287570670500/503358244312716797741446656030318924911701605687799374710761013023811032699405049126092210460531053342518904769548673242594988765645570993329,-1294822628027496942617425737116802923695271119581565009552836574356013729332245303684316335880284905252047942589434394780180417547621941426716/503358244312716797741446656030318924911701605687799374710761013023811032699405049126092210460531053342518904769548673242594988765645570993329,-388123867989888342539302609696032072887253368817025660971349738550653326925117442586300420205067049207464916077430270849105353332453062534596/1510074732938150393224339968090956774735104817063398124132283039071433098098215147378276631381593160027556714308646019727784966296936712979987,1027756317239567395842113575480935249851223650666881824954106395561505547692385295435555451627953894750720874135335641207502557256532067471174/1510074732938150393224339968090956774735104817063398124132283039071433098098215147378276631381593160027556714308646019727784966296936712979987,-1},{5818519086256404971552509452589712097133776544596017389206717266513772812951952632148299371020756776861821739133378476529738673569792588799103/6348267367098161693398326304168430886263573908232565923481873730310430914268301934468758586460972736342323049682330144929460221620319870595984,-403873013474526972454183326621983083920199995898966137437624079323904121164646589134255878891682925905093526047257531715899562576047605482000/396766710443635105837395394010526930391473369264535370217617108144401932141768870904297411653810796021395190605145634058091263851269991912249,2321616367337520190967861825716701626443124624455623801876938327709056121597886341295906040460482880593686780665703541350911906626627610228491/1587066841774540423349581576042107721565893477058141480870468432577607728567075483617189646615243184085580762420582536232365055405079967648996,3875489705622384854363482052258790846953765966128447732299849526032663341142566749003120814964990026369809372590021252311839729063031301399185/1587066841774540423349581576042107721565893477058141480870468432577607728567075483617189646615243184085580762420582536232365055405079967648996,1},{7515564341291376086249628134645922636684789710305120357942929256468506076474965362706696221272530999173219388876545242911561123093256316790896/6278896719513306151239730279462921096621766808259086890907517933995665002498052321732219672676539210346996264559640402173405329294846401195737,4362287632827373829896072633744375926190633192375023363463730544914156062372619818551116628741159140899749966087255566935388721130519165784416/18836690158539918453719190838388763289865300424777260672722553801986995007494156965196659018029617631040988793678921206520215987884539203587211,4349730253949653284068038518307307846906268490789898558661283168671257821876116283340953299577144023359066989231437245426184178437929583931396/18836690158539918453719190838388763289865300424777260672722553801986995007494156965196659018029617631040988793678921206520215987884539203587211,-1464395711479240644234233101495479750055360032053126219237784987392620088033956571299749155403018580289285040045791876790924598107020752559712/6278896719513306151239730279462921096621766808259086890907517933995665002498052321732219672676539210346996264559640402173405329294846401195737,1},{75564416433498456857198394495936376552779722563576632536936206114879457149732059251930820776020180992870228359415741142620389564272079880456/117521238415461259619539381469567297460048704504151874139224570041406415667458470856467167376798277473964096078516439357956782896033529634761,-55553751437582562759929169557342402662413175989114863803400991999096161164911537577104857930868831797737931221816264860751817377912520288133/117521238415461259619539381469567297460048704504151874139224570041406415667458470856467167376798277473964096078516439357956782896033529634761,-145275722863639742935586029888139864211020197336727523853464202178760839209447257456692278324494857388013381119529881781043298486162937425299/117521238415461259619539381469567297460048704504151874139224570041406415667458470856467167376798277473964096078516439357956782896033529634761,-32129818381771203640304974548623319621014134514711972884884859227388008669682587782971896247542896659446118675951216435667554681582995506000/117521238415461259619539381469567297460048704504151874139224570041406415667458470856467167376798277473964096078516439357956782896033529634761,-1},{-107677779946911651654361087337171628419738537019945551899776556384583119287062142273083742266996611444908410976829853528749644553923217349788/247011766535308696508256726181513533933374578844259334206789444422546944916032869311311304560900643861968297644242416634829327789639651036523,-46694145162821282421526080373377043931202326470210078803887587326951171728749604983445840488155683468994971918536658324932357409943754571377/247011766535308696508256726181513533933374578844259334206789444422546944916032869311311304560900643861968297644242416634829327789639651036523,-3356509880728234647511896195743137313398404165330242383590457689633102130151769784100769789994866254015991513924349127516799020648048668039189/1976094132282469572066053809452108271466996630754074673654315555380375559328262954490490436487205150895746381153939333078634622317117208292184,129541933110887883344361349459836417826427817107818684389869488975759530023417946824389931333689385575951588683941828124793095226630053529551/494023533070617393016513452363027067866749157688518668413578888845093889832065738622622609121801287723936595288484833269658655579279302073046,1},{1246028682336154501632344980822928405676168357245484532576367678823457554179441584809478141026275120386367629286472850360746628368298374931/3793402603251207937302470213079879453678936797372641743452021255936910831399042198959555207988093373881114023382493577937867800586200057133,-377583847391921599364163615088347676569749046846127386798608560978725959820043075595825252284449004578590930551422862949907829953505915882/1264467534417069312434156737693293151226312265790880581150673751978970277133014066319851735996031124627038007794164525979289266862066685711,-16480772351262100028285873050886797642189596588405781097853304076234590366799649855376788302070089037175180868409719507510540405344729300307/15173610413004831749209880852319517814715747189490566973808085023747643325596168795838220831952373495524456093529974311751471202344800228532,6204499868294827211518959965152208968345341363490818749878015565503774348030595526702028084427195203097415152405004783922882154085988670507/30347220826009663498419761704639035629431494378981133947616170047495286651192337591676441663904746991048912187059948623502942404689600457064,1},{-957381323179394144317697383309467260456865119729058756865540198788131431467861061365179872703574448567656910161443133562613974954361275757117/691364395287317330419642925415134841018247233185685989415631627054781500448239902104295505311180400389486021105648992922261323279070021999755,145551919373471825738103861459769453486949896346479705238663244360694649650361619593621830716253070133988957600518408796473519259382610079407/138272879057463466083928585083026968203649446637137197883126325410956300089647980420859101062236080077897204221129798584452264655814004399951,767152189794992788588628833902025011016088594523358876123595316456732609223498301031655268576017807296839246678859657109709869971559483260353/691364395287317330419642925415134841018247233185685989415631627054781500448239902104295505311180400389486021105648992922261323279070021999755,-220245047540966607631725863114400390947380312326075325246129882152004501535638776968067539440612417044818171054438565634002729811664915777709/138272879057463466083928585083026968203649446637137197883126325410956300089647980420859101062236080077897204221129798584452264655814004399951,1},{-3287336038574805578790452884390401764925073960979555920085925387617997778391353446869115514925949783402840354579714594864534052392860787569/15550446738048175780460976025492107900728245352995636148513351762789811770421536613862598182063309169414147071144361737889817919178621727184,214039036926481206570409198656243098207124253738978919507391235781045112197889462232839668086329182937393744651581935573525004601906445443037/31100893476096351560921952050984215801456490705991272297026703525579623540843073227725196364126618338828294142288723475779635838357243454368,149345091827338107178327029353995938065164226258939216552325377470359944020043592488994787163444075827441656771098623972583091140980890828497/62201786952192703121843904101968431602912981411982544594053407051159247081686146455450392728253236677656588284577446951559271676714486908736,-269315730142007425973009661131999943193374976394610132528851963461517281049382525535681083558047405932702676890467137927210011190515581979537/62201786952192703121843904101968431602912981411982544594053407051159247081686146455450392728253236677656588284577446951559271676714486908736,1},{332028364296981015949860567388667514395666148664760320328563785883960047834223796421507125215216329477238449046377798149682460717186449719776/6607837241644416265787226589877182099891496027087181442558603395153088865577055419955262970592394005408466821647151753124213013202998696341083,1805717622356575952327954866981346508144879435250097148153925277037693198190455618600385366368971389216541406273011082084120373163533225014367/6607837241644416265787226589877182099891496027087181442558603395153088865577055419955262970592394005408466821647151753124213013202998696341083,-6164380615421576254995771655499207581446785552708384972077638984200419528535057794411150345240955097994979094530778290511462196744694092401215/13215674483288832531574453179754364199782992054174362885117206790306177731154110839910525941184788010816933643294303506248426026405997392682166,2283872025752628247307851047578070380747753318215198383368870712207428227575948808842080783005709100148466322859190553849586902241357849379529/6607837241644416265787226589877182099891496027087181442558603395153088865577055419955262970592394005408466821647151753124213013202998696341083,-1},{-117760328745343873593656165686034314319688174524675812681621262872671313882891774326133614644668710075212943379814059333781607594325948957568300/66805333643217598140191441457478395667550338909902444550324998907648344345220711813852410372007452659731271110031312231924831546058598902205207,-170809250386978007374652180818299756079811080812325994312962913358671383318832904136171680811851743477766665748634417809453995739352381759755648/66805333643217598140191441457478395667550338909902444550324998907648344345220711813852410372007452659731271110031312231924831546058598902205207,22895501371052687300372828811488081755761218256907067739491925621058686270770449817706009260516456225836967723354998051333039881260418680243284/66805333643217598140191441457478395667550338909902444550324998907648344345220711813852410372007452659731271110031312231924831546058598902205207,67390875697063481846845082308768980575826153328296303409084430195337232021290842131331844430103924692181703026651411471653737550202366172253564/66805333643217598140191441457478395667550338909902444550324998907648344345220711813852410372007452659731271110031312231924831546058598902205207,-1},{329427651379885325266465895193648507271973115930564977283028046284369252942239815937678765559220040482092484491492193076161823180044781493851/245504690610610109899922759182545783503612041354689735716749336085004367693696670724932118758596261186693659549750019804952073164911057022432,60541536566183492964628151016893897874832671636500946532209394858638840560395239394185409055305440354335828703465698119482997197955775591072/467993316476475521996727759691727899803760453832377308710053421912039575916109278569401851383574122887134788516710975253189889470611702449011,3327023065448425137059242128227499202182894966663677156035644176310842284793496739524381835305764720803237214411214609319808907408053653054483/3743946531811804175973822077533823198430083630659018469680427375296316607328874228555214811068592983097078308133687802025519115764893619592088,3407786773106360011992225010224867466864285885926824393563358862407454401300914590655601244939158529313384101498594958762588003010995637305857/3743946531811804175973822077533823198430083630659018469680427375296316607328874228555214811068592983097078308133687802025519115764893619592088,-1},{189563292773887475544369808234338713163354956150482592109686787530082841032975320081125801535973353736610770671857783234831355449674733300731/202274833621649720671519781476690144684361641442284209819252868332663250599513403544256308322494658858989682934020824319193475956852095455432,4971432131990192172661948610404759346482699940286342972558879829345859453695819592125842764122358741092582132825946782251524514986388588677/32508455403479419393637107737325201824272406660367105149522782410606593846350368426755478123258070173766199042967632479870380064494086769623,120135420799055198720293922137973341702753392448478738004201521647927400412902750422681846532930054720214108247821468412629473789679910201586/227559187824355935755459754161276412769906846622569736046659476874246156924452578987288346862806491216363393300773427359092660451458607387361,-1257183742782222620078287811841361496189425865068413231890477969135688762882080061205211147316792960958996072833719337051446275066314862838429/910236751297423743021839016645105651079627386490278944186637907496984627697810315949153387451225964865453573203093709436370641805834429549444,1},{-47355051681631287072791267461811443100962449992828095859184192912946498294713073200712206984230032690799982620706369594808923774884093091033712/42524167273098478247074949698620036165691913773469836228656384404004190478191657331716189446159480995110755170236074500597350659605926757404193,31436187979264807281470335022370347257824418838100680233152230324182259394882747444524430247722291303907584398603444731995024239468676018085654/42524167273098478247074949698620036165691913773469836228656384404004190478191657331716189446159480995110755170236074500597350659605926757404193,12838831450182619977901755324866301667553378815917415278168044577226312043648914815511371255818816128587624654349070505963550410129613779558701/42524167273098478247074949698620036165691913773469836228656384404004190478191657331716189446159480995110755170236074500597350659605926757404193,-3027278296670539663249994267724581683337093981271603355305633602888734728702829691910435981453882668984555502370583851498231897796524399160693/85048334546196956494149899397240072331383827546939672457312768808008380956383314663432378892318961990221510340472149001194701319211853514808386,-1},{-815995118493900203837130194215095394612353620537230127717133957297541843226047440511742118828113161025616074387986244802801747368384046842452/44633584423625972644090401563181640951770172220457361143557123815802458771943725430666459265561794920245831549207480147691414363712026512272881,-19123302626677266876571093835230373902455490471970381951986850702106884413377460916870695968372430515844637201820416762393585815258917071337000/44633584423625972644090401563181640951770172220457361143557123815802458771943725430666459265561794920245831549207480147691414363712026512272881,-19912453866153517958914841967024253485941355577967290122150330389891952854580472958437829579659995995554037768058057711550477010753953900852808/133900753270877917932271204689544922855310516661372083430671371447407376315831176291999377796685384760737494647622440443074243091136079536818643,924973109812079317320692044981093465834760553337096382967945504499560907820443426711495255919977998793559088839951043448457663416115983581832/133900753270877917932271204689544922855310516661372083430671371447407376315831176291999377796685384760737494647622440443074243091136079536818643,1},{456577429648844749141775604063172153863724843371636162498866411713386578552438130850712823895549575563412370329056259651281515975707240379324/399110161302913315268298297435372996356158100191809799026217557104585020948676783485693993117846755666376495351594365573277819185384107844837,446622564361285023522294338084926314221895655690263536706336023568304312347204917781951056658994887759861656616389295949905667848070720734380/399110161302913315268298297435372996356158100191809799026217557104585020948676783485693993117846755666376495351594365573277819185384107844837,-276704981433295197717810379402446263041201869079900385313580779417598172973402087408588067456935649735427045312323318353286288937574020607664/399110161302913315268298297435372996356158100191809799026217557104585020948676783485693993117846755666376495351594365573277819185384107844837,-484851693090128916193073793608694051327481033080077887302225883158371752823418927155355312226461541796758875331636314733677036800162388494786/399110161302913315268298297435372996356158100191809799026217557104585020948676783485693993117846755666376495351594365573277819185384107844837,1},{757440357886968437717727794433359986968374670185491325354406766329215038219689951898135778476477864545334488574203206985396298860152535752672/3821411390488003048512065279889730292564030837271717346613764138609139753509597805250378831198080320350697103073027249739324159215289156338411,-2726123819634063672758703235496821657447725005390847297465655281770546246551884809011680951942977956604825555127798321759713079773605660066577/3821411390488003048512065279889730292564030837271717346613764138609139753509597805250378831198080320350697103073027249739324159215289156338411,-285558291002381084932533937067342685242902753828770641544865898830269108869092816163954208233222101858505465620838945681876276588518604816727/849202531219556233002681173308828953903117963838159410358614253024253278557688401166750851377351182300154911794006055497627590936730923630758,2691176588106058375526459795049143750880005370186571308473276022255027113485383890905216359413863255099241464036225542727719946257867601743289/3821411390488003048512065279889730292564030837271717346613764138609139753509597805250378831198080320350697103073027249739324159215289156338411,-1},{203440035367732344274844376195580078807851800301378175029208835204776856415670641511860993398479276107714049551557904321969253779522467008684/397436948169050496117681356360064131390780522321673138660176026057988126393008080667602084902255090929271457034211627769179877157105137568019,-1191505541906852888984041164473448031210268481073421200132213095386220684013448839124297418947443146883499516908801721177390441749927207342766/1192310844507151488353044069080192394172341566965019415980528078173964379179024242002806254706765272787814371102634883307539631471315412704057,-1953568931164840541140772891310544972217858570028299465463158577197579720791665050042430253276914634438727985057998953067338827304925275420306/1192310844507151488353044069080192394172341566965019415980528078173964379179024242002806254706765272787814371102634883307539631471315412704057,901275420683653639707843102854332849336356452892088828622903015173331129616185215830192788084332610845508971007684641310382178341013069365481/2384621689014302976706088138160384788344683133930038831961056156347928758358048484005612509413530545575628742205269766615079262942630825408114,-1},{-283651595343689838888199270200992795396834021448930409503075961306728818260100387575437694379574439487155603587222656673785385345152086298820/793071461999523511448157994540637776734953579916050087522957636221525208058826538124291679294967617340236423630185126265731154060470076016203,-654143680306589756038048872881493300225218956792989332892652053085852068630888534864470953744794288751701698202158660102429594935129128187558/793071461999523511448157994540637776734953579916050087522957636221525208058826538124291679294967617340236423630185126265731154060470076016203,-341657626974975256113734731280892478685631676599070753143045549023508377326427401283947807841617159421255560520180607736951176318517173929996/2379214385998570534344473983621913330204860739748150262568872908664575624176479614372875037884902852020709270890555378797193462181410228048609,-1153900171637490966373746491064266686842222259803701534955726538286996882037686657244762501740045409009652620988203231294091086020532556382452/2379214385998570534344473983621913330204860739748150262568872908664575624176479614372875037884902852020709270890555378797193462181410228048609,1},{-17157043263895333453817775432814329731470391515422481756740498727810573778341374140683817917321507062418299675125107109173684245869347867411/38144225653344677935368680238925957392693218342373629759078515189531400621728805969859194462493643359859332521941008073616471698908667266890,29848522449633180223895555106112686413010660461219089434763473687606037439465312912976854312505728072201480853848145570061384896663767231483/19072112826672338967684340119462978696346609171186814879539257594765700310864402984929597231246821679929666260970504036808235849454333633445,-523517480247921815305486249779601609054950909034648285257529519011693745366292395839462528368670301559135883387273389475120310119509549782837/305153805226757423482949441911407659141545746738989038072628121516251204973830447758873555699949146878874660175528064588931773591269338135120,-10504460331907983220134077348358608134040447671363435822951173807179038571221360025879547714353346440338000768745766824890955969806264752858/19072112826672338967684340119462978696346609171186814879539257594765700310864402984929597231246821679929666260970504036808235849454333633445,1},{-189906653277104968198553608275098154837758533398953235669140132120531040516975059117152304318135943831317396372890051610166624802033280231029/904276587306955862645764369767208853477885726732941886040250341567044673688247591027172048617286451237601840307779051960143739073338642567592,420969134686831643624246693891289787107362884232612598992849537172711497180890097429508543370397831378487236484017988332330066575098839659073/226069146826738965661441092441802213369471431683235471510062585391761168422061897756793012154321612809400460076944762990035934768334660641898,-313952162882135495605504004243372693671714264170009797930458554075445478793469831445410634217663208603254523861606675046792777594259224489675/301425529102318620881921456589069617825961908910980628680083447189014891229415863675724016205762150412533946769259683986714579691112880855864,2213403423611398037108973112610920820173645307944385840819833332357277906757668087495189869477877781339302301536243650264547402338915920067299/904276587306955862645764369767208853477885726732941886040250341567044673688247591027172048617286451237601840307779051960143739073338642567592,1},{-4211863392038478576934491745238604342414241577822036229227924761873726883259894310595238714364375270979883912458398326704910003251872183010896/4804200508387892489595616075659293363739004659421508923810997518128696051448562772531403191490939904492552709264768359351154217804850796097685,-154843844571332964439164298964959414050644877760919387298713275032620997392404392908849429133903905251547287322040481986232855189562892169870/960840101677578497919123215131858672747800931884301784762199503625739210289712554506280638298187980898510541852953671870230843560970159219537,4614954753822956400692712335028405930712200505349819456480381267278191894619632972694158506033236991961852455313516217172397931707675728954569/9608401016775784979191232151318586727478009318843017847621995036257392102897125545062806382981879808985105418529536718702308435609701592195370,-307807202201946677248197946019085443400603352453242217629950417270769616677263149684213365405316487793742111536365790338890467478072563502781/9608401016775784979191232151318586727478009318843017847621995036257392102897125545062806382981879808985105418529536718702308435609701592195370,-1},{-411589216222352236326670064583869577798843091716510416173353877244904166635912689354006485717222695658918887156412443897205686877674441906364/3432417417711238947028159367150536988585899085606120341647821613765247164727674044352349000722292044545781855635920200388676757649456013828521,-1426716707369046517981386733647004068663514963674412976852771577960636880707597644154593845686093186037325940927402190455856275635916429275768/3432417417711238947028159367150536988585899085606120341647821613765247164727674044352349000722292044545781855635920200388676757649456013828521,-121070371764638634669353295165708451806900339438862317031325088696559254592151376707255781623559267925702829165057654622203792721198896894935/3432417417711238947028159367150536988585899085606120341647821613765247164727674044352349000722292044545781855635920200388676757649456013828521,427210731917521102575724077165123578669848920297973493854222286376778906839405646382207385855913243112353512589832344198410496046097016587960/3432417417711238947028159367150536988585899085606120341647821613765247164727674044352349000722292044545781855635920200388676757649456013828521,1},{5925871622882881239782802430292308220827626705702064387607139632903695043527028602789041243117318164984391552215648479229363053985974665798/292439216666360848638492885829158156687344399243136478202474327630688361313452934976400984318485130198406607847631734783793248759957120035521,-30430870585198764650805641250299242387728657245684565111175887416214659310776922499367004294457056055741485499992963163261710161710022912446/292439216666360848638492885829158156687344399243136478202474327630688361313452934976400984318485130198406607847631734783793248759957120035521,250073550036568618367739448641979559154984715477377280680352857504341100465574760884477614580955679449572614238931484316192089511841259412384/292439216666360848638492885829158156687344399243136478202474327630688361313452934976400984318485130198406607847631734783793248759957120035521,7147731068724690686754523822878370970331705881753093872772827491644714575762077297178854739675939282975009198056217679727205991148379457405173/4679027466661773578215886173266530506997510387890183651239589242091013781015246959622415749095762083174505725562107756540691980159313920568336,1},{-10723351288588544080512343993396186550264545818191952307517974641610443852289947557357517436813448616696482798531269276052154259943899079512204/1660179828436699600187779868020647561539768464336299270195941158650610318241879554213286445138453574547485326580783393395856652958110639516901,-5248800666796870474392444047674098673551582951584454774291226847887136174389803001330573468847803904676679047155935228366528157182312792114504/1660179828436699600187779868020647561539768464336299270195941158650610318241879554213286445138453574547485326580783393395856652958110639516901,-8795544873978133053592087561651091097921407891140496923269427877820498416920758592676724670354133852074994805893249761894077683630743691323180/1660179828436699600187779868020647561539768464336299270195941158650610318241879554213286445138453574547485326580783393395856652958110639516901,4886420020901869113315079559172086739559272072324505984280482188677370874262861043503325385621151204885244437106981053901853956238009770600316/1660179828436699600187779868020647561539768464336299270195941158650610318241879554213286445138453574547485326580783393395856652958110639516901,1},{-726339087513611796769778216925603118053987100821549714904371259865181558779690395624636124377706510878564371050684197663690857008287219473265/1081264073133975233787647106883308922215963956507141931493270379470679558762302430046425196571850861274133634278470783525413310399259374046034,1034018588200981432744573448607607073535074394954955141834796601991200241056204731968074894691233849217872548804151834003836529551456823446060/540632036566987616893823553441654461107981978253570965746635189735339779381151215023212598285925430637066817139235391762706655199629687023017,-581275703869177409727547366790138655960297316676192930302516455921324319117662613403958494708196512368941636342026308195870512448624438494921/540632036566987616893823553441654461107981978253570965746635189735339779381151215023212598285925430637066817139235391762706655199629687023017,560884996389217564855061636588987304421034669807090330916660685159957142568783640431333419510647547858362164271664840433358286525926005795511/540632036566987616893823553441654461107981978253570965746635189735339779381151215023212598285925430637066817139235391762706655199629687023017,1},{-2531368114508590116607963667182068735018775457976670658106958108148838993109851496285922290956767737432499765677116649224562047072006375038489/578146735725934357697660292923831506750721203437948121554941599297629393256277632568233054662449577020779919010443218479362480720864313653874,65742519853686409077271713376662650563961294727474064153059467149556958702862208598651551732843066396831733133158640431674107138697493993917/481788946438278631414716910769859588958934336198290101295784666081357827713564693806860878885374647517316599175369348732802067267386928044895,-16586019824456880907731467147361908310391958736924862306404084832362420617943310374199431680682618374909561762849652685926619237083922619034823/5781467357259343576976602929238315067507212034379481215549415992976293932562776325682330546624495770207799190104432184793624807208643136538740,788736858316687302683608969945050225170710820006153123422839477600501385911106430646107459174952158497778096132337566699966671698952241335111/1445366839314835894244150732309578766876803008594870303887353998244073483140694081420582636656123942551949797526108046198406201802160784134685,1},{4352906032955199616732660117693652277631555061256315953996416257810463504569745901064668938424936773173153209608796221718045153813115193160/1249337518390712457215116203942780858028684131118563270197969568973657427228165179511884530772046058310007850672157904225681950322194379343,-2563285368387739522452853263870785782844961610732483864958731192665493995392819583615475259213420160044613521940724435699269263267154567329/1249337518390712457215116203942780858028684131118563270197969568973657427228165179511884530772046058310007850672157904225681950322194379343,-817784967356474492693405459609846611287858788518030598709651240489451568947883394953699857621762858108914049826397517774438251095518966276/416445839463570819071705401314260286009561377039521090065989856324552475742721726503961510257348686103335950224052634741893983440731459781,-376714624990351257824575245253586198171797093435641533855092849181654173476767819296825060835561399452069204588758322108742258590305111719/2498675036781424914430232407885561716057368262237126540395939137947314854456330359023769061544092116620015701344315808451363900644388758686,-1},{202230015542234875240844265546754047949695250843090284155491090755873127252982974550824146086529254997343052384414432450545327707319728580987644/686924127071976485198429218456345847396945987903336653360409687806213729157284176887023407081064780334516732368042595879649148395248177917584179,-429189146899702234213165229282646723217578302025418924937420607821890220618272036782655613921559476340624610651299869541228544743942725427747680/686924127071976485198429218456345847396945987903336653360409687806213729157284176887023407081064780334516732368042595879649148395248177917584179,534054947787859812315330314404610293256172621055894345733459009661234509108905601004161071482813802422058999028130500244660651231642032519517692/686924127071976485198429218456345847396945987903336653360409687806213729157284176887023407081064780334516732368042595879649148395248177917584179,698571849088056734010345815524295811694451366987617700880185019176986832361626211820939089931104897033530775118247122867588497332751357168699960/686924127071976485198429218456345847396945987903336653360409687806213729157284176887023407081064780334516732368042595879649148395248177917584179,1},{-274591706280002089599302462822979182256753982317689670440881913552178731445354374544666843966584291354018084679264463355688013577056473285071456/365745171232483124898011485258814014300111331818915971571328102108325345292587827326274904925602441902661544211005615711893152291185218721818933,-18707758594692594030958929011596300275455094939047013465810908971813071805432296312265761413814322246714453128359383972780973728380423593294376/17416436725356339280857689774229238776195777705662665312920385814682159299647039396489281186933449614412454486238362652947292966246915177229473,718506434298375039650078295969677506243310031282911713578102325246719732325428338922274536530606095688805040728908124152109055495281119269836253/1462980684929932499592045941035256057200445327275663886285312408433301381170351309305099619702409767610646176844022462847572609164740874887275732,191508954718398971388409463079875482812291333387685769478872371560148386607420970335010285993430928931758467989283297381955288006017793782003649/731490342464966249796022970517628028600222663637831943142656204216650690585175654652549809851204883805323088422011231423786304582370437443637866,-1},{-14921974480170688225477713177362037795303984376307815644884873471991005472097025620123373746433054831193118410471477351180077396195211525150620/40284569064323638653571174634098874924166215063786573257929229876030813945150932418260489671353052830915059729565843861475368167655237628471511,12073019023721179856345523898344930331031975466738482706615622871068754537520128513965745372113371641446202384684411547739771691666043005383595/13428189688107879551190391544699624974722071687928857752643076625343604648383644139420163223784350943638353243188614620491789389218412542823837,68439380072884862378060547764312848405412215453730631104314010749055110422330407847139371339416430182505921716608416163880852702529405046330541/80569138128647277307142349268197749848332430127573146515858459752061627890301864836520979342706105661830119459131687722950736335310475256943022,-39643072283406597801663923969288229478887103502512984591292702653734789143366190093808832028817730941254826021050704919392158506333642636515176/40284569064323638653571174634098874924166215063786573257929229876030813945150932418260489671353052830915059729565843861475368167655237628471511,1},{8656469891747960791377622113301474521084051290640607445150743225394882014009159743863997827093174154625971463947709188500224274078041163674828/42286811685992005407249194278291604057995543486491662269586734711194683182378722415631160151193812954183486532784153703989752094209038523727635,-7114046878664566668417289421517404524600773029440386634157422335079330215087869763083921545100927649074042640821534373264424097214660137862192/8457362337198401081449838855658320811599108697298332453917346942238936636475744483126232030238762590836697306556830740797950418841807704745527,-1412650614589880094402993736643515683717375020516390939171149662429918513654333044350581075194119332497073621659428089801013136053957937442578/8457362337198401081449838855658320811599108697298332453917346942238936636475744483126232030238762590836697306556830740797950418841807704745527,6950287418918595552121967482775048963034961599230520130656837771695848387360157821563561381073049201503132027321740354740066823025502903212962/8457362337198401081449838855658320811599108697298332453917346942238936636475744483126232030238762590836697306556830740797950418841807704745527,-1},{-26023915906017859389008410508141472934540103822873857010929817888803032241168519970160131263023077483354169105722433988680142160320335800208348/188877811088370539650961037919085252382613008480184598580946111816752233063941373338937728205110844888272026597079381864304643328480465960679443,-95761018254583666345945932231330289972029281812449472671520004084380141619914932738000937136062527799211344905288800134508271643067890630135792/188877811088370539650961037919085252382613008480184598580946111816752233063941373338937728205110844888272026597079381864304643328480465960679443,-10672223552574380057086803748835841452634971269355148967283811290749422293558462805846837908567012663979338864760102065234029405522541661861256/188877811088370539650961037919085252382613008480184598580946111816752233063941373338937728205110844888272026597079381864304643328480465960679443,12561663753441461801213253061433822168243705973215081680534218113325927122076540570845080021272646362380323685202333742108145969506609418164168/188877811088370539650961037919085252382613008480184598580946111816752233063941373338937728205110844888272026597079381864304643328480465960679443,1},{-806829559645354540433191145301550083982235847192870767724928058118825747833162673936307621095057732078060443132902673156739368399370251845428/8230811854623613603793428612392098610974420004012668062960372355902463452143370691663561017966211509011543121323486386799081432084863432209519,-152796772644870167890847904328841365400461138035308539487480865756783525514226369051194181464085510569265671718667487454216472836996354690312/357861384983635374077975157060526026564105217565768176650450971995759280527972638767980913824617891696154048753195060295612236177602757922153,284255514615830921238883443625874047368414407768860780925408476025667338422606397433538626916235712116394463455988226728381281690194506272032/8230811854623613603793428612392098610974420004012668062960372355902463452143370691663561017966211509011543121323486386799081432084863432209519,1851436586981180300094914153689548350500085866501529026115181550664618195904284390495685917424996035311328381936682328698064858169119323628696/8230811854623613603793428612392098610974420004012668062960372355902463452143370691663561017966211509011543121323486386799081432084863432209519,1},{-315964781993470226792548874582632366535255269549224045469553945575634407440129156070833319928807955507933069491861346498773242888212737168696/367975704124095658614691224212040658421240435930274004226238392073794715402737618409940421004991474989518165293867533985138057558935410232423,-521201191442350729477287200418055245897313117183028917666997633475605750834575535305066478089831894362113017516325349197194520755413278483647/367975704124095658614691224212040658421240435930274004226238392073794715402737618409940421004991474989518165293867533985138057558935410232423,-148622764237296531350253256102925941781355928590106225570134378924781438204460684680712709689669377137366273649157127155916821377955813024789/122658568041365219538230408070680219473746811976758001408746130691264905134245872803313473668330491663172721764622511328379352519645136744141,128446318975478919457069839429672517788856036785300325674320567490971844185727798677294502065103877467653729571092892702745547953688860142878/367975704124095658614691224212040658421240435930274004226238392073794715402737618409940421004991474989518165293867533985138057558935410232423,-1},{649938853119775862772868943562415489937051596287217833816108101118262049550788152950870186731211474734431153496637863092397916491799304507460/980641878483742729198966146538455208049989748841632450227327634724861519850548673970692707645764220447294622908527372212066626975532936908959,-810400006300017794331578741523627037213249669765130595702459498511644631659495178050595525977434554284659708378380432377050555969574937213136/980641878483742729198966146538455208049989748841632450227327634724861519850548673970692707645764220447294622908527372212066626975532936908959,-115739492702398683585436679653332171609048245179098605170790471952094606338550195788315299787590262740472621238540046333510175025498802003292/980641878483742729198966146538455208049989748841632450227327634724861519850548673970692707645764220447294622908527372212066626975532936908959,3848607228336685554762497367689499684136744591693610777955051035226484464668772459213930575054473347679311424762115156541148454823040751717595/1961283756967485458397932293076910416099979497683264900454655269449723039701097347941385415291528440894589245817054744424133253951065873817918,-1},{-2163660671806953483760727351104805856146894916856567014013365300448141304777064815509103541636489957277693991657183568843309720667267121428741/3394898677482169436236931795324701772751742623880779640690164432367216647677658523239173791238340290466974392938105330610327205024199621287568,68712640306118229998228931645854793590582654214018126697894211399288203024409074526430368388826485333853871090998283317265405458657062045885/47151370520585686614401830490620857954885314220566383898474506005100231217745257267210747100532504034263533235251462925143433403113883628994,24635248738880952591677620284390555091021129277155294228943603689742810302349630058215270383324297441633951621173537483480746466812676112738/212181167342635589764808237207793860796983913992548727543135277022951040479853657702448361952396268154185899558631583163145450314012476330473,1200761831278117470920416874318155793504882335787658803028326431118897729235308705028302900970499343794686413020936600955678649457795375854425/424362334685271179529616474415587721593967827985097455086270554045902080959707315404896723904792536308371799117263166326290900628024952660946,-1},{1523528911728935245133214908309420272948550249529134041637142599122384770600910870116404389962330087779622176713782272286716946954058583030463/1769197968975849065138491213573803152644673448771437906270158820465188607619736594539089875355301249684587673582079859748902274256649575078396,180587662652495201650097343190773563170145469317483913833775159498389042137104997056405682576185805964072922318603299772359633464750366640608/2211497461219811331423114016967253940805841810964297382837698525581485759524670743173862344194126562105734591977599824686127842820811968847995,737751646686530491771229287880492990512910818676008251619951284351788209729706287888580878537361676859057099266478096045832974936431127530778/442299492243962266284622803393450788161168362192859476567539705116297151904934148634772468838825312421146918395519964937225568564162393769599,5974506389818130340814142578060272517848740903583378924226071937185168587115111016599466152956383519914582807092255196637480658796634372714127/2211497461219811331423114016967253940805841810964297382837698525581485759524670743173862344194126562105734591977599824686127842820811968847995,-1},{9386412248016131965791841642246891417300622230745670521315704314232444172151728284242615817029766209679479134913203251685099139322663552060/429734681979221679746169395014376050776246330746284821494324923441588897761741089931589038266779151635421389518391657927973955942436771537479,-10685684806720387846071841571786161464049623578059192376300430169311229804077755432615958437349078529376402196377969299179076276932771745119386/7305489593646768555684879715244392863196187622686841965403523698507011261949598528837013650535245577802163621812658184775557251021425116137143,1287042696666337134277599411675834090521720483053597072246357476579895194550262153813058094212607507467096403257918033029271294077392141185661/1718938727916886718984677580057504203104985322985139285977299693766355591046964359726356153067116606541685558073566631711895823769747086149916,1206152560301484792860109185270647221413984436188944135047759409803674467327841204958964461262157484282049146529732164565742521059868312060589/2435163197882256185228293238414797621065395874228947321801174566169003753983199509612337883511748525934054540604219394925185750340475038712381,-1},{-33212579606432626186254021751214194948336814652057932040472406140033962349941185900559830611486146026438858062140814616012157654165396077510612/1488291775434497665152820425415287833926951838763094015286582295648214412820779573435371870160063385128255608425434028013913430738884045811453,-17373141792838457018387793061835726054787539979026417001295993635310709086463477095480349248653152670055202654026171905031737041747012135044976/1488291775434497665152820425415287833926951838763094015286582295648214412820779573435371870160063385128255608425434028013913430738884045811453,2674485438185509045787768502631065334877521946533632246552768260332855527298154230451150443670274034402954181015558567293173867690907237982374/1488291775434497665152820425415287833926951838763094015286582295648214412820779573435371870160063385128255608425434028013913430738884045811453,49218111467881289602892987388676607251026929683347599657370338661756243062463352965283206153871029237495983952327873328967352140177851230602041/2976583550868995330305640850830575667853903677526188030573164591296428825641559146870743740320126770256511216850868056027826861477768091622906,1},{91954810542927178959477412029622837025377310040103370710261485561050814678896585779597951200932265268140505390908041126643508706469038102164728/62931286181254972801185779221969661144317203127124259838333645452234992600724039308835879170739043053245186894236922325914381244952016348408513,-16423216483695081487529545080388471271411847271075820758262081091171218792215939706732509539889118162607695098567878961776557458825010520229243/62931286181254972801185779221969661144317203127124259838333645452234992600724039308835879170739043053245186894236922325914381244952016348408513,-32196308924555007144912830534773618081301792501545927721145092398105085322473896158299826993174797264830863778265067658430220647682976041578592/62931286181254972801185779221969661144317203127124259838333645452234992600724039308835879170739043053245186894236922325914381244952016348408513,-13395177474910029766720637712783871760435897328926810001870503240171378453079993968057716249227620440990320980831690351037141985292587172594178/62931286181254972801185779221969661144317203127124259838333645452234992600724039308835879170739043053245186894236922325914381244952016348408513,1},{-537334099180096118135327930254676283172923467112215182025089683655373929434701820882512819563356990994739027464958087353740329861016257939708/657387601281025755824221581722906530105769192465466870934003016963094272455575312764617493698176755474398794535985741728728638067779892401829,-908466703283680586231892335266250929879116722534421363885318190476694750564476221024130918669672031702865809394637929580725283322198039672688/657387601281025755824221581722906530105769192465466870934003016963094272455575312764617493698176755474398794535985741728728638067779892401829,-865947754793140015271439403209229495311805050709230914224850454020544631859029338395741570717445116758736780826976553119351300182012139305278/657387601281025755824221581722906530105769192465466870934003016963094272455575312764617493698176755474398794535985741728728638067779892401829,303856084974480550986204662604749830556710342843997225113015994213370761036056808029985140277205590598565327618681345016714293791534946384316/657387601281025755824221581722906530105769192465466870934003016963094272455575312764617493698176755474398794535985741728728638067779892401829,-1},{72056114738729981263106579205257170196134006704265194397346948678295956357112461856552112801384807589042273151870765965713089825457104740768/356946926502464500524861593169175279459453600232248925480773819926926488096669404230294911992954250833400033633250952426803100721198858056113,-251063085000971953103029090455332666107793995575152641838648354340203332859087700761722408565409703684684255043784012579000712002989828309891/356946926502464500524861593169175279459453600232248925480773819926926488096669404230294911992954250833400033633250952426803100721198858056113,-38435872253741129893232741365159741695650921147293770380292884910886376046635846408262602802112174462145681424290186381323788904159337264987/101984836143561285864246169476907222702701028637785407280221091407693282313334115494369974855129785952400009609500272121943743063199673730318,241587449916469337109840705790283484133642764973222775133718990697171870129008211737518858091791264329160308655052535823188232478032268371067/356946926502464500524861593169175279459453600232248925480773819926926488096669404230294911992954250833400033633250952426803100721198858056113,-1},{-5407872663937193836053670824905181860422599259431875599633165531745950214264167032870871252646057895085052207906487216163594389567822380047392/72655897171257851215472589443556972033238907016429922515404171979231222050244612686292098140422928832561638060996906699647920835116847888301213,-43019116079042261098234665711661986605296979418609889161366723191309104743801974596667565227859811448183623042758497557150540470178631285726768/72655897171257851215472589443556972033238907016429922515404171979231222050244612686292098140422928832561638060996906699647920835116847888301213,7157100117692788332981845229744986746985994329067766131625807015614440512512342675446078885624138576096221574911067158392826629103867413466210/72655897171257851215472589443556972033238907016429922515404171979231222050244612686292098140422928832561638060996906699647920835116847888301213,52912541903279306957177210789498906464599943344235741874269845348502917539327856778253991845544228041088639544875340868446384827301162089743524/72655897171257851215472589443556972033238907016429922515404171979231222050244612686292098140422928832561638060996906699647920835116847888301213,-1},{-95197281469609805814128257975058661859704507530572266226865940755101885861065744825598790178667662054384467410323329228168688978955628201011604/92023553177936833288845739883903663174106412574241454921674946865271869294109194675511764550012105886742280466189032650370665530225172572206357,-332781053050502488793731909604471642360595315943774450327421174414568788229465028410157962753662980400646169654057637150151241216309044059901056/276070659533810499866537219651710989522319237722724364765024840595815607882327584026535293650036317660226841398567097951111996590675517716619071,280265633218751265651047935396900857776767713490733816716231374935536804063817742357957832575153945581147704555597707110579824517873696643518684/276070659533810499866537219651710989522319237722724364765024840595815607882327584026535293650036317660226841398567097951111996590675517716619071,-5710885442317481980900380250494384962842756836664700353385543752725351273152847954390319409208166112805873328619388218427576633760277750993932/92023553177936833288845739883903663174106412574241454921674946865271869294109194675511764550012105886742280466189032650370665530225172572206357,-1},{6236827914080418077324953714198664733817208302007352345915668935470325780538030213333854013455601463095258464352925613732675041968547941586/51038054897181855657943262265483542134987431350896189394628736392286465901271738508414200570152427751616742839068598764467294999095636523679,-17830908237749693692390274845520584680307376999196465471137449576105366235733972868068145771537133555660372463037407243475824345704233831368/51038054897181855657943262265483542134987431350896189394628736392286465901271738508414200570152427751616742839068598764467294999095636523679,62172541886167256878508646106744865313392954113876126655914352926499412346713063104325342039756856024557498152236851162247417259765731435732/153114164691545566973829786796450626404962294052688568183886209176859397703815215525242601710457283254850228517205796293401884997286909571037,156315247139029947578384086432576658637994150795297189613363897095927609229573142083983909688222379195181890606280783055769483020774322187744/153114164691545566973829786796450626404962294052688568183886209176859397703815215525242601710457283254850228517205796293401884997286909571037,1},{-106064147795948573125853425815054372374195387495808395752490645035080480251231840487961714413841396431438457539711088213998809160689108812996/172996954761217969992719106017678195048897284675109989215861550761947555407060419987667279157745660291503937590574760730837988166321027699943,-3731887324079866442356073345556810400639309666786876492247130265079068496895853066224860621487939372551160874652294636508379631376662269287070/3978929959508013309832539438406598486124637547527529751964815667524793774362389659716347420628150186704590564583219496809273727825383637098689,-2912048890688930209857008723844295900812028696887646267333232054272314202683207775680543459297338233192852526873070562007421570579412598608984/3978929959508013309832539438406598486124637547527529751964815667524793774362389659716347420628150186704590564583219496809273727825383637098689,1053934781346304197610609899010285816213227661055074666919083663709082359766859669397845397478547867178465413180193376418563197346362507252116/3978929959508013309832539438406598486124637547527529751964815667524793774362389659716347420628150186704590564583219496809273727825383637098689,1},{-3061782873210481069485355259831867111628407057997697463802548223955401428512246338774214043121652718122799746738213960719311980101878193699519/3451531215011919915487840746817898479547743386344762490546759177751168569883921467067453239258230512326990231945779741010407309038736355439273,-3206483662106351738068913674240185179382320022305556497947659088931118523680597445497227561915459731651120931737028744548482018808728149324464/3451531215011919915487840746817898479547743386344762490546759177751168569883921467067453239258230512326990231945779741010407309038736355439273,384472503249557030352655587400205498452814469252279327134666216267530164576664232078727591182600570313381078173512268075287145067118569667020/493075887858845702212548678116842639935391912334966070078108453964452652840560209581064748465461501760998604563682820144343901291248050777039,366313524683848040696616549908919153852804299990691016020262776695271626880290913221534764364751135425552388916664012923403809305667071160977/6903062430023839830975681493635796959095486772689524981093518355502337139767842934134906478516461024653980463891559482020814618077472710878546,-1},{7473763043353643103973637628490783891461103130059415291649705612789690916060396154576640389292943375222112459757563983067025109295408987008191/21252878647776215135355527326534491394350298501239337504391093898799371944816267375850716391878859881653191389618801763177295776988776162761585,-646675732113624016578247541932196745112808463323295340888067970451107980599611426258590088396162059487106981781535719370838637622175939933248/1932079877070565012305047938775862854031845318294485227671917627163579267710569761440974217443532716513926489965345614834299616089888742069235,2278333219668814632717386072326398285516159106788427524924126272830505746189649082711716801054059220516251262583262688518187717433952752502048/4250575729555243027071105465306898278870059700247867500878218779759874388963253475170143278375771976330638277923760352635459155397755232552317,15160786312237939982500829876642249224235904256765342726159338861392602444179599213516860545573345276674787362929644642606746273493306863836348/21252878647776215135355527326534491394350298501239337504391093898799371944816267375850716391878859881653191389618801763177295776988776162761585,-1},{-33664598053653595990735555012552922156556658964774325360757552182363126880173364794225263763420887027447495788605916346662298175763067162984260/18810736015700177560969170230359683016497401337867963669069532780024691345841708871142727974078771650746854120387487958580966106050655908441921,-49824309776795057337257603849781421909719506403140020639663498499184218420294396520265070152582058003892111272102965921813413116294276423688320/18810736015700177560969170230359683016497401337867963669069532780024691345841708871142727974078771650746854120387487958580966106050655908441921,27347314286919927986895140195453347018333049177759867670046666891949409032742080539741454680439743049683504196994918431336244097844039081919652/18810736015700177560969170230359683016497401337867963669069532780024691345841708871142727974078771650746854120387487958580966106050655908441921,692295260124783319561017639983748229581830287636485916779574847075651367920404272314283098445395837340413818939693390325436403902642892089884/18810736015700177560969170230359683016497401337867963669069532780024691345841708871142727974078771650746854120387487958580966106050655908441921,-1},{2011355276106377564611395365461707168814928884020375241274659261578875414427957772809375443718214113317305093145027748712972277497871436138943/31456289841453188683421032404191712157637718156671776717153621793482635877415737338241730505974148229132719955481087006760530443466820575498012,-4641026139860015284121874574073165892293046767874192492542518299307627596470772637511437801262866530348247341509708366688652391927631546865120/7864072460363297170855258101047928039409429539167944179288405448370658969353934334560432626493537057283179988870271751690132610866705143874503,2235233661441973958144341938011582937912055964397289892156110321085713583729442442155547599363461983627959054991745673258016492200908062167583/7864072460363297170855258101047928039409429539167944179288405448370658969353934334560432626493537057283179988870271751690132610866705143874503,883205607826054007240863505047916141486242168055894142737254980340893330274852712320575984514363862441897436987237780377052555973471223201239/1123438922909042452979322585863989719915632791309706311326915064052951281336276333508633232356219579611882855552895964527161801552386449124929,-1},{9351869215777472137479572337512980935862250856700380495103957099911529369485753431088694267743466330164426236693317082598468130007868326424774724/1994116818235052050906909459775180102361955569670222399029107377587957207784907378217613524763460422039109502459512231117438282327731280198473081,-7120283218579155834632078515812518725468329338513412804581726464079839177278179796264741040244958042908178698678310360631675271780181092339710304/1994116818235052050906909459775180102361955569670222399029107377587957207784907378217613524763460422039109502459512231117438282327731280198473081,629185569215230342114347655989220579286715658700887256093999252457547972667444039666383990056126679471622186146945073328597187540931289436992696/1994116818235052050906909459775180102361955569670222399029107377587957207784907378217613524763460422039109502459512231117438282327731280198473081,298506077860945237310276081196987966374428277111300127439271117424580938463229450116916169180042624798654899043582575379984759273719922966549256/1994116818235052050906909459775180102361955569670222399029107377587957207784907378217613524763460422039109502459512231117438282327731280198473081,-1},{781932060924083541293171614578396813319371646691430967125062395713320352615473061269783984929345407298293962923218651504862780180374297760112/7780309101311508162818083225179108692265250754666159838174976290585602740801241464524703482751528868276048280580776537716026240978350112420259,1665946180806664505109375626250354759017076900616777744820391224942478539540419506070085555261860175971558068604105795795008810373192620120450/7780309101311508162818083225179108692265250754666159838174976290585602740801241464524703482751528868276048280580776537716026240978350112420259,-3664764924624004113292306740258956023461491217769278717819438801502057843770951666125329656079687878811479746792622011484151145351350481104718/7780309101311508162818083225179108692265250754666159838174976290585602740801241464524703482751528868276048280580776537716026240978350112420259,-1233914248334575318029951184975876468725441688223441400771867391382136468255309074943390771313638711961304983284453425637309866307175797092508/1111472728758786880402583317882729813180750107809451405453568041512228962971605923503529068964504124039435468654396648245146605854050016060037,-1},{-6942508474921206477043257411803138161184899456417624116043412792825611397283318795540841276874152338461683030202600754341207393819439543368449/3374219207233339413807399142802371244398240379458529015266750264622964275741183583835854047273395445981245471869779518095126091549386493535863,5264410098465476025533091195604762544503479089243689650792455804057116646498786925013448779590338209843628469136654477715882248608980251027719/3374219207233339413807399142802371244398240379458529015266750264622964275741183583835854047273395445981245471869779518095126091549386493535863,8270585808288054252089184865197072483288604223554989940327786011922040199820773970831622035911599804546772380764485811282436718448065812595989/6748438414466678827614798285604742488796480758917058030533500529245928551482367167671708094546790891962490943739559036190252183098772987071726,-7279676540636564702469738037353600931238255359729160997278652828459019066532217925042076744682130116979130360439104498706823459760264791770684/3374219207233339413807399142802371244398240379458529015266750264622964275741183583835854047273395445981245471869779518095126091549386493535863,1},{-235909206088905284652279165343159369079234150222284563298282992772508475541797012845614896876075333244849084379418423375604081261322765711105909/272745336870628000012407127613114768780445442215114215135496141711802275727970177567159213389014918405639005818333158708375745801630677894969972,9605950889030799650297595900635960776378272214636960148803399040438360974007465784453481244439683167196393723239308333089233686084848044947808/22728778072552333334367260634426230731703786851259517927958011809316856310664181463929934449084576533803250484861096559031312150135889824580831,26893521186834029674733886409412179838415455994742310123893052442597524625857267697944933298822999197106611923773766610356955636370089314703543/68186334217657000003101781903278692195111360553778553783874035427950568931992544391789803347253729601409751454583289677093936450407669473742493,86030904698309955907687081096075104127429534734941927973310763658228604072810959212755115514501783110910132897704177298874167803324118701142368/68186334217657000003101781903278692195111360553778553783874035427950568931992544391789803347253729601409751454583289677093936450407669473742493,-1},{-1165247470755069489991565861607407007590225931901761949272451693665678880949658174146585728845524526790627904744148168716904391687891954345220/261720349942692903028658826769846646284645332936405682208805531751214134493560569892108853212108404960441968800609021195798565550776610824677,-4006177415362606932353738762187707897142246159127408193600582859968880373178677543511564114111521197421534770702931552019923575423008874682543/1046881399770771612114635307079386585138581331745622728835222127004856537974242279568435412848433619841767875202436084783194262203106443298708,-951468531324378252061033945060256810990658741557130100280667677844787759802392241858492062580181013765519526158583484654664840956107115242030/261720349942692903028658826769846646284645332936405682208805531751214134493560569892108853212108404960441968800609021195798565550776610824677,161739812584232956908259640048965536400142272760825449568129384430323268523737962713110958830353545643607482125215436872599428877372900857237/261720349942692903028658826769846646284645332936405682208805531751214134493560569892108853212108404960441968800609021195798565550776610824677,-1},{-796834592621288369449234717285467940501224888043686338262286474059082758404128926750089991720298054837555774176448627613362458836004195930710/513191538164789497222510670112794312799054966815446328463001338150050109473363401478894115490579363340061133593382307052437578643150888074699,-3227974138662478950816310865768586812369291364428470660417529850805541842803840824458912526959267611501142837972686351169252818029455652954061/1026383076329578994445021340225588625598109933630892656926002676300100218946726802957788230981158726680122267186764614104875157286301776149398,-547546569793612507318508660132680987748292008000777430946137697124793988473473810326215445529775772803322146550399026794106111513427567230123/513191538164789497222510670112794312799054966815446328463001338150050109473363401478894115490579363340061133593382307052437578643150888074699,2411187304878664640565466746071181554209826501623288873992363804454498203197470484669653676169459469469362172109940548575397374212806740438987/2052766152659157988890042680451177251196219867261785313852005352600200437893453605915576461962317453360244534373529228209750314572603552298796,-1},{13120486840773471491750683374561908325905830255440307572094138819099635972807300828818707878114891886375772718451031648581735149152423488204102/4702432754334348821167788165114386412330789665339512546342188149845278739326980680211991317338678156349610655420260619895232996762574539910033,-3975912780062792148807701008660281420178778469428111439235944843557134201802248734104402622690437753449563309358168385935896483743395113974112/4702432754334348821167788165114386412330789665339512546342188149845278739326980680211991317338678156349610655420260619895232996762574539910033,12612251042484449255064366273120039520873537318604616165315879890916212534966289234789686254862546804251058381468217025899019923980111402248370/4702432754334348821167788165114386412330789665339512546342188149845278739326980680211991317338678156349610655420260619895232996762574539910033,-12697249549654548624448938235133458674827832310513553142884459640856159010204037823064968125277991356350559853507175817698000215059063115362196/4702432754334348821167788165114386412330789665339512546342188149845278739326980680211991317338678156349610655420260619895232996762574539910033,-1},{-1234412817376782980540102915435625009284522389627835794444871802494682175666563682121103336840117008980929380586395468814013170765371240688884/84302587623374763374310119214227221093024271499244400252601796771427079584584486526285714294959846489673779464836024205041464368491598066739,-1436536453209115511112372413971749165778837188880562195751536393871805507909482692439286387715047958912779997578291866556131001742889480316872/84302587623374763374310119214227221093024271499244400252601796771427079584584486526285714294959846489673779464836024205041464368491598066739,822118553447331362270638686229568134317004393162470380384282995467218036263618503688459309657428850256037650397400306316937487346304989564788/252907762870124290122930357642681663279072814497733200757805390314281238753753459578857142884879539469021338394508072615124393105474794200217,-853944445880737399233642464798773586195663696217744628870650521570073644033961379525807971130971715304032312756792683297842819702185455552418/252907762870124290122930357642681663279072814497733200757805390314281238753753459578857142884879539469021338394508072615124393105474794200217,1},{-8123165479265867958900654156657957130870103166821392111253087502408070920170861328328403083308646695686077583034191795021557127826491597095111/10493555330371740962846492961348089518513770821287935291126309191156266221668555573463667173313151471753308298709980478581779820827927492192549,36975329909748259321712932648621087674065514012774689841665794810570597696575186078661410937720827030090564648193491960754001651896962429695061/52467776651858704814232464806740447592568854106439676455631545955781331108342777867318335866565757358766541493549902392908899104139637460962745,41518233758490778865642016324678779915472393899548770074035264340908125038931346770393331308273629523292473899918536771754232272048198734214183/52467776651858704814232464806740447592568854106439676455631545955781331108342777867318335866565757358766541493549902392908899104139637460962745,-10939723305197309295392604303299427060416113386719973409205164040555642088713219246542657464472800182732075601151646396452781042151444563659638/52467776651858704814232464806740447592568854106439676455631545955781331108342777867318335866565757358766541493549902392908899104139637460962745,1},{8267681326115639001721750820889862645754976362299331464821694291509350925725088337011978412098057543788344402887700442901506608170232145090/797775539033274311654825743736478113578761363788970305054777202376662207099360151566204309905181311831431518180578418042216731694213204849393,438649036621977992726562103331380922056218336408367579365062760230941329791916306644393517021888171424332058709801828297725949061229114060120/797775539033274311654825743736478113578761363788970305054777202376662207099360151566204309905181311831431518180578418042216731694213204849393,27795052681330966718754689599310049747530911100711725248471477414185059591822050264481183154498899422288544297462534734083608654513535702592/37989311382536871983563130654118005408512445894712871669275104875079152719017150074581157614532443420544358008598972287724606271153009754733,19342410693318237560627108658004701151651150050277114300554512480438967745313744998669194981215256407711908167069460887943733515984785362956/265925179677758103884941914578826037859587121262990101684925734125554069033120050522068103301727103943810506060192806014072243898071068283131,1},{2499399215304518112254614970881207317953314405217128226944035950888198940165163038636229087888784911709082265777771803607027237643983323966583231/1386859398903102789726179080834746334935094958486758559809797363844954852310119897417029942964417832133770057876789101435897092129404583852439856,-92872116697748563878669352750793311086051832514086068718855138673699541623329258898495680009989695465485623689252979213598550246301521128058552/86678712431443924357886192552171645933443434905422409988112335240309678269382493588564371435276114508360628617299318839743568258087786490777491,503766019910285846003243489848690353297540807100776025645538983918029349891122328865106634609967584494526008211397951727018289524402311786972271/346714849725775697431544770208686583733773739621689639952449340961238713077529974354257485741104458033442514469197275358974273032351145963109964,1495820542286828576678289379992053320913416020267894438377849550613904338985838926783496257432763587843563660576586443011445576387164100137227159/693429699451551394863089540417373167467547479243379279904898681922477426155059948708514971482208916066885028938394550717948546064702291926219928,1},{32396513830875957857705726539164795362272969345353681306053726499428151302608509911148312158857402746554577990307251380698512574089094735849386/43844061660947548174548781074371953094780713163828928297683897276347366293611625223299547312826167709268128499008175222151459887258536591375741,18649435706365369007143609648092724773228260455514272662600675840605685642787265508514216400955405629184242294025214526943315400573063745053984/43844061660947548174548781074371953094780713163828928297683897276347366293611625223299547312826167709268128499008175222151459887258536591375741,75876004681421042434269535771746825419310626654253006793955501704912650666956124117019936857915752954722311890868794597300027424247928058350570/43844061660947548174548781074371953094780713163828928297683897276347366293611625223299547312826167709268128499008175222151459887258536591375741,23983437370875931190098834758450142978501038235283806123121066947510013273139919276442369723634329747520927368032800772606848692310830909487732/43844061660947548174548781074371953094780713163828928297683897276347366293611625223299547312826167709268128499008175222151459887258536591375741,1},{1560822213938711037099752747521142353267586147804397960504638773682508492236642337613458580014656083424231396130662260553558838442566345183220/1917630969405264900222808651749233218894464777755739633272516067440840908169409580921085536983269052659403468673981834398282924133220377558579,118620196126263480608998772559112624150315425754428337830346457713791405145788633582206376031276395226898654429629624017545912096158610043008/1917630969405264900222808651749233218894464777755739633272516067440840908169409580921085536983269052659403468673981834398282924133220377558579,3059905329456186777069122545355249898328107843723324458405179836243873050210998825836517831603990695516720104197504006002111007981057262776464/1917630969405264900222808651749233218894464777755739633272516067440840908169409580921085536983269052659403468673981834398282924133220377558579,4989183496824137278821407445221801450011030291052465242571727737457957435192738778441505693698372360297952774106088898357983877863761945524176/1917630969405264900222808651749233218894464777755739633272516067440840908169409580921085536983269052659403468673981834398282924133220377558579,-1},{52702355276199412112096387640772185624603750115460795073890320979939198263333721762803315652888484896428631569077315346347588467306835027545784/161232367213838177768159277087570814192416347856385118201396525050538563818019747152690405542761838450821237733939281484176762612884333856062941,1762670137306646283968643498667847878497142417754724850925547594675466037935795366191511419801204926298596073157620536057938469493530004087425363/644929468855352711072637108350283256769665391425540472805586100202154255272078988610761622171047353803284950935757125936707050451537335424251764,251609183597052495881497734046343642466166498402809723200594814597293541322225453486741420792495073978980743030127413893295839667257616470871663/644929468855352711072637108350283256769665391425540472805586100202154255272078988610761622171047353803284950935757125936707050451537335424251764,2298857791801631740296942219441865749989954957159503680593947583830068439347717183755402546045953112536777686085528643145872294123519238790873509/1289858937710705422145274216700566513539330782851080945611172200404308510544157977221523244342094707606569901871514251873414100903074670848503528,-1},{2216696167256624245825556257857231227237112512101448081709512088219650302578653901798345157600323323773187044595014466986725706924652764899019/882858769618195620108901528871330707661281531935673001880704041986413039779253095661765868574163535226717393907149083333114581518042340713840,-36556603133918167344095238211412190590456934821474243591905749261648606333791081718840003769948794132016503287697783464936441968346897237776/275893365505686131284031727772290846144150478729897813087720013120754074931016592394301833929426104758349185595984088541598306724388231473075,186885515820592340815983711824377688509234870898786323284997782328714161700304854536999648454123523559759139069066849168904843797394630585783/220714692404548905027225382217832676915320382983918250470176010496603259944813273915441467143540883806679348476787270833278645379510585178460,2038412604342795262280024708547727573441760920131475291595119095958184638525825069283495357669198593075080988361131197399845394061179236537569/1103573462022744525136126911089163384576601914919591252350880052483016299724066369577207335717704419033396742383936354166393226897552925892300,-1},{6800117056975276045584775727963010445081282753271464640218423163190130225764150951167993556903111572372569263238863446356034264658592512099212/5966887470745751373345129256896789792873609704769783668708581388338336085396340188153750810213519504704643755330387694504856755036891768084037,-32575314359608603773499823084218896521087150887932344006624688786317082924314091443362752192023398115326594006326250288386137384652608434037051/15911699921988670328920344685058106114329625879386089783222883702235562894390240501743335493902718679212383347547700518679618013431711381557432,21087434106672498018601208794980143122406159291400040517397307164886791754452443419002786401854257059798387600096346861965561919347941198652623/47735099765966010986761034055174318342988877638158269349668651106706688683170721505230006481708156037637150042643101556038854040295134144672296,-23268921277052164225999445674860289710967318113372390198571879902467718595678379934286214776702454222015961105054559605836826190148240612433353/7955849960994335164460172342529053057164812939693044891611441851117781447195120250871667746951359339606191673773850259339809006715855690778716,1},{-55293038702106116048352099664251988330803864887664485658749678466331080294948921771414311853844559892160252602213110065021301838027030881352656/69049868153873294538903384736908754680487399495644659386916799160965959714456659368952790039202803667733444140833143542437999978768126601899403,-25509736222193600988336293781721132063996446947835485631600941472044774791485909103780277924533691854605695838341074649056397312629881485770448/69049868153873294538903384736908754680487399495644659386916799160965959714456659368952790039202803667733444140833143542437999978768126601899403,29496241558830139968104008930892793828905526931477127653233862290112985847623167410876681703925457908370613025046906650764935054704841513404614/69049868153873294538903384736908754680487399495644659386916799160965959714456659368952790039202803667733444140833143542437999978768126601899403,57871944791270170167050188373907656338440536039381724004286382124789306493219447889497693071629425740672954550105559160594292004955260272240779/138099736307746589077806769473817509360974798991289318773833598321931919428913318737905580078405607335466888281666287084875999957536253203798806,-1},{-147843063290684068288094347889181993257296423209133426267829336966075357291518171303049460677955464380990086739864800007196859393672264150420/475947616549297887017324160945359587813502614541935142111821139623938062959988479515981756669631832994016506838977843931482833275500826200973,-564549142998377376358259868494400050304974033156857073185858449677225476713925116486085931422555090336414627799125104272720542339105789360726/475947616549297887017324160945359587813502614541935142111821139623938062959988479515981756669631832994016506838977843931482833275500826200973,-154530631539261726733618405029877164834541557828382964470014410902028976343472627529295088008857004990973779466783410107943019088857102899766/475947616549297887017324160945359587813502614541935142111821139623938062959988479515981756669631832994016506838977843931482833275500826200973,440520063075559932283706225696572446885601928624511936242035063937928000826614597516439810527356062033160246034391583306369543558202290837266/475947616549297887017324160945359587813502614541935142111821139623938062959988479515981756669631832994016506838977843931482833275500826200973,-1},{4017046793079439256936232285770497198111633258518762525808042000308437748695601843378563122316026738229660026747555060612568616892732605978612/2090606757559208494076229602006148758328282743250223591291944219297728524719358776619864775030371928343500859232655616869321775018735612180187,-214986444454438709766859420593693571767274568803811600791660312081920509427826574115986086249475934359382417352072100233852214570333621694989305/35540314878506544399295903234104528891580806635253801051963051728061384920229099202537701175516322781839514606955145486778470175318505407063179,161699036259119916360462393526451204630074547899529588343262513225091609711598605787025386440044861364731834680084023978685504657738423931557244/35540314878506544399295903234104528891580806635253801051963051728061384920229099202537701175516322781839514606955145486778470175318505407063179,-7614513191397231150756938179563669282640803309399587700576343355393570278155818533681119956400915793449489755626242660832528462326980380139742/35540314878506544399295903234104528891580806635253801051963051728061384920229099202537701175516322781839514606955145486778470175318505407063179,-1},{73753486784869476001595526506074798962743781168108191222809271175049993326036017132064544923919169198434860143557409961420980722770938093187/272062153096722436054898829275151512746815135212580272371431240127472280792733176260222814368360898893774401545739288683311074666820404151536,-45760718684676323687629670767937126138583413682135526614778471433282320130586549117132605912414573108859921390124676214245340365770703230864/17003884568545152253431176829696969546675945950786267023214452507967017549545823516263925898022556180860900096608705542706942166676275259471,74603868817272597773669822294571058555409765282348743368212771430763860069397965087221779170684649536003123550876151712720458453130321522079/68015538274180609013724707318787878186703783803145068092857810031868070198183294065055703592090224723443600386434822170827768666705101037884,204321981853120099344448342229042129061415788640460248881952903907536361911058530886122800695550138039754917231783613273933944206897956956853/68015538274180609013724707318787878186703783803145068092857810031868070198183294065055703592090224723443600386434822170827768666705101037884,-1},{-31733800675946336030040661391057749916945975053233839434317537942477312688661687080925578804940485613217358617111916841859269115793183825660/367871871512410359052932175586074729322887604612481341494140490610123610112841286096325301591035831764987229876721604819002705359652305388109,-7871089810409709572260041304555384414559242290620127916964003990602781823760622772074187887251316626312011821856845825740414213607653785117374/8461053044785438258217440038479718774426414906087070854365231284032843032595349580215481936593824130594706287164596910837062223272003023926507,1067522354138458809522636767540091715317705984260397655967629597338961839630876866781812618436029865162956492202849836555284361081017487608358/8461053044785438258217440038479718774426414906087070854365231284032843032595349580215481936593824130594706287164596910837062223272003023926507,1979266728341468459423412948069016237816879882486981477947722058088607002851015763062694321366974350622725374294463391615725192517967439913754/2820351014928479419405813346159906258142138302029023618121743761344281010865116526738493978864608043531568762388198970279020741090667674642169,-1},{-447255066828503425617069358634425762552625228871298416855151876948824950234927570578440314039566328698812926942921948260222447885532859388991739/205055072757327155776931907389791696628309283711748358286417041289807737267940774625573382519229357475795860891608743539046502618193562453673558,59760890877961616649462017027577092992221352682648758694432997581436609665730653046187072483310063240173221793409686773726101794337344764572720/102527536378663577888465953694895848314154641855874179143208520644903868633970387312786691259614678737897930445804371769523251309096781226836779,404173707267614629459559860215221565983535259943605170301274646002244979299962072339857076557872093939289929903877481341207956097721176566429975/205055072757327155776931907389791696628309283711748358286417041289807737267940774625573382519229357475795860891608743539046502618193562453673558,98659498801025248765040315594993746351671253892507271584643743427143478710059688319366905798027218232915340539690658231514403402006222680629510/102527536378663577888465953694895848314154641855874179143208520644903868633970387312786691259614678737897930445804371769523251309096781226836779,1},{1083545329086175851933744849355659015376189495407477670631586127068203278045178257910044996701170249165439315181486362379766987888333998890272/10280074147496621367485015803581134994253109763396195911376556759094959280270288838243244670038380563725751972889756773178868311869523048411477,-8173255333078729203307051597107554077303040031845828080004261238117645704435688365945151847407695792131161466028187101556125760311932021656851/10280074147496621367485015803581134994253109763396195911376556759094959280270288838243244670038380563725751972889756773178868311869523048411477,-259930127361677389396370899530503237543090424083541203306185464885261546133073260900748132056369774846532843624232658826241820345695302941442/1142230460832957929720557311509014999361456640377355101264061862121662142252254315360360518893153395969527996987750752575429812429947005379053,8132965636526127558701086001427055604748854147289743570326171749244069151049249893415294044776896060906272524588980377807825050561135752740215/10280074147496621367485015803581134994253109763396195911376556759094959280270288838243244670038380563725751972889756773178868311869523048411477,-1},{368010394809129270619817802850436005204324448379790556411448862976480835572058322731927325630327231988038807199634966888188780267556164936706/543245732454468984913011775551074714954860351218572786849615024948772894637824615288234622601080519716036266713958156168724629806066947224255,357382795645674571606063044336584013896512739986413110021164836814332255321737767836183676951111623478351552896110940175171821260229249258592/543245732454468984913011775551074714954860351218572786849615024948772894637824615288234622601080519716036266713958156168724629806066947224255,242995681106445394450742197093301414772985327137201640544608699686056950881326940033394475553370753466954617056688629737197162426940986254/170136464909010017197936666317279898200707908305221668289888827105785435213850490224940376636730510402767387007190152260796940120910412535,-661079663426702066036772237162569836719665370422822088373247830711380863285297975530051659715513081492582563907828380257034789486895211345388/543245732454468984913011775551074714954860351218572786849615024948772894637824615288234622601080519716036266713958156168724629806066947224255,-1},{-179749955887697596141122671977233563866403663973553468861932202838896783513504008794849575834000412923908007990019714892175463382470297235306972/99883821915114162339358878847356212865371452032201355190963722069086012911145716750132629187099510580324309181796416691425139093392344233580047,-266898327368569320571135317553822492316901171003938822399625204950042966436665366115707145692317468660044145460809893368840454274112951308141632/99883821915114162339358878847356212865371452032201355190963722069086012911145716750132629187099510580324309181796416691425139093392344233580047,145401742657576504418516361344163535880624636981629900469999925371394812603304493308023631460394629725393274471591566502913722884066964893071428/99883821915114162339358878847356212865371452032201355190963722069086012911145716750132629187099510580324309181796416691425139093392344233580047,4192695940773293579615149272811779770655022878640203954490890203740518102257559041619678279864821737237705063210475316165997725231290627196798/99883821915114162339358878847356212865371452032201355190963722069086012911145716750132629187099510580324309181796416691425139093392344233580047,-1},{-1870487552427963228655196988248780055206465900411975123452760203036540159816873517980258659952085264483763081181258044489578883981801778602184/1978478521505780510520915623964380037035692870307924743198131600192325417627583332360559098037095765735021040550647039748780835011950909715951,-194464523499694744366601145285796257527457651250128778850431394320306347815769616158533515520044629820900203103028132030149590357417599366002/1978478521505780510520915623964380037035692870307924743198131600192325417627583332360559098037095765735021040550647039748780835011950909715951,449156591633628293412183090033996229343647075219094367226369080655359905749716456184902232098034679964938095381177594171549866477362778003831/659492840501926836840305207988126679011897623435974914399377200064108472542527777453519699345698588578340346850215679916260278337316969905317,-265612480940263148389582585644350741809192326901077806699212684550280560685149875614659243240431129595608388767958433341183573568646748900355/1318985681003853673680610415976253358023795246871949828798754400128216945085055554907039398691397177156680693700431359832520556674633939810634,-1},{1575854153463177962356113665718571328531210677912294440733941690433405926469571660399917486021016230230091952264888085545417303509652741452096/4188190979176983981029741623187297515382298707227787018800618598282956884804186492814701302196940513487677546343116018262975753616096746841759,805398862697355149991877481657114778828527663737965047311898333625912774464265717344789671453590061468326171160460023884141476075736844610080/4188190979176983981029741623187297515382298707227787018800618598282956884804186492814701302196940513487677546343116018262975753616096746841759,-3529286381847314047468123411473016170244684271496565544079152141436001024153821561698668873452884932998130967693204834639921337181924510945886/4188190979176983981029741623187297515382298707227787018800618598282956884804186492814701302196940513487677546343116018262975753616096746841759,-2110990763585572142133511600351129596298752195324503633666120541856520722563831444942730186337996254077204799741948167562939022601815357775749/4188190979176983981029741623187297515382298707227787018800618598282956884804186492814701302196940513487677546343116018262975753616096746841759,-1},{16241025895814500347140432608593412916326262050489311067973777766881344086174611793955711760502110458895909696004417655476859404491823035340/48660190266204591647444290612434324806233624835925253205382225129683018311455794141246708066371661246814703618231616774175370393742515863619,-14142682249158460990615702878171506425424433352881980486895653633977013125529996895661993346108142440709879535384194910118196819401034297362/48660190266204591647444290612434324806233624835925253205382225129683018311455794141246708066371661246814703618231616774175370393742515863619,-109522696351693932093233637629356920376269949476685702884413527356743507828978876015230750291205593297531060391158280830132085164794047472272/48660190266204591647444290612434324806233624835925253205382225129683018311455794141246708066371661246814703618231616774175370393742515863619,-73002371447309103537792562988622906723124002092378941275680483894275436550224257029532207297551838609416608404405810047253037198510156004250/48660190266204591647444290612434324806233624835925253205382225129683018311455794141246708066371661246814703618231616774175370393742515863619,1},{13656844046150707138445179459249451540387755265633081265274096560492032158016507513704048402006076629716998460236475960116458504927309237714548/42777836047639077970354211421318202434013354646474441819052851818358537972913406052448434949370386434260331481484736391558819049251112690803157,-30042619451965771817793005082134422968782045100677071164897687391323736597707452279877128166509279734168669790233621771745906462110321745663572/42777836047639077970354211421318202434013354646474441819052851818358537972913406052448434949370386434260331481484736391558819049251112690803157,-576295593336258549295398825783294289462234