% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scope_tidy.R
\name{scope_tidy}
\alias{scope_tidy}
\title{Scoping a tidy tibble allowing to tidy select}
\usage{
scope_tidy(x, data = NULL)
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble, with a \code{"variable"} column, as returned by
\code{\link[=tidy_identify_variables]{tidy_identify_variables()}}.}

\item{data}{(\code{data.frame})\cr
An optional data frame the attributes will be added to.}
}
\value{
A data frame.
}
\description{
This function uses the information from a model tidy tibble to generate
a data frame exposing the different variables of the model,
data frame that could be used for tidy selection. In addition, columns
\code{"var_type"}, \code{"var_class"} and \code{"contrasts_type"} are scoped and their
values are added as attributes to the data frame.
For example, if \code{var_type='continuous'} for variable \code{"age"}, then the
attribute \code{attr(.$age, 'gtsummary.var_type') <- 'continuous'} is set.
That attribute is then used in a selector like \code{all_continuous()}.
Note: attributes are prefixed with \code{"gtsummary."} to be compatible with
selectors provided by \code{{gtsummary}}.
}
\examples{
mod <- lm(Sepal.Length ~ Sepal.Width * Species, data = iris)
tt <- mod |> tidy_and_attach() |> tidy_add_contrasts()

scope_tidy(tt) |> str()
scope_tidy(tt, data = model_get_model_frame(mod)) |> str()

scope_tidy(tt) |> dplyr::select(dplyr::starts_with("Se")) |> names()
scope_tidy(tt) |> dplyr::select(where(is.factor)) |> names()
scope_tidy(tt) |> dplyr::select(all_continuous()) |> names()
scope_tidy(tt) |> dplyr::select(all_contrasts()) |> names()
scope_tidy(tt) |> dplyr::select(all_interaction()) |> names()
scope_tidy(tt) |> dplyr::select(all_intercepts()) |> names()
}
