// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SessionManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.session {

  public class Session_2_0_0 : ICloneable {
    public object Clone() {
      Session_2_0_0 copy = new Session_2_0_0();
      copy.sessionId = this.sessionId;
      copy.username = this.username;
      copy.remoteIp = this.remoteIp;
      copy.clientType = this.clientType;
      copy.creationTime = this.creationTime;
      copy.timeout = this.timeout;
      copy.idle = this.idle;
      copy.userIdle = this.userIdle;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["sessionId"] = this.sessionId;
      json["username"] = this.username;
      json["remoteIp"] = this.remoteIp;
      json["clientType"] = this.clientType;
      json["creationTime"] = (this.creationTime.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
      json["timeout"] = this.timeout;
      json["idle"] = this.idle;
      json["userIdle"] = this.userIdle;
      return json;
    }

    public static Session_2_0_0 Decode(LightJson.JsonObject json, Agent agent) {
      Session_2_0_0 inst = new Session_2_0_0();
      inst.sessionId = (int)json["sessionId"];
      inst.username = (string)json["username"];
      inst.remoteIp = (string)json["remoteIp"];
      inst.clientType = (string)json["clientType"];
      inst.creationTime = new System.DateTime(json["creationTime"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      inst.timeout = (int)json["timeout"];
      inst.idle = (int)json["idle"];
      inst.userIdle = (int)json["userIdle"];
      return inst;
    }

    public int sessionId = 0;
    public string username = "";
    public string remoteIp = "";
    public string clientType = "";
    public System.DateTime creationTime = new System.DateTime(0);
    public int timeout = 0;
    public int idle = 0;
    public int userIdle = 0;
  }
}
