package Shipment::FedEx::WSDL::TrackTypes::TrackEvent;
$Shipment::FedEx::WSDL::TrackTypes::TrackEvent::VERSION = '3.10';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://fedex.com/ws/track/v9' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Timestamp_of :ATTR(:get<Timestamp>);
my %EventType_of :ATTR(:get<EventType>);
my %EventDescription_of :ATTR(:get<EventDescription>);
my %StatusExceptionCode_of :ATTR(:get<StatusExceptionCode>);
my %StatusExceptionDescription_of :ATTR(:get<StatusExceptionDescription>);
my %Address_of :ATTR(:get<Address>);
my %StationId_of :ATTR(:get<StationId>);
my %ArrivalLocation_of :ATTR(:get<ArrivalLocation>);

__PACKAGE__->_factory(
    [ qw(        Timestamp
        EventType
        EventDescription
        StatusExceptionCode
        StatusExceptionDescription
        Address
        StationId
        ArrivalLocation

    ) ],
    {
        'Timestamp' => \%Timestamp_of,
        'EventType' => \%EventType_of,
        'EventDescription' => \%EventDescription_of,
        'StatusExceptionCode' => \%StatusExceptionCode_of,
        'StatusExceptionDescription' => \%StatusExceptionDescription_of,
        'Address' => \%Address_of,
        'StationId' => \%StationId_of,
        'ArrivalLocation' => \%ArrivalLocation_of,
    },
    {
        'Timestamp' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
        'EventType' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'EventDescription' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'StatusExceptionCode' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'StatusExceptionDescription' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Address' => 'Shipment::FedEx::WSDL::TrackTypes::Address',
        'StationId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'ArrivalLocation' => 'Shipment::FedEx::WSDL::TrackTypes::ArrivalLocationType',
    },
    {

        'Timestamp' => 'Timestamp',
        'EventType' => 'EventType',
        'EventDescription' => 'EventDescription',
        'StatusExceptionCode' => 'StatusExceptionCode',
        'StatusExceptionDescription' => 'StatusExceptionDescription',
        'Address' => 'Address',
        'StationId' => 'StationId',
        'ArrivalLocation' => 'ArrivalLocation',
    }
);

} # end BLOCK







1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackEvent

=head1 VERSION

version 3.10

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
TrackEvent from the namespace http://fedex.com/ws/track/v9.

FedEx scanning information about a package.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Timestamp

=item * EventType

=item * EventDescription

=item * StatusExceptionCode

=item * StatusExceptionDescription

=item * Address

=item * StationId

=item * ArrivalLocation

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::TrackEvent

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::TrackEvent
   Timestamp =>  $some_value, # dateTime
   EventType =>  $some_value, # string
   EventDescription =>  $some_value, # string
   StatusExceptionCode =>  $some_value, # string
   StatusExceptionDescription =>  $some_value, # string
   Address =>  { # Shipment::FedEx::WSDL::TrackTypes::Address
     StreetLines =>  $some_value, # string
     City =>  $some_value, # string
     StateOrProvinceCode =>  $some_value, # string
     PostalCode =>  $some_value, # string
     UrbanizationCode =>  $some_value, # string
     CountryCode =>  $some_value, # string
     CountryName =>  $some_value, # string
     Residential =>  $some_value, # boolean
   },
   StationId =>  $some_value, # string
   ArrivalLocation => $some_value, # ArrivalLocationType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
