---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles,  
              formules mathématiques, signe moins, négatif, profondeur,
              alignement des caractères
---

# Pourquoi le signe moins "-" descend-il sous la ligne de base ?

Avez-vous remarqué que le signe moins ($-$) a une profondeur non nulle ? 
Plus concrètement, il descend sous la ligne de base. Cela se remarque 
quand on le met sous un signe de racine :

```
\documentclass[14pt]{extarticle} 
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
\begin{tikzpicture}
  \path (0,0) node[inner sep=0pt] (sqrt) {\Huge$\displaystyle\sqrt{1} 
    \quad \sqrt{-1}$} ;

  \draw[line width=.2pt,blue] (sqrt.base west) -- (sqrt.base east) ;
  \draw[line width=.2pt,green] ([yshift=.30ex]sqrt.south west) 
    -- ([yshift=.30ex]sqrt.south east) ;
  \draw[line width=.2pt,red] (sqrt.south west) -- (sqrt.south east) ;
\end{tikzpicture}
\end{document}
```

Vous pouvez voir que $\sqrt{1}$ descend moins bas que $\sqrt{-1}$.

Lorsqu'il a dessiné la police *[Computer Modern](wpfr:Computer_Modern)*, 
Donald Knuth a choisi de donner au signe moins ($-$) la même profondeur
qu'au signe plus ($+$), pour que l'alignement soit naturellement maintenu
entre les expressions négatives et positives :

```
\documentclass[14pt]{extarticle}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}

\begin{document}
\begin{tikzpicture}
  \path (0,0) node[inner sep=0pt] (sqrt) {\Huge$\displaystyle\sqrt{1} 
    \quad \sqrt{-1} \quad \sqrt{+1}$} ;

  \draw[line width=.2pt,blue] (sqrt.base west) -- (sqrt.base east) ;
  \draw[line width=.2pt,green] ([yshift=.30ex]sqrt.south west) 
    -- ([yshift=.30ex]sqrt.south east) ;
  \draw[line width=.2pt,red] (sqrt.south west) -- (sqrt.south east) ;
\end{tikzpicture}
\end{document}
```

C'est un choix du dessinateur de la police, pas une règle. 
Par exemple, dans la police *[STIX](ctanpkg:stix)*, le $-$ n'a pas
de profondeur tandis que le $+$ en a une :

```
\documentclass[14pt]{extarticle}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{stix}
  \usepackage{tikz}

\begin{document}
\begin{tikzpicture}
  \path (0,0) node[inner sep=0pt] (sqrt) {\Huge$\displaystyle\sqrt{1} 
    \quad \sqrt{-1} \quad \sqrt{+1}$} ;

  \draw[line width=.2pt,blue] (sqrt.base west) -- (sqrt.base east) ;
  \draw[line width=.2pt,green] ([yshift=.19ex]sqrt.south west) 
    -- ([yshift=.19ex]sqrt.south east) ;
  \draw[line width=.2pt,red] (sqrt.south west) -- (sqrt.south east) ;
\end{tikzpicture}
\end{document}
```


:::{sources}
- [Why do \sqrt{1} and \sqrt{-1} have different heights?](https://tex.stackexchange.com/q/340157), 
  sur [TeX Stack Exchange](https://tex.stackexchange.com/)
:::